DROP TABLE IF EXISTS `addons`;
CREATE TABLE `addons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `unique_identifier` varchar(255) NOT NULL,
  `version` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL,
  `about` longtext DEFAULT NULL,
  `purchase_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
INSERT INTO `addons` (`id`, `name`, `unique_identifier`, `version`, `status`, `created_at`, `updated_at`, `about`, `purchase_code`) VALUES ('1', 'Course Affiliate Addon', 'affiliate_course', '1.2', '1', '993351600', NULL, 'This affiliate addon helps to increase your course sales and engage more students', NULL), ('2', 'Certificate', 'certificate', '1.3', '1', '993351600', '993351600', 'This addon helps student to get certified. Academy provides a course completion certificate for each student after completing any course', NULL), ('3', 'Assignment', 'assignment', '1.2', '1', '993351600', NULL, 'You can create assignments for students enrolled in your course, and review the submitted assignment to know the course progress of your enrolled students using this add-on.', NULL), ('4', 'Course Bundle', 'course_bundle', '1.5', '1', '993351600', '993351600', 'Course Bundle allows you to sell multiple courses at once. You can sell the bundle on the subscription system.', NULL), ('5', 'Course Forum', 'forum', '1.3', '1', '993351600', NULL, 'It opportunity the user to any questions or answers about courses.', NULL), ('6', 'Ebook', 'ebook', '1.3', '1', '993351600', '993351600', 'An ebook (short for electronic book), also known as an e-book or eBook, is a book publication made available in digital form, consisting of text, images, or both, readable on the flat-panel display of computers or other electronic devices.[1] Although sometimes defined as an electronic version of a printed book,[2] some e-books exist without a printed equivalent. E-books can be read on dedicated e-reader devices, but also on any computer device that features a controllable viewing screen, including desktop computers, laptops, tablets, and smartphones.', NULL), ('7', 'Offline Payment Gateway', 'offline_payment', '1.4', '1', '993351600', NULL, 'Offline payment gateway allows you to take payment through various local payment gateways.', NULL), ('8', 'Tutor Booking', 'tutor_booking', '1.3', '1', '993351600', NULL, 'This tutor booking addon helps student to book a tuition form a instructor for a specific time', NULL), ('9', 'Live Class', 'live-class', '2.1', '1', '993351600', NULL, 'Live Class addon adds an essential feature to Academy. Nowadays Live class has become so popular that it becomes necessary. On that note we decided to add Zoom in our application.', NULL), ('10', 'Noticeboard', 'noticeboard', '1.0', '1', '993351600', NULL, 'You can display notifications for students enrolled in your course, and you can also send important notifications to their emails using this add-on.', NULL), ('11', 'Course Analytics', 'course_analytics', '1.0', '1', '993351600', NULL, 'You will be able to see the course progress for all enrolled students here. Which will help you understand the needs of your students. On the left side of the chart, you will see the range of the top number of students, and on the bottom of the chart, you will see the range of percentage. Also, you will able to see the table of the chart on the right side.', NULL), ('12', 'Jitsi live class', 'jitsi-live-class', '1.0', '0', '993351600', NULL, 'Jitsi is a set of open-source projects. Jitsi Video bridge passes everyone’s video and audio to all participants, rather than mixing them first.', NULL), ('13', 'Course content AI', 'course_ai', '1.0', '1', '1277334000', NULL, 'You can easily create your course content using this addon. It will offer you something creative, which will save you time.', NULL), ('14', 'Bootcamp', 'bootcamp', '1.0', '1', '1277334000', NULL, 'You can have a live video session, publish modules and classes and schedule with this addon.', NULL), ('15', 'Customer Support', 'customer_support', '1.0', '1', '1277334000', NULL, 'Customer Support allows you to help customer about their issues with your products.', NULL);
DROP TABLE IF EXISTS `affiliator_status`;
CREATE TABLE `affiliator_status` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `unique_identifier` varchar(255) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `address` longtext DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `message` longtext DEFAULT NULL,
  `document` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `applications`;
CREATE TABLE `applications` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `address` longtext DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `message` longtext DEFAULT NULL,
  `document` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `assignment`;
CREATE TABLE `assignment` (
  `assignment_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `course_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `questions` longtext DEFAULT NULL,
  `question_file` varchar(255) DEFAULT NULL,
  `total_marks` int(11) DEFAULT NULL,
  `deadline_date` varchar(255) DEFAULT NULL,
  `deadline_time` varchar(255) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  `updated_date` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`assignment_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `assignment_submission`;
CREATE TABLE `assignment_submission` (
  `submission_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `assignment_id` int(11) DEFAULT NULL,
  `answer` longtext DEFAULT NULL,
  `answer_file` varchar(255) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `review_status` varchar(255) DEFAULT NULL,
  `marks` int(11) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`submission_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `bbb_meetings`;
CREATE TABLE `bbb_meetings` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `meeting_id` varchar(255) DEFAULT NULL,
  `moderator_pw` varchar(255) DEFAULT NULL,
  `viewer_pw` varchar(255) DEFAULT NULL,
  `instructions` longtext DEFAULT NULL,
  `created_at` varchar(100) DEFAULT NULL,
  `updated_at` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `blog_category`;
CREATE TABLE `blog_category` (
  `blog_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `subtitle` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `added_date` varchar(100) NOT NULL,
  PRIMARY KEY (`blog_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `blog_comments`;
CREATE TABLE `blog_comments` (
  `blog_comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `blog_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `comment` longtext NOT NULL,
  `likes` longtext NOT NULL,
  `added_date` varchar(100) NOT NULL,
  `updated_date` varchar(100) NOT NULL,
  PRIMARY KEY (`blog_comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `blogs`;
CREATE TABLE `blogs` (
  `blog_id` int(11) NOT NULL AUTO_INCREMENT,
  `blog_category_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keywords` text NOT NULL,
  `description` longtext NOT NULL,
  `thumbnail` varchar(100) NOT NULL,
  `banner` varchar(100) NOT NULL,
  `is_popular` int(11) NOT NULL,
  `likes` longtext NOT NULL,
  `added_date` varchar(100) NOT NULL,
  `updated_date` varchar(100) NOT NULL,
  `status` varchar(50) NOT NULL,
  PRIMARY KEY (`blog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `bootcamp`;
CREATE TABLE `bootcamp` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` int(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `short_description` mediumtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `start_date` int(255) DEFAULT NULL,
  `faqs` longtext DEFAULT NULL,
  `faq_descriptions` longtext DEFAULT NULL,
  `requirements` longtext DEFAULT NULL,
  `outcomes` longtext DEFAULT NULL,
  `price` int(255) DEFAULT NULL,
  `bootcamp_thumbnail` varchar(255) DEFAULT NULL,
  `discount_flag` int(255) DEFAULT NULL,
  `discounted_price` double DEFAULT NULL,
  `expiry_period` varchar(255) DEFAULT NULL,
  `number_of_month` int(255) DEFAULT NULL,
  `meta_keywords` mediumtext DEFAULT NULL,
  `meta_description` longtext DEFAULT NULL,
  `is_free` int(255) DEFAULT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  `updated_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `bootcamp_category`;
CREATE TABLE `bootcamp_category` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `category_name` varchar(255) DEFAULT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  `updated_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
INSERT INTO `bootcamp_category` (`id`, `category_name`, `added_date`, `updated_date`) VALUES ('1', 'Marketing Digital', '1723557695', '1723557695'), ('2', ' Desenvolvimento Pessoal', '1723557860', '1723557860'), ('3', 'Jornada Profissional', '1723557869', '1723557869'), ('4', 'Vida Abundante', '1723557880', '1723557880'), ('5', 'Desenvolvimento Familiar', '1723557892', '1723557892'), ('6', 'Auto-cura', '1723557918', '1723557918'), ('7', 'Processos Terapêuticos', '1723557928', '1723557928'), ('8', 'IA - Inteligência Artificial', '1723557939', '1723557939'), ('9', NULL, '1723901303', '1723901303');
DROP TABLE IF EXISTS `bootcamp_live_class`;
CREATE TABLE `bootcamp_live_class` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `module_id` int(255) DEFAULT NULL,
  `bootcamp_id` int(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `class_schedule` int(255) DEFAULT NULL,
  `estimated_time` int(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `order_by` int(255) DEFAULT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  `updated_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
INSERT INTO `bootcamp_live_class` (`id`, `module_id`, `bootcamp_id`, `title`, `description`, `class_schedule`, `estimated_time`, `status`, `order_by`, `added_date`, `updated_date`) VALUES ('1', '3', '1', 'BRANDING DA MARCA', '<p>Neste dia, trabalharemos na detinição do propósito e</p><p>valores da marca, criaremos o documento mestre e</p><p>alinharemos a identidade visual e a linguagem da marca</p><p>para garantir uma comunicação consistente e eficaz.</p>', '1724094000', '1724101200', 'completed', '1', '1723905106', '1724104071'), ('2', '4', '1', 'CRIAR CONTEÚDO EM CANVA COM I.A', '<p>Exploraremos o Canva, aprenderemos a criar designs</p><p>atrativos para posts e stories, desenvolveremos</p><p>modelos para diversos tipos de conteúdo, e</p><p>praticaremos a criação de posts especíticos para</p><p>Instagram e Facebook.</p>', '1724180400', '1724187600', 'upcoming', NULL, '1723905184', '1723905463'), ('3', '5', '1', 'ESTRATÉGIAS DE VENDAS PARA INSTAGRAM/FACEBOOK', '<p>O foco será otimizar as biografias e perfis,</p><p>implementar estratégias de engajamento, planejar e</p><p>organizar o feed, além de utilizar Stories e Reels para</p><p>aumentar a audiência e interação com o público.</p>', '1724266800', '1724274000', 'upcoming', NULL, '1723905320', '1723905320'), ('4', '6', '1', 'WhatsApp Business e LinkedIn', '<p>Abordaremos a configuração e uso eficaz do</p><p>WhatsApp Business, criaremos catálogos de</p><p>produtos/ serviços, otimizaremos o perfil no Linkedin e</p><p>desenvolveremos estratégias de networking e</p><p>prospecção de clientes.</p>', '1724353200', '1724360400', 'upcoming', NULL, '1723905406', '1723905406'), ('5', '7', '1', 'TIKTOK', '<p>Aprenderemos sobre o uso do TikTok para negócios,</p><p>desenvolveremos estratégias para criar conteúdo</p><p>curto e viral, utilizaremos tendências e hashtags, e</p><p>analisaremos o desempenho dos vídeos para realizar</p><p>ajustes estratégicos.</p>', '1724439600', '1724446800', 'upcoming', NULL, '1723905534', '1723905534');
DROP TABLE IF EXISTS `bootcamp_modules`;
CREATE TABLE `bootcamp_modules` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `bootcamp_id` int(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `order_by` int(255) DEFAULT NULL,
  `restricted_by` varchar(255) DEFAULT NULL,
  `class_start` int(255) DEFAULT NULL,
  `class_end` int(255) DEFAULT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  `updated_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
INSERT INTO `bootcamp_modules` (`id`, `bootcamp_id`, `title`, `order_by`, `restricted_by`, `class_start`, `class_end`, `added_date`, `updated_date`) VALUES ('8', '1', 'BOAS-VINDAS PROFISSIONAIS DO BEM-ESTAR', NULL, 'free', '1723849200', '1723849200', '1723905569', '1723905569'), ('3', '1', 'DIA 1: BRANDING DA MARCA', NULL, 'free', '1723849200', '1723849200', '1723904463', '1724104175'), ('4', '1', 'DIA 2: CRIAR CONTEÚDO COM CANVA E CHATGPT', NULL, 'free', '1723849200', '1723849200', '1723904560', '1723904560'), ('5', '1', 'DIA 3: ESTRATÉGIAS DE VENDAS PARA INSTAGRAM/FACEBOOK', NULL, 'free', '1723849200', '1723849200', '1723904637', '1723904637'), ('6', '1', 'DIA 4: WHATSAPP BUSINESS E LINKEDIN ', NULL, 'free', '1723849200', '1723849200', '1723904749', '1723904749'), ('7', '1', 'DIA 5: TIKTOK', NULL, 'free', '1723849200', '1723849200', '1723904796', '1723904796');
DROP TABLE IF EXISTS `bootcamp_online_class`;
CREATE TABLE `bootcamp_online_class` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` int(255) DEFAULT NULL,
  `bootcamp_id` int(255) DEFAULT NULL,
  `live_class_id` int(255) DEFAULT NULL,
  `room_name` varchar(255) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `pass` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `schedule` int(255) DEFAULT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  `updated_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `bootcamp_purchase`;
CREATE TABLE `bootcamp_purchase` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(255) DEFAULT NULL,
  `bootcamp_id` int(255) DEFAULT NULL,
  `price` int(255) DEFAULT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `request_date` varchar(255) DEFAULT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  `updated_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
INSERT INTO `bootcamp_purchase` (`id`, `user_id`, `bootcamp_id`, `price`, `payment_method`, `request_date`, `added_date`, `updated_date`) VALUES ('1', '13', '1', '0', 'free', '1724001445', '1724001445', '1724001445'), ('2', '1', '1', '0', 'free', '1724072455', '1724072455', '1724072455'), ('3', NULL, '1', '0', 'free', '1724074470', '1724074470', '1724074470'), ('4', '7', '1', '0', 'free', '1724081133', '1724081133', '1724081133'), ('5', '16', '1', '0', 'free', '1724089375', '1724089375', '1724089375'), ('6', '17', '1', '0', 'free', '1724089608', '1724089608', '1724089608');
DROP TABLE IF EXISTS `bootcamp_resources`;
CREATE TABLE `bootcamp_resources` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  `updated_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `bundle_payment`;
CREATE TABLE `bundle_payment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `bundle_creator_id` int(11) DEFAULT NULL,
  `bundle_id` int(11) DEFAULT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `amount` int(11) DEFAULT 0,
  `date_added` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `bundle_rating`;
CREATE TABLE `bundle_rating` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `bundle_id` int(11) DEFAULT NULL,
  `comment` longtext DEFAULT NULL,
  `rating` varchar(15) DEFAULT NULL,
  `date_added` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `category`;
CREATE TABLE `category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `parent` int(11) DEFAULT 0,
  `slug` varchar(255) DEFAULT NULL,
  `date_added` int(11) DEFAULT NULL,
  `last_modified` int(11) DEFAULT NULL,
  `font_awesome_class` varchar(255) DEFAULT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `sub_category_thumbnail` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `category` (`id`, `code`, `name`, `parent`, `slug`, `date_added`, `last_modified`, `font_awesome_class`, `thumbnail`, `sub_category_thumbnail`) VALUES ('1', '663db94ec9', 'Desenvolvimento', '0', 'desenvolvimento', '1717455600', '1717455600', 'fas fa-users', 'category-thumbnail.png', NULL), ('2', '098ddb881b', 'Profissional', '0', 'profissional', '1717455600', '1717455600', 'fas fa-briefcase', 'category-thumbnail.png', NULL), ('3', 'e9cdc0d9b3', 'Abundância', '0', 'abundância', '1717455600', '1717455600', 'far fa-money-bill-alt', 'category-thumbnail.png', NULL), ('4', '56d0c3a748', 'Família', '0', 'família', '1717455600', NULL, 'fas fa-child', 'category-thumbnail.png', NULL), ('5', '58a297dd1c', 'Curas', '0', 'curas', '1717455600', '1717455600', 'fab fa-medrt', 'category-thumbnail.png', NULL), ('6', '6a52dc2a98', 'Terapêuticos', '0', 'terapêuticos', '1717455600', '1717455600', 'fas fa-user-md', 'category-thumbnail.png', NULL), ('7', 'e71761235e', 'IA - Inteligência Artificial', '0', 'ia-inteligência-artificial', '1717455600', '1717455600', 'far fa-lightbulb', 'category-thumbnail.png', NULL), ('8', 'db3c120073', 'Marketing Digital', '0', 'marketing-digital', '1717455600', NULL, 'fas fa-chart-line', 'category-thumbnail.png', NULL), ('9', '5d0063c1f4', 'Desenvolvimento Pessoal', '1', 'desenvolvimento-pessoal', '1717455600', NULL, 'fas fa-chess', NULL, NULL), ('11', '6df4656f6f', 'Jornada Profissional', '2', 'jornada-profissional', '1717455600', NULL, 'fas fa-chess', NULL, NULL), ('12', '6486bfc206', 'Vida Abundante', '3', 'vida-abundante', '1717455600', NULL, 'fas fa-chess', NULL, NULL), ('13', 'bf5b46a350', 'Desenvolvimento Familiar', '4', 'desenvolvimento-familiar', '1717455600', NULL, 'fas fa-chess', NULL, NULL), ('14', '7bbfe57c7f', 'Auto-cura', '5', 'auto-cura', '1717455600', NULL, 'fas fa-chess', NULL, NULL), ('15', '31b01cdb7e', 'Processos Terapêuticos', '6', 'processos-terapêuticos', '1717455600', NULL, 'fas fa-chess', NULL, NULL);
DROP TABLE IF EXISTS `certificates`;
CREATE TABLE `certificates` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `shareable_url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
INSERT INTO `certificates` (`id`, `student_id`, `course_id`, `shareable_url`) VALUES ('1', '7', '6', '26a3443d6f');
DROP TABLE IF EXISTS `ci_sessions`;
CREATE TABLE `ci_sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('911ed4dab55ca64c5c6bd3315315821643ff2420', '2.82.60.53', '1729877019', '__ci_last_regenerate|i:1729023088;cart_items|a:0:{}language|s:10:\"portuguese\";custom_session_limit|i:1729887095;user_id|s:2:\"12\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:11:\"Edite Pinto\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";'), ('ccca47bbad519aa9f43b6ac3c7e79809b133ebb5', '85.208.96.195', '1729544858', '__ci_last_regenerate|i:1729544858;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('04de71b95f10a2b16f0e09c892475f270469c8cd', '185.191.171.12', '1729544858', '__ci_last_regenerate|i:1729544858;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6abb63e9763680384c71dd0ffb8df49ee8ff0703', '85.208.96.203', '1729544979', '__ci_last_regenerate|i:1729544979;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e298b2e77979cc86ed522faa81e11999faeb200c', '185.191.171.6', '1729546691', '__ci_last_regenerate|i:1729546691;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('65da6251318c3c0cc9a42a789e942ca7f1a3c659', '85.208.96.206', '1729549438', '__ci_last_regenerate|i:1729549438;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('185a3fb26b02082657ad58d95aa242622c68f3bc', '85.208.96.209', '1729549439', '__ci_last_regenerate|i:1729549439;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9a93b54edc3f4f2f60a1bcfee79bde3d7a1a048b', '66.249.72.33', '1729549746', '__ci_last_regenerate|i:1729549746;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('636f0391bba9058902681b4675199ac7b1f60ce1', '66.249.72.34', '1729549746', '__ci_last_regenerate|i:1729549746;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('176fd3f4d9b519197ff8329d0537e2f682e10a88', '66.249.72.32', '1729549747', '__ci_last_regenerate|i:1729549747;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('ddd5b0105d5372ad3d20d998d951570ccec96724', '85.208.96.196', '1729551952', '__ci_last_regenerate|i:1729551952;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2a158cbfac7bdecd5b5de3fda04bda6827ca7ab2', '185.191.171.3', '1729554073', '__ci_last_regenerate|i:1729554073;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dbff18634069f283c368bf5db91eb005322bafa4', '185.191.171.5', '1729554074', '__ci_last_regenerate|i:1729554074;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c4a046d7c4ec9425c98ea99471aa9f46a36a4c14', '149.202.65.183', '1729556636', '__ci_last_regenerate|i:1729556636;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('11ab486a9235bffea2a03cee60c671efc7b09662', '149.202.65.183', '1729556638', '__ci_last_regenerate|i:1729556638;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('9f276a7e17ce4e5478be4227b450552e515cdd7e', '149.202.65.183', '1729556641', '__ci_last_regenerate|i:1729556641;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('4d1cd43804bf0081b3b9f1712b5babd91d1ef9d7', '149.202.65.183', '1729556643', '__ci_last_regenerate|i:1729556643;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('85913ad4664db77c2eac3a8cc4940dd70edf751b', '149.202.65.183', '1729556645', '__ci_last_regenerate|i:1729556645;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('7f2409ec90162dc31ea6ede795c30a59109ceff8', '149.202.65.183', '1729556647', '__ci_last_regenerate|i:1729556647;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('fafa4fcfdb90327a1e081011518341eade26ee19', '185.191.171.14', '1729557799', '__ci_last_regenerate|i:1729557799;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('83c4e1f745c66fa3981f6f275ce9ca9fbb616304', '185.191.171.14', '1729557800', '__ci_last_regenerate|i:1729557800;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8ff7637bbb4f442135e9c63d97a040fc6d911dc6', '66.249.72.33', '1729559708', '__ci_last_regenerate|i:1729559707;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0315aa601f9e48e17eec48e485ac69e0362d7f13', '66.249.72.33', '1729559708', '__ci_last_regenerate|i:1729559708;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b0bcdae763572b41a3546f766ff8694c845becd0', '66.249.72.34', '1729559708', '__ci_last_regenerate|i:1729559708;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e46d73b40124adb1584e1a46a353b24ed7e24911', '66.249.72.32', '1729559768', '__ci_last_regenerate|i:1729559768;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d05895d56fb9b5a9756afc8646337795c539b2bf', '66.249.72.34', '1729559828', '__ci_last_regenerate|i:1729559828;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d12a3070f1d812f4593c3fd0603195b2ccdf109c', '66.249.72.34', '1729559889', '__ci_last_regenerate|i:1729559889;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bd739434d8ca1d0000b80a24e0b2f6d1007267c4', '66.249.72.33', '1729560129', '__ci_last_regenerate|i:1729560129;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('275d26a481f13986f6a900d18aa3e6c2140885b0', '66.249.72.32', '1729560189', '__ci_last_regenerate|i:1729560189;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('026c8299ae688284b8e527f83ef54d74cdc68830', '66.249.72.32', '1729560309', '__ci_last_regenerate|i:1729560309;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7e73924b926facda4fe3ce0d6f495a93fe05e1de', '66.249.72.34', '1729560489', '__ci_last_regenerate|i:1729560489;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bcbf25d35acb184d42f832e4da16c7f270d560a9', '85.208.96.196', '1729560541', '__ci_last_regenerate|i:1729560541;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7b841d3977b8f4a3a31532741d936bd80a3bd092', '66.249.72.34', '1729560549', '__ci_last_regenerate|i:1729560549;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0a64b5c5431e8c42b740d1e0cc1825d03a8badc3', '66.249.72.34', '1729560611', '__ci_last_regenerate|i:1729560611;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e962d7c267314d47e961c891135679cbc79a5565', '66.249.72.34', '1729560672', '__ci_last_regenerate|i:1729560672;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('26a88860b07187fe7da309674e4a012c542e7a9b', '66.249.72.34', '1729560736', '__ci_last_regenerate|i:1729560736;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e386e58fad7c17685fef602b9ff6b068b488d992', '185.191.171.7', '1729560890', '__ci_last_regenerate|i:1729560890;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b472a2944468a1b0b4f6741123eac67fd3aa52ed', '66.249.72.34', '1729563428', '__ci_last_regenerate|i:1729563427;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('36140bd95f76fe3cf1a96bb0a23427ebd4cb7835', '66.249.72.33', '1729563428', '__ci_last_regenerate|i:1729563427;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('281d69f4eb93eca9d80f00f7cdf9a842576cc8a4', '66.249.72.34', '1729563728', '__ci_last_regenerate|i:1729563728;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8d134f14506a847802c5ecd8196db255f6806e36', '66.249.72.32', '1729563728', '__ci_last_regenerate|i:1729563728;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('85171dfcbcb8d5784d5310a7a5e75328050a36e9', '66.249.72.34', '1729563788', '__ci_last_regenerate|i:1729563788;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('23130ddb9dcd1ab0877f4c55ed1a76dbd68bb258', '66.249.72.32', '1729563788', '__ci_last_regenerate|i:1729563788;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('70c10839ef5b57992402595d69cb838dc5866521', '66.249.72.33', '1729563908', '__ci_last_regenerate|i:1729563908;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d06e8cb99875f52064b55ed72cc98aa48cafdd25', '66.249.72.33', '1729563908', '__ci_last_regenerate|i:1729563908;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4a295ab783e855decb0f704fae09195ae0b29093', '66.249.72.34', '1729563968', '__ci_last_regenerate|i:1729563968;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('25d16aa37c23490f97962c0c9a4987a02ecb9330', '66.249.72.33', '1729564148', '__ci_last_regenerate|i:1729564148;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('49895c1440d846d46b3d456803aee08857d561f6', '66.249.72.34', '1729564209', '__ci_last_regenerate|i:1729564209;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('683df5c95211cad3ffb9b22fb2ad14ce6b7f18d0', '66.249.72.33', '1729564269', '__ci_last_regenerate|i:1729564269;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2ff4f1d3d67e9ced1fe0e3ea644ca3646ed12956', '66.249.72.33', '1729564330', '__ci_last_regenerate|i:1729564330;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('50c2d56bd9e571d08d891a27b81921367c4596c0', '66.249.72.33', '1729564511', '__ci_last_regenerate|i:1729564511;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0d0481e89e73451904693947e3e6c24e5f9588e9', '66.249.72.33', '1729564692', '__ci_last_regenerate|i:1729564692;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0a3de4e744e4dee722ad1ac9c3b8d7701a33ae2f', '66.249.72.34', '1729564812', '__ci_last_regenerate|i:1729564812;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a1ad93b9b135758c2bc57267c7797b7a5c2166ce', '66.249.72.33', '1729565113', '__ci_last_regenerate|i:1729565113;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ad21c58262d16f166350014c7a9cf40dfc141224', '66.249.72.34', '1729565234', '__ci_last_regenerate|i:1729565233;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('57273f93596a306df93f3a9bcb31e18b8f87f8d4', '66.249.72.33', '1729565294', '__ci_last_regenerate|i:1729565294;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('74cf9fc7ef221ca41ab3e223d2769bd2772f6bc2', '66.249.72.33', '1729565354', '__ci_last_regenerate|i:1729565354;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fe316662fcc952c90b7d57fcb722980a4b54ea39', '66.249.72.32', '1729565355', '__ci_last_regenerate|i:1729565355;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:215;'), ('c4a673db1ef8f5f7d1ca253565b0d3558e5b8767', '66.249.72.34', '1729565355', '__ci_last_regenerate|i:1729565355;cart_items|a:1:{i:0;s:1:\"5\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:799;'), ('1747931fa19a881034d948b1fde0e1392df31b4b', '66.249.72.32', '1729565356', '__ci_last_regenerate|i:1729565356;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('fc39ed4965c0328053f16cd118472fa986c4f974', '66.249.72.34', '1729565356', '__ci_last_regenerate|i:1729565356;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2330ba920400050e37bc767bd892cc2e376d7b30', '66.249.72.34', '1729565356', '__ci_last_regenerate|i:1729565356;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6a6f8465991e3af9fba4b64df4e1a7c52adbd9a2', '66.249.72.34', '1729565357', '__ci_last_regenerate|i:1729565357;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0e510872c4b9b3d140ce333e98416591226d7ade', '66.249.72.34', '1729565478', '__ci_last_regenerate|i:1729565478;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('743ee3175f150a49b8c96b82b3f97863e4713b3f', '66.249.72.33', '1729565479', '__ci_last_regenerate|i:1729565479;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b31bc80cea5395ea7e92bfaee35165f1bbc5eea7', '66.249.72.33', '1729565661', '__ci_last_regenerate|i:1729565661;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2cc8340b28186404fe5adec28e9deedc1fd311ae', '66.249.72.33', '1729565722', '__ci_last_regenerate|i:1729565722;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('97764ce8219ba81ea1a18a7fd470f5bc99751d96', '66.249.72.33', '1729565782', '__ci_last_regenerate|i:1729565782;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cea079d0fdad89386d665744954b6ee403806c13', '66.249.72.33', '1729565843', '__ci_last_regenerate|i:1729565843;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6b2cf90c2f07ca29a1bb867b2826248b9fcccb45', '66.249.72.32', '1729565843', '__ci_last_regenerate|i:1729565843;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('64eab787c33dbe611a30a19a774942343c2a851b', '66.249.72.34', '1729565843', '__ci_last_regenerate|i:1729565843;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5a1083a28b2be59063b5267ee11085322ecd2a87', '66.249.72.33', '1729566245', '__ci_last_regenerate|i:1729566245;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('34e50337c5c9edbc326f2d99f7af46368adefd24', '66.249.72.32', '1729566554', '__ci_last_regenerate|i:1729566554;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3ecdb884b7c5be053baa0d58d833fd4f447414c4', '66.249.72.32', '1729566555', '__ci_last_regenerate|i:1729566554;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b1b932cdeb5234facfade36b9cbc89c7b089c858', '66.249.72.32', '1729566555', '__ci_last_regenerate|i:1729566555;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('010d9f9339be6393013250eb2443d9108330f396', '66.249.72.34', '1729566556', '__ci_last_regenerate|i:1729566556;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ac1162b8b89b74d68d301a16583065ca320b4bdc', '66.249.72.33', '1729566556', '__ci_last_regenerate|i:1729566556;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f7b8385482111102261a9d8c73028e9ed0aa8861', '66.249.72.33', '1729566677', '__ci_last_regenerate|i:1729566677;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('65248a74c04b24d59a39404c811617ae03bc9cce', '66.249.72.32', '1729566678', '__ci_last_regenerate|i:1729566678;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('13fba8bf5d59942da6b8e6da220f8cb54e998645', '66.249.72.33', '1729566934', '__ci_last_regenerate|i:1729566934;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b883f60075a631ae15b05976507ec7d2b028a1da', '66.249.72.32', '1729569173', '__ci_last_regenerate|i:1729569173;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c788fa479f4582cd074e5ebf029c3f988a0d56cd', '66.249.72.32', '1729569173', '__ci_last_regenerate|i:1729569173;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c04a6ef74ae8f7c6c448bcfa107aa40453f57eaf', '66.249.72.33', '1729569293', '__ci_last_regenerate|i:1729569293;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('603ae0711810e4071a64defbe872f1c596fd57c7', '66.249.72.33', '1729570207', '__ci_last_regenerate|i:1729570207;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4686ddc4da47fdc9930b7c9632c5465ce170e730', '66.249.72.33', '1729570267', '__ci_last_regenerate|i:1729570267;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('167e05f90a122d32994efb69ee4734077b8dbde2', '66.249.72.34', '1729570509', '__ci_last_regenerate|i:1729570508;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('29074c31f7ed3ade3bc783a312c3bee7aa9a0093', '66.249.72.33', '1729570632', '__ci_last_regenerate|i:1729570632;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0b6e80028c3b3617a562bf06af13cf98f5006579', '66.249.72.33', '1729570876', '__ci_last_regenerate|i:1729570876;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('80076c58045c6d1df23455c71dbe8a1960340c2a', '66.249.72.32', '1729570879', '__ci_last_regenerate|i:1729570879;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:215;'), ('87efa019ff13d181bcb4c41af50e1e7cdceccb39', '66.249.72.32', '1729570882', '__ci_last_regenerate|i:1729570882;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('04bcd4216674aa5faf40365c0f958287150c1dc5', '66.249.72.32', '1729570887', '__ci_last_regenerate|i:1729570887;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b1c7c2e06d7ec678be945776adad7b5e5ed7baf1', '66.249.72.33', '1729570949', '__ci_last_regenerate|i:1729570949;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dc14911f73496b7488880ea3e8683af4c9368174', '66.249.72.33', '1729571900', '__ci_last_regenerate|i:1729571900;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ffaf3fbe85457879b76e0607981ffed294027469', '66.249.72.34', '1729571942', '__ci_last_regenerate|i:1729571942;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ee008554add56cb7b1aab651e4fda3f15d208cdd', '66.249.72.34', '1729572002', '__ci_last_regenerate|i:1729572002;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fe5ec89709ce0f79678a4615433c1ef13f3b8395', '66.249.72.33', '1729572062', '__ci_last_regenerate|i:1729572062;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('70929c1145f36d5492045ae79bf62a4224897c10', '66.249.72.32', '1729572122', '__ci_last_regenerate|i:1729572122;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('14a0b92006284c7062ded91693ecc388cf5b3285', '66.249.72.34', '1729572364', '__ci_last_regenerate|i:1729572364;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dd2283c191a514552319ed6430b5cc1a5be68c31', '66.249.72.32', '1729572365', '__ci_last_regenerate|i:1729572365;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b7e65791b732b4c789f57dab169be11e5a4f3398', '66.249.72.34', '1729572365', '__ci_last_regenerate|i:1729572365;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('49737833fad42cc299fda9032f7d8369fa1c98db', '66.249.72.34', '1729572546', '__ci_last_regenerate|i:1729572546;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2cc9b7294ff98d2294049197f185e8caf3c80fde', '66.249.72.34', '1729572666', '__ci_last_regenerate|i:1729572666;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('156781a40b6ae7061649e46de4293d2648fd280a', '66.249.72.34', '1729572846', '__ci_last_regenerate|i:1729572846;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('60778a78ddc1dc98a0dc711c05abaf79a565710c', '66.249.72.32', '1729572847', '__ci_last_regenerate|i:1729572846;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0896d2c428489a6ce6f2528bd6ef452dfa56a177', '66.249.72.32', '1729572847', '__ci_last_regenerate|i:1729572847;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c0b3cb8966ec8a53f9beb84218d77ac75bd899f3', '66.249.72.32', '1729572908', '__ci_last_regenerate|i:1729572908;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9cc92abe2f0f7551c1c655b6c7036d02725dcd00', '66.249.72.33', '1729572908', '__ci_last_regenerate|i:1729572908;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e24e5c48784581b76399e93c5b8c096b4b18a7f8', '66.249.72.33', '1729572908', '__ci_last_regenerate|i:1729572908;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c9173b311042146eac0dfa0b926ea7f3f2011a80', '66.249.72.33', '1729572909', '__ci_last_regenerate|i:1729572908;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('981af4d1b170e707120148c353e70b809da9763f', '66.249.72.33', '1729572969', '__ci_last_regenerate|i:1729572969;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('52c6203e0e5109b51a0fa730bb652205356b0f99', '66.249.72.33', '1729572969', '__ci_last_regenerate|i:1729572969;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('470b52744211b34eb2e35434715b862ba3c52e5f', '66.249.72.33', '1729573151', '__ci_last_regenerate|i:1729573151;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f3d7e8c6a03f0501ba8c062dc07bb5136e16d897', '66.249.72.34', '1729573151', '__ci_last_regenerate|i:1729573151;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d554081ac4571e919d697d45bd4ff9a34ef25af7', '66.249.72.33', '1729573211', '__ci_last_regenerate|i:1729573211;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0c3b008442712ab88b8bd41d1dd31391a96c21e9', '66.249.72.33', '1729573211', '__ci_last_regenerate|i:1729573211;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('aba22d30e0bb5cabe1f5e8edea38f45cbe57944c', '66.249.72.34', '1729573271', '__ci_last_regenerate|i:1729573271;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4e80e333095e71d24049e3bad0640480effc89b5', '66.249.72.32', '1729573331', '__ci_last_regenerate|i:1729573331;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b68a30604057e4f023b76e8e92c8c43890f5f0fa', '66.249.72.32', '1729573331', '__ci_last_regenerate|i:1729573331;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5cea2e86be0b1c2a6ece9ef90b2f9c74893e0cc5', '66.249.72.33', '1729573511', '__ci_last_regenerate|i:1729573511;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8ce5ee17ab62b07c271dc91641084c770578f89e', '66.249.72.32', '1729573512', '__ci_last_regenerate|i:1729573512;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('82ea246097de1163dbd9ca9e580a83a5ac54ebd0', '66.249.72.32', '1729573573', '__ci_last_regenerate|i:1729573573;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:40;'), ('5b9d0759398c6e665fb5bacb5c7fd918b6308bf7', '66.249.72.32', '1729573633', '__ci_last_regenerate|i:1729573633;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e588288394f18f794ad7bcb3e925e7fa58384eb4', '66.249.72.34', '1729573745', '__ci_last_regenerate|i:1729573745;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('86caaa05a683121190bb3cfed6136bd2ce3b9528', '66.249.72.32', '1729573866', '__ci_last_regenerate|i:1729573866;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('69b193de8a8722d4975302a1e168db3177706df6', '66.249.72.32', '1729573867', '__ci_last_regenerate|i:1729573867;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('662a9f45c8f41b89081a11fd4a11a2e43523bf6b', '66.249.72.33', '1729573987', '__ci_last_regenerate|i:1729573987;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('239331b476c53d8db27ed3f0661f06f44bc8beef', '66.249.72.32', '1729574348', '__ci_last_regenerate|i:1729574348;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('483719c9a9742b65edcff6c5c58e5b95eab9872a', '66.249.72.33', '1729574408', '__ci_last_regenerate|i:1729574408;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('38e0d33237cc865316b5fd2b4b187ffb204e75a3', '66.249.72.32', '1729574468', '__ci_last_regenerate|i:1729574468;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5526a03b05299806580897ac1858935f9052a74e', '66.249.72.32', '1729574589', '__ci_last_regenerate|i:1729574589;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a65693a3337f0a7b9c4ec51418efa83463b72aaa', '66.249.72.33', '1729574590', '__ci_last_regenerate|i:1729574590;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a2299ea094a8c97887a6446a034426c066d6b27d', '66.249.72.32', '1729574651', '__ci_last_regenerate|i:1729574651;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7cb6418c40cc4dd0f141e6e8d1f1c29592f0020f', '66.249.72.32', '1729574651', '__ci_last_regenerate|i:1729574651;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fcd1af7decb41cdcd2644d869820b98c6e0167c7', '66.249.72.32', '1729575191', '__ci_last_regenerate|i:1729575191;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('790e55fb6e6e1958f36401db28ec8f1e6ae11ea2', '66.249.72.33', '1729575252', '__ci_last_regenerate|i:1729575252;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4a6f086af9d4bbadba15f4fbe1900b97f4b12e25', '66.249.72.34', '1729575252', '__ci_last_regenerate|i:1729575252;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('7a1eac2cf489030ec7174df4c87310b5071d48c0', '66.249.72.32', '1729575313', '__ci_last_regenerate|i:1729575313;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('191a760053de7ba4fc52e1ce87d0788708712c01', '66.249.72.33', '1729575373', '__ci_last_regenerate|i:1729575373;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1a2f6efcdb8abb5c116d0320f27a653a9d593631', '66.249.72.32', '1729575434', '__ci_last_regenerate|i:1729575434;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3f64abc09971416fed0e60ff7fbdfc8fd3a00a50', '66.249.72.34', '1729576036', '__ci_last_regenerate|i:1729576036;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9afd3a75edfcc35c5d09e1c190a8d9385d92e462', '66.249.72.32', '1729576037', '__ci_last_regenerate|i:1729576037;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fafcec1a4f7f401440670a4b2ef8baae2a74bdcf', '66.249.72.33', '1729576037', '__ci_last_regenerate|i:1729576037;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f372de15b2fa0bd474c34c8f38ca3ab32bbe6b35', '198.235.24.168', '1729577490', '__ci_last_regenerate|i:1729577490;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a279e418ff95852fd4874ccf93ab91abb2d60dce', '96.126.110.181', '1729581938', '__ci_last_regenerate|i:1729581938;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9751d5dc0a3f44dd1cc2db840ad013b0bfc35edb', '96.126.110.181', '1729581940', '__ci_last_regenerate|i:1729581940;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c5919a4bf1dbc9b5b1f9cfb57f647c6a2f2af073', '96.126.110.181', '1729581940', '__ci_last_regenerate|i:1729581940;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('66631614d668636d33c2c9766d91efed4d1a92fc', '96.126.110.181', '1729581940', '__ci_last_regenerate|i:1729581940;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d6464d53763c604f31da0a3989abd7ea263b5fcd', '96.126.110.181', '1729581941', '__ci_last_regenerate|i:1729581941;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('92390848229df044b74f07c7aebd9aef635aa964', '96.126.110.181', '1729581941', '__ci_last_regenerate|i:1729581941;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('06041ca50b21b2e9abeee5fc8197295c07c7b658', '96.126.110.181', '1729581941', '__ci_last_regenerate|i:1729581941;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('981d29cea8ad466d06453a3276af96f87081c18b', '96.126.110.181', '1729581941', '__ci_last_regenerate|i:1729581941;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0fed2bb916604e8c9cb4bf04c3427165bbec8ce0', '96.126.110.181', '1729581942', '__ci_last_regenerate|i:1729581942;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('648be391cf04002750f6160b84c2f9ca9719b2da', '96.126.110.181', '1729581942', '__ci_last_regenerate|i:1729581942;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3ca9dfa20c4630fba68c212ce3536512a47d5e9f', '96.126.110.181', '1729581942', '__ci_last_regenerate|i:1729581942;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5dd37e69c33e8bf0985fa80ee1367d09624a8a72', '96.126.110.181', '1729581943', '__ci_last_regenerate|i:1729581943;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7ebf5e1eb71081c8b1d4e49adb2363c11e491db9', '96.126.110.181', '1729581943', '__ci_last_regenerate|i:1729581943;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('273072e7c7cdfdf58aaf8082383b5ea8496d3e75', '96.126.110.181', '1729581944', '__ci_last_regenerate|i:1729581944;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('67d2e8f976a3e846b2a823b61c811f850293a6da', '96.126.110.181', '1729581944', '__ci_last_regenerate|i:1729581944;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('10dae52ee1f77a61b1f9e917db393f370dfe4c4f', '96.126.110.181', '1729581944', '__ci_last_regenerate|i:1729581944;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('88888d6c570071650233a0be960900b81e8ff708', '96.126.110.181', '1729581944', '__ci_last_regenerate|i:1729581944;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3b20c289d6d0b3704d17c92777d7fb8fe9242204', '96.126.110.181', '1729581945', '__ci_last_regenerate|i:1729581945;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('031666960ca999c60b8b4604b8f7af4161e71f4f', '96.126.110.181', '1729581945', '__ci_last_regenerate|i:1729581945;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('637a467d40ce0e23e0f3ac4dd7b23eba57ffa0cd', '96.126.110.181', '1729581945', '__ci_last_regenerate|i:1729581945;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9124dedff44d1f93665e0bc3b8c0ccc5ce3b4d23', '96.126.110.181', '1729581946', '__ci_last_regenerate|i:1729581946;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b6c5256fc83cf9824fd9c6217cf4ee9016704d8b', '96.126.110.181', '1729581946', '__ci_last_regenerate|i:1729581946;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bda24f47161627935e33c51226776b196291064a', '96.126.110.181', '1729581946', '__ci_last_regenerate|i:1729581946;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2c9ad14a0f5dccfdfbb1807219f7076ba73a6816', '96.126.110.181', '1729581946', '__ci_last_regenerate|i:1729581946;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2ef658b5d149ffa279f3de1c0ef1345960f78db2', '96.126.110.181', '1729581947', '__ci_last_regenerate|i:1729581947;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6fb6ef3d042b6bb3a8bbf795261abf39ee808c80', '96.126.110.181', '1729581947', '__ci_last_regenerate|i:1729581947;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('45c328b7feb2e5198ccf37d4b233db3d37d24b71', '96.126.110.181', '1729581948', '__ci_last_regenerate|i:1729581948;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3e22d4a01f6bfc6881a7b7761157b04dc1a0f7d8', '96.126.110.181', '1729581948', '__ci_last_regenerate|i:1729581948;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('108e4c8ae90ddaedf4cd38bb6812de4053602640', '96.126.110.181', '1729581949', '__ci_last_regenerate|i:1729581949;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('02187e14a7689623a4d64e2cfd908f665d532888', '96.126.110.181', '1729581949', '__ci_last_regenerate|i:1729581949;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5892ae301b00f68477b6371784a79d2f3e3de953', '96.126.110.181', '1729581949', '__ci_last_regenerate|i:1729581949;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c5d17aa7610e400798cf148aa14a4ccf6276405f', '96.126.110.181', '1729581949', '__ci_last_regenerate|i:1729581949;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e98c9e17d9a1b8d5c325d3d5fd7ad0301a9283ef', '96.126.110.181', '1729581949', '__ci_last_regenerate|i:1729581949;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('441ed949cbf1bf36a71a6525f507885fbec35e13', '96.126.110.181', '1729581950', '__ci_last_regenerate|i:1729581950;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a4fa0512e16fbb820b6333b13a52ce6863d32f68', '96.126.110.181', '1729581950', '__ci_last_regenerate|i:1729581950;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('862c743d225817ea4a7c4983e712f98185cb6b04', '96.126.110.181', '1729581950', '__ci_last_regenerate|i:1729581950;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('af2e641c764f4b633685be8346ccf76ea2a5f524', '96.126.110.181', '1729581950', '__ci_last_regenerate|i:1729581950;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4d0a03ef370f680d3941d7bd61cc6c0bb9d7ed38', '96.126.110.181', '1729581951', '__ci_last_regenerate|i:1729581951;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7a602dd523e0577c8b882f8d5ceb297cd0d62d41', '96.126.110.181', '1729581951', '__ci_last_regenerate|i:1729581951;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ee61fac65b8bc9e49f6fc9b43b5cca91dbb716db', '96.126.110.181', '1729581951', '__ci_last_regenerate|i:1729581951;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8e94a48eeb1fce28a59eb6d4efa47349da7fdd05', '96.126.110.181', '1729581952', '__ci_last_regenerate|i:1729581952;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('17a26d68e1dac2bb4c058877f71b252620053f94', '96.126.110.181', '1729581952', '__ci_last_regenerate|i:1729581952;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('28829609f2a36d05c4bf2faaa4de4ee9ee85c9bb', '96.126.110.181', '1729581952', '__ci_last_regenerate|i:1729581952;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b9fb9b9e793ee8820b48eb56ddba1a4945fc4ee9', '96.126.110.181', '1729581952', '__ci_last_regenerate|i:1729581952;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6687df2bffe837e7128b6f981c8748416f20d972', '96.126.110.181', '1729581953', '__ci_last_regenerate|i:1729581953;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('07ad9db6fd06655a81336fe867f5491b93baa19f', '96.126.110.181', '1729581953', '__ci_last_regenerate|i:1729581953;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8d039d45a00766f06a8dd719f7a2fc997c8c1312', '96.126.110.181', '1729581953', '__ci_last_regenerate|i:1729581953;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f972cff9b1fca2e830b8f5bf42fc10e08f06dc0a', '96.126.110.181', '1729581954', '__ci_last_regenerate|i:1729581954;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8d675131279876817b9eceec7fd274373425bc14', '66.249.72.34', '1729589093', '__ci_last_regenerate|i:1729589093;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0b2345604dc35b99f7b1793a802ca56bf1bca7e7', '66.249.72.34', '1729589093', '__ci_last_regenerate|i:1729589093;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('39111a947f2aceed073f6d514750bf28fc9e8c9a', '207.154.197.113', '1729594354', '__ci_last_regenerate|i:1729594354;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ab659f44f1f5d6ed8ee0480f12156014400dcd8f', '207.154.197.113', '1729594357', '__ci_last_regenerate|i:1729594357;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e7279c7e192f026f965e5665644b4af8d9ddd1b0', '207.154.197.113', '1729594358', '__ci_last_regenerate|i:1729594358;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('994369807b7bcc7b578b5a91acac5d4cdc9e6211', '207.154.197.113', '1729594358', '__ci_last_regenerate|i:1729594358;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e98777fa2b7f3a164f8cd85e085dd23f350c39f6', '207.154.197.113', '1729594359', '__ci_last_regenerate|i:1729594359;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('936e0827a3cd630ae57ed0d526f25d0d2e378603', '207.154.197.113', '1729594359', '__ci_last_regenerate|i:1729594359;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bca711a15259128061907c960dd7ca31ac28f652', '207.154.197.113', '1729594360', '__ci_last_regenerate|i:1729594360;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fd4d856faa598b7d9de15cdb46fd9564fa215f90', '207.154.197.113', '1729594360', '__ci_last_regenerate|i:1729594360;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ba19940f3789e3b208647ab134017b4802d865b6', '207.154.197.113', '1729594361', '__ci_last_regenerate|i:1729594361;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('379ff90d733717c1f2d1a3d1c4546dced7f3c28c', '207.154.197.113', '1729594361', '__ci_last_regenerate|i:1729594361;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3cc9be30702e1d21f5172cfad908786d03007633', '207.154.197.113', '1729594362', '__ci_last_regenerate|i:1729594362;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5896f3181717e48220e55dd80fe0db8d49812f44', '207.154.197.113', '1729594363', '__ci_last_regenerate|i:1729594363;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bb760b9fbdf25f73c3e47221ee7a9df47b8cead9', '207.154.197.113', '1729594364', '__ci_last_regenerate|i:1729594364;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('258e738f3a12d49b477c2771b6267e87fc8903e3', '207.154.197.113', '1729594365', '__ci_last_regenerate|i:1729594365;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c45ed3eb268d9928aa28e86f99e404a2d7f63e64', '207.154.197.113', '1729594365', '__ci_last_regenerate|i:1729594365;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('32e3d6cba2fe0e25741300bc7e09239e2e50bf4a', '207.154.197.113', '1729594366', '__ci_last_regenerate|i:1729594366;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7f017c0d52b547ee8cedbec52d42c9b79aba895f', '207.154.197.113', '1729594366', '__ci_last_regenerate|i:1729594366;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dd37818a011acbc94d281135304e3d2b7bdaa82c', '207.154.197.113', '1729594367', '__ci_last_regenerate|i:1729594367;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('16af474838667d1fa2ceec13f7a333dec85dd39b', '207.154.197.113', '1729594368', '__ci_last_regenerate|i:1729594368;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1d7057c9cc705daaebae5031c2665f70558038a2', '207.154.197.113', '1729594368', '__ci_last_regenerate|i:1729594368;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1032755e9a674e0e5cf342ce6925736c2a688118', '207.154.197.113', '1729594369', '__ci_last_regenerate|i:1729594369;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('33434ee9846b9c24375c28df95bee0e087995c04', '207.154.197.113', '1729594369', '__ci_last_regenerate|i:1729594369;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('839e27dd227e2556bf9a85ae31585d3991b4be73', '207.154.197.113', '1729594370', '__ci_last_regenerate|i:1729594370;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('66590fbeb6eb5b93c8dc6cb73bb62bc15ef62a3d', '207.154.197.113', '1729594370', '__ci_last_regenerate|i:1729594370;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b70d9f28fca676462f7b9c60d2bddab531ce5e4a', '207.154.197.113', '1729594371', '__ci_last_regenerate|i:1729594371;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('edc6a004089ed94af2b546ef274c5cc18be2bf40', '207.154.197.113', '1729594372', '__ci_last_regenerate|i:1729594372;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e0875474e3b6582d6db979c91df0188ba9fbebc9', '207.154.197.113', '1729594373', '__ci_last_regenerate|i:1729594373;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2c5d212b1b7c34ff3e14752af1b16c49a67a3fbf', '207.154.197.113', '1729594374', '__ci_last_regenerate|i:1729594374;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c22a77bacb0d3b1fd6f0275fdac590e5cb3a1592', '207.154.197.113', '1729594374', '__ci_last_regenerate|i:1729594374;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6f837b38c864621f8b15fcfde9b514c54d8ad5c7', '207.154.197.113', '1729594375', '__ci_last_regenerate|i:1729594375;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0d4f82abd2e4e6160acffdcca811ed830dde286e', '51.222.253.20', '1729596443', '__ci_last_regenerate|i:1729596443;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3edcb7e2d8a1c3318e5f8f4503b287e266a959ea', '51.222.253.19', '1729606913', '__ci_last_regenerate|i:1729606912;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8ab52739130cb0aa1734205a592bb475202d76cb', '206.189.225.181', '1729609808', '__ci_last_regenerate|i:1729609807;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3e070bf2b46e046bb567a7efb93de849b1c63564', '206.189.225.181', '1729609809', '__ci_last_regenerate|i:1729609809;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('15a9bf272e771735c19fc464f69a7d11e79e437e', '206.189.225.181', '1729609810', '__ci_last_regenerate|i:1729609810;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('781f59fea2e2e1b5f06e90bdf94b185828c436a4', '206.189.225.181', '1729609810', '__ci_last_regenerate|i:1729609810;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fcdbe48b17eb02e07c07153be8e7cf11ebe21190', '206.189.225.181', '1729609810', '__ci_last_regenerate|i:1729609810;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e0b5829acd11e4721d3123b5f119e48ef5b1bfab', '206.189.225.181', '1729609811', '__ci_last_regenerate|i:1729609811;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('98a15230855f017f56e73aa25ded7c5e4117009e', '206.189.225.181', '1729609811', '__ci_last_regenerate|i:1729609811;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dc70deda59d8a482050c7c00ded57a1c460e7c5c', '206.189.225.181', '1729609811', '__ci_last_regenerate|i:1729609811;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('47e7a656af6e147a333b73020622d83cb167f9c0', '206.189.225.181', '1729609812', '__ci_last_regenerate|i:1729609812;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7e6148a53f9183cc17382c36905638a0d0a24bff', '206.189.225.181', '1729609812', '__ci_last_regenerate|i:1729609812;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ce75944661cd59b87d47c87f2d9500b8cf1ac70f', '206.189.225.181', '1729609812', '__ci_last_regenerate|i:1729609812;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7685f222ebe5822cbe7667b79b20a39910d21253', '206.189.225.181', '1729609813', '__ci_last_regenerate|i:1729609813;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fed8661150e3331cd1b58c1249cdccc7620bd872', '206.189.225.181', '1729609814', '__ci_last_regenerate|i:1729609814;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ad4a4c798e01cece2cf5b66b0427cc746c9c31ae', '206.189.225.181', '1729609814', '__ci_last_regenerate|i:1729609814;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0774228bec0465562d4b9429834ede058c5ada89', '206.189.225.181', '1729609814', '__ci_last_regenerate|i:1729609814;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f140867200c950b6ced01f24efebcebcb3c1f18b', '206.189.225.181', '1729609814', '__ci_last_regenerate|i:1729609814;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9e3d4f8542479e541328fc602a8f704548d32e74', '206.189.225.181', '1729609815', '__ci_last_regenerate|i:1729609815;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c58244118fa412317b6becdad42262d0017dc5f3', '206.189.225.181', '1729609815', '__ci_last_regenerate|i:1729609815;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6ab43e09be0740678c62e8d3b41bc4c5afa9eb56', '206.189.225.181', '1729609816', '__ci_last_regenerate|i:1729609816;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ff9cf790efe57c828a690fa2a57bcf22fb436bce', '206.189.225.181', '1729609816', '__ci_last_regenerate|i:1729609816;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('81c204c49d101a7b7d79ba3a19ca464fdfc221d3', '206.189.225.181', '1729609816', '__ci_last_regenerate|i:1729609816;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bda31665550a1300889408f768904bedf543c73d', '206.189.225.181', '1729609816', '__ci_last_regenerate|i:1729609816;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b094c37d38c1398007962975e3097e2a39873527', '206.189.225.181', '1729609817', '__ci_last_regenerate|i:1729609817;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e9360e953ed0b3ae74c0726bdeeebdd9f2a82c23', '206.189.225.181', '1729609817', '__ci_last_regenerate|i:1729609817;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5b0e170a1612f1c3354103d0f594d69ddd76ac3e', '206.189.225.181', '1729609817', '__ci_last_regenerate|i:1729609817;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cae972910f15b9a1a3ede0f56803a481f9754511', '206.189.225.181', '1729609818', '__ci_last_regenerate|i:1729609818;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f5a374df5235dd9cbd906d6e1640a2f1fea7b292', '206.189.225.181', '1729609819', '__ci_last_regenerate|i:1729609819;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('956689b9ba1370ad76d1909bba190f494268e712', '206.189.225.181', '1729609819', '__ci_last_regenerate|i:1729609819;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d16887719acb5efa1f79b2bd2242b4e15e7aa048', '206.189.225.181', '1729609819', '__ci_last_regenerate|i:1729609819;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7fb733111c537a2448318b5ab71045321b6760c4', '206.189.225.181', '1729609820', '__ci_last_regenerate|i:1729609820;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('460eb914985264287b38e6bb4eb28e886473d1bf', '206.189.225.181', '1729609820', '__ci_last_regenerate|i:1729609820;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f9871204c003b1c1e8507a77920d726062293f6e', '206.189.225.181', '1729609820', '__ci_last_regenerate|i:1729609820;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('36735b12cd1de7dbfb0cf119dbebc6d838b8d857', '206.189.225.181', '1729609820', '__ci_last_regenerate|i:1729609820;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a25dce07995952b29038fe1b80cdac2bbc7307ce', '206.189.225.181', '1729609821', '__ci_last_regenerate|i:1729609821;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8abd66c5f88c18a85aec68b4b5ddbe4c03d8a28b', '206.189.225.181', '1729609821', '__ci_last_regenerate|i:1729609821;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a9e71275efa77054bd1abc76fd213d5ba83e20ec', '206.189.225.181', '1729609821', '__ci_last_regenerate|i:1729609821;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('941758def1c7ae2539799ff5e8f39824f048f0b6', '206.189.225.181', '1729609822', '__ci_last_regenerate|i:1729609821;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3f2cbc17b0853a9e0a249807dd6cd8c5170a9c71', '206.189.225.181', '1729609822', '__ci_last_regenerate|i:1729609822;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3b9a523b425a8b163ea744601f39a1c6e5e8ccee', '206.189.225.181', '1729609822', '__ci_last_regenerate|i:1729609822;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1f74bf218c3c8d9a0b0edd67111877e3d096da50', '206.189.225.181', '1729609823', '__ci_last_regenerate|i:1729609823;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('abc2d64c263f7cd23f448b19a9b1d07de0c37d94', '206.189.225.181', '1729609823', '__ci_last_regenerate|i:1729609823;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('11a19b888974c215dea46871905b38d29b0d5d18', '206.189.225.181', '1729609823', '__ci_last_regenerate|i:1729609823;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7c197241fe2ca5f2f5d9995070d4ced04ceaf041', '206.189.225.181', '1729609824', '__ci_last_regenerate|i:1729609824;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9e72e23ec3559b2ae2336ed652d4dd62399f1459', '66.249.72.32', '1729609871', '__ci_last_regenerate|i:1729609871;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('129055d1cdbc30a3a96143df9fec643cac1ff097', '66.249.72.32', '1729609871', '__ci_last_regenerate|i:1729609871;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('980c7f0f4bdf76198e068fe9872306162f8b69c1', '165.22.235.3', '1729617889', '__ci_last_regenerate|i:1729617889;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9e0ad57d6cbee0a17c9ac9baa832177fcf40c4c8', '165.22.235.3', '1729617891', '__ci_last_regenerate|i:1729617891;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e2c4b79ecb495da4cd925a477e9f17ac92f4698c', '165.22.235.3', '1729617891', '__ci_last_regenerate|i:1729617891;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bc90187683b16d30e4f7b58e5e0e09346b2c4fff', '165.22.235.3', '1729617892', '__ci_last_regenerate|i:1729617892;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('eb90a7058630c87aa5a38f3058a7ad99bd054819', '165.22.235.3', '1729617892', '__ci_last_regenerate|i:1729617892;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('da6a493947930b92b72d3cf56b7433a53877419d', '165.22.235.3', '1729617892', '__ci_last_regenerate|i:1729617892;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ec6dcb65441d505611252ad378bfa7bf0d6a5a5a', '165.22.235.3', '1729617892', '__ci_last_regenerate|i:1729617892;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8a44d35bf5ace4d101282de715b678f71b719e81', '165.22.235.3', '1729617893', '__ci_last_regenerate|i:1729617893;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b14e4b6397f9ea1a73ca4cbda94bf8d0b157f47a', '165.22.235.3', '1729617893', '__ci_last_regenerate|i:1729617893;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1d9f2d470902e012ece31b14cbd7fed761f71394', '165.22.235.3', '1729617893', '__ci_last_regenerate|i:1729617893;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4ef04934d7d55655897505af8cd6e6d1079009f2', '165.22.235.3', '1729617893', '__ci_last_regenerate|i:1729617893;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b1b5362b0efa5fe6821a936a3d60032e5f25e902', '165.22.235.3', '1729617894', '__ci_last_regenerate|i:1729617894;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a4419c462af9f8ebfa6dc1a16f3a91f5e9084d99', '165.22.235.3', '1729617895', '__ci_last_regenerate|i:1729617895;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('590a710483f06fb47e8417c83965767034844c66', '165.22.235.3', '1729617895', '__ci_last_regenerate|i:1729617895;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('97f69ba970a849ff29c1c42aa86b5c8940cf7586', '165.22.235.3', '1729617895', '__ci_last_regenerate|i:1729617895;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('19e236d6c6580d2764ae4c2a640c0a837a631955', '165.22.235.3', '1729617896', '__ci_last_regenerate|i:1729617896;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dbe0817f5670973d84e6a96308e727db1350ee9a', '165.22.235.3', '1729617896', '__ci_last_regenerate|i:1729617896;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0b755898fb97cfac3e93f96e891152fac237a906', '165.22.235.3', '1729617896', '__ci_last_regenerate|i:1729617896;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('09601426d38201fa3f93b75f05f598b4cd111a9c', '165.22.235.3', '1729617896', '__ci_last_regenerate|i:1729617896;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('62a72ea093783336b4b8fa322390727607ce412f', '165.22.235.3', '1729617897', '__ci_last_regenerate|i:1729617897;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('451ce2a70d046225eb83a86781c2222b6e26bef3', '165.22.235.3', '1729617897', '__ci_last_regenerate|i:1729617897;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('441a77fcdb7b59e4c344cfed04339e6f8e298749', '165.22.235.3', '1729617897', '__ci_last_regenerate|i:1729617897;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8e0babdbb954642526173d9198b9ebf7ffd8d89b', '165.22.235.3', '1729617897', '__ci_last_regenerate|i:1729617897;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1265f7994a68a96850e2e3083e46a0b8a1748c4d', '165.22.235.3', '1729617898', '__ci_last_regenerate|i:1729617898;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('daaa5818948f80aa7b0fc56f805cbb46f66db6d7', '165.22.235.3', '1729617898', '__ci_last_regenerate|i:1729617898;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4a7c2b5bd5544e1b317318bde0341fb5606a1c82', '165.22.235.3', '1729617899', '__ci_last_regenerate|i:1729617899;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a485789252ebe9c391511f35b190d0e7e6bcfa82', '165.22.235.3', '1729617899', '__ci_last_regenerate|i:1729617899;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('84f1665f17d35eeb4a1061c5a13cbdc89157797c', '165.22.235.3', '1729617900', '__ci_last_regenerate|i:1729617900;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('747c21f0669cc7308d3576b3d8826c3ca88b7272', '165.22.235.3', '1729617900', '__ci_last_regenerate|i:1729617900;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('96c5f759c4de913fbc0be42b834dfb8692609491', '165.22.235.3', '1729617900', '__ci_last_regenerate|i:1729617900;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c8371e5dc0b5f5b610bc4b84ab2557da0bb9843e', '165.22.235.3', '1729617900', '__ci_last_regenerate|i:1729617900;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3ced26a5ca5510368b895ae48c4ab4c3ecb17d2c', '165.22.235.3', '1729617901', '__ci_last_regenerate|i:1729617901;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('637813a2c5ff1451d51c71599a5448dc9031bcaa', '165.22.235.3', '1729617901', '__ci_last_regenerate|i:1729617901;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('086b735d8fe1a3f2733782649534170341e9ed37', '165.22.235.3', '1729617901', '__ci_last_regenerate|i:1729617901;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('85627a77f0515716386b7c321acf9e0eb5bcf19c', '165.22.235.3', '1729617901', '__ci_last_regenerate|i:1729617901;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0799df77bf01d235592800d9dd36b12fc8e15e50', '165.22.235.3', '1729617902', '__ci_last_regenerate|i:1729617902;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4179051d034c9bcc821aa12ed33e3109f72684bc', '165.22.235.3', '1729617902', '__ci_last_regenerate|i:1729617902;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('935f8b543b674f1b66bc48e2f7e3621186b8e037', '165.22.235.3', '1729617902', '__ci_last_regenerate|i:1729617902;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('abedd5d3892491c81dd454cd901138d03fa24987', '165.22.235.3', '1729617903', '__ci_last_regenerate|i:1729617903;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8db53c05358dadbe4cd03cec2f7fada62c16f03e', '165.22.235.3', '1729617903', '__ci_last_regenerate|i:1729617903;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a6d6601bdb74bcc2197f78c0c0874229b3c00174', '165.22.235.3', '1729617903', '__ci_last_regenerate|i:1729617903;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a4f8496c2b407a3cd43e8dc1a93cde03d86d7dab', '165.22.235.3', '1729617903', '__ci_last_regenerate|i:1729617903;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c4b24543a56bda3430852c16441343d1df862554', '165.22.235.3', '1729617904', '__ci_last_regenerate|i:1729617904;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('522f4472a895ca5d382ba7ce79dc7516b2c6976e', '165.22.235.3', '1729617904', '__ci_last_regenerate|i:1729617904;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5a7149f8186d4de8e067b18005c497e538e26d3c', '165.22.235.3', '1729617904', '__ci_last_regenerate|i:1729617904;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5c60351dc1ef5e8726fa244242b87427eb33aa61', '165.22.235.3', '1729617905', '__ci_last_regenerate|i:1729617905;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('06212708fa94e942d93fa04e16c301d6b2bb9b38', '165.22.235.3', '1729617905', '__ci_last_regenerate|i:1729617905;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9343333d9041ce5c6e2bfc35fdf64a8fb92c7073', '147.185.132.249', '1729621147', '__ci_last_regenerate|i:1729621147;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('06c57bc3d922c54ad01ba6dcc74d7735349bfe7b', '51.222.253.15', '1729621789', '__ci_last_regenerate|i:1729621788;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f75dc88499296ebbcc925ddc3aed86830e4ead86', '154.216.18.190', '1729625320', '__ci_last_regenerate|i:1729625320;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1f11367e621e30aedc0d6735d4b2ed4e6464b5c0', '51.222.253.11', '1729636684', '__ci_last_regenerate|i:1729636684;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('48a4125ac76fc173d1bad705bf509723ee150a49', '205.169.39.29', '1729638675', '__ci_last_regenerate|i:1729638673;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a1235560bf633a054fe21f59a6cfee29a78cba37', '205.169.39.22', '1729639304', '__ci_last_regenerate|i:1729639301;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2c91ec63f3791f11a4b9e1d7ff5f6efa4eac07d7', '54.36.148.180', '1729642325', '__ci_last_regenerate|i:1729642325;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('50c5f01f4fc14797c876246c9aa03e7f116f8022', '51.222.253.17', '1729642327', '__ci_last_regenerate|i:1729642327;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('54d99203d56a1e07573a229a4e06a6789bfee128', '51.222.253.20', '1729650612', '__ci_last_regenerate|i:1729650612;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('557b25eef235dcda63113d281e0747fbf1a936a5', '47.128.40.41', '1729654801', '__ci_last_regenerate|i:1729654801;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9d68bef736ca19caa024cbffbca076264dfd1738', '47.128.21.187', '1729654826', '__ci_last_regenerate|i:1729654826;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cbea29a4ba8fdbd6e2f502ac8f26524ffaa9f5bc', '66.249.77.140', '1729657989', '__ci_last_regenerate|i:1729657989;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0d6241ddcdf2c67219bacaff746c685da2426b3f', '66.249.77.142', '1729657989', '__ci_last_regenerate|i:1729657989;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8a8bd9396825ae07e8ece770da662ac5da480cc0', '51.222.253.1', '1729658367', '__ci_last_regenerate|i:1729658367;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c19bb40c1efa3792160ed6524e168c6f37bb4da1', '66.249.77.142', '1729662576', '__ci_last_regenerate|i:1729662576;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d827b83510174ff7242869a073d6f53a5da63283', '66.249.77.142', '1729662729', '__ci_last_regenerate|i:1729662729;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f69a50312124aed0d4de25e177220a9c16711843', '66.249.77.140', '1729664343', '__ci_last_regenerate|i:1729664343;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4207e855ce95d3534d77f2b8733c42fc9699c8cc', '66.249.77.141', '1729664404', '__ci_last_regenerate|i:1729664404;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('50d9e11f8256f06091398b33d7659314f24bcff8', '66.249.77.142', '1729664524', '__ci_last_regenerate|i:1729664524;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('74bc2e8d6308862a5a88e3cb32941547912ef1d4', '66.249.77.142', '1729664585', '__ci_last_regenerate|i:1729664584;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d6812730c012a53a608f0b3bd767a7399c61975f', '66.249.77.140', '1729664946', '__ci_last_regenerate|i:1729664946;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d220ce2fe3595aa60000f3b10aff9bbf6e2063d3', '66.249.77.141', '1729665126', '__ci_last_regenerate|i:1729665126;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c18617c3f0ba1385c6bcfb6c78fe2c85653bbe30', '66.249.77.142', '1729665186', '__ci_last_regenerate|i:1729665186;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4813df3dfe7529e77eda757e7155a287f1d0c088', '66.249.77.140', '1729665246', '__ci_last_regenerate|i:1729665246;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('85bf0fbb34eb1907629c4e1bcffe320d053c6187', '66.249.77.141', '1729665367', '__ci_last_regenerate|i:1729665367;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e5ada1e1418e797f772847f2ce9070af8aef99bc', '66.249.77.142', '1729665427', '__ci_last_regenerate|i:1729665427;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ec065200ea936251db667956b23e25eb6345de75', '66.249.77.141', '1729665547', '__ci_last_regenerate|i:1729665547;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('769b9633dcf0232f1e38f12b9ca6b824a4a90d6e', '66.249.77.142', '1729665607', '__ci_last_regenerate|i:1729665607;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('7b67ec8ffd4bb53951b43d4334f222c77130b232', '66.249.77.141', '1729665667', '__ci_last_regenerate|i:1729665667;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bd9ad7c6ce3dcf13280c80949cd12364063463ec', '66.249.77.140', '1729665728', '__ci_last_regenerate|i:1729665728;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('e3e53f849211fc976c6007f043d4eb47df573977', '66.249.77.141', '1729665908', '__ci_last_regenerate|i:1729665908;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('93e53d5f2f235af4cc3650faa90a0acad9e02981', '66.249.77.142', '1729665968', '__ci_last_regenerate|i:1729665968;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('82dd8b06c52624692f7b4e50177cd90f9f8c8161', '66.249.77.142', '1729666028', '__ci_last_regenerate|i:1729666028;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('368dc637b1cece900894f5ef6db634ee3e399516', '66.249.77.141', '1729666088', '__ci_last_regenerate|i:1729666088;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('70497e5584eb000c923e7b0d12077698549877e0', '66.249.77.140', '1729666148', '__ci_last_regenerate|i:1729666148;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('919e6a2baf28c4e4e832907992115bb5c3a5135c', '66.249.77.141', '1729666388', '__ci_last_regenerate|i:1729666388;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1e623cec4196507e18a014c8141081d9b04d9187', '66.249.77.142', '1729666389', '__ci_last_regenerate|i:1729666388;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dea253d75cc6f6318d3003897a9ad15f3a976e17', '66.249.77.140', '1729666449', '__ci_last_regenerate|i:1729666449;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9154d959b8ff3b2325b10a4ccd9e664332b168eb', '66.249.77.141', '1729666509', '__ci_last_regenerate|i:1729666509;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dc29c4d66f9c09e91d218a29fd9416fcb2ff9c5e', '66.249.77.142', '1729666509', '__ci_last_regenerate|i:1729666509;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:40;'), ('54f74d100f65e1ffcc38f72a6edb11f68d101f27', '66.249.77.140', '1729666749', '__ci_last_regenerate|i:1729666749;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('86b6a21f1b445a48a61954abc0bf98507203b710', '66.249.77.142', '1729666749', '__ci_last_regenerate|i:1729666749;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('75ca5b7fdfdf06371b13139c55193745e1b085ca', '66.249.77.141', '1729666809', '__ci_last_regenerate|i:1729666809;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8040bb2d997bdbddeb42466b1e7d3109c2610843', '66.249.77.141', '1729666809', '__ci_last_regenerate|i:1729666809;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('03889516dd32b589b79dddabf99e669020ec3321', '66.249.77.142', '1729666930', '__ci_last_regenerate|i:1729666930;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2547e796ec27caa53101c197eb5dccd7b7fc4ffe', '66.249.77.142', '1729666990', '__ci_last_regenerate|i:1729666990;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6e21a3f62d41ffd66bfc6f03f4aa4abe606731dd', '179.43.189.138', '1729677525', '__ci_last_regenerate|i:1729677525;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2ae80bbb20977224a1c59589f1b259d57210e2dd', '179.43.189.138', '1729677677', '__ci_last_regenerate|i:1729677677;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('77775f447e0b53f809a0560e8015d2c0b9231ecf', '51.222.253.12', '1729680317', '__ci_last_regenerate|i:1729680317;cart_items|a:0:{}language|s:10:\"portuguese\";error_message|s:35:\"Nenhum valor de pesquisa encontrado\";__ci_vars|a:1:{s:13:\"error_message\";s:3:\"new\";}'), ('f113ffee55280354cf464fefcfe009c295703de8', '51.222.253.19', '1729686656', '__ci_last_regenerate|i:1729686656;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8ec91fbdb4a620edd259da4d29a335991aa40f7d', '51.222.253.16', '1729686657', '__ci_last_regenerate|i:1729686657;cart_items|a:0:{}language|s:10:\"portuguese\";error_message|s:90:\"Seu formulário de inscrição está vazio. Preencha o formulário com seus dados válidos\";__ci_vars|a:1:{s:13:\"error_message\";s:3:\"new\";}'), ('092b0e3bfe7d33627219835728faccf7264581e4', '17.241.75.16', '1729687043', '__ci_last_regenerate|i:1729687043;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('48cafb0ed4f09a0e9e37c184e041dfead509a558', '17.241.75.16', '1729687043', '__ci_last_regenerate|i:1729687043;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ee54c0031893ef35439898d9512c8914c90995d4', '51.222.253.2', '1729690034', '__ci_last_regenerate|i:1729690034;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('412b06ab2ea09927c491cadc94f154b45c9a6f56', '179.43.189.138', '1729693474', '__ci_last_regenerate|i:1729693474;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0b4932296011d6fef81f7942edcdefb5863a4c50', '179.43.189.138', '1729693522', '__ci_last_regenerate|i:1729693522;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('54b98a8bfc7142e4041d106f9ad8e2106df45f70', '51.222.253.15', '1729693901', '__ci_last_regenerate|i:1729693901;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('70a7a62ad6a593312ee7ae0a79e6e1fce6318973', '47.128.122.197', '1729696401', '__ci_last_regenerate|i:1729696401;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1848d6917fce031d5cf40c0f6c55e5b09edb0ad7', '51.222.253.3', '1729696946', '__ci_last_regenerate|i:1729696946;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1dbe920a256d0eaffeba045247298e6676f2732a', '51.222.253.18', '1729698444', '__ci_last_regenerate|i:1729698444;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2647337d108230a89d7e1a6f196ca08d906bb8ad', '51.222.253.14', '1729702426', '__ci_last_regenerate|i:1729702426;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('c51ba3996f97cd8573b978c5af731de0c5e2df5b', '40.77.167.184', '1729704740', '__ci_last_regenerate|i:1729704740;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4148c6781a7fc1e6d60b507f638952121ef0e146', '40.77.167.123', '1729704749', '__ci_last_regenerate|i:1729704749;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('17bf28cf6640fbbad467bce9cc34f081e6be292d', '51.222.253.18', '1729709580', '__ci_last_regenerate|i:1729709580;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('d8d35b58ac9b825cde671a3bb5ec23c723484c2c', '51.222.253.15', '1729711244', '__ci_last_regenerate|i:1729711244;cart_items|a:0:{}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:0;'), ('0e65515120105a9dd4e7d6442529a9ce771cb7c9', '51.222.253.1', '1729713051', '__ci_last_regenerate|i:1729713050;language|s:7:\"english\";'), ('b4af3b7de526859b1863f740f4c6526bf514caf9', '66.249.77.141', '1729714438', '__ci_last_regenerate|i:1729714438;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c512b39042d6c5aabfc68b2ba63d0bf4ec11ff3d', '66.249.77.142', '1729714438', '__ci_last_regenerate|i:1729714438;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('28bc752c73c1fa66bf6dbe72bd8ab7a2256f6fa2', '45.148.10.59', '1729721680', '__ci_last_regenerate|i:1729721679;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8a4894c665949fbde04b029263a3dc753026d339', '45.148.10.59', '1729721691', '__ci_last_regenerate|i:1729721691;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c03667caa124909e2689217928122eb292e57fbd', '45.148.10.59', '1729721691', '__ci_last_regenerate|i:1729721691;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('84b7727999bc77ce37ba648eba2d290a9cea9ba1', '45.148.10.59', '1729721691', '__ci_last_regenerate|i:1729721691;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f7c6c5a987b7c8bb0adacc1c442121e8d834074d', '45.148.10.59', '1729721691', '__ci_last_regenerate|i:1729721691;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('da30aa08ed65bffa0d8ed90d9493be3d4098f801', '45.148.10.59', '1729721691', '__ci_last_regenerate|i:1729721691;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fccd0a08a60d69c0615eacf7f5a11285022df9a7', '45.148.10.59', '1729721691', '__ci_last_regenerate|i:1729721691;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b4a0bb6ffa35b3025dfe28d1dd5e8ddad840c0f9', '45.148.10.59', '1729721692', '__ci_last_regenerate|i:1729721692;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b1dd53a271551c2216d5c6dc5f36045a37747f67', '45.148.10.59', '1729721692', '__ci_last_regenerate|i:1729721692;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('de7e55f01214e6fcc50b713f502fffaac488f914', '45.148.10.59', '1729721692', '__ci_last_regenerate|i:1729721692;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('03cdd703527fbf24410a26cd29631cda8f02cc45', '45.148.10.59', '1729721692', '__ci_last_regenerate|i:1729721692;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('570eec93310e83df2f860a5df6f01ac5232d3347', '45.148.10.59', '1729721692', '__ci_last_regenerate|i:1729721692;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7593afd56f78d750ae3599c98ce3fdc90d902126', '45.148.10.59', '1729721692', '__ci_last_regenerate|i:1729721692;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b2a5a51c36d2e58201c709ec0d20dcddfb13a9df', '45.148.10.59', '1729721692', '__ci_last_regenerate|i:1729721692;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('75bc18c71a0ea86df309f52f8e383f7c8b3edcf3', '45.148.10.59', '1729721692', '__ci_last_regenerate|i:1729721692;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('380656653a9c9fd7036e2a589d2d8c5662d27f66', '45.148.10.59', '1729721693', '__ci_last_regenerate|i:1729721693;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('517ae058a205044fa503a2faf87e520ebd866d4c', '45.148.10.59', '1729721694', '__ci_last_regenerate|i:1729721694;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('472cb91b8982c82ee12c260d99e0fecde254674b', '45.148.10.59', '1729721694', '__ci_last_regenerate|i:1729721694;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7c3cd395429d22d58c6695683f300e327a6b20b0', '51.222.253.11', '1729721757', '__ci_last_regenerate|i:1729721757;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('f7c85cc1aca0b9e326428a90fcd8ef489bb7f73a', '51.222.253.5', '1729723831', '__ci_last_regenerate|i:1729723831;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('eb0317608c7462b847c7cb483157b23400245efa', '51.222.253.11', '1729726996', '__ci_last_regenerate|i:1729726996;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('870a56b188c42ef913be8fcc97caafc2fb991fe5', '91.142.222.180', '1729729117', '__ci_last_regenerate|i:1729729116;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9bd865c410f3a9d70f55db6fc54671e33cd63c8e', '216.244.66.227', '1729729444', '__ci_last_regenerate|i:1729729444;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7c23b518af0a7cdb4fceb2b9de713ccd11b80311', '216.244.66.227', '1729729978', '__ci_last_regenerate|i:1729729978;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('130fd8bc9eb931a3b0c2d7ba7f62ad65ef66bb04', '216.244.66.227', '1729730650', '__ci_last_regenerate|i:1729730650;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('166d3a0d002683d97c649d12c4ac4e66dd374c47', '54.36.148.178', '1729732783', '__ci_last_regenerate|i:1729732783;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('32c0125fcfe23427c7d63b27db9fb38cd02e6d19', '51.222.253.8', '1729732784', '__ci_last_regenerate|i:1729732784;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('1818e66d98de480a69c829b31140ce21501b7a29', '85.208.96.196', '1729735192', '__ci_last_regenerate|i:1729735191;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('96a3c9c861130f9365398e56ab1be047799cc88b', '185.191.171.5', '1729735192', '__ci_last_regenerate|i:1729735192;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cc46ecb974888b10787f472ff56cfcbd96d703bd', '51.222.253.3', '1729735764', '__ci_last_regenerate|i:1729735763;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('5bc5c792a9c004943eaf5331b06d5bf4498c5f13', '85.208.96.209', '1729737520', '__ci_last_regenerate|i:1729737520;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('19743cca3af1764b658f2d55af5016e4fa88b169', '20.171.206.162', '1729737882', '__ci_last_regenerate|i:1729737881;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6a6cfbf3cc9bff01dc149bf5e82d0924a7e1616f', '20.171.206.118', '1729737901', '__ci_last_regenerate|i:1729737901;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('21d31a894021223c88a57815065e250b36c2e649', '20.171.206.118', '1729737930', '__ci_last_regenerate|i:1729737930;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:215;'), ('73a532a6c119661297491bac15dbc4243af6cbdb', '20.171.206.118', '1729737947', '__ci_last_regenerate|i:1729737947;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:78:\"https://cursos.curaquantica13.com/home/course/mentoria-i-a-e-espiritualidade/5\";'), ('7d02d68cd92f75c3fd0a9460e142e95a8b0490e6', '20.171.206.136', '1729737949', '__ci_last_regenerate|i:1729737949;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:80:\"https://cursos.curaquantica13.com/home/course/desprogramação-neurobiológica/1\";'), ('0020a3cc6a7f8ed7462c58abe339f31bf9ea65dd', '20.171.206.136', '1729737951', '__ci_last_regenerate|i:1729737951;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('0f22b05990b02d01e4fc49ed43036418be5996ef', '20.171.206.136', '1729737953', '__ci_last_regenerate|i:1729737953;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('5341bca470d2ee6774e8b1d36eca856775ce2a11', '20.171.206.136', '1729737959', '__ci_last_regenerate|i:1729737959;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:81:\"https://cursos.curaquantica13.com/home/course/curando-minhas-feridas-emocionais/4\";'), ('de57f52b7e536647768a5235f998365a5ec5fc2a', '20.171.206.136', '1729737962', '__ci_last_regenerate|i:1729737962;cart_items|a:0:{}language|s:10:\"portuguese\";theme_mode|s:10:\"dark-theme\";'), ('2debe270c5e12821ef8620a116430f8688b6cd70', '20.171.206.136', '1729737964', '__ci_last_regenerate|i:1729737964;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('26715b0e3bd6854e79bcb68c17a2c380353766d2', '20.171.206.136', '1729737973', '__ci_last_regenerate|i:1729737973;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:68:\"https://cursos.curaquantica13.com/home/course/atraindo-abundância/3\";'), ('e67926b436b845beb0797e0e6d6f7edc0a844088', '20.171.206.136', '1729737975', '__ci_last_regenerate|i:1729737975;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('f41cfc509bae63452557cf7e9312b32389dc70ae', '20.171.206.136', '1729737976', '__ci_last_regenerate|i:1729737976;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:40;'), ('80954a39351767c5ff0e2727af9fbd669813f41f', '20.171.206.136', '1729737977', '__ci_last_regenerate|i:1729737977;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0d9f3b55d11422af94ae347799fac46f40730cc5', '20.171.206.136', '1729737978', '__ci_last_regenerate|i:1729737978;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:71:\"https://cursos.curaquantica13.com/home/course/jornada-atraindo-o-amor/2\";'), ('16aa62cf80a903373c47586d260bf5269a9219da', '20.171.206.136', '1729737981', '__ci_last_regenerate|i:1729737981;cart_items|a:1:{i:0;s:1:\"5\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:799;'), ('cdea95dcd638d704d9f47103c80a9f82e3c3033d', '20.171.206.136', '1729737989', '__ci_last_regenerate|i:1729737989;cart_items|a:0:{}language|s:10:\"portuguese\";error_message|s:35:\"Nenhum valor de pesquisa encontrado\";__ci_vars|a:1:{s:13:\"error_message\";s:3:\"new\";}'), ('1e9b437e5daecab507b5658b77f829be86a96e99', '20.171.206.136', '1729737999', '__ci_last_regenerate|i:1729737999;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b274cc3aa05158d9d72114dc61f34d75b0e610c5', '85.208.96.204', '1729738041', '__ci_last_regenerate|i:1729738041;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2ef34181d36e5292ad704f22671f2d9635219353', '51.222.253.18', '1729742179', '__ci_last_regenerate|i:1729742179;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('d3e2d80acc07f146d741ba798d4613fdcc2df7e2', '109.243.69.136', '1729743508', '__ci_last_regenerate|i:1729743508;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4dab934e95ddefe84ef48e170d0108e7470842e0', '109.243.69.136', '1729743509', '__ci_last_regenerate|i:1729743509;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('11d3ab359a8729781754444c3cf576ec239ea849', '109.243.69.136', '1729743509', '__ci_last_regenerate|i:1729743509;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ad2ed659ca4bf12ba3bf630ecd61566acd33b4d9', '51.222.253.12', '1729745337', '__ci_last_regenerate|i:1729745337;cart_items|a:0:{}language|s:10:\"portuguese\";error_message|s:30:\" Endereço de e-mail inválido\";__ci_vars|a:1:{s:13:\"error_message\";s:3:\"new\";}'), ('8098ab010fd17ab079669cbc384a74631e6bd5a4', '51.222.253.20', '1729746962', '__ci_last_regenerate|i:1729746962;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('19e2b0baa1acb86d8f3f20d84b378bc8b0ae12c0', '85.208.96.201', '1729750242', '__ci_last_regenerate|i:1729750242;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('aa172f3efaeaed5ad9c3c7be950eee0edb31499b', '185.191.171.14', '1729750243', '__ci_last_regenerate|i:1729750243;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('51e67675f526ae80371f664335f2abee21bec1ef', '185.191.171.7', '1729750535', '__ci_last_regenerate|i:1729750535;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5670f1c448f822875c6bb7fff88844e459cbf97b', '51.222.253.1', '1729750679', '__ci_last_regenerate|i:1729750679;cart_items|a:0:{}language|s:10:\"portuguese\";error_message|s:31:\"Não há cursos no seu carrinho\";__ci_vars|a:1:{s:13:\"error_message\";s:3:\"new\";}'), ('64223da082c4ed70e0549b94e48bcba0de3cfd46', '51.222.253.5', '1729751842', '__ci_last_regenerate|i:1729751842;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('9f8ed2db5f366ed1e19cfdabad07a4bd4bb310ce', '51.222.253.7', '1729753059', '__ci_last_regenerate|i:1729753059;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('867d43b52640e686e2d622f2c00c0402e0bf3e6a', '85.208.96.202', '1729755365', '__ci_last_regenerate|i:1729755364;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ac21e89c0fb396987c85f05f626398f5896d5761', '185.191.171.11', '1729755365', '__ci_last_regenerate|i:1729755365;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cafff63a58ac8b67dce444dedafb40196683cc84', '51.222.253.11', '1729755751', '__ci_last_regenerate|i:1729755751;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a62218adf1960b7eca1453bb6a1a81f6ac082e82', '185.191.171.6', '1729756446', '__ci_last_regenerate|i:1729756446;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('495c3b5ca441ff0be6002c127dd929bcf417dcee', '185.191.171.13', '1729756680', '__ci_last_regenerate|i:1729756680;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0ad4d26d4aec4ff70eebd707505a13cc09c97767', '51.222.253.16', '1729756783', '__ci_last_regenerate|i:1729756783;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('04a885d81ba5f51d298eeee53927df4dc9295413', '185.191.171.15', '1729758758', '__ci_last_regenerate|i:1729758758;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cb324c02a78b0e33ae0cb48edd279af9e2ca1f78', '64.227.32.66', '1729761043', '__ci_last_regenerate|i:1729761043;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3242cf15621419b1a8a8740a482a23984e72458d', '64.227.32.66', '1729761046', '__ci_last_regenerate|i:1729761046;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('877637c7625228296e94e2827405984d3591267f', '64.227.32.66', '1729761047', '__ci_last_regenerate|i:1729761047;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0b685487246e0cc9a04a567c431e16134b756e4d', '64.227.32.66', '1729761047', '__ci_last_regenerate|i:1729761047;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2ab8ebae957e0ea2723a33de6a30d34bc9c57fd8', '64.227.32.66', '1729761048', '__ci_last_regenerate|i:1729761048;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('decc0607ec34e2d7091592a2e19c8aedbbe0a7fb', '64.227.32.66', '1729761048', '__ci_last_regenerate|i:1729761048;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0290a500ff25633855b3994c7b2b5a920e9950a7', '64.227.32.66', '1729761049', '__ci_last_regenerate|i:1729761049;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('615964ef73b099f016a4d138335465eb9f222961', '17.241.75.50', '1729761049', '__ci_last_regenerate|i:1729761049;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1c921db3416fd890c16c20507bcb82827a17bca3', '64.227.32.66', '1729761049', '__ci_last_regenerate|i:1729761049;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5017801e3236dba9267fa31cd4a04f170cd98339', '64.227.32.66', '1729761050', '__ci_last_regenerate|i:1729761050;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2c7cb35407a4e02a780f34a0a82e4febc1fbcbdf', '64.227.32.66', '1729761050', '__ci_last_regenerate|i:1729761050;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7ef9ede00bea2871d2748d4c2de29600e0a16d5e', '64.227.32.66', '1729761050', '__ci_last_regenerate|i:1729761050;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('10a57eeedc8d27e60221a3db7b3d68d58728de0f', '64.227.32.66', '1729761051', '__ci_last_regenerate|i:1729761051;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('18869e446e4cafb9d43d7d4be12350238141def6', '64.227.32.66', '1729761053', '__ci_last_regenerate|i:1729761053;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ca2d8f4a2722ea6d65763411cb94f21b91881454', '64.227.32.66', '1729761053', '__ci_last_regenerate|i:1729761053;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('98beae45b0c911c956e37c6b03cbfdd0e58c9d18', '64.227.32.66', '1729761054', '__ci_last_regenerate|i:1729761054;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('17dd0976f3efb41af019fd4b842c21ab4e6b6111', '64.227.32.66', '1729761054', '__ci_last_regenerate|i:1729761054;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('59c6d123e6dd94b8359514bb7c615dbb0904de44', '64.227.32.66', '1729761055', '__ci_last_regenerate|i:1729761055;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e59233ac35c3428cce7b7766c5e57ecde1b60447', '64.227.32.66', '1729761056', '__ci_last_regenerate|i:1729761056;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('08d9dff5be8e3aee8b04ff1259504136a8cf455d', '64.227.32.66', '1729761056', '__ci_last_regenerate|i:1729761056;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('331d4b52c430fece7ffe91e8b7a5056ec47e486a', '64.227.32.66', '1729761056', '__ci_last_regenerate|i:1729761056;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2a715fe972e89a1d00dfc9071e1730261d87782c', '64.227.32.66', '1729761057', '__ci_last_regenerate|i:1729761057;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6bf0ae710cdcfa0fd4acc9aac22b9f3b9c94853e', '64.227.32.66', '1729761057', '__ci_last_regenerate|i:1729761057;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('49318f13ddb9935798a2b401cc7ea459f8881e4c', '64.227.32.66', '1729761058', '__ci_last_regenerate|i:1729761058;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d5c9bc26d39779802f7e396caedcaef950e319a5', '64.227.32.66', '1729761058', '__ci_last_regenerate|i:1729761058;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1b9c370708a3bcf285b46b8c3547e7dd08369d87', '64.227.32.66', '1729761059', '__ci_last_regenerate|i:1729761059;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a356f6408e93f1c008d399d45cbf4170bb76cc03', '64.227.32.66', '1729761060', '__ci_last_regenerate|i:1729761060;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('08e208160d95eb0adac03d1b8e760f5acad507b0', '64.227.32.66', '1729761061', '__ci_last_regenerate|i:1729761061;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('73e271d6496dd42efa503c86da57f96eb2433919', '64.227.32.66', '1729761061', '__ci_last_regenerate|i:1729761061;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('256606b58c4bd90e0fdd88acd5130f14db376116', '64.227.32.66', '1729761062', '__ci_last_regenerate|i:1729761062;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c3d4d3e7037a9d1056d766bebd628c42e545ba37', '64.227.32.66', '1729761063', '__ci_last_regenerate|i:1729761063;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('86c5ecf129fb4a44a82eef0ef1f7c4bd36bc3df7', '64.227.32.66', '1729761063', '__ci_last_regenerate|i:1729761063;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6aae4d9ab28bef231e2ee1b0ae694896c52f3860', '164.90.228.79', '1729761317', '__ci_last_regenerate|i:1729761317;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8baa3d344cef9417a34d1d9537c13f5399978115', '164.90.228.79', '1729761321', '__ci_last_regenerate|i:1729761321;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0ee8ab4f0633b5963130675c21ed541945fd1691', '164.90.228.79', '1729761321', '__ci_last_regenerate|i:1729761321;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('157164f231cb6eac0ea9e8a98583dfc696028e36', '164.90.228.79', '1729761322', '__ci_last_regenerate|i:1729761322;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('26a0695e78fd14227c875e28e6ae3e404e69d312', '164.90.228.79', '1729761322', '__ci_last_regenerate|i:1729761322;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bfaaa9ac041c1a7b0ca61e5f28a4df8c8923b348', '164.90.228.79', '1729761323', '__ci_last_regenerate|i:1729761323;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2a288cf2fc79d1c5c44e08b979c3992ca8ef85eb', '164.90.228.79', '1729761323', '__ci_last_regenerate|i:1729761323;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('164fafd1ab7264d3b98e0d5fae29b6d55861e1ff', '164.90.228.79', '1729761324', '__ci_last_regenerate|i:1729761324;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('26e4993a47c3f4e53f3797c07ef480d1f2534c80', '164.90.228.79', '1729761324', '__ci_last_regenerate|i:1729761324;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('79ccde12a2c8673a05c30bcd2d7c89fed58c252b', '164.90.228.79', '1729761325', '__ci_last_regenerate|i:1729761325;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f212ab76e94faf8f5b284abebccd2c9a971c5583', '164.90.228.79', '1729761325', '__ci_last_regenerate|i:1729761325;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5655dbbf3759124f23f8d0326c80a7e567d7d1af', '164.90.228.79', '1729761326', '__ci_last_regenerate|i:1729761326;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9365cea3a4063b6885a1a8aa2e97b2bbc7d5e1cc', '164.90.228.79', '1729761328', '__ci_last_regenerate|i:1729761328;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('efdbe27895ff9850836fffd7d2609d993fe6c2d7', '164.90.228.79', '1729761328', '__ci_last_regenerate|i:1729761328;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0975f57639661314ca1661f989927afbf907fa8c', '164.90.228.79', '1729761329', '__ci_last_regenerate|i:1729761329;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('94751aba5457a34a4a19be0251f4c3e4616e8869', '164.90.228.79', '1729761329', '__ci_last_regenerate|i:1729761329;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2f117742daba24b02191ca13ecd308cdc45078d7', '164.90.228.79', '1729761330', '__ci_last_regenerate|i:1729761330;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5f1cd0028f901465946e5d37e540f74e8fc852a4', '164.90.228.79', '1729761331', '__ci_last_regenerate|i:1729761331;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c563c0fd22c66cf0a3e0d8b98e73c8cc15e9fdb9', '164.90.228.79', '1729761331', '__ci_last_regenerate|i:1729761331;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f0052c86883bc4e5dba25767c8131d38861834ad', '164.90.228.79', '1729761332', '__ci_last_regenerate|i:1729761332;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f95a966f25f83f0c7baac7c72d1611ac4b69a5ad', '164.90.228.79', '1729761332', '__ci_last_regenerate|i:1729761332;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('52300ab52432d9715a581e8634267565d080c4b3', '164.90.228.79', '1729761333', '__ci_last_regenerate|i:1729761333;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f25dd13792f201fb3d9d38a2928d34337c3de180', '164.90.228.79', '1729761333', '__ci_last_regenerate|i:1729761333;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('18d70d427ea156b78c503614247f6bb1736fde4f', '164.90.228.79', '1729761334', '__ci_last_regenerate|i:1729761334;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0605854cb12391203c5b7ef4db6964d4585d4cad', '164.90.228.79', '1729761334', '__ci_last_regenerate|i:1729761334;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ca0496862746983b2116ddc85b69c70b24cc72cd', '164.90.228.79', '1729761336', '__ci_last_regenerate|i:1729761336;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7e3b34c86d755e99c6e4787924cca23b707012e7', '164.90.228.79', '1729761336', '__ci_last_regenerate|i:1729761336;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('51076e5de2967d9598a1e1fcae15f4b5902180fb', '164.90.228.79', '1729761337', '__ci_last_regenerate|i:1729761337;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('74665de142c3dffdd90139f2ce24549712212779', '164.90.228.79', '1729761338', '__ci_last_regenerate|i:1729761338;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9304686a5134961adcdceb4de9d60b7bbb485cab', '164.90.228.79', '1729761338', '__ci_last_regenerate|i:1729761338;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a71a8a1e1d70d47de1b0217de1edfa11d9a83f13', '51.222.253.11', '1729762865', '__ci_last_regenerate|i:1729762865;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('141444fe64dbffff803651d33718cbf0a631b705', '85.208.96.197', '1729763018', '__ci_last_regenerate|i:1729763018;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('27756e994be201295092cae17904435d51d2bd3c', '85.208.96.204', '1729763018', '__ci_last_regenerate|i:1729763018;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7effd74ce080e30c19b0fc329d23b81884308ed3', '85.208.96.210', '1729763249', '__ci_last_regenerate|i:1729763249;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2e1c63ad984a17f1ac1a9c6654fa098e7fe13a4f', '185.191.171.7', '1729763756', '__ci_last_regenerate|i:1729763755;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3349ad4ca50dc43dff74053640a5ab92aaf4154e', '35.206.115.46', '1729763921', '__ci_last_regenerate|i:1729763921;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4cee65468c1dcca6e067ee8beda88e0a30cfa719', '35.206.115.46', '1729763923', '__ci_last_regenerate|i:1729763923;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c1faef1b37ebb38cbde1028ed29dcf1dc0381390', '35.206.115.46', '1729763926', '__ci_last_regenerate|i:1729763926;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7e97807a65a3f560727938e58fbd6651cd2ad834', '35.206.115.46', '1729763926', '__ci_last_regenerate|i:1729763926;cart_items|a:0:{}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:0;'), ('2d0905c2d862b8d9b5d57248c926c7e63be3ff5c', '35.206.115.46', '1729763929', '__ci_last_regenerate|i:1729763929;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9ab646ce035d6eea305ec31ed133077a1f1b6cbe', '35.206.115.46', '1729763955', '__ci_last_regenerate|i:1729763954;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1b4b6d1c84ccd0376cb63a558c8119163f9dfcb5', '34.0.80.142', '1729764013', '__ci_last_regenerate|i:1729764013;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('db35ebf795abbd7abcfc8cea1f74bb153a913e40', '34.0.80.142', '1729764016', '__ci_last_regenerate|i:1729764016;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6c30a68da11b6a4384e6f5c55fe0f51f2fec2201', '34.0.80.142', '1729764022', '__ci_last_regenerate|i:1729764022;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('938bb01dbf4426a4289ebbac805009412c69b7fd', '34.0.80.142', '1729764022', '__ci_last_regenerate|i:1729764022;cart_items|a:0:{}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:0;'), ('53dc6c74420b74367d9489d73244262cc69ee621', '34.0.80.142', '1729764027', '__ci_last_regenerate|i:1729764027;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a24e01c6c726dae73fea4edab2a1911a6d26cf46', '34.0.80.142', '1729764031', '__ci_last_regenerate|i:1729764031;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4d6d2dd738f47c74334d105ec35ee5cb06f57715', '185.191.171.8', '1729764220', '__ci_last_regenerate|i:1729764220;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b7ab27fab8a6efdd89cd2fd5c2898955c4aa22cf', '185.191.171.1', '1729765703', '__ci_last_regenerate|i:1729765703;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('446bddf935f2a59c3788f9f3fb710c3a2727d791', '85.208.96.206', '1729766110', '__ci_last_regenerate|i:1729766110;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7f8735b1b2a05ec1111542596c98c6b480d48da0', '185.191.171.8', '1729768691', '__ci_last_regenerate|i:1729768691;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('923ba6fc7ee6acc40c17402d06ff2dd3ae3ca7c2', '85.208.96.209', '1729768691', '__ci_last_regenerate|i:1729768691;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f8e09f47df30f11366168419d6bc61412accfd0b', '37.187.89.104', '1729769769', '__ci_last_regenerate|i:1729769769;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('459abc9f26f6e5e50b8fb4b393d416d54e041cbd', '37.187.89.104', '1729769771', '__ci_last_regenerate|i:1729769771;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fb34e030d91cc11a0f87396ed109eb868159991f', '37.187.89.104', '1729769772', '__ci_last_regenerate|i:1729769772;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('40ad12648f77e53d033e1f4472c33cf83cd96d74', '85.208.96.205', '1729770292', '__ci_last_regenerate|i:1729770292;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c9eee735f445f8aa87e357435064d3d8e89155f0', '85.208.96.205', '1729770708', '__ci_last_regenerate|i:1729770708;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('048746ad1c7b5a8ac0a61d97c7f56db27bfd032b', '66.249.79.7', '1729770718', '__ci_last_regenerate|i:1729770718;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('edaf182519862f5ee6721f6c80c255e62375bcda', '66.249.79.8', '1729770718', '__ci_last_regenerate|i:1729770718;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1f1e84f7811d028659b6b02b4238a01b423f79f2', '66.249.79.8', '1729770885', '__ci_last_regenerate|i:1729770885;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('eccf6906886c554ec31e5b8c18c8b053d012f727', '66.249.79.1', '1729771206', '__ci_last_regenerate|i:1729771206;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1f409d56ac6b67cb7b37d517dc5649b571c296d2', '66.249.79.7', '1729771219', '__ci_last_regenerate|i:1729771219;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('61f72f8c81deaef61fa2d874bdfb0b1c012c915b', '51.222.253.20', '1729771227', '__ci_last_regenerate|i:1729771227;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8a200fc22367f58d333fcf02bea727a7190d6f1a', '66.249.79.7', '1729771272', '__ci_last_regenerate|i:1729771272;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0595292310fe4712fbdbb4eb8a867e08597658ed', '66.249.79.7', '1729771333', '__ci_last_regenerate|i:1729771333;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('14316820f7daf95d8cbffacde5ef68f93bfc428f', '66.249.79.8', '1729771333', '__ci_last_regenerate|i:1729771333;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9c5915571fbc96f292784bf17d465973d99b47b9', '66.249.79.7', '1729771392', '__ci_last_regenerate|i:1729771392;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7606d656ffc4b0e3121d7ff26db8f54b6468179e', '66.249.79.1', '1729771544', '__ci_last_regenerate|i:1729771544;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('daf9214179b3b065fe6064dd0a50ad3f45a2a3a9', '66.249.79.1', '1729771545', '__ci_last_regenerate|i:1729771545;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f1aa755d637a1570067a76b2d8db9b3434f9d23b', '66.249.79.7', '1729771995', '__ci_last_regenerate|i:1729771995;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5cf599776dfbb39e4ddac0e47420bf1aa28ef1d3', '66.249.79.8', '1729772095', '__ci_last_regenerate|i:1729772095;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('be3f6aa8501ec9ebc53ce52e61addc417dee9c18', '66.249.79.8', '1729772169', '__ci_last_regenerate|i:1729772169;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c18f460a4698752be352038813df07bf5edd0d6d', '66.249.79.7', '1729772472', '__ci_last_regenerate|i:1729772472;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('aa817db94c4c7706e862897c9c5f7c56566ff157', '66.249.79.7', '1729773195', '__ci_last_regenerate|i:1729773195;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b2eff6cb343e163436b5d8f1c36378c98c5330fa', '66.249.79.8', '1729773945', '__ci_last_regenerate|i:1729773945;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1278dfc4e6e2296872dc3a2b1e2e7ef6b481977e', '66.249.79.7', '1729774004', '__ci_last_regenerate|i:1729774004;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('01cfb19c5eb83d5b07d9d89aef457f53c5c51011', '66.249.79.1', '1729774065', '__ci_last_regenerate|i:1729774065;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:215;'), ('d9785d1a5131af3f4df3cb3f29011aa8f18a6625', '66.249.79.8', '1729774158', '__ci_last_regenerate|i:1729774158;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f8880ecd25f6df4428797799f5b436f0729dedc4', '66.249.79.7', '1729774197', '__ci_last_regenerate|i:1729774197;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9fc277f950ebb7a1b2bf3e342c207af259b01e84', '66.249.79.1', '1729774198', '__ci_last_regenerate|i:1729774198;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4cfacbcbd2d0b9d41b136a6c48e70128aa890268', '66.249.79.8', '1729774206', '__ci_last_regenerate|i:1729774206;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c8e11152d90c66f4ffe5b895ec8e6043cfe132db', '66.249.79.1', '1729774753', '__ci_last_regenerate|i:1729774753;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d26b95b292a4db9ee5181ed91e65683c8b629e63', '66.249.79.7', '1729774753', '__ci_last_regenerate|i:1729774753;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('933499f473828313d95ba804a57738550578055f', '66.249.79.8', '1729774795', '__ci_last_regenerate|i:1729774795;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('431df122189c1fd127273960d73450b3a3cb4c04', '66.249.79.1', '1729774807', '__ci_last_regenerate|i:1729774807;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('96b4ec72952a0d486e29a7a569f8d72eb905a50c', '83.240.178.70', '1729775181', '__ci_last_regenerate|i:1729774826;cart_items|a:0:{}language|s:10:\"portuguese\";custom_session_limit|i:1730638863;user_id|s:1:\"7\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:12:\"Andreia  Sá\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";'), ('7193e35eca1ddddefc2826eec3828851f14f7806', '66.249.79.8', '1729774845', '__ci_last_regenerate|i:1729774845;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('77e5ca0bcba6941bcf5e1a06569daefdaca7701a', '66.249.79.7', '1729774845', '__ci_last_regenerate|i:1729774845;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f155e67cef088291754aee094c2aa13420322854', '66.249.79.7', '1729774854', '__ci_last_regenerate|i:1729774854;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('67b277a72a3fbca19e410c1a92e9edcaff810787', '66.249.79.7', '1729774855', '__ci_last_regenerate|i:1729774855;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d80e7fd80aba1d286e6b0b672047aad04053e507', '66.249.79.8', '1729774942', '__ci_last_regenerate|i:1729774942;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('57ce31b9a66f115ee3349a50ab1d0f1ddede1bf0', '66.249.79.7', '1729774942', '__ci_last_regenerate|i:1729774942;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('795258967122dfba8310ed5c4701b147694521f5', '66.249.79.8', '1729775084', '__ci_last_regenerate|i:1729775084;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8acb8638e181fd1645276240ee801b3391131c05', '66.249.79.8', '1729775421', '__ci_last_regenerate|i:1729775421;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('98d7d7bc77d9107b0dc3eaf1ae6da0e6264f64c8', '66.249.79.7', '1729775473', '__ci_last_regenerate|i:1729775473;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('963cc848b9355201a7de9cb3bcad5c5d68e29a53', '66.249.79.8', '1729775575', '__ci_last_regenerate|i:1729775575;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0f6800e702a94d4ac0c7387df2dbe0481eec3403', '66.249.79.7', '1729775758', '__ci_last_regenerate|i:1729775758;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cf201462fd77d113a191ebb06154d0711102a8e3', '66.249.79.1', '1729775994', '__ci_last_regenerate|i:1729775994;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e902f6df276093267358946e776b9e08136d7d65', '66.249.79.7', '1729776081', '__ci_last_regenerate|i:1729776081;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4fbcc38312ff6d0b3307c581913b5aeb2cbd3fc0', '185.191.171.11', '1729776166', '__ci_last_regenerate|i:1729776166;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8ff6461749defb784e098d7d0d1f863d6ee99150', '85.208.96.210', '1729776166', '__ci_last_regenerate|i:1729776166;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('019a2d612d71523c3def029bddd05583ab1243e2', '66.249.79.1', '1729776175', '__ci_last_regenerate|i:1729776175;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cb8dcf0eca5bf21024a37c7eb530b3ef93af664d', '66.249.79.7', '1729776265', '__ci_last_regenerate|i:1729776265;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('78e3d9dad98ad3966ceca0ede907fa853679f5e8', '66.249.79.1', '1729777147', '__ci_last_regenerate|i:1729777147;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('40ee62e227ec75a4cc438eec79221bb9f2634ab8', '66.249.79.8', '1729777148', '__ci_last_regenerate|i:1729777148;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('e67438fba8acce70a42c6860261239231670b0f9', '66.249.79.1', '1729777284', '__ci_last_regenerate|i:1729777284;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e1d5e4975e1649967fce715cc4830cdec89740dd', '66.249.79.7', '1729777335', '__ci_last_regenerate|i:1729777335;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9c5f771a824ab6c13f7bcda98ea6f23540639fa8', '51.222.253.15', '1729777600', '__ci_last_regenerate|i:1729777600;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('59307ca57bea36521062870235f2ddcded9b81e8', '51.222.253.11', '1729777602', '__ci_last_regenerate|i:1729777602;cart_items|a:0:{}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:0;'), ('dd05f0a25f628a6d0e2b0ed781aff239e43a3de7', '66.249.79.7', '1729777605', '__ci_last_regenerate|i:1729777605;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('782d790d41364598bf4e6b48f7c9d18f7029c1ad', '66.249.79.7', '1729778538', '__ci_last_regenerate|i:1729778538;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b97c3a3d408d782b6cc1ce46095e267906a2f0e2', '66.249.79.1', '1729778961', '__ci_last_regenerate|i:1729778961;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('82da75f2119e230e9fb5b10fbccaaa659f7bfcec', '66.249.79.1', '1729778961', '__ci_last_regenerate|i:1729778961;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8402bd13d5cbb192dd68bd8938425dede0387331', '185.191.171.14', '1729778989', '__ci_last_regenerate|i:1729778989;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ea638ec74c413b17bbe04552590c78c9f9fa5027', '66.249.79.7', '1729779131', '__ci_last_regenerate|i:1729779131;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('39b6689133798ffcb39d2f831d4006e2a1074c80', '66.249.79.8', '1729779131', '__ci_last_regenerate|i:1729779131;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('542628688cecae52d1a5336aa13700ef12eaea2a', '66.249.79.8', '1729779144', '__ci_last_regenerate|i:1729779144;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c08f1cdfa874b41bc4698bd169ab325e2401a9e5', '185.191.171.16', '1729779300', '__ci_last_regenerate|i:1729779300;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('85b57fde5c51283d61456eeac2892e68a0d832a8', '157.245.105.107', '1729779701', '__ci_last_regenerate|i:1729779701;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9cd7f4a304eb6401fb1f01abff4d49d4bfd67c74', '157.245.105.107', '1729779706', '__ci_last_regenerate|i:1729779706;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('00e7a56893d6cb1cf73c2c57012419d68d881afe', '157.245.105.107', '1729779707', '__ci_last_regenerate|i:1729779707;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('89aaeb3713bc539cb2d5b5fa032fdd0b82f367d0', '157.245.105.107', '1729779708', '__ci_last_regenerate|i:1729779708;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f5c852ef881424f3320285dc6b2be914384c5f14', '157.245.105.107', '1729779709', '__ci_last_regenerate|i:1729779709;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('730b50645554b15f7971747aece680cff1a033da', '157.245.105.107', '1729779710', '__ci_last_regenerate|i:1729779710;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9ce49353429b59f8d4915f39b280ba7233f67c13', '157.245.105.107', '1729779711', '__ci_last_regenerate|i:1729779711;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('11555cac84de7dd9c6f6efe033156e7cd142f71f', '157.245.105.107', '1729779711', '__ci_last_regenerate|i:1729779711;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('488d63851658ba2f20b184b77d2cbf50fbb2c4df', '157.245.105.107', '1729779712', '__ci_last_regenerate|i:1729779712;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('14f6c9e7a873134a437cca5c5595fa7bf6821e97', '157.245.105.107', '1729779713', '__ci_last_regenerate|i:1729779713;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('346ed66ca12fa269b92a78fce3e239a3e7483ad8', '157.245.105.107', '1729779714', '__ci_last_regenerate|i:1729779714;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dd132049977adf9fa1bf7b7ab03949a312d19730', '157.245.105.107', '1729779715', '__ci_last_regenerate|i:1729779715;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d5344dc45cd24532f8caeda7c9552bfc2026dee0', '157.245.105.107', '1729779718', '__ci_last_regenerate|i:1729779718;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2654b41c1e80da8a63844aae270344d8828e6d71', '157.245.105.107', '1729779719', '__ci_last_regenerate|i:1729779719;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2b97d9963723ec33d153fe5cf097405173284721', '157.245.105.107', '1729779720', '__ci_last_regenerate|i:1729779720;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d602f010ff26cf980a08cba168863a253ae58a2c', '157.245.105.107', '1729779721', '__ci_last_regenerate|i:1729779721;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6259eba1fc55acda824d8f0806e037fa0bf865fc', '157.245.105.107', '1729779721', '__ci_last_regenerate|i:1729779721;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d3776864b86735cd22780b3fd786a4e4f41f22b0', '157.245.105.107', '1729779723', '__ci_last_regenerate|i:1729779723;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c2b3775bb949a58d1845368883ffd01733c91b54', '157.245.105.107', '1729779724', '__ci_last_regenerate|i:1729779724;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('207a7a1510ac43bd2ab148957618977db2f72472', '157.245.105.107', '1729779724', '__ci_last_regenerate|i:1729779724;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4d05765ab887bc87dfe2d25bb9b29eb96193109d', '157.245.105.107', '1729779725', '__ci_last_regenerate|i:1729779725;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('faaf3f54e1ea04446261edc8f371f6d9083a04a1', '157.245.105.107', '1729779727', '__ci_last_regenerate|i:1729779727;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8af691b2d5d0ef789eafaf188d4ca3078795889e', '157.245.105.107', '1729779728', '__ci_last_regenerate|i:1729779728;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('082c3efe723660858986ed7234eda81b3c1e9c24', '157.245.105.107', '1729779728', '__ci_last_regenerate|i:1729779728;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cbd9ca60a1bd689e1506c965fd9736d979a8dd59', '66.249.79.8', '1729780447', '__ci_last_regenerate|i:1729780447;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('162a8f02c586782dca067563bac1108081ce9348', '66.249.79.7', '1729780626', '__ci_last_regenerate|i:1729780626;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f2917f9583793567f47d7e4cbd38ad44bbbbeaf8', '66.249.79.8', '1729780687', '__ci_last_regenerate|i:1729780687;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bbc512e2d5b01f98566c06a82bab93c678fa95d6', '66.249.79.7', '1729780821', '__ci_last_regenerate|i:1729780821;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d8c4c1abd14d92ce7aecd062658e3b1decc87eac', '66.249.79.8', '1729780975', '__ci_last_regenerate|i:1729780975;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:40;'), ('b6e17d79ad322d2e99f87f6bcac10d6ecd68a34a', '66.249.79.1', '1729781485', '__ci_last_regenerate|i:1729781485;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('67cc3ea1444deab0ea61148fb370fcb96a78634a', '66.249.79.8', '1729781527', '__ci_last_regenerate|i:1729781527;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8f40b639eeadd1031551070a29b81d8e06437b4c', '51.222.253.11', '1729782315', '__ci_last_regenerate|i:1729782315;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f7d8e5e9501dd5dea2f9949c12928c6f36c7dec9', '66.249.79.8', '1729782847', '__ci_last_regenerate|i:1729782847;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dfb5b348decd46e4a6f69ea931fc8d2a0c51f935', '66.249.79.1', '1729782847', '__ci_last_regenerate|i:1729782847;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bea0045fd4af2e818f4f335416f3d74676939f70', '66.249.79.7', '1729782851', '__ci_last_regenerate|i:1729782851;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('eaba1f484de0e1b42d7bb0efee0ed4e53432f6d4', '66.249.79.7', '1729782861', '__ci_last_regenerate|i:1729782861;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('75aa3aaa4d33fc1c289fc843f98283e865ee9ec7', '66.249.79.7', '1729782885', '__ci_last_regenerate|i:1729782885;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2feb49e50734261235f7e6fd06dc70848dde04cf', '66.249.79.7', '1729782895', '__ci_last_regenerate|i:1729782895;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('332201af95de7502501769c5e3b7906a724d4943', '66.249.79.7', '1729782982', '__ci_last_regenerate|i:1729782982;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('305c9473cd16af0ad730e8ebc9da14571b8a2dd4', '66.249.79.1', '1729782982', '__ci_last_regenerate|i:1729782982;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('24cb4cbf3f3c99f5efe51d72db700e0848f8fca7', '66.249.79.7', '1729783077', '__ci_last_regenerate|i:1729783077;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6e7114902b4844f98382a560a4bd28e19aaec942', '66.249.79.8', '1729783077', '__ci_last_regenerate|i:1729783077;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fbdd5884fbbcb284d6bb1bdeb3d4dd330f20886e', '66.249.79.7', '1729783125', '__ci_last_regenerate|i:1729783125;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('663bd76f70c44d2b35e634deb4aeb165daf71ac8', '185.191.171.11', '1729784015', '__ci_last_regenerate|i:1729784015;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4af7a5ec3a7fb167112e227dee2df0033d3eb8b4', '85.208.96.194', '1729784015', '__ci_last_regenerate|i:1729784015;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c83a5c580c2748fc8f282258ddf9d36f4c64ed09', '66.249.79.1', '1729784828', '__ci_last_regenerate|i:1729784828;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fad71aff0d1932d31221ce8275871e95e8db9517', '185.191.171.12', '1729784857', '__ci_last_regenerate|i:1729784857;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fc6bcc30ce442fc549ddc26cd71173038075c319', '66.249.79.8', '1729785852', '__ci_last_regenerate|i:1729785852;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0eeeffedb6c4b6d8720360920f46330056591473', '66.249.79.8', '1729785885', '__ci_last_regenerate|i:1729785885;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4c0f3f862f141ecee446ef14e46ece777843df63', '85.208.96.202', '1729788570', '__ci_last_regenerate|i:1729788570;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2a2dadd5742bfb73ac5e9af3030d07b74cbf6979', '185.191.171.14', '1729788571', '__ci_last_regenerate|i:1729788571;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bfc273cf236e191352052895649f04b78fa4a5f0', '66.249.79.7', '1729790109', '__ci_last_regenerate|i:1729790108;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1892a07a49a1f7402cf4d116073ae943ad9a5745', '66.249.79.1', '1729790109', '__ci_last_regenerate|i:1729790109;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5c1b0b219a01e07032c44f2a5ed81f1f2ac863a9', '66.249.79.8', '1729790240', '__ci_last_regenerate|i:1729790240;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b722990f67766db5a9bfa947be4ed399ee2b9a2a', '66.249.79.8', '1729790455', '__ci_last_regenerate|i:1729790455;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('44aa110107d1a25b7e6c62f240a6ab8666c8a2de', '51.222.253.10', '1729790514', '__ci_last_regenerate|i:1729790514;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('908b08f0d3f0010f97cbbb46159a9a145ead45de', '66.249.79.8', '1729790698', '__ci_last_regenerate|i:1729790698;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9dfde5bab6469cf941045980019047c14295ac1a', '66.249.79.7', '1729790721', '__ci_last_regenerate|i:1729790721;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ab2e1860d3d1a3138dfa5cec587dccc22592a6f6', '66.249.79.7', '1729790745', '__ci_last_regenerate|i:1729790745;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('66e8feaf6a6c0b4fbfc634f97e833eb60a92a132', '66.249.79.8', '1729790947', '__ci_last_regenerate|i:1729790947;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f3f6b20167168cfd4d072f6e4d87b3a73f380967', '66.249.66.21', '1729791011', '__ci_last_regenerate|i:1729791011;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4fb224115a7a747736c53a6549e2a1ad8d3a5720', '66.249.79.8', '1729791014', '__ci_last_regenerate|i:1729791014;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c663595f9d24405d39d81a3252ad6395c32abeec', '66.249.79.7', '1729791117', '__ci_last_regenerate|i:1729791117;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('48d127bffee6d3333b2a8f08c43108e196823730', '66.249.79.7', '1729791644', '__ci_last_regenerate|i:1729791644;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c73e8423a092185badd348a61fbe4e57d452607f', '66.249.79.7', '1729792146', '__ci_last_regenerate|i:1729792146;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4529ab646799afa88d78c698e8de1aff857202df', '66.249.79.8', '1729792195', '__ci_last_regenerate|i:1729792195;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('45e2deef99efa1c0e563458265da6e89d5862396', '66.249.79.8', '1729792195', '__ci_last_regenerate|i:1729792195;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('659ebcdad080e32dbc9d3ec1e7ddf367ee51026a', '66.249.79.1', '1729792281', '__ci_last_regenerate|i:1729792281;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('43187683070937bd8d09d9575b82636f91da25a2', '66.249.79.8', '1729793265', '__ci_last_regenerate|i:1729793265;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('40c4cccc26092fb3e252491a46ffbf6bffb5ad64', '66.249.79.1', '1729793278', '__ci_last_regenerate|i:1729793278;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6f12c895a300855ca3c36f5947cbfef958e1b572', '85.208.96.207', '1729793676', '__ci_last_regenerate|i:1729793676;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d9ce6131025e9c38fe697584c9a701fed3e26f65', '85.208.96.196', '1729793676', '__ci_last_regenerate|i:1729793676;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('161e464d854e3ea955a40ac111c24bdbc4699e3d', '66.249.79.7', '1729794558', '__ci_last_regenerate|i:1729794558;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6d72c394cf01e8f6fbe47578232c8725c9716045', '66.249.79.1', '1729794558', '__ci_last_regenerate|i:1729794558;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b5b9f001681c05e83e46f4aba01a2fa626b1a026', '66.249.79.8', '1729794585', '__ci_last_regenerate|i:1729794585;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('743785598c947c94081104987c1c60d90bb6bfef', '66.249.79.1', '1729794974', '__ci_last_regenerate|i:1729794974;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('8f63fa3660bdb19e6c11f054a702638bbdbc8df1', '66.249.79.8', '1729794975', '__ci_last_regenerate|i:1729794975;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c87d10a9a66e43285e14607367a10a313d949d15', '66.249.79.7', '1729795454', '__ci_last_regenerate|i:1729795454;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9c3828ba4a340a641fa484ec1a03090a99bee121', '66.249.79.7', '1729795616', '__ci_last_regenerate|i:1729795616;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a6778f761fc13e1b82b1e2d99a99a03e07446b3c', '66.249.79.1', '1729796385', '__ci_last_regenerate|i:1729796385;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('885a3accbfd9ed692b1c272efe852538c945f8f4', '66.249.79.1', '1729796625', '__ci_last_regenerate|i:1729796625;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d9d4339a3ed8c27bb190be63195a5aa667b13cbc', '66.249.79.1', '1729796653', '__ci_last_regenerate|i:1729796653;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:215;'), ('fc9b4b7177e80c8d4365cf9550dd7cc2af5cff8c', '66.249.79.8', '1729796832', '__ci_last_regenerate|i:1729796832;cart_items|a:1:{i:0;s:1:\"5\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:799;'), ('c099f6832ce6058e19870e4cac33f03b08fc542f', '66.249.79.7', '1729796946', '__ci_last_regenerate|i:1729796946;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('40d8d143d1997ef8699a5a3f482314ab3145783e', '66.249.79.7', '1729796996', '__ci_last_regenerate|i:1729796995;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d39dcd392cec343eeae7fc09bf66619778c7edf0', '66.249.79.8', '1729797126', '__ci_last_regenerate|i:1729797126;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('89893a4017ea712eb3839dcdbb03b1067fee8500', '66.249.79.8', '1729797547', '__ci_last_regenerate|i:1729797546;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ff381b5d71d8178b55d02e633126264dd77b69fe', '66.249.79.7', '1729797558', '__ci_last_regenerate|i:1729797558;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0a80fbfafb94dd6885d825f6ca191a2221a06177', '66.249.79.1', '1729797727', '__ci_last_regenerate|i:1729797727;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('be5e2cb67c9abd26da099fcacd4edd889ea05fa9', '185.191.171.12', '1729797850', '__ci_last_regenerate|i:1729797850;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7afa7eb048863824cc0df73fda5fe619c447b2b5', '85.208.96.200', '1729797850', '__ci_last_regenerate|i:1729797850;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a7855cf870034937610713290adbe609422394de', '66.249.79.8', '1729797981', '__ci_last_regenerate|i:1729797981;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('048d72414feba4d5cb4d29ac66f525f5aa745949', '66.249.79.1', '1729797985', '__ci_last_regenerate|i:1729797985;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('291a352e29e5b25fbdeac953633c5ff6c942e778', '66.249.79.1', '1729798185', '__ci_last_regenerate|i:1729798185;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4a3215fff8bca6aee5d5087f0d78a5d0e0e40d63', '66.249.79.8', '1729798185', '__ci_last_regenerate|i:1729798185;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e6bb4f8513260f2a29d6f1f07a60bc825822ceb1', '66.249.79.8', '1729798392', '__ci_last_regenerate|i:1729798392;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('906d719c56734b1db21f384f76e1575d6175c041', '66.249.79.7', '1729798392', '__ci_last_regenerate|i:1729798392;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9844a95cab62a83e7ebd987d1fd1cf1d3f159ed6', '66.249.79.1', '1729798463', '__ci_last_regenerate|i:1729798463;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('09b69131289cf88793b1ab458fb18c6e8241b7f8', '66.249.79.8', '1729798537', '__ci_last_regenerate|i:1729798537;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('694113cf41d2325dac8959c2a9d836626299acfb', '66.249.79.1', '1729798567', '__ci_last_regenerate|i:1729798567;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3e3bc7b7bde40d1ed989af31d67397c06a47168b', '51.222.253.16', '1729798896', '__ci_last_regenerate|i:1729798896;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('925c75c35812e17263f2e2f736e09a450af478d5', '51.222.253.20', '1729805252', '__ci_last_regenerate|i:1729805251;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('8bcea304e22ef0fd1d5065e649379453bca66291', '139.196.25.23', '1729808775', '__ci_last_regenerate|i:1729808775;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('87d43201a08b1d61b37ae6b97204b5a2b76a3639', '165.227.173.41', '1729811736', '__ci_last_regenerate|i:1729811736;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ec3d6a2d2336461d337f9e68b771d805a708bf58', '165.227.173.41', '1729811739', '__ci_last_regenerate|i:1729811739;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c5ee5b5d34a6a2dbccc69e1c661b6352baedc13f', '165.227.173.41', '1729811740', '__ci_last_regenerate|i:1729811740;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3adfc1ae6795bb3ff18fc4a8f57d1c7b697f7496', '165.227.173.41', '1729811741', '__ci_last_regenerate|i:1729811741;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a70dfee0b6c7b00dfd580eba4d73ad79385adfcd', '165.227.173.41', '1729811741', '__ci_last_regenerate|i:1729811741;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6f2f86500aa9dca1b594d8c5d0e1561e11de415d', '165.227.173.41', '1729811742', '__ci_last_regenerate|i:1729811742;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8faf68f30458a127eb2956c00a222e610ca82ae5', '165.227.173.41', '1729811742', '__ci_last_regenerate|i:1729811742;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2b8d85ac3c870e9fee29b7d5ceeea7b718eb2fe0', '165.227.173.41', '1729811742', '__ci_last_regenerate|i:1729811742;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3efc06a27b97c8efaecd3c0236fab17fdd7a07f5', '165.227.173.41', '1729811743', '__ci_last_regenerate|i:1729811743;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4726ab9002d43935f8c6b4cac6f5345296578a0f', '165.227.173.41', '1729811743', '__ci_last_regenerate|i:1729811743;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ace5d03e1abf25b57dbd623d7f3fe8532358117e', '165.227.173.41', '1729811744', '__ci_last_regenerate|i:1729811744;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5d702460354587d3be67bb910223ea1cf14fe79e', '165.227.173.41', '1729811745', '__ci_last_regenerate|i:1729811745;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0d0a7ee6b8cf4e9c5c8fddc644608bb7a5669d31', '165.227.173.41', '1729811747', '__ci_last_regenerate|i:1729811747;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('11b3fb63f28b523fbefa2ed119f0efdc1321e5cb', '165.227.173.41', '1729811747', '__ci_last_regenerate|i:1729811747;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9c020cc9a431fa6b0118fb08d0439c460991553b', '165.227.173.41', '1729811748', '__ci_last_regenerate|i:1729811748;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9819b4edb0cae769dbe86c978e4f5214a113b42b', '165.227.173.41', '1729811748', '__ci_last_regenerate|i:1729811748;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('278f7826c9516df5af09b39902d75c4d8ec5d5e1', '165.227.173.41', '1729811748', '__ci_last_regenerate|i:1729811748;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0a653db4fc4fbf58328de19527fb019becb26534', '165.227.173.41', '1729811749', '__ci_last_regenerate|i:1729811749;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('385ed5f78d021043fa44d9be8af1516b4f79f4bf', '165.227.173.41', '1729811750', '__ci_last_regenerate|i:1729811750;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ea307f0beb1741f19be423088b83b1441989498a', '165.227.173.41', '1729811750', '__ci_last_regenerate|i:1729811750;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('eaeb1df65096f65155f67736bc17742e1b3a61b1', '165.227.173.41', '1729811751', '__ci_last_regenerate|i:1729811751;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('51f28e2721c66bc1a0116df9e577ac298537ad50', '165.227.173.41', '1729811751', '__ci_last_regenerate|i:1729811751;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bd5fb77f1d1b39543fb7ba1ea78ba0013eb8d156', '165.227.173.41', '1729811752', '__ci_last_regenerate|i:1729811752;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a3b8f369911849f057b32a00163fd6894560307f', '165.227.173.41', '1729811752', '__ci_last_regenerate|i:1729811752;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c2ca2555cf181e8508805f98298606c152314bc2', '165.227.173.41', '1729811753', '__ci_last_regenerate|i:1729811753;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('84a78d302fee143ea77aaaa70457df737b47cd81', '165.227.173.41', '1729811754', '__ci_last_regenerate|i:1729811754;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('826daff138d811b0aa7c3f09f13420621a49db16', '165.227.173.41', '1729811754', '__ci_last_regenerate|i:1729811754;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('87b0458aa5e623f75db0f43a33b44ecaf3a5ecbc', '165.227.173.41', '1729811755', '__ci_last_regenerate|i:1729811755;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4ecd00c94a589c1373c248aaaa22021833712f5b', '165.227.173.41', '1729811756', '__ci_last_regenerate|i:1729811756;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6eae9613ac5c60a0a81559b5f7e3d1802a6559b0', '165.227.173.41', '1729811756', '__ci_last_regenerate|i:1729811756;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8ade30cb13d4b621a3c1dedb4867a894b5a49390', '165.227.173.41', '1729811757', '__ci_last_regenerate|i:1729811757;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ce9fc09415c3139d7dfd35a7489df882c7acd5d1', '51.222.253.7', '1729811762', '__ci_last_regenerate|i:1729811762;layout|s:4:\"list\";language|s:7:\"english\";'), ('f4a538a1036fa1feaa577b5174f8d1895fe4ce10', '93.159.230.84', '1729813025', '__ci_last_regenerate|i:1729813024;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7e65bb3f2d54e8fd94f241e6ff95e0c2a2cdbb1e', '51.222.253.2', '1729815229', '__ci_last_regenerate|i:1729815229;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('89f3e3c385f0eaa6640196183a871ddddd2d246e', '17.241.227.181', '1729817991', '__ci_last_regenerate|i:1729817991;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1b496971c0200123150869004f674b60575ea8dd', '17.241.227.181', '1729817991', '__ci_last_regenerate|i:1729817991;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('14c7cf3653d4584629878193deeda3f921fe4764', '66.249.79.1', '1729821402', '__ci_last_regenerate|i:1729821402;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('eac18387b8fd09409db58fc0b6ef993643111d47', '66.249.79.7', '1729821402', '__ci_last_regenerate|i:1729821402;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('85a985c6a81454a7f8962b57e5a9d13afeadca1d', '65.21.233.213', '1729821998', '__ci_last_regenerate|i:1729821998;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bc1b271cfe62d065cb6a9e8d87ac83fac8f512dd', '65.21.233.213', '1729822012', '__ci_last_regenerate|i:1729822012;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('8366e1bafe6c694c3f3f148627a1a9e9c5464930', '65.21.233.213', '1729822024', '__ci_last_regenerate|i:1729822024;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('b5b64ecb519b462ec3bc26aa71026e290ca91315', '65.21.233.213', '1729822032', '__ci_last_regenerate|i:1729822031;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('64364a750962e905fdf819b82731de3ce0447a0e', '65.21.233.213', '1729822046', '__ci_last_regenerate|i:1729822046;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('624285b9d598be96112fe2a20db1ee91713683d3', '65.21.233.213', '1729822060', '__ci_last_regenerate|i:1729822060;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('61b00c876896732fb3385dfe535d9511b912b05c', '54.36.148.173', '1729822227', '__ci_last_regenerate|i:1729822227;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8fe0f96c7f18d5af9cd073f41b0b57e7e0622e0a', '51.222.253.9', '1729829369', '__ci_last_regenerate|i:1729829369;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('3f92a5ddd26a9276ea19914b9e2626d8cb1f6065', '66.249.79.8', '1729834510', '__ci_last_regenerate|i:1729834510;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8905a81a6afbeb26bee5450a1d93cfc51102169e', '66.249.79.7', '1729834510', '__ci_last_regenerate|i:1729834510;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('74f0686b2bdcb8f7b66cea12128be40b70c08f96', '66.249.79.8', '1729834517', '__ci_last_regenerate|i:1729834517;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('20b0d5d6f913fbe290a22989564749764b975661', '66.249.79.8', '1729834518', '__ci_last_regenerate|i:1729834518;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('15426417ad5d916c0f89df33eec30c91173f8541', '51.222.253.5', '1729835564', '__ci_last_regenerate|i:1729835563;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fb05c08a9de47037f6d0b801aa897ae66523978d', '94.23.203.86', '1729836726', '__ci_last_regenerate|i:1729836725;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('aaf8381ffada28252c70e8dd7428464aeca1891d', '94.23.203.86', '1729836735', '__ci_last_regenerate|i:1729836735;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('812fa1bdb7210b9db37eadbe1524fc0e3f924797', '51.222.253.19', '1729838492', '__ci_last_regenerate|i:1729838491;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f21ca7ed487b0139b2f307a8caf4269860a8f6d5', '66.249.79.7', '1729841844', '__ci_last_regenerate|i:1729841844;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5aa53ab1f52443edbaa5c0fb4b8fac4bbc575aa7', '66.249.79.8', '1729841845', '__ci_last_regenerate|i:1729841845;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4b7d849bcc12912913a3963c13a0a3d65e41e0f4', '66.249.79.8', '1729842317', '__ci_last_regenerate|i:1729842317;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('2b04d5f561fa428e1032ac2b4d1a32c31bdd8caa', '66.249.79.1', '1729845110', '__ci_last_regenerate|i:1729845110;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3e3cc151ecb1b66ecae349478002e110227578a4', '66.249.79.7', '1729845316', '__ci_last_regenerate|i:1729845316;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('cb3d8c8560c299dca82737d3e66c004f9b8a5109', '51.222.253.20', '1729845601', '__ci_last_regenerate|i:1729845601;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('acc1d3af6a0dd6ccc3d7aacf7ef3c29fa6e7a78e', '66.249.79.1', '1729848676', '__ci_last_regenerate|i:1729848676;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a0a0dbeaa427e6dd37bc1ef116bf2ded7ba48580', '66.249.79.8', '1729857748', '__ci_last_regenerate|i:1729857748;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ad0b56e97bc2f835477cf38f2b3bb3735b78f353', '66.249.79.7', '1729857748', '__ci_last_regenerate|i:1729857748;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2bd30ffd64860c39931470d220a4f3311dde46ae', '51.222.253.19', '1729864960', '__ci_last_regenerate|i:1729864960;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('27086debe1e45bfefa9af681fa7070cef0d92f16', '81.167.26.57', '1729866440', '__ci_last_regenerate|i:1729866440;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5355cf1d2d041aa59de5ac1c17df27574f7b6a21', '81.167.26.57', '1729866442', '__ci_last_regenerate|i:1729866442;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5bab514f98fa81b70111ea0a8badae5bd67c32e3', '81.167.26.57', '1729866444', '__ci_last_regenerate|i:1729866444;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ad5c34deda50e88f6acaf28fdc629fac91eda2ab', '81.167.26.57', '1729866446', '__ci_last_regenerate|i:1729866445;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4579ff154e91f92412600debe0c757a4bda9dd00', '81.167.26.57', '1729866447', '__ci_last_regenerate|i:1729866447;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e9b37f2cb1c07509c2015a1a1697757ba0c0f88c', '40.77.167.184', '1729867268', '__ci_last_regenerate|i:1729867268;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ea4432817254a672b4cf009b6a1286e4c6da0198', '157.55.39.54', '1729867276', '__ci_last_regenerate|i:1729867276;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0cc42c228c557455e574a4e96349577c99c0dbe5', '216.244.66.227', '1729870091', '__ci_last_regenerate|i:1729870091;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7cb2222f273e6d3bef408cddf8ea52c22003106b', '157.55.39.14', '1729870479', '__ci_last_regenerate|i:1729870479;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('76726680febe366940aaa197acf00df32089fdc1', '216.244.66.227', '1729871162', '__ci_last_regenerate|i:1729871162;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2d71cfb436e8c5e89ac83d4eff08de25c795de86', '66.249.77.140', '1729873517', '__ci_last_regenerate|i:1729873517;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('faa6a1846d2a8ab9a1e6470061f6f73ee29d7b01', '66.249.77.142', '1729873517', '__ci_last_regenerate|i:1729873517;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('aec86ad9e0a63d54a5d0b61e7500e0862ea8fefd', '51.222.253.12', '1729879685', '__ci_last_regenerate|i:1729879685;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('111d31887701ece0345f888cc86de3068873455f', '84.23.205.122', '1730370042', '__ci_last_regenerate|i:1729881204;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('af13043838f28566773966b514810c696a2a02a1', '66.249.77.142', '1729882453', '__ci_last_regenerate|i:1729882453;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e5469367324e387ef20f2a44d4c1c5cef0b7d24a', '51.222.253.4', '1729888686', '__ci_last_regenerate|i:1729888686;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bf79e299e1939130c35e2ae90ce13eb89ddf283e', '87.250.224.16', '1729889100', '__ci_last_regenerate|i:1729889099;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('22a051a958b5e880205772a7e677242916d8d5ab', '213.180.203.19', '1729889101', '__ci_last_regenerate|i:1729889101;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d7d24494a8a0940f1a10419700c374e49885c7c2', '54.203.138.147', '1729889111', '__ci_last_regenerate|i:1729889106;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dc77cd7bfe74cf3f4d3aff8384a3463b5ddb1e08', '188.19.25.78', '1729889114', '__ci_last_regenerate|i:1729889110;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9dddbd6629aa030e886b5e4fb2e75ffbda4723cc', '66.249.77.141', '1729889881', '__ci_last_regenerate|i:1729889881;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0fa6196c0444417d292e3edf878f07947ebd8057', '66.249.77.142', '1729889882', '__ci_last_regenerate|i:1729889882;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5d743a48a98a8280e4cff3f44fbf374d9057fe76', '66.249.77.141', '1729891094', '__ci_last_regenerate|i:1729891094;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('be6f1352cfd856de25d97afbc00cb39fbc816f32', '66.249.77.142', '1729891486', '__ci_last_regenerate|i:1729891486;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('50cb52b30856baecc81862f81f60543729df515e', '66.249.77.141', '1729891523', '__ci_last_regenerate|i:1729891523;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6a72e481c58a174a02d7899b1d8a854b96061e32', '66.249.77.140', '1729891808', '__ci_last_regenerate|i:1729891808;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('09eabc03e9d1f3335c4496f826594e55cf2343f3', '66.249.77.140', '1729891936', '__ci_last_regenerate|i:1729891936;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b5dd4c944c7dc14ea0aeae6a02900f67098edba8', '66.249.77.141', '1729891966', '__ci_last_regenerate|i:1729891966;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c16e020ab5fbbeae31e7a6ef0f5f573d02031f8c', '66.249.77.140', '1729892219', '__ci_last_regenerate|i:1729892219;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('65ddc7c27df41c6a375f920a58d46b499087f7e5', '66.249.77.142', '1729892294', '__ci_last_regenerate|i:1729892293;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6558cc1e0a05744a881a88ca0176f73e63698485', '66.249.77.141', '1729892888', '__ci_last_regenerate|i:1729892888;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('53ad8ee68d75f1aed95740ee6ce1a3a8e44adb8c', '66.249.77.141', '1729893365', '__ci_last_regenerate|i:1729893365;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5d80fef1e43a43a543fafb58cd8323872c652b2a', '66.249.77.141', '1729893374', '__ci_last_regenerate|i:1729893374;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b73a74572bff2fc20af0873079cb6c2deb48811d', '66.249.77.142', '1729893670', '__ci_last_regenerate|i:1729893669;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('58d14be9210a8f3931bc52421e62ff5fbac69ef8', '66.249.77.141', '1729893669', '__ci_last_regenerate|i:1729893669;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b91d5c7da392e3decafe766aed0e9537234be87b', '66.249.77.141', '1729893682', '__ci_last_regenerate|i:1729893682;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c5cde0b4fa15ff4c242a17587627ca7a02b2d33e', '66.249.77.141', '1729893686', '__ci_last_regenerate|i:1729893686;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('b687cb872fdfc8700ef54bf5ab7b0e9b3372182a', '66.249.77.142', '1729894978', '__ci_last_regenerate|i:1729894978;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('86503d6863415cef6a0462e76f30a077bbdc337f', '66.249.77.142', '1729894996', '__ci_last_regenerate|i:1729894996;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e151990741744046f593bc7ad0bd2dd1370e536f', '66.249.77.140', '1729895000', '__ci_last_regenerate|i:1729895000;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('22fcf89872518767d3bf37be115799b540e545e9', '51.222.253.19', '1729897504', '__ci_last_regenerate|i:1729897504;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:65:\"https://cursos.curaquantica13.com/home/course/teste-de-edição/7\";'), ('d80df190ae3eb3f1b4d8a9300968c1da209fa21e', '45.148.10.59', '1729897536', '__ci_last_regenerate|i:1729897536;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b0eda6c10bbbcde79243fa8192c50a4fc0b74332', '45.148.10.59', '1729897538', '__ci_last_regenerate|i:1729897538;'), ('bb1a4b09f2fd24b1630fedd1d4c9bced0d2b82b8', '45.148.10.59', '1729897539', '__ci_last_regenerate|i:1729897539;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b0b9821442853ec6464af8ae77dbaa0a5e11c3b7', '199.45.155.77', '1729897755', '__ci_last_regenerate|i:1729897755;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('91dd698bffbcc850119a1f07ad5cc8b292585e5e', '199.45.155.77', '1729897762', '__ci_last_regenerate|i:1729897762;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d4c34bc7f230ec4fa0f0d08389f3a05129a14845', '178.63.11.34', '1729898969', '__ci_last_regenerate|i:1729898969;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7ac3355c51d6a55e5e5f3e642b6d2142e700b397', '178.63.11.34', '1729898990', '__ci_last_regenerate|i:1729898990;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9ebd89aecab2d9424a181bd79d15895ca96f59de', '178.63.11.34', '1729899007', '__ci_last_regenerate|i:1729899006;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('5311eb0b54ad594d262e440b98bd55705602d98f', '178.63.11.34', '1729899010', '__ci_last_regenerate|i:1729899010;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('c440c976f188c0328d169a5d0ab70d9c4a90fe76', '178.63.11.34', '1729899015', '__ci_last_regenerate|i:1729899015;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('088eacc9f36e1dd813764380609d0175423f4cd6', '178.63.11.34', '1729899016', '__ci_last_regenerate|i:1729899016;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('668d325c6b53c0997148718004f5c2026e328f80', '178.63.11.34', '1729899021', '__ci_last_regenerate|i:1729899021;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('3aea23e0b0d3f58985eefdbe0cd27ca416251385', '178.63.11.34', '1729899023', '__ci_last_regenerate|i:1729899023;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('0bce4f2ed05f2c6292bc21500204a0e86f99d3bc', '178.63.11.34', '1729899024', '__ci_last_regenerate|i:1729899024;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('326a680a996375ee153054587bb84607100f9a32', '178.63.11.34', '1729899026', '__ci_last_regenerate|i:1729899026;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('ab0df98bbc39ad6d5a33fcca6b89ca3d092fd02d', '178.63.11.34', '1729899029', '__ci_last_regenerate|i:1729899029;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('252920d3885f1b537af1a905ca3a7fbcd729f26c', '178.63.11.34', '1729899033', '__ci_last_regenerate|i:1729899033;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('a7236f385b495be2d7a960349cdd5bb6fa6f22c6', '178.63.11.34', '1729899038', '__ci_last_regenerate|i:1729899038;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('92edce5e31132e255ff9123cb7304bade3caf6d1', '178.63.11.34', '1729899039', '__ci_last_regenerate|i:1729899039;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('8d926ab8a2488a296b623d3b92107be0de7e1c22', '178.63.11.34', '1729899041', '__ci_last_regenerate|i:1729899041;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('060582ffc90f09601cf5af9693def013ca8f62d7', '178.63.11.34', '1729899043', '__ci_last_regenerate|i:1729899043;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('c801ee19d107b17fc02931410b5376c7aef8b9fe', '178.63.11.34', '1729899045', '__ci_last_regenerate|i:1729899045;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('1bd0101f543dbe1fc4a7e54d5ef269b6a0da0e6b', '178.63.11.34', '1729899048', '__ci_last_regenerate|i:1729899048;language|s:7:\"english\";'), ('68efbd25514517d1b733b8ed2f7d87dea876e797', '178.63.11.34', '1729899049', '__ci_last_regenerate|i:1729899049;language|s:7:\"english\";'), ('839277e4c381e4cacf9defa2272446c2904adbd3', '178.63.11.34', '1729899053', '__ci_last_regenerate|i:1729899053;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a53ae859548b93f9ef74108c99f9c2d1b8bc162d', '178.63.11.34', '1729899057', '__ci_last_regenerate|i:1729899057;language|s:7:\"english\";'), ('db42bf1cb06302e2a5681b8994946e4d3c8fe10d', '178.63.11.34', '1729899057', '__ci_last_regenerate|i:1729899057;language|s:7:\"english\";'), ('c0fbba6b085675964fa9459fa23697f726cf5ebb', '178.63.11.34', '1729899060', '__ci_last_regenerate|i:1729899060;cart_items|a:0:{}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:0;'), ('6930c587d74139519463e4ad2dd9c423aa110b73', '178.63.11.34', '1729899062', '__ci_last_regenerate|i:1729899062;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('013e3b02fa0965f349ba816f4da5f9ac3424090d', '178.63.11.34', '1729899065', '__ci_last_regenerate|i:1729899065;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('43625d798d7a27eda98b98c3c622509502a31503', '178.63.11.34', '1729899067', '__ci_last_regenerate|i:1729899067;layout|s:4:\"list\";language|s:7:\"english\";'), ('11fb82204fd1b4eb181558888ced84c1b3d52735', '178.63.11.34', '1729899068', '__ci_last_regenerate|i:1729899068;layout|s:4:\"list\";language|s:7:\"english\";'), ('f5a1aeacc46677cf313aded28d692111195b33cc', '178.63.11.34', '1729899071', '__ci_last_regenerate|i:1729899071;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3df1f07e2ecb96defae6066591b7689c86b07e95', '178.63.11.34', '1729899073', '__ci_last_regenerate|i:1729899073;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('e859f2ebedc9b9352b220e5c428d5f8bcd4033b6', '178.63.11.34', '1729899077', '__ci_last_regenerate|i:1729899077;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('df0c3f5a9cea13e377154bb0710492cb24536dad', '178.63.11.34', '1729899081', '__ci_last_regenerate|i:1729899081;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bd73763e37c1ff6e7548fb14ed3ad7d81b36dca0', '178.63.11.34', '1729899084', '__ci_last_regenerate|i:1729899084;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9bd79ef197d21ad6d101a9fdb487f72ce9d7bc56', '178.63.11.34', '1729899087', '__ci_last_regenerate|i:1729899087;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('49308cd0e5d27b842aeb35c3bbd1fb4656288920', '178.63.11.34', '1729899090', '__ci_last_regenerate|i:1729899090;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('054dffd2a373a06734213a63835f4b8bf2ff2bcd', '178.63.11.34', '1729899093', '__ci_last_regenerate|i:1729899093;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fc0015bd09da5b716b2835fd3a8faab430394226', '178.63.11.34', '1729899095', '__ci_last_regenerate|i:1729899095;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('63ccd24a3ee44b4a9670984b0981857b733ba956', '178.63.11.34', '1729899098', '__ci_last_regenerate|i:1729899097;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cc4992d9c747ab8130c2464728531ece3f6968fe', '178.63.11.34', '1729899100', '__ci_last_regenerate|i:1729899100;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f3cb1e2772f37abc431e6be3676db2a84c4e742e', '178.63.11.34', '1729899105', '__ci_last_regenerate|i:1729899105;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9a5cc4dd7656f984653df08bedbc367392319b99', '178.63.11.34', '1729899108', '__ci_last_regenerate|i:1729899108;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('49f347fcad1c674b60162522e7609dd2b1078405', '178.63.11.34', '1729899112', '__ci_last_regenerate|i:1729899112;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c7236519be5db256e946e1afd41710319b59bc52', '178.63.11.34', '1729899115', '__ci_last_regenerate|i:1729899115;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ab80e7e5d2cf4136f45729e753029cb908dd16ea', '178.63.11.34', '1729899119', '__ci_last_regenerate|i:1729899119;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9545fe7c7eff8baebe1f9d8d40a6719fba294dbf', '178.63.11.34', '1729899124', '__ci_last_regenerate|i:1729899124;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1987601c2f46b6e1a5a737629a00b3e6769d3272', '178.63.11.34', '1729899129', '__ci_last_regenerate|i:1729899128;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('702ea423624e4619fa5c140035fbb227b4d484e9', '178.63.11.34', '1729899129', '__ci_last_regenerate|i:1729899129;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c4d1d4f467a800142eed27bcf62dcc6efb1c1fd7', '178.63.11.34', '1729899131', '__ci_last_regenerate|i:1729899131;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('46d494d8c9f42da28617e1f47cb6adbf5cc13331', '178.63.11.34', '1729899134', '__ci_last_regenerate|i:1729899134;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('59239fd6b43bbacc85167955c0ba8fe68fce50cb', '178.63.11.34', '1729899137', '__ci_last_regenerate|i:1729899137;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f466e8711c21d00b024d9ccafcef71c953b8657f', '178.63.11.34', '1729899141', '__ci_last_regenerate|i:1729899141;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('083e641c138d5a8ae7c5e1ea367ea58829d1e852', '178.63.11.34', '1729899142', '__ci_last_regenerate|i:1729899142;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('840ffeb48a9b13fc5def33c88b5bffb20d758e5a', '178.63.11.34', '1729899145', '__ci_last_regenerate|i:1729899145;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('84de74f21f3668d6f49be41b152e0ae758f62295', '178.63.11.34', '1729899149', '__ci_last_regenerate|i:1729899149;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('73d129e6e7b8b835815f5e98e59ca66dd317ef5d', '178.63.11.34', '1729899149', '__ci_last_regenerate|i:1729899149;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('11dcc8e10e958eda415b054d2332053c0b521d90', '178.63.11.34', '1729899153', '__ci_last_regenerate|i:1729899153;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e4528345efbbd08e5adb0c438bcaa412930327cc', '178.63.11.34', '1729899155', '__ci_last_regenerate|i:1729899155;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ab5cc77f083d60ae4f3dfe204342aba383597aea', '178.63.11.34', '1729899156', '__ci_last_regenerate|i:1729899156;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1a0388f4420e475fd59b26aaf8e2b0777bc4e4d8', '178.63.11.34', '1729899159', '__ci_last_regenerate|i:1729899158;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a263d68da97c5c2ae1a2f13eed6b02b863b26c84', '178.63.11.34', '1729899161', '__ci_last_regenerate|i:1729899161;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0d97e4eb4c4e09ddab39daa69fe1c80d58ba1729', '178.63.11.34', '1729899162', '__ci_last_regenerate|i:1729899162;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2253ca88cd3bf926643ead08ff08783c6ded0023', '178.63.11.34', '1729899163', '__ci_last_regenerate|i:1729899163;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('46f0dce594178e9dbfb402560150c8c90622e3a7', '178.63.11.34', '1729899165', '__ci_last_regenerate|i:1729899165;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0833b79bc66d09dac6c1d15fdd16bc0b112185bf', '178.63.11.34', '1729899166', '__ci_last_regenerate|i:1729899166;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('19a47883afd8fa3033d9b608814b1d79f960b917', '178.63.11.34', '1729899169', '__ci_last_regenerate|i:1729899169;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7b84b824647bd05a8e90cde851f057b88c2a9f37', '178.63.11.34', '1729899173', '__ci_last_regenerate|i:1729899173;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e0ceaf9741ae3f8bf751ce0850441978d319ced0', '178.63.11.34', '1729899174', '__ci_last_regenerate|i:1729899174;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4e21214c811811df9554c6daf67e9b7d01c7e794', '178.63.11.34', '1729899177', '__ci_last_regenerate|i:1729899177;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f396db83bd1f6a43bb69c93077f94d7c19b6a0ad', '178.63.11.34', '1729899178', '__ci_last_regenerate|i:1729899177;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('20a66f9ea24b4f121ff45147638d96d8385966b8', '178.63.11.34', '1729899184', '__ci_last_regenerate|i:1729899184;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dbc3802b864139f19e4013a3a52655fef524400a', '178.63.11.34', '1729899186', '__ci_last_regenerate|i:1729899186;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('28236ffe97ea26d4056c44650fa74cd3416ad857', '178.63.11.34', '1729899187', '__ci_last_regenerate|i:1729899187;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6a49f735cf0f726c74612795258ab782653da40c', '178.63.11.34', '1729899188', '__ci_last_regenerate|i:1729899188;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b3f30d86b31079a5a5a5ea1b92b359335381ead1', '178.63.11.34', '1729899192', '__ci_last_regenerate|i:1729899192;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:65:\"https://cursos.curaquantica13.com/home/course/teste-de-edição/7\";'), ('b18765b182890874699453aa978da185931d7bd5', '178.63.11.34', '1729899198', '__ci_last_regenerate|i:1729899198;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fd0edfc5e01959016e944eadfcdcdf9aad6ccaec', '51.222.253.1', '1729899656', '__ci_last_regenerate|i:1729899655;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e8ca53875f18cf764a476abc80bbaaf44b2d968a', '66.249.79.7', '1729900385', '__ci_last_regenerate|i:1729900385;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('366de3319681978fdbe709045e4fcc6e298b4a33', '167.94.146.63', '1729900707', '__ci_last_regenerate|i:1729900706;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7cf0bbca312a1672f7213a3df2fe9da4bae96e43', '167.94.146.63', '1729900711', '__ci_last_regenerate|i:1729900711;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9b7dab33f7958e4dc84e6b47fdbb1ed4e12b0e61', '51.222.253.10', '1729901759', '__ci_last_regenerate|i:1729901759;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a245a763d2bb8d2bdf47782797d8ebdc84655d28', '51.222.253.3', '1729903268', '__ci_last_regenerate|i:1729903268;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('209c1ed821c299b82a7c0352c7e80ec395069eef', '51.222.253.9', '1729905055', '__ci_last_regenerate|i:1729905055;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('200572f62781a5f01f1202f2873c84677e6913df', '66.249.77.142', '1729908605', '__ci_last_regenerate|i:1729908605;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c1606872ac543a4a085e8c2b19bac0e5350e5dfe', '66.249.77.141', '1729908724', '__ci_last_regenerate|i:1729908724;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8b47ffd9f4db9104f9ea1e9cb9408a22a1e550d1', '66.249.77.140', '1729909497', '__ci_last_regenerate|i:1729909497;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9336d7646bb10eb9df67ed6d01d160a8d545cd10', '66.249.77.140', '1729909529', '__ci_last_regenerate|i:1729909529;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cb51a4f6764240479eb234c7567917a9f79101b4', '66.249.77.140', '1729909530', '__ci_last_regenerate|i:1729909530;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('be4523d49168940973ea8734ec0035ccefd8e393', '66.249.77.142', '1729909636', '__ci_last_regenerate|i:1729909636;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b0648b53fe1853138c1d26a6ae85434946f9a138', '66.249.77.140', '1729910824', '__ci_last_regenerate|i:1729910824;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f9fa61db00854375fb1d6980a54cf370d70c8849', '66.249.77.140', '1729911188', '__ci_last_regenerate|i:1729911188;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a731010d5c92b9ae23fc928268942f899fe7be01', '66.249.77.140', '1729911479', '__ci_last_regenerate|i:1729911479;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3b5d7f6cc0030dcae096403c2e1a8f4a1a78468d', '66.249.77.141', '1729911899', '__ci_last_regenerate|i:1729911899;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('38ae43465d9dbf015535d64037841159d100f7f7', '66.249.77.140', '1729911922', '__ci_last_regenerate|i:1729911922;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:40;'), ('57a7b5d2cc536b69c6dba6d23f4c42938b86e15a', '66.249.77.142', '1729912450', '__ci_last_regenerate|i:1729912450;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f6e237345ce7a6c021a4b87e598ca621325b4f48', '66.249.77.142', '1729912450', '__ci_last_regenerate|i:1729912450;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1d45ab0556bf591ef9240bd2f176ebf940cfc282', '51.222.253.19', '1729914201', '__ci_last_regenerate|i:1729914201;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('26d632bfcc5213f0663c03e158e6e2b95dce4034', '66.249.77.140', '1729916584', '__ci_last_regenerate|i:1729916584;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fa4b70b73d90aedab0ad80e9c130da620fba9356', '66.249.77.141', '1729916584', '__ci_last_regenerate|i:1729916584;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a49ef0cb1cdfd48d4949f4932b1ee4bb7dbec23e', '66.249.77.141', '1729916725', '__ci_last_regenerate|i:1729916725;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('02f13ab0777dd2a6930d6f94fcfe45dbd4c080ee', '66.249.77.141', '1729916725', '__ci_last_regenerate|i:1729916725;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ac5f34807928bd6d964c41e71dc7e7d993d75038', '66.249.77.140', '1729916818', '__ci_last_regenerate|i:1729916818;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0f4d835b94409a0b4406a0c0d64f925538a09ced', '66.249.77.141', '1729916818', '__ci_last_regenerate|i:1729916818;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('efa40bd4237416f9787fd82f9324bfc680e7ea4c', '66.249.77.140', '1729916905', '__ci_last_regenerate|i:1729916905;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1371aa08fdc906e854e743cd05fc17cfb7d5048e', '66.249.77.142', '1729916905', '__ci_last_regenerate|i:1729916905;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e126edf60f3c36546c227645aacdd8c636059538', '51.222.253.14', '1729920573', '__ci_last_regenerate|i:1729920573;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c5cecbc5939e1ec544c6a4a8b4424c7dd8aeddea', '54.36.149.95', '1729926724', '__ci_last_regenerate|i:1729926724;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('da209195fd04e3fc692130ccad936009ae7e4e15', '51.222.253.18', '1729926725', '__ci_last_regenerate|i:1729926725;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('096cf427ca0cd6bdc8e49293a612c554400a70c4', '66.249.77.141', '1729932495', '__ci_last_regenerate|i:1729932495;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9e24eafb2b64297bba6d4eb0abc9f052400c42a6', '66.249.77.140', '1729932495', '__ci_last_regenerate|i:1729932495;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e3cff69d2310a6c1e49462943abd2dda0534b7a3', '87.236.176.132', '1729935658', '__ci_last_regenerate|i:1729935658;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('09996e23875c1aa9c6f036444b818a027a4d1b4e', '87.236.176.107', '1729935659', '__ci_last_regenerate|i:1729935659;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e2d65b2c9281b7b9a5c96306119ba62c96568413', '66.249.77.140', '1729936095', '__ci_last_regenerate|i:1729936095;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e390202416910fb0e4532a2fd1194f8b1fd2a42f', '66.249.77.142', '1729936098', '__ci_last_regenerate|i:1729936098;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('56e97482a9c4d8be44727fa2593b127679b70f41', '51.222.253.11', '1729938831', '__ci_last_regenerate|i:1729938831;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9f76e06936f5b03c872edbc05daaee306519ff5a', '66.249.77.142', '1729942248', '__ci_last_regenerate|i:1729942247;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('440ce005a725d601bfdbe0f17780f206643ad7d1', '66.249.77.141', '1729942248', '__ci_last_regenerate|i:1729942248;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ba36fe5471ec7263098c8d454493c73cddc75522', '51.222.253.8', '1729943319', '__ci_last_regenerate|i:1729943319;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('39e45918c5faef30d37b3f355ab8468e32abac24', '167.172.232.142', '1729944473', '__ci_last_regenerate|i:1729944473;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('75b5cfc32f62504e72a1dacdeb0d86659c5dd751', '167.172.232.142', '1729944475', '__ci_last_regenerate|i:1729944475;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('30791a337a9edc3b998875f0c0389a6853b32957', '167.172.232.142', '1729944476', '__ci_last_regenerate|i:1729944476;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('972720e45d7903f63f60afb64f6d631dbf913d67', '167.172.232.142', '1729944476', '__ci_last_regenerate|i:1729944476;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fdf12f1508dc92f15f4b17b08bd072b9df4b70db', '167.172.232.142', '1729944476', '__ci_last_regenerate|i:1729944476;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5ca07252a4b8b151ac873263c121ec7d949e3dc3', '167.172.232.142', '1729944476', '__ci_last_regenerate|i:1729944476;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b697d30efbbbea295a52f621dd1cc8f4dab82b87', '167.172.232.142', '1729944477', '__ci_last_regenerate|i:1729944477;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8eefdff628a5c2382029f3bdfe7022b7b0f32561', '167.172.232.142', '1729944477', '__ci_last_regenerate|i:1729944477;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cc7470276842f943590df4133d0cbe4cedf6f0ec', '167.172.232.142', '1729944477', '__ci_last_regenerate|i:1729944477;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6510d3560f7e27ad5348bcf6a725545dd3697623', '167.172.232.142', '1729944478', '__ci_last_regenerate|i:1729944478;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4b7702877a4faeb4d02ced1d4a6b3929f4c69713', '167.172.232.142', '1729944478', '__ci_last_regenerate|i:1729944478;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2991b4fe9e8957aeb7813824a41297ad95d56e1c', '167.172.232.142', '1729944478', '__ci_last_regenerate|i:1729944478;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7b89a59f68d7d6c20f0fa26170d0620d344557ed', '167.172.232.142', '1729944479', '__ci_last_regenerate|i:1729944479;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c85468ca0024080a4defc7f30be612281bfc25f8', '167.172.232.142', '1729944480', '__ci_last_regenerate|i:1729944480;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8dec3dd0422b68778ddba3295efbbc473002e86f', '167.172.232.142', '1729944480', '__ci_last_regenerate|i:1729944480;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ab3f2ee50e4bda72f8d5479e28a1087502fadae7', '167.172.232.142', '1729944480', '__ci_last_regenerate|i:1729944480;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f585c5ca2062173c7cfd0fd251cd8a72f0484171', '167.172.232.142', '1729944481', '__ci_last_regenerate|i:1729944481;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0b277e1c47ffc46c312ad7cb5d09dad10643db64', '167.172.232.142', '1729944481', '__ci_last_regenerate|i:1729944481;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('00d15dd2dbaf19d5f0bc774055c2144d1bf5c622', '167.172.232.142', '1729944481', '__ci_last_regenerate|i:1729944481;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d4b29992854f9303e5e723f8f87677207cac12fc', '167.172.232.142', '1729944482', '__ci_last_regenerate|i:1729944482;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8a4aedf28b9538a7a34560def48e70f08c95ffe3', '167.172.232.142', '1729944482', '__ci_last_regenerate|i:1729944482;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c360d6512e295e577a821b940082ebfe59ca165b', '167.172.232.142', '1729944482', '__ci_last_regenerate|i:1729944482;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8ebed36305603361c91aaf6c4dc9f2a037546ef4', '167.172.232.142', '1729944482', '__ci_last_regenerate|i:1729944482;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1be727b39d3a3dc160064bdc9e10a0b8d86b41b7', '167.172.232.142', '1729944483', '__ci_last_regenerate|i:1729944483;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a4c6f17188ee07cd744817f97e8999eb2f4a3829', '167.172.232.142', '1729944483', '__ci_last_regenerate|i:1729944483;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bb38f8d6fa04d0d77623536668b286b080c3c642', '167.172.232.142', '1729944484', '__ci_last_regenerate|i:1729944484;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('edbfdf8ca69fd2e86faba2b920709408401745ef', '167.172.232.142', '1729944484', '__ci_last_regenerate|i:1729944484;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5f91344be2f25b611f4f062e3aba635c5ea7932a', '167.172.232.142', '1729944485', '__ci_last_regenerate|i:1729944485;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c22d305528d4f26bf0a3f279011e3bfe74a1a75a', '167.172.232.142', '1729944485', '__ci_last_regenerate|i:1729944485;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c4a16a00a7d40b0dc4797fd38bcb959e631a2bce', '167.172.232.142', '1729944485', '__ci_last_regenerate|i:1729944485;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('035e258d02ec4538a534c68018c8f288bd3c12dd', '167.172.232.142', '1729944486', '__ci_last_regenerate|i:1729944486;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('755dbbd5fc946c84deea15f9452f21ac5c69a1ba', '167.172.232.142', '1729944486', '__ci_last_regenerate|i:1729944486;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1d6007ed35cb91a198d91a9b14728448e6846623', '167.172.232.142', '1729944486', '__ci_last_regenerate|i:1729944486;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4dfae7e70deb091d9c9e47959ccab8927bbd7679', '167.172.232.142', '1729944486', '__ci_last_regenerate|i:1729944486;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a208b3d6a8cbfb740635b1fadefdbbd427b554e0', '167.172.232.142', '1729944487', '__ci_last_regenerate|i:1729944487;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('94acfa1efb667f591968ded01bbf5929e059b6b7', '167.172.232.142', '1729944487', '__ci_last_regenerate|i:1729944487;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b2cdce711eae631600cbd56eec9a48c1faeaab05', '167.172.232.142', '1729944487', '__ci_last_regenerate|i:1729944487;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f3e573570c1d5711f74efb879e14bb1c91326cc8', '167.172.232.142', '1729944488', '__ci_last_regenerate|i:1729944488;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('11e20071552fde47d675857a6b7f6a8c7e10261c', '167.172.232.142', '1729944488', '__ci_last_regenerate|i:1729944488;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e8db5e747bf9c296d28165baf9941ad5468e6af1', '167.172.232.142', '1729944488', '__ci_last_regenerate|i:1729944488;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5a5bc326781dff6d21c36d4dbc2062fcaa227df5', '167.172.232.142', '1729944489', '__ci_last_regenerate|i:1729944489;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c7e4275740a8e1855a3c317ddf10c08c1cc09527', '167.172.232.142', '1729944489', '__ci_last_regenerate|i:1729944489;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('24621e1e4e86d571b0e231a51609f3e38c4bd5ca', '167.172.232.142', '1729944490', '__ci_last_regenerate|i:1729944489;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d7595a3f1f7c1b64caada81461d97108292597cd', '51.222.253.4', '1729946497', '__ci_last_regenerate|i:1729946497;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cb590c9141af96c8351c6cba8438b8020624c380', '66.249.77.140', '1729947230', '__ci_last_regenerate|i:1729947230;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c163d2095aec125abca6f15be9f21ee8a52b9f77', '66.249.77.141', '1729948316', '__ci_last_regenerate|i:1729948316;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c12400d8f18873af80fff64162f762d4b93ccc22', '51.222.253.14', '1729949355', '__ci_last_regenerate|i:1729949355;language|s:7:\"english\";'), ('396bf4ba718eaaaab7e41897bba8ac84d3e30031', '64.226.65.160', '1729951857', '__ci_last_regenerate|i:1729951857;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1b02008c4b3216aae73d678b9a812e7dbde2f590', '64.226.65.160', '1729951860', '__ci_last_regenerate|i:1729951860;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e29c0ffbe8274a93831e92c3e9b0efdc3133586c', '64.226.65.160', '1729951861', '__ci_last_regenerate|i:1729951861;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dde1ee9d9a1105446da7fa70ba389fa01831fa61', '64.226.65.160', '1729951862', '__ci_last_regenerate|i:1729951862;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('82b6098482ca526b549c09f3a45b95a3823f7929', '64.226.65.160', '1729951862', '__ci_last_regenerate|i:1729951862;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f26a91b5d7d90ecabc929f7ad1d8abd32d00cdb9', '64.226.65.160', '1729951862', '__ci_last_regenerate|i:1729951862;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ddbf73a102e1237c76854affb4bdb6dc8eff28d2', '64.226.65.160', '1729951863', '__ci_last_regenerate|i:1729951863;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('76cf480dbe8cb327af3941829bb41559557edd5c', '64.226.65.160', '1729951863', '__ci_last_regenerate|i:1729951863;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8c4e2001a09b33e9cec0c04ec0bf5ac0236178f2', '64.226.65.160', '1729951864', '__ci_last_regenerate|i:1729951864;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b05882c43614b8d4c1b8f05241b95ed4adf183c8', '64.226.65.160', '1729951864', '__ci_last_regenerate|i:1729951864;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('63e9ae31628604e7941e52ac2cb4d6f94eb78fba', '64.226.65.160', '1729951865', '__ci_last_regenerate|i:1729951865;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a20caeb0159a1316f41ad4b4ea2a2bc15baad4c3', '64.226.65.160', '1729951866', '__ci_last_regenerate|i:1729951866;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('abfeef84defd9e53d66452dad4d56ef8311807ab', '64.226.65.160', '1729951868', '__ci_last_regenerate|i:1729951867;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('631bf6b83766c632f0d5e5de07e7bf3eaa8560c1', '64.226.65.160', '1729951868', '__ci_last_regenerate|i:1729951868;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ccc039f2a27e6471366fa21b21dde30e43e535e3', '64.226.65.160', '1729951869', '__ci_last_regenerate|i:1729951868;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('942ab0ac27c638786ee22e71126520c3bdfd0f40', '64.226.65.160', '1729951869', '__ci_last_regenerate|i:1729951869;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('15b7fe849950eed2274fb0c97ccf685f56b7a629', '64.226.65.160', '1729951869', '__ci_last_regenerate|i:1729951869;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('59079aba12ad2bc22cf17b9b29496a1d7cd28dcc', '64.226.65.160', '1729951870', '__ci_last_regenerate|i:1729951870;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('80f2883869644599e356f2b6137de63763c54bc8', '64.226.65.160', '1729951871', '__ci_last_regenerate|i:1729951871;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('30e9a5775b85fbf4932b90962d95a0ad44da9185', '64.226.65.160', '1729951871', '__ci_last_regenerate|i:1729951871;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3ae545d124d03526f384acb9921a8e1696ba748d', '64.226.65.160', '1729951872', '__ci_last_regenerate|i:1729951872;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('691c944309a831de8b86ddf4e18d880ec7c85f4a', '64.226.65.160', '1729951872', '__ci_last_regenerate|i:1729951872;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6fa8ee741ee12abf06f118c38f218cb52137b184', '64.226.65.160', '1729951873', '__ci_last_regenerate|i:1729951873;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c7a40ed737bfe82602f54ceb553dc29136601dfc', '64.226.65.160', '1729951873', '__ci_last_regenerate|i:1729951873;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('67bbc21bba8d9976425a03469b598dc52498c67d', '64.226.65.160', '1729951874', '__ci_last_regenerate|i:1729951874;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7ef22a570960a4651b71c96ccf92e78f97650fc4', '64.226.65.160', '1729951875', '__ci_last_regenerate|i:1729951875;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fc88f55838ff8c5191a78906ca9d0b476da66233', '64.226.65.160', '1729951876', '__ci_last_regenerate|i:1729951876;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('399ba93c891e017a8fa2b1e013a5db9cbbb67899', '64.226.65.160', '1729951877', '__ci_last_regenerate|i:1729951877;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f55f7828f08866cbe55f9480613c78edf1475491', '64.226.65.160', '1729951877', '__ci_last_regenerate|i:1729951877;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e6a24b622c2099eb908a9a2527a4e2b3bef71d0c', '64.226.65.160', '1729951878', '__ci_last_regenerate|i:1729951878;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ea2fce4622c705ce169922c15943c9e756c7301f', '51.222.253.16', '1729952218', '__ci_last_regenerate|i:1729952218;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('eff4554aafa27bfc0a131a55b3a14a61ebc9a342', '40.77.167.123', '1729953285', '__ci_last_regenerate|i:1729953285;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('308acc7cb3eabee0377222a3bee35d2bf12263bc', '66.249.77.142', '1729953776', '__ci_last_regenerate|i:1729953775;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('23862e33438f0eaa031d3b2af17a8b40865a45f7', '66.249.77.141', '1729953776', '__ci_last_regenerate|i:1729953776;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:65:\"https://cursos.curaquantica13.com/home/course/teste-de-edição/7\";'), ('49485a53b3e39ec716cd9d94e5e1ffa4104af57e', '66.249.77.142', '1729955962', '__ci_last_regenerate|i:1729955962;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('325b41449c56c9513efa327dedf8a9644e4bf64e', '52.167.144.206', '1729956115', '__ci_last_regenerate|i:1729956115;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fc7027b65d26d4b6b3f508fefad2207c8969353b', '66.249.77.141', '1729958532', '__ci_last_regenerate|i:1729958532;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('44f2d6d7e176155b140df6b67307d06c447a17b3', '66.249.77.141', '1729958533', '__ci_last_regenerate|i:1729958532;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('50c856d64b72bd9492273544682ede1cc616dd0a', '66.249.77.141', '1729967248', '__ci_last_regenerate|i:1729967248;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2699dfb7edbc02a4732b4ffa0ffa4a55ebbef3ca', '66.249.77.141', '1729967248', '__ci_last_regenerate|i:1729967248;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('eea5c2ef366c6faf60a067e13484a5639988ac1e', '66.249.77.140', '1729968289', '__ci_last_regenerate|i:1729968289;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a857233453f8811ebb1f0a65a4cb4ac833f9c756', '51.222.253.16', '1729969263', '__ci_last_regenerate|i:1729969263;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5102fe9fab8e6f09cd1fee8d59162435b28b7695', '185.191.171.2', '1729972543', '__ci_last_regenerate|i:1729972543;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f39318dd67efda1fa39de0b22a64a73627061416', '185.191.171.16', '1729972544', '__ci_last_regenerate|i:1729972544;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7ee02f334115176d5d099626ac24f3244698666d', '66.249.77.141', '1729974416', '__ci_last_regenerate|i:1729974416;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dd882d7dc5403c4e428e426cf276eafb776314fa', '66.249.77.141', '1729974416', '__ci_last_regenerate|i:1729974416;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('aada442dab654316fd589153676e2fa2f5a2408b', '66.249.77.142', '1729974487', '__ci_last_regenerate|i:1729974487;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e36805f95b7e21ecfc14ac095423b446eec51185', '66.249.77.141', '1729974623', '__ci_last_regenerate|i:1729974623;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('195eabd92c040cee7e6a4c92539f704cfe4ae3d0', '66.249.77.141', '1729974624', '__ci_last_regenerate|i:1729974624;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7b898d42d9bf3607ea9f85fded11bc0d2aabc337', '66.249.77.141', '1729975454', '__ci_last_regenerate|i:1729975453;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ebbf1979126adb3b92232432d7853801476bd387', '66.249.77.141', '1729975466', '__ci_last_regenerate|i:1729975466;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f444d592eb00d390a19b272ffcd5aa26286b6810', '206.189.233.36', '1729976082', '__ci_last_regenerate|i:1729976081;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c7261fc6de7e17749b199d0b280de378b1ec84b9', '206.189.233.36', '1729976084', '__ci_last_regenerate|i:1729976084;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8ee2520802609a308c1321a79be78abc357e6118', '206.189.233.36', '1729976084', '__ci_last_regenerate|i:1729976084;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('87d5675bce4c6d6db3096ced73d20add3920d7ab', '206.189.233.36', '1729976084', '__ci_last_regenerate|i:1729976084;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c288d9a6cdbc60f750a7b83da3e97b1c2654bb5f', '206.189.233.36', '1729976085', '__ci_last_regenerate|i:1729976085;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('819af4f267b976d129401909401a2fbde8afc281', '206.189.233.36', '1729976085', '__ci_last_regenerate|i:1729976085;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('71a0e3080c625a556bb389a4a7b65397693838c9', '206.189.233.36', '1729976085', '__ci_last_regenerate|i:1729976085;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6522931e1557a50cc33261b092d345ee23b3fa08', '206.189.233.36', '1729976085', '__ci_last_regenerate|i:1729976085;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ac1cc0af27c3aeb7cc84f05d6b678a0efed02a84', '206.189.233.36', '1729976086', '__ci_last_regenerate|i:1729976086;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ed884f9a3d340615516944822eda67617ae72d40', '206.189.233.36', '1729976086', '__ci_last_regenerate|i:1729976086;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6ce18d581ca4cc9e531a7a35769274973c5aebf0', '206.189.233.36', '1729976086', '__ci_last_regenerate|i:1729976086;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5f79fda68fb945963913bc6accd6fe79d118c480', '206.189.233.36', '1729976087', '__ci_last_regenerate|i:1729976087;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8ba642dc7c14d19d0c60a61a11183a5fdc907b15', '206.189.233.36', '1729976088', '__ci_last_regenerate|i:1729976088;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ae3e3d0c2f648251b0aa2a30904bfa35332aa8c6', '206.189.233.36', '1729976088', '__ci_last_regenerate|i:1729976088;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('12064c6f713122ed281b3da7cd56d693cc528304', '206.189.233.36', '1729976088', '__ci_last_regenerate|i:1729976088;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0b61017b319ce5c3ab86c13c533a430a260b8847', '206.189.233.36', '1729976089', '__ci_last_regenerate|i:1729976089;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('db02a53a84190b9a140c6b43662eec33aa305490', '206.189.233.36', '1729976089', '__ci_last_regenerate|i:1729976089;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a7dad75eedb28375fdd4a20464e5c56fbfe36fcb', '206.189.233.36', '1729976089', '__ci_last_regenerate|i:1729976089;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0398fb840de4d31d2147711a4e3090fbc952985e', '206.189.233.36', '1729976090', '__ci_last_regenerate|i:1729976090;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('396843cf1427a5a3d51691200c9f3cd8231335e5', '206.189.233.36', '1729976090', '__ci_last_regenerate|i:1729976090;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e6d20bdeb09f5068dbb6dc19c55419b9513d4208', '206.189.233.36', '1729976090', '__ci_last_regenerate|i:1729976090;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a65e7c0ef91ec86c6b25917116e02c3e030f0d8f', '206.189.233.36', '1729976091', '__ci_last_regenerate|i:1729976091;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('825d6f330dec64f6ba6f626ad9f297593712b19f', '206.189.233.36', '1729976091', '__ci_last_regenerate|i:1729976091;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3915c3bb07ea76fd9769fa9370c44a8e6361a8ef', '206.189.233.36', '1729976091', '__ci_last_regenerate|i:1729976091;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0769d5213642b51a770740d66bea47ec1a840b0a', '206.189.233.36', '1729976092', '__ci_last_regenerate|i:1729976092;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3a26e4080273f05f13a732cddb30758c68da29c1', '206.189.233.36', '1729976092', '__ci_last_regenerate|i:1729976092;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6d2f9f69135c026c07a96c4e25595b1ad06f8ba0', '206.189.233.36', '1729976093', '__ci_last_regenerate|i:1729976093;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a1d4af0ef7c319884facd96ac90ad8a2fcf31ee6', '206.189.233.36', '1729976093', '__ci_last_regenerate|i:1729976093;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('28021e2bf9a27b16a13cfca041e9be0afa26abfb', '206.189.233.36', '1729976094', '__ci_last_regenerate|i:1729976094;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1a6c7b70d9ce90f9d3afb1c1daa4e0d2eb60f220', '206.189.233.36', '1729976094', '__ci_last_regenerate|i:1729976094;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('526a8b357d4c787dab90028e8b32b941b69f3b72', '206.189.233.36', '1729976094', '__ci_last_regenerate|i:1729976094;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ddd6dbfaa108dc336d51cb884d75cd76daa3a465', '206.189.233.36', '1729976095', '__ci_last_regenerate|i:1729976095;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bc623404690d219c9ff68193c4e88ec7da67cf74', '206.189.233.36', '1729976095', '__ci_last_regenerate|i:1729976095;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('23f264f2a72678ce491770475ea9174f8352d7b2', '206.189.233.36', '1729976095', '__ci_last_regenerate|i:1729976095;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('98fe08dbceba6b27c44ba52be5148d244fef7edf', '206.189.233.36', '1729976095', '__ci_last_regenerate|i:1729976095;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e0286e02c1dac7b9e7191169b9d7fd594cd22f36', '206.189.233.36', '1729976096', '__ci_last_regenerate|i:1729976096;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('21c327050754bc8d67c79e64cdd3b13935ca0a6b', '206.189.233.36', '1729976096', '__ci_last_regenerate|i:1729976096;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a557fa1e24dbffa9429d481e700e31674b02fb79', '206.189.233.36', '1729976097', '__ci_last_regenerate|i:1729976097;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8cafffa0f4dd402ce26a44de0150888ab3e42664', '206.189.233.36', '1729976097', '__ci_last_regenerate|i:1729976097;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f084208c22bace04ff84a61f02138d98d8243eb8', '206.189.233.36', '1729976097', '__ci_last_regenerate|i:1729976097;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3ddb7c6e056bdb2cda45d657dfbc7a57cef5efa6', '206.189.233.36', '1729976098', '__ci_last_regenerate|i:1729976098;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('87bff4b35f3cb479accd31c275cc60f6e9ce6828', '206.189.233.36', '1729976098', '__ci_last_regenerate|i:1729976098;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ad364ed0f6144d9ce0b550a5bf7593bd1bf2a068', '66.249.77.141', '1729976843', '__ci_last_regenerate|i:1729976843;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('57ce26944f98af5f8d500a98648ccbae3a2c0431', '66.249.77.141', '1729976948', '__ci_last_regenerate|i:1729976948;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:215;'), ('8770aee7aedbcb2dffca7b81ee501a3513bf855e', '51.222.253.2', '1729977258', '__ci_last_regenerate|i:1729977258;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e9a00d0acc21abbac7d21cf911c942d6a0e60474', '66.249.77.140', '1729977859', '__ci_last_regenerate|i:1729977859;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f7e0233e2479f5c70719211530bde322ba2f6847', '66.249.77.141', '1729977923', '__ci_last_regenerate|i:1729977923;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0ab0d5b237638f610ed2744d90ca43bada32de39', '66.249.77.140', '1729979529', '__ci_last_regenerate|i:1729979529;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6471e60856cb1334eb1926e5388783be1be5ade5', '66.249.77.142', '1729979529', '__ci_last_regenerate|i:1729979529;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5062ecd0e5e632d99fcf69b9cbda3f9c005788e4', '66.249.77.140', '1729979605', '__ci_last_regenerate|i:1729979605;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('eebb5e65e0455a8e3c39bb42b07af2dfda4dd641', '66.249.77.140', '1729980165', '__ci_last_regenerate|i:1729980165;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b7cf192937dfb831de90a5c7cbd1478c46bd7fdc', '66.249.77.141', '1729980179', '__ci_last_regenerate|i:1729980179;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('2e2d3953fc3d166bdd39ff7c01943217ffad6a24', '66.249.77.142', '1729980262', '__ci_last_regenerate|i:1729980262;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f849c72cc78262e0f9967e5faf55eb6ee3df1586', '66.249.77.142', '1729980526', '__ci_last_regenerate|i:1729980526;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('302ee67b089c5434c1e496f19fa663075a065fe5', '66.249.77.142', '1729980659', '__ci_last_regenerate|i:1729980659;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('18e03f0618fb8cccf0d421335bfc79d4677cb4a2', '66.249.77.141', '1729980664', '__ci_last_regenerate|i:1729980664;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e7f9358ebeafda9e1d59c864c6da68e3021995ec', '66.249.77.140', '1729980960', '__ci_last_regenerate|i:1729980960;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('508446ac1ce88a7bba20533da7fec9d42612bdef', '66.249.77.142', '1729981032', '__ci_last_regenerate|i:1729981032;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('07d9b9e7153ac96c45299b53454a55c589d8517a', '66.249.77.142', '1729981085', '__ci_last_regenerate|i:1729981085;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('69c27df535a586dd5bf735b5dcd347b5b7723ada', '66.249.77.142', '1729981160', '__ci_last_regenerate|i:1729981160;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7e0cd362bb53a61ff2d9f78e51fa0b140e74b8f3', '66.249.77.140', '1729981324', '__ci_last_regenerate|i:1729981324;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a7301c71f59523d9740ae349739060850dee7a68', '66.249.77.140', '1729981379', '__ci_last_regenerate|i:1729981379;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6a0d1ac0f437ee7ecc07941d6e0b2d5c0270b6f8', '66.249.77.140', '1729981462', '__ci_last_regenerate|i:1729981462;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6a692148cda67bcabe0a86e96fd56800c49f8080', '66.249.77.141', '1729981797', '__ci_last_regenerate|i:1729981797;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('76285fbd588666fe116046fc4d98570ce8c4b8d5', '66.249.77.141', '1729981809', '__ci_last_regenerate|i:1729981809;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0c67b502a4b358eb864351291007453287d2d9e3', '66.249.77.142', '1729981869', '__ci_last_regenerate|i:1729981869;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0d743a02f9d5f4b446f0168be400a1e407700c54', '66.249.77.142', '1729981924', '__ci_last_regenerate|i:1729981924;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('945e8eb3f76e39ffa05cdedfe704d591f6e4f429', '66.249.77.141', '1729981940', '__ci_last_regenerate|i:1729981940;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fc6d299e9162ea6117b6db6df816a6aa0b202b14', '66.249.77.140', '1729982005', '__ci_last_regenerate|i:1729982005;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5fff3828db6837cd01f58785e37b212d9d50b338', '66.249.77.140', '1729982006', '__ci_last_regenerate|i:1729982006;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a02585994f8c721c75d961d36b66d38f8845c63f', '66.249.77.142', '1729982067', '__ci_last_regenerate|i:1729982067;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a65647326417aac31bd960554bebb3b933df4d3f', '66.249.77.142', '1729982099', '__ci_last_regenerate|i:1729982099;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6e0534edeead5ed902f6f7cda3280308ae192b2f', '66.249.77.141', '1729983660', '__ci_last_regenerate|i:1729983660;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5ba8847978629d857dcf8201ff9a16feeee10f83', '85.208.96.210', '1729984423', '__ci_last_regenerate|i:1729984423;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('691e21df3d66d1bc53af83bd0d091d5fc5e5bea1', '185.191.171.9', '1729984423', '__ci_last_regenerate|i:1729984423;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8134bcd2f92f00c2ad5b304a2c4ca0e14ba75952', '51.222.253.10', '1729986052', '__ci_last_regenerate|i:1729986052;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('745b1e78a60c3d428f79365ce5bd5e7296da0817', '66.249.77.142', '1729986206', '__ci_last_regenerate|i:1729986206;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('36c17f0ab1df53abce88d9a83ac587ecd9192a8b', '66.249.77.141', '1729986375', '__ci_last_regenerate|i:1729986375;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8b3155546ff089e0cca20ba1e34962875629dacf', '167.172.158.128', '1729986390', '__ci_last_regenerate|i:1729986390;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f5aa643b5969fd0c0e05b8a70fef95d5eda15090', '167.172.158.128', '1729986392', '__ci_last_regenerate|i:1729986392;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ff49868a39a6ab2754ca2da3230662854c1eda59', '167.172.158.128', '1729986392', '__ci_last_regenerate|i:1729986392;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b7db7a0da901b791dd397614453df43e5059e2f7', '167.172.158.128', '1729986393', '__ci_last_regenerate|i:1729986393;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dfbe1fd38f6fe446bb5673f063c19b99375457db', '167.172.158.128', '1729986393', '__ci_last_regenerate|i:1729986393;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bd6204c3396d4a73e58e280fb59ac4f214284e3c', '167.172.158.128', '1729986393', '__ci_last_regenerate|i:1729986393;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c41c7ef02c456bf0e8d13d12f8d516b739f15965', '167.172.158.128', '1729986393', '__ci_last_regenerate|i:1729986393;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5562be3d59f5db5b8ac9ee6b62b30e20cb6efecb', '167.172.158.128', '1729986394', '__ci_last_regenerate|i:1729986394;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('48a0a1bcf47dd1ab00d480fda3f3239cb7b08cd1', '167.172.158.128', '1729986394', '__ci_last_regenerate|i:1729986394;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a8d36635f032e9c5bac3ad9b2f904f907106dd45', '167.172.158.128', '1729986394', '__ci_last_regenerate|i:1729986394;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e9cb0761a252f0f992de140c0de7e6c79845d059', '167.172.158.128', '1729986394', '__ci_last_regenerate|i:1729986394;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('436d87b79096a22e3f0b5529bc44ad7e06cd3625', '167.172.158.128', '1729986395', '__ci_last_regenerate|i:1729986395;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('30bbdf32747626e5304215e4aff22a0b9b4ec0b0', '167.172.158.128', '1729986396', '__ci_last_regenerate|i:1729986396;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2130ed189a406e580bfb2e1bdf7ca9999478253f', '167.172.158.128', '1729986396', '__ci_last_regenerate|i:1729986396;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f4a0f601fee87192a13bd5319e4c5e2f6994f66b', '167.172.158.128', '1729986397', '__ci_last_regenerate|i:1729986397;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('41b62a8864a49c453d10c7f03ba9903402bf7c1b', '167.172.158.128', '1729986397', '__ci_last_regenerate|i:1729986397;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('00263611c06c373d342b8377a46dafeb97cba988', '167.172.158.128', '1729986397', '__ci_last_regenerate|i:1729986397;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5e3d0fba8717f4336ac23c80724248de0d843e43', '167.172.158.128', '1729986398', '__ci_last_regenerate|i:1729986398;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3bc4e6843815385409d076514b5de9496aa249fe', '167.172.158.128', '1729986398', '__ci_last_regenerate|i:1729986398;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a2cf2079c624a3ab0ccef2fbd3d6f67d37a0a6b7', '167.172.158.128', '1729986398', '__ci_last_regenerate|i:1729986398;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('19e16666fe997f9edfc3ed7aab44a9483b788f65', '167.172.158.128', '1729986398', '__ci_last_regenerate|i:1729986398;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8591cdbb8c80069922b21308f7d305851ec91c43', '167.172.158.128', '1729986399', '__ci_last_regenerate|i:1729986399;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c1b8b7718b542e6ea7aa00d57a91bc8439da895a', '167.172.158.128', '1729986399', '__ci_last_regenerate|i:1729986399;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('06431ee4182b2974c8d7309d89eb0deea306218b', '167.172.158.128', '1729986399', '__ci_last_regenerate|i:1729986399;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('29ede333cd8130056d5a30de0a48b0933e490d5f', '167.172.158.128', '1729986400', '__ci_last_regenerate|i:1729986400;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('786b3f6c9b98c19eb8c7b26137ff4b225960ec8d', '167.172.158.128', '1729986400', '__ci_last_regenerate|i:1729986400;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('71cac3ffde85ce13c1a0a662b3fb362d172c41f2', '167.172.158.128', '1729986401', '__ci_last_regenerate|i:1729986401;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8098f15c70eb7a9fba5ba95f7b194cf902ac2fc7', '167.172.158.128', '1729986401', '__ci_last_regenerate|i:1729986401;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e40bd28e6cfd1893dae7f7ecc9f50bae4bb0d3cd', '167.172.158.128', '1729986402', '__ci_last_regenerate|i:1729986402;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fed555668779bdc26ca7a0147f5d6d9f4d5bd019', '167.172.158.128', '1729986402', '__ci_last_regenerate|i:1729986402;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('80c9d288926f5806cc3855580b3439d5c7f2285b', '167.172.158.128', '1729986402', '__ci_last_regenerate|i:1729986402;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2ba9c18ce5a0dd62de6065fe497d6d0f49c977a5', '167.172.158.128', '1729986403', '__ci_last_regenerate|i:1729986402;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('eecd43fc37502ccf40b67c1888f3aeef5880d22b', '167.172.158.128', '1729986403', '__ci_last_regenerate|i:1729986403;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9762a21b804d079febe620a424ca43647c69423d', '167.172.158.128', '1729986403', '__ci_last_regenerate|i:1729986403;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7084bc8eb9080b4d1d6f32645b4b210e0407bc10', '167.172.158.128', '1729986403', '__ci_last_regenerate|i:1729986403;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8f35cd46985a3ec7112eabd7d33405f2e90b7b23', '167.172.158.128', '1729986404', '__ci_last_regenerate|i:1729986404;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e9e3504a3fec2fec73cc58a4168f5480b2795131', '167.172.158.128', '1729986404', '__ci_last_regenerate|i:1729986404;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c9703238379b8e5f5538a5a9f837a60384b19613', '167.172.158.128', '1729986404', '__ci_last_regenerate|i:1729986404;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('451ad74c6935117a8826f4866bab2df2a0800416', '167.172.158.128', '1729986405', '__ci_last_regenerate|i:1729986405;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('50bc01eedc66d905c078b0209cc4fc0048391f77', '167.172.158.128', '1729986405', '__ci_last_regenerate|i:1729986405;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('249d173976bf15cd55bf52afedfcd86a2c88671f', '167.172.158.128', '1729986406', '__ci_last_regenerate|i:1729986406;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0657c3c19d71ad493a52083816f5a96f93ce87b5', '167.172.158.128', '1729986406', '__ci_last_regenerate|i:1729986406;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('820b56e51ee1516eec9cbe7d3d9bc6af94f0d9f9', '167.172.158.128', '1729986406', '__ci_last_regenerate|i:1729986406;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3313d7a50c13f258ca413793b7b4c855c98ce12a', '66.249.77.140', '1729986595', '__ci_last_regenerate|i:1729986595;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1164f62109c28c6b28c2d9632173fefb169d53c6', '66.249.77.141', '1729986742', '__ci_last_regenerate|i:1729986742;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ba54500a3cae24162708b217df5953be51519333', '66.249.77.142', '1729986801', '__ci_last_regenerate|i:1729986801;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d9ac17fadeacaa0934cf7875922d7fd52002f2f8', '66.249.77.141', '1729986844', '__ci_last_regenerate|i:1729986844;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('05b136f6a364d8b63a1e1bc42b2919ce1f584580', '66.249.77.142', '1729987035', '__ci_last_regenerate|i:1729987035;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('831ce4feaabc0b886bc1cf17f1fc849a1cca6e57', '66.249.77.141', '1729987094', '__ci_last_regenerate|i:1729987094;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a1b6ccb9ae22b99ee974f508e77a556c500fc808', '66.249.77.140', '1729987155', '__ci_last_regenerate|i:1729987155;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('b4116daa9778015809c45d9f2231166cb3b47bb1', '66.249.77.141', '1729987808', '__ci_last_regenerate|i:1729987808;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b146c5543e1c347ce3f94aaeee8f85aa7b7a9430', '66.249.77.140', '1729987808', '__ci_last_regenerate|i:1729987808;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6c43c13492ee9fff6e1859cf7054c6a8f971aeac', '66.249.77.141', '1729988003', '__ci_last_regenerate|i:1729988003;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a464be4359e6cb09faf25b75c4fecb5516221db4', '66.249.77.142', '1729988053', '__ci_last_regenerate|i:1729988053;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f7f8db483ef8bea1fddf7f8573c4a11a5d769f38', '66.249.77.141', '1729988109', '__ci_last_regenerate|i:1729988109;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7bb4a8ec5108267c4274cd29f6eb0a073d22a090', '66.249.77.142', '1729988267', '__ci_last_regenerate|i:1729988266;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dd32524561e40a699a5ca4e47385746820727974', '66.249.77.140', '1729988278', '__ci_last_regenerate|i:1729988278;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:40;'), ('7dc6a4512d910a0f3a638694b0e85b38138f360f', '66.249.77.140', '1729988344', '__ci_last_regenerate|i:1729988344;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d01afd32585afe2d6ccfe6c14f413674a212d787', '66.249.77.141', '1729988412', '__ci_last_regenerate|i:1729988412;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3804d1f830a1c6c053bd0a0ad78a496c072f455e', '66.249.77.140', '1729988423', '__ci_last_regenerate|i:1729988423;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('411f3efa940c95d4fa461634a3f700d52dc26892', '66.249.77.142', '1729988637', '__ci_last_regenerate|i:1729988637;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e795043ed8dbc442b7491bcffdf01281fa7a3e5a', '66.249.77.141', '1729988638', '__ci_last_regenerate|i:1729988638;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('39203e8acaf25721934084e4ac8064d18ea395cc', '66.249.77.140', '1729988640', '__ci_last_regenerate|i:1729988640;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d6e9d28e2fa5dfe4ffb3bf88388e3f62f1f26d9e', '66.249.77.141', '1729988660', '__ci_last_regenerate|i:1729988660;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('acf5932a883fc9100d78e8bc4dfaaf3fbfb22cbd', '66.249.77.140', '1729988662', '__ci_last_regenerate|i:1729988662;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f4372e7c615f9a9eca129f7284ed6dfc8234efe7', '66.249.77.140', '1729988709', '__ci_last_regenerate|i:1729988709;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('db91d5b2bcc00987e43f31cb62f7f8c2575630fc', '66.249.77.142', '1729988996', '__ci_last_regenerate|i:1729988996;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d0b631ebd55e29f815eff96d15b47fbbb4340236', '66.249.77.142', '1729989179', '__ci_last_regenerate|i:1729989179;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8e6574187dbc8944e9bed5cc1ac22bcbcd19bee8', '66.249.77.142', '1729989322', '__ci_last_regenerate|i:1729989322;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fd15fd905e3d1023f7a9dd473ad85b50865d75c7', '66.249.77.141', '1729989566', '__ci_last_regenerate|i:1729989566;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dbd6179f948c8f278b03d81872623e27b849a4d1', '66.249.77.140', '1729989728', '__ci_last_regenerate|i:1729989728;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6e85f918e9982601730d616076b7dc6d5ac4eb93', '66.249.77.142', '1729989793', '__ci_last_regenerate|i:1729989793;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('238d52dfb06aac142d1cbefeeb0d8f68a717c97c', '66.249.77.140', '1729989835', '__ci_last_regenerate|i:1729989835;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b8d41248daf50aa4a77975489efa9c9cb435dfff', '66.249.77.141', '1729989897', '__ci_last_regenerate|i:1729989897;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('338f0562a72732c2472b6e6f8d5f9c854af6d1cf', '66.249.77.142', '1729990342', '__ci_last_regenerate|i:1729990342;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('179d4a96ee2d065d2a678e86de4cebfa5593e002', '66.249.77.140', '1729990684', '__ci_last_regenerate|i:1729990684;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c5274712b1f3689175417cb4ec1bdd354ea80f3c', '66.249.77.141', '1729990694', '__ci_last_regenerate|i:1729990694;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('248bef1d6a9e9b1280f64da32ba35e791bd1c04f', '66.249.77.141', '1729990786', '__ci_last_regenerate|i:1729990786;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c60d86bd122c7ceb1a67b9bd6be7c465e9a341ef', '66.249.77.140', '1729990988', '__ci_last_regenerate|i:1729990988;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f4144bbd6a4073e4aff479d136525d554ea8ab7d', '66.249.77.140', '1729991043', '__ci_last_regenerate|i:1729991043;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1a9250553482a98746b0e0f7554c9a1640d2f91e', '66.249.77.142', '1729991355', '__ci_last_regenerate|i:1729991355;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('18295af003fc6de8d3ef1304c27601a6639452af', '66.249.77.140', '1729992193', '__ci_last_regenerate|i:1729992193;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e6537b5cc2122f42153dcf514bd3bd9cbdf6d007', '66.249.77.140', '1729992194', '__ci_last_regenerate|i:1729992194;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('81b1ff15305e2831452849e2ea2cb348128a6dcf', '66.249.77.142', '1729992248', '__ci_last_regenerate|i:1729992248;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('af4e666f17e20ce49541f5f0d7bfb5cff6dccc34', '66.249.77.140', '1729992282', '__ci_last_regenerate|i:1729992282;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('1ac0011f924c2d64e5d6ee347c3cc797ff011b9f', '66.249.77.140', '1729992283', '__ci_last_regenerate|i:1729992283;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('abc7031a0dc17ad2b1a5940f1c81deb53e2980c7', '66.249.77.141', '1729992300', '__ci_last_regenerate|i:1729992300;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9f7c98c79074e424420cf8125989c72cef951ce4', '66.249.77.141', '1729992300', '__ci_last_regenerate|i:1729992300;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5e8e3a4a09f0b773c36e8759f1a7ddc4d679099c', '66.249.77.141', '1729992307', '__ci_last_regenerate|i:1729992307;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9bf3d260a6890a4a595b4db7f1ad455781b03650', '66.249.77.140', '1729992333', '__ci_last_regenerate|i:1729992333;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a9f2d146f7d99063476901f6197a06efff8c439f', '66.249.77.140', '1729992344', '__ci_last_regenerate|i:1729992344;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2369719c104890d8912db500aef420de2a83a107', '66.249.77.140', '1729992348', '__ci_last_regenerate|i:1729992348;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2200fe03e3d118a65db103a67e75dd6783bfbd57', '66.249.77.142', '1729992586', '__ci_last_regenerate|i:1729992586;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7839b1a737f8b5ac0c35354df0f9fc11e3d4b372', '66.249.77.140', '1729992623', '__ci_last_regenerate|i:1729992623;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f28c072fbc8a4ebf38011debb0dcdc40070ab7e1', '66.249.77.140', '1729993034', '__ci_last_regenerate|i:1729993034;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('15391a78282058308e619bb8f7b16f59ecaaae42', '66.249.77.140', '1729993100', '__ci_last_regenerate|i:1729993100;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('19ca0adffc20a804447c041db4827ab15d6033b0', '66.249.77.141', '1729993101', '__ci_last_regenerate|i:1729993101;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('d271d1e584a387493e1400162fd66b6d2f2e9a19', '85.208.96.209', '1729993183', '__ci_last_regenerate|i:1729993183;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('251f914e53ff779b5cadf63e93ed09d0e505e57d', '85.208.96.212', '1729993184', '__ci_last_regenerate|i:1729993184;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('db1e73b74b26d120d9509f1d969de993fc4e64c2', '66.249.77.142', '1729993406', '__ci_last_regenerate|i:1729993406;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('87802737f751a00668f77d2a9e82b55d5549b7cc', '66.249.77.141', '1729993787', '__ci_last_regenerate|i:1729993787;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('056ac4758f6e71371ef06c7bdce67085cf24311b', '185.191.171.11', '1729993922', '__ci_last_regenerate|i:1729993922;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fc3cf5e962595c87bfc3a1be8a435f4b47f3072b', '66.249.77.141', '1729993966', '__ci_last_regenerate|i:1729993966;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('495ae56e68c97c481c2a8395a6f9cab1207e7c4c', '66.249.77.140', '1729996988', '__ci_last_regenerate|i:1729996988;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7dd2b28ac14a4116523153c604ebe0f12e1117b1', '66.249.77.140', '1729996988', '__ci_last_regenerate|i:1729996988;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:215;'), ('078de26e982030d46079559b37469568880aa898', '66.249.77.142', '1729997168', '__ci_last_regenerate|i:1729997168;cart_items|a:1:{i:0;s:1:\"5\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:799;'), ('a5c65579a1ea84b14bb44c65c3693f0f9e680020', '66.249.77.142', '1729997218', '__ci_last_regenerate|i:1729997218;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('c3f5904fbe8f2b78a2976e0e8a6155068b3f7cfe', '66.249.77.141', '1729997997', '__ci_last_regenerate|i:1729997997;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4adcb1bc074506804d39b4af773ee593eb256580', '66.249.77.142', '1729998193', '__ci_last_regenerate|i:1729998193;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('564906ebf0aaa4d9e727b81bdb50c1ceb514f5b8', '185.191.171.14', '1729998304', '__ci_last_regenerate|i:1729998304;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c1279dcabf1b1de9fb2efc35e5144fb33a0f555a', '185.191.171.13', '1729998304', '__ci_last_regenerate|i:1729998304;layout|s:4:\"list\";language|s:7:\"english\";'), ('6907f894d0152ffe74313580716198a0899d30ea', '66.249.77.141', '1729998616', '__ci_last_regenerate|i:1729998615;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c78b6528042668555a6490fc482e74b8449909cc', '66.249.77.141', '1729998617', '__ci_last_regenerate|i:1729998617;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9fd9c5857394c113f13d440d25ba884a2fc4c336', '66.249.77.142', '1729999263', '__ci_last_regenerate|i:1729999263;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0c383b9801970433e2f317aeaa5dad2e214b1b54', '85.208.96.208', '1729999401', '__ci_last_regenerate|i:1729999401;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7096c2e8c0e598e47e7750ea2db8eab573ef6464', '66.249.77.142', '1729999605', '__ci_last_regenerate|i:1729999605;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('06dfda3c2eb6cc5f6db224952d308296bf93b316', '66.249.77.141', '1729999633', '__ci_last_regenerate|i:1729999632;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('505fec306ceb189b5b656746472be2259c5a7c20', '66.249.77.140', '1729999637', '__ci_last_regenerate|i:1729999637;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b1bb30bfc1e38a5ac3b8e727bf52277036d994b2', '51.222.253.11', '1730000619', '__ci_last_regenerate|i:1730000619;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a3ae4a985f22e89fa1abd324ffdd29c976d27703', '66.249.77.142', '1730001022', '__ci_last_regenerate|i:1730001022;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0026958528db95baba046ab9d553d40e3c3cf619', '66.249.77.142', '1730001022', '__ci_last_regenerate|i:1730001022;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7c380753a048e7f717721504465396bbfbcfa761', '66.249.77.140', '1730001056', '__ci_last_regenerate|i:1730001056;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a955251530504cea8876a69b4cb6d55e9e97f58b', '66.249.77.140', '1730001616', '__ci_last_regenerate|i:1730001616;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('09acfd786ac6017382e213bad5e6b3a0672323f7', '85.208.96.199', '1730001845', '__ci_last_regenerate|i:1730001844;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5a9090905174976cc928364bfab98a812c4b005e', '66.249.77.142', '1730001865', '__ci_last_regenerate|i:1730001865;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b4b28bad7d6ad2f3c8cac5e5a1083ec27fa003de', '85.208.96.193', '1730004667', '__ci_last_regenerate|i:1730004667;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f3dd19bec8ba0f2457e68d33239f471f08cdf5e6', '85.208.96.195', '1730004667', '__ci_last_regenerate|i:1730004667;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('52ad62367a98fbb83fc90aa49b4f03408b1af11b', '85.208.96.208', '1730005477', '__ci_last_regenerate|i:1730005476;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b6f3b14d0bf42ad7923068d21b8c4865c19bc0d3', '85.208.96.205', '1730010195', '__ci_last_regenerate|i:1730010195;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e3be02fb4d25e0626b4ced36cafeb487f1ebb9f7', '185.191.171.4', '1730010196', '__ci_last_regenerate|i:1730010195;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('38bf5b0b770ac0e964cd86d8710388449e12b5fb', '51.222.253.8', '1730013580', '__ci_last_regenerate|i:1730013580;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('774b37b6c269a89ea89ec6790cc659778b4cc19a', '85.208.96.208', '1730013928', '__ci_last_regenerate|i:1730013927;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('900a3a264f6783830a6e46e5b77b06b295b976d9', '185.191.171.19', '1730013928', '__ci_last_regenerate|i:1730013928;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f8eb96c51757804c9ef42e04faaea42191dc8cd8', '51.222.253.10', '1730017101', '__ci_last_regenerate|i:1730017101;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('690919cf618dd3d516073e97841d6db58a0925bc', '51.222.253.2', '1730019253', '__ci_last_regenerate|i:1730019253;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('577ab07966f81d13f010399d14ba4f1f1185dfa0', '45.148.10.59', '1730021078', '__ci_last_regenerate|i:1730021078;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('877fd117479ae58bc1fb5affea4278f9c8fa9cd2', '45.148.10.59', '1730021078', '__ci_last_regenerate|i:1730021078;'), ('456ba6d692282bb1ee1018e764994ea81ae5f872', '45.148.10.59', '1730021079', '__ci_last_regenerate|i:1730021079;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('23763eaa5755f3233f1c43adb934b5d438c64a8c', '85.208.96.198', '1730022907', '__ci_last_regenerate|i:1730022907;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('93a9cbd433575fe86c12323e69dce148988337fa', '85.208.96.210', '1730022908', '__ci_last_regenerate|i:1730022908;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('86beb699c815289cd07d11da7278cb29ebaafe87', '85.208.96.210', '1730023539', '__ci_last_regenerate|i:1730023539;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('207c186c56951a38c2c1aa9c2de387236a59f722', '54.36.148.149', '1730026177', '__ci_last_regenerate|i:1730026176;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('37a8fa0646b684208c1c00776159f4d30cca761d', '51.222.253.1', '1730026178', '__ci_last_regenerate|i:1730026178;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('183ddd6e13b91953afd621e482ee648e6d3abcc0', '85.208.96.208', '1730028138', '__ci_last_regenerate|i:1730028138;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2186828262f01c9a580d75f9b6a788d1c253c04f', '85.208.96.209', '1730028139', '__ci_last_regenerate|i:1730028139;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('07df5f1210e8a415e968b89c4e5f6febb96e7608', '40.77.167.12', '1730030609', '__ci_last_regenerate|i:1730030609;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a29afe949341dca60f9a2c03aca17c21a705e696', '37.187.73.123', '1730035660', '__ci_last_regenerate|i:1730035660;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fd51a159e770d192e98340330ff6faab49512b8e', '37.187.73.123', '1730035678', '__ci_last_regenerate|i:1730035678;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b17318db297f63c4a8f50b4d4d43c846a4e76a0f', '37.187.73.123', '1730035683', '__ci_last_regenerate|i:1730035683;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fdeef31debc5831a605f21007fcf57f426f6b5be', '66.249.77.142', '1730039162', '__ci_last_regenerate|i:1730039162;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1a32eac19afeb60063dd796cc33b6558248cfb75', '66.249.77.140', '1730039162', '__ci_last_regenerate|i:1730039162;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ccd608cf2bb3e7fc18e9322ab30887d3f07bf32f', '47.128.32.93', '1730042582', '__ci_last_regenerate|i:1730042582;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7b6c76beb8bcd22b9b146c3a20591136a981491f', '47.128.58.218', '1730042602', '__ci_last_regenerate|i:1730042602;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1c0fa06c27fbb4912588b186527a52636c9a3576', '66.249.77.142', '1730051303', '__ci_last_regenerate|i:1730051303;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7e846af87c9d838cdacadbca7437f6dfd3bf3944', '66.249.77.140', '1730051303', '__ci_last_regenerate|i:1730051303;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e063d0eaed5797a26b009921ff443af35c2205c4', '149.202.86.86', '1730059017', '__ci_last_regenerate|i:1730059017;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e511c79bdca10ba67cc6a62dcc359b3f630eff81', '149.202.86.86', '1730059032', '__ci_last_regenerate|i:1730059032;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a17e33030b943899b86e02dff4cc239e1bc11b1c', '51.222.253.2', '1730061421', '__ci_last_regenerate|i:1730061421;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('75d6420bbabd51774191fcac38bf1d2f5ce87c01', '66.249.77.140', '1730079256', '__ci_last_regenerate|i:1730079256;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ce45e12fd50209cd9cd0a85c46b828815bd1a0e9', '66.249.77.140', '1730079256', '__ci_last_regenerate|i:1730079256;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('94333e0007cc462c130ef9a9286a1a296dcd0a21', '66.249.77.142', '1730079496', '__ci_last_regenerate|i:1730079496;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('b09ff38c7e420a480483f0f6001fdfa88b8ed4b6', '66.249.72.32', '1730088717', '__ci_last_regenerate|i:1730088716;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('107b55577537e948ee2fe0049d2e68e0ab33a55e', '66.249.72.32', '1730088717', '__ci_last_regenerate|i:1730088717;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5997bd8775f7caea3a21dea809202691280b1fc0', '66.249.72.34', '1730088946', '__ci_last_regenerate|i:1730088946;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b01a2a8195bb28465c78fbf73c92962f01487cba', '66.249.72.32', '1730089258', '__ci_last_regenerate|i:1730089258;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8ba782a94f8343d528c1daa2ada78087d58cdd42', '66.249.72.32', '1730089259', '__ci_last_regenerate|i:1730089258;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4ed28efd04d21c70633ebfc06769742417fa3046', '66.249.72.34', '1730089763', '__ci_last_regenerate|i:1730089763;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c2414ded1681f97495235e515df3add127ce67d4', '66.249.72.33', '1730089795', '__ci_last_regenerate|i:1730089795;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('aab61721e8a9dfdd48b0934f45821ddb8ea52e03', '66.249.72.32', '1730089797', '__ci_last_regenerate|i:1730089797;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('46b99e82a8176c3135f4f0d06abfe2caf0b743c2', '66.249.72.34', '1730089927', '__ci_last_regenerate|i:1730089927;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0249592a06f5dc7ef3f37a6c725ead42f2d26637', '66.249.72.34', '1730089989', '__ci_last_regenerate|i:1730089989;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fe8b8fd3b26ff6bb2e3611ffea9b9f7bca23ae8b', '66.249.72.32', '1730090157', '__ci_last_regenerate|i:1730090157;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5c63de084cd5b909a9a7525fd6b645350c22d9a6', '66.249.72.34', '1730090228', '__ci_last_regenerate|i:1730090228;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7cc7add7d7501fb91381657ebd6109f6edd06997', '66.249.72.32', '1730090266', '__ci_last_regenerate|i:1730090265;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('6107488e42722bca99cb93be6650309c22661b1a', '66.249.72.34', '1730090294', '__ci_last_regenerate|i:1730090294;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('85147d6c92fce59ae7fd52371bd4a45a430c6d99', '66.249.72.33', '1730090305', '__ci_last_regenerate|i:1730090305;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('67c4f327a13b5dd90a2fd35614fa28ba6eec141a', '66.249.72.32', '1730090347', '__ci_last_regenerate|i:1730090347;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('641d83ba62ab6a4a11093abcc41fed6b6cc58ffb', '66.249.72.33', '1730090362', '__ci_last_regenerate|i:1730090362;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0294087f8125be035e9b1e9360e2b4a06ea8152c', '66.249.72.34', '1730090648', '__ci_last_regenerate|i:1730090648;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f614e647473e0209194e56e7e40be2f2ab91874a', '139.59.21.251', '1730096389', '__ci_last_regenerate|i:1730096389;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d76ae43b11906e54d1cb361870370cf70c74a7d0', '139.59.21.251', '1730096395', '__ci_last_regenerate|i:1730096395;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bd2aac7258ef265bc74a527bd742fc516553710c', '51.222.253.6', '1730100714', '__ci_last_regenerate|i:1730100714;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b17db5a192b4d165b575103790efa14015e0dfb8', '51.222.253.11', '1730105412', '__ci_last_regenerate|i:1730105412;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5e93d82f781d44ecf9245df593cf19e3fbb02112', '134.209.26.64', '1730107447', '__ci_last_regenerate|i:1730107446;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5517fe479bf98028d602a75b65e19f500d0523be', '51.222.253.20', '1730110310', '__ci_last_regenerate|i:1730110310;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('840e0f8d0536e6f18c59547fbb25a9914043dc51', '51.222.253.12', '1730114744', '__ci_last_regenerate|i:1730114744;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f932f3571f2c2a46565125b1521c1533d418f504', '66.249.72.33', '1730118059', '__ci_last_regenerate|i:1730118059;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('33f02e1f7ed5f7c76d9ec31abf68c7b86025931f', '66.249.72.34', '1730118059', '__ci_last_regenerate|i:1730118059;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c821675a379b9bd03fb37f1e95a5888a5372f21c', '66.249.72.34', '1730118419', '__ci_last_regenerate|i:1730118419;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6864699f61d79818b581a40974b2857a1cae0617', '66.249.72.32', '1730118796', '__ci_last_regenerate|i:1730118796;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('16eb266bf52c7f56d666e11c78e7de4b357f1102', '66.249.72.34', '1730119256', '__ci_last_regenerate|i:1730119256;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d744bd3f93bb7dc63385d0ccb4074078256ff4ea', '66.249.72.34', '1730119257', '__ci_last_regenerate|i:1730119257;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('143b0729f4f9ac2d5e6e29c079c3c23d8fd8579b', '66.249.72.32', '1730119259', '__ci_last_regenerate|i:1730119259;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('872075a31e48cae66191edc90a20ede49be0b048', '66.249.72.32', '1730119761', '__ci_last_regenerate|i:1730119761;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:40;'), ('66ecd4c1b59308c19cc6859035092df56c22cb51', '66.249.72.34', '1730119905', '__ci_last_regenerate|i:1730119905;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('561efc9001a9151b02a53951fc7b40d7658f1317', '66.249.72.34', '1730120566', '__ci_last_regenerate|i:1730120566;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2586d235c6ef20eb8655ca1f02b8aab766baf0ca', '66.249.72.32', '1730120819', '__ci_last_regenerate|i:1730120819;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dfe05481ba9fa0ae5ea4f66d0def9c036f601492', '66.249.72.33', '1730121023', '__ci_last_regenerate|i:1730121023;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cadc029aca761b3e40941e18d830ec8da39f974b', '66.249.72.32', '1730121025', '__ci_last_regenerate|i:1730121025;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7fd2e3d130afdbf4233ef1b4f7a76974c33b4490', '47.128.36.203', '1730127463', '__ci_last_regenerate|i:1730127463;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('91c749a8420213d85400bf619003f404d9745d52', '47.128.98.52', '1730127487', '__ci_last_regenerate|i:1730127487;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('513655a2ad34efd3bd436a1b7478f503fd911975', '192.250.226.178', '1730130834', '__ci_last_regenerate|i:1730130834;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b74ddf36565c81adebe3937686924590007e5636', '51.222.253.10', '1730131516', '__ci_last_regenerate|i:1730131516;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('3cba03297c0615a7ac328e62b282e56b8144f676', '95.91.16.21', '1730137819', '__ci_last_regenerate|i:1730137819;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8e9086982504bd0783f2bf0b678ca79baed0b888', '95.91.16.21', '1730137826', '__ci_last_regenerate|i:1730137826;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8b946816719148efc7139cf27f9cafc681234961', '95.91.16.21', '1730137829', '__ci_last_regenerate|i:1730137829;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('365b53ebcea14dbefa50f866a015e05d938b566f', '95.91.16.21', '1730137830', '__ci_last_regenerate|i:1730137830;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fe25f8b6fe445d74fdfe5d6d1552329f179105b4', '95.91.16.21', '1730137832', '__ci_last_regenerate|i:1730137832;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ce58da94a1934b58212a7481ebee0ba4550a9cf3', '51.222.253.9', '1730138585', '__ci_last_regenerate|i:1730138585;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('60c824c35d0145ae6aee81103337ca28d4a0cb9d', '20.171.206.40', '1730140116', '__ci_last_regenerate|i:1730140116;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3884b03679fccbeca6d4df7ee3f3e22aebe83c2c', '20.171.206.19', '1730140135', '__ci_last_regenerate|i:1730140134;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('96831b02c2ed7bdb02c4d4c420e2e26a4d1520c4', '20.171.206.19', '1730140156', '__ci_last_regenerate|i:1730140156;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('e743004294bcbd0629d57ba500c6af8a6364a885', '20.171.206.19', '1730140165', '__ci_last_regenerate|i:1730140165;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('6279883fe419b3d7a97345e74d0133c5bf148bf8', '20.171.206.19', '1730140175', '__ci_last_regenerate|i:1730140175;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:68:\"https://cursos.curaquantica13.com/home/course/atraindo-abundância/3\";'), ('74525fff9bf8d61e8dc94badef7989d34c3ec6c5', '20.171.206.19', '1730140177', '__ci_last_regenerate|i:1730140177;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:78:\"https://cursos.curaquantica13.com/home/course/mentoria-i-a-e-espiritualidade/5\";'), ('0bd535d2dfd1ad95c35850cd0b7c8cb8048add33', '20.171.206.19', '1730140180', '__ci_last_regenerate|i:1730140180;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('97b37b5d08576e9f4ab7bc04d39328ee2f29e0cb', '20.171.206.19', '1730140182', '__ci_last_regenerate|i:1730140182;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:80:\"https://cursos.curaquantica13.com/home/course/desprogramação-neurobiológica/1\";'), ('82dafd418f4a30f2942d11e05bef92b38ecede23', '20.171.206.74', '1730140184', '__ci_last_regenerate|i:1730140184;cart_items|a:1:{i:0;s:1:\"5\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:799;'), ('2795ad7bb7bc541e1f7d5bd2e1d4db590bfdcec8', '20.171.206.74', '1730140185', '__ci_last_regenerate|i:1730140185;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('514e112a641d2702b1429fb1cbe47e00aac4f59b', '20.171.206.74', '1730140188', '__ci_last_regenerate|i:1730140188;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:71:\"https://cursos.curaquantica13.com/home/course/jornada-atraindo-o-amor/2\";'), ('63c2bfe3f9e51fd0c19aa4b401f7f581f2e9808a', '20.171.206.74', '1730140190', '__ci_last_regenerate|i:1730140190;cart_items|a:0:{}language|s:10:\"portuguese\";theme_mode|s:10:\"dark-theme\";'), ('99ff9002d38b9f15eba4b86265a6f7ec8f24270d', '20.171.206.74', '1730140193', '__ci_last_regenerate|i:1730140193;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('68a53afb2e82f867be8dcc3bf5596c0a6150a81e', '20.171.206.74', '1730140201', '__ci_last_regenerate|i:1730140201;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:215;'), ('dfa6f41cadf1d1abfbab62531d8b0502f718eebc', '20.171.206.74', '1730140209', '__ci_last_regenerate|i:1730140209;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:40;'), ('0ed489e98446096abd42df807b5c90285e8065e3', '20.171.206.74', '1730140213', '__ci_last_regenerate|i:1730140213;cart_items|a:0:{}language|s:10:\"portuguese\";error_message|s:35:\"Nenhum valor de pesquisa encontrado\";__ci_vars|a:1:{s:13:\"error_message\";s:3:\"new\";}'), ('01ea64e4be3649b66d063ce4c389497c1eb75c19', '20.171.206.74', '1730140214', '__ci_last_regenerate|i:1730140214;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:81:\"https://cursos.curaquantica13.com/home/course/curando-minhas-feridas-emocionais/4\";'), ('49ee529ed83d67e76743fc64a91ca1635da88972', '20.171.206.74', '1730140218', '__ci_last_regenerate|i:1730140218;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('2ecbb696949ef61bb69de8c170eb9982857b9471', '54.36.149.80', '1730146660', '__ci_last_regenerate|i:1730146660;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4b6e6315378bfc787f34d33dff09b5ae72ac99bc', '51.222.253.10', '1730146661', '__ci_last_regenerate|i:1730146661;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('2f2cfff529741c4fda2c641631f8aaa3faece331', '66.249.72.34', '1730149443', '__ci_last_regenerate|i:1730149443;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('98494eb6faa911ab63f6584f55fef9d529d35e67', '66.249.72.32', '1730149444', '__ci_last_regenerate|i:1730149444;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('446dacc5b0161c8eeb63c56d1ea66b485b176b2f', '51.222.253.14', '1730150495', '__ci_last_regenerate|i:1730150494;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('c6207327309f85e452f59ebf69afd989ba3e8986', '66.249.72.34', '1730154368', '__ci_last_regenerate|i:1730154368;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0d56b901377e33544cca1d6362860323177eefa7', '47.128.31.199', '1730157766', '__ci_last_regenerate|i:1730157766;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e98e296f564cf57592c9ffa52f53f9688b05f0fa', '51.222.253.17', '1730158184', '__ci_last_regenerate|i:1730158184;language|s:7:\"english\";'), ('2f24a612ce1a611c2f343e0ef6edcca21cb3468e', '185.191.171.16', '1730166158', '__ci_last_regenerate|i:1730166158;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('912a2af9e18e1d8ca45705b9fb740fe1e46273b0', '85.208.96.196', '1730166158', '__ci_last_regenerate|i:1730166158;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d27a12a770786bcbbd86a03508ce436d8cb12f3d', '51.222.253.18', '1730171923', '__ci_last_regenerate|i:1730171923;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('eb3d84f9487f4788d5e570ba0c65d0c28fdfd1b3', '66.249.72.33', '1730176621', '__ci_last_regenerate|i:1730176621;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ca04ad38328750ae2960049106eabd13653bd76f', '66.249.72.32', '1730176622', '__ci_last_regenerate|i:1730176622;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0e69700445fdaf9d0de6c0c460dfda9584fe1afc', '66.249.72.34', '1730177116', '__ci_last_regenerate|i:1730177116;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ea2da59adc54c16cb205d530ec55989102e83c17', '66.249.72.33', '1730177169', '__ci_last_regenerate|i:1730177169;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a9bded5f51a43f24a4ed321b0bfbdc78e0855979', '66.249.72.33', '1730177701', '__ci_last_regenerate|i:1730177701;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6c413c5a522272daace91e58a52deccde028b657', '66.249.72.32', '1730177725', '__ci_last_regenerate|i:1730177725;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3952792638b28b58f518063b275aeaf0c7b477f3', '66.249.72.33', '1730178021', '__ci_last_regenerate|i:1730178021;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('baf5dad0d3dfba842191aef8bd575afc6619eb68', '66.249.72.33', '1730178166', '__ci_last_regenerate|i:1730178166;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('acb3c7c7c210ef0827ef1a7a0615c00552e6b9fc', '66.249.72.34', '1730178677', '__ci_last_regenerate|i:1730178677;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:215;'), ('755f3ef93a36a623c899763e4feed9d085e170af', '66.249.72.34', '1730178901', '__ci_last_regenerate|i:1730178901;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5e7215efb842740549ed5dc924b86f8831b3e198', '66.249.72.32', '1730179015', '__ci_last_regenerate|i:1730179015;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9de26dc50f22a31c9ce8ac145424a625ed776c4c', '66.249.72.34', '1730180101', '__ci_last_regenerate|i:1730180101;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f5d9e6473802cc11f3c78c8f205e20c37addd1c8', '66.249.72.32', '1730180528', '__ci_last_regenerate|i:1730180528;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('20450d5fdbead5d514b2ad7cacfbcd44ea18948e', '66.249.72.33', '1730180528', '__ci_last_regenerate|i:1730180528;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c71c8147438fc7a7992be799616ec5db36cb05b8', '66.249.72.32', '1730180539', '__ci_last_regenerate|i:1730180539;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9945b1c957e40d4bfab6471bd929f8dc14168d2e', '66.249.72.32', '1730180545', '__ci_last_regenerate|i:1730180545;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('c7749dc4605b210b38f3ec439eedd3b559d39787', '66.249.72.34', '1730180904', '__ci_last_regenerate|i:1730180904;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a5e2bf21a8af0ffad40729683ab3de956e42919c', '66.249.72.32', '1730181794', '__ci_last_regenerate|i:1730181794;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8eeabe85ac7d81dca9f5bbbf70c4af6daa46e186', '66.249.72.33', '1730181923', '__ci_last_regenerate|i:1730181923;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5637784b2958a43aca421f3c5fb0685fa8ebbdca', '66.249.72.32', '1730181964', '__ci_last_regenerate|i:1730181964;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('443801ed4d140605a31a132dadece8d5da95c5b6', '66.249.72.33', '1730181968', '__ci_last_regenerate|i:1730181968;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('61aeb61766538f79ad93a9d6c2ef307c26a5ff4c', '66.249.72.34', '1730182029', '__ci_last_regenerate|i:1730182029;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e3fa611461a1988420377d4ae787488e90bfae46', '66.249.72.34', '1730182095', '__ci_last_regenerate|i:1730182095;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f2016c0224addb5d9363a4d6f65778f9ce6ba9c0', '66.249.72.34', '1730182167', '__ci_last_regenerate|i:1730182167;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b0a92ec58a1f1732f917eb26c8c2766b0f55583f', '124.220.171.34', '1730182592', '__ci_last_regenerate|i:1730182592;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('759715d9b061171f2ea1e1125d11dcf072b38c51', '66.249.72.33', '1730182675', '__ci_last_regenerate|i:1730182675;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fbe716eca1a7d8737b8dbd21698636c8302851c6', '66.249.72.32', '1730182803', '__ci_last_regenerate|i:1730182803;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3f2ab82b2eb8e2d28721937f209e8b026d0baeaa', '66.249.72.32', '1730182936', '__ci_last_regenerate|i:1730182936;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e382261f1d88cdd7c82147c70418f06dc8e06c82', '66.249.72.32', '1730183096', '__ci_last_regenerate|i:1730183096;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('84454189a48f444a1bc56ef1fc7a36722e31e725', '66.249.72.34', '1730183182', '__ci_last_regenerate|i:1730183182;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('14fea4a13470b939a881a4f32b8fafcc6958bfb9', '51.222.253.4', '1730183393', '__ci_last_regenerate|i:1730183392;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('0d308e67970edd6f1600affd3c8ede4ee6d9dfaf', '66.249.72.32', '1730184046', '__ci_last_regenerate|i:1730184046;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9d3610343955d604f83aa6447045921465b4f011', '66.249.72.32', '1730184261', '__ci_last_regenerate|i:1730184261;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7d98be68a2f80d4671e4b83c51d61b4700831871', '66.249.72.34', '1730184262', '__ci_last_regenerate|i:1730184261;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2ea1ba93402eec8d23ebc034999728aaa8d57e83', '66.249.72.32', '1730186065', '__ci_last_regenerate|i:1730186065;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1a1d18114aeeff4c149e3151482e3785251bab4c', '66.249.72.34', '1730186124', '__ci_last_regenerate|i:1730186124;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f0b6af89d22e2f56b692af32bc62510fc663aa05', '51.222.253.14', '1730186426', '__ci_last_regenerate|i:1730186426;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('955ee10356727736474b46aa793c048aabd56c86', '47.128.20.36', '1730186480', '__ci_last_regenerate|i:1730186480;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ee067b18b23a4de941ddb3bbc910a6032210927c', '47.128.110.66', '1730186504', '__ci_last_regenerate|i:1730186504;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('459a7b62859d47c1b149a2295f55b9b5cd8dff18', '66.249.72.32', '1730186534', '__ci_last_regenerate|i:1730186534;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f3103cbd0eeee2ee45e237539aa8597fb9f72547', '66.249.72.32', '1730187144', '__ci_last_regenerate|i:1730187144;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7fa761840fec38699e8a53bfb6600325f0f8d7e7', '66.249.72.32', '1730187782', '__ci_last_regenerate|i:1730187782;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('11a46ca2ca823e6d09b5035523a8e81bb1a3a9fb', '66.249.72.32', '1730187787', '__ci_last_regenerate|i:1730187787;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e05b3ff14081ae65853074e80db6d7c041baec7b', '66.249.72.34', '1730188159', '__ci_last_regenerate|i:1730188159;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b2aac081fc3192cc86614b7e396a5d98c1ccac50', '66.249.72.34', '1730188159', '__ci_last_regenerate|i:1730188159;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a4b0d30178f7993805e019b12cde51c8699eaf08', '66.249.72.33', '1730188159', '__ci_last_regenerate|i:1730188159;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('81893e96cb5a430481e9af6aeacda6c2eb272c49', '66.249.72.32', '1730188196', '__ci_last_regenerate|i:1730188196;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('37fc735b0f7648ffafc13ea2bb453da5773422de', '66.249.72.32', '1730189217', '__ci_last_regenerate|i:1730189217;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d41d0ea03378017925eda1b75678de2e03c9e773', '66.249.72.32', '1730189283', '__ci_last_regenerate|i:1730189283;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2dc714be5165593d5caec6f1c29968acea6c762d', '66.249.72.32', '1730189470', '__ci_last_regenerate|i:1730189470;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('24b397de3614f74a698c118f2bd5ca8179c5cab3', '66.249.72.32', '1730189479', '__ci_last_regenerate|i:1730189479;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ce9ea2fbe72d700f9d29ad476bdf966504da08f9', '66.249.72.32', '1730189484', '__ci_last_regenerate|i:1730189484;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('383de6c39f9a867e1aeefdfb0ffd9d70c8606f9f', '66.249.72.34', '1730189523', '__ci_last_regenerate|i:1730189523;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('aab82c8f5aaf83ed682d3f2a609c6d8ca247425d', '66.249.72.33', '1730189716', '__ci_last_regenerate|i:1730189716;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:40;'), ('e2a5ba4cc61588943e90c0cc6779b02e2def5eda', '66.249.72.32', '1730189719', '__ci_last_regenerate|i:1730189719;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('aa017a344041dfce77ea1ef181138c98a11f5a86', '66.249.72.32', '1730189719', '__ci_last_regenerate|i:1730189719;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('82c5c2544522d9b94a430416d5a671a4828b9728', '66.249.72.32', '1730189722', '__ci_last_regenerate|i:1730189722;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('582a90ef42b15d6b2bee2d3abd86227b248ee4cf', '66.249.72.32', '1730189762', '__ci_last_regenerate|i:1730189762;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('865d74442c50e56055ebec894777beda30233040', '66.249.72.34', '1730189986', '__ci_last_regenerate|i:1730189986;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9adb9bbddb43b5ca73367b3fe5fa8823b8cc6a57', '66.249.72.32', '1730190015', '__ci_last_regenerate|i:1730190015;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ebdf583400acef0eb23eb5e43845cf4c23d4e16d', '66.249.72.34', '1730190252', '__ci_last_regenerate|i:1730190252;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('34af5c3ba4048a357897af8ba7e58698839efe61', '66.249.72.34', '1730190369', '__ci_last_regenerate|i:1730190369;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3fb0c685a8f750f8fade1557bcade96613181d4c', '66.249.72.33', '1730190428', '__ci_last_regenerate|i:1730190428;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9fc34f7e60f4807a2b9fd8b641362d33668c2691', '66.249.72.32', '1730190466', '__ci_last_regenerate|i:1730190466;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('01c3193ac4a38dc91708ea7424156c26b225bee8', '66.249.72.32', '1730190487', '__ci_last_regenerate|i:1730190487;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c2a08afa2faede35bd172cd0cbcc8415847101be', '51.222.253.6', '1730190510', '__ci_last_regenerate|i:1730190510;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a253d02447eda1f804eaa2f16c62e13040b35954', '66.249.72.33', '1730190669', '__ci_last_regenerate|i:1730190669;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d5e5fc9df2043bbe13d59d2338544c567653ba8e', '66.249.72.34', '1730192456', '__ci_last_regenerate|i:1730192456;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6327419bf469f1599119c52ac711e55767532849', '66.249.72.32', '1730192456', '__ci_last_regenerate|i:1730192456;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6286c2752e4efe93186e606a774758758c11e982', '66.249.72.33', '1730192545', '__ci_last_regenerate|i:1730192545;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0a3dd8221e5de4161787bef2ca57dacdf8256528', '66.249.72.32', '1730192583', '__ci_last_regenerate|i:1730192583;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('66b1b25aaa3fc0f5b4e43403c8bf45621c186f7d', '66.249.72.32', '1730192756', '__ci_last_regenerate|i:1730192756;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f60bab58414746399513b4c72d801e3f994f1ddc', '66.249.72.34', '1730192761', '__ci_last_regenerate|i:1730192761;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4a7b8625df91070b5a4da1f01cfbda71431aa145', '66.249.72.33', '1730193417', '__ci_last_regenerate|i:1730193417;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('678b2bb7c3b7e94cab7ddd243c08d6b6e511c1f6', '66.249.72.34', '1730193668', '__ci_last_regenerate|i:1730193668;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3e6a3ca64807ded6a71b303a001cdd1077e687ab', '66.249.72.33', '1730193746', '__ci_last_regenerate|i:1730193746;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4c1f1b0166fc34da4c0871853188796b366aef15', '51.222.253.15', '1730193818', '__ci_last_regenerate|i:1730193818;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('1ed5b2dd52c5695d55a5ae3d6e88d569f11ddffc', '66.249.72.33', '1730194089', '__ci_last_regenerate|i:1730194089;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5944968d1698fd1f3072b3349b9825b06594c1c0', '66.249.72.33', '1730195337', '__ci_last_regenerate|i:1730195337;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('739ecb6e0292cbfe63c242bf1c1c40e32f7e7f27', '66.249.72.34', '1730195413', '__ci_last_regenerate|i:1730195413;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('94d5b378cdb77f402621bb666a92e9c6eb04f7a2', '66.249.72.33', '1730197989', '__ci_last_regenerate|i:1730197989;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a589e3442f78025cd184eeafb970c3513f21a561', '66.249.72.34', '1730197990', '__ci_last_regenerate|i:1730197990;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:215;'), ('911c7fd635cb4018d1348d1d5604b47f8e200406', '66.249.72.34', '1730199467', '__ci_last_regenerate|i:1730199467;cart_items|a:1:{i:0;s:1:\"5\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:799;'), ('e1c00b5be60129893bd24fc88912c1a5617883b4', '51.222.253.15', '1730201541', '__ci_last_regenerate|i:1730201541;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('8d41b25e2ca50b99111338bf308ffe230994041a', '66.249.72.32', '1730202362', '__ci_last_regenerate|i:1730202362;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6220a336d292ea7254e26f8da280a40394207747', '66.249.72.34', '1730202362', '__ci_last_regenerate|i:1730202362;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('fa7f52da0eede072f51cb96a4cf2b8515e589869', '66.249.72.33', '1730202725', '__ci_last_regenerate|i:1730202725;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5c6beba1ab722a512ff4f29701b0c8df75376c18', '66.249.72.32', '1730203270', '__ci_last_regenerate|i:1730203269;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a29840d5512a5db8160e1ee687885ad9e1cc9525', '66.249.72.32', '1730204162', '__ci_last_regenerate|i:1730204162;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fba4da67b6d7590f1606a9e434b111c28480b09b', '66.249.72.32', '1730204287', '__ci_last_regenerate|i:1730204287;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e62e97b87049c5c671ed077126c56345421a13d5', '66.249.72.32', '1730204293', '__ci_last_regenerate|i:1730204293;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1e8f57bc25d6f55b74d7b16780ed50f77c192699', '66.249.72.32', '1730204542', '__ci_last_regenerate|i:1730204542;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('025f6cfd193571ec0ee8aa27c839d95fe1915a75', '66.249.72.32', '1730204545', '__ci_last_regenerate|i:1730204545;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('44bbcc7be64d6670a4ac6231bb5aa69ec4ec7d26', '66.249.72.33', '1730204890', '__ci_last_regenerate|i:1730204890;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c5fd6776e2a4f71f7f7a60430a6cc3804f417c52', '66.249.72.32', '1730205322', '__ci_last_regenerate|i:1730205322;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('85df4171d134af838d1d765512cebb705f75de2c', '51.222.253.9', '1730205600', '__ci_last_regenerate|i:1730205600;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6eeb90fda94af67ff769e1200a7fc1a391c856d5', '66.249.72.32', '1730206579', '__ci_last_regenerate|i:1730206579;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('129f8acf80fb82ad2ba41b3b00a78123cca92c24', '66.249.72.32', '1730206579', '__ci_last_regenerate|i:1730206579;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e466598db9008c5b967fd42ec730df86f63ca5aa', '66.249.72.32', '1730206826', '__ci_last_regenerate|i:1730206826;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bdf0248784046fc997b0d0bbad58e00d27e4714d', '66.249.72.34', '1730206976', '__ci_last_regenerate|i:1730206976;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('28dacc3a07f1e69b60875f4afea87af895a04a80', '66.249.72.32', '1730206992', '__ci_last_regenerate|i:1730206992;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('93d0dde071038107cc4c6cab921d17834c0c59de', '66.249.72.32', '1730207480', '__ci_last_regenerate|i:1730207480;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7f514e5d121314e12eadcaa770f716fa1e992074', '66.249.72.34', '1730208656', '__ci_last_regenerate|i:1730208656;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ce97febb130aa1af704f278461ecec4e00f2f5f5', '66.249.72.33', '1730208667', '__ci_last_regenerate|i:1730208667;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('13002d672e61b1ac891b4abc6ccdb7128318f183', '66.249.72.32', '1730208903', '__ci_last_regenerate|i:1730208903;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('07d858001e895c6169ca3b30418e6173a50c5fd3', '66.249.72.32', '1730208906', '__ci_last_regenerate|i:1730208906;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('af607161590fab82ec4716f30acee60fc1b6d1a9', '66.249.72.34', '1730209032', '__ci_last_regenerate|i:1730209032;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('edbceae90084f72e845cbeb1bfb62005342d6288', '66.249.72.33', '1730210104', '__ci_last_regenerate|i:1730210104;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('92b08543a57c4717d10715a3ab426308280689e2', '66.249.72.32', '1730210121', '__ci_last_regenerate|i:1730210121;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('55371abb6f7f72bfb2c2fa8df51cd47503aff65f', '66.249.72.32', '1730210146', '__ci_last_regenerate|i:1730210146;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3b99d45c68128597f9eed3d34f01c68d55e04344', '66.249.72.32', '1730210155', '__ci_last_regenerate|i:1730210155;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fec0378c405312151b75dace75fca374455ffdb6', '66.249.72.32', '1730210155', '__ci_last_regenerate|i:1730210155;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('63e27287adc8570595d7bd069efe227f0e2e2251', '66.249.72.33', '1730210179', '__ci_last_regenerate|i:1730210179;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('164ed2bee3beea04d33bd757f6ae3b698607b913', '66.249.72.33', '1730210882', '__ci_last_regenerate|i:1730210882;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('64671853b4ee7a4d40aeeedd9b47e1e0e723a10d', '66.249.72.32', '1730210882', '__ci_last_regenerate|i:1730210882;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('76a83e73309188e670e59d2b8b124eae760d2788', '66.249.72.33', '1730210964', '__ci_last_regenerate|i:1730210964;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('430b15865e9d05ce0827ba7ebb05129e250387a9', '66.249.72.34', '1730213276', '__ci_last_regenerate|i:1730213275;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('72649e061c38cfabc38afa54a25bb646a12dda65', '66.249.72.33', '1730213525', '__ci_last_regenerate|i:1730213525;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5d91d319e2be6eeb0cb48a40dc8d22a34493745c', '66.249.72.32', '1730213533', '__ci_last_regenerate|i:1730213533;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('24f73cb13d0413e5e014d7f1f27f105f6283a89d', '66.249.72.33', '1730213708', '__ci_last_regenerate|i:1730213708;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fd0aa5995b51c78f2ede386c1bce78a86ce49d05', '47.128.33.16', '1730215270', '__ci_last_regenerate|i:1730215270;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0464218ac496108e2e6fba19e9a4b04f42d962fa', '51.222.253.2', '1730216252', '__ci_last_regenerate|i:1730216252;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('dc746282821abfbcbef6be025f2b54b1bb4e6bd9', '66.249.72.33', '1730216986', '__ci_last_regenerate|i:1730216986;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4225b633d527364d27c0918da47a12a7c9809cdf', '66.249.72.32', '1730216986', '__ci_last_regenerate|i:1730216986;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('40c8586f6cede339cc7f91d74f1a706be6746c9e', '66.249.72.34', '1730218702', '__ci_last_regenerate|i:1730218701;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2964106130d23645931dc58e8ef9e5a88b553480', '66.249.72.33', '1730218803', '__ci_last_regenerate|i:1730218803;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('13bbfeeffc0f8d503641a3ddfce34e5f30de02cd', '66.249.72.34', '1730219703', '__ci_last_regenerate|i:1730219703;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('80ef200a8c8413eabb40587f33a715b785c2f1c4', '66.249.72.32', '1730219722', '__ci_last_regenerate|i:1730219722;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2bc03a3530b3a39fb33cc6a12becc997efc6e365', '66.249.72.34', '1730219781', '__ci_last_regenerate|i:1730219781;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('88b7207f58a4573367195bc9f93e756bdf665612', '66.249.72.32', '1730221033', '__ci_last_regenerate|i:1730221033;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a35e3c05f4d14894b6dc1a91ab32df0c908eea9c', '66.249.72.32', '1730221033', '__ci_last_regenerate|i:1730221033;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1e5c36d560363706865cb05c2d3ce3bcd5ea4938', '66.249.72.33', '1730224587', '__ci_last_regenerate|i:1730224587;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b8795fb5eeef638160b70e1174a3f2f0a12f9b44', '51.222.253.16', '1730225205', '__ci_last_regenerate|i:1730225205;cart_items|a:0:{}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:0;'), ('cd83f17586af8a1883c7717c84801a5c5402d65e', '185.191.171.12', '1730225273', '__ci_last_regenerate|i:1730225273;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4804d3de25d6ac1233686a34f76d5e5ea1b7ceca', '85.208.96.212', '1730225273', '__ci_last_regenerate|i:1730225273;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5ddb9a22242d46328e47c3e6dfd7980baca22c16', '47.128.62.63', '1730225695', '__ci_last_regenerate|i:1730225695;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('02f95428801280769b54b07543a6473c1b83c6cc', '51.222.253.19', '1730227755', '__ci_last_regenerate|i:1730227755;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4d85c9003f06b6251b376a47015d21825ca2ec5b', '51.222.253.8', '1730229234', '__ci_last_regenerate|i:1730229234;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f86f7f1deab49f400a172ae2c914c6b0e52e1d60', '85.208.96.197', '1730230146', '__ci_last_regenerate|i:1730230146;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a394abfd39a0248bbd9782f820c248d8c1954f44', '85.208.96.199', '1730230146', '__ci_last_regenerate|i:1730230146;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f31f433ebc363011f712594c9de1d0411eb1f782', '51.222.253.20', '1730230685', '__ci_last_regenerate|i:1730230685;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('a01c9bdd813a8e6ff27da00d41ad1b8cc4f20a24', '185.191.171.6', '1730230853', '__ci_last_regenerate|i:1730230853;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('21222848195a3da9daa86d664e7d1212e093056b', '199.45.155.81', '1730231386', '__ci_last_regenerate|i:1730231386;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('eaae0760cab5a5868bef87c846f4cc02e601ceb7', '199.45.155.81', '1730231395', '__ci_last_regenerate|i:1730231395;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6beb3f9ee2495562c7c84610ae823ef984214fac', '199.45.155.81', '1730231401', '__ci_last_regenerate|i:1730231401;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('392b23fe583216457625a7deabb99b8a9c5ebeb6', '199.45.155.81', '1730231405', '__ci_last_regenerate|i:1730231405;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('58008a2733c9287dd3546b54f28f48507488f894', '185.191.171.13', '1730231463', '__ci_last_regenerate|i:1730231463;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('159b449185d77ac7697a65ef21cc0496af98bfb1', '47.128.125.186', '1730231681', '__ci_last_regenerate|i:1730231681;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1fffaeb64966fd8da00a1d8fafdb2f7281a6d306', '51.222.253.10', '1730233039', '__ci_last_regenerate|i:1730233038;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c468267dedd485fb7ea3bdfb9a2fb83b54aaedd5', '185.191.171.3', '1730234375', '__ci_last_regenerate|i:1730234375;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('96d55ba36584f860e5f3e0c842dc2e47f8e8a882', '85.208.96.212', '1730234375', '__ci_last_regenerate|i:1730234375;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('720643d0c79db249389ace7b45613e3090ac363c', '85.208.96.208', '1730234950', '__ci_last_regenerate|i:1730234950;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('60858c05313ff679c5ff34a70e8cbee39e8d95c5', '66.249.72.34', '1730234966', '__ci_last_regenerate|i:1730234966;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('79a0aa2ba98de9e000502a0412f0503c792d3799', '66.249.72.32', '1730234967', '__ci_last_regenerate|i:1730234967;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f3cd0220284eb28036b1f8d88c226c4bb9db67f1', '40.77.167.184', '1730235177', '__ci_last_regenerate|i:1730235177;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1328e6133fd2725b0d47ab4a896b682146a2d731', '207.46.13.31', '1730235213', '__ci_last_regenerate|i:1730235213;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('037b118ea57616bf2db6e802530b591e73d45980', '185.191.171.16', '1730236368', '__ci_last_regenerate|i:1730236368;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fcf85fc4b1fdc1e3f7dbb19de4d98a7aeddf65fc', '54.36.148.191', '1730236609', '__ci_last_regenerate|i:1730236609;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('02ce3a64a96cceb7aabb0361d9adacd12f5654b6', '51.222.253.4', '1730236611', '__ci_last_regenerate|i:1730236611;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7d7cc861c6b475b31fca2c3e8ca2364f87fb33bf', '185.191.171.16', '1730240248', '__ci_last_regenerate|i:1730240248;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9eb0930d15f263bf3d5ef985276ca9686fa670ce', '185.191.171.5', '1730240250', '__ci_last_regenerate|i:1730240250;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0bf2576dd6ba8d31ba06d8aa94803f365de32297', '47.128.38.156', '1730240446', '__ci_last_regenerate|i:1730240446;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('afede8a64ea72523ca46c6174ebdb72767aa67d8', '51.222.253.17', '1730241113', '__ci_last_regenerate|i:1730241112;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ed4ed41ef2d1d0c2c669aec23e72466b1ba2c43e', '85.208.96.202', '1730241844', '__ci_last_regenerate|i:1730241844;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8df2005e77a4ef462d6f7c61a9ce767ddacfdeb2', '185.191.171.19', '1730243391', '__ci_last_regenerate|i:1730243391;language|s:7:\"english\";'), ('d44ae465b8cae3ea8f4c7e184644debd83939fb3', '66.249.72.33', '1730246186', '__ci_last_regenerate|i:1730246186;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cb36d1b8a8688557625958ff1aba40e24aebc3c3', '66.249.72.33', '1730246186', '__ci_last_regenerate|i:1730246186;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('c082f2a0b992d07663b1c159692b4a15606d064e', '85.208.96.212', '1730246828', '__ci_last_regenerate|i:1730246828;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('41971def426dea997f4e3f6eff726ac7fb5243f5', '85.208.96.206', '1730246829', '__ci_last_regenerate|i:1730246829;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2886a67517729ec664c150bf21b9e7eece205c2d', '85.208.96.199', '1730248088', '__ci_last_regenerate|i:1730248087;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e9e2ead28aca39a26cc221be509a7e7ab7c7e2c7', '51.222.253.20', '1730249225', '__ci_last_regenerate|i:1730249224;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b5dea871bbd1da9c94d76b0bcccc20bec52b7ff6', '47.128.125.203', '1730249619', '__ci_last_regenerate|i:1730249619;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e563858f6fafa855bd5c45f08c4d92716963dd8a', '85.208.96.207', '1730252621', '__ci_last_regenerate|i:1730252621;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6bb3a5d9bf33291b0eefd7aea83e285d604d0a31', '85.208.96.199', '1730252621', '__ci_last_regenerate|i:1730252621;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('53e5e4395dbbe5928ff5819ff18c872a9364d962', '51.222.253.10', '1730253962', '__ci_last_regenerate|i:1730253962;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('0446d27d31a477e53befae56c1c30cc4ec927126', '85.208.96.201', '1730254169', '__ci_last_regenerate|i:1730254169;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6e8955446a8d88bb9148019ec7bfa2a5a48d1933', '47.128.49.103', '1730258093', '__ci_last_regenerate|i:1730258092;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3d2dcea3e482923bbce0f2900fc009af857ab880', '85.208.96.205', '1730258727', '__ci_last_regenerate|i:1730258726;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e6b9b95e0b8422abc589a75ddd4f4329d11660fd', '185.191.171.16', '1730258727', '__ci_last_regenerate|i:1730258727;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('ea02150a1680db17d98a0570ebf834ca8172aa29', '51.222.253.16', '1730259281', '__ci_last_regenerate|i:1730259281;layout|s:4:\"list\";language|s:7:\"english\";'), ('44e686275581cdc375e2f9669c91d7c8d1adc76c', '185.191.171.7', '1730263915', '__ci_last_regenerate|i:1730263915;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6eb3f2ea7de83b14058f014061feae756d167bac', '185.191.171.19', '1730263915', '__ci_last_regenerate|i:1730263915;language|s:7:\"english\";'), ('71658ac4b633bf22604bf30caa98a536515fdf3b', '51.222.253.5', '1730264035', '__ci_last_regenerate|i:1730264035;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('cf6aa37fdbe9f8c2ff916a9f8c51412427289b7c', '185.191.171.18', '1730264404', '__ci_last_regenerate|i:1730264403;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cc71884b10e2dd0b600f6219bb487a664c7d20cd', '47.128.112.176', '1730266156', '__ci_last_regenerate|i:1730266156;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6edaabd1bc22cbcbe3d1363f8d0520aff0a7f29c', '185.191.171.1', '1730267639', '__ci_last_regenerate|i:1730267639;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b0c44aa2f16628bb5b6ed0478bd5b28bd955085c', '85.208.96.194', '1730267639', '__ci_last_regenerate|i:1730267639;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('00c7052a6601e556324c5ce5341c1c2244df4ce7', '206.189.2.13', '1730267932', '__ci_last_regenerate|i:1730267932;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bfd62d754223b709f99044f2aa468b82e49e5d49', '206.189.2.13', '1730267935', '__ci_last_regenerate|i:1730267935;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a7a2b87aa7fd6d2488069f9de890fb905921d83f', '206.189.2.13', '1730267936', '__ci_last_regenerate|i:1730267936;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('33b8040ac3bc0a980e56ca309515e06434232973', '206.189.2.13', '1730267936', '__ci_last_regenerate|i:1730267936;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('09e6b4fb74dd460614be9f1508dcc0b6a894ee4c', '206.189.2.13', '1730267937', '__ci_last_regenerate|i:1730267937;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1c04ced5354276dc9c4d6aaf8c774ebb5501ac7e', '206.189.2.13', '1730267937', '__ci_last_regenerate|i:1730267937;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c7ae494b3ba265107496fdcbc0c1c7166434c46c', '206.189.2.13', '1730267938', '__ci_last_regenerate|i:1730267938;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dda49e0844d7fc01211cac60e44bb293f8ec071a', '206.189.2.13', '1730267938', '__ci_last_regenerate|i:1730267938;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('82c446327476aa259bba7718724a4cf8ea69af09', '206.189.2.13', '1730267939', '__ci_last_regenerate|i:1730267939;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cb77f4a76a2ba304690a6497f881006b3cf9fc6f', '206.189.2.13', '1730267939', '__ci_last_regenerate|i:1730267939;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3df84f35ea72dfb41d6d3bbaa6f98f1ab719d7ba', '206.189.2.13', '1730267940', '__ci_last_regenerate|i:1730267940;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5dd7401e53d95fde65f5596a565ab0a3b3f6a5ac', '206.189.2.13', '1730267941', '__ci_last_regenerate|i:1730267941;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4502b00ad376fd62f31f4df2160686415a0e26c5', '206.189.2.13', '1730267942', '__ci_last_regenerate|i:1730267942;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4507e9b41e2de9e20a06899e716d692759089415', '206.189.2.13', '1730267943', '__ci_last_regenerate|i:1730267943;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('83b8496b436947930c429f1a292244c2931125c1', '206.189.2.13', '1730267943', '__ci_last_regenerate|i:1730267943;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a6a7f4a125f4638db735cf22f30794ca947243e6', '206.189.2.13', '1730267944', '__ci_last_regenerate|i:1730267944;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('af84651b2429e42d34918987d4f68ae0f6230daa', '206.189.2.13', '1730267944', '__ci_last_regenerate|i:1730267944;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3f8d409cb86af326a456421e1967d38fb91300c0', '206.189.2.13', '1730267945', '__ci_last_regenerate|i:1730267945;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3489874dc8329ecdad185cc4e8ae7e014fc348e2', '206.189.2.13', '1730267946', '__ci_last_regenerate|i:1730267946;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3fd4a73f6019e3f0c016acc3e055b25d17ff14e7', '206.189.2.13', '1730267946', '__ci_last_regenerate|i:1730267946;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('81d22aa41348d5c92d11bdc318d48c958921ebbc', '206.189.2.13', '1730267946', '__ci_last_regenerate|i:1730267946;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0769b5db61f097f86bde1fed9f5f8562199fd024', '206.189.2.13', '1730267947', '__ci_last_regenerate|i:1730267947;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8bf1bafe989b53e9d884352695fc2f4e8f3b1fbb', '206.189.2.13', '1730267947', '__ci_last_regenerate|i:1730267947;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('786c5bfa05696f02822995c3ff3367a779cd6dc7', '206.189.2.13', '1730267948', '__ci_last_regenerate|i:1730267948;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b23fdb216be1c3622d7798fcda8cb315ec837ab3', '206.189.2.13', '1730267948', '__ci_last_regenerate|i:1730267948;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('809ad552c81e9ab30d6173611ff00de99701e357', '206.189.2.13', '1730267950', '__ci_last_regenerate|i:1730267950;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('614c020bdbc2469f21097f20772f70b814905062', '206.189.2.13', '1730267950', '__ci_last_regenerate|i:1730267950;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d3f584789e722d6a23234f67709d8c009eab3017', '206.189.2.13', '1730267951', '__ci_last_regenerate|i:1730267951;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2df8b049444eed7ad59cd410e733b8be46d544d1', '206.189.2.13', '1730267951', '__ci_last_regenerate|i:1730267951;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3f31ed869ad24f3be536b9f8c77f00349857dab0', '206.189.2.13', '1730267952', '__ci_last_regenerate|i:1730267952;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('69bae85eda1277c7f51a820c67d59ed90af0c8bc', '206.189.2.13', '1730267952', '__ci_last_regenerate|i:1730267952;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('057723ec3175034a133ec2db24260774271a42e1', '185.191.171.12', '1730268015', '__ci_last_regenerate|i:1730268015;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5576a5d3cdcb704159b53295a3f798e94a4d63a4', '85.208.96.195', '1730269597', '__ci_last_regenerate|i:1730269597;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ac5d4a7bb662dd61a551c0bfa62132ad7fd7b86d', '85.208.96.209', '1730269710', '__ci_last_regenerate|i:1730269710;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9eacfacd9bdfa811565d929c15844c252787160d', '85.208.96.201', '1730272344', '__ci_last_regenerate|i:1730272344;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dbf1c410b3df901eb3e54aa9b75f454b1d35f917', '185.191.171.14', '1730272345', '__ci_last_regenerate|i:1730272345;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('266ed70768eccfb66c2f9b17c8ba137ac94dc9c0', '47.128.33.236', '1730273617', '__ci_last_regenerate|i:1730273617;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('aa62c5886b151034ae474582e145d215709589db', '51.222.253.7', '1730273946', '__ci_last_regenerate|i:1730273946;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('f108d683213b6a792aea5df4964e5622c9ca2be5', '85.208.96.206', '1730275076', '__ci_last_regenerate|i:1730275076;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3e0af290f0d91349135a9b18e5f6ca0d229116cd', '85.208.96.206', '1730277186', '__ci_last_regenerate|i:1730277186;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c0ea695da5551016b6d8ad099f0ca8182811b381', '85.208.96.196', '1730277186', '__ci_last_regenerate|i:1730277186;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f1c0fa235d69f58053742a89fe46ec14ab77d44c', '185.191.171.2', '1730277673', '__ci_last_regenerate|i:1730277673;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8ad7408f4b08322c77920034c23b779c795c260c', '209.38.248.17', '1730278191', '__ci_last_regenerate|i:1730278191;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b4c87cb6c355308ec68cc746c41c6d5dab517b17', '209.38.248.17', '1730278195', '__ci_last_regenerate|i:1730278195;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b9369aec0f27b423c92475ad2fcc626f04656542', '209.38.248.17', '1730278195', '__ci_last_regenerate|i:1730278195;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9f71f61e6e2338f035d944e84f079eecec60c43c', '209.38.248.17', '1730278196', '__ci_last_regenerate|i:1730278196;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('267e46e9240cb008c4983b5414a67bb9469f1523', '209.38.248.17', '1730278196', '__ci_last_regenerate|i:1730278196;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c7b26597a3bf5cb3df098de3cb6a642a4408da1a', '209.38.248.17', '1730278197', '__ci_last_regenerate|i:1730278197;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1bdb3952c19dd22dd5653f3cb981dfe60ed0c08c', '209.38.248.17', '1730278197', '__ci_last_regenerate|i:1730278197;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d448536bea22c38f6b08432cdca3d8f2a46a7c4b', '209.38.248.17', '1730278198', '__ci_last_regenerate|i:1730278198;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e1c7bf9a066aa3b2dd2db3e57ea19bbfc53b2f20', '209.38.248.17', '1730278198', '__ci_last_regenerate|i:1730278198;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2c4357fff3126d8a3b9a2c5239a6b0b09dd44f50', '209.38.248.17', '1730278199', '__ci_last_regenerate|i:1730278199;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('725a01c6e2644ad2d9d906c50fa4279a848720e2', '209.38.248.17', '1730278199', '__ci_last_regenerate|i:1730278199;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('018eb69f8b973779f48b5cb413db9ada8a234c5e', '209.38.248.17', '1730278200', '__ci_last_regenerate|i:1730278200;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ef0f88b72b0504c43b4421e3988f0a93d7a6259b', '209.38.248.17', '1730278202', '__ci_last_regenerate|i:1730278202;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f11304765c74764a772523ec911e4879caa20711', '209.38.248.17', '1730278203', '__ci_last_regenerate|i:1730278203;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('23715338863e9db349f3e9cd80e5049a38fc8ecd', '209.38.248.17', '1730278203', '__ci_last_regenerate|i:1730278203;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d45ed2e871fd80484a4d406fdbccda7df0dce776', '209.38.248.17', '1730278204', '__ci_last_regenerate|i:1730278204;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('512d9ce64545f343e6abc240f3233e16beba0330', '209.38.248.17', '1730278204', '__ci_last_regenerate|i:1730278204;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('87dbea674ceb0f59739f6f8f655069d3264c066f', '209.38.248.17', '1730278205', '__ci_last_regenerate|i:1730278205;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f71ef940eb7abdc20f53925cedc8d9021108c25f', '209.38.248.17', '1730278206', '__ci_last_regenerate|i:1730278206;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3025cfc6760ba366c560542d533dd2de5e87c540', '209.38.248.17', '1730278206', '__ci_last_regenerate|i:1730278206;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('61fbd4dd54383630c596e24c4d0ba1be6496b957', '209.38.248.17', '1730278207', '__ci_last_regenerate|i:1730278207;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4fcfbb0cb45cea28220be9a86782741c137e63e8', '209.38.248.17', '1730278207', '__ci_last_regenerate|i:1730278207;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('73ca7e9c25b6d31215fdea9465efd4708117f9d8', '209.38.248.17', '1730278208', '__ci_last_regenerate|i:1730278208;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('02abb0956438b4ad4a5d03f325d693aed493f704', '209.38.248.17', '1730278208', '__ci_last_regenerate|i:1730278208;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('03af26caddd8a82dd6b24de1f00e1235e1a9df7b', '209.38.248.17', '1730278209', '__ci_last_regenerate|i:1730278209;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1e66428c8e5714be4b3547cd5ab15c1d4318af05', '209.38.248.17', '1730278210', '__ci_last_regenerate|i:1730278210;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b527657b62621835d08070db1ede8b821ba59e47', '209.38.248.17', '1730278210', '__ci_last_regenerate|i:1730278210;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b5ae2df67a3ae0424c2039f14e4f0ecda238d440', '209.38.248.17', '1730278211', '__ci_last_regenerate|i:1730278211;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('02aede5761e529132be15307a30d7b32b55f88db', '209.38.248.17', '1730278211', '__ci_last_regenerate|i:1730278211;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('874892fd694d9c7bc6fc3c6019e9bd4837ba6425', '209.38.248.17', '1730278212', '__ci_last_regenerate|i:1730278212;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('01e760b235d78407ae7064d906b553f1f66a39b2', '47.128.37.68', '1730280779', '__ci_last_regenerate|i:1730280779;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fad310a24b32a1c93630a8127030de8820b6076d', '51.222.253.16', '1730281584', '__ci_last_regenerate|i:1730281584;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('851e11d57f6b92e9d58a01b23c17341d16a8652c', '51.222.253.10', '1730281586', '__ci_last_regenerate|i:1730281586;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('feab5d85026673d71095877532fbc2f3f35ec030', '66.249.72.32', '1730284665', '__ci_last_regenerate|i:1730284665;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fdef5380d3f7a33c23f3f1bf885780260f26b5ea', '66.249.72.33', '1730284665', '__ci_last_regenerate|i:1730284665;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5d263549e6754d4d43313208e08e3aea7b3b03f1', '66.249.72.34', '1730284686', '__ci_last_regenerate|i:1730284686;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fe03d3d8c052486182efc98e2bedddccbd80ea9c', '66.249.72.32', '1730285175', '__ci_last_regenerate|i:1730285175;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('544f5873262720a7fac3cba4fdfe6e4fee15397c', '66.249.72.33', '1730285385', '__ci_last_regenerate|i:1730285385;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1d42a7c7b08c8f1a5e09b948d89840eff8cad59d', '66.249.72.33', '1730285654', '__ci_last_regenerate|i:1730285654;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f275b3496e32ec126293a8a293f2bd08b74abab6', '66.249.72.32', '1730285661', '__ci_last_regenerate|i:1730285661;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3a842954761ea981829294f1355da7299a51a25b', '66.249.72.32', '1730285695', '__ci_last_regenerate|i:1730285695;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9e7661016e91b59c2fb5c756710a42096070dced', '66.249.72.33', '1730285719', '__ci_last_regenerate|i:1730285719;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c530d5d739c2f1afcd9aacd314f16808eea2596d', '66.249.72.33', '1730286183', '__ci_last_regenerate|i:1730286183;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ffec8f7c714ad14a4f9aab780849030a7dd80dbe', '47.128.36.22', '1730286203', '__ci_last_regenerate|i:1730286203;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f97d1e1945074af30766717baae9bcb7d76475c6', '66.249.72.32', '1730286246', '__ci_last_regenerate|i:1730286246;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fa73ff98f391b88a106b9c4af50828749a813f1e', '66.249.72.32', '1730286252', '__ci_last_regenerate|i:1730286252;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e9ca6c611e5dc5b34bf9e756f9a913cb60bf190a', '66.249.72.33', '1730287044', '__ci_last_regenerate|i:1730287044;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('583ebebd638a4125c17030eef337b7994f1124c7', '66.249.72.33', '1730287377', '__ci_last_regenerate|i:1730287377;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7af5ec8d7518b964827e2cb38b3cfbb172176991', '66.249.72.32', '1730287391', '__ci_last_regenerate|i:1730287391;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('95ef3ab6864ea562599cc1f8b88a23e6891cb66a', '66.249.72.33', '1730287701', '__ci_last_regenerate|i:1730287701;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('39287675a2d57388df21ba69b948962a483b268f', '66.249.72.34', '1730287942', '__ci_last_regenerate|i:1730287941;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('d7f76f0312a9fdd293712d1782d7775a74fa651d', '66.249.72.32', '1730288886', '__ci_last_regenerate|i:1730288886;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('15f5d733b9b6698a25cf9426356c31586d947978', '66.249.72.33', '1730288886', '__ci_last_regenerate|i:1730288886;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('94e5fb838312cbb94e3901dc660495a900ec8c78', '66.249.72.34', '1730289367', '__ci_last_regenerate|i:1730289367;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('da8062c9449c0f8eb22d19272cfa73bc7b3714b0', '66.249.72.33', '1730289477', '__ci_last_regenerate|i:1730289477;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cf26f24493543a74c2955e008b6dccbef5648ff3', '66.249.72.33', '1730290027', '__ci_last_regenerate|i:1730290027;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cf2e2c2388e532cc9ad496237f495cf38d5a6457', '193.70.81.99', '1730290644', '__ci_last_regenerate|i:1730290644;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b5b78e54ae693d173dd0514020a27da487c9dedd', '193.70.81.99', '1730290647', '__ci_last_regenerate|i:1730290647;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('19ec445dfe7213e77997024854ab3fd75ad6dcf4', '193.70.81.99', '1730290649', '__ci_last_regenerate|i:1730290649;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6b99f0eea1291cbfcc4626e1ce6a52a70e733936', '66.249.72.33', '1730292615', '__ci_last_regenerate|i:1730292615;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('2dea31d5e367cb5b1f5dcab2eebd45a58fd7bd16', '66.249.72.32', '1730292615', '__ci_last_regenerate|i:1730292615;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a69c73ede1f455e5f5df050081a454c5bc21fa56', '47.128.29.143', '1730294270', '__ci_last_regenerate|i:1730294269;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('482671bf4e00fbef2dae346b1014b733171a3c85', '66.249.72.34', '1730294842', '__ci_last_regenerate|i:1730294842;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e8d330d4109679c438277285f6b17717a90d7a22', '51.222.253.3', '1730295438', '__ci_last_regenerate|i:1730295438;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4a2a47bf56186b6402951b05445315e3b799f6d4', '85.246.162.116', '1730318017', '__ci_last_regenerate|i:1730295593;cart_items|a:0:{}language|s:10:\"portuguese\";custom_session_limit|i:1729971224;user_id|s:2:\"11\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:38:\"Nina Sicilia  Rentroia Prieto Teixeira\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";'), ('0db78fc7804586b4205b38325123e7f5154d4174', '35.159.117.157', '1730301059', '__ci_last_regenerate|i:1730301059;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0ff7ef5443cd4f829233d4ae4b4f9b746805bdc2', '47.128.56.107', '1730301145', '__ci_last_regenerate|i:1730301145;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d60c801a604baedd598cb1518aad38a917382f5a', '51.222.253.14', '1730301764', '__ci_last_regenerate|i:1730301764;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dfe4d015f51bb48035ef0ab54247c9ad9cc5ca7a', '139.59.136.184', '1730307711', '__ci_last_regenerate|i:1730307711;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('40d9376d8be17fd13a395e7a52f316b6607cbe22', '139.59.136.184', '1730307714', '__ci_last_regenerate|i:1730307714;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5f4d2f05f0268896eeae30d6696a68af9ec617fd', '139.59.136.184', '1730307715', '__ci_last_regenerate|i:1730307715;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4459c81f0a1ce5fc606bbac7c9f1f537c7ee95eb', '139.59.136.184', '1730307716', '__ci_last_regenerate|i:1730307716;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5bd4a2984e91fcc8050b17b1b90dfd7dabf57d0a', '139.59.136.184', '1730307716', '__ci_last_regenerate|i:1730307716;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('29f0cd4f58a1af4b75716829e693a4ac58ed73a8', '139.59.136.184', '1730307717', '__ci_last_regenerate|i:1730307717;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b5a6578ca304e072fb27373aa422ef71f5d24501', '139.59.136.184', '1730307717', '__ci_last_regenerate|i:1730307717;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2077a27f5c0e8ffb5c6ae9b12edd6e6680275038', '139.59.136.184', '1730307718', '__ci_last_regenerate|i:1730307718;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fe568827aecc23391a145997eef5003cbc85707b', '139.59.136.184', '1730307718', '__ci_last_regenerate|i:1730307718;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('db0be34526d155f87a2752df111e548cd1c12dc7', '139.59.136.184', '1730307718', '__ci_last_regenerate|i:1730307718;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cb003de6e0b34af22b89a3f95ecf812f9e04b2d5', '139.59.136.184', '1730307719', '__ci_last_regenerate|i:1730307719;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3990e541e38a2707f9453d049345f1053b5310a1', '139.59.136.184', '1730307720', '__ci_last_regenerate|i:1730307720;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bb3e35a9fb9cc0ea25725aae96bf71cb78d79f35', '139.59.136.184', '1730307722', '__ci_last_regenerate|i:1730307722;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('38cb7ce016b3440c87a489545238cc7cb84b250a', '139.59.136.184', '1730307722', '__ci_last_regenerate|i:1730307722;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ae0e75019985087ff00b345c24d832f4fe10aaf5', '139.59.136.184', '1730307723', '__ci_last_regenerate|i:1730307723;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('751be251efe3ca9c40c1f0d0d36de60724dc80f7', '139.59.136.184', '1730307723', '__ci_last_regenerate|i:1730307723;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c6f4a483f1463b56c18f75b3b05b9576199339e8', '139.59.136.184', '1730307724', '__ci_last_regenerate|i:1730307724;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('23edd38ef31348bed7c18dcf3d7d85aa10956236', '139.59.136.184', '1730307724', '__ci_last_regenerate|i:1730307724;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('022a62918f63113101427e99a9f73e74eef23828', '139.59.136.184', '1730307725', '__ci_last_regenerate|i:1730307725;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9ef21d473dee42c83930e36ac29e135fc6a549a1', '139.59.136.184', '1730307725', '__ci_last_regenerate|i:1730307725;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('96a9e2ee21b8f91cb82f61b35438462880aece9d', '139.59.136.184', '1730307726', '__ci_last_regenerate|i:1730307726;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1de4f1ab9303f31974fb57de23d7c1e799ea256a', '139.59.136.184', '1730307726', '__ci_last_regenerate|i:1730307726;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f932fd8fdba608207f26c50c61f5491d5e46f66a', '139.59.136.184', '1730307727', '__ci_last_regenerate|i:1730307727;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4d2669d8f083bfa4b0b7f847342038748c501e27', '139.59.136.184', '1730307727', '__ci_last_regenerate|i:1730307727;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f86ffaacfea34737bf6dbd7be3370459c7a98646', '139.59.136.184', '1730307728', '__ci_last_regenerate|i:1730307728;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ee668797e95387266d02357b3f7877f47466c9c6', '139.59.136.184', '1730307729', '__ci_last_regenerate|i:1730307729;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('23fe47f1ad986eb2df1e066e3bbad4dd8efe7a51', '139.59.136.184', '1730307729', '__ci_last_regenerate|i:1730307729;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5076d281ca05c84071abf6248e72a2810e245a53', '139.59.136.184', '1730307730', '__ci_last_regenerate|i:1730307730;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f346745e1d9db47528de9a22e99f0df86fe26b4f', '139.59.136.184', '1730307731', '__ci_last_regenerate|i:1730307731;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f4f50d320b7a78e5f98e84825652fc1afbf9d24f', '139.59.136.184', '1730307731', '__ci_last_regenerate|i:1730307731;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('cce61b2650279f0f59ac746386d6c0e295bde1f1', '139.59.136.184', '1730307732', '__ci_last_regenerate|i:1730307732;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('27c1f847e522f135e02e48c439e311f7f62a4654', '147.182.149.75', '1730309137', '__ci_last_regenerate|i:1730309137;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c3705ddf90502bbc5a0bfc2cdfaa4196c479f3bf', '147.182.149.75', '1730309139', '__ci_last_regenerate|i:1730309139;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2fa74c5f89a9c28d57b177a172b567ce0b5716e3', '147.182.149.75', '1730309139', '__ci_last_regenerate|i:1730309139;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('297d808ac6ecc96048dcb7045f0c7405d49af74d', '147.182.149.75', '1730309139', '__ci_last_regenerate|i:1730309139;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a8cf9c8aed885c758745110001faa81868350e5b', '147.182.149.75', '1730309140', '__ci_last_regenerate|i:1730309140;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a7c8d03f2ec6b2ce7bf564b57ab561b6730638ee', '147.182.149.75', '1730309140', '__ci_last_regenerate|i:1730309140;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('115fc93e230f8ad6799b489e79256a4d69f11572', '147.182.149.75', '1730309140', '__ci_last_regenerate|i:1730309140;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e51f2bd33d1e74451521a3a477971fba3d29879a', '147.182.149.75', '1730309140', '__ci_last_regenerate|i:1730309140;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('389b9a9bb59a1b29342ae252267bc93afa9424bd', '147.182.149.75', '1730309141', '__ci_last_regenerate|i:1730309141;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c78ef9593456355d6ba06063707b7d6bcc45e5f5', '147.182.149.75', '1730309141', '__ci_last_regenerate|i:1730309141;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('28b3820349b4e4d5258d8051b8bf916f8a7e1296', '147.182.149.75', '1730309141', '__ci_last_regenerate|i:1730309141;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('dbddd3544e838d0c41af5afedf2c1832bae806d2', '147.182.149.75', '1730309142', '__ci_last_regenerate|i:1730309142;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('83b8e63395d5f6956b23dd1b04357a42e61a6a6d', '147.182.149.75', '1730309143', '__ci_last_regenerate|i:1730309142;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2e098c4ce2b24fb75c29f1a0d94dc669507ce1ce', '147.182.149.75', '1730309143', '__ci_last_regenerate|i:1730309143;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('0f897635b3aea13f99f4adc0ccf0c58bdd8a3729', '147.182.149.75', '1730309143', '__ci_last_regenerate|i:1730309143;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('50362cb64884ff25eb41e1abad21e1ae61d2f208', '147.182.149.75', '1730309143', '__ci_last_regenerate|i:1730309143;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8c75d9e0bd39a92e0334513a890b3d63570d2c38', '147.182.149.75', '1730309144', '__ci_last_regenerate|i:1730309144;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a7e7aee4470f486754b4ff0a01a887d7b7411065', '147.182.149.75', '1730309144', '__ci_last_regenerate|i:1730309144;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fadc4f2a45fe114e9c825ea44f3d9de89877e78f', '147.182.149.75', '1730309144', '__ci_last_regenerate|i:1730309144;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5d2d57440a94e8cdaf56496c56a998987b2f8f62', '147.182.149.75', '1730309144', '__ci_last_regenerate|i:1730309144;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a0839c08bd7902b7a7ea29f9da392d215087601d', '147.182.149.75', '1730309145', '__ci_last_regenerate|i:1730309145;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f2f5aa4558c366af10e9ab189711af437e1be9a7', '147.182.149.75', '1730309145', '__ci_last_regenerate|i:1730309145;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6c36d18fd54aa4c195eb2f2a7296d2416e277905', '147.182.149.75', '1730309145', '__ci_last_regenerate|i:1730309145;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fdafc7a1daf919a0f4d15ef478fffbce47e44225', '147.182.149.75', '1730309145', '__ci_last_regenerate|i:1730309145;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b2e9b297282ff1f5895b7c4cdb8c475b90559206', '147.182.149.75', '1730309146', '__ci_last_regenerate|i:1730309146;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8c065102cd708d5ac52954a6abe27b3d945b2f24', '147.182.149.75', '1730309147', '__ci_last_regenerate|i:1730309147;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ea46d8d023a0271303bee168a4267f32e4fa5c61', '147.182.149.75', '1730309147', '__ci_last_regenerate|i:1730309147;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('373bab27ebcd6c4d0945228fbb92ed8d30850c0b', '147.182.149.75', '1730309148', '__ci_last_regenerate|i:1730309148;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('68481821269b3f6d357b8b489d9030e2c472a893', '147.182.149.75', '1730309148', '__ci_last_regenerate|i:1730309148;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fe0d9de421ed5fe4a9aab3e5a4a12bb3e549fb1d', '147.182.149.75', '1730309148', '__ci_last_regenerate|i:1730309148;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7f77b03afa0ce77cc61e91f329d7b595f071d5ce', '147.182.149.75', '1730309149', '__ci_last_regenerate|i:1730309148;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5909168629dc4aa8ca5716559109ccd7071c2b4a', '147.182.149.75', '1730309149', '__ci_last_regenerate|i:1730309149;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ab54d0ab6f3d09f82a635baa3e7d443423f7f4d5', '147.182.149.75', '1730309149', '__ci_last_regenerate|i:1730309149;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('52d6b92797f6233989f84df1fb1d57f08e021330', '147.182.149.75', '1730309149', '__ci_last_regenerate|i:1730309149;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('73281125a543557365aaae6bc952d670433394d4', '147.182.149.75', '1730309149', '__ci_last_regenerate|i:1730309149;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('06442da09c91af50aaf5c09759633f11bb72dd7f', '147.182.149.75', '1730309150', '__ci_last_regenerate|i:1730309150;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b5b8a06d5d9c2974283994d64dc71c568faae891', '147.182.149.75', '1730309150', '__ci_last_regenerate|i:1730309150;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('49c2efb7d4b548ba2088eb47aeb407402bd7a53d', '147.182.149.75', '1730309150', '__ci_last_regenerate|i:1730309150;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('156e3bf4a72c3c94becf87a0090175e1068d00e8', '147.182.149.75', '1730309151', '__ci_last_regenerate|i:1730309151;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d46a688db10f49395b0b8048f2c7a12206eb679c', '147.182.149.75', '1730309151', '__ci_last_regenerate|i:1730309151;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ad3b2baaefa4403f19ee93fa39ac8e83d4e9bc88', '147.182.149.75', '1730309151', '__ci_last_regenerate|i:1730309151;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6b77afcea92e92060673aa9f226d1b1b652334ae', '147.182.149.75', '1730309152', '__ci_last_regenerate|i:1730309152;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ba3c172c5d5a91504f6649d71971d88d6f178a14', '147.182.149.75', '1730309152', '__ci_last_regenerate|i:1730309152;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a51d59079a041853ef262aa01c7cc8cc758a042b', '147.182.149.75', '1730309152', '__ci_last_regenerate|i:1730309152;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f9c1fb301cc295cbc864a7e1ad46b039e44cf3f0', '147.182.149.75', '1730309153', '__ci_last_regenerate|i:1730309153;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d307a1acb0b49ea8e06a0efb9538e2e78a25e4fa', '66.249.72.34', '1730311207', '__ci_last_regenerate|i:1730311206;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('67cb0a2bfdef7d8dcb80be2f25213770dab47c46', '66.249.72.32', '1730311207', '__ci_last_regenerate|i:1730311207;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1edf6ea2c5f631fb04c453f069275d167e0c8455', '66.249.72.33', '1730311267', '__ci_last_regenerate|i:1730311267;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1e1652ba91053f278f9a4f57761172ca2a1295ad', '66.249.72.32', '1730311395', '__ci_last_regenerate|i:1730311395;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('debafa59738fbbbaaa1cc74d14780a07e709e879', '51.222.253.20', '1730311582', '__ci_last_regenerate|i:1730311582;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('53970db421ac03b009e997886c0eec1133aec8bf', '66.249.72.34', '1730311632', '__ci_last_regenerate|i:1730311632;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1f9c819b4d5ef91f0f3b50100cde271c3e81ee50', '66.249.72.32', '1730311644', '__ci_last_regenerate|i:1730311644;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f3568b0fb3a690ee70c75391290093c106c5d1b1', '66.249.72.34', '1730311760', '__ci_last_regenerate|i:1730311760;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a31909b0e8b95f55ecbdf9a6d9d89c75a311fb28', '66.249.72.34', '1730311797', '__ci_last_regenerate|i:1730311797;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('17112eb67b3d3715327d59a004d6c3fa096f76ab', '66.249.72.33', '1730311867', '__ci_last_regenerate|i:1730311867;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:40;'), ('861cdb6febe2285cfc95e70f23fe0ce0b6daba61', '66.249.72.33', '1730311987', '__ci_last_regenerate|i:1730311986;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('e2b8e1cc7e7fc30b8aa43d0eaba2973a316418f1', '66.249.72.34', '1730312565', '__ci_last_regenerate|i:1730312565;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b0751e0907d8cb57d745bd71732f483bb0558596', '66.249.72.32', '1730313078', '__ci_last_regenerate|i:1730313078;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('03d8673de654ce37949ea090a0c813ba6ec41c60', '66.249.72.34', '1730313144', '__ci_last_regenerate|i:1730313144;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c041afa58510202d867682f7883fe959f1a6d894', '66.249.72.34', '1730315530', '__ci_last_regenerate|i:1730315530;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f8eede771cb577c2e49c091cac4014ab347b2b53', '40.77.167.184', '1730321321', '__ci_last_regenerate|i:1730321321;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('503cf8faf1c9d3504f7fbbaa324fc60528a7017d', '157.55.39.49', '1730321332', '__ci_last_regenerate|i:1730321332;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('854205ebb54dd3ce5c09636633ce4d099c196764', '177.81.112.109', '1730321442', '__ci_last_regenerate|i:1730321441;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a946d98a3885ec99077e9f389b89f1dd4e378af1', '47.128.40.130', '1730332486', '__ci_last_regenerate|i:1730332486;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6003733050453a3d2325aa1ba68ff20b5c9db6bf', '54.36.148.65', '1730340220', '__ci_last_regenerate|i:1730340220;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8e76a4e7bf45321a15c77c8d40292679b3c3cee8', '51.222.253.14', '1730340221', '__ci_last_regenerate|i:1730340221;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('807fff4a0a009fff6c3be833a4cafcc010a12a90', '188.166.64.236', '1730344707', '__ci_last_regenerate|i:1730344706;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8c965d9596b41c24ed7c9672bd763c25ae5d6d20', '188.166.64.236', '1730344710', '__ci_last_regenerate|i:1730344710;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4c22a759b1ee67309854312525a85827f2af5a22', '135.181.74.243', '1730351454', '__ci_last_regenerate|i:1730351454;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('9b494314e042d9b9078db468779f2a07f4d7fb46', '135.181.74.243', '1730351462', '__ci_last_regenerate|i:1730351462;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('e53c2ae42567f0a436deca05ab1c247cf28a9c9b', '135.181.74.243', '1730351470', '__ci_last_regenerate|i:1730351470;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('0d120854acd12f83309454b146d89ebccd324994', '135.181.74.243', '1730351476', '__ci_last_regenerate|i:1730351476;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('3eabde66e71143cf992a2fa23927b6158003756f', '135.181.74.243', '1730351485', '__ci_last_regenerate|i:1730351485;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('bb5361ffe25b3b5d20c7afc3f665bf7d2895efc2', '135.181.74.243', '1730351497', '__ci_last_regenerate|i:1730351497;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('b2b34d10d9996fac54af427ab5710e5ad7f046cd', '51.222.253.2', '1730355595', '__ci_last_regenerate|i:1730355595;cart_items|a:0:{}language|s:10:\"portuguese\";layout|s:4:\"list\";'), ('b0959b04371225941f1384f265b02bacca2c3f02', '20.171.206.164', '1730355972', '__ci_last_regenerate|i:1730355972;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('8d38f04662b697ffc1155f708e41b18ed6eb6d08', '20.171.206.59', '1730357009', '__ci_last_regenerate|i:1730357009;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('1353a38aee93d40f41d99477f9f60d9253e870f8', '20.171.206.210', '1730358209', '__ci_last_regenerate|i:1730358209;cart_items|a:0:{}language|s:10:\"portuguese\";theme_mode|s:10:\"dark-theme\";'), ('2993c5311dcd40e20a06bb1bea46feeb2ea31f5b', '20.171.206.210', '1730358214', '__ci_last_regenerate|i:1730358214;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:78:\"https://cursos.curaquantica13.com/home/course/mentoria-i-a-e-espiritualidade/5\";'), ('cf327d4151cfa7024821ebe6725af0b6c73f4a02', '20.171.206.186', '1730358217', '__ci_last_regenerate|i:1730358216;cart_items|a:1:{i:0;s:1:\"2\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:40;'), ('1321007e99b20d4954a1234fefe42099779d5ac9', '20.171.206.186', '1730358220', '__ci_last_regenerate|i:1730358220;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:68:\"https://cursos.curaquantica13.com/home/course/atraindo-abundância/3\";'), ('5712ce6da050d88cbcdb906777d115762297e68a', '20.171.206.186', '1730358225', '__ci_last_regenerate|i:1730358225;cart_items|a:1:{i:0;s:1:\"4\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('2d8a23ea17bc8466fee5d92f98af625422909fde', '20.171.206.186', '1730358227', '__ci_last_regenerate|i:1730358227;cart_items|a:1:{i:0;s:1:\"3\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:20;'), ('61162ed9e460a0be332c6fa69c4f4757a83a6955', '20.171.206.186', '1730358229', '__ci_last_regenerate|i:1730358229;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:80:\"https://cursos.curaquantica13.com/home/course/desprogramação-neurobiológica/1\";'), ('b1a6f93b971bd4b27ce78a079cb4079c96dce3cd', '20.171.206.186', '1730358236', '__ci_last_regenerate|i:1730358236;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('21f35675e9c1382a6f2ae3352a6b5fb55753a9d2', '20.171.206.186', '1730358238', '__ci_last_regenerate|i:1730358238;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:81:\"https://cursos.curaquantica13.com/home/course/curando-minhas-feridas-emocionais/4\";'), ('b6a54140b602ef8a2ee88f455b72a7c521ee1300', '20.171.206.186', '1730358240', '__ci_last_regenerate|i:1730358240;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c593ccbc371a7174a94f5f6157a1601e4454df79', '20.171.206.186', '1730358243', '__ci_last_regenerate|i:1730358243;cart_items|a:1:{i:0;s:1:\"5\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:799;'), ('8148c9c669b5af94c61df4486058a191c6f7433b', '20.171.206.186', '1730358258', '__ci_last_regenerate|i:1730358258;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:215;'), ('6c9b5e8d29865ab4fab1f16185185ff4d4f88a3b', '20.171.206.186', '1730358265', '__ci_last_regenerate|i:1730358265;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('a4c42c4ad6f087becfb792fa236b92b69cb63565', '20.171.206.186', '1730358266', '__ci_last_regenerate|i:1730358266;cart_items|a:0:{}language|s:10:\"portuguese\";error_message|s:35:\"Nenhum valor de pesquisa encontrado\";__ci_vars|a:1:{s:13:\"error_message\";s:3:\"new\";}'), ('5bef307b5f6c34cb8d5b246dce7955e4c0824fe2', '20.171.206.186', '1730358268', '__ci_last_regenerate|i:1730358268;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('aebad2a51c1cb9a2dbea2afe216d114103cb138d', '20.171.206.68', '1730358304', '__ci_last_regenerate|i:1730358304;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:71:\"https://cursos.curaquantica13.com/home/course/jornada-atraindo-o-amor/2\";'), ('4d563bedc7f2c02d9f326764bca9106f4d1acc4a', '47.128.35.230', '1730359392', '__ci_last_regenerate|i:1730359392;cart_items|a:0:{}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:0;'), ('ea292fa27db57f40e47e87c95a7108c4f1a057fe', '20.171.206.132', '1730359416', '__ci_last_regenerate|i:1730359416;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('72c322160f720867593906e4f9f6811ada9bdbbc', '20.171.206.132', '1730359425', '__ci_last_regenerate|i:1730359425;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4dd83d4a054a0828764ffece0b2d0529804d2bfc', '20.171.206.132', '1730359427', '__ci_last_regenerate|i:1730359427;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c063f064ba23b3b67b770fab74b542ade77bb7ab', '94.23.7.187', '1730364748', '__ci_last_regenerate|i:1730364748;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('19680b6ad3592f4c24d23724a436b1b10ffcc87d', '94.23.7.187', '1730364751', '__ci_last_regenerate|i:1730364751;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('124fd0accd81df11edd5a347f337f5577278d567', '66.249.72.34', '1730369533', '__ci_last_regenerate|i:1730369533;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('60290d14c0fc3ba470167da9c738a62afbe5e20c', '66.249.72.33', '1730369533', '__ci_last_regenerate|i:1730369533;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('85f50e8ee51703226ff53e3a829cc3b78eeebf60', '66.249.72.34', '1730369780', '__ci_last_regenerate|i:1730369780;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('eefad42674b19f0e45ae7db49a2e0bd2a17fddef', '66.249.72.32', '1730369843', '__ci_last_regenerate|i:1730369843;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('da70a2b75be6d8f4f4f038260b9f68cae4d58ee1', '66.249.72.32', '1730369875', '__ci_last_regenerate|i:1730369875;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5c1522de079ded29f6f394b912abc4314f2ed6a6', '66.249.72.33', '1730372003', '__ci_last_regenerate|i:1730372003;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('077f0a5ed70995245e4403297bf30a559222eeb8', '66.249.72.34', '1730372044', '__ci_last_regenerate|i:1730372044;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d7b5bd59ca3d88c999d7d28658bca9b1e179d2e1', '66.249.72.34', '1730372215', '__ci_last_regenerate|i:1730372215;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('93557b60f5d681af4aaa2a2b7893bbde750809d8', '66.249.72.33', '1730373420', '__ci_last_regenerate|i:1730373420;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ae832d39e12116cf5d9debf5840c29d445915eca', '66.249.72.32', '1730373421', '__ci_last_regenerate|i:1730373420;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('2ecb06ad384ed323b37d3a10f0950796fbb7ea46', '66.249.72.32', '1730373434', '__ci_last_regenerate|i:1730373434;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f877c4c6860fda94e352e1f6303fca108ae467a9', '66.249.72.34', '1730373540', '__ci_last_regenerate|i:1730373540;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('626282ecbb6003d023492f5b85f9f347064029ff', '66.249.72.33', '1730373541', '__ci_last_regenerate|i:1730373541;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d8ff51f36ad67b45f72ad5ebc157561a809f9c66', '66.249.72.34', '1730374075', '__ci_last_regenerate|i:1730374075;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('258729b01dd5822e9060eba05707de73b7cb95bd', '66.249.72.34', '1730374086', '__ci_last_regenerate|i:1730374086;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('4fb42e72d7a58ec5f136ca80b1e32db575881ed3', '66.249.72.34', '1730374341', '__ci_last_regenerate|i:1730374341;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('88ae4d6d39685625d3448e805237f3010c1c4647', '66.249.72.32', '1730375024', '__ci_last_regenerate|i:1730375024;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5c8f2bc0ebdcb309a427b774c423accf22578cb3', '66.249.72.34', '1730375046', '__ci_last_regenerate|i:1730375045;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('51992b7fd26ea843e0aabed7b5b0fc964828efb8', '66.249.72.34', '1730375361', '__ci_last_regenerate|i:1730375361;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('5c7204512a56407f58d4ae24299c4fc4c07491f9', '66.249.72.33', '1730375522', '__ci_last_regenerate|i:1730375522;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ca826bc395e2f1d946ea5da8533d5f105ca6c6dc', '66.249.72.34', '1730377043', '__ci_last_regenerate|i:1730377043;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('069f5475b9a87aa0d04e6799fa60f99ec376f752', '66.249.72.34', '1730377044', '__ci_last_regenerate|i:1730377044;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d29154a10903cd41bdf104f1ea9e9e207716c1cd', '66.249.72.33', '1730377218', '__ci_last_regenerate|i:1730377218;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('6fa1b4627ef095f56b3b8fc5a1fc92ecc6175352', '66.249.72.33', '1730377218', '__ci_last_regenerate|i:1730377218;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b1230bbfd7c9b24e2a3117fc38849894014cafc1', '66.249.72.33', '1730377447', '__ci_last_regenerate|i:1730377447;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d88ccaa16f3550d94af1df59508dce9065f4e01a', '66.249.72.33', '1730377448', '__ci_last_regenerate|i:1730377447;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('7356ebc2a6aad7f346ade941654ed49d8b42c027', '66.249.72.32', '1730377461', '__ci_last_regenerate|i:1730377461;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3f9ae778c9b03a287c5890cbd5bca8a9ff24faad', '66.249.72.32', '1730378402', '__ci_last_regenerate|i:1730378402;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('45c1dda9add6a9fe44fe8bb9c1d66f9884eb35aa', '66.249.72.34', '1730378655', '__ci_last_regenerate|i:1730378655;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d1e7cba82cdbc481b74f8109a4652c1de886ddf2', '66.249.72.34', '1730378763', '__ci_last_regenerate|i:1730378763;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('127a1ecebbf15e47fec01988d7e8e87bfdf1b7ea', '66.249.72.32', '1730380374', '__ci_last_regenerate|i:1730380374;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('360dd9b06bc73316fe842da5206bbb21caefacb4', '66.249.72.33', '1730380987', '__ci_last_regenerate|i:1730380987;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('a60dcef95c0b5326d1b577cb42c235827e9a63ec', '66.249.72.34', '1730381642', '__ci_last_regenerate|i:1730381642;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('bd1b20c47ad9c1a56899806f93703e5a5846a206', '66.249.72.32', '1730381642', '__ci_last_regenerate|i:1730381642;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('ddfe87310a1ef13a43edecc72fb7f04c58f2790a', '66.249.72.32', '1730381660', '__ci_last_regenerate|i:1730381660;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c7888b60d5959c9bb805e6a92b61545b5ca6d088', '66.249.72.33', '1730381784', '__ci_last_regenerate|i:1730381784;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d9c9cf4038419cae3422c91098d0807871fb6459', '66.249.72.34', '1730381844', '__ci_last_regenerate|i:1730381844;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('fcc7bc0783cfcfdb268425f9eb25f0e45f74011a', '66.249.72.33', '1730381965', '__ci_last_regenerate|i:1730381965;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('136dfc059980f44cde30e71e81c744a1be7c4a97', '66.249.72.33', '1730382063', '__ci_last_regenerate|i:1730382063;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('b69086d8d28af785c3bec122ce235cc0e3116e15', '66.249.72.32', '1730382072', '__ci_last_regenerate|i:1730382072;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('f6bce9e28c1c1c1a86ad6e76b44d0c9deda760e7', '66.249.72.32', '1730382104', '__ci_last_regenerate|i:1730382104;cart_items|a:1:{i:0;s:1:\"1\";}language|s:10:\"portuguese\";applied_coupon|N;total_price_of_checking_out|i:215;'), ('93021e8cd5a9262cfbf53ffafbedb51aa14030f1', '66.249.72.33', '1730382124', '__ci_last_regenerate|i:1730382124;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('153884bfa5e210956fc49e87ccd1b60e0c2ad142', '66.249.72.34', '1730383026', '__ci_last_regenerate|i:1730383026;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c4613cda25a972e9976e31927a3f0f00a5091e4b', '66.249.72.32', '1730383027', '__ci_last_regenerate|i:1730383027;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3a376509ffb47419ee4aac501ee9a6158ab52b02', '66.249.72.33', '1730383376', '__ci_last_regenerate|i:1730383376;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('3c89a11c63081a127fd0e3e5033b477ae4a9573a', '85.247.105.23', '1730384714', '__ci_last_regenerate|i:1730384688;cart_items|a:1:{i:0;s:1:\"5\";}language|s:10:\"portuguese\";custom_session_limit|i:1731248713;user_id|s:1:\"1\";role_id|s:1:\"1\";role|s:5:\"Admin\";name|s:19:\"Administrador Geral\";is_instructor|s:1:\"1\";admin_login|s:1:\"1\";applied_coupon|N;total_price_of_checking_out|i:799;layout|s:4:\"list\";url_history|s:52:\"https://cursos.curaquantica13.com/home/shopping_cart\";'), ('05258fab074f2bab19cc710a572680d93d7d998b', '47.128.44.39', '1730388117', '__ci_last_regenerate|i:1730388117;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('c7ab8be836c87f91bd1d616b7f6cccdfb179e940', '177.172.92.214', '1730407775', '__ci_last_regenerate|i:1730398666;cart_items|a:0:{}language|s:10:\"portuguese\";custom_session_limit|i:1731262698;user_id|s:1:\"1\";role_id|s:1:\"1\";role|s:5:\"Admin\";name|s:19:\"Administrador Geral\";is_instructor|s:1:\"1\";admin_login|s:1:\"1\";'), ('aeb515ec7ddb62ebe0628a601add1e3e4dbbf9a8', '216.244.66.227', '1730399805', '__ci_last_regenerate|i:1730399805;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('72486b52b86d030d3f7f8f18b3cfbc526c8caa91', '51.222.253.1', '1730400140', '__ci_last_regenerate|i:1730400140;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('08eaa3417ce0faefec457baee31da70ee45b3842', '51.222.253.15', '1730400142', '__ci_last_regenerate|i:1730400142;cart_items|a:0:{}language|s:10:\"portuguese\";url_history|s:84:\"https://cursos.curaquantica13.com/home/course/despertando-o-meu-poder-de-auto-cura/6\";'), ('ebd76536db4507530019c1bfb0ce729620954f34', '216.244.66.227', '1730400848', '__ci_last_regenerate|i:1730400848;cart_items|a:0:{}language|s:10:\"portuguese\";'), ('d451b2d42f1bf96d2d9095a427be9fc46590eb64', '177.172.92.214', '1730408613', '__ci_last_regenerate|i:1730408545;cart_items|a:0:{}language|s:10:\"portuguese\";custom_session_limit|i:1731272613;user_id|s:1:\"1\";role_id|s:1:\"1\";role|s:5:\"Admin\";name|s:19:\"Administrador Geral\";is_instructor|s:1:\"1\";admin_login|s:1:\"1\";');
DROP TABLE IF EXISTS `comment`;
CREATE TABLE `comment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `body` longtext DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `commentable_id` int(11) DEFAULT NULL,
  `commentable_type` varchar(50) DEFAULT NULL,
  `date_added` int(11) DEFAULT NULL,
  `last_modified` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `contact`;
CREATE TABLE `contact` (
  `id` int(21) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  `has_read` int(11) DEFAULT NULL,
  `replied` int(11) DEFAULT NULL,
  `created_at` varchar(100) DEFAULT NULL,
  `updated_at` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `contact` (`id`, `first_name`, `last_name`, `email`, `phone`, `address`, `message`, `has_read`, `replied`, `created_at`, `updated_at`) VALUES ('1', 'thophonryZS', 'thophonryZS', 'sweence@mailport.lat', '83792438179', 'https://enhanceyourlife.mom/', 'com 20 E2 AD 90 20Viagra 20Generico 20Bom 20 20Viagra 20Gel viagra generico bom He bought a landmark waterfront hotel and nearby marina andvowed to make natives of rival SГѓ o Paulo, the country s businesscapital, die with envy <a>cialis and priligy</a>', NULL, NULL, '1724604855', NULL), ('2', 'thophonryZS', 'thophonryZS', 'sweence@mailport.lat', '85828349583', 'https://enhanceyourlife.mom/', 'What did CL s tests of turmeric find <a>do i need a doctor prescription to buy priligy</a>', NULL, NULL, '1724611672', NULL), ('3', 'thophonryZS', 'thophonryZS', 'sweence@mailport.lat', '84949681893', 'https://enhanceyourlife.mom/', 'Your feelings of increased peace will be impossible to keep to yourself <a>priligy dapoxetine amazon</a>', NULL, NULL, '1724629335', NULL), ('4', 'thophonryZS', 'thophonryZS', 'sweence@mailport.lat', '86992112339', 'https://enhanceyourlife.mom/', 'Merico V, Zanoni M, Parada Bustamante A, Garagna S, Zuccotti M <a>better business bureau online pharmacy priligy</a>', NULL, NULL, '1724753317', NULL), ('5', 'thophonryZS', 'thophonryZS', 'sweence@mailport.lat', '89743765884', 'https://enhanceyourlife.mom/', 'Pattern of plasma volume response of healthy young men during a 3 h passive heat exposure <a>where to buy priligy in malaysia</a> They re also great if you like the convenience of renewing online or if you like to order many months worth of a drug you take on a regular basis', NULL, NULL, '1724900422', NULL), ('6', 'thophonryZS', 'thophonryZS', 'sweence@mailport.lat', '83632979243', 'https://enhanceyourlife.mom/', 'It is interesting to note that no labeling cell division was reported in the organ of Corti in the normal or injured ear in any of these investigations on adult animals <a>priligy precio</a>', NULL, NULL, '1724932491', NULL), ('7', 'thophonryZS', 'thophonryZS', 'sweence@mailport.lat', '82289712735', 'https://enhanceyourlife.mom/', 'These compounds may induce bone loss and lead to osteoporosis <a>order priligy online</a>', NULL, NULL, '1724933402', NULL), ('8', 'thophonryZS', 'thophonryZS', 'sweence@mailport.lat', '87572174226', 'https://enhanceyourlife.mom/', 'Our embryologists optimize conditions in the incubator to maximize your embryos growth and development, and they will call you with updates as this process progresses <a>priligy amazon uk</a>', NULL, NULL, '1724937585', NULL), ('9', 'thophonryZS', 'thophonryZS', 'sweence@mailport.lat', '88341928195', 'https://enhanceyourlife.mom/', 'Letrozole is a potent aromatase inhibitor, and it does come with some side effects <a>buy priligy paypal</a> Feeling very beneficial', NULL, NULL, '1724981655', NULL), ('10', 'thophonryZS', 'thophonryZS', 'sweence@mailport.lat', '87882272548', 'https://enhanceyourlife.mom/', 'Also, with diclofenac 2 mg kg rectally two times a day <a>priligy fda approval</a>', NULL, NULL, '1725009182', NULL), ('11', 'thophonryZS', 'thophonryZS', 'sweence@mailport.lat', '81546712211', 'https://enhanceyourlife.mom/', '43 Italian Study 21, 23 n 5, 408, ages 35 70 Tamoxifen, 20 mg d 46 All types 22 19 2 <a>buy priligy reddit</a> I am heartbroken and will always wonder if there was anything we could have done differently to save him', NULL, NULL, '1725075761', NULL), ('12', 'thophonryZS', 'thophonryZS', 'sweence@mailport.lat', '87934999719', 'https://enhanceyourlife.mom/', 'I don t mean I m a saint far from it, she adds <a>priligy 60 mg</a>', NULL, NULL, '1725089074', NULL);
DROP TABLE IF EXISTS `coupons`;
CREATE TABLE `coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) DEFAULT NULL,
  `discount_percentage` varchar(255) DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  `expiry_date` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `course`;
CREATE TABLE `course` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `short_description` longtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `outcomes` longtext DEFAULT NULL,
  `faqs` text NOT NULL,
  `language` varchar(255) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `sub_category_id` int(11) DEFAULT NULL,
  `section` longtext DEFAULT NULL,
  `requirements` longtext DEFAULT NULL,
  `price` double DEFAULT NULL,
  `discount_flag` int(11) DEFAULT 0,
  `discounted_price` double DEFAULT NULL,
  `level` varchar(50) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `video_url` varchar(255) DEFAULT NULL,
  `date_added` int(11) DEFAULT NULL,
  `last_modified` int(11) DEFAULT NULL,
  `course_type` varchar(255) DEFAULT NULL,
  `is_top_course` int(11) DEFAULT 0,
  `is_admin` int(11) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `course_overview_provider` varchar(255) DEFAULT NULL,
  `meta_keywords` longtext DEFAULT NULL,
  `meta_description` longtext DEFAULT NULL,
  `is_free_course` int(11) DEFAULT NULL,
  `multi_instructor` int(11) NOT NULL DEFAULT 0,
  `enable_drip_content` int(11) NOT NULL,
  `creator` int(11) DEFAULT NULL,
  `expiry_period` int(11) DEFAULT NULL,
  `upcoming_image_thumbnail` varchar(255) DEFAULT NULL,
  `publish_date` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `course` (`id`, `title`, `short_description`, `description`, `outcomes`, `faqs`, `language`, `category_id`, `sub_category_id`, `section`, `requirements`, `price`, `discount_flag`, `discounted_price`, `level`, `user_id`, `thumbnail`, `video_url`, `date_added`, `last_modified`, `course_type`, `is_top_course`, `is_admin`, `status`, `course_overview_provider`, `meta_keywords`, `meta_description`, `is_free_course`, `multi_instructor`, `enable_drip_content`, `creator`, `expiry_period`, `upcoming_image_thumbnail`, `publish_date`) VALUES ('1', 'Desprogramação Neurobiológica', 'Descubra a Revolução da Sua Mente com a Desprogramação Neurobiológica!\r\n\r\nPrepare-se para uma jornada de transformação profunda e duradoura! Se estás cansado de ser refém de pensamentos negativos, ansiedade constante e comportamentos limitantes que roubam a tua felicidade, este convite é a chave para a tua libertação.', '<p>Convido-te para a primeira turma do curso de Desprogramação Neurobiológica, que acontecerá nos dias 26 e 27 de julho. Uma ferramenta poderosa para liberar traumas emocionais, curar doenças, aumentar a autoestima, e encontrar paz interior. </p><p>\r\n\r\n</p><p><br></p><p>O que ganhas?</p><p><br></p><p>- Curso de DESPROGRAMAÇÃO NEUROBIOLÓGICA</p><p>\r\n\r\n</p><p><br></p><p>Esta ferramenta conecta a sua mente ao seu coração, libertando os teus comportamentos repetitivos, crenças e limitações que foram implementadas ao longo de nossas vidas!\r\n</p><p>\r\n</p><p><br></p><p>- Torne-se um Desprogramador Neurobiológico que cria realidades.\r\n</p><p>- Certificação internacional. </p><p>                                                       \r\n- Apostila Digital e Acesso Vitalício ao conteúdo na plataforma do curso.\r\n</p><p>- Com o curso poderás te auto aplicar, fazer atendimentos presenciais e a distância.\r\n</p><p>- Passo a passo da Autoaplicação e Ancoramento.\r\n</p><p>- Acesso a uma comunidade online exclusiva para interagir com outros participantes e compartilhar experiências.\r\n</p><p>- Artes gráficas para divulgação e venda de sessões.\r\n</p><p>- Sessões de perguntas e respostas ao vivo.\r\n</p>', '[]', '[]', 'portuguese', '1', '9', '[1,2,3,4,5,6,7,8,9,10]', '[]', '215', NULL, '0', 'beginner', '1,2', NULL, '', '1717455600', '1717613801', 'general', '0', '1', 'active', '', 'crenças limitantes,neurociencia,energia metal,desprogramação,gestão emocional', '', NULL, '1', '0', '1', NULL, NULL, NULL), ('2', 'Jornada Atraindo o Amor', 'Pronto para superar as dores do passado e encontrar o amor que merece?', '<p class=\"MsoNormal\">Descubra o segredo para superar as dores do amor próprio\r\nferido e da autoestima abalada. Este curso vai muito além de teorias; oferece\r\nsessões de Desprogramação Neurobiológica para eliminar as barreiras que a\r\nrejeição causou na sua vida amorosa.<o:p></o:p></p><p class=\"MsoNormal\"><o:p> </o:p></p><p class=\"MsoNormal\">Recupere sua autoestima e confiança. Aprenda a se libertar\r\ndas dores do passado e do sentimento de rejeição que o impedem de viver um\r\nrelacionamento saudável e significativo.<o:p></o:p></p><p class=\"MsoNormal\"><o:p> </o:p></p><p class=\"MsoNormal\">Inscreva-se agora e comece sua jornada de cura. Este é o\r\nmomento de investir em si mesmo, superar as dores do passado e atrair o amor\r\nque sempre mereceu.<o:p></o:p></p><p class=\"MsoNormal\"><o:p> </o:p></p><p>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n</p><p class=\"MsoNormal\">Garanta a sua vaga e descubra como transformar a sua vida\r\namorosa hoje mesmo!<o:p></o:p></p>', '[]', '[]', 'portuguese', '1', '9', '[11,12,13,14,15,16,17,18,19,20,21]', '[]', '40', NULL, '0', 'beginner', '1', NULL, '', '1717542000', '1717626447', 'general', '0', '1', 'active', '', 'Amor,Relacionamentos,Casal Feliz,Cura,Desenvolvimento Pessoal,Amor Próprio,Autoestima', '', NULL, '0', '0', '1', '12', NULL, NULL), ('3', 'Atraindo Abundância', 'Está pronto para viver a melhor semana da tua vida? Durante sete dias, mergulhe no melhor relacionamento com a prosperidade. Esta é a sua oportunidade de libertar amarras emocionais, energéticas e programas mentais limitantes que impedem a sua expansão, criatividade e equilíbrio.', '<blockquote class=\"blockquote\"><span style=\"font-family:\" segoe=\"\" ui=\"\" emoji\",sans-serif;=\"\" mso-bidi-font-family:\"segoe=\"\" emoji\"\"=\"\">*</span> JORNADA TERAPÊUTICA:\r\nAtrair Abundância em 7 Dias <span style=\"font-family:\" segoe=\"\" ui=\"\" emoji\",sans-serif;=\"\" mso-bidi-font-family:\"segoe=\"\" emoji\"\"=\"\">*<br></span><o:p> <br></o:p>Além de um curso transformador, você receberá um poderoso\r\ntratamento energético com a magia da Desprogramação Neurobiológica e a cura da\r\nEnergia Angelical.<br><o:p> <br></o:p>Esteja disposto a atrair todas as possibilidades que já\r\nestão disponíveis. Basta ouvir as meditações e permitir-se receber esse\r\ntratamento energético que irá transformar sua vida. Tudo é online, sem\r\ndeslocamentos.<br><o:p> <br></o:p>Garanta a sua vaga agora e experimente a magia da\r\ntransformação!</blockquote><p>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n</p>', '[]', '[]', 'portuguese', '3', '12', '[22,23,24,25,26,27,28,29,30,31,32]', '[]', '50', '1', '20', 'beginner', '1,2', NULL, 'https://youtu.be/bI0R8Thmh54', '1717542000', '1720642154', 'general', '0', '1', 'active', 'youtube', 'abundância ,prosperidade ,magnetismo ,atração do dinheiro,desprogramação,neurobiologia', 'abundancia prosperidade magnetismo dinheiro', NULL, '1', '0', '1', '12', NULL, NULL), ('4', 'Curando Minhas Feridas Emocionais', 'Descubra um caminho de cura emocional profunda no curso terapêutico &quot;Curando as Minhas Feridas Emocionais&quot;. Recupere sua autoestima, liberte-se da tristeza e restaure o desejo de amar. Com sessões de desprogramação neurobiológica e vídeos esclarecedores conduzidos pela Terapeuta Diana Lira.', '<blockquote class=\"blockquote\">Mulheres que passaram por decepções, enfrentam baixa\r\nautoestima, carregam mágoas e tristeza, e perderam o desejo de amar, este é um\r\nconvite especial para vocês.<br><o:p> <br></o:p>No curso \"Curando as Minhas Feridas Emocionais,\"\r\nofereço-te um caminho de cura emocional e mental profunda. Sabemos que as\r\nferidas emocionais podem ser profundas, afetando sua confiança e bem-estar. É\r\nhora de enfrentar essas feridas e restaurar a alegria em sua vida.<br><o:p> <br></o:p>Este curso é liderado pela experiente Terapeuta Diana Lira,\r\nconhecida por suas sessões de desprogramação neurobiológica e vídeos\r\nenriquecedores. Ao longo do curso recebes um tratamento para curar as tuas\r\nferidas mais profundas. Aprenderás a reconhecer e libertar os traumas\r\nemocionais que te mantem prisioneira da tristeza e da baixa autoestima.</blockquote><p>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n</p>', '[]', '[]', 'portuguese', '6', '15', '[33,34,35,36,37,38,39,40]', '[]', '30', '1', '20', 'beginner', '1', NULL, '', '1717628400', '1717631091', 'general', '0', '1', 'active', '', 'curar feridas,desprogramação neurobiologica,terapias ,criança interior ', '', NULL, '0', '0', '1', '12', NULL, NULL), ('5', 'Mentoria I.A e Espiritualidade', 'A mentoria em IA e Espiritualidade foi criada especialmente para profissionais do bem-estar que desejam transformar as suas carreiras e vidas pessoais de maneira profunda e inovadora. Este programa integra Inteligência Artificial com práticas Espirituais, oferecendo uma abordagem holística para o crescimento pessoal e profissional.', '<blockquote class=\"blockquote\">Durante a mentoria, aprenderá a utilizar ferramentas\r\navançadas de IA para automatizar tarefas, optimizar o seu marketing digital e\r\natrair mais clientes com estratégias personalizadas e eficazes. Além disso,\r\ndescobrirá técnicas práticas de gestão de tempo e produtividade que lhe\r\npermitirão equilibrar as responsabilidades profissionais com a vida pessoal,\r\ncuidando de si enquanto cuida dos outros.<br> <o:p> <br></o:p>A mentoria também foca na superação de bloqueios emocionais,\r\najudando-o a enfrentar medos e crenças limitantes através de sessões\r\nterapêuticas dedicadas, libertando o seu potencial para um crescimento\r\ncontínuo. Ao fazer parte deste programa, juntar-se-á a uma comunidade\r\nacolhedora de profissionais do bem-estar, onde poderá trocar experiências,\r\naprender e crescer em conjunto.<br> <o:p> <br></o:p>A abordagem holística do programa inclui práticas\r\nespirituais integradas com a tecnologia, proporcionando uma jornada de\r\nautodescoberta e desenvolvimento que harmoniza o crescimento pessoal com a\r\neficiência tecnológica. Com uma formação abrangente em gestão de negócios,\r\nganhará confiança e competência para gerir o seu empreendimento terapêutico com\r\npráticas de empreendedorismo testadas e aprovadas, e desenvolverá a capacidade\r\nde tomar decisões informadas baseadas em dados e feedbacks.<br> <o:p> <br></o:p>Em apenas seis meses, estará preparado para duplicar os seus\r\nrendimentos, equilibrando crescimento pessoal e inovação tecnológica. Este\r\nprograma foi desenhado para profissionais dedicados e apaixonados, prontos para\r\nelevar o seu impacto e transformar as suas carreiras. Não espere mais para dar\r\no próximo passo rumo a um futuro mais próspero e equilibrado. Junte-se à\r\nMentoria em IA e Espiritualidade e comece agora a sua jornada de transformação.</blockquote><p>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n</p>', '[]', '{\"1. O que \\u00e9 a mentoria em IA e Espiritualidade?\":\"A mentoria em IA e Espiritualidade \\u00e9 um programa personalizado que integra ferramentas de intelig\\u00eancia artificial com pr\\u00e1ticas espirituais, destinado a profissionais do bem-estar. O objetivo \\u00e9 aprimorar habilidades empreendedoras, atrair clientes de forma eficiente e alcan\\u00e7ar um equil\\u00edbrio saud\\u00e1vel entre trabalho e vida pessoal.\",\"2. Para quem \\u00e9 a mentoria?\":\"A mentoria \\u00e9 projetada para profissionais do bem-estar, como terapeutas, psic\\u00f3logos e coaches, com idades entre 30 e 50 anos, que est\\u00e3o em in\\u00edcio ou meio de carreira e desejam expandir seus neg\\u00f3cios usando tecnologia avan\\u00e7ada e pr\\u00e1ticas espirituais.\",\"3. Quais s\\u00e3o os principais benef\\u00edcios desta mentoria?\":\"\\u2022 Aprender a gerir um neg\\u00f3cio de terapia de forma eficaz.\\r\\n \\u2022 Desenvolver estrat\\u00e9gias de marketing digital para atrair e reter clientes.\\r\\n \\u2022 Encontrar um equil\\u00edbrio saud\\u00e1vel entre vida profissional e pessoal.\\r\\n \\u2022 Superar bloqueios emocionais que impedem o crescimento profissional.\\r\\n \\u2022 Participar de uma comunidade de suporte para networking e troca de experi\\u00eancias.\\r\\n \\u2022 Utilizar ferramentas de IA para otimizar a produtividade e o crescimento do neg\\u00f3cio.\",\"4. Como a IA \\u00e9 integrada na mentoria?\":\"Utilizamos ferramentas de IA para otimizar diversas \\u00e1reas do neg\\u00f3cio, como marketing digital, gest\\u00e3o de clientes e produtividade. A mentoria ensina como essas tecnologias podem ser harmonizadas com pr\\u00e1ticas espirituais para melhorar o bem-estar geral e o sucesso profissional.\",\"5. Qual \\u00e9 a estrutura do programa de mentoria?\":\"O programa \\u00e9 estruturado em m\\u00f3dulos que cobrem gest\\u00e3o de neg\\u00f3cios, estrat\\u00e9gias de marketing digital, t\\u00e9cnicas de produtividade, equil\\u00edbrio trabalho-vida, supera\\u00e7\\u00e3o de bloqueios emocionais e desenvolvimento pessoal. Cada m\\u00f3dulo \\u00e9 projetado para ser flex\\u00edvel e adapt\\u00e1vel \\u00e0s necessidades individuais dos participantes.\",\"6. Como posso me inscrever na mentoria?\":\"Voc\\u00ea pode se inscrever na mentoria atrav\\u00e9s da nossa plataforma online. Basta preencher o formul\\u00e1rio de inscri\\u00e7\\u00e3o, e nossa equipe entrar\\u00e1 em contato para fornecer mais detalhes e concluir o processo de inscri\\u00e7\\u00e3o.\",\"7. Quanto tempo dura a mentoria?\":\"A mentoria tem dura\\u00e7\\u00e3o de 6 meses, durante os quais os participantes ter\\u00e3o acesso a sess\\u00f5es semanais, materiais de estudo e atividades pr\\u00e1ticas.\",\"8. Qual \\u00e9 o custo da mentoria?\":\"O custo da mentoria ser\\u00e1 informado durante o processo de inscri\\u00e7\\u00e3o. Oferecemos planos de pagamento flex\\u00edveis para atender \\u00e0s necessidades financeiras dos participantes.\",\"9. Existem requisitos para participar da mentoria?\":\"Sim, \\u00e9 necess\\u00e1rio ter um background profissional na \\u00e1rea de bem-estar, como terapia, psicologia, nutri\\u00e7\\u00e3o, fisioterapia, ou coaching, e estar disposto a integrar pr\\u00e1ticas tecnol\\u00f3gicas e espirituais no seu desenvolvimento profissional.\",\"10. Como a mentoria pode ajudar a duplicar meus rendimentos em 6 meses?\":\"Atrav\\u00e9s de estrat\\u00e9gias eficazes de marketing digital, otimiza\\u00e7\\u00e3o de processos de neg\\u00f3cios com IA, desenvolvimento de habilidades de gest\\u00e3o e supera\\u00e7\\u00e3o de bloqueios emocionais, voc\\u00ea poder\\u00e1 atrair mais clientes, aumentar a efici\\u00eancia e melhorar a qualidade do seu servi\\u00e7o, resultando em um aumento significativo dos rendimentos.\",\"11. Como \\u00e9 feita a integra\\u00e7\\u00e3o entre tecnologia e espiritualidade na mentoria?\":\"A mentoria se concentra em melhorar a gest\\u00e3o do seu neg\\u00f3cio terap\\u00eautico atrav\\u00e9s da utiliza\\u00e7\\u00e3o de ferramentas de IA. Aprender\\u00e1 a otimizar processos administrativos, automatizar tarefas repetitivas, analisar dados de clientes para personalizar servi\\u00e7os e implementar estrat\\u00e9gias de marketing digital mais eficazes. Essas melhorias aumentar\\u00e3o a efici\\u00eancia operacional, permitir\\u00e3o um atendimento mais focado e atrair\\u00e3o mais clientes, resultando em um aumento significativo dos seus rendimentos.\",\"12. Qual \\u00e9 o suporte oferecido durante a mentoria?\":\"Durante a mentoria, voc\\u00ea ter\\u00e1 acesso a sess\\u00f5es de teraoia em grupo, webinars, materiais did\\u00e1ticos e uma comunidade de suporte para networking e troca de experi\\u00eancias. A nossa equipa estar\\u00e1 dispon\\u00edvel para responder a perguntas e fornecer orienta\\u00e7\\u00e3o cont\\u00ednua.\",\"13. Posso participar da mentoria se n\\u00e3o tiver muita experi\\u00eancia com tecnologia?\":\"Sim, a mentoria \\u00e9 projetada para ser acess\\u00edvel a todos os n\\u00edveis de experi\\u00eancia com tecnologia. Fornecemos treinamento completo sobre o uso de ferramentas de IA e suporte cont\\u00ednuo para garantir que se sinta confiante e capacitado a utilizar essas tecnologias.\"}', 'portuguese', '2', '11', '[41,43,44,45,47,48,50,51,63]', '[]', '799', NULL, '599', 'beginner', '1', NULL, '', '1717628400', '1724977591', 'general', '0', '1', 'active', '', '', 'Inscreva-se na Mentoria em IA e Espiritualidade para transformar o seu negócio terapêutico. Aprenda a integrar inteligência artificial a sua prática espiritual, aumentando a sua eficiência, atraindo mais clientes e duplicando os seus rendimentos em 6 meses. Descubra como otimizar a gestão do seu negócio e alcançar o equilíbrio trabalho-vida!', NULL, '0', '0', '1', '8', NULL, ''), ('6', 'Despertando o meu Poder de Auto Cura', 'Bem-vindo ao curso “Despertando o meu Poder de Auto Cura”. Neste curso, embarcará numa jornada transformadora para fortalecer o seu sistema imunológico, alcançar estados elevados de felicidade e revitalizar a sua glândula do timo, utilizando técnicas da quinta dimensão.', '<p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">O que vai aprender neste curso:</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);=\"\" min-height:=\"\" 15px;\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\"><br></p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">Conectar-se espiritualmente:</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">Descubra e fortaleça a sua conexão com o seu eu interior e com o universo.</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);=\"\" min-height:=\"\" 15px;\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\"><br></p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">Desprogramar padrões limitantes:</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">Através de técnicas avançadas de desprogramação neurobiológica, liberte-se de bloqueios emocionais e mentais.</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);=\"\" min-height:=\"\" 15px;\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\"><br></p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">Limpar a glândula do timo:</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">Aprenda a revitalizar esta importante glândula para potenciar a sua energia vital e o seu sistema imunológico.</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);=\"\" min-height:=\"\" 15px;\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\"><br></p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">Atingir estados de felicidade profunda:</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">Desenvolva práticas diárias que promovem um estado de alegria e plenitude contínua.</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);=\"\" min-height:=\"\" 15px;\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\"><br></p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">Comece hoje a sua jornada de auto cura e descubra o poder que reside dentro de si. Junte-se a nós e desperte para uma vida cheia de paz, felicidade e saúde, transformando a sua vida e alcançando um novo patamar de autoconhecimento e equilíbrio.</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);=\"\" min-height:=\"\" 15px;\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\"><br></p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">O que esperar:</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);=\"\" min-height:=\"\" 15px;\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\"><br></p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\"> • Sessões guiadas com práticas e exercícios</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\"> • Meditações e técnicas de limpeza energética</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\"> • Suporte contínuo e comunidade de apoio</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);=\"\" min-height:=\"\" 15px;\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\"><br></p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">Este curso foi feito com um cuidado especial e amor para si.</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);=\"\" min-height:=\"\" 15px;\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\"><br></p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">Com carinho,</p><p helvetica=\"\" neue\";=\"\" font-size-adjust:=\"\" none;=\"\" font-kerning:=\"\" auto;=\"\" font-variant-alternates:=\"\" normal;=\"\" font-variant-ligatures:=\"\" font-variant-numeric:=\"\" font-variant-east-asian:=\"\" font-variant-position:=\"\" font-variant-emoji:=\"\" font-feature-settings:=\"\" font-optical-sizing:=\"\" font-variation-settings:=\"\" color:=\"\" rgb(0,=\"\" 0,=\"\" 0);\"=\"\" style=\"margin-right: 0px; margin-left: 0px; line-height: normal; font-family: Nunito, \"Segoe UI\", arial; font-stretch: normal; font-size: 13px;\">Terapeuta Diana Lira.</p>', '[\"1. Conex\\u00e3o Espiritual Fortalecida: Sentir\\u00e1 uma conex\\u00e3o mais profunda com o seu eu interior e com o universo.\",\"2. Liberta\\u00e7\\u00e3o de Padr\\u00f5es Limitantes: Ser\\u00e1 capaz de identificar e desprogramar bloqueios emocionais e mentais que impedem o seu crescimento.\",\"3. Energia Vital Revitalizada: Aprender\\u00e1 a limpar e revitalizar a gl\\u00e2ndula do timo, potenciando a sua energia vital e o sistema imunol\\u00f3gico.\",\"4. Estados de Felicidade Profunda: Desenvolver\\u00e1 pr\\u00e1ticas que promovem uma alegria e plenitude cont\\u00ednuas na sua vida di\\u00e1ria.\",\"5. Autoconhecimento e Equil\\u00edbrio: Alcan\\u00e7ar\\u00e1 um novo patamar de autoconhecimento e equil\\u00edbrio emocional.\",\"6. Comunidade de Apoio: Ter\\u00e1 acesso a uma comunidade de apoio que partilha as mesmas jornadas e objetivos de cura e crescimento.\"]', '{\"1. Quem pode participar deste curso?\":\"Qualquer pessoa que deseja melhorar a sua conex\\u00e3o espiritual, libertar-se de padr\\u00f5es limitantes e alcan\\u00e7ar um estado de felicidade e equil\\u00edbrio. N\\u00e3o \\u00e9 necess\\u00e1rio ter experi\\u00eancia pr\\u00e9via em terapias integrativas\",\"2. Quanto tempo dura o curso?\":\"O curso \\u201cDespertando o Poder de Autocura\\u201d tem a dura\\u00e7\\u00e3o de 8 semanas, com sess\\u00f5es semanais e suporte cont\\u00ednuo.\",\"3. Como s\\u00e3o as sess\\u00f5es?\":\"As sess\\u00f5es s\\u00e3o online, com pr\\u00e1ticas guiadas, medita\\u00e7\\u00f5es e t\\u00e9cnicas de limpeza energ\\u00e9tica. Voc\\u00ea pode participar no conforto da sua casa.\",\"4. Preciso de algum material espec\\u00edfico?\":\"N\\u00e3o, todo o material necess\\u00e1rio ser\\u00e1 disponibilizado durante o curso. Apenas precisa de um local tranquilo para praticar as medita\\u00e7\\u00f5es e exerc\\u00edcios.\",\"5. E se eu tiver d\\u00favidas durante o curso?\":\"Ter\\u00e1 acesso a um suporte cont\\u00ednuo e uma comunidade de apoio onde pode esclarecer todas as suas d\\u00favidas e partilhar experi\\u00eancias.\",\"6. Posso fazer o curso no meu pr\\u00f3prio ritmo?\":\"Sim, embora as sess\\u00f5es sejam semanais, pode acessar o conte\\u00fado gravado e praticar conforme a sua disponibilidade.\",\"7. O que acontece se eu n\\u00e3o puder participar de uma sess\\u00e3o ao vivo?\":\"Todas as sess\\u00f5es s\\u00e3o gravadas, e voc\\u00ea pode assistir no seu pr\\u00f3prio tempo.\",\"8. O curso oferece certifica\\u00e7\\u00e3o?\":\"Sim, ao concluir o curso, receber\\u00e1 um certificado de participa\\u00e7\\u00e3o.\"}', 'portuguese', '5', '14', '[52,53,54,55,56,57,58,59,60]', '[\"1. Comprometimento:Este curso requer um compromisso pessoal com as pr\\u00e1ticas e exerc\\u00edcios propostos.\",\"2. Acesso \\u00e0 Internet: Necessita de uma conex\\u00e3o est\\u00e1vel \\u00e0 internet para participar das sess\\u00f5es online e acessar os materiais do curso.\",\"3. Espa\\u00e7o Tranquilo: Um local calmo e livre de distra\\u00e7\\u00f5es para realizar as medita\\u00e7\\u00f5es e pr\\u00e1ticas.\",\"4. Mente Aberta: Estar aberto a novas experi\\u00eancias e t\\u00e9cnicas de autoconhecimento e cura.\"]', '0', NULL, '0', 'beginner', '1,2', NULL, 'https://youtu.be/_G7xMTJf-LA', '1720998000', '1721072827', 'general', '0', '1', 'active', 'youtube', 'AutoCura,felicidade profunda,sistema inmunológico,glândula do timo', 'Auto Cura, felicidade profunda, sistema imunológico, glândula do timo', '1', '1', '0', '1', NULL, NULL, NULL), ('7', 'Teste de Edição', 'Teste 1', '<p>Teste 2</p>', '[\"Ser mais Ativo\",\"Estar Mais Calmo\",\"Ter mais Paci\\u00eancia \"]', '[]', 'portuguese', '1', '9', '[61]', '[\"Ser Aluno\",\"Ser maio de 18 Anos\"]', '0', NULL, '0', 'advanced', '1', NULL, 'https://youtu.be/G-ITG3Xn2bw', '1720998000', '1721068976', 'general', '0', '1', 'private', 'youtube', '', 'teste', '1', '0', '1', '1', '6', NULL, NULL);
DROP TABLE IF EXISTS `course_affiliation`;
CREATE TABLE `course_affiliation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` varchar(255) DEFAULT NULL,
  `buyer_id` int(11) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `actual_amount` decimal(10,2) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `percentage` decimal(10,2) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `date_added` varchar(255) DEFAULT NULL,
  `referee_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `course_affiliation_payment`;
CREATE TABLE `course_affiliation_payment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT 'pending',
  `type` varchar(255) DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `course_bundle`;
CREATE TABLE `course_bundle` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `banner` varchar(255) DEFAULT NULL,
  `course_ids` longtext DEFAULT NULL,
  `subscription_limit` int(11) DEFAULT NULL,
  `price` int(11) DEFAULT 0,
  `bundle_details` longtext DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  `date_added` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `course_forum`;
CREATE TABLE `course_forum` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `upvoted_user_id` longtext DEFAULT NULL,
  `is_parent` int(11) DEFAULT 0,
  `date_added` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `currency`;
CREATE TABLE `currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `symbol` varchar(255) DEFAULT NULL,
  `paypal_supported` int(11) DEFAULT NULL,
  `stripe_supported` int(11) DEFAULT NULL,
  `ccavenue_supported` int(11) DEFAULT 0,
  `iyzico_supported` int(11) DEFAULT 0,
  `paystack_supported` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
INSERT INTO `currency` (`id`, `name`, `code`, `symbol`, `paypal_supported`, `stripe_supported`, `ccavenue_supported`, `iyzico_supported`, `paystack_supported`) VALUES ('1', 'US Dollar', 'USD', '$', '1', '1', '0', '0', '0'), ('2', 'Albanian Lek', 'ALL', 'Lek', '0', '1', '0', '0', '0'), ('3', 'Algerian Dinar', 'DZD', 'دج', '1', '1', '0', '0', '0'), ('4', 'Angolan Kwanza', 'AOA', 'Kz', '1', '1', '0', '0', '0'), ('5', 'Argentine Peso', 'ARS', '$', '1', '1', '0', '0', '0'), ('6', 'Armenian Dram', 'AMD', '֏', '1', '1', '0', '0', '0'), ('7', 'Aruban Florin', 'AWG', 'ƒ', '1', '1', '0', '0', '0'), ('8', 'Australian Dollar', 'AUD', '$', '1', '1', '0', '0', '0'), ('9', 'Azerbaijani Manat', 'AZN', 'm', '1', '1', '0', '0', '0'), ('10', 'Bahamian Dollar', 'BSD', 'B$', '1', '1', '0', '0', '0'), ('11', 'Bahraini Dinar', 'BHD', '.د.ب', '1', '1', '0', '0', '0'), ('12', 'Bangladeshi Taka', 'BDT', '৳', '1', '1', '0', '0', '0'), ('13', 'Barbadian Dollar', 'BBD', 'Bds$', '1', '1', '0', '0', '0'), ('14', 'Belarusian Ruble', 'BYR', 'Br', '0', '0', '0', '0', '0'), ('15', 'Belgian Franc', 'BEF', 'fr', '1', '1', '0', '0', '0'), ('16', 'Belize Dollar', 'BZD', '$', '1', '1', '0', '0', '0'), ('17', 'Bermudan Dollar', 'BMD', '$', '1', '1', '0', '0', '0'), ('18', 'Bhutanese Ngultrum', 'BTN', 'Nu.', '1', '1', '0', '0', '0'), ('19', 'Bitcoin', 'BTC', '฿', '1', '1', '0', '0', '0'), ('20', 'Bolivian Boliviano', 'BOB', 'Bs.', '1', '1', '0', '0', '0'), ('21', 'Bosnia', 'BAM', 'KM', '1', '1', '0', '0', '0'), ('22', 'Botswanan Pula', 'BWP', 'P', '1', '1', '0', '0', '0'), ('23', 'Brazilian Real', 'BRL', 'R$', '1', '1', '0', '0', '0'), ('24', 'British Pound Sterling', 'GBP', '£', '1', '1', '0', '0', '0'), ('25', 'Brunei Dollar', 'BND', 'B$', '1', '1', '0', '0', '0'), ('26', 'Bulgarian Lev', 'BGN', 'Лв.', '1', '1', '0', '0', '0'), ('27', 'Burundian Franc', 'BIF', 'FBu', '1', '1', '0', '0', '0'), ('28', 'Cambodian Riel', 'KHR', 'KHR', '1', '1', '0', '0', '0'), ('29', 'Canadian Dollar', 'CAD', '$', '1', '1', '0', '0', '0'), ('30', 'Cape Verdean Escudo', 'CVE', '$', '1', '1', '0', '0', '0'), ('31', 'Cayman Islands Dollar', 'KYD', '$', '1', '1', '0', '0', '0'), ('32', 'CFA Franc BCEAO', 'XOF', 'CFA', '1', '1', '0', '0', '0'), ('33', 'CFA Franc BEAC', 'XAF', 'FCFA', '1', '1', '0', '0', '0'), ('34', 'CFP Franc', 'XPF', '₣', '1', '1', '0', '0', '0'), ('35', 'Chilean Peso', 'CLP', '$', '1', '1', '0', '0', '0'), ('36', 'Chinese Yuan', 'CNY', '¥', '1', '1', '0', '0', '0'), ('37', 'Colombian Peso', 'COP', '$', '1', '1', '0', '0', '0'), ('38', 'Comorian Franc', 'KMF', 'CF', '1', '1', '0', '0', '0'), ('39', 'Congolese Franc', 'CDF', 'FC', '1', '1', '0', '0', '0'), ('40', 'Costa Rican ColÃ³n', 'CRC', '₡', '1', '1', '0', '0', '0'), ('41', 'Croatian Kuna', 'HRK', 'kn', '1', '1', '0', '0', '0'), ('42', 'Cuban Convertible Peso', 'CUC', '$, CUC', '1', '1', '0', '0', '0'), ('43', 'Czech Republic Koruna', 'CZK', 'Kč', '1', '1', '0', '0', '0'), ('44', 'Danish Krone', 'DKK', 'Kr.', '1', '1', '0', '0', '0'), ('45', 'Djiboutian Franc', 'DJF', 'Fdj', '1', '1', '0', '0', '0'), ('46', 'Dominican Peso', 'DOP', '$', '1', '1', '0', '0', '0'), ('47', 'East Caribbean Dollar', 'XCD', '$', '1', '1', '0', '0', '0'), ('48', 'Egyptian Pound', 'EGP', 'ج.م', '1', '1', '0', '0', '0'), ('49', 'Eritrean Nakfa', 'ERN', 'Nfk', '1', '1', '0', '0', '0'), ('50', 'Estonian Kroon', 'EEK', 'kr', '1', '1', '0', '0', '0'), ('51', 'Ethiopian Birr', 'ETB', 'Nkf', '1', '1', '0', '0', '0'), ('52', 'Euro', 'EUR', '€', '1', '1', '0', '0', '0'), ('53', 'Falkland Islands Pound', 'FKP', '£', '1', '1', '0', '0', '0'), ('54', 'Fijian Dollar', 'FJD', 'FJ$', '1', '1', '0', '0', '0'), ('55', 'Gambian Dalasi', 'GMD', 'D', '1', '1', '0', '0', '0'), ('56', 'Georgian Lari', 'GEL', 'ლ', '1', '1', '0', '0', '0'), ('57', 'German Mark', 'DEM', 'DM', '1', '1', '0', '0', '0'), ('58', 'Ghanaian Cedi', 'GHS', 'GH₵', '1', '1', '0', '0', '0'), ('59', 'Gibraltar Pound', 'GIP', '£', '1', '1', '0', '0', '0'), ('60', 'Greek Drachma', 'GRD', '₯, Δρχ, Δρ', '1', '1', '0', '0', '0'), ('61', 'Guatemalan Quetzal', 'GTQ', 'Q', '1', '1', '0', '0', '0'), ('62', 'Guinean Franc', 'GNF', 'FG', '1', '1', '0', '0', '0'), ('63', 'Guyanaese Dollar', 'GYD', '$', '1', '1', '0', '0', '0'), ('64', 'Haitian Gourde', 'HTG', 'G', '1', '1', '0', '0', '0'), ('65', 'Honduran Lempira', 'HNL', 'L', '1', '1', '0', '0', '0'), ('66', 'Hong Kong Dollar', 'HKD', '$', '1', '1', '0', '0', '0'), ('67', 'Hungarian Forint', 'HUF', 'Ft', '1', '1', '0', '0', '0'), ('68', 'Icelandic KrÃ³na', 'ISK', 'kr', '1', '1', '0', '0', '0'), ('69', 'Indian Rupee', 'INR', '₹', '1', '1', '1', '0', '0'), ('70', 'Indonesian Rupiah', 'IDR', 'Rp', '1', '1', '0', '0', '0'), ('71', 'Iranian Rial', 'IRR', '﷼', '1', '1', '0', '0', '0'), ('72', 'Iraqi Dinar', 'IQD', 'د.ع', '1', '1', '0', '0', '0'), ('73', 'Israeli New Sheqel', 'ILS', '₪', '1', '1', '0', '0', '0'), ('74', 'Italian Lira', 'ITL', 'L,£', '1', '1', '0', '0', '0'), ('75', 'Jamaican Dollar', 'JMD', 'J$', '1', '1', '0', '0', '0'), ('76', 'Japanese Yen', 'JPY', '¥', '1', '1', '0', '0', '0'), ('77', 'Jordanian Dinar', 'JOD', 'ا.د', '1', '1', '0', '0', '0'), ('78', 'Kazakhstani Tenge', 'KZT', 'лв', '1', '1', '0', '0', '0'), ('79', 'Kenyan Shilling', 'KES', 'KSh', '1', '1', '0', '0', '0'), ('80', 'Kuwaiti Dinar', 'KWD', 'ك.د', '1', '1', '0', '0', '0'), ('81', 'Kyrgystani Som', 'KGS', 'лв', '1', '1', '0', '0', '0'), ('82', 'Laotian Kip', 'LAK', '₭', '1', '1', '0', '0', '0'), ('83', 'Latvian Lats', 'LVL', 'Ls', '0', '0', '0', '0', '0'), ('84', 'Lebanese Pound', 'LBP', '£', '1', '1', '0', '0', '0'), ('85', 'Lesotho Loti', 'LSL', 'L', '1', '1', '0', '0', '0'), ('86', 'Liberian Dollar', 'LRD', '$', '1', '1', '0', '0', '0'), ('87', 'Libyan Dinar', 'LYD', 'د.ل', '1', '1', '0', '0', '0'), ('88', 'Lithuanian Litas', 'LTL', 'Lt', '0', '0', '0', '0', '0'), ('89', 'Macanese Pataca', 'MOP', '$', '1', '1', '0', '0', '0'), ('90', 'Macedonian Denar', 'MKD', 'ден', '1', '1', '0', '0', '0'), ('91', 'Malagasy Ariary', 'MGA', 'Ar', '1', '1', '0', '0', '0'), ('92', 'Malawian Kwacha', 'MWK', 'MK', '1', '1', '0', '0', '0'), ('93', 'Malaysian Ringgit', 'MYR', 'RM', '1', '1', '0', '0', '0'), ('94', 'Maldivian Rufiyaa', 'MVR', 'Rf', '1', '1', '0', '0', '0'), ('95', 'Mauritanian Ouguiya', 'MRO', 'MRU', '1', '1', '0', '0', '0'), ('96', 'Mauritian Rupee', 'MUR', '₨', '1', '1', '0', '0', '0'), ('97', 'Mexican Peso', 'MXN', '$', '1', '1', '0', '0', '0'), ('98', 'Moldovan Leu', 'MDL', 'L', '1', '1', '0', '0', '0'), ('99', 'Mongolian Tugrik', 'MNT', '₮', '1', '1', '0', '0', '0'), ('100', 'Moroccan Dirham', 'MAD', 'MAD', '1', '1', '0', '0', '0'), ('101', 'Mozambican Metical', 'MZM', 'MT', '1', '1', '0', '0', '0'), ('102', 'Myanmar Kyat', 'MMK', 'K', '1', '1', '0', '0', '0'), ('103', 'Namibian Dollar', 'NAD', '$', '1', '1', '0', '0', '0'), ('104', 'Nepalese Rupee', 'NPR', '₨', '1', '1', '0', '0', '0'), ('105', 'Netherlands Antillean Guilder', 'ANG', 'ƒ', '1', '1', '0', '0', '0'), ('106', 'New Taiwan Dollar', 'TWD', '$', '1', '1', '0', '0', '0'), ('107', 'New Zealand Dollar', 'NZD', '$', '1', '1', '0', '0', '0'), ('108', 'Nicaraguan CÃ³rdoba', 'NIO', 'C$', '1', '1', '0', '0', '0'), ('109', 'Nigerian Naira', 'NGN', '₦', '1', '1', '0', '0', '1'), ('110', 'North Korean Won', 'KPW', '₩', '0', '0', '0', '0', '0'), ('111', 'Norwegian Krone', 'NOK', 'kr', '1', '1', '0', '0', '0'), ('112', 'Omani Rial', 'OMR', '.ع.ر', '0', '0', '0', '0', '0'), ('113', 'Pakistani Rupee', 'PKR', '₨', '1', '1', '0', '0', '0'), ('114', 'Panamanian Balboa', 'PAB', 'B/.', '1', '1', '0', '0', '0'), ('115', 'Papua New Guinean Kina', 'PGK', 'K', '1', '1', '0', '0', '0'), ('116', 'Paraguayan Guarani', 'PYG', '₲', '1', '1', '0', '0', '0'), ('117', 'Peruvian Nuevo Sol', 'PEN', 'S/.', '1', '1', '0', '0', '0'), ('118', 'Philippine Peso', 'PHP', '₱', '1', '1', '0', '0', '0'), ('119', 'Polish Zloty', 'PLN', 'zł', '1', '1', '0', '0', '0'), ('120', 'Qatari Rial', 'QAR', 'ق.ر', '1', '1', '0', '0', '0'), ('121', 'Romanian Leu', 'RON', 'lei', '1', '1', '0', '0', '0'), ('122', 'Russian Ruble', 'RUB', '₽', '1', '1', '0', '0', '0'), ('123', 'Rwandan Franc', 'RWF', 'FRw', '1', '1', '0', '0', '0'), ('124', 'Salvadoran ColÃ³n', 'SVC', '₡', '0', '0', '0', '0', '0'), ('125', 'Samoan Tala', 'WST', 'SAT', '1', '1', '0', '0', '0'), ('126', 'Saudi Riyal', 'SAR', '﷼', '1', '1', '0', '0', '0'), ('127', 'Serbian Dinar', 'RSD', 'din', '1', '1', '0', '0', '0'), ('128', 'Seychellois Rupee', 'SCR', 'SRe', '1', '1', '0', '0', '0'), ('129', 'Sierra Leonean Leone', 'SLL', 'Le', '1', '1', '0', '0', '0'), ('130', 'Singapore Dollar', 'SGD', '$', '1', '1', '0', '0', '0'), ('131', 'Slovak Koruna', 'SKK', 'Sk', '1', '1', '0', '0', '0'), ('132', 'Solomon Islands Dollar', 'SBD', 'Si$', '1', '1', '0', '0', '0'), ('133', 'Somali Shilling', 'SOS', 'Sh.so.', '1', '1', '0', '0', '0'), ('134', 'South African Rand', 'ZAR', 'R', '1', '1', '0', '0', '0'), ('135', 'South Korean Won', 'KRW', '₩', '1', '1', '0', '0', '0'), ('136', 'Special Drawing Rights', 'XDR', 'SDR', '1', '1', '0', '0', '0'), ('137', 'Sri Lankan Rupee', 'LKR', 'Rs', '1', '1', '0', '0', '0'), ('138', 'St. Helena Pound', 'SHP', '£', '1', '1', '0', '0', '0'), ('139', 'Sudanese Pound', 'SDG', '.س.ج', '1', '1', '0', '0', '0'), ('140', 'Surinamese Dollar', 'SRD', '$', '1', '1', '0', '0', '0'), ('141', 'Swazi Lilangeni', 'SZL', 'E', '1', '1', '0', '0', '0'), ('142', 'Swedish Krona', 'SEK', 'kr', '1', '1', '0', '0', '0'), ('143', 'Swiss Franc', 'CHF', 'CHf', '1', '1', '0', '0', '0'), ('144', 'Syrian Pound', 'SYP', 'LS', '0', '0', '0', '0', '0'), ('145', 'São Tomé and Príncipe Dobra', 'STD', 'Db', '1', '1', '0', '0', '0'), ('146', 'Tajikistani Somoni', 'TJS', 'SM', '1', '1', '0', '0', '0'), ('147', 'Tanzanian Shilling', 'TZS', 'TSh', '1', '1', '0', '0', '0'), ('148', 'Thai Baht', 'THB', '฿', '1', '1', '0', '0', '0'), ('149', 'Tongan pa\'anga', 'TOP', '$', '1', '1', '0', '0', '0'), ('150', 'Trinidad & Tobago Dollar', 'TTD', '$', '1', '1', '0', '0', '0'), ('151', 'Tunisian Dinar', 'TND', 'ت.د', '1', '1', '0', '0', '0'), ('152', 'Turkish Lira', 'TRY', '₺', '1', '1', '0', '1', '0'), ('153', 'Turkmenistani Manat', 'TMT', 'T', '1', '1', '0', '0', '0'), ('154', 'Ugandan Shilling', 'UGX', 'USh', '1', '1', '0', '0', '0'), ('155', 'Ukrainian Hryvnia', 'UAH', '₴', '1', '1', '0', '0', '0'), ('156', 'United Arab Emirates Dirham', 'AED', 'إ.د', '1', '1', '0', '0', '0'), ('157', 'Uruguayan Peso', 'UYU', '$', '1', '1', '0', '0', '0'), ('158', 'Afghan Afghani', 'AFA', '؋', '1', '1', '0', '0', '0'), ('159', 'Uzbekistan Som', 'UZS', 'лв', '1', '1', '0', '0', '0'), ('160', 'Vanuatu Vatu', 'VUV', 'VT', '1', '1', '0', '0', '0'), ('161', 'Venezuelan BolÃvar', 'VEF', 'Bs', '0', '0', '0', '0', '0'), ('162', 'Vietnamese Dong', 'VND', '₫', '1', '1', '0', '0', '0'), ('163', 'Yemeni Rial', 'YER', '﷼', '1', '1', '0', '0', '0'), ('164', 'Zambian Kwacha', 'ZMK', 'ZK', '1', '1', '0', '0', '0');
DROP TABLE IF EXISTS `custom_page`;
CREATE TABLE `custom_page` (
  `custom_page_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `page_content` longtext NOT NULL,
  `page_url` varchar(255) NOT NULL,
  `button_title` varchar(255) NOT NULL,
  `button_position` varchar(255) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`custom_page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `ebook`;
CREATE TABLE `ebook` (
  `ebook_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `banner` varchar(255) DEFAULT NULL,
  `file` varchar(255) DEFAULT NULL,
  `publication_name` varchar(255) DEFAULT NULL,
  `edition` varchar(255) DEFAULT NULL,
  `discount_flag` int(11) DEFAULT NULL,
  `discounted_price` double NOT NULL,
  `price` double NOT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  `updated_date` varchar(255) DEFAULT NULL,
  `is_active` int(11) DEFAULT NULL,
  `is_free` int(11) DEFAULT NULL,
  `preview` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ebook_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `ebook_category`;
CREATE TABLE `ebook_category` (
  `category_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `ebook_payment`;
CREATE TABLE `ebook_payment` (
  `payment_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `ebook_id` int(11) DEFAULT NULL,
  `paid_amount` double NOT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `admin_revenue` float DEFAULT NULL,
  `instructor_revenue` float DEFAULT NULL,
  `instructor_payment_status` int(11) DEFAULT NULL,
  `payment_keys` varchar(255) DEFAULT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  `updated_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `ebook_reviews`;
CREATE TABLE `ebook_reviews` (
  `review_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `ebook_id` int(11) DEFAULT NULL,
  `rating` int(11) DEFAULT NULL,
  `comment` longtext DEFAULT NULL,
  `added_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`review_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `enrol`;
CREATE TABLE `enrol` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `gifted_by` int(11) NOT NULL DEFAULT 0,
  `expiry_date` varchar(255) DEFAULT NULL,
  `date_added` int(11) DEFAULT NULL,
  `last_modified` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `enrol` (`id`, `user_id`, `course_id`, `gifted_by`, `expiry_date`, `date_added`, `last_modified`) VALUES ('1', '4', '1', '0', NULL, '1718406000', NULL), ('2', '4', '2', '0', '1749576303', '1718406000', NULL), ('3', '4', '3', '0', '1749576303', '1718406000', NULL), ('4', '5', '1', '0', NULL, '1718751600', NULL), ('5', '5', '2', '0', '1749928729', '1718751600', NULL), ('6', '5', '3', '0', '1749928729', '1718751600', NULL), ('7', '2', '5', '0', NULL, '1719183600', NULL), ('8', '7', '5', '0', NULL, '1719183600', '1719183600'), ('9', '6', '5', '0', NULL, '1719183600', NULL), ('10', '9', '5', '0', NULL, '1719183600', NULL), ('11', '10', '5', '0', NULL, '1719183600', NULL), ('12', '8', '3', '0', '1750372565', '1719183600', NULL), ('13', '11', '5', '0', '1740053425', '1719270000', NULL), ('14', '5', '5', '0', '1740053918', '1719270000', NULL), ('15', '12', '5', '0', '1740177339', '1719356400', NULL), ('16', '7', '6', '0', NULL, '1721170800', NULL), ('17', '14', '6', '0', NULL, '1721343600', NULL), ('18', '15', '6', '0', NULL, '1723244400', NULL), ('19', '13', '5', '0', '1744737375', '1723935600', NULL);
DROP TABLE IF EXISTS `frontend_settings`;
CREATE TABLE `frontend_settings` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `frontend_settings` (`id`, `key`, `value`) VALUES ('1', 'banner_title', 'Comece aprendendo agora na melhor plataforma para terapias energéticas!'), ('2', 'banner_sub_title', 'Estude em qualquer lugar a qualquer hora. Explore todos os cursos pelo menor preço de todos os tempos!'), ('4', 'about_us', '<h2>Sobre a Curaquantica13</h2>\r\n<p class=\"MsoNormal\">A Cura Quântica 13 foi sendo construída a partir de\r\nvivências e pesquisas que foram conduzindo transformações significativos na\r\nvida de pessoas que passaram por nossos cuidados. Por aqui, cada pessoa é\r\ncompreendida em seu processo singular de vivenciar as emoções, suas crenças,\r\nsuas histórias de vida.<o:p></o:p></p>'), ('10', 'terms_and_condition', '<h2>Termos e Regras</h2>\r\n<p class=\"MsoNormal\">Nossa missão é melhorar vidas por meio do aprendizado. Permitimos que qualquer pessoa em qualquer lugar crie e compartilhe conteúdo educacional (instrutores) e acesse esse conteúdo educacional para aprender (alunos). Consideramos nosso modelo de marketplace a melhor forma de oferecer conteúdo educacional valioso aos nossos usuários. Precisamos de regras para manter nossa plataforma e serviços seguros para você, para nós e para nossa comunidade de alunos e instrutores. Estes Termos se aplicam a todas as suas atividades no site da Curaquantica13, nos aplicativos móveis, em nossas APIs e outros serviços relacionados (\"Redes Sociais\").\r\n<br><br>\r\nSe você publicar conteúdo em nossa plataforma, também deverá concordar com os Termos do instrutor. Também fornecemos detalhes sobre o processamento dos dados pessoais de nossos alunos e instrutores em nossa Política de Privacidade. Se você estiver usando nossa plataforma para empresas como parte da assinatura da curaquantica13, consulte nossa Declaração de privacidade clicando AQUI.\r\n<br><br>\r\nVocê precisa de uma conta para a maioria das atividades em nossa plataforma, inclusive para comprar e acessar conteúdo ou enviar conteúdo para publicação. Ao configurar e manter sua conta, você deve fornecer e continuar a fornecer informações precisas e completas, incluindo um endereço de e-mail válido. Você tem total responsabilidade por sua conta e tudo o que acontece em sua conta, inclusive por qualquer dano ou dano (a nós ou a qualquer outra pessoa) causado por alguém usando sua conta sem sua permissão. Isso significa que você precisa ter cuidado com sua senha. Você não pode transferir sua conta para outra pessoa ou usar a conta de outra pessoa. Se você entrar em contato conosco para solicitar acesso a uma conta, não concederemos esse acesso a menos que você possa nos fornecer as informações necessárias para provar que você é o proprietário dessa conta. No caso da morte de um usuário, a conta desse usuário será encerrada.\r\n<o:p></o:p></p>'), ('11', 'privacy_policy', '<h2>Política de Privacidade</h2>\r\n<p class=\"MsoNormal\">Esta Política de Privacidade foi atualizada pela última vez em dezembro, 2023.\r\n\r\nAgradecemos a sua participação na Curaquantica13. A Curaquantica13 (“nós”, “a Empresa”) respeita a privacidade dos usuários e deseja que todos entendam como coletamos, usamos e compartilhamos os dados dos usuários. Esta Política de Privacidade abrange nossas práticas de coleta de dados e descreve os direitos do usuário em relação aos dados pessoais.\r\n<br><br>\r\nA menos que nos vinculemos a outra política ou indiquemos em contrário, esta Política de Privacidade se aplica quando você visita ou usa os sites, os aplicativos móveis, as APIs ou serviços relacionados da Curaquantica13 (os “Serviços”). Ela também se aplica a clientes em potencial dos nossos produtos profissionais ou empresariais.\r\n<br><br>\r\nAo usar os Serviços, o usuário concorda com os termos desta Política de Privacidade. Não use os Serviços caso não concorde com esta Política de Privacidade ou qualquer outro acordo que reja o uso dos Serviços por parte do usuário.\r\n<o:p></o:p></p>'), ('13', 'theme', 'default-new'), ('14', 'cookie_note', 'Este site utiliza cookies para personalizar o conteúdo e analisar o tráfego para lhe oferecer uma melhor experiência.'), ('15', 'cookie_status', 'active'), ('16', 'cookie_policy', '<h1>Política de Cookies</h1><ol><li>Cookies são pequenos arquivos de texto que podem ser usados ​​por sites para tornar a experiência do usuário mais eficiente.</li><li>A lei estabelece que podemos armazenar cookies no seu dispositivo se forem estritamente necessários para o funcionamento deste site. Para todos os outros tipos de cookies necessitamos da sua permissão.</li><li>Este site utiliza diferentes tipos de cookies. Alguns cookies são colocados por serviços de terceiros que aparecem nas nossas páginas.\r\n</li></ol>'), ('17', 'banner_image', '{\"home_7\":\"24e7683835f66abc7d1b63fe5d7a4136.png\"}'), ('18', 'light_logo', 'e6ff107459d435e38b54ad4c06202c33.png'), ('19', 'dark_logo', 'c37266f891444b10aa9c22ed163b99c7.png'), ('20', 'small_logo', 'ccc5dd5279b84a232c60ea1bb5cf8519.png'), ('21', 'favicon', '08a1cf3abf2457b3cd090aaa532c39f3.png'), ('22', 'recaptcha_status', '0'), ('23', 'recaptcha_secretkey', 'Valid-secret-key'), ('24', 'recaptcha_sitekey', 'Valid-site-key'), ('25', 'refund_policy', '<h2>Política de Pagamentos e Reembolsos</h2>\r\n<p class=\"MsoNormal\">Em vigor a partir de 1º de janeiro de 2024.\r\n<br><br>\r\nPara obter detalhes sobre nossas políticas de reembolso e cancelamento, consulte as informações abaixo. Observe que nossas políticas podem diferir entre ofertas e as opções de pagamento podem variar. Observe também que tratamos as violações de nossos Termos de Uso e Código de Honra com muita seriedade e não temos obrigação de oferecer reembolso aos usuários que violarem estas ou outras políticas da Curaquantica13, mesmo que suas solicitações sejam feitas dentro do período de reembolso designado. Da mesma forma, não temos obrigação de oferecer reembolsos tardios aos usuários que não obtiverem uma nota de aprovação em uma Oferta de Conteúdo ou que, de outra forma, estiverem insatisfeitos com sua nota final.\r\n<br><br>\r\nPara obter mais informações sobre nosso processo de reembolso, incluindo instruções para solicitar reembolso, visite nossa Central de Ajuda ao Aluno.\r\n<br><br><b>\r\n1. Compras únicas, Reembolsos Gerais, Projetos Orientados.\r\n</b><br><br>\r\nA Curaquantica13 não oferece reembolso para pagamentos feitos em projetos orientados.\r\n<br><br><b>\r\nCursos e Especializações.</b><br>\r\nSe você cancelar sua inscrição única paga em um curso ou especialização, a Curaquantica13 oferecerá um reembolso total até 14 dias após o pagamento ou até que você ganhe um certificado de curso para qualquer curso da especialização, o que ocorrer primeiro.\r\n<br><br><b>\r\nReembolsos para Certificados.</b><br>\r\nSe você não receber seu certificado de conclusão dentro de 180 dias após a inscrição em um projeto orientado, sua inscrição expirará e você precisará pagar para se inscrever novamente no projeto orientado, a fim de concluí-lo e obter seu certificado de conclusão.\r\n<br><br><b>\r\nCursos.</b><br>\r\nDepois de obter um certificado de curso com seu pagamento, você não terá direito a reembolso, mesmo que seja dentro de 14 dias. Se você não receber o certificado do curso dentro de 180 dias, sua inscrição expirará e você precisará pagar para se inscrever novamente no curso.\r\n<br><br><b>\r\nEspecializações.</b><br>\r\nSalvo indicação em contrário como parte do processo de inscrição, você terá um ano após adquirir uma especialização para concluí-la.\r\n<br><br><b>\r\n2. Assinaturas de especialização mensais\r\n</b><br><br><b>\r\nReembolsos Gerais.</b><br>\r\nA Curaquantica13 não oferece reembolso para pagamentos feitos em um plano de assinatura de especialização mensal.\r\n<br><br><b>\r\nReembolsos para testes.</b><br>\r\nPara evitar cobranças durante o período de avaliação gratuita, você deve cancelar sua assinatura antes do término da avaliação gratuita. Se você concluir um curso durante o período de teste gratuito, a Curaquantica13 reserva-se o direito de exigir que você pague uma assinatura de um mês para receber um curso e/ou certificado de especialização.\r\n<br><br><b>\r\nCancelamento.</b><br>\r\nSua assinatura continuará mensalmente, a menos e até que você cancele ou a assinatura seja suspensa ou descontinuada pela Curaquantica13. Se você cancelar sua assinatura, o cancelamento entrará em vigor no final do período mensal atual. Você continuará tendo acesso à sua assinatura pelo restante desse período, mas não receberá reembolso. Para assinaturas de especializações individuais, a Curaquantica13 descontinuará automaticamente sua assinatura no final do período mensal durante o qual você ganha um certificado para a especialização.\r\n<br><br><b>\r\n3. Outros serviços pagos\r\n</b><br><br>\r\nExceto conforme descrito nesta Política de Reembolso ou conforme explicitamente declarado como parte do processo de inscrição para um Serviço, a Curaquantica13 não tem obrigação de fornecer reembolsos ou vouchers para quaisquer outros Serviços.\r\n<br><br>\r\nA Curaquantica13 reserva-se o direito de oferecer reembolsos a seu critério. Observe que nossas políticas diferem entre pagamentos de assinatura e pagamentos únicos feitos para compras de cursos, especializações e projetos guiados, e que as opções de pagamento podem variar de uma oferta para outra. Observe também que tratamos as violações de nossos Termos de Uso e Código de Honra com muita seriedade e não temos obrigação de oferecer reembolso aos usuários que violarem estas ou outras políticas da Curaquantica13, mesmo que suas solicitações sejam feitas dentro do período de reembolso designado. Da mesma forma, não temos obrigação de oferecer reembolsos tardios aos usuários que não obtiverem uma nota de aprovação em uma Oferta de Conteúdo ou que, de outra forma, estiverem insatisfeitos com sua nota final.\r\n<br><br>\r\nPara obter mais informações sobre nosso processo de reembolso, incluindo instruções para solicitar reembolso, visite nossa Central de Ajuda ao Aluno.\r\n<br><br><b>\r\n4. Mercados de terceiros\r\n</b><br><br>\r\nNão obstante o acima exposto, se você comprar ou se inscrever em um curso, especialização, projeto guiado ou adquirir qualquer outro Serviço pago, por meio de um mercado de terceiros (por exemplo, compras no aplicativo através da Apple AppStore/ Google PlayStore ou compras feitas através de determinados serviços de pagamento alternativos), a política de reembolso aplicável a esse mercado de terceiros será aplicada, salvo indicação explícita em contrário pela Curaquatica13. Exceto quando explicitamente declarado de outra forma pela Curaquantica13, o mercado terceirizado será o único responsável por fazer reembolsos de acordo com sua política de reembolso, e a Curaquantica13 não terá obrigações de reembolso. O Curaquantica13 se isenta de qualquer responsabilidade relacionada à política de reembolso de qualquer mercado de terceiros ou à conformidade ou não conformidade do terceiro com tal política.\r\n<br><br><b>\r\n5. Ofertas promocionais\r\n</b><br><br>\r\nPoderemos, de tempos em tempos, oferecer ofertas promocionais especiais ou descontos (“Ofertas”). A elegibilidade da oferta é determinada pelo Curaquantica13 a seu exclusivo critério e nos reservamos o direito de revogar uma oferta caso determinemos que você não é elegível. Os usuários com uma Oferta existente podem não ser elegíveis para Ofertas adicionais. Poderemos usar informações como método de pagamento ou endereço de e-mail da conta usado em uma compra da uraquantica13 para determinar a elegibilidade da Oferta. Os requisitos de elegibilidade e outras limitações e condições serão divulgados quando você se inscrever na Oferta ou em outras comunicações que lhe forem disponibilizadas.\r\n<br><br><b>\r\n6. Alterações nos planos de preços e assinaturas\r\n</b><br><br>\r\nReservamo-nos o direito de alterar nossos planos de assinatura ou ajustar preços de nosso serviço ou de quaisquer componentes dele de qualquer maneira e a qualquer momento, conforme determinarmos a nosso critério exclusivo e absoluto. Exceto quando expressamente previsto nestes Termos, quaisquer alterações de preço ou alterações em seu plano de assinatura entrarão em vigor após notificação a você.\r\n<br><br><b>\r\n7. Direito de rescisão dos utilizadores europe</b>us\r\n<br><br>\r\nAlém das políticas de reembolso estabelecidas acima, se você tiver o direito de rescisão de acordo com as leis relevantes do seu país, incluindo quaisquer leis aplicáveis da União Europeia, então:\r\n<br>\r\nVocê tem o direito de rescisão por um período de 14 dias. Você poderá rescindir seu contrato com a Curaquantica13 para os Serviços, sem indicar qualquer motivo e sem incorrer em quaisquer custos além dos previstos nesta cláusula.\r\nO período de rescisão expirará após 14 dias a partir do dia em que o seu contrato foi celebrado. No entanto, você não tem o direito de rescisão a) se os Serviços já tiverem sido totalmente executados com o seu consentimento prévio e expresso e com o seu reconhecimento de que perderá o seu direito de rescisão assim que os Serviços tiverem sido executados por nós ou b) se Os Serviços começaram com o seu consentimento prévio e expresso e o seu reconhecimento de que perderá o seu direito de rescisão ao iniciar a utilização dos Serviços.\r\nPara exercer o direito de rescisão, deverá informar-nos da sua decisão de rescisão através de uma declaração inequívoca (por exemplo, uma carta enviada por correio/email ou contatando-nos para orientações e ações de término/conclusão.\r\n<o:p></o:p></p>'), ('26', 'facebook', 'https://www.facebook.com/curaquantica13'), ('27', 'twitter', ''), ('28', 'linkedin', ''), ('31', 'blog_page_title', 'Onde as possibilidades começam'), ('32', 'blog_page_subtitle', 'Somos uma plataforma de cursos para aprendizagem e ensino on-line para Saúde Integrativa e Psicoemocional. Explore alguns de nossos conteúdos mais populares e aprenda algo novo.'), ('33', 'blog_page_banner', 'blog-page.png'), ('34', 'instructors_blog_permission', '1'), ('35', 'blog_visibility_on_the_home_page', '1'), ('37', 'website_faqs', '[]'), ('38', 'motivational_speech', '[]'), ('39', 'home_page', 'home_7'), ('40', 'contact_info', '{\"email\":\"curaquantica13@curaquantica13.com\",\"phone\":\"+351 969-741-855\",\"address\":\"Cidade - Funchal, Portugal\",\"office_hours\":\"Segunda \\u00e0 Sexta das 9:00hs \\u00e0s 17:00hs\"}'), ('41', 'custom_css', ''), ('42', 'embed_code', ''), ('43', 'top_course_section', '1'), ('44', 'latest_course_section', '1'), ('45', 'top_category_section', '1'), ('46', 'upcoming_course_section', '1'), ('47', 'faq_section', '1'), ('48', 'top_instructor_section', '0'), ('49', 'motivational_speech_section', '1'), ('50', 'promotional_section', '1');
DROP TABLE IF EXISTS `jitsi_live_class`;
CREATE TABLE `jitsi_live_class` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `course_id` int(11) DEFAULT NULL,
  `date` varchar(100) DEFAULT NULL,
  `time` varchar(100) DEFAULT NULL,
  `jitsi_meeting_id` varchar(255) DEFAULT NULL,
  `jitsi_meeting_password` varchar(255) DEFAULT NULL,
  `note_to_students` longtext DEFAULT NULL,
  `class_topic` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
INSERT INTO `jitsi_live_class` (`id`, `course_id`, `date`, `time`, `jitsi_meeting_id`, `jitsi_meeting_password`, `note_to_students`, `class_topic`) VALUES ('1', '1', '1717542000', '1717595532', NULL, '', '', 'Live class'), ('2', '2', '1717542000', '1717620061', NULL, '', '', 'Live class'), ('3', '3', '1717542000', '1717713362', NULL, '', '', 'Live class'), ('4', '4', '1717628400', '1717631074', NULL, '', '', 'Live class');
DROP TABLE IF EXISTS `language`;
CREATE TABLE `language` (
  `phrase_id` int(11) NOT NULL AUTO_INCREMENT,
  `phrase` longtext DEFAULT NULL,
  `english` longtext DEFAULT NULL,
  `portugues` text DEFAULT NULL,
  `spanish` text DEFAULT NULL,
  `portuguese` longtext DEFAULT NULL,
  PRIMARY KEY (`phrase_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2050 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `language` (`phrase_id`, `phrase`, `english`, `portugues`, `spanish`, `portuguese`) VALUES ('1', 'English', 'English', NULL, 'Engleză', 'Inglês'), ('2', '404_not_found', '404 not found', NULL, '404 Nu a fost gasit', '404 não encontrado'), ('3', 'courses', 'Courses', 'Courses', 'Cursuri', 'Cursos'), ('4', 'all_courses', 'All courses', 'All courses', 'Toate cursurile', 'Todos os cursos'), ('5', 'search', 'Search', 'Search', 'Căutare', 'Procurar'), ('6', 'you_have_no_items_in_your_cart!', 'You have no items in your cart!', 'You have no items in your cart!', 'You have no items in your cart!', 'Você não tem itens no seu carrinho!'), ('7', 'checkout', 'Checkout', 'Checkout', 'Verifică', 'Confira'), ('8', 'login', 'Login', 'Login', 'Log in', 'Conecte-se'), ('9', 'join_now', 'Join now', 'Join now', 'Alătură-te acum', 'Entrar'), ('10', 'sign_up', 'Sign up', 'Sign up', 'Inscrie-te', 'Inscrever-se'), ('11', 'cart', 'Cart', 'Cart', 'Cart', 'Carrinho'), ('12', 'categories', 'Categories', 'Categories', 'Categorii', 'Categorias'), ('13', 'cookie_policy', 'Cookie policy', 'Cookie policy', 'Politica de cookie-uri', 'Política de cookies'), ('14', 'accept', 'Accept', 'Accept', 'Accept', 'Aceitar'), ('15', 'home', 'Home', 'Home', 'Acasă', 'Home'), ('16', 'the_page_you_requested_could_not_be_found', 'The page you requested could not be found', NULL, 'Pagina pe care ați solicitat-o ​​nu a putut fi găsită', 'A página solicitada não pôde ser encontrada'), ('17', 'check_the_spelling_of_the_url', 'Check the spelling of the url', NULL, 'Verificați ortografia adresei URL', 'Verifique a ortografia do URL'), ('18', 'if_you_are_still_puzzled,_click_on_the_home_link_below', 'If you are still puzzled, click on the home link below', NULL, 'If you are still puzzled, click on the home link below', 'Se você ainda está confuso, clique no link inicial abaixo'), ('19', 'back_to_home', 'Back to home', NULL, 'Înapoi acasă', 'De volta para casa'), ('20', 'top_categories', 'Top categories', 'Top categories', 'Categorii de top', 'Principais categorias'), ('21', 'useful_links', 'Useful links', 'Useful links', 'Link-uri utile', 'Links Úteis'), ('22', 'become_an_instructor', 'Become an instructor', 'Become an instructor', 'Become an instructor', 'Torne-se um instrutor'), ('23', 'blog', 'Blog', 'Blog', 'Blog', 'Blog'), ('24', 'help', 'Help', 'Help', 'Ajutor', 'Ajuda'), ('25', 'contact_us', 'Contact us', 'Contact us', 'Contactaţi-ne', 'Contate-nos'), ('26', 'about_us', 'About us', 'About us', 'Despre noi', 'Sobre nós'), ('27', 'privacy_policy', 'Privacy policy', 'Privacy policy', 'Politica de confidențialitate', 'Política de Privacidade'), ('28', 'terms_and_condition', 'Terms and condition', 'Terms and condition', 'Termeni și condiții', 'Termos e Condições'), ('29', 'faq', 'Faq', 'Faq', 'FAQ', 'Perguntas frequentes'), ('30', 'refund_policy', 'Refund policy', 'Refund policy', 'Politica de rambursare', 'Politica de reembolso'), ('31', 'subscribe_to_our_newsletter', 'Subscribe to our newsletter', 'Subscribe to our newsletter', 'Aboneaza-te la newsletter-ul nostru', 'Assine a nossa newsletter'), ('32', 'enter_your_email_address', 'Enter your email address', 'Enter your email address', 'Introdu adresa ta de e-mail', 'Insira o seu endereço de email'), ('33', 'creativeitem', 'Creativeitem', 'Creativeitem', NULL, 'Creativeitem'), ('34', 'are_you_sure', 'Are you sure', 'Are you sure', 'Esti sigur', 'Tem certeza'), ('35', 'yes', 'Yes', 'Yes', 'da', 'Sim'), ('36', 'no', 'No', 'No', 'Nu', 'Não'), ('37', 'log_in', 'Log in', NULL, 'Log in', 'Conecte-se'), ('38', 'explore,_learn,_and_grow_with_us._enjoy_a_seamless_and_enriching_educational_journey._lets_begin!', 'Explore, learn, and grow with us. enjoy a seamless and enriching educational journey. lets begin!', NULL, 'Explore, learn, and grow with us. enjoy a seamless and enriching educational journey. lets begin!', 'Explore, aprenda e cresça conosco. desfrute de uma jornada educacional contínua e enriquecedora. vamos começar!'), ('39', 'your_email', 'Your email', NULL, 'Email-ul tau', 'Seu e-mail'), ('40', 'enter_your_email', 'Enter your email', NULL, 'Introduceți adresa dvs. de email', 'Digite seu e-mail'), ('41', 'password', 'Password', NULL, 'Parola', 'Senha'), ('42', 'enter_your_valid_password', 'Enter your valid password', NULL, 'Introduceți parola dvs. validă', 'Digite sua senha válida'), ('43', 'forgot_password?', 'Forgot password?', NULL, 'Forgot password?', 'Esqueceu sua senha?'), ('44', 'don`t_have_an_account?', 'Don`t have an account?', NULL, 'Don`t have an account?', 'Não tem uma conta?'), ('45', 'or', 'Or', NULL, 'Sau', 'Ou'), ('46', 'start_learning_from_best_platform', 'Start learning from best platform', 'Start learning from best platform', 'Începeți să învățați de la cea mai bună platformă', 'Comece a aprender com a melhor plataforma'), ('47', 'study_any_topic,_anytime._explore_thousands_of_courses_for_the_lowest_price_ever!', 'Study any topic, anytime. explore thousands of courses for the lowest price ever!', 'Study any topic, anytime. explore thousands of courses for the lowest price ever!', 'Study any topic, anytime. explore thousands of courses for the lowest price ever!', 'Estude qualquer assunto, a qualquer hora. explore milhares de cursos pelo menor preço de todos os tempos!'), ('48', 'what_do_you_want_to_learn', 'What do you want to learn', NULL, 'Ce vrei să inveți', 'O que você quer aprender'), ('49', 'happy', 'Happy', NULL, 'Fericit', 'Feliz'), ('50', 'students', 'Students', NULL, 'Elevi', 'Alunos'), ('51', 'experienced', 'Experienced', NULL, 'Cu experienta', 'Com experiência'), ('52', 'instructors', 'Instructors', NULL, 'Instructori', 'Instrutores'), ('53', 'online_courses', 'Online courses', NULL, 'Cursuri online', 'Cursos online'), ('54', 'explore_a_variety_of_fresh_topics', 'Explore a variety of fresh topics', NULL, 'Explorați o varietate de subiecte noi', 'Explore uma variedade de tópicos novos'), ('55', 'expert_instruction', 'Expert instruction', NULL, 'Instruire de specialitate', 'Instrução especializada'), ('56', 'find_the_right_course_for_you', 'Find the right course for you', NULL, 'Găsiți cursul potrivit pentru dvs', 'Encontre o curso certo para você'), ('57', 'smart_solution', 'Smart solution', NULL, 'Soluție inteligentă', 'Solução inteligente'), ('58', 'learn_on_your_schedule', 'Learn on your schedule', NULL, 'Învață în programul tău', 'Aprenda de acordo com sua programação'), ('59', 'top_courses', 'Top courses', 'Top courses', 'Cursuri de top', 'Melhores cursos'), ('60', 'these_are_the_most_popular_courses_among_listen_courses_learners_worldwide', 'These are the most popular courses among listen courses learners worldwide', 'These are the most popular courses among listen courses learners worldwide', 'Acestea sunt cele mai populare cursuri printre cursanții de cursuri de ascultare din întreaga lume', 'Estes são os cursos mais populares entre os alunos de cursos auditivos em todo o mundo'), ('61', 'top', 'Top', NULL, 'Top', 'Principal'), ('62', 'latest_courses', 'Latest courses', 'Latest courses', 'Ultimele cursuri', 'Últimos cursos'), ('63', 'these_are_the_most_latest_courses_among_listen_courses_learners_worldwide', 'These are the most latest courses among listen courses learners worldwide', 'These are the most latest courses among listen courses learners worldwide', 'Acestea sunt cele mai recente cursuri dintre cursanții de ascultare din întreaga lume', 'Estes são os cursos mais recentes entre os alunos de cursos auditivos em todo o mundo'), ('64', 'join_now_to_start_learning', 'Join now to start learning', 'Join now to start learning', 'Înscrie-te acum pentru a începe să înveți', 'Cadastre-se agora para começar a aprender'), ('65', 'learn_from_our_quality_instructors!', 'Learn from our quality instructors!', 'Learn from our quality instructors!', 'Learn from our quality instructors!', 'Aprenda com nossos instrutores de qualidade!'), ('66', 'get_started', 'Get started', 'Get started', 'Incepe', 'iniciar'), ('67', 'become_a_new_instructor', 'Become a new instructor', 'Become a new instructor', 'Deveniți un nou instructor', 'Torne-se um novo instrutor'), ('68', 'teach_thousands_of_students_and_earn_money!', 'Teach thousands of students and earn money!', 'Teach thousands of students and earn money!', 'Teach thousands of students and earn money!', 'Ensine milhares de alunos e ganhe dinheiro!'), ('69', 'welcome', 'Welcome', NULL, 'Bine ati venit', 'Bem-vindo'), ('70', 'administration', 'Administration', NULL, 'Administrare', 'Administração'), ('71', 'manage_profile', 'Manage profile', NULL, 'Gestionați profilul', 'Gerenciar perfil'), ('72', 'settings', 'Settings', NULL, 'Setări', 'Configurações'), ('73', 'log_out', 'Log out', NULL, 'Deconectați-vă', 'Sair'), ('74', 'logout', 'Logout', NULL, 'Deconectare', 'Sair'), ('75', 'dashboard', 'Dashboard', NULL, 'Bord', 'Painel'), ('76', 'quick_actions', 'Quick actions', NULL, 'Acțiuni rapide', 'Ações rápidas'), ('77', 'create_course', 'Create course', NULL, 'Creați un curs', 'Criar curso'), ('78', 'add_course', 'Add course', NULL, 'Adaugă curs', 'Adicionar curso'), ('79', 'add_new_lesson', 'Add new lesson', NULL, 'Adăugați o lecție nouă', 'Adicionar nova lição'), ('80', 'add_lesson', 'Add lesson', NULL, 'Adăugați o lecție', 'Adicionar lição'), ('81', 'add_student', 'Add student', NULL, 'Adăugați un student', 'Adicionar aluno'), ('82', 'enrol_a_student', 'Enrol a student', NULL, 'Înscrieți un student', 'Inscrever um aluno'), ('83', 'enrol_student', 'Enrol student', NULL, 'Înscrieți studentul', 'Inscrever aluno'), ('84', 'help_center', 'Help center', NULL, 'Centru de ajutor', 'Centro de ajuda'), ('85', 'read_documentation', 'Read documentation', NULL, 'Citiți documentația', 'Leia a documentação'), ('86', 'watch_video_tutorial', 'Watch video tutorial', NULL, 'Urmărește tutorialul video', 'Assista ao tutorial em vídeo'), ('87', 'get_customer_support', 'Get customer support', NULL, 'Obțineți asistență pentru clienți', 'Obtenha suporte ao cliente'), ('88', 'order_customization', 'Order customization', NULL, 'Personalizarea comenzii', 'Personalização do pedido'), ('89', 'request_a_new_feature', 'Request a new feature', NULL, 'Solicitați o nouă funcție', 'Solicite um novo recurso'), ('90', 'browse_addons', 'Browse addons', NULL, 'Răsfoiți suplimente', 'Procure complementos'), ('91', 'get_services', 'Get services', NULL, NULL, 'Obtenha serviços'), ('92', 'remove_all', 'Remove all', NULL, 'Inlătură tot', 'Deletar tudo'), ('93', 'notification', 'Notification', NULL, 'Notificare', 'Notificação'), ('94', 'no_notification', 'No notification', NULL, 'Nicio notificare', 'Nenhuma notificação'), ('95', 'stay_tuned!', 'Stay tuned!', NULL, 'Stay tuned!', 'Fique atento!'), ('96', 'notifications_about_your_activity_will_show_up_here.', 'Notifications about your activity will show up here.', NULL, 'Notifications about your activity will show up here.', 'Notificações sobre sua atividade aparecerão aqui.'), ('97', 'notification_settings', 'Notification settings', NULL, 'Setări de notificare', 'Configurações de notificação'), ('98', 'mark_all_as_read', 'Mark all as read', NULL, 'Marcheaza totul ca fiind citit', 'marcar tudo como lido'), ('99', 'admin', 'Admin', NULL, 'Admin', 'Administrador'), ('100', 'my_account', 'My account', NULL, 'Contul meu', 'Minha conta'), ('101', 'visit_website', 'Visit website', NULL, 'Vizitati site-ul', 'Visite o site'), ('102', 'navigation', 'Navigation', NULL, 'Navigare', 'Navegação'), ('103', 'manage_courses', 'Manage courses', NULL, 'Gestionați cursurile', 'Gerenciar cursos'), ('104', 'add_new_course', 'Add new course', NULL, 'Adăugați un curs nou', 'Adicionar novo curso'), ('105', 'course_category', 'Course category', NULL, 'Categoria cursului', 'Categoria do curso'), ('106', 'coupons', 'Coupons', NULL, 'Cupoane', 'Cupons'), ('107', 'enrollments', 'Enrollments', NULL, 'Înscrieri', 'Inscrições'), ('108', 'course_enrollment', 'Course enrollment', NULL, 'Inscrierea la curs', 'Inscrição no curso'), ('109', 'enrol_history', 'Enrol history', NULL, 'Istoricul înscrierii', 'Histórico de inscrições'), ('110', 'report', 'Report', NULL, 'Raport', 'Relatório'), ('111', 'admin_revenue', 'Admin revenue', NULL, 'Venitul administrativ', 'Receita administrativa'), ('112', 'instructor_revenue', 'Instructor revenue', NULL, 'Venitul instructorului', 'Receita do instrutor'), ('113', 'purchase_history', 'Purchase history', NULL, 'Istoricul cumparaturilor', 'Histórico de compras'), ('114', 'users', 'Users', NULL, 'Utilizatori', 'Usuários'), ('115', 'admins', 'Admins', NULL, 'Administratori', 'Administradores'), ('116', 'manage_admins', 'Manage admins', NULL, 'Gestionați administratorii', 'Gerenciar administradores'), ('117', 'add_new_admin', 'Add new admin', NULL, 'Adăugați un nou administrator', 'Adicionar novo administrador'), ('118', 'manage_instructors', 'Manage instructors', NULL, 'Gestionați instructorii', 'Gerenciar instrutores'), ('119', 'add_new_instructor', 'Add new instructor', NULL, 'Adăugați un instructor nou', 'Adicionar novo instrutor'), ('120', 'instructor_payout', 'Instructor payout', NULL, 'Plata instructorului', 'Pagamento do instrutor'), ('121', 'instructor_settings', 'Instructor settings', NULL, 'Setările instructorului', 'Configurações do instrutor'), ('122', 'applications', 'Applications', NULL, 'Aplicații', 'Formulários'), ('123', 'manage_students', 'Manage students', NULL, 'Gestionați studenții', 'Gerenciar alunos'), ('124', 'add_new_student', 'Add new student', NULL, 'Adăugați un nou student', 'Adicionar novo aluno'), ('125', 'message', 'Message', NULL, 'Mesaj', 'Mensagem'), ('126', 'newsletter', 'Newsletter', NULL, 'Buletin informativ', 'Boletim de Notícias'), ('127', 'all_newsletter', 'All newsletter', NULL, 'Toate newsletter-ul', 'Todos os boletins informativos'), ('128', 'subscribed_user', 'Subscribed user', NULL, 'Utilizator abonat', 'Usuário inscrito'), ('129', 'contact', 'Contact', NULL, NULL, 'Contato'), ('130', 'all_blogs', 'All blogs', NULL, 'Toate blogurile', 'Todos os blogs'), ('131', 'pending_blog', 'Pending blog', NULL, 'Blog în așteptare', 'Blog pendente'), ('132', 'blog_category', 'Blog category', NULL, 'Categoria blog', 'Categoria do blog'), ('133', 'blog_settings', 'Blog settings', NULL, 'Setări blog', 'Configurações do blog'), ('134', 'addons', 'Addons', NULL, 'Suplimente', 'Complementos'), ('135', 'themes', 'Themes', NULL, 'Teme', 'Temas'), ('136', 'system_settings', 'System settings', NULL, 'Setarile sistemului', 'Configurações de sistema'), ('137', 'website_settings', 'Website settings', NULL, 'Setări site', 'Configurações do site'), ('138', 'academy_cloud', 'Academy cloud', NULL, 'Norul academiei', 'Nuvem da academia'), ('139', 'drip_content_settings', 'Drip content settings', NULL, 'Setări de conținut pentru picurare', 'Configurações de conteúdo de gotejamento'), ('140', 'wasabi_storage_settings', 'Wasabi storage settings', NULL, NULL, 'Configurações de armazenamento Wasabi'), ('141', 'bbb_live_class_settings', 'Bbb live class settings', NULL, NULL, 'Configurações de aula ao vivo do BBB'), ('142', 'payment_settings', 'Payment settings', NULL, 'Setări de plată', 'Configurações de pagamento'), ('143', 'language_settings', 'Language settings', NULL, 'Setările de limbă', 'Configurações de linguagem'), ('144', 'social_login', 'Social login', NULL, 'Conectare socială', 'Login social'), ('145', 'custom_page_builder', 'Custom page builder', NULL, 'Creator de pagini personalizate', 'Construtor de páginas personalizadas'), ('146', 'data_center', 'Data center', NULL, 'Centru de date', 'Centro de dados'), ('147', 'about', 'About', NULL, 'Despre', 'Sobre'), ('148', 'admin_revenue_this_year', 'Admin revenue this year', NULL, 'Venituri de administrare anul acesta', 'Receita administrativa este ano'), ('149', 'number_courses', 'Number courses', NULL, 'Număr cursuri', 'Cursos numéricos'), ('150', 'number_of_lessons', 'Number of lessons', NULL, 'Numărul de lecții', 'Número de aulas'), ('151', 'number_of_enrolment', 'Number of enrolment', NULL, 'Numărul de înscrieri', 'Número de matrículas'), ('152', 'number_of_student', 'Number of student', NULL, 'Numărul de elev', 'Número de aluno'), ('153', 'course_overview', 'Course overview', NULL, 'Privire de ansamblu asupra curs', 'Visão geral do curso'), ('154', 'active_courses', 'Active courses', NULL, 'Cursuri active', 'Cursos ativos'), ('155', 'pending_courses', 'Pending courses', NULL, 'Cursuri în așteptare', 'Cursos pendentes'), ('156', 'requested_withdrawal', 'Requested withdrawal', NULL, 'Retragere solicitată', 'Retirada solicitada'), ('157', 'january', 'January', NULL, 'ianuarie', 'Janeiro'), ('158', 'february', 'February', NULL, 'februarie', 'Fevereiro'), ('159', 'march', 'March', NULL, 'Martie', 'Março'), ('160', 'april', 'April', NULL, 'Aprilie', 'Abril'), ('161', 'may', 'May', NULL, 'Mai', 'Maio'), ('162', 'june', 'June', NULL, 'iunie', 'Junho'), ('163', 'july', 'July', NULL, 'iulie', 'Julho'), ('164', 'august', 'August', NULL, 'August', 'Agosto'), ('165', 'september', 'September', NULL, 'Septembrie', 'Setembro'), ('166', 'october', 'October', NULL, 'octombrie', 'Outubro'), ('167', 'november', 'November', NULL, 'noiembrie', 'Novembro'), ('168', 'december', 'December', NULL, 'decembrie', 'Dezembro'), ('169', 'this_year', 'This year', NULL, 'Anul acesta', 'Este ano'), ('170', 'active_course', 'Active course', NULL, 'Curs activ', 'Curso ativo'), ('171', 'pending_course', 'Pending course', NULL, 'Curs în așteptare', 'Curso pendente'), ('172', 'heads_up', 'Heads up', NULL, 'Atenție', 'Atenção'), ('173', 'congratulations', 'Congratulations', NULL, 'Felicitări', 'Parabéns'), ('174', 'oh_snap', 'Oh snap', NULL, 'Oh, trage', 'Ah, não'), ('175', 'please_fill_all_the_required_fields', 'Please fill all the required fields', NULL, 'Vă rugăm să completați toate câmpurile obligatorii', 'Por favor preencha todos os campos obrigatórios'), ('176', 'close', 'Close', NULL, 'Închide', 'Fechar'), ('177', 'cancel', 'Cancel', NULL, 'Anulare', 'cancelar'), ('178', 'continue', 'Continue', NULL, 'Continua', 'continuar'), ('179', 'ok', 'Ok', NULL, 'Bine', 'ok'), ('180', 'success', 'Success', NULL, 'Succes', 'sucesso'), ('181', 'your_server_does_not_allow_uploading_files_that_large.', 'Your server does not allow uploading files that large.', NULL, NULL, 'Seu servidor não permite upload de arquivos tão grandes.'), ('182', 'your_servers_file_upload_limit_is_128mb', 'Your servers file upload limit is 128mb', NULL, NULL, 'O limite de upload de arquivos do seu servidor é de 128 MB'), ('183', 'successfully', 'Successfully', NULL, 'Cu succes', 'com sucesso'), ('184', 'div_added_to_bottom_', 'Div added to bottom ', NULL, 'Div adăugat în partea de jos', 'Div adicionado ao final'), ('185', 'div_has_been_deleted_', 'Div has been deleted ', NULL, 'Div a fost șters', 'A div foi excluída'), ('186', 'multi_language_settings', 'Multi language settings', NULL, 'Setări în mai multe limbi', 'Configurações multilíngues'), ('187', 'manage_language', 'Manage language', NULL, 'Gestionați limba', 'Gerenciar idioma'), ('188', 'language_list', 'Language list', NULL, 'Lista de limbi', 'Lista de idiomas'), ('189', 'add_language', 'Add language', NULL, 'Adăugați limba', 'Adicionar idioma'), ('190', 'import_language', 'Import language', NULL, 'Limba de import', 'Idioma de importação'), ('191', 'language', 'Language', NULL, 'Limba', 'Linguagem'), ('192', 'direction', 'Direction', NULL, NULL, 'Direção'), ('193', 'option', 'Option', NULL, 'Opțiune', 'Opção'), ('194', 'ltr', 'Ltr', NULL, NULL, 'Ltr'), ('195', 'rtl', 'Rtl', NULL, NULL, 'Rtl'), ('196', 'edit_phrase', 'Edit phrase', NULL, 'Editați fraza', 'Editar frase'), ('197', 'export', 'Export', NULL, 'Export', 'Exportar'), ('198', 'delete_language', 'Delete language', NULL, 'Ștergeți limba', 'Excluir idioma'), ('199', 'add_new_phrase', 'Add new phrase', NULL, 'Adăugați o frază nouă', 'Adicionar nova frase'), ('200', 'save', 'Save', NULL, 'Salvați', 'Salvar'), ('201', 'add_new_language', 'Add new language', NULL, 'Adăugați o limbă nouă', 'Adicionar novo idioma'), ('202', 'no_special_character_or_space_is_allowed', 'No special character or space is allowed', NULL, 'Nu este permis niciun caracter special sau spațiu', 'Nenhum caractere especial ou espaço é permitido'), ('203', 'valid_examples', 'Valid examples', NULL, 'Exemple valide', 'Exemplos válidos'), ('204', 'choose_your_json_file', 'Choose your json file', NULL, 'Alegeți fișierul json', 'Escolha seu arquivo json'), ('205', 'import', 'Import', NULL, 'Import', 'Importar'), ('206', 'phrase_updated', 'Phrase updated', NULL, 'Expresia a fost actualizată', 'Frase atualizada'), ('207', 'language_added_successfully', 'Language added successfully', NULL, 'Limba adăugată cu succes', 'Idioma adicionado com sucesso'), ('208', 'website_name', 'Website name', NULL, 'Numele site-ului', 'Nome do site'), ('209', 'website_title', 'Website title', NULL, 'Titlul site-ului', 'Título do site'), ('210', 'website_keywords', 'Website keywords', NULL, 'Cuvinte cheie pentru site-uri web', 'Palavras-chave do site'), ('211', 'website_description', 'Website description', NULL, 'Descrierea site-ului', 'Descrição do site'), ('212', 'author', 'Author', NULL, 'Autor', 'Autor'), ('213', 'slogan', 'Slogan', NULL, 'Slogan', 'Slogan'), ('214', 'system_email', 'System email', NULL, 'E-mail de sistem', 'E-mail do sistema'), ('215', 'address', 'Address', NULL, 'Abordare', 'Endereço'), ('216', 'phone', 'Phone', NULL, 'Telefon', 'Telefone'), ('217', 'youtube_api_key', 'Youtube api key', NULL, 'Cheie API Youtube', 'Chave de API do YouTube'), ('218', 'get_youtube_api_key', 'Get youtube api key', NULL, 'Obțineți cheia API youtube', 'Obtenha a chave da API do YouTube'), ('219', 'if_you_want_to_use_google_drive_video,_you_need_to_enable_the_google_drive_service_in_this_api', 'If you want to use google drive video, you need to enable the google drive service in this api', NULL, NULL, 'Se quiser usar o Google Drive Video, você precisa ativar o serviço Google Drive nesta API'), ('220', 'vimeo_api_key', 'Vimeo api key', NULL, 'Tasta API Vimeo', 'Chave de API do Vimeo'), ('221', 'get_vimeo_api_key', 'Get vimeo api key', NULL, 'Obțineți cheia API Vimeo', 'Obtenha a chave da API do Vimeo'), ('222', 'purchase_code', 'Purchase code', NULL, 'Cod de achiziție', 'Código de compra'), ('223', 'system_language', 'System language', NULL, 'Limba sistemului', 'Idioma do sistema'), ('224', 'student_email_verification', 'Student email verification', NULL, 'Verificarea e-mailului studentului', 'Verificação de e-mail do aluno'), ('225', 'enable', 'Enable', NULL, 'Permite', 'Habilitar'), ('226', 'disable', 'Disable', NULL, 'Dezactivați', 'Desativar'), ('227', 'course_accessibility', 'Course accessibility', NULL, 'Accesibilitatea cursurilor', 'Acessibilidade do curso'), ('228', 'publicly', 'Publicly', NULL, 'Public', 'Publicamente'), ('229', 'only_logged_in_users', 'Only logged in users', NULL, 'Doar utilizatori autentificati', 'Somente usuários logados'), ('230', 'number_of_authorized_devices', 'Number of authorized devices', NULL, 'Numărul de dispozitive autorizate', 'Número de dispositivos autorizados'), ('231', 'how_many_devices_do_you_want_to_allow_for_logging_in_using_a_single_account', 'How many devices do you want to allow for logging in using a single account', NULL, 'Câte dispozitive doriți să permiteți conectarea folosind un singur cont', 'Quantos dispositivos você deseja permitir o login usando uma única conta'), ('232', 'course_selling_tax', 'Course selling tax', NULL, 'Taxa de vânzare curs', 'Taxa de venda do curso'), ('233', 'enter_0_if_you_want_to_disable_the_tax_option', 'Enter 0 if you want to disable the tax option', NULL, 'Introduceți 0 dacă doriți să dezactivați opțiunea fiscală', 'Digite 0 se desejar desativar a opção de imposto'), ('234', 'google_analytics_id', 'Google analytics id', NULL, 'ID Google Analytics', 'ID do Google Analytics'), ('235', 'keep_it_blank_if_you_want_to_disable_it', 'Keep it blank if you want to disable it', NULL, 'Păstrați-l gol dacă doriți să îl dezactivați', 'Deixe em branco se quiser desativá-lo'), ('236', 'meta_pixel_id', 'Meta pixel id', NULL, 'Meta pixel id', 'ID de meta pixel'), ('237', 'footer_text', 'Footer text', NULL, 'Text de subsol', 'Texto de rodapé'), ('238', 'footer_link', 'Footer link', NULL, 'Link de subsol', 'Link do rodapé'), ('239', 'timezone', 'Timezone', NULL, NULL, 'Fuso horário'), ('240', 'can_students_disable_their_own_accounts?', 'Can students disable their own accounts?', NULL, NULL, 'Os alunos podem desativar suas próprias contas?'), ('241', 'update_product', 'Update product', NULL, 'Actualizați produsul', 'Atualizar produto'), ('242', 'file', 'File', NULL, 'Fişier', 'Arquivo'), ('243', 'update', 'Update', NULL, 'Actualizați', 'Atualizar'), ('244', 'system_settings_updated', 'System settings updated', NULL, 'Setările sistemului au fost actualizate', 'Configurações do sistema atualizadas'), ('245', 'frontend_settings', 'Frontend settings', NULL, 'Setări pentru front-end', 'Configurações de front-end'), ('246', 'home_layout', 'Home layout', NULL, NULL, 'Layout inicial'), ('247', 'home_page_settings', 'Home page settings', NULL, NULL, 'Configurações da página inicial'), ('248', 'website_faqs', 'Website faqs', NULL, 'Întrebări frecvente pe site', 'Perguntas frequentes do site'), ('249', 'contact_information', 'Contact information', NULL, NULL, 'Informações de contato'), ('250', 'recaptcha', 'Recaptcha', NULL, 'Recaptcha', 'Recaptcha'), ('251', 'logo_&_images', 'Logo & images', NULL, NULL, 'Logotipo e imagens'), ('252', 'custom_codes', 'Custom codes', NULL, NULL, 'Códigos personalizados'), ('253', 'frontend_website_settings', 'Frontend website settings', NULL, 'Setări site-ul frontend', 'Configurações do site front-end'), ('254', 'banner_title', 'Banner title', NULL, 'Titlul bannerului', 'Título do banner'), ('255', 'banner_sub_title', 'Banner sub title', NULL, 'Subtitlul bannerului', 'Subtítulo do banner'), ('256', 'cookie_status', 'Cookie status', NULL, 'Starea cookie-urilor', 'Estado dos cookies'), ('257', 'active', 'Active', NULL, 'Activ', 'Ativo'), ('258', 'inactive', 'Inactive', NULL, 'Inactiv', 'Inativo'), ('259', 'cookie_note', 'Cookie note', NULL, 'Notă de cookie', 'Nota sobre cookie'), ('260', 'facebook', 'Facebook', NULL, 'Facebook', 'Facebook'), ('261', 'twitter', 'Twitter', NULL, 'Stare de nervozitate', 'Twitter'), ('262', 'linkedin', 'Linkedin', NULL, 'Linkedin', 'Linkedin'), ('263', 'update_settings', 'Update settings', NULL, 'Actualizați setările', 'Atualizar configurações'), ('264', 'activated', 'Activated', NULL, 'Activat', 'ativado'), ('265', 'motivational_speech', 'Motivational speech', NULL, 'Discurs motivațional', 'Discurso motivacional'), ('266', 'title', 'Title', NULL, 'Titlu', 'Título'), ('267', 'description', 'Description', NULL, 'Descriere', 'Descrição'), ('268', 'image', 'Image', NULL, 'Imagine', 'Imagem'), ('269', 'upload_image', 'Upload image', NULL, 'Incarca imaginea', 'Enviar Imagem'), ('270', 'faq_question', 'Faq question', NULL, 'Întrebare frecventă', 'Pergunta frequente'), ('271', 'save_changes', 'Save changes', NULL, 'Salvează modificările', 'Salvar alterações'), ('272', 'home_page_section', 'Home page section', NULL, NULL, 'Seção da página inicial'), ('273', 'upcoming_course_section', 'Upcoming course section', NULL, NULL, 'Seção do próximo curso'), ('274', 'top_course_section', 'Top course section', NULL, NULL, 'Seção principal do curso'), ('275', 'latest_course_section', 'Latest course section', NULL, NULL, 'Seção do curso mais recente'), ('276', 'top_category_section', 'Top category section', NULL, NULL, 'Seção da categoria principal'), ('277', 'top_instructor_section', 'Top instructor section', NULL, NULL, 'Seção de instrutor principal'), ('278', 'faq_section', 'Faq section', NULL, NULL, 'Seção de perguntas frequentes'), ('279', 'motivational_speech_section', 'Motivational speech section', NULL, NULL, 'Seção de discurso motivacional'), ('280', 'blog_visibility_on_the_home_page', 'Blog visibility on the home page', NULL, 'Vizibilitatea blogului pe pagina de start', 'Visibilidade do blog na página inicial'), ('281', 'promotional_section', 'Promotional section', NULL, NULL, 'Seção promocional'), ('282', 'question', 'Question', NULL, 'Întrebare', 'Pergunta'), ('283', 'answer', 'Answer', NULL, 'Răspuns', 'Responder'), ('284', 'contact_email', 'Contact email', NULL, NULL, 'Email de contato'), ('285', 'phone_number', 'Phone number', NULL, NULL, 'Número de telefone'), ('286', 'office_hours', 'Office hours', NULL, NULL, 'Horário comercial'), ('287', 'submit', 'Submit', NULL, 'Trimite', 'Enviar'), ('288', 'recaptcha_settings', 'Recaptcha settings', NULL, 'Setări Recaptcha', 'Configurações de recaptcha'), ('289', 'recaptcha_status', 'Recaptcha status', NULL, 'Starea recaptcha', 'Status de recaptcha'), ('290', 'recaptcha_sitekey', 'Recaptcha sitekey', NULL, 'Recaptcha sitekey', 'Chave do site Recaptcha'), ('291', 'recaptcha_secretkey', 'Recaptcha secretkey', NULL, 'Recaptcha cheie secretă', 'Chave secreta de recaptcha'), ('292', 'update_recaptcha_settings', 'Update recaptcha settings', NULL, 'Actualizați setările recaptcha', 'Atualizar configurações de recaptcha'), ('293', 'update_banner_image', 'Update banner image', NULL, 'Actualizați imaginea bannerului', 'Atualizar imagem do banner'), ('294', 'upload_banner_image', 'Upload banner image', NULL, 'Încărcați imaginea bannerului', 'Carregar imagem do banner'), ('295', 'update_light_logo', 'Update light logo', NULL, 'Actualizați sigla luminii', 'Atualizar logotipo claro'), ('296', 'upload_light_logo', 'Upload light logo', NULL, 'Încărcați sigla luminii', 'Carregar logotipo claro'), ('297', 'update_dark_logo', 'Update dark logo', NULL, 'Actualizați sigla întunecată', 'Atualizar logotipo escuro'), ('298', 'upload_dark_logo', 'Upload dark logo', NULL, 'Încărcați sigla întunecată', 'Carregar logotipo escuro'), ('299', 'update_small_logo', 'Update small logo', NULL, 'Actualizați sigla mică', 'Atualizar logotipo pequeno'), ('300', 'upload_small_logo', 'Upload small logo', NULL, 'Încărcați un logo mic', 'Carregar logotipo pequeno'), ('301', 'update_favicon', 'Update favicon', NULL, 'Actualizați favicon', 'Atualizar favicon'), ('302', 'upload_favicon', 'Upload favicon', NULL, 'Încărcați favicon', 'Carregar favicon'), ('303', 'you_can_modify_your_theme_style_and_add_external_embed_code_from_here', 'You can modify your theme style and add external embed code from here', NULL, NULL, 'Você pode modificar o estilo do seu tema e adicionar código de incorporação externo aqui'), ('304', 'enter_your_custom_css', 'Enter your custom css', NULL, NULL, 'Insira seu CSS personalizado'), ('305', 'only_css_code', 'Only css code', NULL, NULL, 'Somente código CSS'), ('306', 'these_codes_are_applicable_for_all_pages_of_the_frontend_site', 'These codes are applicable for all pages of the frontend site', NULL, NULL, 'Esses códigos são aplicáveis ​​a todas as páginas do site frontend'), ('307', 'enter_your_embed_or_widget_code', 'Enter your embed or widget code', NULL, NULL, 'Insira seu código de incorporação ou widget'), ('308', 'enter_your_embed_or_widget_code_here', 'Enter your embed or widget code here', NULL, NULL, 'Insira seu código de incorporação ou widget aqui'), ('309', 'new_home_page_layout_has_been_activated', 'New home page layout has been activated', NULL, 'A fost activat un nou aspect al paginii de pornire', 'O novo layout da página inicial foi ativado'), ('310', 'manage_your_drip_content_settings', 'Manage your drip content settings', NULL, NULL, 'Gerencie suas configurações de conteúdo de gotejamento'), ('311', 'lesson_completion_role', 'Lesson completion role', NULL, NULL, 'Função de conclusão da lição'), ('312', 'video_percentage_wise', 'Video percentage wise', NULL, NULL, 'Porcentagem de vídeo'), ('313', 'video_duration_wise', 'Video duration wise', NULL, NULL, 'Duração do vídeo em termos de duração'), ('314', 'minimum_duration_to_watch', 'Minimum duration to watch', NULL, NULL, 'Duração mínima para assistir'), ('315', 'minimum_percentage_to_watch', 'Minimum percentage to watch', NULL, NULL, 'Porcentagem mínima para assistir'), ('316', 'message_for_locked_lesson', 'Message for locked lesson', NULL, NULL, 'Mensagem para aula bloqueada'), ('317', 'attention', 'Attention', NULL, NULL, 'Atenção'), ('318', 'the_auto_checkmark_is_only_applicable_for_video_lessons', 'The auto checkmark is only applicable for video lessons', NULL, NULL, 'A marca de seleção automática só é aplicável para videoaulas'), ('319', 'learn_more', 'Learn more', NULL, 'Află mai multe', 'Saber mais'), ('320', 'setup_payment_informations', 'Setup payment informations', NULL, NULL, 'Configurar informações de pagamento'), ('321', 'system_currency_settings', 'System currency settings', NULL, NULL, 'Configurações de moeda do sistema'), ('322', 'system_currency', 'System currency', NULL, NULL, 'Moeda do sistema'), ('323', 'select_system_currency', 'Select system currency', NULL, NULL, 'Selecione a moeda do sistema'), ('324', 'currency_position', 'Currency position', NULL, NULL, 'Posição monetária'), ('325', 'left', 'Left', NULL, NULL, 'Esquerda'), ('326', 'right', 'Right', NULL, NULL, 'Direita'), ('327', 'left_with_a_space', 'Left with a space', NULL, NULL, 'Esquerda com um espaço'), ('328', 'right_with_a_space', 'Right with a space', NULL, NULL, 'Direita com um espaço'), ('329', 'update_system_currency', 'Update system currency', NULL, NULL, 'Atualizar moeda do sistema'), ('330', 'want_to_keep_test_mode_enabled', 'Want to keep test mode enabled', NULL, NULL, 'Deseja manter o modo de teste ativado'), ('331', 'select_currency', 'Select currency', NULL, NULL, 'Escolha a moeda'), ('332', 'sandbox_client_id', 'Sandbox client id', NULL, 'ID client Sandbox', 'ID do sandbox do cliente'), ('333', 'sandbox_secret_key', 'Sandbox secret key', NULL, 'Cheie secretă pentru Sandbox', 'Chave secreta da sandbox'), ('334', 'production_client_id', 'Production client id', NULL, 'ID client de producție', 'ID do cliente de produção'), ('335', 'production_secret_key', 'Production secret key', NULL, 'Cheie secretă de producție', 'Chave secreta de produção'), ('336', 'public_key', 'Public key', NULL, 'Cheie publică', 'Chave pública'), ('337', 'secret_key', 'Secret key', NULL, 'Cheie secreta', 'Chave secreta'), ('338', 'public_live_key', 'Public live key', NULL, 'Cheie publică live', 'Chave pública ao vivo'), ('339', 'secret_live_key', 'Secret live key', NULL, 'Cheie secretă live', 'Chave ativa secreta'), ('340', 'key_id', 'Key id', NULL, 'Id-ul cheii', 'ID da chave'), ('341', 'theme_color', 'Theme color', NULL, 'Culoarea temei', 'Cor do tema'), ('342', 'api_key', 'Api key', NULL, NULL, 'Chave API'), ('343', 'other_parameter', 'Other parameter', NULL, NULL, 'Outro parâmetro'), ('344', 'pos_id', 'Pos id', NULL, NULL, 'ID da posição'), ('345', 'second_key', 'Second key', NULL, NULL, 'Segunda chave'), ('346', 'client_id', 'Client id', NULL, NULL, 'ID do Cliente'), ('347', 'client_secret', 'Client secret', NULL, NULL, 'Chave do cliente'), ('348', 'store_id', 'Store id', NULL, NULL, 'ID da loja'), ('349', 'store_password', 'Store password', NULL, NULL, 'Senha Loja'), ('350', 'skrill_merchant_email', 'Skrill merchant email', NULL, NULL, 'E-mail do comerciante Skrill'), ('351', 'secret_passphrase', 'Secret passphrase', NULL, NULL, 'Senha secreta'), ('352', 'shared_key', 'Shared key', NULL, NULL, 'Chave compartilhada'), ('353', 'app_key', 'App key', NULL, NULL, 'Chave do aplicativo'), ('354', 'app_secret', 'App secret', NULL, NULL, 'Segredo do aplicativo'), ('355', 'username', 'Username', NULL, NULL, 'Nome de usuário'), ('356', 'merchant_id', 'Merchant id', NULL, NULL, 'ID do comerciante'), ('357', 'merchant_password', 'Merchant password', NULL, NULL, 'Senha do comerciante'), ('358', 'signature_key', 'Signature key', NULL, NULL, ' Chave de assinatura'), ('359', 'api_secret', 'Api secret', NULL, NULL, ' Segredo da API'), ('360', 'ensure_that_the_system_currency_and_all_active_payment_gateway_currencies_are_same', 'Ensure that the system currency and all active payment gateway currencies are same', NULL, NULL, 'Certifique-se de que a moeda do sistema e todas as moedas ativas do gateway de pagamento sejam iguais'), ('361', 'welcome_to', NULL, 'Welcome to', 'Bun venit la', 'Bem-vindo ao'), ('362', 'join_for_free', NULL, 'Join for free', 'Înscrie-te gratis', 'Entre de graça'), ('363', 'happy_student', NULL, 'Happy student', 'Student fericit', 'Estudante feliz'), ('364', 'experienced_instructor', NULL, 'Experienced instructor', 'Instructor cu experienta', 'Instrutor experiente'), ('365', 'quality_courses', NULL, 'Quality courses', 'Cursuri de calitate', 'Cursos de qualidade'), ('366', 'latest_top_skills', NULL, 'Latest top skills', 'Cele mai recente abilități de top', 'Últimas principais habilidades'), ('367', 'stay_ahead_with_our_curated_courses,_mastering_in-demand_skills.', NULL, 'Stay ahead with our curated courses, mastering in-demand skills.', 'Stay ahead with our curated courses, mastering in-demand skills.', 'Fique à frente com nossos cursos selecionados, dominando as habilidades exigidas.'), ('368', 'globalization', NULL, 'Globalization', 'Globalizarea', 'Globalização'), ('369', 'opportunity_for_global_networking_and_collaboration_with_peers_worldwide.', NULL, 'Opportunity for global networking and collaboration with peers worldwide.', 'Opportunity for global networking and collaboration with peers worldwide.', 'Oportunidade de networking global e colaboração com pares em todo o mundo.'), ('370', 'cost-effectiveness', NULL, 'Cost-effectiveness', 'Eficiența costurilor', 'Custo-benefício'), ('371', 'cost-effective_compared_to_traditional_in-person_education.', NULL, 'Cost-effective compared to traditional in-person education.', 'Cost-effective compared to traditional in-person education.', 'Econômico em comparação com a educação presencial tradicional.'), ('372', 'popular_categories', NULL, 'Popular categories', 'Categorii populare', 'Categorias populares'), ('373', 'quality_educators', NULL, 'Quality educators', 'Educatori de calitate', 'Educadores de qualidade'), ('374', 'premium_courses', NULL, 'Premium courses', 'Cursuri premium', 'Cursos premium'), ('375', 'cost-free_course', NULL, 'Cost-free course', 'Curs gratuit', 'Curso gratuito'), ('376', 'write_a_public_review', NULL, NULL, 'Scrieți o recenzie publică', 'Escreva uma avaliação pública'), ('377', 'describe_your_experience_what_you_got_out_of_the_course_and_other_helpful_highlights', NULL, NULL, 'Descrieți experiența dvs. ceea ce ați obținut la curs și alte aspecte utile', 'Descreva sua experiência, o que você obteve com o curso e outros destaques úteis'), ('378', 'what_did_the_instructor_do_well_and_what_could_use_some_improvement', NULL, NULL, 'Ce a făcut bine instructorul și la ce ar putea folosi unele îmbunătățiri', 'O que o instrutor fez bem e o que poderia ser melhorado'), ('379', 'next', NULL, NULL, 'Următorul', 'Próximo'), ('380', 'previous', NULL, NULL, 'Anterior', 'Anterior'), ('381', 'publish', NULL, NULL, 'Publica', 'Publicar'), ('382', 'delete', 'Delete', NULL, 'Șterge', 'Excluir'), ('383', '404_page_not_found', NULL, NULL, '404 Pagina nu a fost găsită', 'ERRO 404 - Página não Encontrada'), ('384', 'search_for_courses', NULL, NULL, 'Căutați cursuri', 'Pesquisar cursos'), ('385', 'total', 'Total', NULL, 'Total', 'Total'), ('386', 'go_to_cart', NULL, NULL, 'Du-te la coș', 'Vá para o carrinho'), ('387', 'your_cart_is_empty', NULL, NULL, 'Coșul tău este gol', 'Seu carrinho está vazio'), ('388', 'this_is_not_the_web_page_you_are_looking_for', NULL, NULL, 'Aceasta nu este pagina web pe care o căutați', 'Esta não é a página da web que você está procurando'), ('389', 'step', NULL, NULL, 'Etapa', 'Etapa'), ('390', 'how_would_you_rate_this_course_overall', NULL, NULL, 'Cum ați evalua acest curs în ansamblu', 'Como você avaliaria este curso em geral'), ('391', 'all_category', 'All category', NULL, 'Toate categoriile', 'Todas as categorias'), ('392', 'showing_on_this_page', 'Showing on this page', NULL, 'Afișat pe această pagină', 'Mostrando nesta página'), ('393', 'filter', 'Filter', NULL, 'Filtru', 'Filtro'), ('394', 'show_more', 'Show more', NULL, 'Afișați mai multe', 'Mostre mais'), ('395', 'price', 'Price', NULL, 'Preț', 'Preço'), ('396', 'all', 'All', NULL, 'Toate', 'Todos'), ('397', 'free', 'Free', NULL, 'Gratuit', 'Livre'), ('398', 'paid', 'Paid', NULL, 'Plătit', 'Pago'), ('399', 'level', NULL, NULL, 'Nivel', 'Nível'), ('400', 'beginner', 'Beginner', NULL, 'Începător', 'Principiante'), ('401', 'advanced', NULL, NULL, 'Avansat', 'Avançado'), ('402', 'intermediate', NULL, NULL, 'Intermediar', 'Intermediário'), ('403', 'ratings', 'Ratings', NULL, 'Evaluări', 'Avaliações'), ('404', 'lessons', 'Lessons', NULL, 'Lecții', 'Lições'), ('405', 'hours', 'Hours', NULL, 'Ore', 'Horas'), ('406', 'show_less', 'Show less', NULL, 'Arata mai putin', 'Mostre menos'), ('407', 'course', 'Course', NULL, 'Curs', 'Curso'), ('408', 'students_enrolled', NULL, NULL, 'Elevii înscriși', 'Alunos matriculados'), ('409', 'created_by', 'Created by', NULL, 'Creat de', 'Criado por'), ('410', 'last_updated', 'Last updated', NULL, 'Ultima actualizare', 'Ultima atualização'), ('411', 'what_will_i_learn', NULL, NULL, 'Ce voi invata', 'O que vou aprender'), ('412', 'curriculum_for_this_course', NULL, NULL, 'Curriculum pentru acest curs', 'Currículo deste curso'), ('413', 'requirements', 'Requirements', NULL, 'Cerințe', 'Requisitos'), ('414', 'view_more', NULL, NULL, 'Vezi mai mult', 'Veja mais'), ('415', 'other_related_courses', NULL, NULL, 'Alte cursuri conexe', 'Outros cursos relacionados'), ('416', 'updated', NULL, NULL, 'Actualizat', 'Atualizada'), ('417', 'about_the_instructor', NULL, NULL, 'Despre instructor', 'Sobre o instrutor'), ('418', 'reviews', 'Reviews', NULL, 'Recenzii', 'Avaliações'), ('419', 'student_feedback', NULL, NULL, 'Feedback-ul elevilor', 'Feedback dos alunos'), ('420', 'average_rating', NULL, NULL, 'Rata medie', 'Classificação média'), ('421', 'buy_now', 'Buy now', NULL, 'Cumpără acum', 'Comprar agora'), ('422', 'added_to_cart', NULL, NULL, 'Adăugat în coș', 'Adicionado ao carrinho'), ('423', 'includes', NULL, NULL, 'Include', 'Inclui'), ('424', 'on_demand_videos', NULL, NULL, 'Videoclipuri la cerere', 'Vídeos sob demanda'), ('425', 'full_lifetime_access', NULL, NULL, 'Acces pe viață completă', 'Acesso vitalício completo'), ('426', 'access_on_mobile_and_tv', NULL, NULL, 'Acces pe mobil si tv', 'Acesso no celular e tv'), ('427', 'add_to_cart', 'Add to cart', NULL, 'Adaugă in coş', 'Adicionar ao carrinho'), ('428', 'please_wait', NULL, NULL, 'Va rugam asteptati', 'Por favor, aguarde'), ('429', 'preview_this_course', NULL, NULL, 'Previzualizează acest curs', 'Visualizar este curso'), ('430', 'course_preview', NULL, NULL, 'Previzualizare curs', 'Visualização do curso'), ('431', 'add_new_category', NULL, NULL, 'Adăugați o nouă categorie', 'Adicionar nova categoria'), ('432', 'enrolment', NULL, NULL, 'Înscriere', 'Inscrição'), ('433', 'addon_manager', NULL, NULL, 'Manager de suplimente', 'Gerenciador de complementos'), ('434', 'available_addons', NULL, NULL, 'Suplimente disponibile', 'Complementos disponíveis'), ('435', 'smtp_settings', NULL, NULL, 'Setări smtp', 'Configurações SMTP'), ('436', 'theme_settings', NULL, NULL, 'Setari tema', 'Configurações de tema'), ('437', 'enrolled_course', NULL, NULL, 'Curs inscris', 'Curso inscrito'), ('438', 'total_amount', NULL, NULL, 'Valoare totală', 'Montante total'), ('439', 'enrolment_date', NULL, NULL, 'Data înscrierii', 'Data de inscrição'), ('440', 'actions', 'Actions', NULL, 'Acțiuni', 'Ações'), ('441', 'private_messaging', NULL, NULL, 'Mesaje private', 'Mensagens privadas'), ('442', 'private_message', NULL, NULL, 'Mesaj privat', 'Mensagem privada'), ('443', 'new_message', NULL, NULL, 'Mesaj nou', 'Nova mensagem'), ('444', 'click_the_upload_h5p_file_button.', NULL, NULL, NULL, 'Clique no botão carregar arquivo h5p.'), ('445', 'menu', NULL, NULL, 'Meniul', 'Cardápio'), ('446', 'all_tutions', NULL, NULL, 'Toate preturile', 'Todas as aulas'), ('447', 'ebooks', 'Ebooks', NULL, 'Cărți electronice', 'E-books'), ('448', 'course_bundles', 'Course bundles', NULL, 'Pachetele de curs', 'Pacotes de cursos'), ('449', 'administrator', NULL, NULL, 'Administrator', 'Administrador'), ('450', 'lifetime_access', NULL, NULL, 'Acces pe viață', 'Acesso vitalício'), ('451', 'compare', 'Compare', NULL, 'Comparaţie', 'Comparar'), ('452', 'lectures', 'Lectures', NULL, 'Prelegeri', 'Palestras'), ('453', 'get_enrolled', NULL, NULL, 'Înscrieți-vă', 'Inscreva-se'), ('454', 'h5p_course', NULL, NULL, 'curs H5p', 'Curso H5p'), ('455', 'scorm_course', NULL, NULL, 'Curs scorm', 'Curso Scorm'), ('456', 'featured_instructor', NULL, NULL, 'Instructor recomandat', 'Instrutor em destaque'), ('457', 'all_rights_reserved', NULL, NULL, 'Toate drepturile rezervate', 'Todos os direitos reservados'), ('458', 'view_less', NULL, NULL, 'Vedeți mai puțin', 'Ver menos'), ('459', 'ai_writer', 'Ai writer', NULL, 'Ai scriitor', 'Ai Escritor'), ('460', 'course_bundle', 'Course bundle', NULL, 'Pachet de cursuri', 'Pacote de cursos'), ('461', 'add_new_bundle', 'Add new bundle', NULL, 'Adăugați un pachet nou', 'Adicionar novo pacote'), ('462', 'manage_bundle', 'Manage bundle', NULL, 'Gestionați pachetul', 'Gerenciar pacote'), ('463', 'subscription_report', 'Subscription report', NULL, 'Raport de abonament', 'Relatório de assinatura'), ('464', 'tutor_booking', 'Tutor booking', NULL, 'Rezervare tutore', 'Reserva de tutor'), ('465', 'subject_category', 'Subject category', NULL, 'Categoria de subiect', 'Categoria de assunto'), ('466', 'add_booking', 'Add booking', NULL, 'Adăugați rezervarea', 'Adicionar reserva'), ('467', 'all_bookings', 'All bookings', NULL, 'Toate rezervările', 'Todas as reservas'), ('468', 'booked_schedules', 'Booked schedules', NULL, 'Programe rezervate', 'Horários reservados'), ('469', 'live_class_settings', NULL, NULL, 'Setări de curs live', 'Configurações de aula ao vivo'), ('470', 'ebook', 'Ebook', NULL, 'Ebook', 'E-book'), ('471', 'all_ebooks', 'All ebooks', NULL, 'Toate cărțile electronice', 'Todos os e-books'), ('472', 'add_ebook', 'Add ebook', NULL, 'Adăugați o carte electronică', 'Adicionar e-book'), ('473', 'payment_history', 'Payment history', NULL, 'Istoria platilor', 'Histórico de pagamento'), ('474', 'category', 'Category', NULL, 'Categorie', 'Categoria'), ('475', 'affiliate', 'Affiliate', NULL, 'Afiliat', 'Afiliado'), ('476', 'affliliator_list', 'Affliliator list', NULL, 'Lista de afiliați', 'Lista de afiliados'), ('477', 'affiliation_history', 'Affiliation history', NULL, 'Istoricul afilierii', 'Histórico de afiliação'), ('478', 'payouts', 'Payouts', NULL, 'Plăți', 'Pagamentos'), ('479', 'create_affiliator', 'Create affiliator', NULL, 'Creați un afiliat', 'Criar afiliado'), ('480', 'affiliation_settings', 'Affiliation settings', NULL, 'Setări de afiliere', 'Configurações de afiliação'), ('481', 'offline_payment', 'Offline payment', NULL, 'Plată offline', 'Pagamento off-line'), ('482', 'pending_request', 'Pending request', NULL, 'Cerere in asteptare', 'Pedido pendente'), ('483', 'accepted_request', 'Accepted request', NULL, 'Cerere acceptată', 'Solicitação aceita'), ('484', 'suspended_request', 'Suspended request', NULL, 'Cerere suspendată', 'Solicitação suspensa'), ('485', 'offline_payment_settings', 'Offline payment settings', NULL, 'Setări de plată offline', 'Configurações de pagamento off-line'), ('486', 'customer_support', 'Customer support', NULL, 'Relații Clienți', 'Suporte ao cliente'), ('487', 'ticket_list', 'Ticket list', NULL, 'Lista de bilete', 'Lista de ingressos'), ('488', 'support_category', 'Support category', NULL, 'Categoria suport', 'Categoria de suporte'), ('489', 'macro', 'Macro', NULL, 'Macro', 'macro'), ('490', 'create_ticket', 'Create ticket', NULL, 'Creați un bilet', 'Criar ingresso'), ('491', 'certificate_settings', 'Certificate settings', NULL, 'Setări de certificat', 'Configurações de certificado'), ('492', 's3_settings', NULL, NULL, 'Setări S3', 'Configurações S3'), ('493', 'open_ai_settings', 'Open ai settings', NULL, 'Deschideți setările IA', 'Abra as configurações de IA'), ('494', 'custom_page', NULL, NULL, 'Pagina personalizată', 'Página personalizada'), ('495', 'email', NULL, NULL, 'E-mail', 'E-mail'), ('496', 'requested_withdrawal_amount', NULL, NULL, 'Suma de retragere solicitată', 'Valor de saque solicitado'), ('497', 'provide_your_valid_login_credentials', NULL, NULL, 'Furnizați datele dvs. de conectare valide', 'Forneça suas credenciais de login válidas'), ('498', 'continue_with_email', NULL, NULL, 'Continuați cu e-mailul', 'Continuar com e-mail'), ('499', 'forgot_password', NULL, NULL, 'Aţi uitat parola', 'Esqueceu sua senha'), ('500', 'do_not_have_an_account', NULL, NULL, 'Nu ai un cont', 'Não possui uma conta'), ('501', 'not_found', NULL, NULL, 'Nu a fost găsit', 'Não encontrado'), ('502', 'about_this_application', NULL, NULL, 'Despre această aplicație', 'Sobre este aplicativo'), ('503', 'software_version', NULL, NULL, 'Versiune software', 'Versão do software'), ('504', 'check_update', NULL, NULL, 'Verifica actualizarea', 'Checar atualização'), ('505', 'php_version', NULL, NULL, 'versiunea PHP', 'Versão PHP'), ('506', 'curl_enable', NULL, NULL, 'Activare curl', 'Habilitar curvatura'), ('507', 'enabled', NULL, NULL, 'Activat', 'Habilitado'), ('508', 'product_license', NULL, NULL, 'Licență de produs', 'Licença do produto'), ('509', 'invalid', NULL, NULL, 'Invalid', 'Inválido'), ('510', 'enter_valid_purchase_code', NULL, NULL, 'Introduceți codul de achiziție valid', 'Insira um código de compra válido'), ('511', 'customer_support_status', NULL, NULL, 'Starea asistenței pentru clienți', 'Status do suporte ao cliente'), ('512', 'support_expiry_date', NULL, NULL, 'Data de expirare a suportului', 'Data de expiração do suporte'), ('513', 'customer_name', NULL, NULL, 'Numele clientului', 'Nome do cliente'), ('514', 'product_updated_successfully', NULL, NULL, 'Produsul a fost actualizat cu succes', 'Produto atualizado com sucesso'), ('515', 'your_servers_file_upload_limit_is_900mb', NULL, NULL, 'Limita de încărcare a fișierelor de pe serverele dvs. este de 900 MB', 'O limite de upload de arquivos do seu servidor é de 900 MB'), ('516', '', NULL, NULL, '', ''), ('517', 'upcoming', 'Upcoming', NULL, 'În viitor', 'Por vir'), ('518', 'upcoming_courses', 'Upcoming courses', NULL, 'Cursuri viitoare', 'Próximos cursos'), ('519', 'discover_a_world_of_learning_opportunities_through_our_upcoming_courses,_where_industry_experts_and_thought_leaders_will_guide_you_in_acquiring_new_expertise,_expanding_your_horizons,_and_reaching_your_full_potential.', NULL, NULL, 'Discover a world of learning opportunities through our upcoming courses, where industry experts and thought leaders will guide you in acquiring new expertise, expanding your horizons, and reaching your full potential.', 'Descubra um mundo de oportunidades de aprendizagem por meio de nossos próximos cursos, onde especialistas do setor e líderes inovadores irão guiá-lo na aquisição de novos conhecimentos, na expansão de seus horizontes e no alcance de todo o seu potencial.'), ('520', 'outcomes', 'Outcomes', NULL, 'Rezultate', 'Resultados'), ('521', 'remove_from_cart', 'Remove from cart', NULL, 'Scoateți din coș', 'Remover do carrinho'), ('522', 'enroll_now', NULL, NULL, 'Inscrie-te acum', 'Inscreva-se agora'), ('523', 'top_instructors', NULL, NULL, 'Instructori de top', 'Melhores instrutores'), ('524', 'they_efficiently_serve_large_number_of_students_on_our_platform', NULL, NULL, 'Deservesc eficient un număr mare de studenți pe platforma noastră', 'Eles atendem com eficiência um grande número de alunos em nossa plataforma'), ('525', 'thanks_for_subscribing_to_our_newsletter', 'Thanks for subscribing to our newsletter', NULL, 'Vă mulțumim că v-ați abonat la newsletter-ul nostru', 'Obrigado por assinar nossa newsletter'), ('526', 'such_script_searches_are_not_allowed', NULL, NULL, 'Astfel de căutări de script nu sunt permise', 'Essas pesquisas de script não são permitidas'), ('527', 'list_view', NULL, NULL, 'Vizualizare listă', 'Exibição de lista'), ('528', 'grid_view', NULL, NULL, 'Vizualizare grilă', 'Visualização em grade'), ('529', 'reset', NULL, NULL, 'Resetați', 'Reiniciar'), ('530', 'showing', 'Showing', NULL, 'Se arată', 'Mostrando'), ('531', 'of', 'Of', NULL, 'De', 'De'), ('532', 'results', 'Results', NULL, 'Rezultate', 'Resultados'), ('533', 'newly_published', NULL, NULL, 'Nou publicat', 'Recentemente publicado'), ('534', 'highest_rating', NULL, NULL, 'Cel mai mare rating', 'Classificação mais alta'), ('535', 'lowest_price', NULL, NULL, 'Cel mai mic pret', 'Menor preço'), ('536', 'highest_price', NULL, NULL, 'Cel mai mare preț', 'Preço mais alto'), ('537', 'discounted', NULL, NULL, 'Reducere', 'Desconto'), ('538', 'bundles', NULL, NULL, 'Pachete', 'Pacotes'), ('539', 'search_for_bundle', 'Search for bundle', NULL, 'Căutați pachet', 'Pesquisar pacote'), ('540', 'rating_updated_successfully', 'Rating updated successfully', NULL, 'Evaluarea a fost actualizată cu succes', 'Classificação atualizada com sucesso'), ('541', 'please_select_a_rating_greater_than_0', 'Please select a rating greater than 0', NULL, 'Vă rugăm să selectați o evaluare mai mare de 0', 'Selecione uma classificação superior a 0'), ('542', 'your_subscription_date_is_over_please_renew_your_bundle', 'Your subscription date is over please renew your bundle', NULL, 'Data abonamentului s-a încheiat, vă rugăm să reînnoiți pachetul', 'A data da sua assinatura expirou, renove o seu pacote'), ('543', 'bundle_details', NULL, NULL, 'Detalii pachet', 'Detalhes do pacote'), ('544', 'buy', NULL, NULL, 'Cumpără', 'Comprar'), ('545', 'all_categories', NULL, NULL, 'Toate categoriile', 'Todas as categorias'), ('546', 'view_details', NULL, NULL, 'Vezi detalii', 'Ver detalhes'), ('547', 'send_request', NULL, NULL, 'Trimite cerere', 'Enviar pedido'), ('548', 'back_to_login', NULL, NULL, 'Înapoi la autentificare', 'Volte ao login'), ('549', 'my_course', NULL, NULL, 'Cursul meu', 'Meu curso'), ('550', 'by', 'By', NULL, 'De', 'Por'), ('551', 'go_to_wishlist', NULL, NULL, 'Accesați lista de dorințe', 'Ir para a lista de desejos'), ('552', 'become_a_instructor', NULL, NULL, 'Deveniți instructor', 'Torne-se um instrutor'), ('553', 'my_courses', NULL, NULL, 'Cursurile mele', 'Meus cursos'), ('554', 'my_wishlist', NULL, NULL, 'Lista mea de dorinte', 'Minha Lista de Desejos'), ('555', 'my_messages', NULL, NULL, 'Mesajele mele', 'Minhas mensagens'), ('556', 'user_profile', NULL, NULL, 'Profil de utilizator', 'Perfil de usuário'), ('557', 'support', NULL, NULL, 'A sustine', 'Apoiar'), ('558', 'start_now', NULL, NULL, 'Începe acum', 'Comece agora'), ('559', 'gift_someone_else', NULL, NULL, 'Cadou altcuiva', 'Presenteie outra pessoa'), ('560', 'wishlist', NULL, NULL, 'lista de dorințe', 'Lista de Desejos'), ('561', 'messages', NULL, NULL, 'Mesaje', 'Mensagens'), ('562', 'profile', NULL, NULL, 'Profil', 'Perfil'), ('563', 'account_credentials', NULL, NULL, 'Acreditările contului', 'Credenciais da conta'), ('564', 'go_to_course_page', NULL, NULL, 'Accesați pagina cursului', 'Ir para a página do curso'), ('565', 'author_profile', NULL, NULL, 'Profilul autorului', 'Perfil do autor'), ('566', 'quizzes', NULL, NULL, 'Chestionare', 'Testes'), ('567', 'expiry_period', 'Expiry period', NULL, 'Perioada de expirare', 'Período de expiração'), ('568', 'upcoming_live_class', NULL, NULL, 'Următorul curs live', 'Próxima aula ao vivo'), ('569', 'enrolled', 'Enrolled', NULL, 'Înscris', 'Inscrito'), ('570', 'overview', 'Overview', NULL, 'Prezentare generală', 'Visão geral'), ('571', 'curriculum', 'Curriculum', NULL, 'Curriculum', 'Currículo'), ('572', 'instructor', 'Instructor', NULL, 'Instructor', 'Instrutor'), ('573', 'course_description', 'Course description', NULL, 'Descrierea cursului', 'Descrição do Curso'), ('574', 'what_will_i_learn?', 'What will i learn?', NULL, 'What will i learn?', 'O que vou aprender'), ('575', 'instructor_profile', NULL, NULL, 'Profilul instructorului', 'Perfil do instrutor'), ('576', 'how_to_shoot_cinematic_tech_videos_like_apple', NULL, NULL, 'Cum să înregistrezi videoclipuri tehnologice cinematografice precum Apple', 'Como gravar vídeos cinematográficos de tecnologia como a Apple'), ('577', 'compare_this_course', 'Compare this course', NULL, 'Compara acest curs', 'Compare este curso'), ('578', 'skill_level', 'Skill level', NULL, 'Nivelul de aptitudine', 'Nível de habilidade'), ('579', 'lifetime', 'Lifetime', NULL, 'Durata de viață', 'Vida'), ('580', 'certificate', 'Certificate', NULL, 'Certificat', 'Certificado'), ('581', 'related_courses', 'Related courses', NULL, 'Cursuri conexe', 'Cursos relacionados'), ('582', 'first_name', NULL, NULL, 'Nume', 'Primeiro nome'), ('583', 'enter_your_first_name', NULL, NULL, 'Introduceți prenumele dvs', 'Digite seu primeiro nome'), ('584', 'last_name', NULL, NULL, 'Nume', 'Sobrenome'), ('585', 'enter_your_last_name', NULL, NULL, 'Introduceți numele dvs. de familie', 'Digite seu sobrenome'), ('586', 'apply_to_become_a_instructor', NULL, NULL, 'Aplicați pentru a deveni instructor', 'Inscreva-se para se tornar um instrutor'), ('587', 'enter_your_phone_number', NULL, NULL, 'Introdu numarul tau de telefon', 'Digite seu número de telefone'), ('588', 'document', NULL, NULL, 'Document', 'Documento'), ('589', 'provide_some_documents_about_your_qualifications', NULL, NULL, 'Furnizați câteva documente despre calificările dvs', 'Forneça alguns documentos sobre suas qualificações'), ('590', 'already_you_have_an_account?', NULL, NULL, NULL, 'Você já tem uma conta?'), ('591', 'invalid_login_credentials', 'Invalid login credentials', NULL, 'Date de conectare nevalide', 'Credenciais de login inválidas'), ('592', 'publication_name', NULL, NULL, 'Numele publicației', 'Nome da Publicação'), ('593', 'published_date', NULL, NULL, 'Data publicării', 'Data de publicação'), ('594', 'category_name', NULL, NULL, 'Numele categoriei', 'Nome da Categoria'), ('595', 'read_preview', NULL, NULL, 'Citiți previzualizarea', 'Leia a visualização'), ('596', 'free_download', NULL, NULL, 'Descărcare gratuită', 'Download grátis'), ('597', 'book_specification_and_summary', NULL, NULL, 'Specificația cărții și rezumatul', 'Especificação e resumo do livro'), ('598', 'summary', NULL, NULL, 'rezumat', 'Resumo'), ('599', 'specification', NULL, NULL, 'Specificație', 'Especificação'), ('600', 'other_related_ebooks', NULL, NULL, 'Alte cărți electronice conexe', 'Outros e-books relacionados'), ('601', 'about_instructor', NULL, NULL, 'Despre instructor', 'Sobre o instrutor'), ('602', 'ebook_review', NULL, NULL, 'Recenzie de ebook', 'Revisão do e-book'), ('603', 'add_to_wishlist', NULL, NULL, 'Adaugă la lista de dorințe', 'Adicionar a lista de desejos'), ('604', 'added_to_wishlist', NULL, NULL, 'Adăugat la lista de dorințe', 'Adicionado à Lista de Desejos'), ('605', 'wordpress_theme_development_with_bootstrap', NULL, NULL, 'Dezvoltarea temei Wordpress cu bootstrap', 'Desenvolvimento de tema Wordpress com bootstrap'), ('606', 'home_page_layout', NULL, NULL, 'Aspectul paginii de pornire', 'Layout da página inicial'), ('607', 'banner_image_update', NULL, NULL, 'Actualizare imagine banner', 'Atualização da imagem do banner'), ('608', 'frontend_settings_updated', NULL, NULL, 'Setările pentru front-end au fost actualizate', 'Configurações de front-end atualizadas'), ('609', 'your_servers_file_upload_limit_is_512mb', NULL, NULL, 'Limita de încărcare a fișierelor de pe serverele dvs. este de 512 MB', 'O limite de upload de arquivos do seu servidor é de 512 MB'), ('610', 'blog_page_title', NULL, NULL, 'Titlul paginii de blog', 'Título da página do blog'), ('611', 'blog_page_subtitle', NULL, NULL, 'Subtitrarea paginii de blog', 'Legenda da página do blog'), ('612', 'instructors_blog_permission', NULL, NULL, 'Permisiunea blogului instructorilor', 'Permissão do blog dos instrutores'), ('613', 'visible', NULL, NULL, 'Vizibil', 'Visível'), ('614', 'invisible', NULL, NULL, 'Invizibil', 'Invisível'), ('615', 'blog_page_banner', NULL, NULL, 'Banner pentru pagina de blog', 'Banner da página do blog'), ('616', 'blog_settings_updated_successfully', NULL, NULL, 'Setările blogului au fost actualizate cu succes', 'Configurações do blog atualizadas com sucesso'), ('617', 'visit_our_latest_blogs', NULL, NULL, 'Vizitați cele mai recente bloguri ale noastre', 'Visite nossos blogs mais recentes'), ('618', 'visit_our_valuable_articles_to_get_more_information.', NULL, NULL, 'Visit our valuable articles to get more information.', 'Visite nossos valiosos artigos para obter mais informações.'), ('619', 'thu', NULL, NULL, 'joi', 'qui'), ('620', 'dec', NULL, NULL, 'Dec', 'Dezembro'), ('621', 'free_courses', 'Free courses', NULL, 'Cursuri gratuite', 'Cursos gratuitos'), ('622', 'paid_courses', 'Paid courses', NULL, 'Cursuri platite', 'Cursos pagos'), ('623', 'course_list', 'Course list', NULL, 'Lista de cursuri', 'Lista de cursos'), ('624', 'status', 'Status', NULL, 'stare', 'Status'), ('625', 'pending', 'Pending', NULL, 'In asteptarea', 'Pendente'), ('626', 'private', 'Private', NULL, 'Privat', 'Privado'), ('627', 'lesson_and_section', 'Lesson and section', NULL, 'Lecție și secțiune', 'Lição e seção'), ('628', 'enrolled_student', 'Enrolled student', NULL, 'Student inscris', 'Aluno matriculado'), ('629', 'mark_as_pending', 'Mark as pending', NULL, 'Marcați ca în așteptare', 'Marcar como pendente'), ('630', 'section_and_lesson', 'Section and lesson', NULL, 'Secțiune și lecție', 'Seção e lição'), ('631', 'academic_progress', 'Academic progress', NULL, 'Progresul academic', 'Progresso acadêmico'), ('632', 'edit_this_course', 'Edit this course', NULL, 'Editați acest curs', 'Editar este curso'), ('633', 'view_course_on_frontend', 'View course on frontend', NULL, 'Vizualizați cursul pe frontend', 'Ver curso no frontend'), ('634', 'go_to_course_playing_page', 'Go to course playing page', NULL, 'Accesați pagina de joc curs', 'Ir para a página de jogo do curso'), ('635', 'section', 'Section', NULL, 'Secțiune', 'Seção'), ('636', 'lesson', 'Lesson', NULL, 'Lecţie', 'Lição'), ('637', 'mark_as_active', 'Mark as active', NULL, 'Marcați ca activ', 'Marcar como ativo'), ('638', 'edit_course', NULL, NULL, 'Editați cursul', 'Editar curso'), ('639', 'course_manager', NULL, NULL, 'Manager de curs', 'Gerente de curso'), ('640', 'view_on_frontend', NULL, NULL, 'Vizualizare pe frontend', 'Ver no front-end'), ('641', 'back_to_course_list', NULL, NULL, 'Înapoi la lista de cursuri', 'Voltar à lista de cursos'), ('642', 'zoom_live_class', NULL, NULL, 'Zoom live curs', 'Zoom aula ao vivo'), ('643', 'jitsi_live_class', NULL, NULL, 'curs live Jitsi', 'Aula ao vivo de Jitsi'), ('644', 'assignment', NULL, NULL, 'Misiune', 'Atribuição'), ('645', 'noticeboard', NULL, NULL, 'Avizier', 'Quadro de notícias'), ('646', 'analytics', NULL, NULL, 'Analytics', 'Análise'), ('647', 'basic', NULL, NULL, 'De bază', 'Básico'), ('648', 'info', NULL, NULL, 'Info', 'Informações'), ('649', 'pricing', NULL, NULL, 'Prețuri', 'Preços'), ('650', 'media', NULL, NULL, 'Mass-media', 'meios de comunicação'), ('651', 'seo', NULL, NULL, 'Seo', 'SEO'), ('652', 'finish', NULL, NULL, 'finalizarea', 'Terminar'), ('653', 'add_new_section', NULL, NULL, 'Adăugați o nouă secțiune', 'Adicionar nova seção'), ('654', 'add_section', NULL, NULL, 'Adăugați o secțiune', 'Adicionar seção'), ('655', 'add_new_quiz', NULL, NULL, 'Adăugați un nou test', 'Adicionar novo questionário'), ('656', 'add_quiz', NULL, NULL, 'Adăugați test', 'Adicionar teste'), ('657', 'sort_sections', NULL, NULL, 'Sortați secțiuni', 'Classificar seções'), ('658', 'sort_lessons', NULL, NULL, 'Sortați lecțiile', 'Classificar aulas'), ('659', 'sort_lesson', NULL, NULL, 'Sortează lecția', 'Classificar lição'), ('660', 'update_section', NULL, NULL, 'Secțiunea de actualizare', 'Seção de atualização'), ('661', 'edit_section', NULL, NULL, 'Editați secțiunea', 'Editar seção'), ('662', 'delete_section', NULL, NULL, 'Ștergeți secțiunea', 'Excluir seção'), ('663', 'update_lesson', NULL, NULL, 'Actualizați lecția', 'Atualizar lição'), ('664', 'edit', NULL, NULL, 'Editați | ×', 'Editar'), ('665', 'quiz_results', NULL, NULL, 'Rezultatele testului', 'Resultados do questionário'), ('666', 'manage_quiz_questions', NULL, NULL, 'Gestionați întrebările testului', 'Gerenciar perguntas do quiz'), ('667', 'quiz_questions', NULL, NULL, 'Întrebări test', 'Perguntas do questionário'), ('668', 'update_quiz_information', NULL, NULL, 'Actualizați informațiile testului', 'Atualizar informações do questionário'), ('669', 'quiz', NULL, NULL, 'Test', 'Questionário'), ('670', 'live_class_schedule', NULL, NULL, 'Programul de curs live', 'Programação de aulas ao vivo'), ('671', 'date', NULL, NULL, 'Data', 'Data'), ('672', 'time', NULL, NULL, 'Timp', 'Tempo'), ('673', 'note_to_students', NULL, NULL, 'Notă pentru studenți', 'Nota para os alunos'), ('674', 'zoom_meeting_id', NULL, NULL, 'ID întâlnire Zoom', 'ID da reunião com zoom'), ('675', 'enter_meeting_id', NULL, NULL, 'Introduceți id-ul întâlnirii', 'Insira o ID da reunião'), ('676', 'zoom_meeting_password', NULL, NULL, 'Parola de întâlnire Zoom', 'Senha da reunião Zoom'), ('677', 'enter_meeting_password', NULL, NULL, 'Introduceți parola întâlnirii', 'Digite a senha da reunião'), ('678', 'course_enrolment_details', NULL, NULL, 'Detalii de înscriere la curs', 'Detalhes de inscrição no curso'), ('679', 'get', NULL, NULL, 'obține', 'Pegar'), ('680', 'meeting_plans_that_fit_your_business_perfectly', NULL, NULL, 'Planuri de întâlniri care se potrivesc perfect afacerii tale', 'Planos de reuniões que se adaptam perfeitamente ao seu negócio'), ('681', 'zoom_meeting_plans', NULL, NULL, 'Planuri de întâlnire Zoom', 'Planos de reunião com zoom'), ('682', 'jitsi_meeting_password', NULL, NULL, 'Parola de întâlnire Jitsi', 'Senha da reunião Jitsi'), ('683', 'make_sure_you_save_the_live_class_password_before_starting_the_class', NULL, NULL, 'Asigurați-vă că salvați parola pentru cursul live înainte de a începe cursul', 'Certifique-se de salvar a senha da aula ao vivo antes de iniciar a aula'), ('684', 'enter_your_class_topic', NULL, NULL, 'Introduceți subiectul clasei dvs', 'Insira o tema da sua aula'), ('685', 'enter_your_message', NULL, NULL, 'Introduceți mesajul dvs', 'Digite sua mensagem'), ('686', 'send_a_mail_to_students_to_join_this_live_class', NULL, NULL, 'Trimiteți un e-mail studenților pentru a se înscrie la acest curs live', 'Envie um e-mail aos alunos para participarem desta aula ao vivo'), ('687', 'start_live_video_class', NULL, NULL, 'Începeți cursul video live', 'Iniciar videoaula ao vivo'), ('688', 'sending_mail', NULL, NULL, 'Se trimite mail', 'Enviando email'), ('689', 'the_message_field_is_empty', NULL, NULL, 'Câmpul de mesaj este gol', 'O campo da mensagem está vazio'), ('690', 'create_new_assignment', NULL, NULL, 'Creați o nouă misiune', 'Criar nova tarefa'), ('691', 'assignment_title', NULL, NULL, 'Titlul sarcinii', 'Título da tarefa'), ('692', 'enter_assignment_title', NULL, NULL, 'Introduceți titlul sarcinii', 'Insira o título da tarefa'), ('693', 'questions', NULL, NULL, 'Întrebări', 'Questões'), ('694', 'enter_your_assignment_questions', NULL, NULL, 'Introduceți întrebările legate de temă', 'Insira as perguntas da sua tarefa'), ('695', 'question_file', NULL, NULL, 'Fișier cu întrebări', 'Arquivo de perguntas'), ('696', 'choose_file', NULL, NULL, 'Alege fișierul', 'Escolher arquivo'), ('697', 'total_marks', NULL, NULL, 'Note totale', 'Total de marcas'), ('698', 'deadline', NULL, NULL, 'Termen limită', 'Prazo final'), ('699', 'note', NULL, NULL, 'Notă', 'Observação'), ('700', 'submission_status', NULL, NULL, 'Statusul cererii', 'status de submissão'), ('701', 'draft', NULL, NULL, 'Proiect', 'Rascunho'), ('702', 'add_new_assignment', NULL, NULL, 'Adăugați o nouă misiune', 'Adicionar nova tarefa'), ('703', 'uploading', NULL, NULL, 'Încărcare', 'Enviando'), ('704', 'fill_up_the_required_feilds', NULL, NULL, 'Completați câmpurile necesare', 'Preencha os campos necessários'), ('705', 'course_title', 'Course title', NULL, 'Titlul cursului', 'Título do curso'), ('706', 'enter_your_notice_title', NULL, NULL, 'Introduceți titlul notificării dvs', 'Insira o título do seu aviso'), ('707', 'enter_your_notice_description', NULL, NULL, 'Introduceți descrierea notificării dvs', 'Insira a descrição do seu aviso'), ('708', 'send_mail_to_students_if_urgent', NULL, NULL, 'Trimiteți e-mail studenților dacă este urgent', 'Envie e-mail para os alunos se for urgente'), ('709', 'add_new_notice', NULL, NULL, 'Adăugați o notificare nouă', 'Adicionar novo aviso'), ('710', 'updating', NULL, NULL, 'Actualizare', 'Atualizando'), ('711', 'course_type', NULL, NULL, 'Tipul de curs', 'Tipo de curso'), ('712', 'general', NULL, NULL, 'General', 'Em geral'), ('713', 'the_course_type_can_not_be_editable', NULL, NULL, 'Tipul de curs nu poate fi editabil', 'O tipo de curso não pode ser editável'), ('714', 'instructor_of_this_course', NULL, NULL, 'Instructor al acestui curs', 'Instrutor deste curso'), ('715', 'enter_course_title', NULL, NULL, 'Introduceți titlul cursului', 'Insira o título do curso'), ('716', 'short_description', NULL, NULL, 'Scurta descriere', 'Pequena descrição'), ('717', 'select_a_category', NULL, NULL, 'Selectați o categorie', 'Selecione uma categoria'), ('718', 'select_sub_category', NULL, NULL, 'Selectați subcategoria', 'Selecione a subcategoria'), ('719', 'language_made_in', NULL, NULL, 'Limba făcută în', 'Linguagem feita em'), ('720', 'enable_drip_content', NULL, NULL, 'Activați conținutul prin picurare', 'Ativar conteúdo de gotejamento'), ('721', 'updated_as_a', NULL, NULL, 'Actualizat ca a', 'Atualizado como um'), ('722', 'private_course', NULL, NULL, 'Curs privat', 'Curso privado'), ('723', 'upcoming_course', NULL, NULL, 'Curs viitor', 'Próximo curso'), ('724', 'check_if_this_course_is_top_course', NULL, NULL, 'Verificați dacă acest curs este cursul de top', 'Verifique se este curso é o melhor'), ('725', 'course_faq', 'Course faq', NULL, 'Întrebări frecvente ale cursului', 'Perguntas frequentes do curso'), ('726', 'provide_requirements', NULL, NULL, 'Furnizați cerințe', 'Fornecer requisitos'), ('727', 'provide_outcomes', NULL, NULL, 'Oferiți rezultate', 'Forneça resultados'), ('728', 'check_if_this_is_a_free_course', NULL, NULL, 'Verificați dacă acesta este un curs gratuit', 'Verifique se este é um curso gratuito'), ('729', 'course_price', NULL, NULL, 'Pretul cursului', 'Preço do curso'), ('730', 'enter_course_course_price', NULL, NULL, 'Introduceți prețul cursului', 'Insira o preço do curso'), ('731', 'check_if_this_course_has_discount', NULL, NULL, 'Verificați dacă acest curs are reducere', 'Verifique se este curso tem desconto'), ('732', 'discounted_price', NULL, NULL, 'Pret redus', 'Preço com desconto'), ('733', 'this_course_has', NULL, NULL, 'Acest curs are', 'Este curso tem'), ('734', 'discount', NULL, NULL, 'Reducere', 'Desconto'), ('735', 'limited_time', NULL, NULL, 'Timp limitat', 'Tempo limitado'), ('736', 'number_of_month', NULL, NULL, 'Numărul lunii', 'Número do mês'), ('737', 'after_purchase,_students_can_access_the_course_until_your_selected_time.', NULL, NULL, NULL, 'Após a compra, os alunos poderão acessar o curso até o horário selecionado.'), ('738', 'course_overview_provider', NULL, NULL, 'Furnizor de prezentare generală a cursului', 'Provedor de visão geral do curso'), ('739', 'youtube', NULL, NULL, 'Youtube', 'YouTube'), ('740', 'vimeo', NULL, NULL, 'Vimeo', 'Vimeo'), ('741', 'html5', NULL, NULL, 'HTML5', 'HTML5'), ('742', 'course_overview_url', NULL, NULL, 'Url de prezentare generală a cursului', 'URL de visão geral do curso'), ('743', 'course_thumbnail', 'Course thumbnail', NULL, 'Miniatura cursului', 'Miniatura do curso'), ('744', 'meta_keywords', NULL, NULL, 'Cuvinte cheie meta', 'Meta palavras-chave'), ('745', 'write_a_keyword_and_then_press_enter_button', NULL, NULL, 'Scrieți un cuvânt cheie și apoi apăsați butonul Enter', 'Escreva uma palavra-chave e pressione o botão Enter'), ('746', 'meta_description', NULL, NULL, 'Meta descriere', 'Meta Descrição'), ('747', 'thank_you', NULL, NULL, 'Mulțumesc', 'Obrigado'), ('748', 'you_are_just_one_click_away', NULL, NULL, 'Ești la doar un clic distanță', 'Você está a apenas um clique de distância'), ('749', 'course_updated_successfully', NULL, NULL, 'Cursul a fost actualizat cu succes', 'Curso atualizado com sucesso'), ('750', 'course_progress_analytics', NULL, NULL, 'Analiza progresului cursului', 'Análise do progresso do curso'), ('751', 'completion_percentage', NULL, NULL, 'Procent de finalizare', 'Porcentagem de conclusão'), ('752', 'enrolled_students', NULL, NULL, 'Studenți înscriși', 'Alunos matriculados'), ('753', 'number_of_students', NULL, NULL, 'Numarul studentilor', 'Número de estudantes'), ('754', 'course_enrolments', NULL, NULL, 'Inscrieri la cursuri', 'Inscrições em cursos'), ('755', 'jan', NULL, NULL, 'ian', 'janeiro'), ('756', 'feb', NULL, NULL, 'feb', 'fevereiro'), ('757', 'mar', NULL, NULL, 'Mar', 'março'), ('758', 'apr', NULL, NULL, 'Aprilie', 'abril'), ('759', 'jun', NULL, NULL, 'Iunie', 'junho'), ('760', 'jul', NULL, NULL, 'iul', 'julho'), ('761', 'aug', NULL, NULL, 'aug', 'agosto'), ('762', 'sep', NULL, NULL, 'sept', 'setembro'), ('763', 'oct', NULL, NULL, 'oct', 'outubro'), ('764', 'nov', NULL, NULL, 'nov', 'novembro'), ('765', 'go', NULL, NULL, 'Merge', 'Ir'), ('766', 'the_dates_of_month', NULL, NULL, 'Datele lunii', 'As datas do mês'), ('767', 'upload_scorm_course', NULL, NULL, 'Încărcați cursul scorm', 'Carregar curso de scorm'), ('768', 'upload_course', NULL, NULL, 'Încărcați cursul', 'Carregar curso'), ('769', 'instruction', NULL, NULL, 'Instruire', 'Instrução'), ('770', 'click_the_upload_course_button', NULL, NULL, 'Faceți clic pe butonul de încărcare a cursului', 'Clique no botão de upload do curso'), ('771', 'you_will_get_a_floating_form_after_clicking_the_button', NULL, NULL, 'Veți primi un formular plutitor după ce faceți clic pe butonul', 'Você obterá um formulário flutuante após clicar no botão'), ('772', 'select_a_scorm_provider_first', NULL, NULL, 'Selectați mai întâi un furnizor de scorm', 'Selecione um provedor de scorm primeiro'), ('773', 'choose_your_scorm_zip_file', NULL, NULL, 'Alegeți fișierul zip scorm', 'Escolha seu arquivo zip scorm'), ('774', 'click_the_upload_button_to_save_the_course_file', NULL, NULL, 'Faceți clic pe butonul de încărcare pentru a salva fișierul cursului', 'Clique no botão de upload para salvar o arquivo do curso'), ('775', 'scorm', NULL, NULL, 'batjocor', 'Scorm'), ('776', 'upload_h5p_file', NULL, NULL, 'Încărcați fișierul h5p', 'Carregar arquivo h5p'), ('777', 'remove', NULL, NULL, 'Elimina', 'Remover'), ('778', 'click_the_upload_h5p_course_button.', NULL, NULL, NULL, 'Clique no botão de upload do curso h5p.'), ('779', 'choose_your_h5p_file.', NULL, NULL, NULL, 'Escolha seu arquivo h5p.'), ('780', 'h5p', NULL, NULL, 'H5p', 'H5p'), ('781', 'blogs', NULL, NULL, 'Bloguri', 'Blogues'), ('782', 'add_new_blog', NULL, NULL, 'Adăugați un blog nou', 'Adicionar novo blog'), ('783', 'creator', NULL, NULL, 'Creator', 'O Criador'), ('784', 'deactivate', NULL, NULL, 'Dezactivați', 'Desativar'), ('785', 'blog_details', NULL, NULL, 'Detalii blog', 'Detalhes do blog'), ('786', 'inspirational_journeys', NULL, NULL, 'Călătorii inspiraționale', 'Viagens inspiradoras'), ('787', 'follow_the_stories_of_academics_and_their_research_expeditions', NULL, NULL, 'Urmărește poveștile academicilor și expedițiile lor de cercetare', 'Acompanhe as histórias de acadêmicos e suas expedições de pesquisa'), ('788', 'comments', NULL, NULL, 'Comentarii', 'Comentários'), ('789', 'leave_a_comment', NULL, NULL, 'Lasa un comentariu', 'Deixe um comentário'), ('790', 'enter_your_comments_here', NULL, NULL, 'Introdu aici comentariile tale', 'Digite seus comentários aqui'), ('791', 'type_your_keywords', NULL, NULL, 'Introduceți cuvintele cheie', 'Digite suas palavras-chave'), ('792', 'recent_posts', NULL, NULL, 'Postări recente', 'Postagens recentes'), ('793', 'edit_blog', NULL, NULL, 'Editează blogul', 'Editar blog'), ('794', 'edit_your_blog', NULL, NULL, 'Editează-ți blogul', 'Edite seu blog'), ('795', 'enter_blog_title', NULL, NULL, 'Introduceți titlul blogului', 'Digite o título do blog'), ('796', 'keywords', NULL, NULL, 'Cuvinte cheie', 'Palavras-chave'), ('797', 'click_the_enter_button_after_writing_your_keyword', NULL, NULL, 'Faceți clic pe butonul Enter după ce ați scris cuvântul cheie', 'Clique no botão Enter depois de escrever sua palavra-chave'), ('798', 'blog_banner', NULL, NULL, 'Banner de blog', 'Banner do blog'), ('799', 'choose_a_banner', NULL, NULL, 'Alegeți un banner', 'Escolha um banner'), ('800', 'blog_thumbnail', NULL, NULL, 'Miniatura blogului', 'Miniatura do blog'), ('801', 'choose_a_thumbnail', NULL, NULL, 'Alegeți o miniatură', 'Escolha uma miniatura'), ('802', 'do_you_want_to_mark_it_as_popular', NULL, NULL, 'Doriți să-l marcați ca popular', 'Você quer marcá-lo como popular'), ('803', 'mark_as_popular', NULL, NULL, 'Marcați ca popular', 'Marcar como popular'), ('804', 'update_blog', NULL, NULL, 'Actualizați blogul', 'Atualizar blog'), ('805', 'blog_updated_successfully', NULL, NULL, 'Blog actualizat cu succes', 'Blog atualizado com sucesso'), ('806', 'add_instructor', NULL, NULL, 'Adăugați instructor', 'Adicionar instrutor'), ('807', 'photo', NULL, NULL, 'Fotografie', 'foto'), ('808', 'name', NULL, NULL, 'Nume', 'Nome'), ('809', 'enrolled_courses', NULL, NULL, 'Cursuri inscrise', 'Cursos inscritos'), ('810', 'view_courses', NULL, NULL, 'Vizualizați cursurile', 'Ver cursos'), ('811', 'instructor_edit', NULL, NULL, 'Editarea instructorului', 'Edição do instrutor'), ('812', 'instructor_edit_form', NULL, NULL, 'Formular de editare a instructorului', 'Formulário de edição do instrutor'), ('813', 'basic_info', NULL, NULL, 'Informatii de baza', 'Informação básica'), ('814', 'login_credentials', NULL, NULL, 'Date de conectare', 'Credenciais de login'), ('815', 'social_information', NULL, NULL, 'Informații sociale', 'Informações sociais'), ('816', 'payment_info', NULL, NULL, 'Informatii plată', 'informação de pagamento'), ('817', 'a_short_title_about_yourself', NULL, NULL, 'Un scurt titlu despre tine', 'Um breve título sobre você'), ('818', 'short_title', NULL, NULL, 'Titlu scurt', 'Título curto'), ('819', 'skills', NULL, NULL, 'Aptitudini', 'Habilidades'), ('820', 'write_your_skill_and_click_the_enter_button', NULL, NULL, 'Scrieți-vă abilitățile și faceți clic pe butonul Enter', 'Escreva sua habilidade e clique no botão Enter'), ('821', 'biography', NULL, NULL, 'Biografie', 'Biografia'), ('822', 'user_image', NULL, NULL, 'Imaginea utilizatorului', 'Imagem do usuário'), ('823', 'choose_user_image', NULL, NULL, 'Alegeți imaginea utilizatorului', 'Escolha a imagem do usuário'), ('824', 'razorpay', NULL, NULL, 'Razorpay', 'Razorpay'), ('825', 'required_for_instructor', NULL, NULL, 'Necesar pentru instructor', 'Obrigatório para instrutor'), ('826', 'stripe', NULL, NULL, 'Dunga', 'stripe'), ('827', 'paypal', NULL, NULL, 'Paypal', 'PayPal'), ('828', 'ccavenue', NULL, NULL, 'Ccavenue', 'Ccavenue'), ('829', 'ccavenue_merchant_id', NULL, NULL, 'Id-ul comerciantului Ccavenue', 'ID do comerciante Ccavenue'), ('830', 'ccavenue_working_key', NULL, NULL, 'Cheie de lucru Ccavenue', 'Chave de trabalho Ccavenue'), ('831', 'ccavenue_access_code', NULL, NULL, 'Cod de acces Ccavenue', 'Código de acesso Ccavenue'), ('832', 'iyzico', NULL, NULL, 'Iyzico', 'Iyzico'), ('833', 'api_test_key', NULL, NULL, 'Cheie de testare API', 'Chave de teste da API'), ('834', 'secret_test_key', NULL, NULL, 'Cheie de testare secretă', 'Chave de teste secreta'), ('835', 'api_live_key', NULL, NULL, 'Tasta API live', 'Chave ativa da API'), ('836', 'paystack', NULL, NULL, 'Paysstack', 'paystack'), ('837', 'public_test_key', NULL, NULL, 'Cheie publică de testare', 'Chave de teste pública'), ('838', 'paytm', NULL, NULL, 'Paytm', 'paytm'), ('839', 'paytm_merchant_key', NULL, NULL, 'Cheie de comerciant Paytm', 'Chave do comerciante Paytm'), ('840', 'paytm_merchant_mid', NULL, NULL, 'Comerciant Paytm mid', 'Comerciante Paytm médio'), ('841', 'paytm_merchant_website', NULL, NULL, 'Site-ul comercial Paytm', 'Site do comerciante Paytm'), ('842', 'industry_type_id', NULL, NULL, 'Id-ul tipului de industrie', 'ID do tipo de indústria'), ('843', 'channel_id', NULL, NULL, 'ID canal', 'ID do canal'), ('844', 'user_update_successfully', NULL, NULL, 'Actualizarea utilizatorului cu succes', 'Atualização do usuário com sucesso'), ('845', 'current_course_provider', NULL, NULL, 'Furnizor curent de cursuri', 'Provedor de curso atual'), ('846', 'ispring', NULL, NULL, 'Isprimava', 'ispring'), ('847', 'preview', NULL, NULL, 'previzualizare', 'Visualização'), ('848', 'update_scorm_course', NULL, NULL, 'Actualizați cursul scorm', 'Atualizar curso de Scorm'), ('849', 'update_course', NULL, NULL, 'Actualizați cursul', 'Curso de atualização'), ('850', 'student', NULL, NULL, 'Student', 'Estudante'), ('851', 'progress', NULL, NULL, 'Progres', 'Progresso'), ('852', 'not_started_yet', NULL, NULL, 'Încă nu a început', 'Não iniciado ainda'), ('853', 'not_completed_yet', NULL, NULL, 'Nu a fost finalizată încă', 'Ainda não completado'), ('854', 'enrolled_from', NULL, NULL, 'Înscris din', 'Inscrito de'), ('855', 'last_seen_on', NULL, NULL, 'Văzut ultima dată pe', 'Visto pela última vez em'), ('856', 'completed_on', NULL, NULL, 'Completat pe', 'Completo em'), ('857', 'completed_lesson', NULL, NULL, 'Lecție finalizată', 'Lição concluída'), ('858', 'out_of', NULL, NULL, 'Din', 'Fora de'), ('859', 'watched_duration', NULL, NULL, 'Durata urmărită', 'Duração assistida'), ('860', 'course_adding_form', NULL, NULL, 'Formular de adăugare a cursului', 'Formulário de adição de curso'), ('861', 'create_as_a', NULL, NULL, 'Creați ca a', 'Crie como um'), ('862', 'course_has_been_added_successfully', NULL, NULL, 'Cursul a fost adăugat cu succes', 'O curso foi adicionado com sucesso'), ('863', 'instructor_add', NULL, NULL, 'Add instructor', 'Instrutor adicionado'), ('864', 'instructor_add_form', NULL, NULL, 'Formular de adăugare a instructorului', 'Formulário de adição de instrutor'), ('865', 'sub_categories', NULL, NULL, 'Subcategorii', 'Subcategorias'), ('866', 'edit_category', NULL, NULL, 'Editați categoria', 'Editar categoria'), ('867', 'update_category', NULL, NULL, 'Actualizați categoria', 'Atualizar categoria'), ('868', 'update_category_form', NULL, NULL, 'Actualizați formularul categoriei', 'Atualizar formulário de categoria'), ('869', 'category_title', NULL, NULL, 'Titlul categoriei', 'Título da categoria'), ('870', 'parent', NULL, NULL, 'Mamă', 'Pai'), ('871', 'none', NULL, NULL, 'Nici unul', 'Nenhum'), ('872', 'select_none_to_create_a_parent_category', NULL, NULL, 'Selectați niciunul pentru a crea o categorie părinte', 'Selecione nenhum para criar uma categoria pai'), ('873', 'icon_picker', NULL, NULL, 'Selector de pictograme', 'Seletor de ícones'), ('874', 'category_thumbnail', NULL, NULL, 'Miniatura categoriei', 'Miniatura da categoria'), ('875', 'the_image_size_should_be', NULL, NULL, 'Dimensiunea imaginii ar trebui să fie', 'O tamanho da imagem deve ser'), ('876', 'choose_thumbnail', NULL, NULL, 'Alege miniatura', 'Escolha a miniatura'), ('877', 'data_added_successfully', NULL, NULL, 'Date adăugate cu succes', 'Dados adicionados com sucesso'), ('878', 'logo_updated', NULL, NULL, 'Logo-ul a fost actualizat', 'Logotipo atualizado'), ('879', 'favicon_updated', NULL, NULL, 'Favicon actualizat', 'Favicon atualizado'), ('880', 'motivational_speech_updated_successfully', NULL, NULL, 'Discursul motivațional a fost actualizat cu succes', 'Discurso motivacional atualizado com sucesso'), ('881', 'unlock_new_expertise_with_industry_experts_and_thought_leaders_in_our_upcoming_courses.', NULL, NULL, NULL, 'Desbloqueie novos conhecimentos com especialistas do setor e líderes inovadores em nossos próximos cursos.'), ('882', 'duration', NULL, NULL, 'Durată', 'Duração'), ('883', 'popular_instructor', NULL, NULL, 'Instructor popular', 'Instrutor popular'), ('884', 'our_popular_instructor_is_a_charismatic_and_knowledgeable_individual_who_captivates_students_with_engaging_lessons,_making_learning_a_delightful_and_enriching_experience.', NULL, NULL, NULL, 'Nosso popular instrutor é um indivíduo carismático e experiente que cativa os alunos com aulas envolventes, tornando o aprendizado uma experiência agradável e enriquecedora.'), ('885', 'follow_the_latest_news', NULL, NULL, 'Urmăriți cele mai recente știri', 'Acompanhe as últimas notícias'), ('886', 'website_notification', NULL, NULL, 'Notificare pe site', 'Notificação do site'), ('887', 'email_template', NULL, NULL, 'Șablon de e-mail', 'Modelo de e-mail'), ('888', 'protocol', NULL, NULL, 'Protocol', 'Protocolo'), ('889', 'smtp_crypto', NULL, NULL, 'Smtp cripto', 'Criptografia SMTP'), ('890', 'smtp_host', NULL, NULL, 'gazdă smtp', 'Host SMTP'), ('891', 'smtp_port', NULL, NULL, 'Port smtp', 'Porta SMTP'), ('892', 'smtp_from_email', NULL, NULL, 'Smtp din e-mail', 'E-mail para  SMTP'), ('893', 'smtp_username', NULL, NULL, 'Nume de utilizator SMS', 'Nome de usuário para SMTP'), ('894', 'smtp_password', NULL, NULL, 'Parola smtp', 'Senha SMTP'), ('895', 'email_type', NULL, NULL, 'Tipul de e-mail', 'Tipo de e-mail'), ('896', 'email_subject', NULL, NULL, 'Subiectul emailului', 'Assunto do email'), ('897', 'action', NULL, NULL, 'Acțiune', 'Ação'), ('898', 'to_admin', NULL, NULL, 'Pentru admin', 'Para administrar'), ('899', 'to_user', NULL, NULL, 'Către utilizator', 'Ao usuário'), ('900', 'edit_email_template', NULL, NULL, 'Editați șablonul de e-mail', 'Editar modelo de e-mail'), ('901', 'to_instructor', NULL, NULL, 'Către instructor', 'Para instrutor'), ('902', 'to_student', NULL, NULL, 'Pentru student', 'Para estudante'), ('903', 'to_affiliator', NULL, NULL, 'Către afiliat', 'Para afiliado'), ('904', 'to_payer', NULL, NULL, 'Pentru plătitor', 'Para o pagador'), ('905', 'to_receiver', NULL, NULL, 'La receptor', 'Para o receptor'), ('906', 'configure_your_notification_settings', NULL, NULL, 'Configurați setările de notificare', 'Defina suas configurações de notificação'), ('907', 'new_user_registration', NULL, NULL, 'Înregistrare utilizator nou', 'Registo de novo utilizador'), ('908', 'get_notified_when_a_new_user_signs_up', NULL, NULL, 'Primiți notificări când se înregistrează un nou utilizator', 'Seja notificado quando um novo usuário se inscrever'), ('909', 'configure_for_admin', NULL, NULL, 'Configurați pentru admin', 'Configurar para administrador'), ('910', 'system_notification', NULL, NULL, 'Notificare de sistem', 'Notificação do sistema'), ('911', 'email_notification', NULL, NULL, 'Notificare prin e-mail', 'Notificação de Email'), ('912', 'configure_for_user', NULL, NULL, 'Configurați pentru utilizator', 'Configurar para usuário'), ('913', 'email_verification', NULL, NULL, 'Verificare a email-ului', 'Verificação de e-mail'), ('914', 'not_editable', NULL, NULL, 'Nu este editabil', 'Não editável'), ('915', 'it_is_permanently_enabled_for_student_email_verification.', NULL, NULL, NULL, 'Está permanentemente habilitado para verificação de e-mail de alunos.'), ('916', 'forgot_password_mail', NULL, NULL, 'Am uitat parola e-mail', 'Esqueci a senha do e-mail'), ('917', 'account_security_alert', NULL, NULL, 'Alertă de securitate a contului', 'Alerta de segurança da conta'), ('918', 'send_verification_code_for_login_from_a_new_device', NULL, NULL, 'Trimiteți codul de verificare pentru autentificare de pe un dispozitiv nou', 'Envie o código de verificação para login de um novo dispositivo'), ('919', 'course_purchase_notification', NULL, NULL, 'Notificare de achiziție de curs', 'Notificação de compra de curso'), ('920', 'stay_up-to-date_on_student_course_purchases.', NULL, NULL, NULL, 'Mantenha-se atualizado sobre as compras de cursos dos alunos.'), ('921', 'configure_for_student', NULL, NULL, 'Configurați pentru student', 'Configurar para aluno'), ('922', 'configure_for_instructor', NULL, NULL, 'Configurați pentru instructor', 'Configurar para instrutor'), ('923', 'course_completion_mail', NULL, NULL, 'E-mail de finalizare a cursului', 'Correio de conclusão de curso'), ('924', 'stay_up_to_date_on_student_course_completion.', NULL, NULL, NULL, 'Mantenha-se atualizado sobre a conclusão do curso do aluno.'), ('925', 'course_eligibility_notification', NULL, NULL, 'Notificare de eligibilitate a cursului', 'Notificação de elegibilidade do curso'), ('926', 'stay_up_to_date_on_course_certificate_eligibility.', NULL, NULL, NULL, 'Mantenha-se atualizado sobre a elegibilidade do certificado do curso.'), ('927', 'offline_payment_suspended_mail', NULL, NULL, 'Plată offline e-mail suspendată', 'Correio suspenso de pagamento off-line'), ('928', 'if_students_provides_fake_information,_notify_them_of_the_suspension', NULL, NULL, NULL, 'Se os alunos fornecerem informações falsas, notifique-os sobre a suspensão'), ('929', 'course_bundle_purchase_notification', NULL, NULL, 'Notificare de cumpărare a pachetului de cursuri', 'Notificação de compra de pacote de cursos'), ('930', 'stay_up-to-date_on_student_course_bundle_purchases.', NULL, NULL, NULL, 'Mantenha-se atualizado sobre as compras de pacotes de cursos para estudantes.'), ('931', 'new_user_added_as_affiliator', NULL, NULL, 'Utilizator nou adăugat ca afiliat', 'Novo usuário adicionado como afiliado'), ('932', 'send_account_information_to_the_new_user', NULL, NULL, 'Trimiteți informații despre cont noului utilizator', 'Envie informações da conta para o novo usuário'), ('933', 'configure_for_affiliator', NULL, NULL, 'Configurați pentru afiliat', 'Configurar para afiliado'), ('934', 'affiliate_approval_notification', NULL, NULL, 'Notificare de aprobare a afiliaților', 'Notificação de aprovação de afiliado'), ('935', 'send_affiliate_approval_mail_to_the_user_account', NULL, NULL, 'Trimiteți e-mail de aprobare a afiliaților în contul de utilizator', 'Envie um e-mail de aprovação de afiliado para a conta do usuário'), ('936', 'affiliator_request_cancellation', NULL, NULL, 'Anularea cererii afiliatului', 'Cancelamento de solicitação de afiliado'), ('937', 'send_mail,_when_you_cancel_the_affiliation_request', NULL, NULL, NULL, 'Enviar e-mail quando você cancelar a solicitação de afiliação'), ('938', 'affiliation_money_withdrawal_request', NULL, NULL, 'Cerere de retragere a banilor de afiliere', 'Solicitação de retirada de dinheiro de afiliação'), ('939', 'send_mail,_when_the_users_request_the_withdrawal_of_money', NULL, NULL, NULL, 'Enviar e-mail, quando os usuários solicitarem a retirada de dinheiro'), ('940', 'approval_of_withdrawal_request_of_affiliation', NULL, NULL, 'Aprobarea cererii de retragere a afilierii', 'Aprovação do pedido de retirada de afiliação'), ('941', 'send_mail,_when_you_approved_the_affiliation_withdrawal_request', NULL, NULL, NULL, 'Enviar e-mail quando você aprovar a solicitação de retirada de afiliação'), ('942', 'course_gift_notification', NULL, NULL, 'Notificare cadou curs', 'Notificação de presente do curso'), ('943', 'notify_users_after_course_gift', NULL, NULL, 'Notificați utilizatorii după cadou curs', 'Notificar os usuários após o presente do curso'), ('944', 'configure_for_payer', NULL, NULL, 'Configurați pentru plătitor', 'Configurar para pagador'), ('945', 'configure_for_receiver', NULL, NULL, 'Configurați pentru receptor', 'Configurar para receptor'), ('946', 'custom_pages', NULL, NULL, 'Pagini personalizate', 'Páginas personalizadas'), ('947', 'add_a_new_page', NULL, NULL, 'Adăugați o pagină nouă', 'Adicionar uma nova página'), ('948', 'page_title', NULL, NULL, 'Titlul paginii', 'Título da página'), ('949', 'button_title', NULL, NULL, 'Titlul butonului', 'Título do botão'), ('950', 'button_position', NULL, NULL, 'Poziția butonului', 'Posição do botão'), ('951', 'social_login_configuration', NULL, NULL, 'Configurare autentificare socială', 'Configuração de login social'), ('952', 'facebook_login', NULL, NULL, 'logare Facebook', 'entrar no Facebook'), ('953', 'facebook_app_creation_instruction', NULL, NULL, 'Instrucțiuni pentru crearea aplicației Facebook', 'Instruções de criação de aplicativo do Facebook'), ('954', 'facebook_app_id', NULL, NULL, 'Id-ul aplicației Facebook', 'ID do aplicativo do Facebook'), ('955', 'facebook_app_secret', NULL, NULL, 'Secretul aplicației Facebook', 'Segredo do aplicativo Facebook'), ('956', 'completed', NULL, NULL, 'Efectuat', 'Concluído'), ('957', 'lesson_type', NULL, NULL, 'Tipul de lecție', 'Tipo de aula'), ('958', 'video_url', NULL, NULL, 'Adresa URL a videoclipului', 'URL do vídeo'), ('959', 'this_video_will_be_shown_on_web_application', NULL, NULL, 'Acest videoclip va fi afișat pe aplicația web', 'Este vídeo será exibido em aplicativo web'), ('960', 'thumbnail', NULL, NULL, 'Miniatură', 'Miniatura'), ('961', 'caption', NULL, NULL, 'Legendă', 'legenda'), ('962', '.vtt', NULL, NULL, NULL, '.vtt'), ('963', 'choose_your_caption_file', NULL, NULL, 'Alegeți fișierul subtitrare', 'Escolha seu arquivo de legenda'), ('964', 'lesson_provider', NULL, NULL, 'Furnizor de lecții', 'Provedor de aula'), ('965', 'for_mobile_application', NULL, NULL, 'Pentru aplicația mobilă', 'Para aplicativo móvel'), ('966', 'only', NULL, NULL, 'Numai', 'Apenas'), ('967', 'type_video_is_acceptable_for_mobile_application', NULL, NULL, 'Tipul video este acceptabil pentru aplicația mobilă', 'O tipo de vídeo é aceitável para aplicativos móveis'), ('968', 'do_you_want_to_keep_it_free_as_a_preview_lesson', NULL, NULL, 'Doriți să o păstrați gratuit ca lecție de previzualizare', 'Quer mantê-lo gratuito como uma aula prévia'), ('969', 'mark_as_free_lesson', NULL, NULL, 'Marcați ca lecție gratuită', 'Marcar como aula gratuita'), ('970', 'course_content', NULL, NULL, 'Conținutul cursului', 'Conteúdo do curso'), ('971', 'mark_as_complete', NULL, NULL, 'Marcați ca fiind complet', 'Marcar como concluído'), ('972', 'video', NULL, NULL, 'Video', 'Vídeo'), ('973', 'iframe', NULL, NULL, 'Iframe', 'Iframe'), ('974', 'pdf', NULL, NULL, 'Pdf', 'PDF'), ('975', 'forum', NULL, NULL, 'forum', 'Fórum'), ('976', 'live_class', NULL, NULL, 'Clasă live', 'Aula ao vivo'), ('977', 'website_faqs_updated_successfully', NULL, NULL, 'Întrebările frecvente ale site-ului au fost actualizate cu succes', 'Perguntas frequentes do site atualizadas com sucesso'), ('978', 'frequently_asked_questions', NULL, NULL, 'Întrebări frecvente', 'Perguntas frequentes'), ('979', 'have_something_to_know?', NULL, NULL, 'Have something to know?', 'Tem algo para saber?'), ('980', 'check_here_if_you_have_any_questions_about_us.', NULL, NULL, 'Check here if you have any questions about us.', 'Verifique aqui se você tiver alguma dúvida sobre nós.'), ('981', 'see_more', NULL, NULL, 'Vezi mai mult', 'Ver mais'), ('982', 'course_content_not_found', NULL, NULL, 'Conținutul cursului nu a fost găsit', 'Conteúdo do curso não encontrado'), ('983', 'please_ensure_that_your_course_has_at_least_one_section_and_one_lesson.', NULL, NULL, NULL, 'Certifique-se de que seu curso tenha pelo menos uma seção e uma lição.'), ('984', 'total_questions', NULL, NULL, 'Total intrebari', 'Total de perguntas'), ('985', 'total_participant_students', NULL, NULL, 'Total studenți participanți', 'Total de alunos participantes'), ('986', 'participant_students', NULL, NULL, 'Elevii participanți', 'Alunos participantes'), ('987', 'select_student', NULL, NULL, 'Selectați student', 'Selecione o aluno'), ('988', 'select_a_student_to_view_the_answer_sheet', NULL, NULL, 'Selectați un student pentru a vizualiza foaia de răspunsuri', 'Selecione um aluno para visualizar a folha de respostas'), ('989', 'courses_included', NULL, NULL, 'Cursuri incluse', 'Cursos incluídos'), ('990', 'subscription', NULL, NULL, 'Abonament', 'Inscrição'), ('991', 'days', NULL, NULL, 'Zile', 'Dias'), ('992', 'included_courses', NULL, NULL, 'Cursuri incluse', 'Cursos incluídos'), ('993', 'think_more_clearly', NULL, NULL, 'Gandeste mai clar', 'Pense com mais clareza'), ('994', 'gather_your_thoughts,_and_make_your_decisions_clearly', NULL, NULL, 'Gather your thoughts, and make your decisions clearly', 'Reúna seus pensamentos e tome suas decisões com clareza'), ('995', 'select_your_service', 'Select your service', NULL, 'Selectați serviciul dvs', 'Selecione seu serviço'), ('996', 'course_short_description', 'Course short description', NULL, 'Scurtă descriere a cursului', 'Breve descrição do curso'), ('997', 'course_long_description', 'Course long description', NULL, 'Descriere lungă a cursului', 'Descrição longa do curso'), ('998', 'course_requirements', 'Course requirements', NULL, 'Cerințele cursului', 'Requisitos do curso'), ('999', 'course_outcomes', 'Course outcomes', NULL, 'Rezultatele cursului', 'Resultados do curso'), ('1000', 'course_seo_tags', 'Course seo tags', NULL, 'Etichete seo de curs', 'Tags de SEO do curso'), ('1001', 'course_lesson_text', 'Course lesson text', NULL, 'Textul lecției de curs', 'Texto da lição do curso'), ('1002', 'course_certificate_text', 'Course certificate text', NULL, 'Textul certificatului de curs', 'Texto do certificado do curso'), ('1003', 'course_quiz_text', 'Course quiz text', NULL, 'Textul testului de curs', 'Texto do teste do curso'), ('1004', 'course_blog_title', 'Course blog title', NULL, 'Titlul blogului cursului', 'Título do blog do curso'), ('1005', 'course_blog_post', 'Course blog post', NULL, 'Postare pe blogul cursului', 'Postagem no blog do curso'), ('1006', 'enter_your_keyword', 'Enter your keyword', NULL, 'Introduceți cuvântul cheie', 'Insira sua palavra-chave'), ('1007', 'generate', 'Generate', NULL, 'Genera', 'Gerar'), ('1008', 'generating', 'Generating', NULL, 'Generarea', 'Gerando'), ('1009', 'generated_text', 'Generated text', NULL, 'Text generat', 'Texto gerado'), ('1010', 'copy', 'Copy', NULL, 'Copie', 'cópia de'), ('1011', 'copyed', 'Copyed', NULL, 'Copiat', 'Copiado'), ('1012', '_learning_animal_name_', NULL, NULL, 'învățarea numelui animalului', 'aprendendo o nome dos animais'), ('1013', 'share_and_earn', NULL, NULL, 'Distribuie și câștigă', 'Compartilhe e ganhe'), ('1014', 'supreme_photoshop_training:_from_beginner_to_expert', NULL, NULL, NULL, 'Treinamento supremo em Photoshop: do iniciante ao especialista'), ('1015', 'write_a_review', NULL, NULL, 'Scrie o recenzie', 'Escreva uma crítica'), ('1016', '1_start_rating', NULL, NULL, '1 evaluare de început', '1 classificação inicial'), ('1017', '2_start_rating', NULL, NULL, '2 start rating', '2 classificação inicial'), ('1018', '3_start_rating', NULL, NULL, '3 start rating', '3 classificação inicial'), ('1019', '4_start_rating', NULL, NULL, '4 start rating', '4 classificação inicial'), ('1020', '5_start_rating', NULL, NULL, '5 start rating', '5 classificação inicial'), ('1021', 'write_your_comment', NULL, NULL, 'Scrie comentariul tău', 'Escreva seu comentário'), ('1022', 'adobe_illustrator_cc_-_essentials_training_course', NULL, NULL, 'Adobe Illustrator cc - curs de instruire esențiale', 'Adobe Illustrator CC - curso de treinamento básico'), ('1023', 'mon', NULL, NULL, 'Lun', 'seg.'), ('1024', 'select_a_user', NULL, NULL, 'Selectați un utilizator', 'Selecione um usuário'), ('1025', 'write_your_message', NULL, NULL, 'Scrie-ți mesajul', 'Escreva sua mensagem'), ('1026', 'send', NULL, NULL, 'Trimite', 'Enviar'), ('1027', 'purchased_courses', NULL, NULL, 'Cursuri achiziționate', 'Cursos adquiridos'), ('1028', 'payment_method', NULL, NULL, 'Modalitate de plată', 'Forma de pagamento'), ('1029', 'purchased_date', NULL, NULL, 'Data achiziției', 'Data de compra'), ('1030', 'invoice', NULL, NULL, 'Factura fiscala', 'Fatura'), ('1031', 'assignment_list', NULL, NULL, 'Lista de sarcini', 'Lista de tarefas'), ('1032', 'no_data_found', NULL, NULL, 'Nu s-au gasit date', 'Nenhum dado encontrado'), ('1033', 'uncheck', NULL, NULL, 'Debifați', 'Desmarque'), ('1034', 'faqs', NULL, NULL, 'Întrebări frecvente', 'Perguntas frequentes'), ('1035', 'looking_for_answers?', NULL, NULL, NULL, 'Procurando respostas?'), ('1036', 'latest_from_our_blog', NULL, NULL, 'Cele mai recente de pe blogul nostru', 'Novidades do nosso blog'), ('1037', 'exploring_the_cutting-edge_insights_and_updates_on_our_blog', NULL, NULL, 'Explorând perspectivele și actualizările de ultimă oră de pe blogul nostru', 'Explorando os insights e atualizações mais recentes em nosso blog'), ('1038', 'see_all', NULL, NULL, 'Vezi toate', 'Ver tudo'), ('1039', 'popular_blogs', NULL, NULL, 'Bloguri populare', 'Blogs populares'), ('1040', 'learn_from_expert_bloggers_and_expand_your_knowledge', NULL, NULL, 'Învață de la bloggeri experți și extinde-ți cunoștințele', 'Aprenda com blogueiros especialistas e expanda seu conhecimento'), ('1041', 'shopping_cart', NULL, NULL, 'Cărucior de cumpărături', 'Carrinho de compras'), ('1042', 'your_cart_items', 'Your cart items', NULL, 'Articolele din coșul dvs', 'Itens do seu carrinho'), ('1043', 'items', 'Items', NULL, 'Articole', 'Unid'), ('1044', 'subtotal', 'Subtotal', NULL, 'Subtotal', 'Subtotal'), ('1045', 'apply_coupon', 'Apply coupon', NULL, 'Aplicați cuponul', 'Aplicar cupom'), ('1046', 'apply', 'Apply', NULL, 'aplica', 'Aplicar'), ('1047', 'send_as_a_gift', 'Send as a gift', NULL, 'Trimite cadou', 'Enviar como presente'), ('1048', 'email_address', 'Email address', NULL, 'Adresa de e-mail', 'Endereço de email'), ('1049', 'continue_to_payment', 'Continue to payment', NULL, 'Continuați cu plata', 'Continuar para o pagamento'), ('1050', 'searching', 'Searching', NULL, 'In cautarea', 'Procurando'), ('1051', 'quiz_submission_successfully', NULL, NULL, 'Trimiterea testului cu succes', 'Envio do questionário com sucesso'), ('1052', 'obtained_marks', NULL, NULL, 'Note obținute', 'Notas obtidas'), ('1053', 'correct', NULL, NULL, 'Corect', 'Correto'), ('1054', 'wrong', NULL, NULL, 'Gresit', 'Errado'), ('1055', 'correct_answer', NULL, NULL, 'Răspuns corect', 'Resposta correta'), ('1056', 'user_added_successfully', NULL, NULL, 'Utilizatorul adăugat cu succes', 'Usuário adicionado com sucesso'), ('1057', 'instructor_payouts', NULL, NULL, 'Plățile instructorului', 'Pagamentos de instrutor'), ('1058', 'list_of_payouts', NULL, NULL, 'Lista plăților', 'Lista de pagamentos'), ('1059', 'completed_payouts', NULL, NULL, 'Plăți finalizate', 'Pagamentos concluídos'), ('1060', 'pending_payouts', NULL, NULL, 'Plăți în așteptare', 'Pagamentos pendentes'), ('1061', 'payout_amount', NULL, NULL, 'suma de plata', 'Montante de pagamento'), ('1062', 'payment_type', NULL, NULL, 'Tipul de plată', 'Tipo de pagamento'), ('1063', 'payout_date', NULL, NULL, 'Data plății', 'Data de pagamento'), ('1064', 'pay', NULL, NULL, 'A plati', 'Pagar'), ('1065', 'public_instructor_settings', NULL, NULL, 'Setările instructorilor publici', 'Configurações públicas do instrutor'), ('1066', 'allow_public_instructor', NULL, NULL, 'Permiteți instructor public', 'Permitir instrutor público'), ('1067', 'instructor_application_note', NULL, NULL, 'Notă de aplicare a instructorului', 'Nota de aplicação do instrutor'), ('1068', 'instructor_commission_ettings', NULL, NULL, 'Stabilirea comisiei de instructor', 'Configurações de comissão do instrutor'), ('1069', 'instructor_revenue_percentage', NULL, NULL, 'Procentul veniturilor instructorului', 'Porcentagem de receita do instrutor'), ('1070', 'admin_revenue_percentage', NULL, NULL, 'Procentul venitului administrativ', 'Porcentagem de receita do administrador'), ('1071', 'instructor_application', NULL, NULL, 'Aplicație pentru instructor', 'Aplicativo para instrutor'), ('1072', 'instructor_applications', NULL, NULL, 'Aplicații pentru instructori', 'Aplicativos para instrutores'), ('1073', 'list_of_applications', NULL, NULL, 'Lista aplicațiilor', 'Lista de aplicativos'), ('1074', 'pending_applications', NULL, NULL, 'Aplicații în așteptare', 'Candidaturas pendentes'), ('1075', 'approved_applications', NULL, NULL, 'Aplicații aprobate', 'Aplicativos aprovados'), ('1076', 'details', NULL, NULL, 'Detalii', 'Detalhes'), ('1077', 'applicant_details', NULL, NULL, 'Detalii solicitant', 'Detalhes do candidato'), ('1078', 'application_details', NULL, NULL, 'Detalii aplicație', 'Detalhes da aplicação'), ('1079', 'download', NULL, NULL, 'Descarca', 'Download'), ('1080', 'approve', NULL, NULL, 'Aproba', 'Aprovar'), ('1081', 'approved', NULL, NULL, 'Aprobat', 'Aprovado'), ('1082', 'add_admin', NULL, NULL, 'Adăugați admin', 'Adicionar administrador'), ('1083', 'root_admin', NULL, NULL, 'Administrator rădăcină', 'Administrador raiz'), ('1084', 'assign_permission', NULL, NULL, 'Atribuiți permisiunea', 'Atribuir permissão'), ('1085', 'manage_profil', NULL, NULL, 'Gestionați profilul', 'Gerenciar perfil'), ('1086', 'facebook_link', NULL, NULL, 'link pe Facebook', 'Link do Facebook'), ('1087', 'twitter_link', NULL, NULL, 'link Twitter', 'Link do Twitter'), ('1088', 'linkedin_link', NULL, NULL, 'Link-ul Linkedin', 'link do Linkedin'), ('1089', 'the_image_size_should_be_any_square_image', NULL, NULL, 'Dimensiunea imaginii ar trebui să fie orice imagine pătrată', 'O tamanho da imagem deve ser qualquer imagem quadrada'), ('1090', 'update_profile', NULL, NULL, 'Actualizare profil', 'Atualizar perfil'), ('1091', 'current_password', NULL, NULL, 'Parola actuală', 'Senha atual'), ('1092', 'new_password', NULL, NULL, 'Parolă Nouă', 'Nova senha'), ('1093', 'confirm_new_password', NULL, NULL, 'Confirmă noua parolă', 'Confirme a nova senha'), ('1094', 'update_password', NULL, NULL, 'Actualizați parola', 'Atualizar senha'), ('1095', 'educator_profile', NULL, NULL, 'Profilul educatorului', 'Perfil do educador'), ('1096', 'statistics', NULL, NULL, 'Statistici', 'Estatisticas'), ('1097', 'total_students', NULL, NULL, 'Total studenți', 'Total de alunos'), ('1098', 'the_complete_python_bootcamp_from_zero_to_hero', NULL, NULL, 'Campul de pregătire complet python de la zero la erou', 'O bootcamp python completo do zero ao herói'), ('1099', 'course_added_to_wishlist', NULL, NULL, 'Curs adăugat la lista de dorințe', 'Curso adicionado à lista de desejos'), ('1100', 'manage_course_bundle', NULL, NULL, 'Gestionați pachetul de cursuri', 'Gerenciar pacote de cursos'), ('1101', 'bundle', NULL, NULL, 'Pachet', 'Pacote'), ('1102', 'subscription_limit', NULL, NULL, 'Limită de abonament', 'Limite de assinatura'), ('1103', 'deactive', NULL, NULL, 'Activ', 'Desativo'), ('1104', 'edit_course_bundle', NULL, NULL, 'Editați pachetul de cursuri', 'Editar pacote de cursos'), ('1105', 'bundle_add_form', NULL, NULL, 'Formular de adăugare a pachetului', 'Formulário de adição de pacote'), ('1106', 'course_bundle_title', NULL, NULL, 'Titlul pachetului de curs', 'Título do pacote de cursos'), ('1107', 'select_courses', NULL, NULL, 'Selectați cursuri', 'Selecione os cursos'), ('1108', 'current_price_of_the_courses_is', NULL, NULL, 'Pretul curent al cursurilor este', 'O preço atual dos cursos é'), ('1109', 'bundle_price', NULL, NULL, 'Prețul pachetului', 'Preço do pacote'), ('1110', 'subscription_renew_days', NULL, NULL, 'Zile de reînnoire a abonamentului', 'Dias de renovação de assinatura'), ('1111', 'count_day', NULL, NULL, 'Numără ziua', 'Contar dia'), ('1112', 'banner', NULL, NULL, 'Banner', 'Bandeira'), ('1113', 'update_bundle', NULL, NULL, 'Actualizați pachetul', 'Pacote de atualização'), ('1114', 'complete_guitar_lessons_system_', NULL, NULL, 'Sistem complet de lecții de chitară', 'Sistema completo de aulas de violão'), ('1115', 'item_successfully_added_to_cart', 'Item successfully added to cart', NULL, 'Articol adăugat cu succes în coș', 'Item adicionado com sucesso ao carrinho'), ('1116', 'after_effects_cc_2019:_complete_course', NULL, NULL, NULL, NULL), ('1117', 'how_to_use_lighting_design_to_transform_your_home', NULL, NULL, 'Cum să utilizați designul de iluminat pentru a vă transforma casa', 'Como usar o design de iluminação para transformar sua casa'), ('1118', 'invoice_id', NULL, NULL, 'Numărul de indentificare al facturii', 'ID da fatura'), ('1119', 'billed_to', NULL, NULL, 'Facturat către', 'Faturado para'), ('1120', 'date_of_issue', NULL, NULL, 'Data emiterii', 'Data de emissão'), ('1121', 'invoice_total', NULL, NULL, 'Totalul facturii', 'Total da fatura'), ('1122', 'qty', NULL, NULL, 'Cant', 'Quantidade'), ('1123', 'paid_by', NULL, NULL, 'Platit de', 'Pago pelo'), ('1124', 'tax', NULL, NULL, 'Impozit', 'Imposto'), ('1125', 'grand_total', NULL, NULL, 'Total general', 'total geral'), ('1126', 'print', NULL, NULL, 'Imprimare', 'Imprimir'), ('1127', 'back', NULL, NULL, 'Înapoi', 'Voltar'), ('1128', 'the_data_science_course:_complete_data_science', NULL, NULL, NULL, 'O curso de ciência de dados: ciência de dados completa'), ('1129', 'newsletters', NULL, NULL, 'Buletine informative', 'boletins informativos'), ('1130', 'newsletter_template', NULL, NULL, 'Șablon de buletin informativ', 'Modelo de boletim informativo'), ('1131', 'your_phone', NULL, NULL, 'Telefonul tau', 'Seu telefone'), ('1132', 'subject', NULL, NULL, 'Subiect', 'Assunto'), ('1133', 'subscriber', NULL, NULL, 'Abonat', 'Assinante'), ('1134', 'user_status', NULL, NULL, 'Starea utilizatorului', 'Status do usuário'), ('1135', 'newsletter_added_successfully', NULL, NULL, 'Newsletter adăugat cu succes', 'Newsletter adicionada com sucesso'), ('1136', 'edit_newsletter_template', NULL, NULL, 'Editați șablonul de buletin informativ', 'Editar modelo de boletim informativo'), ('1137', 'send_newsletter', NULL, NULL, 'Trimite newsletter', 'Enviar boletim informativo'), ('1138', 'send_to', NULL, NULL, 'Trimite catre', 'Enviar para'), ('1139', 'selected_user', NULL, NULL, 'Utilizator selectat', 'Usuário selecionado'), ('1140', 'all_users', NULL, NULL, 'Toți utilizatorii', 'Todos os usuários'), ('1141', 'all_student', NULL, NULL, 'Tot student', 'Todos estudantes'), ('1142', 'all_instructor', NULL, NULL, 'Tot instructor', 'Todo instrutor'), ('1143', 'newsletter_subscriber', NULL, NULL, 'Abonat la newsletter', 'Assinante do boletim informativo'), ('1144', 'all_subscriber', NULL, NULL, 'Tot abonat', 'Todos os assinantes'), ('1145', 'registered_user', NULL, NULL, 'Utilizator Inregistrat', 'Usuário Registrado'), ('1146', 'non_registered_user', NULL, NULL, 'Utilizator neînregistrat', 'Usuário não cadastrado'), ('1147', 'select_your_users', NULL, NULL, 'Selectați utilizatorii dvs', 'Selecione seus usuários'), ('1148', 'newsletter_deleted_successfully', NULL, NULL, 'Buletinul informativ a fost șters cu succes', 'Boletim informativo excluído com sucesso'), ('1149', 'item_successfully_removed_from_cart', NULL, NULL, 'Articolul a fost eliminat cu succes din coș', 'Item removido do carrinho com sucesso'), ('1150', 'course_compare', NULL, NULL, 'Comparare curs', 'Comparação de cursos'), ('1151', 'compare_with_1_courses', NULL, NULL, 'Comparați cu 1 curs', 'Comparar com 1 cursos'), ('1152', 'select_a_course', NULL, NULL, 'Selectați un curs', 'Selecione um curso'), ('1153', 'has_discount', NULL, NULL, 'Are reducere', 'Tem desconto'), ('1154', 'made_in', NULL, NULL, 'Facut in', 'Criado em'), ('1155', 'last_updated_at', NULL, NULL, 'Ultima actualizare la', 'Última atualização em'), ('1156', 'total_lectures', NULL, NULL, 'Total prelegeri', 'Palestras totais'), ('1157', 'total_quizzes', NULL, NULL, 'Total chestionare', 'Total de questionários'), ('1158', 'total_duration', NULL, NULL, 'Durata totala', 'Duração total'), ('1159', 'total_enrolment', NULL, NULL, 'Înscriere totală', 'Matrícula total'), ('1160', 'number_of_reviews', NULL, NULL, 'Numărul de recenzii', 'Número de avaliações'), ('1161', 'avg_rating', NULL, NULL, 'Evaluare medie', 'Avaliação média'), ('1162', 'add_phrase', NULL, NULL, 'Adăugați o frază', 'Adicionar frase'), ('1163', 'language_deleted_successfully', 'Language deleted successfully', NULL, 'Limba a fost ștearsă cu succes', 'Idioma excluído com sucesso'), ('1164', 'لوحة_القيادة', NULL, NULL, NULL, 'Painel'), ('1165', 'تحرير_الدورة', NULL, NULL, NULL, 'Edite o curso'), ('1166', 'tableau_de_bord', NULL, NULL, NULL, 'Painel'), ('1167', 'credentials', NULL, NULL, NULL, 'Credenciais '), ('1168', 'profile_photo', NULL, NULL, NULL, 'Foto de perfil'), ('1169', 'update_your_profile_photo_and_personal_details', NULL, NULL, NULL, 'Atualize sua foto de perfil e dados pessoais'), ('1170', 'upload_photo', NULL, NULL, NULL, 'Carregar foto'), ('1171', 'account_information', NULL, NULL, NULL, 'Informação da conta'), ('1172', 'enter_current_password', NULL, NULL, NULL, 'Digite a senha atual'), ('1173', 'enter_new_password', NULL, NULL, NULL, 'Insira a nova senha'), ('1174', 'confirm_password', NULL, NULL, NULL, 'Confirme sua senha'), ('1175', 're-type_your_password', NULL, NULL, NULL, 'Digite novamente sua senha'), ('1176', 'profile_info', NULL, NULL, NULL, 'Informações do perfil'), ('1177', 'add_your_twitter_link', NULL, NULL, NULL, 'Adicione seu link do Twitter'), ('1178', 'add_your_facebook_link', NULL, NULL, NULL, 'Adicione seu link do Facebook'), ('1179', 'add_your_linkedin_link', NULL, NULL, NULL, 'Adicione seu link do LinkedIn'), ('1180', 'course_removed_from_wishlist', NULL, NULL, NULL, 'Curso removido da lista de desejos'), ('1181', 'javascript_understanding_the_weird_parts_-_the_first_3.5_hours', NULL, NULL, NULL, 'Javascript entendendo as partes estranhas - as primeiras 3,5 horas'), ('1182', 'search_result', NULL, NULL, NULL, 'Resultado da pesquisa'), ('1183', 'add_custom_page', NULL, NULL, NULL, 'Adicionar página personalizada'), ('1184', 'add_your_new_page', NULL, NULL, NULL, 'Adicione sua nova página'), ('1185', 'page_information', NULL, NULL, NULL, 'Informações da página'), ('1186', 'enter_page_title', NULL, NULL, NULL, 'Insira o título da página'), ('1187', 'page_content', NULL, NULL, NULL, 'Conteúdo da página'), ('1188', 'footer', NULL, NULL, NULL, 'Rodapé'), ('1189', 'header', NULL, NULL, NULL, 'Cabeçalho'), ('1190', 'page_url', NULL, NULL, NULL, 'URL da página'), ('1191', 'add_page', NULL, NULL, NULL, 'Adicionar Página'), ('1192', 'new_page_added_successfully', NULL, NULL, NULL, 'Nova página adicionada com sucesso'), ('1193', 'more', NULL, NULL, NULL, 'Mais'), ('1194', 'edit_custom_page', NULL, NULL, NULL, 'Editar página personalizada'), ('1195', 'edit_your_page', NULL, NULL, NULL, 'Edite sua página'), ('1196', 'update_page', NULL, NULL, NULL, 'Atualizar página'), ('1197', 'page_updated_successfully', NULL, NULL, NULL, 'Página atualizada com sucesso'), ('1198', 'happy_students', NULL, NULL, NULL, 'Alunos felizes'), ('1199', 'experienced_instructors', NULL, NULL, NULL, 'Instrutores experientes'), ('1200', 'we_provides_you_world_class_performance', NULL, NULL, NULL, 'Nós fornecemos a você desempenho de classe mundial'), ('1201', 'why_learn_online?', NULL, NULL, NULL, 'Por que aprender on-line?'), ('1202', 'flexibility', NULL, NULL, NULL, 'Flexibilidade'), ('1203', 'flexibility_in_scheduling_and_learning_at_your_own_pace.', NULL, NULL, NULL, 'Flexibilidade de agendamento e aprendizado no seu próprio ritmo.'), ('1204', 'accessibility', NULL, NULL, NULL, 'Acessibilidade'), ('1205', 'convenient_access_from_anywhere_with_an_internet_connection.', NULL, NULL, NULL, 'Acesso conveniente de qualquer lugar com conexão à Internet.'), ('1206', 'quality_trainers', NULL, NULL, NULL, 'Instrutores de qualidade'), ('1207', 'cost-free_courses', NULL, NULL, NULL, 'Cursos gratuitos'), ('1208', 'what_the_people_tinks_about_us', NULL, NULL, NULL, 'O que as pessoas pensam sobre nós'), ('1209', 'tue', NULL, NULL, NULL, 'ter.'), ('1210', 'our_latest_blog', NULL, NULL, NULL, 'Nosso último blog'), ('1211', 'pay_for_purchasing_course', NULL, NULL, NULL, 'Pague pela compra do curso'), ('1212', 'payment', 'Payment', NULL, NULL, 'Pagamento'), ('1213', 'make_payment', NULL, NULL, NULL, 'Faça o pagamento'), ('1214', 'select_payment_gateway', NULL, NULL, NULL, 'Selecione o gateway de pagamento'), ('1215', 'pay_by_razorpay', NULL, NULL, NULL, 'Pague por razorpay'), ('1216', 'pay_with_stripe', NULL, NULL, NULL, 'Pague com stripe'), ('1217', 'create_intelligence', NULL, NULL, NULL, 'Crie inteligência'), ('1218', 'learn_with_us', NULL, NULL, NULL, 'Aprenda conosco'), ('1219', 'top_rated_courses', NULL, NULL, NULL, 'Cursos mais bem avaliados'), ('1220', 'number_of_enrolled_students', NULL, NULL, NULL, 'Número de alunos matriculados'), ('1221', 'total_lessons', NULL, NULL, NULL, 'Total de aulas'), ('1222', 'our_identity', NULL, NULL, NULL, 'Nossa identidade'), ('1223', 'we_always_prioritize_quality_and_uniqueness', NULL, NULL, NULL, 'Sempre priorizamos qualidade e exclusividade'), ('1224', 'our_identity_is_a_reflection_of_who_we_are_as_individuals_or_as_an_organization,_while_our_profile_provides_a_concise_summary_of_our_background,_skills,_and_accomplishments.', NULL, NULL, NULL, 'Nossa identidade reflete quem somos como indivíduos ou como organização, enquanto nosso perfil fornece um resumo conciso de nossa experiência, habilidades e realizações.'), ('1225', 'our_popular_instructor', NULL, NULL, NULL, 'Nosso popular instrutor'), ('1226', 'read_more', NULL, NULL, NULL, 'Consulte mais informação'), ('1227', 'no_search_value_found', NULL, NULL, NULL, 'Nenhum valor de pesquisa encontrado'), ('1228', 'complete_blender_creator:_learn_3d_modelling_', NULL, NULL, NULL, 'Criador completo de liquidificador: aprenda modelagem 3D'), ('1229', 'home_pages', NULL, NULL, NULL, 'Páginas iniciais'), ('1230', 'wed', NULL, NULL, NULL, 'qua.'), ('1231', 'user_not_found', NULL, NULL, NULL, 'Usuário não encontrado'), ('1232', 'import_your_data', NULL, NULL, NULL, 'Importe seus dados'), ('1233', 'choose_your_demo_file', NULL, NULL, NULL, 'Escolha seu arquivo de demonstração'), ('1234', 'backup_your_website', NULL, NULL, NULL, 'Faça backup do seu site'), ('1235', 'backup_your_current_data', NULL, NULL, NULL, 'Faça backup dos seus dados atuais'), ('1236', 'keep_a_backup', NULL, NULL, NULL, 'Mantenha um backup'), ('1237', 'no_backup', NULL, NULL, NULL, 'Sem backup'), ('1238', 'your_backup_file_has_been_stored_successfully', NULL, NULL, NULL, 'Seu arquivo de backup foi armazenado com sucesso'), ('1239', 'backup_files_deleted_successfully', NULL, NULL, NULL, 'Arquivos de backup excluídos com sucesso'), ('1240', 'buy_new_addon', NULL, NULL, NULL, 'Compre novo complemento'), ('1241', 'install_addon', NULL, NULL, NULL, 'Instalar complemento'), ('1242', 'installed_addons', NULL, NULL, NULL, 'Complementos instalados'), ('1243', 'version', NULL, NULL, NULL, 'Versão'), ('1244', 'addon_update', NULL, NULL, NULL, 'Atualização de complemento'), ('1245', 'about_this_addon', NULL, NULL, NULL, 'Sobre este complemento'), ('1246', 'addon_is_activated_successfully', NULL, NULL, NULL, 'Addon foi ativado com sucesso'), ('1247', 'jitsi_live_class_schedule', NULL, NULL, NULL, 'Horário de aulas ao vivo de Jitsi'), ('1248', 'join_live_video_class', NULL, NULL, NULL, 'Participe da videoaula ao vivo'), ('1249', 'live_class_is_not_scheduled_to_this_course_yet', NULL, NULL, NULL, 'A aula ao vivo ainda não está agendada para este curso'), ('1250', 'find_a_tutor', 'Find a tutor', NULL, 'Find a tutor', 'Encontre um tutor'), ('1251', 'assignments', NULL, NULL, NULL, 'atribuições'), ('1252', 'zoom_live_class_schedule', NULL, NULL, NULL, 'Zoom programação de aulas ao vivo'), ('1253', 'your_question_has_been_successfully_published', NULL, NULL, NULL, 'Sua pergunta foi publicada com sucesso'), ('1254', 'please_write_your_question_title_or_summary', NULL, NULL, NULL, 'Por favor, escreva o título ou resumo da sua pergunta'), ('1255', 'notifications', NULL, NULL, NULL, 'Notificações'), ('1256', 'search_questions', NULL, NULL, NULL, 'Perguntas de pesquisa'), ('1257', 'questions_in_this_course', NULL, NULL, NULL, 'Perguntas neste curso'), ('1258', 'ask_a_new_question', NULL, NULL, NULL, 'Faça uma nova pergunta'), ('1259', 'sat', NULL, NULL, NULL, 'Sab.'), ('1260', 'add_update', NULL, NULL, NULL, 'Adicionar atualização'), ('1261', 'ge_to_addon_list', NULL, NULL, NULL, 'Acesse a lista de complementos'), ('1262', 'upload_addon_file', NULL, NULL, NULL, 'Carregar arquivo adicional'), ('1263', 'zip_file', NULL, NULL, NULL, 'Arquivo zip'), ('1264', 'update_addon', NULL, NULL, NULL, 'Atualizar complemento'), ('1265', 'addon_updated_successfully', NULL, NULL, NULL, 'Addon atualizado com sucesso'), ('1266', 'add_addon', NULL, NULL, NULL, 'Adicionar complemento'), ('1267', 'install_an_addon', NULL, NULL, NULL, 'Instale um complemento'), ('1268', 'back_to_addon_list', NULL, NULL, NULL, 'Voltar à lista de complementos'), ('1269', 'addon_installed_successfully', NULL, NULL, NULL, 'Complemento instalado com sucesso'), ('1270', 'meeting_invite_link', NULL, NULL, NULL, 'Link de convite para reunião'), ('1271', 'enter_meeting_invite_link', NULL, NULL, NULL, 'Insira o link do convite da reunião'), ('1272', 'all_questions', NULL, NULL, NULL, 'Todas as perguntas'), ('1273', 'found', NULL, NULL, NULL, 'Encontrado'), ('1274', 'there_is_no_data_related_to_your_question', NULL, NULL, NULL, 'Não há dados relacionados à sua pergunta'), ('1275', 'booked_tuition', NULL, NULL, NULL, 'Aulas reservadas'), ('1276', 'my_ebooks', NULL, NULL, NULL, 'Meus e-books'), ('1277', 'affiliate_history_', NULL, NULL, NULL, 'História do afiliado'), ('1278', 'payout_settings', NULL, NULL, NULL, 'Configurações de pagamento'), ('1279', 'be_careful', NULL, NULL, NULL, 'Tome cuidado'), ('1280', 'just_configure_the_payment_gateway_you_want_to_use,_leave_the_rest_blank.', NULL, NULL, NULL, 'Basta configurar o gateway de pagamento que deseja utilizar, deixar o restante em branco.'), ('1281', 'also,_make_sure_that_you_have_configured_your_payment_settings_correctly', NULL, NULL, NULL, 'Além disso, certifique-se de ter configurado suas configurações de pagamento corretamente'), ('1282', 'setup_your_payment_settings', NULL, NULL, NULL, 'Defina suas configurações de pagamento'), ('1283', 'affiliate_course_history', NULL, NULL, NULL, 'Histórico do curso afiliado'), ('1284', 'total_affiliate_earnings_:', NULL, NULL, NULL, 'Ganhos totais do afiliado:'), ('1285', 'available_balance_to_withdrawal', NULL, NULL, NULL, 'Saldo disponível para retirada'), ('1286', 'earning_history', NULL, NULL, NULL, 'Histórico de ganhos'), ('1287', 'withdrawal_history', NULL, NULL, NULL, 'Histórico de retiradas'), ('1288', 'withdrawal_available_earning', NULL, NULL, NULL, 'Retirada de ganhos disponíveis'), ('1289', 'request_withdrawl', NULL, NULL, NULL, 'Solicitar retirada'), ('1290', 'enter_withdrawl_amount', NULL, NULL, NULL, 'Insira o valor do saque'), ('1291', 'you_have_to_buy_the_course_first', NULL, NULL, NULL, 'Você tem que comprar o curso primeiro'), ('1292', 'notice', NULL, NULL, NULL, 'Perceber'), ('1293', 'you_have_completed', NULL, NULL, NULL, 'Você completou'), ('1294', 'of_the_course', NULL, NULL, NULL, 'Do curso'), ('1295', 'you_can_download_the_course_completion_certificate_after_completing_the_course', NULL, NULL, NULL, 'Você pode baixar o certificado de conclusão do curso após concluí-lo'), ('1296', 'the_course_is_not_over_yet', NULL, NULL, NULL, 'O curso ainda não acabou'), ('1297', 'list_of_tuitions', 'List of tuitions', NULL, NULL, 'lista de tutores'), ('1298', 'filters', 'Filters', NULL, NULL, 'Filtros'), ('1299', 'tuition_type', 'Tuition type', NULL, NULL, 'Tipo de aula'), ('1300', 'online', 'Online', NULL, NULL, 'Online'), ('1301', 'in_perosn', 'In perosn', NULL, NULL, 'Em pessoa'), ('1302', 'main_category', 'Main category', NULL, NULL, 'Categoria principal'), ('1303', 'sub_category', 'Sub category', NULL, NULL, 'Subcategoria'), ('1304', 'price_range', 'Price range', NULL, NULL, 'Faixa de preço'), ('1305', 'hourly', 'Hourly', NULL, NULL, 'De hora em hora'), ('1306', 'fixed', 'Fixed', NULL, NULL, 'Fixo'), ('1307', 'tutors', 'Tutors', NULL, NULL, 'Tutores'), ('1308', 'tution_availability', 'Tution availability', NULL, NULL, 'Disponibilidade de aulas'), ('1309', 'single_time', 'Single time', NULL, NULL, 'Única vez'), ('1310', 'selected_days_', 'Selected days ', NULL, NULL, 'Dias selecionados'), ('1311', 'no_result_found', 'No result found', NULL, NULL, 'nenhum resultado encontrado'), ('1312', 'purchase_for', NULL, NULL, NULL, 'Compre por'), ('1313', 'please_login_first', NULL, NULL, NULL, 'Por favor faça login primeiro'), ('1314', 'lesson_has_been_deleted_successfully', NULL, NULL, NULL, 'A lição foi excluída com sucesso'), ('1315', 'select_lesson_type', NULL, NULL, NULL, 'Selecione o tipo de aula'), ('1316', 'secured', NULL, NULL, NULL, 'Protegido'), ('1317', 'video_file', NULL, NULL, NULL, 'Arquivo de vídeo'), ('1318', 'google_drive_video', NULL, NULL, NULL, 'Vídeo do Google Drive'), ('1319', 'document_file', NULL, NULL, NULL, 'Arquivo de documento'), ('1320', 'text', NULL, NULL, NULL, 'Texto'), ('1321', 'image_file', NULL, NULL, NULL, 'Arquivo de imagem'), ('1322', 'iframe_embed', NULL, NULL, NULL, 'Incorporação de iframe'), ('1323', 'please_select_a_course', NULL, NULL, NULL, 'Selecione um curso'), ('1324', 'change', NULL, NULL, NULL, 'Mudar'), ('1325', 'upload_system_video_file', NULL, NULL, NULL, 'Carregar arquivo de vídeo do sistema'), ('1326', 'select_system_video_file', NULL, NULL, NULL, 'Selecione o arquivo de vídeo do sistema'), ('1327', 'has_to_be_bigger_than', NULL, NULL, NULL, 'Tem que ser maior que'), ('1328', 'lesson_has_been_added_successfully', NULL, NULL, NULL, 'A lição foi adicionada com sucesso'), ('1329', 'your_servers_file_upload_limit_is_9000mb', NULL, NULL, NULL, 'O limite de upload de arquivos do seu servidor é de 9.000 MB'), ('1330', 'connect_with_us_to_experience_seamless_communication._we_value_open_dialogue_and_are_eager_to_engage_with_you._whether_you_have_questions,_ideas,_or_feedback,_we_are_here_to_listen_and_respond.', NULL, NULL, NULL, 'Conecte-se conosco para experimentar uma comunicação perfeita. valorizamos o diálogo aberto e estamos ansiosos para interagir com você. quer você tenha dúvidas, ideias ou comentários, estamos aqui para ouvir e responder.'), ('1331', 'get_in_touch', NULL, NULL, NULL, 'Entrar em contato'), ('1332', 'our_address', NULL, NULL, NULL, 'Nosso endereço'), ('1333', 'i_agree_that_my_submitted_data_is_being_collected_and_stored.', NULL, NULL, NULL, 'Concordo que meus dados enviados sejam coletados e armazenados.'), ('1334', 'contact_information_updated_successfully', NULL, NULL, NULL, 'Informações de contato atualizadas com sucesso'), ('1335', 'indonesian', NULL, NULL, NULL, 'Indonésia'), ('1336', 'has_been_added_successfully', NULL, NULL, NULL, 'Foi adicionado com sucesso'), ('1337', 'analyzing_the_url', NULL, NULL, NULL, 'Analisando a URL'), ('1338', 'invalid_url', NULL, NULL, NULL, 'URL inválida'), ('1339', 'your_video_source_has_to_be_either_youtube_or_vimeo', NULL, NULL, NULL, 'A fonte do seu vídeo deve ser YouTube ou Vimeo'), ('1340', 'provide_a_section_name', NULL, NULL, NULL, 'Forneça um nome de seção'), ('1341', 'date_of_study_plan', NULL, NULL, NULL, 'Data do plano de estudos'), ('1342', 'optional', NULL, NULL, NULL, 'Optional'), ('1343', 'restriction_of_study_plan', NULL, NULL, NULL, 'Restrição de plano de estudos'), ('1344', 'no_restriction', NULL, NULL, NULL, 'Sem restrição'), ('1345', 'until_the_start_date,_keep_this_section_locked', NULL, NULL, NULL, 'Até a data de início, mantenha esta seção bloqueada'), ('1346', 'keep_this_section_open_only_within_the_selected_date_range', NULL, NULL, NULL, 'Mantenha esta seção aberta apenas dentro do período selecionado'), ('1347', 'user', NULL, NULL, NULL, 'Usuário'), ('1348', 'paid_amount', NULL, NULL, NULL, 'Quantidade paga'), ('1349', 'apply_to_become_an_instructor', NULL, NULL, NULL, 'Inscreva-se para se tornar um instrutor'), ('1350', 'account', NULL, NULL, NULL, 'Conta'), ('1351', 'instructor_dashboard', NULL, NULL, NULL, 'Painel do instrutor'), ('1352', 'become_an_affiliator', NULL, NULL, NULL, 'Torne-se um afiliado'), ('1353', 'sales_report', NULL, NULL, NULL, 'Relatório de vendas'), ('1354', 'student_bookings', NULL, NULL, NULL, 'Reservas de estudantes'), ('1355', 'payout_report', NULL, NULL, NULL, 'Relatório de pagamento'), ('1356', 'number_of_courses', NULL, NULL, NULL, 'Número de cursos'), ('1357', 'pending_balance', NULL, NULL, NULL, 'Balanço pendente'), ('1358', 'notice_details', NULL, NULL, NULL, 'Detalhes do aviso'), ('1359', 'resend_mail', NULL, NULL, NULL, 'Reenviar e-mail'), ('1360', 'edit_notice', NULL, NULL, NULL, 'Editar aviso'), ('1361', 'start_meeting', NULL, NULL, NULL, 'Iniciar reunião'), ('1362', 'enter_your_text', NULL, NULL, NULL, 'Digite seu texto'), ('1363', 'section_has_been_updated_successfully', NULL, NULL, NULL, 'A seção foi atualizada com sucesso'), ('1364', 'study_plan', NULL, NULL, NULL, 'Plano de estudo'), ('1365', 'my_bundles', NULL, NULL, NULL, 'Meus pacotes'), ('1366', 'draft_courses', NULL, NULL, NULL, 'Rascunhos de cursos'), ('1367', 'mark_as_drafted', NULL, NULL, NULL, 'Marcar como redigido'), ('1368', 'total_section', NULL, NULL, NULL, 'Seção total'), ('1369', 'total_lesson', NULL, NULL, NULL, 'Lição total'), ('1370', 'total_attempts', NULL, NULL, NULL, 'Total de tentativas'), ('1371', 'obtained_marks_of_all_attempts', NULL, NULL, NULL, 'Notas obtidas em todas as tentativas'), ('1372', 'go_to_answer_sheet', NULL, NULL, NULL, 'Ir para a folha de respostas'), ('1373', 'view_profile', 'View profile', NULL, NULL, 'Ver perfil'), ('1374', 'for_web_application', NULL, NULL, NULL, 'Para aplicação web'), ('1375', 'design_rules:_principles_+_practices_for_great_ui_design', NULL, NULL, NULL, 'Regras de design: princípios + práticas para um excelente design de interface do usuário'), ('1376', 'select_student_:', NULL, NULL, NULL, 'Selecione o aluno'), ('1377', 'student_name', NULL, NULL, NULL, 'Nome do aluno'), ('1378', 'course_score', NULL, NULL, NULL, 'Pontuação do curso'), ('1379', 'tutor_categories', NULL, NULL, NULL, 'Categorias de tutor'), ('1380', 'add_category', NULL, NULL, NULL, 'Adicionar categoria'), ('1381', 'tutor_category_add_form', NULL, NULL, NULL, ' Formulário de adição de categoria de tutor'), ('1382', 'data_deleted', NULL, NULL, NULL, 'Dados excluídos'), ('1383', 'update_tutor_category', NULL, NULL, NULL, 'Atualizar categoria de tutor'), ('1384', 'update_tutor_category_form', NULL, NULL, NULL, 'Atualizar formulário de categoria de tutor'), ('1385', 'data_edited_successfully', NULL, NULL, NULL, 'Dados editados com sucesso'), ('1386', 'add_schedule', NULL, NULL, NULL, 'Adicionar programação'), ('1387', 'tution_topic', NULL, NULL, NULL, 'Tópico de aula'), ('1388', 'select_category', NULL, NULL, NULL, 'Selecione a Categoria'), ('1389', 'class_type', NULL, NULL, NULL, 'Tipo de aula'), ('1390', 'in_person', NULL, NULL, NULL, 'Em pessoa'), ('1391', 'price_type', NULL, NULL, NULL, 'Tipo de preço'), ('1392', 'tution_type', NULL, NULL, NULL, 'Tipo de aula'), ('1393', 'repeated_days_', NULL, NULL, NULL, 'Dias repetidos'), ('1394', 'select_days', NULL, NULL, NULL, 'Selecione os dias'), ('1395', 'check_all_', NULL, NULL, NULL, 'Verifique tudo'), ('1396', 'sunday', NULL, NULL, NULL, 'Domingo'), ('1397', 'monday', NULL, NULL, NULL, 'Segunda-feira'), ('1398', 'tuesday', NULL, NULL, NULL, 'Terça-feira'), ('1399', 'wednesday', NULL, NULL, NULL, 'Quarta-feira'), ('1400', 'thursday', NULL, NULL, NULL, 'Quinta-feira'), ('1401', 'friday', NULL, NULL, NULL, 'Sexta-feira'), ('1402', 'saturday', NULL, NULL, NULL, 'Sábado'), ('1403', 'schedule_start_time', NULL, NULL, NULL, 'Agendar horário de início'), ('1404', 'schedule_end_time', NULL, NULL, NULL, 'Agendar horário de término'), ('1405', 'class_duration', NULL, NULL, NULL, NULL), ('1406', 'select_duration', NULL, NULL, NULL, 'Selecione a duração'), ('1407', 'class_invitation_link', NULL, NULL, NULL, 'Link de convite para aula'), ('1408', 'group', NULL, NULL, NULL, 'Grupo'), ('1409', 'single', NULL, NULL, NULL, 'Solteiro (a)'), ('1410', 'start_time', NULL, NULL, NULL, 'Hora de início'), ('1411', 'end_time', NULL, NULL, NULL, 'Fim do tempo'), ('1412', 'one_time', NULL, NULL, NULL, 'Um tempo'), ('1413', 'everyday', NULL, NULL, NULL, 'Diariamente'), ('1414', 'selected_days', NULL, NULL, NULL, 'Dias selecionados'), ('1415', 'save_schedule', NULL, NULL, NULL, 'Salvar programação'), ('1416', 'required_field', NULL, NULL, NULL, 'Campo obrigatório'), ('1417', 'you_can_not_keep_any_field_empty', NULL, NULL, NULL, 'Você não pode deixar nenhum campo vazio'), ('1418', 'booked_schedule', NULL, NULL, NULL, 'Agenda reservada'), ('1419', 'tutor', NULL, NULL, NULL, 'Tutor(a)'), ('1420', 'booked_by', NULL, NULL, NULL, 'Reservado por'), ('1421', 'schedule_added_successfully', NULL, NULL, NULL, 'Agenda adicionada com sucesso'), ('1422', 'list_of_bookings', NULL, NULL, NULL, 'Lista de reservas'), ('1423', 'booking_lists', NULL, NULL, NULL, 'Listas de reservas'), ('1424', 'added_by', NULL, NULL, NULL, 'Adicionado por'), ('1425', 'the_complete_communication_skills_master_class_for_life', NULL, NULL, NULL, 'A aula magistral completa de habilidades de comunicação para a vida'), ('1426', 'business', NULL, NULL, NULL, 'Negócios'), ('1427', 'communication_skills', NULL, NULL, NULL, 'Habilidades de comunicação'), ('1428', 'john_doe', NULL, NULL, NULL, NULL), ('1429', '_schedules', NULL, NULL, NULL, 'horários'), ('1430', 'edit_schedules', NULL, NULL, NULL, 'Editar programações'), ('1431', 'edit_booking', NULL, NULL, NULL, 'Editar reserva'), ('1432', '_inactive_booking', NULL, NULL, NULL, 'reserva inativa'), ('1433', 'leadership:_you_can_speak_like_a_leader', NULL, NULL, NULL, 'Liderança: você pode falar como um líder'), ('1434', 'leadership', NULL, NULL, NULL, 'Liderança'), ('1435', 'finance_and_accounting', NULL, NULL, NULL, 'Finanças e contabilidade'), ('1436', 'graphic_design', NULL, NULL, NULL, 'Design gráfico'), ('1437', 'accounting', NULL, NULL, NULL, 'Contabilidade'), ('1438', 'bookkeeping', NULL, NULL, NULL, 'Escrituração contábil'), ('1439', 'global_economics', NULL, NULL, NULL, 'Economia global'), ('1440', 'photoshop', NULL, NULL, NULL, NULL), ('1441', 'adobe_illustrator', NULL, NULL, NULL, NULL), ('1442', 'drawing', NULL, NULL, NULL, 'Desenho'), ('1443', 'doe', NULL, NULL, NULL, NULL), ('1444', '0', NULL, NULL, NULL, NULL), ('1445', 'available_schedules', NULL, NULL, NULL, 'Horários disponíveis'), ('1446', '67', NULL, NULL, NULL, NULL), ('1447', '2', NULL, NULL, NULL, NULL), ('1448', 'international_economics:_a_comprehensive_economics_course', NULL, NULL, NULL, 'Economia internacional: um curso abrangente de economia'), ('1449', '79', NULL, NULL, NULL, NULL), ('1450', 'blockchain_a-z:_build_a_blockchain,_a_crypto_+_chatgpt_bonus', NULL, NULL, NULL, 'Blockchain a-z: construa um blockchain, um bônus criptográfico + chatgpt'), ('1451', 'mathew_anderson', NULL, NULL, NULL, NULL), ('1452', 'anderson', NULL, NULL, NULL, NULL), ('1453', 'edit_schedule', NULL, NULL, NULL, 'Editar programação'), ('1454', 'eidt_schedule', NULL, NULL, NULL, 'Editar programação'), ('1455', 'update_schedule', NULL, NULL, NULL, 'Cronograma de atualização'), ('1456', 'schedule_updated_successfully', NULL, NULL, NULL, 'Agenda atualizada com sucesso'), ('1457', 'tutore_details', NULL, NULL, NULL, 'Detalhes do tutor'), ('1458', 'john', NULL, NULL, NULL, NULL), ('1459', 'schedule', NULL, NULL, NULL, 'Agendar'), ('1460', 'review', NULL, NULL, NULL, 'Análise'), ('1461', 'availability', NULL, NULL, NULL, 'Disponibilidade'), ('1462', 'view_all_availability', NULL, NULL, NULL, 'Ver toda a disponibilidade'), ('1463', 'hours_taught', NULL, NULL, NULL, 'Horas ensinadas'), ('1464', 'all_review', NULL, NULL, NULL, 'Todas as revisões'), ('1465', 'date_&_time', NULL, NULL, NULL, 'Data hora'), ('1466', 'request_lesson', NULL, NULL, NULL, 'Solicitar aula'), ('1467', 'edit_review', NULL, NULL, NULL, 'Editar avaliação'), ('1468', 'tuition_topic', NULL, NULL, NULL, 'Tópico de mensalidade'), ('1469', 'disable_successfully', NULL, NULL, NULL, 'Desativar com sucesso'), ('1470', 'inactived_booking_lists', NULL, NULL, NULL, 'Listas de reservas inativas'), ('1471', '95', NULL, NULL, NULL, NULL), ('1472', 'course_enrolment', NULL, NULL, NULL, 'Inscrição no curso'), ('1473', 'enrolment_form', NULL, NULL, NULL, 'Formulário de inscrição'), ('1474', 'course_to_enrol', NULL, NULL, NULL, 'Curso para se inscrever'), ('1475', 'enrol_histories', NULL, NULL, NULL, 'Registrar históricos'), ('1476', 'active_affiliators', NULL, NULL, NULL, 'Afiliados ativos'), ('1477', 'add_affiliator', NULL, NULL, NULL, 'Adicionar afiliado'), ('1478', 'active_affiliator_', NULL, NULL, NULL, 'Afiliado ativo'), ('1479', 'suspend_affiliator_', NULL, NULL, NULL, 'Suspender afiliado'), ('1480', 'pending_affiliator_', NULL, NULL, NULL, 'Afiliado pendente'), ('1481', 'suspend', NULL, NULL, NULL, 'Suspender'), ('1482', 'suspended_affiliators', NULL, NULL, NULL, 'Afiliados suspensos'), ('1483', 'pending_affiliators', NULL, NULL, NULL, 'Afiliados pendentes'), ('1484', 'pending_payment_request', NULL, NULL, NULL, 'Solicitação de pagamento pendente'), ('1485', 'offline_payments', NULL, NULL, NULL, 'Pagamentos off-line'), ('1486', 'payment_document', NULL, NULL, NULL, 'Documento de pagamento'), ('1487', 'enrolling_the_student_and_sending_mail', NULL, NULL, NULL, 'Inscrever o aluno e enviar correspondência'), ('1488', 'accepted_payment_request', NULL, NULL, NULL, 'Solicitação de pagamento aceita'), ('1489', 'suspended_payment_request', NULL, NULL, NULL, 'Solicitação de pagamento suspensa'), ('1490', 'enter_your_bank_information', NULL, NULL, NULL, 'Insira suas informações bancárias'), ('1491', 'choose_an_option_from_the_left_side', NULL, NULL, NULL, 'Escolha uma opção do lado esquerdo'), ('1492', 'contact_users', NULL, NULL, NULL, 'Entre em contato com usuários'), ('1493', 'your_contact_request_has_been_sent_successfully', NULL, NULL, NULL, 'Sua solicitação de contato foi enviada com sucesso'), ('1494', 'not_registered', NULL, NULL, NULL, 'Não registrado'), ('1495', 'reply_to_john_dic', NULL, NULL, NULL, 'Respondendo a John Dic'), ('1496', 'reply', NULL, NULL, NULL, 'Responder'), ('1497', 'bundle_review', NULL, NULL, NULL, 'Revisão do pacote'), ('1498', 'ebook_details', NULL, NULL, NULL, NULL), ('1499', 'publisher', NULL, NULL, NULL, 'Editor(a)'), ('1500', 'edition', NULL, NULL, NULL, 'Edição'), ('1501', 'no._of_page', NULL, NULL, NULL, 'Nº da página'), ('1502', 'mathew', NULL, NULL, NULL, ' Matheus'), ('1503', 'language_direction_updated_successfully', NULL, NULL, NULL, 'Direção do idioma atualizada com sucesso'), ('1504', 'sun', NULL, NULL, NULL, 'Dom.'), ('1505', 'zoom_live_class_settings', 'Zoom live class settings', NULL, NULL, 'Zoom nas configurações da aula ao vivo'), ('1506', 'discover_which_courses_are_the_best_for_you', 'Discover which courses are the best for you', NULL, NULL, 'Descubra quais cursos são mais adequados para você'), ('1507', 'add_new_resource_file', NULL, NULL, NULL, 'Adicionar novo arquivo de recursos'), ('1508', 'resource_files', NULL, NULL, NULL, 'Arquivos de recursos'), ('1509', 'enter_your_title', NULL, NULL, NULL, 'Digite seu título'), ('1510', 'resource_file', NULL, NULL, NULL, 'Arquivo de recursos'), ('1511', 'add', NULL, NULL, NULL, 'Adicionar'), ('1512', 'edit_resource', NULL, NULL, NULL, 'Editar recurso'), ('1513', 'resource_deleted_successfully', NULL, NULL, NULL, 'Recurso excluído com sucesso'), ('1514', '64', NULL, NULL, NULL, NULL), ('1515', '36', NULL, NULL, NULL, NULL), ('1516', 'ebook_list', NULL, NULL, NULL, 'Lista de e-books'), ('1517', 'add_new_ebook', NULL, NULL, NULL, 'Adicionar novo e-book'), ('1518', 'ebook_category', NULL, NULL, NULL, 'Categoria de e-book'), ('1519', 'ebook_categories', NULL, NULL, NULL, 'Categorias de e-books'), ('1520', 'add_a_new_ebook_category', NULL, NULL, NULL, 'Adicione uma nova categoria de e-book'), ('1521', 'purchased_item', NULL, NULL, NULL, 'Item comprado'), ('1522', 'ebook_adding_form', NULL, NULL, NULL, 'Formulário de adição de e-book'), ('1523', 'back_to_ebook_list', NULL, NULL, NULL, 'Voltar à lista de e-books'), ('1524', 'ebook_files', NULL, NULL, NULL, 'Arquivos de e-book'), ('1525', 'add_a_new_ebook', NULL, NULL, NULL, 'Adicionar um novo e-book'), ('1526', 'enter_ebook_title', NULL, NULL, NULL, 'Insira o título do e-book'), ('1527', 'ebook_banner', NULL, NULL, NULL, 'Banner do e-book'), ('1528', 'ebook_thumbnail', NULL, NULL, NULL, 'Miniatura do e-book'), ('1529', 'check_if_this_is_a_free_ebook', NULL, NULL, NULL, 'Check if this is a free ebook'), ('1530', 'ebook_price', NULL, NULL, NULL, 'Preço do e-book'), ('1531', 'enter_ebook_price', NULL, NULL, NULL, 'Insira o preço do e-book'), ('1532', 'check_if_this_ebook_has_discount', NULL, NULL, NULL, 'Verifique se este e-book tem desconto'), ('1533', 'this_ebook_has', NULL, NULL, NULL, 'Este e-book tem'), ('1534', 'ebook_preview_file', NULL, NULL, NULL, 'Arquivo de visualização do e-book'), ('1535', 'ebook_complete_file', NULL, NULL, NULL, 'Arquivo completo do e-book'), ('1536', 'ebook_admin_revenue', NULL, NULL, NULL, 'Receita de administração de e-books'), ('1537', 'purchase_date', NULL, NULL, NULL, 'Data de compra'), ('1538', 'ebook_instructor_revenue', NULL, NULL, NULL, 'Receita do instrutor de e-book'), ('1539', 'add_course_bundle', NULL, NULL, NULL, 'Adicionar pacote de cursos'), ('1540', 'create_bundle', NULL, NULL, NULL, 'Criar pacote'), ('1541', 'add_new_coupon', NULL, NULL, NULL, 'Adicionar novo cupom'), ('1542', 'coupon_code', NULL, NULL, NULL, 'Código do cupom'), ('1543', 'discount_percentage', NULL, NULL, NULL, 'Porcentagem de desconto'), ('1544', 'validity_till', NULL, NULL, NULL, 'Validade até'), ('1545', 'active_subscription_report', NULL, NULL, NULL, 'Relatório de assinatura ativa'), ('1546', 'expire', NULL, NULL, NULL, 'Expirar'), ('1547', 'all_bundles', NULL, NULL, NULL, 'Todos os pacotes'), ('1548', 'amount', NULL, NULL, NULL, 'Quantia'), ('1549', 'expire_date', NULL, NULL, NULL, 'Data de validade'), ('1550', 'expired_subscription_report', NULL, NULL, NULL, 'Relatório de assinatura expirada'), ('1551', 'meeting_id', NULL, NULL, NULL, 'ID da reunião'), ('1552', 'meeting_password', NULL, NULL, NULL, 'Senha da reunião'), ('1553', 'please_configure_client_id_and_secret_key_in_your_zoom_settings_to_start_your_live_class_from_here', NULL, NULL, NULL, 'Configure o ID do cliente e a chave secreta nas configurações de zoom para iniciar sua aula ao vivo a partir daqui'), ('1554', 'fri', NULL, NULL, NULL, 'Sex.'), ('1555', 'ask_your_question', NULL, NULL, NULL, 'Faça sua pergunta'), ('1556', 'title_or_summary', NULL, NULL, NULL, 'Título ou resumo'), ('1557', 'send_notification', NULL, NULL, NULL, 'Enviar notificação'), ('1558', 'write_a_reply', NULL, NULL, NULL, 'Escreva uma resposta'), ('1559', 'publish_reply', NULL, NULL, NULL, 'Publicar resposta'), ('1560', 'zoom_oauth_configuration', NULL, NULL, NULL, 'Configuração de zoom oauth'), ('1561', 'zoom_oauth_creation_instruction', NULL, NULL, NULL, 'Instruções de criação de Zoom OAuth'), ('1562', 'how_to_create_zoom_oauth_app?', NULL, NULL, NULL, 'Como criar um aplicativo zoom oauth?'), ('1563', 'your_servers_file_upload_limit_is_40mb', NULL, NULL, NULL, 'O limite de upload de arquivos do seu servidor é de 40 MB'), ('1564', 'color_theory_for_designers', NULL, NULL, NULL, 'Teoria das cores para designers'), ('1565', 'lesson_has_been_updated_successfully', NULL, NULL, NULL, 'A lição foi atualizada com sucesso'), ('1566', 'video_url_is_not_supported', NULL, NULL, NULL, 'O URL do vídeo não é compatível'), ('1567', 'add_coupons', NULL, NULL, NULL, 'Adicionar cupons'), ('1568', 'back_to_coupons', NULL, NULL, NULL, 'Voltar aos cupons'), ('1569', 'coupon_add_form', NULL, NULL, NULL, 'Formulário para adicionar cupom'), ('1570', 'generate_a_random_coupon_code', NULL, NULL, NULL, 'Gere um código de cupom aleatório'), ('1571', 'generate_random', NULL, NULL, NULL, 'Gerar aleatoriamente'), ('1572', 'expiry_date', NULL, NULL, NULL, 'Data de validade'), ('1573', 'coupon_added_successfully', NULL, NULL, NULL, 'Cupom adicionado com sucesso'), ('1574', 'included_course', NULL, NULL, NULL, 'Curso incluído'), ('1575', 'buy_subscription', NULL, NULL, NULL, 'Comprar assinatura'), ('1576', 'course_bundle_updated_successfully', NULL, NULL, NULL, 'Pacote de cursos atualizado com sucesso'), ('1577', 'list_of_schedules', NULL, NULL, NULL, 'Lista de horários'), ('1578', 'booking_title_:_the_complete_communication_skills_master_class_for_life', NULL, NULL, NULL, 'Título da reserva: a master class completa sobre habilidades de comunicação para toda a vida'), ('1579', '_active_schedule_list', NULL, NULL, NULL, 'lista de agendamento ativo'), ('1580', 'upcoming_', NULL, NULL, NULL, 'Por vir'), ('1581', 'archive_', NULL, NULL, NULL, ' Arquivo'), ('1582', 'active_till', NULL, NULL, NULL, 'Ativo até'), ('1583', 'time_', NULL, NULL, NULL, 'Tempo'), ('1584', 'monday,', NULL, NULL, NULL, 'Segunda-feira'), ('1585', 'tuesday,', NULL, NULL, NULL, 'Terça-feira'), ('1586', 'wednesday,', NULL, NULL, NULL, 'Quarta-feira'), ('1587', 'thursday,', NULL, NULL, NULL, 'Quinta-feira'), ('1588', 'friday,', NULL, NULL, NULL, 'Sexta-feira'), ('1589', 'saturday,', NULL, NULL, NULL, 'Sábado'), ('1590', 'available', NULL, NULL, NULL, 'Disponível'), ('1591', 'start_class_', NULL, NULL, NULL, 'Começar a aula'), ('1592', '_inactive', NULL, NULL, NULL, 'Inativo'), ('1593', 'edit_ebook', NULL, NULL, NULL, 'Editar e-book'), ('1594', 'ebook_editing_form', NULL, NULL, NULL, 'Formulário de edição de e-book'), ('1595', 'enter_publication_name', NULL, NULL, NULL, 'Insira o nome da publicação'), ('1596', 'enter_edition', NULL, NULL, NULL, 'Insira a edição'), ('1597', 'minimum_required_value_1', NULL, NULL, NULL, 'Valor mínimo exigido 1'), ('1598', 'ebook_category_updated_successfully', NULL, NULL, NULL, 'Categoria do e-book atualizada com sucesso'), ('1599', 'newsletter_updated_successfully', NULL, NULL, NULL, 'Newsletter atualizada com sucesso'), ('1600', 'build_websites_from_scratch_with_html_&_css', NULL, NULL, NULL, 'Crie sites do zero com HTML e CSS'), ('1601', 'view', NULL, NULL, NULL, 'Visualizar'), ('1602', 'ebook_category_deleted_successfully', NULL, NULL, NULL, 'Categoria de e-book excluída com sucesso'), ('1603', 'student_has_been_enrolled', NULL, NULL, NULL, 'O aluno foi matriculado'), ('1604', 'user_name', NULL, NULL, NULL, 'Nome de usuário'), ('1605', 'enrollment_date', NULL, NULL, NULL, 'Data de inscrição'), ('1606', 'data_deleted_successfully', NULL, NULL, NULL, 'Dados excluídos com sucesso'), ('1607', 'add_an_affiliator', NULL, NULL, NULL, 'Adicionar um afiliado'), ('1608', 'affiliator_add_form', NULL, NULL, NULL, 'Formulário de adição de afiliado'), ('1609', 'paypal_client_id', NULL, NULL, NULL, 'ID do cliente Paypal'), ('1610', 'paypal_secret_key', NULL, NULL, NULL, 'Chave secreta do Paypal'), ('1611', 'stripe_public_key', NULL, NULL, NULL, 'Stripe chave pública'), ('1612', 'stripe_secret_key', NULL, NULL, NULL, 'Stripe chave secreta'), ('1613', 'affiliate_addon_settings', NULL, NULL, NULL, 'Configurações de complemento de afiliado'), ('1614', 'allow_public_affiliator', NULL, NULL, NULL, 'Permitir afiliado público'), ('1615', 'affiliate_commission_percentage', NULL, NULL, NULL, 'Porcentagem de comissão de afiliado'), ('1616', 'affiliation_course_payouts', NULL, NULL, NULL, 'Pagamentos de cursos de afiliação'), ('1617', 'affiliate_payouts', NULL, NULL, NULL, 'Pagamentos de afiliados'), ('1618', 'complete_payouts', NULL, NULL, NULL, 'Pagamentos completos'), ('1619', 'admin_add', NULL, NULL, NULL, 'Adicionar administrador'), ('1620', 'back_to_admins', NULL, NULL, NULL, 'Voltar para administradores'), ('1621', 'admin_add_form', NULL, NULL, NULL, 'formulário de adição de administrador'), ('1622', 'please_enter_your_messsage', NULL, NULL, NULL, 'Por favor, digite sua mensagem'), ('1623', 'sent_message', NULL, NULL, NULL, 'Mensagem enviada'), ('1624', 'introduction_and_learn_bootstrap', NULL, NULL, NULL, 'Introdução e aprender bootstrap'), ('1625', 'you_have_successfully_rated_the_course', NULL, NULL, NULL, 'Você avaliou o curso com sucesso'), ('1626', 'the_complete_graphic_design_theory', NULL, NULL, NULL, 'A teoria completa do design gráfico'), ('1627', 'scorm_drawing_course', NULL, NULL, NULL, 'Curso de desenho Scorm'), ('1628', 'renew_subscription', NULL, NULL, NULL, 'Renovar inscrição'), ('1629', 'rating', NULL, NULL, NULL, 'Avaliação'), ('1630', 'archive', NULL, NULL, NULL, 'Arquivo'), ('1631', 'there_are_no_courses_on_your_cart', NULL, NULL, NULL, 'Não há cursos no seu carrinho'), ('1632', 'blog_masterclass:_how_to_build_a_successful', NULL, NULL, NULL, 'Masterclass de blog: como construir um sucesso'), ('1633', 'ultimate_guide_to_running', NULL, NULL, NULL, 'Guia definitivo para correr'), ('1634', 'course_not_found', NULL, NULL, NULL, 'Curso não encontrado'), ('1635', 'sorry,_try_using_more_similar_words_in_your_search.', NULL, NULL, NULL, 'Desculpe, tente usar mais palavras semelhantes em sua pesquisa.'), ('1636', 'home_page', NULL, NULL, NULL, 'Pagina inicial'), ('1637', 'the_course_creator_must_have_zoom_client_id_and_secret_key_configured', NULL, NULL, NULL, 'O criador do curso deve ter o ID do cliente zoom e a chave secreta configurados'), ('1638', 'short_title_about_yourself', NULL, NULL, NULL, 'Título curto sobre você'), ('1639', 'your_skills', NULL, NULL, NULL, 'Suas habilidades'), ('1640', 'year', NULL, NULL, NULL, 'Ano'), ('1641', 'month', NULL, NULL, NULL, 'Mês'), ('1642', 'day', NULL, NULL, NULL, 'Dia'), ('1643', 'hour', NULL, NULL, NULL, 'Hora'), ('1644', 'minute', NULL, NULL, NULL, 'Minuto'), ('1645', 'second', NULL, NULL, NULL, 'Segundo'), ('1646', 'ago', NULL, NULL, NULL, 'Ago'), ('1647', 'articles', NULL, NULL, NULL, 'Articles'), ('1648', 'blog_categories', NULL, NULL, NULL, 'Categorias de blogs'), ('1649', 'add_a_new_category', NULL, NULL, NULL, 'Adicionar uma nova categoria'), ('1650', 'ebook_updated_successfully', NULL, NULL, NULL, 'Ebook atualizado com sucesso'), ('1651', 'zoom_live_settings', NULL, NULL, NULL, 'Configurações de zoom ao vivo'), ('1652', 'affiliation_status', NULL, NULL, NULL, 'Status de afiliação'), ('1653', 'ebook_added_successfully', NULL, NULL, NULL, 'E-book adicionado com sucesso'), ('1654', 'ebook_deleted_successfully', NULL, NULL, NULL, 'E-book excluído com sucesso'), ('1655', 'activate', NULL, NULL, NULL, 'ativar'), ('1656', 'ebook_activate_successfully', NULL, NULL, NULL, 'E-book ativado com sucesso'), ('1657', 'the_complete_digital_marketing_guide', NULL, NULL, NULL, 'O guia completo de marketing digital'), ('1658', '47', NULL, NULL, NULL, NULL), ('1659', '19', NULL, NULL, NULL, NULL), ('1660', 'user_deleted_successfully', NULL, NULL, NULL, 'Usuário excluído com sucesso'), ('1661', 'you_have_no_items_in_your_wishlist!', NULL, NULL, NULL, 'Você não têm itens na sua lista de desejos!'), ('1662', 'professional_skills', NULL, NULL, NULL, 'Habilidades profissionais'), ('1663', 'country', NULL, NULL, NULL, 'País'), ('1664', 'city', NULL, NULL, NULL, 'Cidade'), ('1665', 'zip_code', NULL, NULL, NULL, 'CEP'), ('1666', 'state', NULL, NULL, NULL, 'Estado'), ('1667', 'pay_now', NULL, NULL, NULL, 'Pague agora'), ('1668', 'pay_by_iyzico', NULL, NULL, NULL, 'Pagar por iyzico'), ('1669', 'payable_amount', NULL, NULL, NULL, 'Valor a pagar'), ('1670', 'document_of_your_payment', NULL, NULL, NULL, 'Documento do seu pagamento'), ('1671', 'submit_payment_document', NULL, NULL, NULL, 'Enviar documento de pagamento'), ('1672', 'pay_by_paystack', NULL, NULL, NULL, ' Pagar por paystack'), ('1673', 'pay_by_paytm', NULL, NULL, NULL, ' Pagar por paytm'), ('1674', 'pay_by_xendit', NULL, NULL, NULL, ' Pagar por xendit'), ('1675', 'pay_by_payu', NULL, NULL, NULL, ' Pagar por payu'), ('1676', 'pay_by_pageseguro', NULL, NULL, NULL, 'Pague por pageseguro'), ('1677', 'pay_by_ssl_commerz', NULL, NULL, NULL, ' Pagar por ssl commerz'), ('1678', 'pay_by_skrill', NULL, NULL, NULL, ' Pagar por skrill'), ('1679', 'pay_by_doku', NULL, NULL, NULL, ' Pagar por doku'), ('1680', 'pay_with_bkash', NULL, NULL, NULL, ' Pagar com bkash'), ('1681', 'pay_by_cashfree', NULL, NULL, NULL, ' Pague sem cashfree'), ('1682', 'telephone', NULL, NULL, NULL, 'Telefone'), ('1683', 'pay_by_maxicash', NULL, NULL, NULL, ' Pagar por maxicash'), ('1684', 'bootcamp', 'Bootcamp', NULL, NULL, 'Bootcamp'), ('1685', 'bootcamp_list', 'Bootcamp list', NULL, NULL, ' Lista de bootcamp'), ('1686', 'add_bootcamp', 'Add bootcamp', NULL, NULL, ' Adicionar bootcamp'), ('1687', 'bootcamps', 'Bootcamps', NULL, NULL, 'Bootcamps'), ('1688', 'module_and_class', NULL, NULL, NULL, 'Módulo e aula'), ('1689', 'bootcamp_form', NULL, NULL, NULL, 'Formulário de bootcamp'), ('1690', 'add_new_bootcamp', NULL, NULL, NULL, 'Adicionar novo bootcamp'), ('1691', 'bootcamp_add_form', NULL, NULL, NULL, ' Formulário de adição do Bootcamp'), ('1692', 'bootcamp_title', NULL, NULL, NULL, 'Título do bootcamp'), ('1693', 'start_date', NULL, NULL, NULL, 'Data de início'), ('1694', 'bootcamp_faq', NULL, NULL, NULL, ' Perguntas frequentes sobre o bootcamp'), ('1695', 'check_if_this_is_a_free_nodule', NULL, NULL, NULL, 'Verifique se este é um nódulo grátis'), ('1696', 'enter_price', NULL, NULL, NULL, 'Insira o preço'), ('1697', 'check_if_this_module_has_discount', NULL, NULL, NULL, 'Verifique se este módulo tem desconto'), ('1698', 'this_module_has', NULL, NULL, NULL, 'Este módulo possui'), ('1699', 'bootcamp_thumbnail', NULL, NULL, NULL, 'Miniatura do Bootcamp'), ('1700', 'add_bootcamp_category', NULL, NULL, NULL, 'Adicionar categoria de bootcamp'), ('1701', 'bootcamp_category', NULL, NULL, NULL, 'Categoria Bootcamp'), ('1702', 'payment_report', NULL, NULL, NULL, 'Relatório de pagamento'), ('1703', 'category_added.', NULL, NULL, NULL, 'Categoria adicionada.'), ('1704', 'edit_bootcamp_category', NULL, NULL, NULL, 'Editar categoria de bootcamp'), ('1705', 'bootcamp_created', NULL, NULL, NULL, 'Bootcamp criado'), ('1706', 'edit_bootcamp', NULL, NULL, NULL, 'Editar bootcamp'), ('1707', 'bootcamp_edit_form', NULL, NULL, NULL, 'Formulário de edição do Bootcamp'), ('1708', 'add_new_module', NULL, NULL, NULL, 'Adicionar novo módulo'), ('1709', 'add_module', NULL, NULL, NULL, 'Adicionar módulo'), ('1710', 'add_live_class', NULL, NULL, NULL, 'Adicionar aula ao vivo'), ('1711', 'sort_section', NULL, NULL, NULL, 'Seção de classificação'), ('1712', 'module_price', NULL, NULL, NULL, 'Preço do módulo'), ('1713', 'enter_module_price', NULL, NULL, NULL, 'Insira o preço do módulo'), ('1714', 'after_purchase,_students_can_access_the_module_until_your_selected_time.', NULL, NULL, NULL, 'Após a compra, os alunos poderão acessar o módulo até o horário selecionado.'), ('1715', 'owner', NULL, NULL, NULL, 'Proprietário(a)'), ('1716', 'module', NULL, NULL, NULL, 'Módulo'), ('1717', 'class', NULL, NULL, NULL, 'Aula'), ('1718', 'bootcamp_updated', NULL, NULL, NULL, 'Bootcamp atualizado'), ('1719', 'module_name', NULL, NULL, NULL, 'Nome do módulo'), ('1720', 'restriction_of_study_plan:_', NULL, NULL, NULL, 'Restrição de plano de estudos'), ('1721', 'class_schedule', NULL, NULL, NULL, 'Horário de aula'), ('1722', 'estimated_time', NULL, NULL, NULL, 'Tempo estimado'), ('1723', 'live', NULL, NULL, NULL, 'Live'), ('1724', 'sections_have_been_sorted', NULL, NULL, NULL, 'As seções foram classificadas'), ('1725', 'module_created', NULL, NULL, NULL, 'Módulo criado'), ('1726', 'sort_class', NULL, NULL, NULL, 'Classificar classe'), ('1727', 'edit_module', NULL, NULL, NULL, 'Editar módulo'), ('1728', 'live_class_added', NULL, NULL, NULL, ' Aula ao vivo adicionada'), ('1729', 'add_resource', NULL, NULL, NULL, 'Adicionar recurso'), ('1730', 'resource', NULL, NULL, NULL, 'Recurso'), ('1731', 'edit_live_class', NULL, NULL, NULL, 'Editar aula ao vivo'), ('1732', 'module_updated.', NULL, NULL, NULL, 'Módulo atualizado.'), ('1733', 'list_of_sections', NULL, NULL, NULL, 'Lista de seções'), ('1734', 'update_sorting', NULL, NULL, NULL, 'Atualizar classificação'), ('1735', 'choose_a_file', NULL, NULL, NULL, 'Escolha um arquivo'), ('1736', 'please_set_schedule_properly', NULL, NULL, NULL, 'Por favor, defina o cronograma corretamente'), ('1737', 'live_class_updated.', NULL, NULL, NULL, 'Aula ao vivo atualizada.'), ('1738', 'all_bootcamps', NULL, NULL, NULL, 'Todos os bootcamps'), ('1739', 'please_select_a_module.', NULL, NULL, NULL, 'Selecione um módulo.'), ('1740', 'pay_for_purchasing_bootcamp', NULL, NULL, NULL, 'Pague pela compra do bootcamp'), ('1741', 'your_document_will_be_reviewd', NULL, NULL, NULL, 'Seu documento será analisado'), ('1742', 'payment_document_file', NULL, NULL, NULL, 'Arquivo de documento de pagamento'), ('1743', 'suspended', NULL, NULL, NULL, 'Suspenso'), ('1744', 'pending_payments_has_been_approved', NULL, NULL, NULL, 'Os pagamentos pendentes foram aprovados'), ('1745', 'payment_not_configured_yet', 'Payment not configured yet', NULL, NULL, 'Pagamento ainda não configurado'), ('1746', 'my_bootcamp', NULL, NULL, NULL, 'Meu bootcamp'), ('1747', 'start_date:', NULL, NULL, NULL, 'Start date'), ('1748', 'starts', NULL, NULL, NULL, 'Começa'), ('1749', 'this_is_content_is_currently_locked.', NULL, NULL, NULL, 'Este conteúdo está atualmente bloqueado.'), ('1750', 'from', NULL, NULL, NULL, 'De'), ('1751', 'to', NULL, NULL, NULL, 'Para'), ('1752', 'your_servers_file_upload_limit_is_500mb', NULL, NULL, NULL, 'O limite de upload de arquivos do seu servidor é de 500 MB'), ('1753', 'jitsi_live_class_settings', NULL, NULL, NULL, 'Configurações de aula ao vivo de Jitsi'), ('1754', 'team_training', NULL, NULL, NULL, 'Treinamento de equipe'), ('1755', 'manage_packages', NULL, NULL, NULL, 'Gerenciar pacotes'), ('1756', 'add_new_package', NULL, NULL, NULL, 'Adicionar novo pacote'), ('1757', 'teams', NULL, NULL, NULL, 'Equipes'), ('1758', 'your_servers_file_upload_limit_is_64mb', NULL, NULL, NULL, 'O limite de upload de arquivos do seu servidor é de 64 MB'), ('1759', 'our_premium_services', NULL, NULL, NULL, 'Nossos serviços premium'), ('1760', 'explore_our_upcoming_courses', NULL, NULL, NULL, 'Explore nossos próximos cursos'), ('1761', 'our_expert_instructor_', NULL, NULL, NULL, 'Nosso instrutor especialista'), ('1762', 'learn', NULL, NULL, NULL, ' Aprender'), ('1763', 'new_skills_when_and_where_you_like.', NULL, NULL, NULL, 'Novas habilidades quando e onde você quiser.'), ('1764', 'discover_a_world_of_learning_opportunities_through_our_upcoming_courses,_where_industry_experts.', NULL, NULL, NULL, 'Descubra um mundo de oportunidades de aprendizagem por meio de nossos próximos cursos, com especialistas do setor.'), ('1765', 'join_course_for_free', NULL, NULL, NULL, 'Participe do curso gratuitamente'), ('1766', 'became_a_instructor', NULL, NULL, NULL, 'Tornou-se um instrutor'), ('1767', 'share_on_facebook', 'Share on facebook', NULL, NULL, 'Compartilhar no Facebook'), ('1768', 'share_on_twitter', 'Share on twitter', NULL, NULL, 'Compartilhar no Twitter'), ('1769', 'share_on_whatsapp', 'Share on whatsapp', NULL, NULL, 'Compartilhe no Whatsapp'), ('1770', 'share_on_linkedin', 'Share on linkedin', NULL, NULL, 'Compartilhe no LinkedIn'), ('1771', 'my_teams', NULL, NULL, NULL, 'Minhas equipes'), ('1772', 'bbb_live_class', NULL, NULL, NULL, 'Aula ao vivo do BB'), ('1773', 'moderator_password', NULL, NULL, NULL, 'Senha do moderador'), ('1774', 'viewer_password', NULL, NULL, NULL, 'Senha do visualizador'), ('1775', 'instructions_for_students', NULL, NULL, NULL, 'Instruções para alunos'), ('1776', 'attention!', NULL, NULL, NULL, 'Atenção'), ('1777', 'give_some_instructions_to_keep_your_students_informed_about_the_meeting', NULL, NULL, NULL, 'Dê algumas instruções para manter seus alunos informados sobre a reunião'), ('1778', 'save_meeting_info', NULL, NULL, NULL, 'Salvar informações da reunião'), ('1779', 'meeting_id_and_password_can_not_be_empty', NULL, NULL, NULL, 'O ID e a senha da reunião não podem ficar vazios'), ('1780', 'moderator_and_viewer_password_can_not_be_same', NULL, NULL, NULL, 'A senha do moderador e do visualizador não pode ser a mesma'), ('1781', 'upcoming_image_thumbnail', NULL, NULL, NULL, ' Próxima miniatura da imagem'), ('1782', 'start_live_class', NULL, NULL, NULL, 'Iniciar aula ao vivo'), ('1783', 'change_course_author', NULL, NULL, NULL, 'Alterar autor do curso'), ('1784', 'xendit', NULL, NULL, NULL, 'Xendit'), ('1785', 'payu', NULL, NULL, NULL, 'Payu'), ('1786', 'pagseguro', NULL, NULL, NULL, 'Pagseguro'), ('1787', 'ssl_commerz', NULL, NULL, NULL, 'Ssl commerz'), ('1788', 'skrill', NULL, NULL, NULL, 'Skrill'), ('1789', 'doku', NULL, NULL, NULL, 'Doku'), ('1790', 'bkash', NULL, NULL, NULL, 'Bkash'), ('1791', 'cashfree', NULL, NULL, NULL, 'Cashfree'), ('1792', 'maxicash', NULL, NULL, NULL, 'Maxicash'), ('1793', 'aamarpay', NULL, NULL, NULL, 'Aamarpay'), ('1794', 'flutterwave', NULL, NULL, NULL, 'Flutterwave'), ('1795', 'tazapay', NULL, NULL, NULL, 'Tazapay'), ('1796', 'sub_category_thumbnail', NULL, NULL, NULL, 'Miniatura da subcategoria'), ('1797', 'your_servers_file_upload_limit_is_100mb', NULL, NULL, NULL, 'O limite de upload de arquivos do seu servidor é de 100 MB'), ('1798', 'view_all', NULL, NULL, NULL, 'Ver tudo'), ('1799', 'music_theory_-_fundamentals_for_composition_in_any_genre', NULL, NULL, NULL, ' Teoria musical – fundamentos para composição em qualquer gênero'), ('1800', 'to_start_the_zoom_meeting,_you_need_to_configure_the_zoom_settings_from_the_course_creator_account._also,_the_meeting_id_and_password_must_be_configured_from_the_same_account.', NULL, NULL, NULL, 'Para iniciar a reunião de zoom, você precisa definir as configurações de zoom na conta do criador do curso. além disso, o ID da reunião e a senha devem ser configurados na mesma conta.'), ('1801', 'available_team_training_package', NULL, NULL, NULL, 'Pacote de treinamento de equipe disponível'), ('1802', 'sold', NULL, NULL, NULL, 'Vendido'), ('1803', 'capacity', NULL, NULL, NULL, 'Capacidade'), ('1804', 'access_key', NULL, NULL, NULL, 'Chave de acesso'), ('1805', 'bucket_name', NULL, NULL, NULL, 'Nome do intervalo'), ('1806', 'region_name', NULL, NULL, NULL, 'Nome da região'), ('1807', 'دورات_نشطة', NULL, NULL, NULL, 'Cursos ativos'), ('1808', 'buy_new_theme', NULL, NULL, NULL, 'Compre novo tema'), ('1809', 'upload_your_theme_file', NULL, NULL, NULL, 'Carregue seu arquivo de tema'), ('1810', 'installed_themes', NULL, NULL, NULL, 'Temas instalados'), ('1811', 'add_new_themes', NULL, NULL, NULL, 'Adicione novos temas'), ('1812', 'active_theme', NULL, NULL, NULL, 'Tema ativo'), ('1813', 'theme_successfully_activated', NULL, NULL, NULL, 'Tema ativado com sucesso'), ('1814', 'you_do_not_have_right_to_access_this_theme', NULL, NULL, NULL, 'Você não tem direito de acessar este tema'), ('1815', 'total_pending', NULL, NULL, NULL, 'Total pendente'), ('1816', 'waiting_to_be_sent', NULL, NULL, NULL, 'Aguardando ser enviado'), ('1817', 'total_success', NULL, NULL, NULL, 'Sucesso total'), ('1818', 'successfully_sent', NULL, NULL, NULL, 'Enviado com sucesso'), ('1819', 'total_faild', NULL, NULL, NULL, 'Falha total'), ('1820', 'waiting_for_the_next_cue', NULL, NULL, NULL, 'Esperando pela próxima deixa'), ('1821', 'unable_to_send', NULL, NULL, NULL, 'Não foi possível enviar'), ('1822', '10_attempts_failed,_click_here_to_send_email_manually', NULL, NULL, NULL, '10 tentativas falharam, clique aqui para enviar e-mail manualmente'), ('1823', 'remove_cronjob_file', NULL, NULL, NULL, 'Remover arquivo cronjob'), ('1824', 'painel', NULL, NULL, NULL, 'Painel'), ('1825', 'configurações_multilíngues', NULL, NULL, NULL, 'Configurações multilíngues'), ('1826', 'language_file_import_successfully', 'Language file import successfully', NULL, NULL, 'Importação de arquivo de idioma com sucesso'), ('1827', 'configurações_de_sistema', NULL, NULL, NULL, 'Configurações de sistema'), ('1828', 'academia_webbyservices', NULL, NULL, 'Academia webbyservices', 'Academia Webbyservices'), ('1829', 'gerenciador_de_complementos', NULL, NULL, NULL, 'Gerenciador de complementos'), ('1830', 'adicionar_complemento', NULL, NULL, NULL, 'Adicionar complemento'), ('1831', 'enter_your_valid_purchase_code', NULL, NULL, NULL, 'Insira seu código de compra válido'), ('1832', 'adicionar_atualização', NULL, NULL, NULL, 'Adicionar atualização'), ('1833', 'configurações_de_front-end', NULL, NULL, NULL, 'Configurações de front-end'), ('1834', 'configurações_de_conteúdo_de_gotejamento', NULL, NULL, NULL, 'Configurações de conteúdo de gotejamento'), ('1835', 'configurações_de_certificado', NULL, NULL, NULL, 'Configurações de certificado'), ('1836', 'certificate_template_text', NULL, NULL, NULL, 'Certificate template text'), ('1837', 'and', NULL, NULL, NULL, 'E'), ('1838', 'represents_student_name_and_course_title_on_the_certificate', NULL, NULL, NULL, 'Representa o nome do aluno e o título do curso no certificado'), ('1839', 'certificate_template', NULL, NULL, NULL, 'Modelo de certificado'), ('1840', 'make_sure_that_template_size_is_less_than', NULL, NULL, NULL, 'Certifique-se de que o tamanho do modelo seja menor que'), ('1841', 'certificate_text_position', NULL, NULL, NULL, 'Posição do texto do certificado'), ('1842', 'you_must_update_the_text_position_after_updating_the_certificate_template_text', NULL, NULL, NULL, 'Você deve atualizar a posição do texto após atualizar o texto do modelo de certificado'), ('1843', 'edit_text_position', NULL, NULL, NULL, 'Editar posição do texto'), ('1844', 'bigbluebutton_live_class_settings', NULL, NULL, NULL, 'Configurações de aula ao vivo do Bigbluebutton'), ('1845', 'bigbluebutton_endpoint', NULL, NULL, NULL, 'Ponto de extremidade Bigbluebutton'), ('1846', 'bigbluebutton_shared_secret_or_salt', NULL, NULL, NULL, 'Bigbluebutton compartilhou segredo ou salt'), ('1847', 'configurações_de_pagamento', NULL, NULL, NULL, 'Configurações de pagamento'), ('1848', 'payment_settings_updated_successfully', NULL, NULL, NULL, 'Configurações de pagamento atualizadas com sucesso'), ('1849', 'configurações_de_notificação', NULL, NULL, NULL, 'Configurações de notificação'), ('1850', 'login_social', NULL, NULL, NULL, 'Login social'), ('1851', 'páginas_personalizadas', NULL, NULL, NULL, 'Páginas personalizadas'), ('1852', 'centro_de_dados', NULL, NULL, NULL, 'Centro de dados'), ('1853', 'sobre', NULL, NULL, NULL, 'Sobre'), ('1854', 'invalid_purchase_code', NULL, NULL, NULL, 'Código de compra inválido'), ('1855', 'gerenciar_perfil', NULL, NULL, NULL, 'Gerenciar perfil'), ('1856', 'contato', NULL, NULL, NULL, 'Contato'), ('1857', 'complementos_disponíveis', NULL, NULL, NULL, 'Complementos disponíveis'), ('1858', 'gerenciar_pacote_de_cursos', NULL, NULL, NULL, 'Gerenciar pacote de cursos'), ('1859', 'relatório_de_assinatura', NULL, NULL, NULL, 'Relatório de assinatura'), ('1860', 'no_addon_found', NULL, NULL, NULL, 'Nenhum complemento encontrado'), ('1861', 'meeting_sdk_configuration', NULL, NULL, NULL, 'Configuração do SDK de reunião'), ('1862', 'how_to_create_zoom_meeting_sdk?', NULL, NULL, NULL, 'Como criar SDK de reunião com zoom?'), ('1863', 'academia_curaquantica13', NULL, NULL, NULL, 'Academia curaquantica13'), ('1864', 'password_updated', NULL, NULL, NULL, 'Senha atualizada'), ('1865', 'comece_a_aprender_com_a_melhor_plataforma', NULL, NULL, NULL, 'Comece a aprender com a melhor plataforma'), ('1866', 'estude_em_qualquer_lugar_a_qualquer_hora._explore_todos_os_cursos_pelo_menor_preço_de_todos_os_tempos!', 'Estude em qualquer lugar a qualquer hora. explore todos os cursos pelo menor preço de todos os tempos!', NULL, NULL, 'Estude em qualquer lugar a qualquer hora. explore todos os cursos pelo menor preço de todos os tempos!'), ('1867', 'drip_content_settings_updated_successfully', NULL, NULL, NULL, 'Configurações de conteúdo de gotejamento atualizadas com sucesso'), ('1868', 'adicionar_curso', NULL, NULL, NULL, 'Adicionar curso'), ('1869', 'categorias', NULL, NULL, NULL, 'Categorias'), ('1870', 'adicionar_categoria', NULL, NULL, NULL, 'Adicionar categoria'), ('1871', 'category_add_form', NULL, NULL, NULL, ' Formulário de adição de categoria'), ('1872', 'category_code', NULL, NULL, NULL, 'Código da categoria'), ('1873', 'editar_categoria', NULL, NULL, NULL, 'Editar categoria'), ('1874', 'cursos_ativos', NULL, NULL, NULL, 'Cursos ativos'), ('1875', 'category_name_already_exists', NULL, NULL, NULL, ' O nome da categoria já existe'), ('1876', 'instrutor_adicionado', NULL, NULL, NULL, 'Instrutor adicionado'), ('1877', 'instrutor', NULL, NULL, NULL, 'Instrutor'), ('1878', 'editar_curso', NULL, NULL, NULL, 'Editar curso'), ('1879', 'section_has_been_added_successfully', NULL, NULL, NULL, ' A seção foi adicionada com sucesso'), ('1880', 'audio_file', NULL, NULL, NULL, 'Arquivo de áudio'), ('1881', 'wasabi_storage_video', NULL, NULL, NULL, ' Vídeo de armazenamento Wasabi'), ('1882', 'live_class_is_not_scheduled_yet', NULL, NULL, NULL, ' Aula ao vivo ainda não está agendada'), ('1883', 'enter_google_drive_video_url', NULL, NULL, NULL, 'Insira o URL do vídeo do Google Drive'), ('1884', 'document_type', NULL, NULL, NULL, 'Tipo de documento'), ('1885', 'select_type_of_document', NULL, NULL, NULL, 'Selecione o tipo de documento'), ('1886', 'text_file', NULL, NULL, NULL, 'Arquivo de texto'), ('1887', 'pdf_file', NULL, NULL, NULL, 'Arquivo PDF'), ('1888', 'attachment', NULL, NULL, NULL, ' Anexo'), ('1889', 'iframe_source', NULL, NULL, NULL, 'Fonte do iframe'), ('1890', 'provide_the_source_only', NULL, NULL, NULL, 'Forneça apenas a fonte'), ('1891', 'pagamento_do_instrutor', NULL, NULL, NULL, 'Pagamento do instrutor'), ('1892', 'configurações_do_instrutor', NULL, NULL, NULL, 'Configurações do instrutor'), ('1893', 'instructor_commission_settings', NULL, NULL, NULL, 'Configurações de comissão do instrutor'), ('1894', 'aplicativo_para_instrutor', NULL, NULL, NULL, 'Aplicativo para instrutor'), ('1895', 'categorias_de_tutor', NULL, NULL, NULL, 'Categorias de tutor'), ('1896', 'desprogramação_neurobiológica', NULL, NULL, NULL, 'Desprogramação neurobiológica'), ('1897', 'invalid_lesson_url_and_duration', NULL, NULL, NULL, ' URL e duração da aula inválidos'), ('1898', 'access_denied', NULL, NULL, NULL, 'Acesso negado'), ('1899', 'sort_lessons_of', NULL, NULL, NULL, 'Classificar lições de'), ('1900', 'lessons_have_been_sorted', NULL, NULL, NULL, 'As aulas foram classificadas'), ('1901', 'enter_your_html5_video_url', NULL, NULL, NULL, 'Insira o URL do seu vídeo HTML5'), ('1902', 'audio', NULL, NULL, NULL, 'Áudio'), ('1903', 'months', 'Months', NULL, NULL, ' Meses'), ('1904', 'course_status_updated', NULL, NULL, NULL, 'Status do curso atualizado'), ('1905', 'mail_subject', NULL, NULL, NULL, 'Assunto da mensagem'), ('1906', 'mail_body', NULL, NULL, NULL, 'Corpo da mensagem'), ('1907', 'send_mail', NULL, NULL, NULL, 'Enviar mensagem'), ('1908', 'atraindo_abundância', 'Atraindo abundância', NULL, NULL, 'Atraindo abundância'), ('1909', 'institucional_curaquantica13', 'Institucional curaquantica13', NULL, NULL, 'Institucional curaquantica13'), ('1910', 'disabled', NULL, NULL, NULL, 'Desabilitado(a)'), ('1911', 'certificate_template_has_been_updated', NULL, NULL, NULL, ' O modelo de certificado foi atualizado'), ('1912', 'configurações_de_armazenamento_wasabi', NULL, NULL, NULL, 'Configurações de armazenamento wasabi'), ('1913', 'addon_is_deactivated_successfully', NULL, NULL, NULL, ' Addon foi desativado com sucesso'), ('1914', 'configurações_de_aula_ao_vivo_do_bbb', NULL, NULL, NULL, 'Configurações de aula ao vivo do bbb'), ('1915', 'course_noticeboard', NULL, NULL, NULL, 'Quadro de avisos do curso'), ('1916', 'notify_to_enrolled_students_when_announcements_are_created_by_the_instructor_for_a_particular_course._', NULL, NULL, NULL, 'Notifique os alunos matriculados quando anúncios forem criados pelo instrutor para um determinado curso.'), ('1917', 'smtp_settings_updated_successfully', NULL, NULL, NULL, 'Configurações de SMTP atualizadas com sucesso'), ('1918', 'configurações_de_tema', NULL, NULL, NULL, 'Configurações de tema'), ('1919', 'administradores', NULL, NULL, NULL, 'Administradores'), ('1920', 'instructor_settings_updated', NULL, NULL, NULL, 'Configurações do instrutor atualizadas'), ('1921', 'estudante', NULL, NULL, NULL, 'Estudante'), ('1922', 'student_add', NULL, NULL, NULL, 'Adicionar aluno'), ('1923', 'student_add_form', NULL, NULL, NULL, 'Formulário de adição de aluno'), ('1924', 'sslcommerz', NULL, NULL, NULL, 'Sslcommerz'), ('1925', 'solicitação_de_pagamento_aceita', NULL, NULL, NULL, 'Solicitação de pagamento aceita'), ('1926', 'solicitação_de_pagamento_suspensa', NULL, NULL, NULL, 'Solicitação de pagamento suspensa'), ('1927', 'configurações_de_pagamento_off-line', NULL, NULL, NULL, 'Configurações de pagamento off-line'), ('1928', 'mensagens_privadas', NULL, NULL, NULL, 'Mensagens privadas'), ('1929', 'boletins_informativos', NULL, NULL, NULL, 'Boletins informativos'), ('1930', 'create_cronjob_file', NULL, NULL, NULL, 'Criar arquivo cronjob'), ('1931', 'usuário_inscrito', NULL, NULL, NULL, 'Usuário inscrito'), ('1932', 'configurações_do_blog', NULL, NULL, NULL, 'Configurações do blog'), ('1933', 'theme_removed_successfully', NULL, NULL, NULL, 'Tema removido com sucesso'), ('1934', 'upload_theme_file', NULL, NULL, NULL, 'Carregar arquivo de tema'), ('1935', 'install_theme', NULL, NULL, NULL, 'Instalar tema'), ('1936', 'comece_a_aprender_com_a_melhor_plataforma_educacional_para_terapias_energéticas_', NULL, NULL, NULL, 'Comece a aprender com a melhor plataforma educacional para terapias energéticas '), ('1937', 'comece_aprendendo_agora_na_melhor_plataforma_para_terapias_energéticas!', 'Comece aprendendo agora na melhor plataforma para terapias energéticas!', NULL, NULL, 'Comece aprendendo agora na melhor plataforma para terapias energéticas!'), ('1938', 'portuguese', NULL, NULL, NULL, 'Portuguese'), ('1939', '_lista_de_bootcamp', NULL, NULL, NULL, ' Lista de bootcamp'), ('1940', 'tickets', NULL, NULL, NULL, 'Tickets'), ('1941', 'opened', NULL, NULL, NULL, 'Aberto'), ('1942', 'closed', NULL, NULL, NULL, 'Fechado'), ('1943', 'ticket_id', NULL, NULL, NULL, 'ID do Ticket'), ('1944', 'priority', NULL, NULL, NULL, 'Prioridade'), ('1945', 'openai_settings', NULL, NULL, NULL, 'Configurações Openai'), ('1946', 'manage_your_open_ai_settings', NULL, NULL, NULL, 'Gerencie suas configurações de IA'), ('1947', 'select_ai_model', NULL, NULL, NULL, 'Selecione o modelo de IA'), ('1948', 'max_tokens', NULL, NULL, NULL, 'Maximo de tokens'), ('1949', 'number_of_image_creation', NULL, NULL, NULL, 'Número de criação de imagem'), ('1950', 'configurações_openai', NULL, NULL, NULL, 'Configurações openai'), ('1951', 'formulário_de_bootcamp', NULL, NULL, NULL, 'Formulário de bootcamp'), ('1952', 'categoria', NULL, NULL, NULL, 'Categoria'), ('1953', 'relatório_de_pagamento', NULL, NULL, NULL, 'Relatório de pagamento'), ('1954', 'support_macros', NULL, NULL, NULL, ' Macros de suporte'), ('1955', 'macros', NULL, NULL, NULL, 'Macros'), ('1956', 'add_new_macro', NULL, NULL, NULL, 'Adicionar nova macro'), ('1957', 'invalid_email_address', 'Invalid email address', NULL, NULL, ' Endereço de e-mail inválido'), ('1958', 'bootcamp_not_found', NULL, NULL, NULL, ' Bootcamp não encontrado'), ('1959', 'your_images', 'Your images', NULL, NULL, 'Suas imagens'), ('1960', 'edição_do_instrutor', NULL, NULL, NULL, 'Edição do instrutor'), ('1961', 'adicionar_aluno', NULL, NULL, NULL, 'Adicionar aluno'), ('1962', 'student_edit', NULL, NULL, NULL, 'Edição do aluno'), ('1963', 'student_edit_form', NULL, NULL, NULL, 'Formulário de edição do aluno'), ('1964', 'inscrição_no_curso', NULL, NULL, NULL, 'Inscrição no curso'), ('1965', 'histórico_de_inscrições', NULL, NULL, NULL, 'Histórico de inscrições'), ('1966', 'expiration_on', NULL, NULL, NULL, 'Expiração em'), ('1967', 'your_servers_file_upload_limit_is_2mb', NULL, NULL, NULL, 'O limite de upload de arquivos do seu servidor é de 2 MB'), ('1968', 'this_lecture_is_available_exclusively_as_of_premium_part._to_gain_access,_please_purchase_the_course', NULL, NULL, NULL, 'Esta palestra está disponível exclusivamente na parte premium. para ter acesso, adquira o curso'), ('1969', 'jornada_atraindo_o_amor', NULL, NULL, NULL, 'Jornada atraindo o amor'), ('1970', 'you_do_not_have_permission_to_access_this_course', NULL, NULL, NULL, 'Você não tem permissão para acessar este curso'), ('1971', 'your_registration_has_been_successfully_done', NULL, NULL, NULL, ' Seu cadastro foi realizado com sucesso'), ('1972', 'please_check_your_mail_inbox_to_verify_your_email_address', NULL, NULL, NULL, 'Verifique sua caixa de entrada de e-mail para verificar seu endereço de e-mail'), ('1973', 'verification_code', NULL, NULL, NULL, 'Código de verificação'), ('1974', 'enter_your_verification_code_here', NULL, NULL, NULL, 'Insira seu código de verificação aqui'), ('1975', 'enter_your_verification_code', NULL, NULL, NULL, 'Digite seu código de verificação'), ('1976', 'mail_successfully_sent_to_your_inbox', NULL, NULL, NULL, ' Email enviado com sucesso para sua caixa de entrada'), ('1977', 'your_email_address_has_been_successfully_verified', NULL, NULL, NULL, ' Seu endereço de e-mail foi verificado com sucesso'), ('1978', 'compare_with_3_courses', NULL, NULL, NULL, ' Compare com 3 cursos'), ('1979', 'email_template_updated_successfully', NULL, NULL, NULL, 'Modelo de e-mail atualizado com sucesso'), ('1980', 'section_has_been_deleted_successfully', NULL, NULL, NULL, 'A seção foi excluída com sucesso'), ('1981', 'curando_minhas_feridas_emocionais', NULL, NULL, NULL, 'Curando minhas feridas emocionais'), ('1982', 'student_has_been_enrolled_to_that_course', NULL, NULL, NULL, 'O aluno foi matriculado nesse curso'), ('1983', 'unverified', NULL, NULL, NULL, ' Não verificado'), ('1984', 'you_have_already_registered', NULL, NULL, NULL, 'Você já se registrou'), ('1985', 'mentoria_i.a_e_espiritualidade', NULL, NULL, NULL, 'Mentoria i.a e espiritualidade'), ('1986', 'successfully_enabled', NULL, NULL, NULL, 'Ativado com sucesso'), ('1987', 'frequently_asked_question', NULL, NULL, NULL, 'Pergunta frequente'), ('1988', 'account_disable', NULL, NULL, NULL, 'Desativar conta'), ('1989', 'found_number_of_bundles', 'Found number of bundles', NULL, NULL, 'Número encontrado de pacotes'), ('1990', 'your_sign_up_form_is_empty', NULL, NULL, NULL, 'Seu formulário de inscrição está vazio'), ('1991', 'fill_out_the_form_with_your_valid_data', NULL, NULL, NULL, 'Preencha o formulário com seus dados válidos'), ('1992', 'check_your_inbox_for_the_request', NULL, NULL, NULL, 'Verifique sua caixa de entrada para a solicitação'), ('1993', 'solicitação_de_pagamento_pendente', NULL, NULL, NULL, 'Solicitação de pagamento pendente'), ('1994', 'for_more_details_check_out_our', NULL, NULL, NULL, 'Para mais detalhes confira nosso'), ('1995', 'website', NULL, NULL, NULL, 'Website'), ('1996', 'compare_with_0_courses', NULL, NULL, NULL, 'Comparar com 0 cursos'), ('1997', 'compare_with_0.5_courses', NULL, NULL, NULL, 'Compare com 0,5 cursos'), ('1998', 'search_results', NULL, NULL, NULL, 'Resultados da pesquisa'), ('1999', 'invalid_attachment', NULL, NULL, NULL, 'Anexo inválido'), ('2000', 'zoom_nas_configurações_da_aula_ao_vivo', NULL, NULL, NULL, 'Zoom nas configurações da aula ao vivo'), ('2001', 'assignment_added_successfully', NULL, NULL, NULL, 'Tarefa adicionada com sucesso'), ('2002', 'edit_assignment', NULL, NULL, NULL, ' Editar tarefa'), ('2003', 'mark_as_draft', NULL, NULL, NULL, 'Marcar como rascunho'), ('2004', 'view_submission', NULL, NULL, NULL, ' Ver envio'), ('2005', 'deadline:_', NULL, NULL, NULL, 'Prazo final'), ('2006', 'submit_assignment', NULL, NULL, NULL, 'Enviar tarefa'), ('2007', 'deadline:', NULL, NULL, NULL, 'Prazo final'), ('2008', 'status:_', NULL, NULL, NULL, 'Status'), ('2009', 'total_marks:', NULL, NULL, NULL, 'Total de marcas'), ('2010', '1', NULL, NULL, NULL, '1'), ('2011', 'submit_assignment_form', NULL, NULL, NULL, ' Enviar formulário de tarefa'), ('2012', 'back_to_assignment_list', NULL, NULL, NULL, 'Voltar à lista de tarefas'), ('2013', 'questions:', NULL, NULL, NULL, 'Questões'), ('2014', 'upload_file', NULL, NULL, NULL, 'Carregar arquivo'), ('2015', 'enter_your_private_note', NULL, NULL, NULL, 'Digite sua nota privada'), ('2016', 'assignment_deleted_successfully', NULL, NULL, NULL, 'Tarefa excluída com sucesso'), ('2017', 'img', NULL, NULL, NULL, 'Img'), ('2018', 'notice_added_successfully', NULL, NULL, NULL, 'Aviso adicionado com sucesso'), ('2019', 'update_notice', NULL, NULL, NULL, 'Aviso de atualização'), ('2020', 'notice_deleted_successfully', NULL, NULL, NULL, ' Aviso excluído com sucesso'), ('2021', 'please_select_valid_audio_file', NULL, NULL, NULL, 'Selecione um arquivo de áudio válido'), ('2022', 'despertando_o_meu_poder_de_auto_cura', NULL, NULL, NULL, 'Despertando o meu poder de auto cura'), ('2023', 'teste_de_edição', NULL, NULL, NULL, 'Teste de edição'), ('2024', 'successfully_enrolled', NULL, NULL, NULL, 'Inscrito com sucesso'), ('2025', 'editar_bootcamp', NULL, NULL, NULL, 'Editar bootcamp'), ('2026', 'start', NULL, NULL, NULL, ' Começar'), ('2027', 'modules', NULL, NULL, NULL, 'Módulos'), ('2028', 'bootcamp_description', NULL, NULL, NULL, 'Descrição do bootcamp'), ('2029', 'in_this_course_you_get', NULL, NULL, NULL, 'Neste curso você obtém'), ('2030', 'class_record', NULL, NULL, NULL, 'Registro de aula'), ('2031', 'no_class_in_this_module.', NULL, NULL, NULL, 'Nenhuma aula neste módulo.'), ('2032', 'module_deleted.', NULL, NULL, NULL, 'Módulo excluído.'), ('2033', 'data_already_exists.', NULL, NULL, NULL, 'Os dados já existem.'), ('2034', 'data_exists.', NULL, NULL, NULL, 'Os dados existem.'), ('2035', 'bootcamp_purchased', NULL, NULL, NULL, ' Bootcamp adquirido'), ('2036', 'no_class_is_available', NULL, NULL, NULL, ' Nenhuma aula está disponível'), ('2037', 'payment_invoice', NULL, NULL, NULL, ' Fatura de pagamento'), ('2038', 'your_custom_codes_updated_successfully', NULL, NULL, NULL, 'Your custom codes updated successfully'), ('2039', 'it_looks_like_you_are_skipping_a_version', NULL, NULL, NULL, 'It looks like you are skipping a version'), ('2040', 'please_update_version', NULL, NULL, NULL, 'Please update version'), ('2041', 'first', NULL, NULL, NULL, 'First'), ('2042', 'duplicate_this_course', NULL, NULL, NULL, 'Duplicate this course'), ('2043', 'publish_date', NULL, NULL, NULL, 'Publish date'), ('2044', 'enter_publish_date', NULL, NULL, NULL, 'Enter publish date'), ('2045', 'bootcamp_deleted.', NULL, NULL, NULL, 'Bootcamp deleted.'), ('2046', 'well_done', NULL, NULL, NULL, 'Well done'), ('2047', 'you_are_now_eligible_to_download_the_course_completion_certificate', NULL, NULL, NULL, 'You are now eligible to download the course completion certificate'), ('2048', 'get_certificate', NULL, NULL, NULL, 'Get certificate'), ('2049', 'attached_files', NULL, NULL, NULL, 'Attached files');
DROP TABLE IF EXISTS `lesson`;
CREATE TABLE `lesson` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `duration` varchar(255) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `video_type` varchar(255) DEFAULT NULL,
  `cloud_video_id` int(20) DEFAULT NULL,
  `video_url` varchar(255) DEFAULT NULL,
  `audio_url` varchar(400) DEFAULT NULL,
  `date_added` int(11) DEFAULT NULL,
  `last_modified` int(11) DEFAULT NULL,
  `lesson_type` varchar(255) DEFAULT NULL,
  `attachment` longtext DEFAULT NULL,
  `attachment_type` varchar(255) DEFAULT NULL,
  `caption` varchar(255) DEFAULT NULL,
  `summary` longtext DEFAULT NULL,
  `is_free` int(11) NOT NULL DEFAULT 0,
  `order` int(11) NOT NULL DEFAULT 0,
  `quiz_attempt` int(11) NOT NULL DEFAULT 0,
  `video_type_for_mobile_application` varchar(255) DEFAULT NULL,
  `video_url_for_mobile_application` varchar(255) DEFAULT NULL,
  `duration_for_mobile_application` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `lesson` (`id`, `title`, `duration`, `course_id`, `section_id`, `video_type`, `cloud_video_id`, `video_url`, `audio_url`, `date_added`, `last_modified`, `lesson_type`, `attachment`, `attachment_type`, `caption`, `summary`, `is_free`, `order`, `quiz_attempt`, `video_type_for_mobile_application`, `video_url_for_mobile_application`, `duration_for_mobile_application`) VALUES ('2', 'Sejam Muito Bem-vindos!! (Livre)', '01:10:00', '1', '1', 'youtube', NULL, 'https://youtu.be/jtUySn91c2U', NULL, '1717455600', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('8', 'Encontro Google Meet', NULL, '1', '3', NULL, NULL, NULL, NULL, '1717542000', '1717542000', 'text', '&lt;br&gt;', 'description', NULL, '&lt;h1 segoe=&quot;&quot; ui&quot;,=&quot;&quot; arial;=&quot;&quot; text-align:=&quot;&quot; center;&quot;=&quot;&quot; style=&quot;margin-top: 0px; margin-bottom: 0.5rem; line-height: 1.2; font-size: 2.5rem;&quot;&gt;&lt;a href=&quot;https://meet.google.com/hke-umcs-sye&quot; target=&quot;_blank&quot; style=&quot;color: rgb(0, 86, 179); text-decoration-line: underline; font-weight: 500; transition: all 0.5s ease 0s;&quot;&gt;&lt;span style=&quot;font-family: Arial;&quot;&gt;&lt;font color=&quot;#000000&quot;&gt;&lt;br&gt;&lt;/font&gt;&lt;/span&gt;&lt;/a&gt;&lt;/h1&gt;&lt;h3 style=&quot;margin-top: 0px; margin-bottom: 0.5rem; line-height: 1.2; font-size: 2.5rem;&quot;&gt;&lt;a href=&quot;https://meet.google.com/hke-umcs-sye&quot; target=&quot;_blank&quot; style=&quot;color: rgb(0, 86, 179); text-decoration-line: underline; font-weight: 500; transition: all 0.5s ease 0s;&quot;&gt;&lt;span style=&quot;font-family: Arial;&quot;&gt;&lt;font color=&quot;#000000&quot;&gt;CLIQUE AQUI PARA ENTRAR NA SALA&lt;/font&gt;&lt;/span&gt;&lt;/a&gt;&lt;/h3&gt;', '0', '0', '0', NULL, NULL, NULL), ('9', 'Grupo de Alunos Telegram', NULL, '1', '4', NULL, NULL, NULL, NULL, '1717542000', '1717542000', 'text', '&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;/p&gt;', 'description', NULL, '&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;b&gt;Grupo Telegram Turma 2024.&lt;/b&gt;&lt;/blockquote&gt;&lt;p&gt;&lt;b&gt;Facilitadora/Tutora: Diana Lira&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;ul&gt;&lt;li&gt;&lt;a href=&quot;https://t.me/+I3KLFmHKvXA3MTA0&quot; target=&quot;_blank&quot;&gt;https://t.me/+I3KLFmHKvXA3MTA0&lt;/a&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;b&gt;Grupo de Alunos DNB mundial no&amp;nbsp; telegram para trocas e dúvidas.&lt;/b&gt;&lt;/blockquote&gt;&lt;ul&gt;&lt;li&gt;&lt;a href=&quot;https://t.me/joinchat/VzYOobT3_5SMhu71&quot; target=&quot;_blank&quot;&gt;https://t.me/joinchat/VzYOobT3_5SMhu71&lt;/a&gt;&lt;/li&gt;&lt;/ul&gt;', '0', '0', '0', NULL, NULL, NULL), ('10', 'O Que é a DNB? Como surgiu?', '01:27:40', '1', '5', 'youtube', NULL, 'https://youtu.be/XBjsFllxwkY', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('11', 'Neurónios e Caminhos neurais', '00:42:45', '1', '5', 'youtube', NULL, 'https://youtu.be/IHtUdqg3Rn8', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('12', 'DNB Pet', '00:03:00', '1', '6', 'youtube', NULL, 'https://youtu.be/Xo9DxT25s5A', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('13', 'DNB Pet - Parte 2', '01:40:00', '1', '6', NULL, NULL, 'https://youtu.be/z93rtwn-ZsQ', NULL, '1717542000', '1717542000', 'video', '', 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('14', 'Formas de aplicação DNB', '00:44:50', '1', '6', 'youtube', NULL, 'https://youtu.be/Y8evSYk5OSU', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('15', 'Iniciação a energia DNB', '00:08:49', '1', '6', 'youtube', NULL, 'https://youtu.be/S-SweeHti84', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('16', 'Passo a passo para aplicar a energia da DNB', '00:15:39', '1', '6', NULL, NULL, 'https://youtu.be/G_4pVolTcWg', NULL, '1717542000', '1717542000', 'video', '', 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('22', 'Avisos', NULL, '1', '8', NULL, NULL, NULL, NULL, '1717542000', NULL, 'text', '', 'description', NULL, '&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;1) Cancelamento/Alteração Classe + Participação:&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;​A Facilitadora Diana Lira, reserva-se ao direito de cancelar unilateralmente o evento caso as inscrições não alcancem o número mínimo de pessoas inscritas.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;A comunicação do cancelamento deverá ser feita diretamente a pessoa do CONTRATANTE até 24 horas antes do evento previsto, sendo resguardado o direito ao reembolso total da inscrição.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;color: rgb(0, 0, 0);&quot;&gt;2) Direito de Imagem:&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;​Autorizo a facilitadora, Diana Lira, utilizar minha imagem contida em fotos e/ou filmagens e áudio, a serem coletadas durante o referido curso, com o meu prévio consentimento, para ilustrar filmes, vídeos, clips, peças publicitárias e promocionais, destinadas a divulgar produtos, nomes, marcas, serviços ou qualquer outra denominação ou atividade ligada às marcas Os Meninos da Consciência e a nós. A presente autorização, que se faz firme e valiosa, é concedida a título não oneroso, sem qualquer limitação quanto ao tempo, território e forma de divulgação, e será respeitada por nós, meus herdeiros e sucessores.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;3)Termo de Responsabilidade e Ciência sobre o Não Compartilhamento de Dados&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;​Caro ALUNO (A), seja bem-vindo (a)!&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;Este “Termo de Responsabilidade” foi firmado para que Vossa Senhoria esteja ciente da PROIBIÇÃO de divulgação e compartilhamento não autorizado de quaisquer dos conteúdos, materiais e vídeo aula disponibilizados neste curso.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;Fica expressamente PROIBIDO, a criação/registro e uso da marca e material deste curso sem a autorização expressa do criador da ferramenta.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;Fica PROIBIDO ainda, a tradução dos conteúdos, materiais e vídeo aula disponibilizados neste curso.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;Estando Vossa Senhoria advertido (a), que o descumprimento de quaisquer das ordens acima elucidadas, lhe acarretará a responsabilização civil e penal pelas perdas, danos diretos e indiretos e lucro cessante, porventura, causados ao criador da ferramenta.&lt;/span&gt;&lt;/p&gt;', '0', '0', '0', NULL, NULL, NULL), ('23', 'Depoimentos', '00:00:55', '1', '9', 'youtube', NULL, 'https://youtu.be/QszGddlyvCI', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('24', 'Criando o meu negócio com a DNB', '00:01:16', '1', '10', 'youtube', NULL, 'https://youtu.be/qCzfyjB7_bw', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('25', 'Passo 1: Começa por Aqui...', '00:03:53', '1', '10', NULL, NULL, 'https://youtu.be/87ELz9XGhFA', NULL, '1717542000', '1717542000', 'video', '', 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('26', 'Passo 2: Redes Sociais', '00:13:17', '1', '10', 'youtube', NULL, 'https://youtu.be/H3yQ9xanZ8E', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('27', 'Passo 3: Definir Objetivos', '00:08:42', '1', '10', 'youtube', NULL, 'https://youtu.be/zMRuwqqZTEQ', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('28', 'Passo 4: Fazer, Fazer, e Fazerrr...', '00:06:46', '1', '10', 'youtube', NULL, 'https://youtu.be/HjHSQYkN0U4', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('34', 'Apostila DNB Pet e Pessoas', NULL, '1', '2', NULL, NULL, NULL, NULL, '1717542000', '1717542000', 'text', '', 'description', NULL, '&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;p&gt;&lt;b&gt;OBS....&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;br&gt;Visualize ou realize o download do arquivo clicando &lt;a href=&quot;https://drive.google.com/file/d/1fi3f0CAisGnoA2FGpdIrAQtGh52eKXDC/view?usp=drive_link&quot; target=&quot;_blank&quot;&gt;&lt;b&gt;AQUI&lt;/b&gt;&lt;/a&gt;.&lt;/p&gt;&lt;/blockquote&gt;', '0', '1', '0', NULL, NULL, NULL), ('35', 'Pontos Importantes', '00:03:42', '1', '2', 'youtube', NULL, 'https://youtu.be/lzK03HBUgM0', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '2', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('36', 'Instruções sobre a Plataforma do curso', '00:03:34', '1', '2', 'youtube', NULL, 'https://youtu.be/aKPTkUyY-SE', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '3', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('37', 'Manual do praticante', NULL, '1', '7', NULL, NULL, NULL, NULL, '1717542000', NULL, 'text', '', 'description', NULL, '&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;p&gt;&lt;b&gt;OBS...&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;br&gt;Visualize ou realize o download do arquivo clicando &lt;b&gt;&lt;a href=&quot;https://drive.google.com/file/d/1eLKabsvInPby0TaFtYSVIpmulKx-BNZT/view?usp=drive_link&quot; target=&quot;_blank&quot;&gt;AQUI&lt;/a&gt;.&lt;/b&gt;&lt;/p&gt;&lt;/blockquote&gt;', '0', '0', '0', NULL, NULL, NULL), ('38', 'Materiais gráficos - Portugues', NULL, '1', '7', NULL, NULL, NULL, NULL, '1717542000', NULL, 'text', '', 'description', NULL, '&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;p&gt;&lt;b&gt;OBS...&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;br&gt;Visualize ou realize o download do arquivo clicando &lt;b&gt;&lt;a href=&quot;https://drive.google.com/drive/folders/1eE8Dp-6useV-GVPlVF4-SUesEJJOPCTo?usp=drive_link&quot; target=&quot;_blank&quot;&gt;AQUI&lt;/a&gt;.&lt;/b&gt;&lt;/p&gt;&lt;/blockquote&gt;', '0', '0', '0', NULL, NULL, NULL), ('39', 'Imagens em JPG', NULL, '1', '7', NULL, NULL, NULL, NULL, '1717542000', NULL, 'text', '', 'description', NULL, '&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;p&gt;&lt;b&gt;OBS...&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;br&gt;Visualize ou realize o download do arquivo clicando &lt;b&gt;&lt;a href=&quot;https://drive.google.com/drive/folders/1Mhiw0H2YSFTWsv8hW82P9z9SzG3q6yde?usp=drive_link&quot; target=&quot;_blank&quot;&gt;AQUI&lt;/a&gt;.&lt;/b&gt;&lt;/p&gt;&lt;/blockquote&gt;', '0', '0', '0', NULL, NULL, NULL), ('40', 'Materiais gráficos para post', NULL, '1', '7', NULL, NULL, NULL, NULL, '1717542000', NULL, 'text', '', 'description', NULL, '&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;p&gt;&lt;b&gt;OBS...&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;br&gt;Visualize ou realize o download do arquivo clicando &lt;b&gt;&lt;a href=&quot;https://drive.google.com/drive/folders/19Kiu0AN_a-rTmrx4Ru1sCvZx1oelX5Jf?usp=drive_link&quot; target=&quot;_blank&quot;&gt;AQUI&lt;/a&gt;.&lt;/b&gt;&lt;/p&gt;&lt;/blockquote&gt;', '0', '0', '0', NULL, NULL, NULL), ('41', 'Artes Gráficas', NULL, '1', '7', NULL, NULL, NULL, NULL, '1717542000', NULL, 'text', '', 'description', NULL, '&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;p&gt;&lt;b&gt;OBS...&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;br&gt;Visualize ou realize o download do arquivo clicando &lt;b&gt;&lt;a href=&quot;https://drive.google.com/drive/folders/1QQLpEdrYtdcY2mL9cl0qd2QOewb7_zGx?usp=drive_link&quot; target=&quot;_blank&quot;&gt;AQUI&lt;/a&gt;.&lt;/b&gt;&lt;/p&gt;&lt;/blockquote&gt;', '0', '0', '0', NULL, NULL, NULL), ('42', 'Passo a passo para criar uma conta instagram Bussiness', NULL, '1', '10', NULL, NULL, NULL, NULL, '1717542000', NULL, 'text', '', 'description', NULL, '&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;p&gt;&lt;b&gt;OBS...&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;br&gt;Visualize ou realize o download do arquivo clicando &lt;b&gt;&lt;a href=&quot;https://drive.google.com/file/d/1EOVZawRjxvZlcopQlPhLMvWjLizlKnhQ/view?usp=drive_link&quot; target=&quot;_blank&quot;&gt;AQUI&lt;/a&gt;.&lt;/b&gt;&lt;/p&gt;&lt;/blockquote&gt;', '0', '0', '0', NULL, NULL, NULL), ('46', 'Bem-Vindos Despertos!!', '00:02:00', '2', '11', 'youtube', NULL, 'https://youtube.com/shorts/I5YfX7b3niY?feature=share', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '&lt;blockquote class=&quot;blockquote&quot;&gt;A Jornada Atraindo o Amor é uma imersão com o passo a passo\r\npara desbloquear tudo o teu campo energético que te impede de atrair o Amor.\r\nSerão 7 aulas com videos explicativos e sessões audio de Desprogramação\r\nNeurobiológica, para uma transformação profunda dos programas mentais limitando\r\nque te impedem de viver o Amor&lt;br&gt;​&lt;br&gt;&lt;o:p&gt;&amp;nbsp;&lt;br&gt;&lt;/o:p&gt;Dia 1: Abrindo o meu coração para o amor.&lt;br&gt;Dia 2: Libertação de Karmas e Perdão.&lt;br&gt;Dia 3: Desapego, culpa e mágoa.&lt;br&gt;Dia 4: Cortando laços energéticos.&lt;br&gt;Dia 5: Trabalhando a clareza.&lt;br&gt;Dia 6: Vivendo na frequência da Gratidão.&lt;br&gt;Dia 7: Manifestando o Amor.&lt;/blockquote&gt;&lt;p&gt;\r\n\r\n&lt;/p&gt;', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('47', 'O que é a Desprogramação Neurobiológica?', '00:01:25', '2', '13', 'youtube', NULL, 'https://youtu.be/s9xPKh3SYLQ', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('48', 'Impacto da DNB no teu corpo', '00:01:25', '2', '13', 'youtube', NULL, 'https://youtu.be/9FyUpVDXfWU', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('49', 'Abrindo o meu Coração', '00:01:30', '2', '14', 'youtube', NULL, 'https://youtu.be/Cdh3wnwnshU', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('50', 'Sessão DNB para Abrir o Receber', '00:05:00', '2', '14', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/dccd4449fe4230bf94d59a893e3d3f52.mp3', '1717542000', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('51', 'Libertação de Karmas e Perdão', '00:01:28', '2', '15', 'youtube', NULL, 'https://youtu.be/bUveJTquaGw', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('52', 'Sessão DNB libertação de Karmas e Perdão', '00:11:00', '2', '15', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/144451b12f63037f3072f7a5ad9f54c7.mp3', '1717542000', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('53', 'Desapego, Culpa e Mágoas', '00:01:30', '2', '16', 'youtube', NULL, 'https://youtu.be/NzZyDIMXJKs', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('54', 'A Culpa é um desperdiço de energia', '00:01:25', '2', '16', NULL, NULL, 'https://youtu.be/oKcAKGAABmQ', NULL, '1717542000', '1717542000', 'video', '', 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('55', 'Sessão DNB Desapego, Culpa e mágoa', '00:25:00', '2', '16', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/b99f8ccafd156e311b7bc2696722902b.mp3', '1717542000', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('56', 'Corte de Laços energéticos', '00:01:30', '2', '17', 'youtube', NULL, 'https://youtu.be/9gQP4SUMgPM', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('57', 'Sessão DNB para Cortes de Laços Energéticos', '00:12:30', '2', '17', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/f82f0f19f8de49e9fed7296d28a91ca4.mp3', '1717542000', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('58', 'Trabalhando a Clareza', '00:06:15', '2', '18', 'youtube', NULL, 'https://youtu.be/aO2aFsYtB2E', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('59', 'Sessão DNB para Trabalhar a Clareza', '00:12:30', '2', '18', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/6a2a7c2a6a0a0a237d66255467fa7153.mp3', '1717542000', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('60', 'Trabalhando a Gratidão', '00:01:30', '2', '19', 'youtube', NULL, 'https://youtu.be/mjIlwEyvbQQ', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('61', '1 - Lista de Agradecimento', '00:01:30', '2', '19', 'youtube', NULL, 'https://youtu.be/aDuieGpzaT0', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('62', '2 - Atraimos o que somos', '00:01:30', '2', '19', 'youtube', NULL, 'https://youtu.be/0OOPE0ytE5I', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('63', 'Olha para os problemas como oportunidades', '00:01:30', '2', '19', 'youtube', NULL, 'https://youtu.be/VP8oYiSx_40', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('64', 'Sessão Audio Trabalhando a Gratidão', '00:16:15', '2', '19', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/8bb93b346400e0ae73f8160db8db7191.mp3', '1717542000', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('65', 'Manifestando o Amor', '00:01:30', '2', '20', 'youtube', NULL, 'https://youtu.be/j8jvQ2zp-3I', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('66', 'Meditação para Manifestar o Amor', '00:12:15', '2', '20', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/7440bcf3a88f51198bfb36c783393f8c.mp3', '1717542000', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('67', 'Manifestando o Amor', '00:01:30', '2', '20', 'youtube', NULL, 'https://youtu.be/j8jvQ2zp-3I', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('68', 'Avisos importantes', NULL, '2', '21', NULL, NULL, NULL, NULL, '1717542000', NULL, 'text', '', 'description', NULL, '&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;b&gt;Caros Despertos,&lt;/b&gt;&lt;br&gt;&lt;o:p&gt;&amp;nbsp;&lt;br&gt;&lt;/o:p&gt;Este “Termo de Responsabilidade” foi firmado para que Vossa\r\nExcelência esteja ciente da PROIBIÇÃO de divulgação e compartilhamento não\r\nautorizado de quaisquer dos conteúdos, materiais e vídeo aula disponibilizadas\r\nneste curso.&lt;br&gt;&lt;o:p&gt;&amp;nbsp;&lt;br&gt;&lt;/o:p&gt;Fica expressamente PROIBIDO, a criação/registro e uso da\r\nmarca e material deste curso sem a autorização expressa do criador do curso.&lt;br&gt;&lt;o:p&gt;&amp;nbsp;&lt;br&gt;&lt;/o:p&gt;Fica PROIBIDO ainda, a tradução dos conteúdos, materiais e\r\nvídeo aula disponibilizadas neste curso.&lt;br&gt;&lt;o:p&gt;&amp;nbsp;&lt;br&gt;&lt;/o:p&gt;Autorizo a terapeuta Diana Lira, utilizar a minha imagem\r\ncontida em fotos e/ou filmagens e áudio, a serem coletadas durante o referido\r\ncurso, com o meu prévio consentimento, para ilustrar filmes, vídeos, clips,\r\npeças publicitárias e promocionais, destinadas a divulgar produtos, nomes,\r\nmarcas, serviços ou qualquer outra denominação ou atividade ligada a marca Cura\r\nQuântica 13. A presente autorização, que se faz firme e valiosa, é concedida a\r\ntítulo não oneroso, sem qualquer limitação quanto ao tempo, território e forma\r\nde divulgação, e será respeitada por nós, meus herdeiros e sucessores.&lt;br&gt;&lt;o:p&gt;&amp;nbsp;&lt;/o:p&gt;&lt;/blockquote&gt;&lt;p&gt;\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n&lt;/p&gt;&lt;blockquote class=&quot;blockquote&quot;&gt;Estando Vossa Excelência advertido (a), que o descumprimento\r\nde quaisquer das ordens acima elucidadas, lhe acarretará a responsabilização\r\ncivil e penal pelas perdas, danos diretos e indiretos e lucro cessante,\r\nporventura, causados ao criador do curso.&lt;/blockquote&gt;\r\n\r\n&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;p&gt;&lt;b&gt;OBS...&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;br&gt;Visualize ou realize o download do arquivo clicando &lt;b&gt;&lt;a href=&quot;https://drive.google.com/file/d/1Da8fsFpa5EQfQIBiVPP46JbY29fR40s2/view?usp=share_link&quot; target=&quot;_blank&quot;&gt;AQUI&lt;/a&gt;.&lt;/b&gt;&lt;/p&gt;&lt;/blockquote&gt;', '0', '0', '0', NULL, NULL, NULL), ('69', 'Como vai funcionar a Jornada', '00:01:30', '3', '22', 'youtube', NULL, 'https://youtu.be/o4Rn2eON8xo', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('70', 'O que deves fazer durante a Jornada?', '00:01:30', '3', '23', 'youtube', NULL, 'https://youtu.be/8JxS7C3L82g', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('71', 'Como abrir o meu receber?', '00:01:30', '3', '24', 'youtube', NULL, 'https://youtu.be/b6IUsw1wJIA', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('72', '1 - A ESCOLHA', '00:01:05', '3', '24', NULL, NULL, 'https://youtu.be/PbEHejtY6fg', NULL, '1717542000', '1717542000', 'video', '', 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('73', '2 - Trabalhar o MERECIMENTO', '00:01:30', '3', '24', 'youtube', NULL, 'https://youtu.be/OgpU02oItlM', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('74', '3 - CONFIAR', '00:01:30', '3', '24', 'youtube', NULL, 'https://youtu.be/JU8FOTo5nUo', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('75', 'Sessão Audio DNB Abrindo o meu corpo para receber abundância', '00:15:00', '3', '24', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/dea39c71c999b4299e8c2bea2aeccc74.mp3', '1717542000', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('76', 'Cortando laços energéticos que me conectam a falta', '00:01:30', '3', '25', 'youtube', NULL, 'https://youtu.be/uriK1h_TzHE', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('77', 'Meditação angelical para cortar laços energéticos que me conectam a falta', '00:32:15', '3', '25', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/34c2df97c38a9ee92a2d085de7742e42.mp3', '1717542000', '1717542000', 'audio', NULL, 'file', NULL, '&lt;blockquote class=&quot;blockquote&quot;&gt;Meditação com os Anjos da Criação para cortar todos os laços desta vida ou outras vidas que te conectam a escassez.&lt;/blockquote&gt;', '0', '0', '0', NULL, NULL, NULL), ('78', 'Desprogramando padrões familiares de escassez', '00:01:30', '3', '26', 'youtube', NULL, 'https://youtu.be/BjWjAY2hIvY', NULL, '1717542000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('79', 'Sessão Audio DNB desprogramando padrões familiares de escassez', '00:13:00', '3', '26', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/37bd9620086c7d3b7561bf045f16f6de.mp3', '1717542000', NULL, 'audio', NULL, 'file', NULL, '&lt;blockquote class=&quot;blockquote&quot;&gt;Procure uma posição confortável e oiça a sessão de desprogramado neurobiológica varias vezes até sentir necessário&lt;/blockquote&gt;', '0', '0', '0', NULL, NULL, NULL), ('80', 'Desprogramando o medo ao Sucesso', '00:01:30', '3', '27', 'youtube', NULL, 'https://youtu.be/G8zsR-9z_YU', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('81', 'Como manter a energia do Sucesso?', '00:01:30', '3', '27', 'youtube', NULL, 'https://youtu.be/lkF8vJjsAQc', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('82', 'Sessão DNB Desprogramando o medo do Sucesso', '00:17:00', '3', '27', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/b53f50eb1a3cba851350396f170cf230.mp3', '1717628400', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('83', 'Passo a passo para criar abundância', '00:01:30', '3', '28', 'youtube', NULL, 'https://youtu.be/QkKBgwzkmXc', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('84', '1.0 - MENTE. Escolher diferente', '00:01:30', '3', '28', NULL, NULL, 'https://youtu.be/Pe0EVapT2iA', NULL, '1717628400', '1717628400', 'video', '', 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('85', '1.1 - MENTE. Novas redes neurais', '00:01:30', '3', '28', NULL, NULL, 'https://youtu.be/aGmZ2MbCqgA', NULL, '1717628400', '1717628400', 'video', '', 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('86', '1.2 - MENTE. Autoconhecimento', '00:01:30', '3', '28', NULL, NULL, 'https://youtu.be/KQbe9aTeVcM', NULL, '1717628400', '1717628400', 'video', '', 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('87', '2.0 - Trabalhando o CORPO', '00:01:30', '3', '28', NULL, NULL, 'https://youtu.be/nWWOWDJRJl4', NULL, '1717628400', '1717628400', 'video', '', 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('88', '2.1 - CORPO: Consciência Física', '00:01:30', '3', '28', NULL, NULL, 'https://youtu.be/4HGVfkLEc0Y', NULL, '1717628400', '1717628400', 'video', '', 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('89', '2.2 - CORPO. Corpo-Alerta-Saúde', '00:01:30', '3', '28', NULL, NULL, 'https://youtu.be/IPsQKOtW5WA?si=2opHklJ13itS4Htb', NULL, '1717628400', '1717628400', 'video', '', 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('90', '3.0 - Trabalhando as EMOÇÕES', '00:01:30', '3', '28', 'youtube', NULL, 'https://youtu.be/EH3VzDc4wzQ', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('91', '4.0 - Trabalhar o ESPIRITO', '00:01:30', '3', '28', 'youtube', NULL, 'https://youtu.be/CKeURpvVt-g', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('92', 'Meditação Angelical para abertura de caminhos', '00:20:15', '3', '28', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/4fae8f8d8fcec0f876cfc269d8529e7c.mp3', '1717628400', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('93', 'Vibrando na frequência do EU SOU', '00:01:30', '3', '29', 'youtube', NULL, 'https://youtu.be/lSLXxzwEhJM?si=y0-dWtRa0tq8PqLj', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('94', 'Dica bônus para atrair Abundância', '00:01:30', '3', '29', 'youtube', NULL, 'https://youtu.be/VZySyx5Dfdo', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('95', 'Meditação Angelical para Vibrar na Frequência do &quot;Eu Sou&quot;', '00:27:45', '3', '29', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/9a2b8be435335907f54dfef8dbdae23f.mp3', '1717628400', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('96', 'Ancorando Novo padrão energético da Abundância', '00:01:30', '3', '30', 'youtube', NULL, 'https://youtu.be/iKidDD5iP78', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('97', 'Ancorando o &quot;Eu Sou&quot; no futuro', '00:01:30', '3', '30', 'youtube', NULL, 'https://youtu.be/0RxpbG1D5XE', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('98', 'Meditação Angelical ancorando novo padrão energético de abundância', '00:22:30', '3', '30', NULL, NULL, NULL, 'https://academia.curaquantica13.com/uploads/lesson_files/audios/aa1cf49d3f88326b8a3c0560574f9b98.mp3', '1717628400', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('99', 'Gratidão Despertos!!', '00:01:30', '3', '31', 'youtube', NULL, 'https://youtu.be/fGEQAcOgblY', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('100', 'Avisos Importantes', NULL, '3', '22', NULL, NULL, NULL, NULL, '1717628400', NULL, 'text', '', 'description', NULL, '&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;Caros Despertos,&lt;/b&gt;&lt;br&gt;&lt;o:p&gt;&amp;nbsp;&lt;br&gt;&lt;/o:p&gt;Este “Termo de Responsabilidade” foi firmado para que Vossa\r\nExcelência esteja ciente da PROIBIÇÃO de divulgação e compartilhamento não\r\nautorizado de quaisquer dos conteúdos, materiais e vídeo aula disponibilizadas\r\nneste curso.&lt;br&gt;&lt;o:p&gt;&amp;nbsp;&lt;br&gt;&lt;/o:p&gt;Fica expressamente PROIBIDO, a criação/registro e uso da\r\nmarca e material deste curso sem a autorização expressa do criador do curso.&lt;br&gt;&lt;o:p&gt;&amp;nbsp;&lt;br&gt;&lt;/o:p&gt;Fica PROIBIDO ainda, a tradução dos conteúdos, materiais e\r\nvídeo aula disponibilizadas neste curso.&lt;br&gt;&lt;o:p&gt;&amp;nbsp;&lt;br&gt;&lt;/o:p&gt;Autorizo a terapeuta Diana Lira, utilizar a minha imagem\r\ncontida em fotos e/ou filmagens e áudio, a serem coletadas durante o referido\r\ncurso, com o meu prévio consentimento, para ilustrar filmes, vídeos, clips,\r\npeças publicitárias e promocionais, destinadas a divulgar produtos, nomes,\r\nmarcas, serviços ou qualquer outra denominação ou atividade ligada a marca Cura\r\nQuântica 13. A presente autorização, que se faz firme e valiosa, é concedida a\r\ntítulo não oneroso, sem qualquer limitação quanto ao tempo, território e forma\r\nde divulgação, e será respeitada por nós, meus herdeiros e sucessores.&lt;br&gt;&lt;o:p&gt;&amp;nbsp;&lt;br&gt;&lt;/o:p&gt;Estando Vossa Excelência advertido (a), que o descumprimento\r\nde quaisquer das ordens acima elucidadas, lhe acarretará a responsabilização\r\ncivil e penal pelas perdas, danos diretos e indiretos e lucro cessante,\r\nporventura, causados ao criador do curso.&lt;/p&gt;&lt;/blockquote&gt;&lt;p&gt;\r\n\r\n&lt;/p&gt;\r\n\r\n&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;blockquote class=&quot;blockquote&quot;&gt;&lt;p&gt;&lt;b&gt;OBS...&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;br&gt;Visualize ou realize o download do arquivo clicando &lt;b&gt;&lt;a href=&quot;https://drive.google.com/file/d/1Da8fsFpa5EQfQIBiVPP46JbY29fR40s2/view?usp=share_link&quot; target=&quot;_blank&quot;&gt;AQUI&lt;/a&gt;.&lt;/b&gt;&lt;/p&gt;&lt;/blockquote&gt;', '0', '0', '0', NULL, NULL, NULL), ('101', 'Seja Bem Vindo', '00:01:30', '4', '33', 'youtube', NULL, 'https://youtu.be/G-ITG3Xn2bw', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('102', 'Como faço a Cura do meu Emocional?', '00:01:30', '4', '34', 'youtube', NULL, 'https://youtu.be/crdFz9y0ffg', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('103', 'Cura Karmica', '00:01:30', '4', '35', 'youtube', NULL, 'https://youtu.be/iNlOcDC4NU0', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('104', 'Corte de laços energéticos', '00:01:30', '4', '36', 'youtube', NULL, 'https://youtu.be/uAmZRi2Jn2I', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('105', 'Desprogramando crenças limitantes', '00:01:30', '4', '37', 'youtube', NULL, 'https://youtu.be/Q44O-kxwHM4', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('106', 'Como vou-te ajudar a Desprogramar?', '00:01:30', '4', '38', 'youtube', NULL, 'https://youtu.be/S3X2gZO_2tU', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('107', 'Como a Desprogramação Neurobiológica Liberta o coração e a mente?', '00:01:30', '4', '39', 'youtube', NULL, 'https://youtu.be/9zpdAYMIai8', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('108', 'Abrindo o meu Coração para Receber', '00:01:30', '4', '40', 'youtube', NULL, 'https://youtu.be/X9zg0tJ8b1E', NULL, '1717628400', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('110', 'CANAL INFORMAÇÕES TELEGRAM', NULL, '5', '41', NULL, NULL, NULL, NULL, '1718751600', '1718751600', 'text', '&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;Neste canal, vais encontrar atualizações importantes, materiais de apoio, e terás a oportunidade de interagir diretamente comigo e com outros participantes. É o espaço ideal para tirar dúvidas, partilhar experiências e fortalecer a tua jornada de transformação. Junta-te a nós e aproveita ao máximo todos os recursos e o suporte contínuo disponível para ti!&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;Clica no link abaixo&amp;nbsp;&amp;nbsp;&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://t.me/+BzpACd1ZHTk3MmY0&quot; target=&quot;_blank&quot;&gt;Canal TELEGRAM&lt;/a&gt;&lt;br&gt;&lt;/p&gt;', 'description', NULL, '', '0', '4', '0', NULL, NULL, NULL), ('113', 'TRATAMENTO TERAPÊUTICO', NULL, '5', '43', NULL, NULL, NULL, NULL, '1718751600', '1719183600', 'text', '&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;&lt;span style=&quot;font-family: Nunito;&quot;&gt;Neste módulo, vamos concentrar-nos em sessões de terapia em grupo, concebidas para desbloquear questões emocionais e desprogramar crenças limitantes que possam estar a impedir o seu crescimento pessoal e profissional. Durante estas sessões, exploraremos diversas técnicas terapêuticas para promover a cura emocional, aumentar a autoconfiança e preparar a sua mente para o Sucesso. &lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;&lt;span style=&quot;font-family: Nunito;&quot;&gt;Num ambiente seguro e acolhedor, cada participante terá a oportunidade de partilhar as suas experiências, receber feedback e trabalhar em conjunto para superar obstáculos internos. Este módulo é essencial para libertar o seu verdadeiro potencial e preparar o caminho para uma carreira próspera e equilibrada.&lt;/span&gt;&lt;/p&gt;', 'description', NULL, '', '0', '1', '0', NULL, NULL, NULL), ('119', ' CRIANDO OS MEUS ASSISTENTES ROBÔS (Brevemente)', NULL, '5', '51', NULL, NULL, NULL, NULL, '1719097200', '1722898800', 'text', '&lt;p&gt;&lt;br&gt;&lt;/p&gt;', 'description', NULL, '', '0', '5', '0', NULL, NULL, NULL), ('120', 'CANVA: criação de material de marca (Brevemente)', NULL, '5', '44', NULL, NULL, NULL, NULL, '1719097200', '1722898800', 'text', '', 'description', NULL, '', '0', '2', '0', NULL, NULL, NULL), ('121', 'INSTAGRAM/FACEBOOK.(Brevemente)', NULL, '5', '44', NULL, NULL, NULL, NULL, '1719097200', '1722898800', 'text', '', 'description', NULL, '', '0', '3', '0', NULL, NULL, NULL), ('122', 'LINKEDIN (Brevemente)', NULL, '5', '44', NULL, NULL, NULL, NULL, '1719097200', '1722898800', 'text', '', 'description', NULL, '', '0', '4', '0', NULL, NULL, NULL), ('123', 'WHATSAPP/TELEGRAM (Brevemente)', NULL, '5', '44', NULL, NULL, NULL, NULL, '1719097200', '1722898800', 'text', '', 'description', NULL, '', '0', '5', '0', NULL, NULL, NULL), ('135', 'Sejam muito Bem-Vindos', '00:01:06', '5', '41', 'youtube', NULL, 'https://youtu.be/IxpXG7zhLwc', NULL, '1719183600', NULL, 'video', NULL, 'url', NULL, '', '0', '1', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('136', 'E-BOOK: 8 Passos para construir Autoridade online e Integrar IA com Espiritualidade', '', '5', '43', '', NULL, '', NULL, '1719270000', '1720220400', 'other', '55d7e2d385a0313f3944f43a14274f64.pdf', 'pdf', NULL, '&lt;p&gt;&lt;a href=&quot;https://drive.google.com/file/d/1YpTU1IETlfRsRvveI1Y5Jd0_Mx0obEYv/view?usp=sharing&quot; target=&quot;_blank&quot;&gt;https://drive.google.com/file/d/1YpTU1IETlfRsRvveI1Y5Jd0_Mx0obEYv/view?usp=sharing&lt;/a&gt;&lt;br&gt;&lt;/p&gt;', '0', '7', '0', '', '', ''), ('138', 'Plataforma EAD Mentoria', '00:01:05', '5', '41', 'youtube', NULL, 'https://youtu.be/C4BJx_d-OD0', NULL, '1719270000', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;Link plataforma:&amp;nbsp;&amp;nbsp;&lt;a href=&quot;https://youtu.be/C4BJx_d-OD0&quot; target=&quot;_blank&quot;&gt;https://youtu.be/C4BJx_d-OD0&lt;/a&gt;&lt;br&gt;&lt;/p&gt;', '0', '3', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('144', 'AULA INAUGURAL', '00:24:32', '5', '47', 'youtube', NULL, 'https://youtu.be/PR22DtgsAsY', NULL, '1719356400', NULL, 'video', NULL, 'url', NULL, '', '0', '5', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('145', 'APRESENTAÇÃO DA MENTORIA', '00:35:06', '5', '47', 'youtube', NULL, 'https://youtu.be/TpgtWRe1uX4', NULL, '1719442800', NULL, 'video', NULL, 'url', NULL, '', '0', '6', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('146', 'Como vai funcionar a mentoria?', '00:02:36', '5', '41', 'youtube', NULL, 'https://youtu.be/dSF3dapDGpI?si=Zo3mZkyYOJ7fxrJB', NULL, '1719442800', NULL, 'video', NULL, 'url', NULL, '&lt;p class=&quot;MsoNormal&quot;&gt;Teremos encontros quinzenais às quartas-feiras, às 20h, via\r\nGoogle Meet, onde proporcionaremos aulas completas e espaços dedicados para\r\nesclarecer todas as suas dúvidas. Além disso, todos os meses organizaremos um\r\nbootcamp prático, onde poderá aplicar os conhecimentos adquiridos. Para\r\nenriquecer ainda mais a sua experiência, incluímos até 5 sessões de terapia em\r\ngrupo ao longo do programa, garantindo suporte emocional e partilha de\r\nexperiências entre os participantes. Esta abordagem permitirá que veja resultados\r\nconcretos no seu negócio terapêutico, com feedback e apoio contínuo para\r\nassegurar o seu sucesso.&lt;o:p&gt;&lt;/o:p&gt;&lt;/p&gt;', '0', '2', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('149', 'CHATGTP GUIA PRATICO PARA A GESTÃO DO NEGÓCIO', '', '5', '48', '', NULL, '', NULL, '1720047600', '1720220400', 'other', 'f51c85e56d615b2a775ad7944f1c1756.pdf', 'pdf', NULL, '', '0', '4', '0', '', '', ''), ('150', 'CONFIGURAR CHATGPT E FERRAMENTAS DE IA', '01:15:47', '5', '48', 'youtube', NULL, 'https://youtu.be/fWgHVRJdJGA', NULL, '1720047600', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;ATIVIDADES práticas para explorar o chatGPT&amp;nbsp;&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://docs.google.com/document/d/1-wqJcfwzVFxsRVRSbnSVnCuKnCyxOueJeRHH0b9sLtM/edit?usp=sharing&quot; target=&quot;_blank&quot;&gt;https://docs.google.com/document/d/1-wqJcfwzVFxsRVRSbnSVnCuKnCyxOueJeRHH0b9sLtM/edit?usp=sharing&lt;/a&gt;&lt;br&gt;&lt;/p&gt;', '0', '3', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('154', 'MEDITAÇÃO ANGELICAL ABERTURA DE CAMINHOS.', '00:18:31', '5', '43', 'youtube', NULL, 'https://youtu.be/ICVCEPB4zKU', NULL, '1720047600', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;&lt;span style=&quot;font-family: Nunito;&quot;&gt;Neste módulo, mergulharemos na prática da meditação angelical, uma técnica poderosa para abrir caminhos e alinhar-se com as energias positivas do universo. Através de meditações guiadas, iremos conectar-nos com seres angélicos, buscando orientação, proteção e inspiração para superar obstáculos e atrair oportunidades. Esta prática não só promove a paz interior e o bem-estar espiritual, mas também facilita a manifestação dos seus objetivos pessoais e profissionais. Prepare-se para desbloquear novas possibilidades e trilhar um caminho de luz e sucesso.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;', '0', '5', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('155', 'BASES DE I.A NO NEGÓCIO TERAPÊUTICO', '00:15:49', '5', '48', 'youtube', NULL, 'https://youtu.be/SxdatlgkAAI', NULL, '1720047600', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;&lt;span style=&quot;font-family: Nunito;&quot;&gt;Neste módulo, iremos explorar as incríveis potencialidades do ChatGPT, uma ferramenta de inteligência artificial que pode transformar a forma como gere o seu negócio terapêutico. Aprenderá a utilizar o ChatGPT para automatizar tarefas administrativas, criar conteúdos envolventes para as redes sociais, responder a dúvidas frequentes dos clientes e muito mais. Esta tecnologia permitirá otimizar o seu tempo, aumentar a eficiência e melhorar a comunicação com os seus clientes, tudo enquanto mantém um toque pessoal e humano. Prepare-se para elevar o seu negócio a um novo patamar com a ajuda do ChatGPT.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;', '0', '1', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('156', 'APLICAÇÕES DE IA ', '00:25:41', '5', '48', 'youtube', NULL, 'https://youtu.be/TU04rnB4Yz4', NULL, '1720047600', NULL, 'video', NULL, 'url', NULL, '&lt;div class=&quot;tab-content ct-tabs-content&quot; style=&quot;color: rgb(115, 121, 130); font-family: Inter, sans-serif; font-size: 15px; background-color: rgb(236, 240, 241);&quot;&gt;&lt;div class=&quot;tab-pane fade active show&quot; id=&quot;summary-class-content&quot; role=&quot;tabpanel&quot; aria-labelledby=&quot;summary-class-tab&quot;&gt;&lt;p style=&quot;margin-bottom: 0px;&quot;&gt;MAPA MENTAL DA AULA&amp;nbsp;&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://whimsical.com/bases-de-ia-NJnYhLSKmp5aMbmgWtjdZ7&quot; target=&quot;_blank&quot; style=&quot;color: inherit; transition: all 0.3s ease-in-out 0s; outline-style: none; outline-width: initial; box-shadow: none;&quot;&gt;https://whimsical.com/bases-de-ia-&lt;/a&gt;&lt;span style=&quot;background-color: rgb(255, 255, 255); font-size: 0.875rem;&quot;&gt;&lt;a href=&quot;https://whimsical.com/bases-de-ia-NJnYhLSKmp5aMbmgWtjdZ7&quot; target=&quot;_blank&quot; style=&quot;color: inherit; transition: all 0.3s ease-in-out 0s; outline-style: none; outline-width: initial; box-shadow: none;&quot;&gt;NJnYhLSKmp5aMbmgWtjdZ7&lt;/a&gt;&lt;/span&gt;&lt;/p&gt;&lt;div&gt;&lt;br&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;', '0', '2', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('158', 'QUESTIONÁRIO DIAGNÓSTICO', NULL, '5', '50', NULL, NULL, NULL, NULL, '1720220400', '1722898800', 'text', '&lt;p&gt;QUESTIONÁRIO DIAGNÓSTICO&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://forms.gle/HzpKS3E7d2b38BsU7&quot; target=&quot;_blank&quot; style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;&lt;b&gt;https://forms.gle/HzpKS3E7d2b38BsU7&lt;/b&gt;&lt;/a&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;A importância de os mentorados fazerem e enviarem o questionário diagnóstico é fundamental para o sucesso da sua jornada na mentoria. Este questionário inicial permite-nos compreender melhor as suas necessidades, desafios e objetivos específicos. Com estas informações, podemos personalizar o programa para atender às suas particularidades, garantindo uma abordagem mais eficaz e direcionada.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14); min-height: 17px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;&lt;span style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;Após o envio do questionário diagnóstico, agendamos a Sessão de Posicionamento&lt;/span&gt;. Esta sessão é o primeiro passo para todo o aprendizado que será adquirido ao longo da mentoria. Serve como base para criar conteúdo relevante, desenvolver estratégias de marketing digital e otimizar as táticas de vendas. Com estas estratégias, os mentorados serão capazes de atrair e reter clientes, aumentar a sua presença online e, eventualmente, duplicar os seus rendimentos em seis meses através da integração de tecnologias de IA e práticas empresariais avançadas.&lt;/p&gt;', 'description', NULL, '', '0', '1', '0', NULL, NULL, NULL), ('160', 'STORIES QUE VENDEM (Brevemente)', NULL, '5', '44', NULL, NULL, NULL, NULL, '1720393200', '1722898800', 'text', '', 'description', NULL, '', '0', '7', '0', NULL, NULL, NULL), ('162', 'TÉCNICA PROMODORO', '00:07:59', '5', '51', 'youtube', NULL, 'https://youtu.be/0RFXSphtvsg', NULL, '1720479600', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;&lt;a href=&quot;https://drive.google.com/file/d/1WtUJPNwn03awo9tkEYzRUZiNIWDmJY2N/view?usp=sharing&quot; target=&quot;_blank&quot;&gt;https://drive.google.com/file/d/1WtUJPNwn03awo9tkEYzRUZiNIWDmJY2N/view?usp=sharing&lt;/a&gt;&lt;br&gt;&lt;/p&gt;', '0', '4', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('163', 'GOOGLE DRIVE/DOCS/AGENDA/FORMS/KEEP', '00:22:18', '5', '51', 'youtube', NULL, 'https://youtu.be/6dy73DbIpB8', NULL, '1720479600', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;Link Google Docs: &lt;a href=&quot;https://docs.google.com/document&quot; target=&quot;_blank&quot;&gt;https://docs.google.com/document&lt;/a&gt;&lt;/p&gt;&lt;p&gt;Link Google Formularios:&amp;nbsp;&lt;a href=&quot;https://docs.google.com/forms&quot; target=&quot;_blank&quot;&gt; https://docs.google.com/forms&lt;/a&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;color: rgb(0, 0, 0); font-size: 0.875rem;&quot;&gt;Link Google Keep:&lt;a href=&quot;https://keep.google.com&quot; target=&quot;_blank&quot;&gt; https://keep.google.com&lt;/a&gt;&lt;/span&gt;&lt;br&gt;&lt;/p&gt;', '0', '2', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('168', 'DEFINIÇÃO DE METAS E OBJETIVOS', NULL, '5', '50', NULL, NULL, NULL, NULL, '1720652400', '1721257200', 'other', '5f91a91478d701ee858aac8f79fd3d82.pdf', 'pdf', NULL, '&lt;p&gt;Link do pdf para descarregar ou imprimir:&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://drive.google.com/file/d/1oYH5Kc5gJ6vPflMbfBqBzKIrjlpT4BnZ/view?usp=sharing&quot; target=&quot;_blank&quot;&gt;https://drive.google.com/file/d/1oYH5Kc5gJ6vPflMbfBqBzKIrjlpT4BnZ/view?usp=sharing&lt;/a&gt;&lt;br&gt;&lt;/p&gt;', '0', '11', '0', NULL, NULL, NULL), ('169', 'DEFININDO O MEU POSICIONAMENTO PODEROSO', '01:49:46', '5', '47', 'youtube', NULL, 'https://youtu.be/AaqOfs269_0', NULL, '1720652400', NULL, 'video', NULL, 'url', NULL, '', '0', '7', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('170', '1.- Origem do Despertando o Poder de Autocura', '00:05:34', '6', '52', 'youtube', NULL, 'https://youtu.be/_G7xMTJf-LA', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('171', '2.- Exercício de respiração para acalmar e dormir', '00:02:48', '6', '53', 'youtube', NULL, 'https://youtu.be/wZjCwLGe5zs', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('172', '3.- Desprogramando o meu timo', '00:20:00', '6', '54', NULL, NULL, NULL, 'https://cursos.curaquantica13.com/uploads/lesson_files/audios/03edb5bc72f22de3c16b64942ec8622b.mp3', '1720998000', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('173', '4.- Sessão Anjos da Criação para limpeza e alinhamento energético da Glândula do Timo', '00:20:00', '6', '55', NULL, NULL, NULL, 'https://cursos.curaquantica13.com/uploads/lesson_files/audios/fce1dd3b839f5ced4a2de567c61cd22e.mp3', '1720998000', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('174', '5.- Agua Solarizada Azul', '00:05:01', '6', '56', 'youtube', NULL, 'https://youtu.be/5IS_Ma6DidE', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('175', '6.- Como preparar a Agua Solarizada', '00:02:01', '6', '57', 'youtube', NULL, 'https://youtu.be/qqFPXn7aNbo', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('176', '7.- Sessão DNB para abrir o Receber', '00:08:52', '6', '58', NULL, NULL, NULL, 'https://cursos.curaquantica13.com/uploads/lesson_files/audios/b9950659247773f81a66aa379439eef8.mp3', '1720998000', NULL, 'audio', NULL, 'file', NULL, '', '0', '0', '0', NULL, NULL, NULL), ('178', '9.- Depoimento', '00:00:38', '6', '60', 'youtube', NULL, 'https://youtu.be/sQnwYEPr06I', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('179', '8.- Exercício para ativar a glândula do timo', '00:07:48', '6', '59', 'youtube', NULL, 'https://youtu.be/ZB0Rd_fMqIQ', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('180', 'TRELLO', '00:14:31', '5', '51', 'youtube', NULL, 'https://youtu.be/fOlvzqLul3M', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;Link da app referida na Aula:&amp;nbsp;&lt;a href=&quot;http://www.trello.com&quot; target=&quot;_blank&quot;&gt;www.trello.com&lt;/a&gt;&lt;/p&gt;', '0', '3', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('183', 'COMO CRIAR UM NEGÓCIO MILIONÁRIO', '01:01:00', '5', '50', 'youtube', NULL, 'https://youtu.be/3IVXoQ1kGdg?si=uBTAQ9l12ZvX-zL0', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-top:0pt;margin-bottom:0pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Dicas para um Negócio de Sucesso segundo Sandro San:&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;b style=&quot;font-weight:normal;&quot; id=&quot;docs-internal-guid-2fabbd53-7fff-96ca-4e4b-06737b87791c&quot;&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;1.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Foco em Produtos de Alto Valor&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Ajude especialistas e consultores a criarem e venderem produtos de alto valor para gerar receitas significativas.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;2.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Persistência e Resiliência&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: O caminho para o sucesso não é fácil e envolve enfrentar dificuldades e fracassos. Aprender com essas experiências é crucial.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;3.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Decisões Estratégicas&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: É importante tomar decisões conscientes e estratégicas para mudar a trajetória de sua vida e negócios.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;4.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Liberdade Financeira&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: A liberdade financeira é essencial para ter controle sobre a vida e poder ajudar os outros. Ter dinheiro proporciona mais opções e segurança.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;5.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Oportunidades em Situações Difíceis&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Transformar situações adversas em oportunidades, como negociar dívidas ou identificar nichos de mercado, pode levar ao sucesso.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;6.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Importância da Autoridade&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Autoridade no mercado é construída pelo conhecimento e pela capacidade de resolver problemas dos clientes, não necessariamente pela fama.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;7.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Soluções Simples e Eficazes&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Soluções rápidas e diretas são valorizadas e podem ser mais caras do que soluções complexas e longas.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;8.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Valor Percebido pelo Mercado&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Os consumidores muitas vezes associam preços mais altos a produtos de melhor qualidade. Aproveitar essa percepção pode ser uma estratégia eficaz.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;9.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Automatização de Processos&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Utilizar a internet e a automação para criar processos de venda eficientes pode escalar o negócio de maneira significativa.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;10.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Diferenciação de Produto&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Ter diferenciais claros e visíveis para os clientes é crucial para se destacar da concorrência.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;11.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Marketing Estratégico&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Investir em marketing para atrair o público certo e converter leads em clientes de alto valor.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;12.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Começar com um Produto Premium&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Iniciar o negócio com um posicionamento premium pode ser mais eficaz do que tentar subir os preços posteriormente.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;13.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Mentalidade de Empreendedor&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Ter uma mentalidade focada em resultados e em fazer coisas diferentes para obter resultados diferentes é essencial.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-top:0pt;margin-bottom:0pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Essas dicas fornecem uma base sólida para quem deseja alcançar o sucesso nos negócios, focando em estratégias de valor, resiliência, autoridade e marketing eficiente.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;b style=&quot;font-weight:normal;&quot;&gt;&lt;br&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-top:0pt;margin-bottom:0pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Aqui são reveladas as melhores estratégias para cobrar mais pelos vossos serviços e atrair clientes de alto valor, com a ajuda do meu mentor Sandro San. Se estão prontos para transformar a vossa carreira e alcançar o sucesso financeiro, este vídeo é para vocês!&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;b style=&quot;font-weight:normal;&quot;&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-top:0pt;margin-bottom:0pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;As Melhores dicas que o Sandro San fala neste video são:&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;1.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Mentores&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Ter mentores é fundamental para alcançar níveis elevados de sucesso. Procure orientação de mentores experientes que já atingiram os objetivos que você busca.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;2.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Histórias Inspiradoras&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Aprenda com histórias de sucesso de pessoas que conseguiram cobrar mais caro pelos seus serviços. Isso pode servir de inspiração e mostrar estratégias eficazes.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;3.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Cobrar Justo&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Entenda o valor do seu trabalho. Muitas vezes, os clientes não sabem o quanto você investiu para adquirir suas habilidades. Cobrar um preço justo pelo valor entregue é essencial.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;4.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Clientes de Alto Valor&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Clientes que pagam mais geralmente têm mais comprometimento e resultados melhores. Ajuste seu foco para atrair clientes dispostos a investir em soluções de alta qualidade.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;5.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Comunicação Eficaz&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Mostre autoridade e conhecimento sobre o problema que você resolve. Clientes precisam sentir que você entende suas dores e que pode oferecer soluções eficazes.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;6.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Embalagem e Posicionamento&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Diferencie-se no mercado através de um posicionamento claro e uma “embalagem” atraente, seja no marketing ou na apresentação dos seus serviços.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;7.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Investimento em Tráfego&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Invista em anúncios para alcançar previsibilidade financeira. Conheça o valor de cada cliente e esteja disposto a investir para atrair novos clientes.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;8.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Processo de Vendas&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Tenha um processo de vendas bem estruturado que inclui anúncios, conteúdo de valor, ofertas e fechamento de vendas.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;9.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Conteúdo de Alto Valor&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Crie conteúdo que mostra seu entendimento profundo dos problemas dos seus clientes e ofereça soluções práticas e valiosas.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;10.&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Desafio Pessoal&lt;/span&gt;&lt;span style=&quot;font-size:10.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Experimente criar uma oferta de maior valor do que você costuma cobrar e veja a resposta do mercado. Ajuste conforme necessário para encontrar o preço justo pelo seu serviço.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', '0', '12', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('184', 'DEFININDO PROBLEMA COMPLEXO', '00:04:24', '5', '50', 'youtube', NULL, 'https://youtu.be/foskg2bsmuo', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '', '0', '3', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('186', 'PROPOSTA ÚNICA DE VALOR', '00:02:44', '5', '50', 'youtube', NULL, 'https://youtu.be/8Qxo__b8PAw', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '', '0', '4', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('187', 'ERROS COMUNS NO POSICIONAMENTO', '00:09:49', '5', '50', 'youtube', NULL, 'https://youtu.be/a24VrSVWyaQ', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '', '0', '5', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('188', 'IDENTIFICANDO O NICHO IDEAL', '00:05:05', '5', '50', 'youtube', NULL, 'https://youtu.be/Ik3bgaXC6_s', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '', '0', '6', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('189', 'CONSISTÊNCIA É A CHAVE', '00:07:23', '5', '50', 'youtube', NULL, 'https://youtu.be/GbgoMzXVlHA', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '', '0', '7', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('191', 'Teste', '00:01:30', '7', '61', 'youtube', NULL, 'https://youtu.be/OV7e5OkrlgM?si=JSTGwYjwqZNeCfFY', NULL, '1720998000', NULL, 'video', NULL, 'url', NULL, '', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('193', 'IDENTIFICANDO CLIENTE IDEAL', '00:06:34', '5', '50', 'youtube', NULL, 'https://youtu.be/YqWBbFcbrAY', NULL, '1721170800', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;https://drive.google.com/file/d/1y7Q-wrsHU3qZMPEM4DNCQoaU6OWvVz1J/view?usp=sharing&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', '0', '2', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('194', 'LINK GOOGLE MEET ENCONTRO AO VIVO', NULL, '5', '47', NULL, NULL, NULL, NULL, '1721170800', '1721170800', 'text', '&lt;p&gt;&lt;span style=&quot;font-family: Tahoma; background-color: rgb(255, 255, 255);&quot;&gt;LINK AULA PARA ENCONTROS AO VIVO&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-family: Tahoma; background-color: rgb(255, 255, 0);&quot;&gt;https://meet.google.com/uvk-zobj-ybb?authuser=0&lt;/span&gt;&lt;span style=&quot;font-family: &amp;quot;Lucida Grande&amp;quot;;&quot;&gt;﻿&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', 'description', NULL, '', '0', '3', '0', NULL, NULL, NULL), ('195', 'CRONOGRAMA DE ENCONTROS AO VIVO', NULL, '5', '47', NULL, NULL, NULL, NULL, '1721170800', '1725836400', 'text', '&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;ENCONTROS AO VIVO&lt;/p&gt;&lt;p&gt;23/06/24. Aula Inaugural&lt;/p&gt;&lt;p&gt;03/07/24 Bases de IA e Meditação Angelical: Abertura de Jornada&lt;/p&gt;&lt;p&gt;10/07/24 Posicionamento&lt;/p&gt;&lt;p&gt;17/07/24 Mentalidade Empreendedora&lt;/p&gt;&lt;p&gt;31/07/24 Marketing&amp;nbsp;&lt;/p&gt;&lt;p&gt;14/08/24 Marketing Redes&lt;/p&gt;&lt;p&gt;28/08/24 Encontro tira duvidas Bootcamp&lt;/p&gt;&lt;p&gt;11/09/24 Funis de Venda&lt;/p&gt;&lt;p&gt;25/09/24&amp;nbsp;&lt;/p&gt;&lt;p&gt;09/10/24&lt;/p&gt;&lt;p&gt;23/10/24&lt;/p&gt;&lt;p&gt;13/11/24&lt;/p&gt;&lt;p&gt;27/11/24&lt;/p&gt;&lt;p&gt;11/12/24&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', 'description', NULL, '', '0', '4', '0', NULL, NULL, NULL), ('196', 'MENTALIDADE EMPREENDEDORA', '01:25:37', '5', '47', 'youtube', NULL, 'https://youtu.be/dTu8SJRUv9E', NULL, '1721257200', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;LINK DO MAPA MENTAL APRESENTADO NA AULA:&amp;nbsp;&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://miro.com/welcomeonboard/bGlNOVMzb3BWajJ0cXI2ZmJydUNTNll6bWp3dTNvYjhKa0docDk2ZnhOY1hlUjZueFpPY2xTOFpDQkhrT3RmWHwzNDU4NzY0NTkyNzYyMDAxOTU2fDI=?share_link_id=675374199759&quot; target=&quot;_blank&quot;&gt;https://miro.com/welcomeonboard/bGlNOVMzb3BWajJ0cXI2ZmJydUNTNll6bWp3dTNvYjhKa0docDk2ZnhOY1hlUjZueFpPY2xTOFpDQkhrT3RmWHwzNDU4NzY0NTkyNzYyMDAxOTU2fDI=?share_link_id=675374199759&lt;/a&gt;&lt;a href=&quot;https://miro.com/welcomeonboard/bGlNOVMzb3BWajJ0cXI2ZmJydUNTNll6bWp3dTNvYjhKa0docDk2ZnhOY1hlUjZueFpPY2xTOFpDQkhrT3RmWHwzNDU4NzY0NTkyNzYyMDAxOTU2fDI=?share_link_id=675374199759&quot; target=&quot;_blank&quot;&gt;&lt;/a&gt;&lt;/p&gt;&lt;p&gt;Biografia recomendada:&lt;/p&gt;&lt;p&gt;Napoleão Hill &quot;Pense e fique Rico&quot;&lt;/p&gt;&lt;p&gt;Gary Keller: &quot;a Única Coisa&quot;&lt;/p&gt;', '0', '8', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('197', 'COMO CRIAR UMA OFERTA IRRESISTÍVEL?', '00:36:39', '5', '50', 'youtube', NULL, 'https://youtu.be/4kCDPKeLEl4', NULL, '1722034800', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;&lt;span style=&quot;color: rgb(0, 0, 0); font-size: 0.875rem;&quot;&gt;Material da Aula:&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://drive.google.com/file/d/1fKN702FePVQZiakqB6wsmnJiwyeXPzKi/view?usp=sharing&quot; target=&quot;_blank&quot;&gt;https://drive.google.com/file/d/1fKN702FePVQZiakqB6wsmnJiwyeXPzKi/view?usp=sharing&lt;/a&gt;&lt;a href=&quot;https://drive.google.com/file/d/1fKN702FePVQZiakqB6wsmnJiwyeXPzKi/view?usp=sharing&quot; target=&quot;_blank&quot;&gt;&lt;/a&gt;&lt;/p&gt;&lt;p&gt;Passo a passo para criar uma oferta Irresistível com o ChatGPT&lt;/p&gt;', '0', '8', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('198', 'PASSO A PASSO PARA CRIAR O SEU DOCUMENTO MESTRE', '', '5', '50', '', NULL, '', NULL, '1722034800', '1724108400', 'other', 'aa1ba0e4e8cc7691d0e7c47faa70a0d8.pdf', 'pdf', NULL, '&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &quot; .sf=&quot;&quot; ns&quot;;=&quot;&quot; color:=&quot;&quot; rgb(14,=&quot;&quot; 14,=&quot;&quot; 14);&quot;=&quot;&quot;&gt;Criar um passo a passo detalhado para desenvolver a vossa oferta é essencial para garantir que cada aspeto do vosso programa/produto/mentoria e está bem pensado e alinhado com as necessidades do vosso público-alvo. Este processo estruturado proporciona clareza e orientação, permitindo que desenvolvam um método eficaz e consistente.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &quot; .sf=&quot;&quot; ns&quot;;=&quot;&quot; color:=&quot;&quot; rgb(14,=&quot;&quot; 14,=&quot;&quot; 14);=&quot;&quot; min-height:=&quot;&quot; 17px;&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &quot; .sf=&quot;&quot; ns&quot;;=&quot;&quot; color:=&quot;&quot; rgb(14,=&quot;&quot; 14,=&quot;&quot; 14);&quot;=&quot;&quot;&gt;Em primeiro lugar, um guia passo a passo ajuda a definir claramente quem vocês são, o que fazem e para quem fazem. Estes elementos são fundamentais para estabelecer uma conexão forte e autêntica com o vosso público-alvo. Quando sabem exatamente quem estão a tentar alcançar, podem criar mensagens e estratégias de marketing mais eficazes, aumentando as chances de atrair e reter clientes.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &quot; .sf=&quot;&quot; ns&quot;;=&quot;&quot; color:=&quot;&quot; rgb(14,=&quot;&quot; 14,=&quot;&quot; 14);=&quot;&quot; min-height:=&quot;&quot; 17px;&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &quot; .sf=&quot;&quot; ns&quot;;=&quot;&quot; color:=&quot;&quot; rgb(14,=&quot;&quot; 14,=&quot;&quot; 14);&quot;=&quot;&quot;&gt;Além disso, a análise das dores, desejos e armadilhas do vosso público-alvo permite uma compreensão profunda dos desafios que enfrentam e das soluções que procuram. Este conhecimento é crucial para desenvolver uma oferta que realmente ressoe com eles e que se destaque no mercado. Ao abordar diretamente as suas necessidades e problemas, podem posicionar a vossa oferta como a solução ideal, aumentando a perceção de valor e a confiança dos potenciais clientes.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &quot; .sf=&quot;&quot; ns&quot;;=&quot;&quot; color:=&quot;&quot; rgb(14,=&quot;&quot; 14,=&quot;&quot; 14);=&quot;&quot; min-height:=&quot;&quot; 17px;&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &quot; .sf=&quot;&quot; ns&quot;;=&quot;&quot; color:=&quot;&quot; rgb(14,=&quot;&quot; 14,=&quot;&quot; 14);&quot;=&quot;&quot;&gt;A inclusão de uma jornada de compra bem definida garante que guiam os vossos clientes de forma suave e eficaz desde o primeiro ponto de contacto até à compra final e além. Este planeamento meticuloso ajuda a identificar e remover possíveis obstáculos que possam surgir ao longo do caminho, facilitando a conversão e a fidelização dos clientes.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &quot; .sf=&quot;&quot; ns&quot;;=&quot;&quot; color:=&quot;&quot; rgb(14,=&quot;&quot; 14,=&quot;&quot; 14);=&quot;&quot; min-height:=&quot;&quot; 17px;&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &quot; .sf=&quot;&quot; ns&quot;;=&quot;&quot; color:=&quot;&quot; rgb(14,=&quot;&quot; 14,=&quot;&quot; 14);&quot;=&quot;&quot;&gt;Finalmente, a criação de um método em etapas claras e concisas assegura que o vosso programa é fácil de seguir e aplicar. Isto não só melhora a experiência do cliente, mas também permite medir e otimizar continuamente o vosso processo, garantindo que entregam resultados consistentes e de alta qualidade.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &quot; .sf=&quot;&quot; ns&quot;;=&quot;&quot; color:=&quot;&quot; rgb(14,=&quot;&quot; 14,=&quot;&quot; 14);=&quot;&quot; min-height:=&quot;&quot; 17px;&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &quot; .sf=&quot;&quot; ns&quot;;=&quot;&quot; color:=&quot;&quot; rgb(14,=&quot;&quot; 14,=&quot;&quot; 14);&quot;=&quot;&quot;&gt;Em resumo, elaborar um passo a passo para criar a vossa oferta é uma prática indispensável para qualquer profissional do bem-estar que deseja criar um programa/produto/mentoria bem-sucedido e impactante. Este método estruturado proporciona uma base sólida para desenvolver uma oferta que realmente atenda às necessidades do vosso público, aumente o vosso alcance e maximize os resultados.&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;EXEMPLO DE DOCUMENTO MESTRE:&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://drive.google.com/file/d/1ZWZBv2S2yhLqh0ck_VLPgZqqgXR3aPt6/view?usp=sharing&quot; target=&quot;_blank&quot;&gt;https://drive.google.com/file/d/1ZWZBv2S2yhLqh0ck_VLPgZqqgXR3aPt6/view?usp=sharing&lt;/a&gt;&lt;br&gt;&lt;/p&gt;', '0', '10', '0', '', '', ''), ('199', 'ESTRATÉGIAS DE MKT DIGITAL', '01:37:12', '5', '47', 'youtube', NULL, 'https://youtu.be/GUcG_XOyeRI', NULL, '1722380400', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;Mapa mental da aula:&amp;nbsp;&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://mm.tt/app/map/2996580285?t=bD1trs92C4&quot; target=&quot;_blank&quot;&gt;https://mm.tt/app/map/2996580285?t=bD1trs92C4&lt;/a&gt;&lt;br&gt;&lt;/p&gt;', '0', '9', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('200', 'ENCONTRO EXTRA. PASSO A PASSO DOC MESTRE', '01:48:34', '5', '47', 'youtube', NULL, 'https://youtu.be/tYNJrfcTf68', NULL, '1723071600', NULL, 'video', NULL, 'url', NULL, '', '0', '10', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('201', 'CONTEÚDO DE ALTO VALOR', '01:48:47', '5', '47', 'youtube', NULL, 'https://youtu.be/APSCwLGWcBI', NULL, '1723676400', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;APRESENTAÇÃO DA AULA&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://drive.google.com/file/d/1V-BBDrIelMP0xoF1JB-lUg9p-kpusZFn/view?usp=sharing&quot; target=&quot;_blank&quot;&gt;https://drive.google.com/file/d/1V-BBDrIelMP0xoF1JB-lUg9p-kpusZFn/view?usp=sharing&lt;/a&gt;&lt;/p&gt;&lt;p&gt;PASSO A PASSO PARA CRIAR CONTEÚDO DE ALTO VALOR COM CHATGPT&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://drive.google.com/file/d/1ZF0MX86n8dymgDscu4eRNCQlnv9mCsTS/view?usp=sharing&quot; target=&quot;_blank&quot;&gt;https://drive.google.com/file/d/1ZF0MX86n8dymgDscu4eRNCQlnv9mCsTS/view?usp=sharing&lt;/a&gt;&lt;br&gt;&lt;/p&gt;', '0', '11', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('202', 'CRIA O BRANDING DA TUA MARCA EM 1 DIA', '01:46:43', '5', '63', 'youtube', NULL, 'https://youtu.be/PuEGl4pHkjU', NULL, '1724108400', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;Neste dia, trabalharemos na definição do propósito e&lt;/p&gt;&lt;p&gt;valores da marca, criaremos o documento mestre e&lt;/p&gt;&lt;p&gt;alinharemos a identidade visual e a linguagem da marca&lt;/p&gt;&lt;p&gt;para garantir uma comunicação consistente e eficaz.&lt;/p&gt;', '0', '2', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('203', 'PASSO A PASSO PARA CRIAR O BRANDING DE MARCA EM 1 DIA', NULL, '5', '63', NULL, NULL, NULL, NULL, '1724108400', NULL, 'other', '7cd482c549822d3f240c27bf66ac3935.pdf', 'pdf', NULL, '&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://docs.google.com/document/d/1yqY4QBh0LHBOJxKtdAm09WOuPMbKPf-olWqpXxMKVp8/edit?usp=sharing&quot; target=&quot;_blank&quot;&gt;https://docs.google.com/document/d/1yqY4QBh0LHBOJxKtdAm09WOuPMbKPf-olWqpXxMKVp8/edit?usp=sharing&lt;/a&gt;&lt;br&gt;&lt;/p&gt;', '0', '3', '0', NULL, NULL, NULL), ('204', 'CAMINHO DO CRESCIMENTO COM I.A E ESPIRITUALIDADE', NULL, '5', '41', NULL, NULL, NULL, NULL, '1724108400', '1724108400', 'other', '33b270253725d0fc335de7fde3a5d83c.png', 'img', NULL, '&lt;p class=&quot;p1&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;Esta timeline foi criada para orientar-vos no processo de expansão do vosso negócio terapêutico. Vamos juntos percorrer estes passos para alcançar o sucesso.&lt;/p&gt;&lt;p class=&quot;p2&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);=&quot;&quot; min-height:=&quot;&quot; 15px;&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;Passo 1: Descoberta e Planeamento&lt;/p&gt;&lt;p class=&quot;p1&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;O primeiro passo é fundamental para definir o vosso posicionamento. Agendem a vossa sessão individual de posicionamento o mais rapidamente possível para avançarem nos próximos passos com clareza e confiança. Analise as suas competências, crie um método exclusivo de bem-estar e defina o seu nicho e público-alvo. Adote técnicas de gestão de tempo para garantir produtividade e eficácia.&lt;/p&gt;&lt;p class=&quot;p2&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);=&quot;&quot; min-height:=&quot;&quot; 15px;&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;Passo 2: Identidade e Conexão&lt;/p&gt;&lt;p class=&quot;p1&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;Com o posicionamento definido, é hora de desenvolver a identidade visual da vossa marca, incluindo logotipo, missão, visão e valores. Estruture um plano de conteúdos para as redes sociais e selecione as plataformas mais adequadas para se conectar com o vosso público. Não se esqueçam de integrar práticas de autocuidado na vossa rotina para manter o equilíbrio e bem-estar.&lt;/p&gt;&lt;p class=&quot;p2&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);=&quot;&quot; min-height:=&quot;&quot; 15px;&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;Passo 3: Atrair e Converter&lt;/p&gt;&lt;p class=&quot;p1&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;Neste passo, vamos implementar estratégias de tráfego, funis de vendas e campanhas de anúncios (pagos e orgânicos) para atrair e converter clientes. Monitorizem continuamente os resultados e façam ajustes necessários para otimizar a performance. Estabeleçam limites claros entre o trabalho e a vida pessoal para manter a saúde mental e a produtividade.&lt;/p&gt;&lt;p class=&quot;p2&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);=&quot;&quot; min-height:=&quot;&quot; 15px;&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;Passo 4: Analisar e Ajustar&lt;/p&gt;&lt;p class=&quot;p1&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;A análise de métricas é essencial para entender o desempenho das vossas estratégias. Recolham feedback dos clientes para identificar pontos de melhoria e implementem ajustes estratégicos baseados nesses dados. Esta etapa contínua garantirá que estão sempre a melhorar e a adaptar-se às necessidades do mercado.&lt;/p&gt;&lt;p class=&quot;p2&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);=&quot;&quot; min-height:=&quot;&quot; 15px;&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;Passo 5: Conectar e Crescer&lt;/p&gt;&lt;p class=&quot;p1&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;Finalmente, conectem-se com outros profissionais e participem em comunidades de suporte. Participe em eventos, forme parcerias e envolva-se em grupos que favoreçam a sua expanção. Utilize o feedback obtido para um crescimento contínuo e sustentável do vosso negócio.&lt;/p&gt;&lt;p class=&quot;p2&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);=&quot;&quot; min-height:=&quot;&quot; 15px;&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; helvetica=&quot;&quot; neue&quot;;=&quot;&quot; color:=&quot;&quot; rgb(0,=&quot;&quot; 0,=&quot;&quot; 0);&quot;=&quot;&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-variant-position: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 13px; line-height: normal;&quot;&gt;Agendem a vossa sessão inicial de posicionamento para dar o primeiro passo nesta jornada de crescimento e transformação. Estamos aqui para apoiar-vos em cada etapa do caminho!&lt;/p&gt;', '0', '5', '0', NULL, NULL, NULL), ('205', 'LINK BOOTCAMP AO VIVO ', NULL, '5', '63', NULL, NULL, NULL, NULL, '1724108400', '1724281200', 'text', '&lt;p&gt;DE 19/08 A 23/08 ÁS 20H PT:&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://meet.google.com/zqk-scez-poi&quot; target=&quot;_blank&quot;&gt;https://meet.google.com/zqk-scez-poi&lt;/a&gt;&lt;a href=&quot;https://meet.google.com/zqk-scez-poi&quot; target=&quot;_blank&quot; style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;&lt;/a&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;text-align: center;margin-top:0pt;margin-bottom:0pt;&quot;&gt;&lt;span style=&quot;font-size:14.5pt;font-family:&#039;Playfair Display&#039;,serif;color:#9900ff;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Considerações Importantes para Tirar o Máximo Proveito do Bootcamp&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;b style=&quot;font-weight:normal;&quot; id=&quot;docs-internal-guid-09b81cf6-7fff-100d-5be6-6bcf3edb2c18&quot;&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.38;margin-top:0pt;margin-bottom:0pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Bem-vindas ao nosso bootcamp! Esta jornada é uma oportunidade única para expandir as vossas competências e transformar o vosso negócio de bem-estar. Para garantir que retiram o máximo benefício de cada sessão&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:#00ffff;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;, seguem algumas considerações fundamentais para o vosso sucesso:&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;b style=&quot;font-weight:normal;&quot;&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;1.&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Reserve o Horário das 20h às 22h Exclusivamente para o Bootcamp&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Este é o momento em que estaremos juntas, a colocar a teoria em prática e a desenvolver atividades concretas. Participar em tempo real permitirá que recebam apoio imediato, tirem dúvidas na hora e beneficiem da energia coletiva do grupo.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;2.&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Crie um Espaço Tranquilo e Livre de Interrupções&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Para quem trabalha a partir de casa, é essencial comunicar aos familiares que este horário é dedicado ao vosso desenvolvimento profissional. Peçam gentilmente para não serem interrompidas, garantindo um ambiente propício à concentração e ao aprendizado.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;3.&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Preparem-se Antecipadamente&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Certifiquem-se, com antecedência, de que têm todo o material necessário e que a vossa ligação à internet está estável. Isto evita imprevistos e permite que participem de forma plena.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;4.&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Tenham em Mente os Vossos Objetivos Pessoais e Profissionais&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Antes de cada sessão, reflitam sobre os objetivos que desejam alcançar. Isto ajudará a manter o foco e a aplicar o conteúdo diretamente às vossas necessidades específicas.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;5.&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Participação Ativa e Envolvimento&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Contribuam nas discussões, partilhem as vossas experiências e não hesitem em fazer perguntas. Quanto mais se envolverem, mais rica será a troca de conhecimento, e maior será a aprendizagem.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;6.&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Apliquem o Conhecimento em Tempo Real&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Durante as sessões práticas, aproveitem para implementar imediatamente o que está a ser ensinado. Esta prática direta facilita a assimilação do conteúdo e acelera o vosso progresso.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;7.&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Acompanhem as Atividades Complementares&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Entre as sessões, reservem algum tempo para rever os materiais fornecidos e realizar as tarefas propostas. Estas atividades extras reforçam a aprendizagem e garantem que estejam sempre um passo à frente.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;8.&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Mantenham uma Mente Aberta e Receptiva&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Este bootcamp será intenso e, por vezes, desafiante. Encarem cada sessão com uma atitude positiva e dispostas a experimentar novas técnicas e abordagens.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;9.&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Aproveitem a Comunidade e o Apoio&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Este bootcamp não é apenas um curso, mas uma oportunidade para construir uma rede de apoio. Conectem-se com outras mentoradas, troquem experiências e incentivem-se umas às outras.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 23pt;text-indent: -22pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 22pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;10.&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:&#039;Times New Roman&#039;,serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Cuidem do Vosso Bem-estar&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: O equilíbrio entre aprendizagem e descanso é crucial. Garantam que, após cada sessão, têm tempo para relaxar e assimilar as informações. Um corpo e mente descansados são fundamentais para a produtividade.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;b style=&quot;font-weight:normal;&quot;&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-top:0pt;margin-bottom:0pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#ff00ff;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Benefícios de Participar no Bootcamp&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#ff00ff;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;:&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 10pt;text-indent: -10pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 10pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;•&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Crescimento Acelerado&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: As estratégias ensinadas são direcionadas para duplicar os vossos rendimentos em apenas 6 meses, utilizando tecnologias emergentes e práticas de gestão eficazes.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 10pt;text-indent: -10pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 10pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;•&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Apoio Personalizado&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: A oportunidade de receber feedback em tempo real e ajustar o vosso progresso de imediato é inestimável.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 10pt;text-indent: -10pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 10pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;•&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Ambiente Colaborativo&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: A ligação com outros profissionais do bem-estar que estão na mesma jornada proporciona um sentido de comunidade e pertença, essenciais para o crescimento.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 10pt;text-indent: -10pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 10pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;•&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Desenvolvimento Pessoal e Profissional&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Não só aprimorarão as vossas competências técnicas, mas também crescerão emocionalmente, superando bloqueios e expandindo a visão do vosso negócio.&lt;/span&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-left: 10pt;text-indent: -10pt;margin-top:0pt;margin-bottom:0pt;padding:0pt 0pt 0pt 10pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;•&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space:pre;&quot;&gt;	&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Ferramentas e Técnicas Modernas&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Aprenderão a utilizar ferramentas de IA e marketing digital que estão a transformar o mercado, preparando-vos para o futuro do bem-estar.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;/p&gt;&lt;p dir=&quot;ltr&quot; style=&quot;line-height:1.7999999999999998;margin-top:0pt;margin-bottom:0pt;&quot;&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;Conclusão&lt;/span&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;: Participar neste bootcamp é um compromisso convosco mesmas e com o vosso futuro profissional. Preparando-se adequadamente e participando ativamente, garantirão que este seja um dos investimentos mais valiosos na vossa carreira. Estamos juntas nesta jornada!&lt;/span&gt;&lt;/p&gt;&lt;div&gt;&lt;span style=&quot;font-size:11.5pt;font-family:Arial,sans-serif;color:#0e0e0e;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', 'description', NULL, '', '0', '1', '0', NULL, NULL, NULL), ('206', 'CRIANDO CONTEÚDO EM CANVA EM 1 DIA', '01:49:03', '5', '63', 'youtube', NULL, 'https://youtu.be/S4FPcrliFH4', NULL, '1724194800', NULL, 'video', NULL, 'url', NULL, '&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; font-size: 12px; line-height: normal; font-family: Helvetica; color: rgb(0, 0, 0);&quot;&gt;Exploraremos o Canva, aprenderemos a criar designs atrativos para posts e stories, desenvolveremos modelos para diversos tipos de conteúdo, e praticaremos a criação de posts específicos para Instagram e&lt;/p&gt;', '0', '4', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('207', 'PROMPT CHATGPT PARA CANVA', NULL, '5', '63', NULL, NULL, NULL, NULL, '1724194800', NULL, 'other', '45f6b3df1af841b474665f453d4fa9e4.pdf', 'pdf', NULL, '', '0', '5', '0', NULL, NULL, NULL), ('208', 'OTIMIZAÇÃO DE INSTAGRAM E FACEBOOK', '01:43:45', '5', '63', 'youtube', NULL, 'https://youtu.be/hVhBGHWWvFI', NULL, '1724281200', NULL, 'video', NULL, 'url', NULL, '&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; font-size: 12px; line-height: normal; font-family: Helvetica; color: rgb(0, 0, 0);&quot;&gt;O Foco será otimizar as biografias e perfis, implementar estratégias de engajamento, planejar e organizar o feed, além de utilizar Stories e Reels para aumentar a audiência e interação com o publico.&lt;/p&gt;', '0', '6', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('209', 'COMO LIDAR COM A RESISTÊNCIA AO EMPREENDER NO DIGITAL', '00:14:40', '5', '43', 'youtube', NULL, 'https://youtu.be/z858enSyCxs', NULL, '1724281200', NULL, 'video', NULL, 'url', NULL, '', '0', '6', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('210', 'WHATSAPP BUSINESS', '00:31:07', '5', '63', 'youtube', NULL, 'https://youtu.be/o9FOM1B0S_w', NULL, '1724281200', NULL, 'video', NULL, 'url', NULL, '&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; font-size: 12px; line-height: normal; font-family: Helvetica; color: rgb(0, 0, 0);&quot;&gt;&lt;span style=&quot;font-family: Nunito;&quot;&gt;Abordaremos a configuração e uso eficaz do WhatsApp Business, criaremos catálogos de produtos/serviços.&lt;/span&gt;&lt;/p&gt;', '0', '7', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('211', 'LINKEDIN', '00:31:07', '5', '63', 'youtube', NULL, 'https://youtu.be/Ric5d4jTnNw', NULL, '1724281200', NULL, 'video', NULL, 'url', NULL, '&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; font-size: 12px; line-height: normal; font-family: Helvetica; color: rgb(0, 0, 0);&quot;&gt;&lt;span style=&quot;font-family: Nunito;&quot;&gt;Otimizaremos o perfil no Linkedin e desenvolveremos estratégias de networking e prospecção de clientes.&lt;/span&gt;&lt;/p&gt;', '0', '8', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('213', 'TIKTOK', '01:46:05', '5', '63', 'youtube', NULL, 'https://youtu.be/BEVQ0OZ-urI', NULL, '1724454000', NULL, 'video', NULL, 'url', NULL, '&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; font-size: 12px; line-height: normal; font-family: Helvetica; color: rgb(0, 0, 0);&quot;&gt;&lt;span style=&quot;font-family: Nunito;&quot;&gt;Aprenderemos sobre o uso do TikTok para negócios, desenvolveremos estratégias para criar conteúdo curto e viral, utilizaremos tendências e hashtags, e analisaremos o desempenho dos vídeos para realizar ajustes estratégicos.&lt;/span&gt;&lt;span style=&quot;font-family: Nunito;&quot;&gt;﻿&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; font-size: 12px; line-height: normal; color: rgb(0, 0, 0);&quot;&gt;&lt;font face=&quot;Nunito&quot;&gt;MAPA MENTAL UTILIZADO NA AULA:&amp;nbsp;&lt;/font&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal;&quot;&gt;&lt;font color=&quot;#000000&quot; face=&quot;Helvetica&quot;&gt;&lt;span style=&quot;font-size: 12px;&quot;&gt;&lt;a href=&quot;ttps://mm.tt/app/map/3395989780?t=L0QCH5hdeW&quot; target=&quot;_blank&quot;&gt;https://mm.tt/app/map/3395989780?t=L0QCH5hdeW&lt;/a&gt;&lt;/span&gt;&lt;/font&gt;&lt;/p&gt;', '0', '9', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('215', 'MEDITAÇÃO ANGELICAL: ENERGIA DE VALOR/CHAKRA SEXUAL', '00:34:47', '5', '43', 'youtube', NULL, 'https://youtu.be/TTSmB3eTyzo', NULL, '1724972400', NULL, 'video', NULL, 'url', NULL, '', '0', '2', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('216', 'ENCONTRO TIRA DÚVIDAS BOOTCAMP', '01:35:05', '5', '47', 'youtube', NULL, 'https://youtu.be/FOPiko1njac', NULL, '1724972400', NULL, 'video', NULL, 'url', NULL, '', '0', '12', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('217', 'COMO CRIAR MULTIPLOS VIDEOS EM MINUTOS', '00:35:39', '5', '51', 'youtube', NULL, 'https://youtu.be/83ya66MYzss', NULL, '1726095600', NULL, 'video', NULL, 'url', NULL, '&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;O Opus Clip é uma ferramenta de inteligência artificial que ajuda a transformar vídeos longos em pequenos clipes otimizados para redes sociais. Para profissionais de bem-estar, como terapeutas e mentores, esta ferramenta é uma excelente forma de economizar tempo e aumentar a visibilidade online.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14); min-height: 17px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;Ao utilizar o Opus Clip, podemos pegar vídeos de palestras, lives, ou mesmo sessões gravadas (com consentimento, claro!) e gerar trechos curtos e atrativos que destacam as mensagens mais importantes. Estes clipes são ideais para postar no Instagram, TikTok, YouTube, ou outras plataformas, aumentando o alcance da nossa mensagem sem precisar gastar horas a editar vídeos manualmente.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14); min-height: 17px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;Os principais benefícios para nós, profissionais do bem-estar, incluem:&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14); min-height: 17px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p3&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 13px; text-indent: -13px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space: pre;&quot;&gt;	&lt;/span&gt;•&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space: pre;&quot;&gt;	&lt;/span&gt;&lt;b&gt;Maior eficiência&lt;/b&gt;: A IA seleciona automaticamente as melhores partes do vídeo, poupando-nos tempo de edição.&lt;/p&gt;&lt;p class=&quot;p3&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 13px; text-indent: -13px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space: pre;&quot;&gt;	&lt;/span&gt;•&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space: pre;&quot;&gt;	&lt;/span&gt;&lt;b&gt;Conteúdo envolvente&lt;/b&gt;: Gera vídeos curtos que captam a atenção do público rapidamente, ideais para redes sociais.&lt;/p&gt;&lt;p class=&quot;p3&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 13px; text-indent: -13px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space: pre;&quot;&gt;	&lt;/span&gt;•&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space: pre;&quot;&gt;	&lt;/span&gt;&lt;b&gt;Mais alcance e impacto&lt;/b&gt;: Com publicações regulares e atraentes, podemos atingir mais pessoas que precisam do nosso trabalho.&lt;/p&gt;&lt;p class=&quot;p3&quot; style=&quot;margin-right: 0px; margin-left: 13px; text-indent: -13px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space: pre;&quot;&gt;	&lt;/span&gt;•&lt;span class=&quot;Apple-tab-span&quot; style=&quot;white-space: pre;&quot;&gt;	&lt;/span&gt;&lt;b&gt;Facilidade de uso&lt;/b&gt;: Não precisa de habilidades técnicas para usar o Opus Clip, o que torna a ferramenta acessível a qualquer pessoa.&lt;/p&gt;', '0', '1', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('218', 'COMO VENDER DE FORMA ORGÂNICA?', '01:12:45', '5', '44', 'youtube', NULL, 'https://youtu.be/Ad-9ic1JViU', NULL, '1726095600', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;&lt;font color=&quot;#3c3838&quot; face=&quot;Inter, sans-serif&quot; size=&quot;3&quot;&gt;&lt;span style=&quot;white-space: pre;&quot;&gt;Apresentação:&lt;/span&gt;&lt;/font&gt;&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://gamma.app/docs/4-Funis-de-Vendas-Simples-para-Executar-em-5-Passos-l94buetefqbhz0m&quot; target=&quot;_blank&quot; style=&quot;font-family: Inter, sans-serif; font-size: medium; white-space: pre; background-color: rgb(255, 255, 255);&quot;&gt;https://gamma.app/docs/4-Funis-de-Vendas-Simples-para-Executar-em-5-Passos-l94buetefqbhz0m&lt;/a&gt;&lt;br&gt;&lt;/p&gt;', '0', '1', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('219', 'COMO CRIAR COPY QUE CONVERTE EM 5 PASSOS SIMPLES', '01:16:10', '5', '47', 'youtube', NULL, 'https://youtu.be/l_XYBTMIpqY', NULL, '1727305200', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;Apresentação da aula para baixar clica no link:&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://drive.google.com/file/d/1Z_hPGq9kmM9rsAy-AopcIy-IzeDK9k2b/view?usp=sharing&quot; target=&quot;_blank&quot;&gt;https://drive.google.com/file/d/1Z_hPGq9kmM9rsAy-AopcIy-IzeDK9k2b/view?usp=sharing&lt;/a&gt;&lt;br&gt;&lt;/p&gt;', '0', '2', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('221', 'ASSISTENTE I.A PARA GERAR CONTEÚDO REDES SOCIAIS', NULL, '5', '48', NULL, NULL, NULL, NULL, '1728514800', NULL, 'text', '&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;&lt;b&gt;Explora a Criação de Conteúdos com a IA!&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14); min-height: 17px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;Disponibilizamos aqui uma ferramenta incrível para otimizar a tua presença digital: &lt;b&gt;o Chatbot de Inteligência Artificial. &lt;/b&gt;Desenvolvido especialmente para empreendedoras da área de terapias e desenvolvimento pessoal, este chatbot é o teu parceiro ideal na criação de conteúdos envolventes e estratégicos para redes sociais.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14); min-height: 17px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;Com ele, terás acesso a ideias de publicações, sugestões de títulos que captam a atenção e dicas para aumentar o envolvimento, tudo adaptado ao teu nicho. O nosso chatbot ajuda a transformar as tuas ideias em conteúdos alinhados com os teus objetivos de marketing, deixando-te mais tempo livre para o que realmente importa: atender os teus clientes e expandir o teu impacto.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14); min-height: 17px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;Experimenta já e descobre como a inteligência artificial pode revolucionar a tua comunicação digital, ajudando-te a destacar-te e a conectar-te ainda mais com a tua audiência!&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14); min-height: 17px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;Se quiseres ajustar algo específico, diz-me!&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;&lt;b&gt;Entra aqui e começa a gerar conteúdo em segundos:&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal;&quot;&gt;&lt;font color=&quot;#0e0e0e&quot; face=&quot;.SF NS&quot;&gt;&lt;a href=&quot;https://chatgpt.com/g/g-GRj5NIKF4-assistente-de-redes-sociais&quot; target=&quot;_blank&quot; style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;https://chatgpt.com/g/g-GRj5NIKF4-assistente-de-redes-sociais&lt;/a&gt;&lt;/font&gt;&lt;br&gt;&lt;/p&gt;', 'description', NULL, '', '0', '5', '0', NULL, NULL, NULL), ('223', '2. TRAFEGO PAGO PERSONA', '01:19:00', '5', '44', 'youtube', NULL, 'https://youtu.be/i_thH_Ktc98', NULL, '1729033200', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;Reflexão sobre Persona&amp;nbsp;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;https://drive.google.com/file/d/1ZHfsRJbn57zRof_nWJTiUcaYibCB4asa/view?usp=sharing&lt;/span&gt;&lt;br&gt;&lt;/p&gt;', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('224', '1. TRAFEGO PAGO, O BASICO', '03:03:04', '5', '44', 'youtube', NULL, 'https://youtu.be/MK3OpTzRdpI', NULL, '1729033200', NULL, 'video', NULL, 'url', NULL, '&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; font-size: 13px; line-height: normal; font-family: &amp;quot;Helvetica Neue&amp;quot;; color: rgb(0, 0, 0);&quot;&gt;Na aula de Tráfego Pago, conduzida por Washington, os alunos mergulharam nos primeiros passos essenciais para dominar as vendas no ambiente digital. Washington explicou como criar campanhas eficazes que capturam a atenção do público-alvo, destacando as melhores práticas para usar ferramentas como o Facebook Ads e o Google Ads. Os participantes aprenderam a segmentar corretamente os anúncios, definir orçamentos e monitorar os resultados, tudo de forma prática e acessível. Essa aula foi uma excelente introdução ao mundo do tráfego pago, proporcionando uma base sólida para quem deseja expandir sua presença digital e atrair mais clientes.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; font-size: 13px; line-height: normal; font-family: &amp;quot;Helvetica Neue&amp;quot;; color: rgb(0, 0, 0); min-height: 15px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; font-size: 13px; line-height: normal; font-family: &amp;quot;Helvetica Neue&amp;quot;; color: rgb(0, 0, 0);&quot;&gt;Tarefa 1&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; font-size: 13px; line-height: normal; font-family: &amp;quot;Helvetica Neue&amp;quot;; color: rgb(0, 0, 0); min-height: 15px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p3&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; font-size: 13px; line-height: normal; font-family: &amp;quot;Helvetica Neue&amp;quot;; color: rgb(31, 107, 192);&quot;&gt;https://drive.google.com/file/d/1N6TK4Owplv3nuRK-dgQ38VTGaySCjXl8/view?usp=sharing&lt;/p&gt;', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('225', 'VENCENDO O MEDO DE GRAVAR VIDEOS', '00:13:31', '5', '43', 'youtube', NULL, 'https://youtu.be/3hLXPhPGFfU', NULL, '1729206000', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;&lt;span style=&quot;color: rgb(0, 0, 0); font-size: 0.875rem;&quot;&gt;Superar o medo de gravar vídeos é um passo essencial para fortalecer a tua presença online e conectar-te de forma autêntica com o teu público. Nesta aula, abordamos estratégias práticas para vencer essa barreira, aumentar a confiança em frente às câmaras e criar conteúdos que realmente transmitam a tua mensagem. Se sentes insegurança ou receio de te expor em vídeos, este conteúdo é para ti! Vamos juntos superar esses desafios e transformar a forma como te comunicas e atrais clientes.&lt;/span&gt;&lt;/p&gt;&lt;div class=&quot;flex-shrink-0 flex flex-col relative items-end&quot;&gt;&lt;div class=&quot;pt-0&quot;&gt;&lt;div class=&quot;gizmo-shadow-stroke flex h-8 w-8 items-center justify-center overflow-hidden rounded-full&quot;&gt;&lt;div class=&quot;h-full w-full&quot;&gt;&lt;div class=&quot;gizmo-shadow-stroke overflow-hidden rounded-full&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;p&gt;ROTEIRO DE VIDEOS TAREFAS PARA SUPERAR O MEDO DE GRAVAR VIDEOS&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;https://drive.google.com/file/d/1cFcwB7I96FSulbgl-Vh85KEjUliYpSyD/view?usp=sharing&quot; target=&quot;_blank&quot;&gt;https://drive.google.com/file/d/1cFcwB7I96FSulbgl-Vh85KEjUliYpSyD/view?usp=sharing&lt;/a&gt;&lt;span style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;br&gt;&lt;/p&gt;', '0', '3', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('226', 'AUTOMATIZAÇÕES NO NEGÓCIO DE BEM-ESTAR', '00:01:06', '5', '48', 'youtube', NULL, 'https://youtu.be/YrZhuTJ6ka8', NULL, '1729551600', NULL, 'video', NULL, 'url', NULL, '&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;Na aula da Dália, foi abordada a importância da &lt;b&gt;IA e automação&lt;/b&gt; como ferramentas para transformar e otimizar a prática terapêutica, liberando tempo e energia para um atendimento mais humano e profundo. Através da sua jornada, desde a &lt;b&gt;odontologia até à terapia&lt;/b&gt;, Dália partilhou como a automação pode simplificar processos, como o &lt;b&gt;agendamento de consultas&lt;/b&gt;, respostas a perguntas frequentes e &lt;b&gt;interações iniciais com pacientes&lt;/b&gt;. Ferramentas como &lt;b&gt;Calendly&lt;/b&gt;, &lt;b&gt;WhatsApp Business&lt;/b&gt; e &lt;b&gt;ManyChat&lt;/b&gt; foram citadas como soluções práticas para automatizar e agilizar o atendimento.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14); min-height: 17px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;Ela também destacou a importância de &lt;b&gt;estruturar a presença nas redes sociais&lt;/b&gt;, escolhendo as plataformas certas e utilizando formatos como &lt;b&gt;reels&lt;/b&gt;, &lt;b&gt;carrosséis&lt;/b&gt; e &lt;b&gt;cópias estratégicas&lt;/b&gt; para aumentar o &lt;b&gt;engajamento e conversão&lt;/b&gt;. Além disso, sublinhou como a &lt;b&gt;automação&lt;/b&gt; não só melhora a eficiência, mas também cria uma experiência de venda &lt;b&gt;humanizada&lt;/b&gt; e acolhedora, reforçada por depoimentos e uma conexão genuína com os clientes.&lt;/p&gt;&lt;p class=&quot;p2&quot; style=&quot;margin-right: 0px; margin-bottom: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14); min-height: 17px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;p1&quot; style=&quot;margin-right: 0px; margin-left: 0px; font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-stretch: normal; line-height: normal; font-family: &amp;quot;.SF NS&amp;quot;; color: rgb(14, 14, 14);&quot;&gt;Por fim, incentivou as mentoradas a adotarem a automação como aliada para alcançar &lt;b&gt;mais leveza e recompensa&lt;/b&gt; na prática, criando um espaço digital e físico mais centrado no &lt;b&gt;bem-estar&lt;/b&gt; dos pacientes.&lt;/p&gt;', '0', '0', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('227', 'ENCONTRO TIRA-DÚVIDA', '01:25:13', '5', '47', 'youtube', NULL, 'https://youtu.be/AYqJPx5kkTw', NULL, '1729724400', NULL, 'video', NULL, 'url', NULL, '', '0', '1', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10'), ('228', 'MEDITAÇÃO ANGELICAL PARA DESBLOQUEAR O RECEBER', '00:33:23', '5', '43', 'youtube', NULL, 'https://youtu.be/COkKu_5AP90', NULL, '1729724400', NULL, 'video', NULL, 'url', NULL, '&lt;p&gt;A Meditação Angelical para Abrir o Receber é uma prática suave e poderosa que nos conecta com a energia dos anjos, abrindo o coração e a mente para receber abundância, amor e bênçãos. Ao nos sintonizarmos com a vibração angelical, liberamos bloqueios e permitimos que o fluxo de luz divina nos guie e preencha com tudo o que precisamos. Prepare-se para se conectar com sua essência mais elevada e abrir-se para o receber de maneira profunda e transformadora.&lt;br&gt;&lt;/p&gt;', '0', '4', '0', 'html5', 'https://www.html5rocks.com/en/tutorials/video/basics/devstories.webm', '00:01:10');
DROP TABLE IF EXISTS `live_class`;
CREATE TABLE `live_class` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `course_id` int(11) DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `zoom_meeting_id` varchar(255) DEFAULT NULL,
  `zoom_meeting_password` varchar(255) DEFAULT NULL,
  `meeting_invite_link` varchar(255) DEFAULT NULL,
  `note_to_students` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
INSERT INTO `live_class` (`id`, `course_id`, `date`, `time`, `zoom_meeting_id`, `zoom_meeting_password`, `meeting_invite_link`, `note_to_students`) VALUES ('1', '1', '1717542000', '1717595532', '', '', NULL, ''), ('2', '2', '1717542000', '1717620061', '', '', NULL, ''), ('3', '3', '1722380400', '1720650962', '2024', '12345', NULL, 'teste de aula'), ('4', '4', '1717628400', '1717631074', '', '', NULL, ''), ('5', '5', '-3600', '1724976000', '', '', NULL, ''), ('6', '6', '1720998000', '1721052872', '', '', NULL, ''), ('7', '7', '1720998000', '1721068260', '', '', NULL, '');
DROP TABLE IF EXISTS `log`;
CREATE TABLE `log` (
  `id` int(11) NOT NULL,
  `from` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `message`;
CREATE TABLE `message` (
  `message_id` int(20) NOT NULL AUTO_INCREMENT,
  `message_thread_code` varchar(255) DEFAULT NULL,
  `message` longtext DEFAULT NULL,
  `sender` int(20) DEFAULT NULL,
  `receiver` int(20) DEFAULT NULL,
  `timestamp` varchar(255) DEFAULT NULL,
  `read_status` int(11) DEFAULT NULL,
  PRIMARY KEY (`message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `message_thread`;
CREATE TABLE `message_thread` (
  `message_thread_id` int(11) NOT NULL AUTO_INCREMENT,
  `message_thread_code` varchar(255) DEFAULT NULL,
  `sender` varchar(255) DEFAULT '',
  `receiver` varchar(255) DEFAULT '',
  `last_message_timestamp` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`message_thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `newsletter_histories`;
CREATE TABLE `newsletter_histories` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `tried_times` int(11) DEFAULT NULL,
  `sent_at` varchar(100) DEFAULT NULL,
  `created_at` varchar(100) DEFAULT NULL,
  `updated_at` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `newsletter_subscriber`;
CREATE TABLE `newsletter_subscriber` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `created_at` varchar(255) DEFAULT NULL,
  `updated_at` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `newsletter_subscriber` (`id`, `email`, `created_at`, `updated_at`) VALUES ('1', 'curaquantica13@gmail.com', '1718314707', NULL);
DROP TABLE IF EXISTS `newsletters`;
CREATE TABLE `newsletters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` varchar(255) DEFAULT NULL,
  `updated_at` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `noticeboard`;
CREATE TABLE `noticeboard` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `course_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `date_added` varchar(255) DEFAULT NULL,
  `date_updated` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `notification_settings`;
CREATE TABLE `notification_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `is_editable` int(11) DEFAULT NULL,
  `addon_identifier` varchar(255) DEFAULT NULL,
  `user_types` varchar(400) DEFAULT NULL,
  `system_notification` varchar(400) DEFAULT NULL,
  `email_notification` varchar(400) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `setting_title` varchar(255) DEFAULT NULL,
  `setting_sub_title` varchar(255) DEFAULT NULL,
  `date_updated` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `notification_settings` (`id`, `type`, `is_editable`, `addon_identifier`, `user_types`, `system_notification`, `email_notification`, `subject`, `template`, `setting_title`, `setting_sub_title`, `date_updated`) VALUES ('1', 'signup', '1', NULL, '[\"admin\",\"user\"]', '{\"admin\":\"1\",\"user\":\"1\"}', '{\"admin\":\"1\",\"user\":\"1\"}', '{\"admin\":\"Novo usu\\u00e1rio cadastrado\",\"user\":\"Registrado com sucesso\"}', '{\"admin\":\"Novo usu\\u00e1rio cadastrado [user_name] \\r\\n<br>E-mail do usu\\u00e1rio: <b>[user_email]<\\/b>\",\"user\":\"Voc\\u00ea se registrou com sucesso conosco em [system_name].\"}', 'New user registration', 'Get notified when a new user signs up', '1719236362'), ('2', 'email_verification', '0', NULL, '[\"user\"]', '{\"user\":\"0\"}', '{\"user\":\"1\"}', '{\"user\":\"C\\u00f3digo de verifica\\u00e7\\u00e3o de e-mail\"}', '{\"user\":\"Voc\\u00ea recebeu um c\\u00f3digo de verifica\\u00e7\\u00e3o por e-mail. Seu c\\u00f3digo de verifica\\u00e7\\u00e3o \\u00e9 [email_verification_code]\"}', 'Email verification', 'It is permanently enabled for student email verification.', '1684135777'), ('3', 'forget_password_mail', '0', NULL, '[\"user\"]', '{\"user\":\"0\"}', '{\"user\":\"1\"}', '{\"user\":\"Esqueci o c\\u00f3digo de verifica\\u00e7\\u00e3o de senha\"}', '{\"user\":\"Voc\\u00ea recebeu um c\\u00f3digo de verifica\\u00e7\\u00e3o por e-mail. Seu c\\u00f3digo de verifica\\u00e7\\u00e3o \\u00e9 [system_name] [verification_link] [minutes]\"}', 'Forgot password mail', 'It is permanently enabled for student email verification.', '1684145383'), ('4', 'new_device_login_confirmation', '0', NULL, '[\"user\"]', '{\"user\":\"0\"}', '{\"user\":\"1\"}', '{\"user\":\"Por favor confirme seu login\"}', '{\"user\":\"Voc\\u00ea j\\u00e1 tentou fazer login com um dispositivo diferente? Confirme usando o c\\u00f3digo de verifica\\u00e7\\u00e3o. Seu c\\u00f3digo de verifica\\u00e7\\u00e3o \\u00e9 [verification_code]. Lembre-se de que voc\\u00ea perder\\u00e1 o acesso ao seu dispositivo anterior ap\\u00f3s fazer login no novo dispositivo <b>[user_agent]<\\/b>.<br> Use o c\\u00f3digo de verifica\\u00e7\\u00e3o em [minutos] minutos\"}', 'Account security alert', 'Send verification code for login from a new device', '1684145383'), ('6', 'course_purchase', '1', NULL, '[\"admin\",\"student\",\"instructor\"]', '{\"admin\":\"1\",\"student\":\"1\",\"instructor\":\"1\"}', '{\"admin\":\"1\",\"student\":\"1\",\"instructor\":\"1\"}', '{\"admin\":\" Um novo curso foi vendido\",\"instructor\":\" Um novo curso foi vendido\",\"student\":\"Voc\\u00ea comprou um novo curso\"}', '{\"admin\":\"<p>T\\u00edtulo do curso: [course_title]<\\/p><p>Aluno: [student_name]\\r\\n<\\/p><p>Valor pago: [paid_amount]<\\/p><p>Instrutor: [instructor_name]<\\/p>\",\"instructor\":\"T\\u00edtulo do curso: [course_title]\\r\\nAluno: [nome_aluno]\\r\\nValor pago: [paid_amount]\",\"student\":\"T\\u00edtulo do curso: [course_title]\\r\\nValor pago: [paid_amount]\\r\\nInstrutor: [nome_instrutor]\"}', 'Course purchase notification', 'Stay up-to-date on student course purchases.', '1719236395'), ('7', 'course_completion_mail', '1', NULL, '[\"student\",\"instructor\"]', '{\"student\":\"1\",\"instructor\":\"1\"}', '{\"student\":\"1\",\"instructor\":\"1\"}', '{\"instructor\":\"Course completion\",\"student\":\"You have completed a new course\"}', '{\"instructor\":\"Course completed [course_title]\\r\\nStudent: [student_name]\",\"student\":\"Course: [course_title]\\r\\nInstructor: [instructor_name]\"}', 'Course completion mail', 'Stay up to date on student course completion.', '1719236402'), ('8', 'certificate_eligibility', '1', 'certificate', '[\"student\",\"instructor\"]', '{\"student\":\"1\",\"instructor\":\"1\"}', '{\"student\":\"0\",\"instructor\":\"0\"}', '{\"instructor\":\"Elegibilidade do certificado\",\"student\":\"elegibilidade do certificado\"}', '{\"instructor\":\"Curso: [curso_t\\u00edtulo]\\r\\nAluno: [nome_aluno]\\r\\nLink do certificado: [certificate_link]\",\"student\":\"Curso: [curso_t\\u00edtulo]\\r\\nInstrutor: [nome_instrutor]\\r\\nLink do certificado: [certificate_link]\"}', 'Course eligibility notification', 'Stay up to date on course certificate eligibility.', '1684303460'), ('9', 'offline_payment_suspended_mail', '1', 'offline_payment', '[\"student\"]', '{\"student\":\"1\"}', '{\"student\":\"1\"}', '{\"student\":\" Seu pagamento foi suspenso\"}', '{\"student\":\"<p>Seu pagamento off-line foi <b xss=removed>suspenso<\\/b>!<\\/p><p>Forne\\u00e7a um documento v\\u00e1lido do seu pagamento.<\\/p>\"}', 'Offline payment suspended mail', 'If students provides fake information, notify them of the suspension', '1719236410'), ('10', 'bundle_purchase', '1', 'course_bundle', '[\"admin\",\"student\",\"instructor\"]', '{\"admin\":\"1\",\"student\":\"1\",\"instructor\":\"1\"}', '{\"admin\":\"1\",\"student\":\"1\",\"instructor\":\"1\"}', '{\"admin\":\"Um novo pacote de cursos foi vendido\",\"instructor\":\" Um novo pacote de cursos foi vendido\",\"student\":\"Voc\\u00ea comprou um novo teste de pacote de cursos\"}', '{\"admin\":\"Pacote de cursos: [bundle_title]\\r\\nAluno: [nome_aluno]\\r\\nInstrutor: [nome_instrutor]\",\"instructor\":\"Pacote de cursos: [bundle_title]\\r\\nAluno: [nome_aluno]\",\"student\":\"Pacote de cursos: [bundle_title]\\r\\nInstrutor: [nome_instrutor]\"}', 'Course bundle purchase notification', 'Stay up-to-date on student course bundle purchases.', '1719236425'), ('13', 'add_new_user_as_affiliator', '0', 'affiliate_course', '[\"affiliator\"]', '{\"affiliator\":\"0\"}', '{\"affiliator\":\"1\"}', '{\"affiliator\":\"Parab\\u00e9ns! Voc\\u00ea foi designado como afiliado\"}', '{\"affiliator\":\"Voc\\u00ea foi designado como afiliado do site.\\r\\nSite: [website_link]\\r\\n<br>\\r\\nSenha: [senha]\"}', 'New user added as affiliator', 'Send account information to the new user', '1684135777'), ('14', 'affiliator_approval_notification', '1', 'affiliate_course', '[\"affiliator\"]', '{\"affiliator\":\"1\"}', '{\"affiliator\":\"1\"}', '{\"affiliator\":\" Parab\\u00e9ns! Sua solicita\\u00e7\\u00e3o de afiliado foi aprovada\"}', '{\"affiliator\":\"Parab\\u00e9ns! Sua solicita\\u00e7\\u00e3o de afiliado foi aprovada\"}', 'Affiliate approval notification', 'Send affiliate approval mail to the user account', '1719236434'), ('15', 'affiliator_request_cancellation', '1', 'affiliate_course', '[\"affiliator\"]', '{\"affiliator\":\"1\"}', '{\"affiliator\":\"1\"}', '{\"affiliator\":\"Desculpe ! Sua solicita\\u00e7\\u00e3o foi recusada no momento\"}', '{\"affiliator\":\"Desculpe ! Seu pedido foi recusado no momento.\"}', 'Affiliator request cancellation', 'Send mail, when you cancel the affiliation request', '1719236439'), ('16', 'affiliation_amount_withdrawal_request', '1', 'affiliate_course', '[\"admin\",\"affiliator\"]', '{\"admin\":\"1\",\"affiliator\":\"1\"}', '{\"admin\":\"0\",\"affiliator\":\"0\"}', '{\"admin\":\" Nova solicita\\u00e7\\u00e3o de saque de dinheiro\",\"affiliator\":\" Nova solicita\\u00e7\\u00e3o de saque de dinheiro\"}', '{\"admin\":\"Nova solicita\\u00e7\\u00e3o de saque de dinheiro por [user_name] [amount]\",\"affiliator\":\"Sua solicita\\u00e7\\u00e3o de retirada de [quantia] foi enviada \\u00e0 autoridade\"}', 'Affiliation money withdrawal request', 'Send mail, when the users request the withdrawal of money', '1684303476'), ('17', 'approval_affiliation_amount_withdrawal_request', '1', 'affiliate_course', '[\"affiliator\"]', '{\"affiliator\":\"1\"}', '{\"affiliator\":\"0\"}', '{\"affiliator\":\"Parab\\u00e9ns! Sua solicita\\u00e7\\u00e3o de saque foi aprovada\"}', '{\"affiliator\":\"Parab\\u00e9ns! Sua solicita\\u00e7\\u00e3o de pagamento foi aprovada.\"}', 'Approval of withdrawal request of affiliation', 'Send mail, when you approved the affiliation withdrawal request', '1684303480'), ('18', 'course_gift', '1', NULL, '[\"payer\",\"receiver\"]', '{\"payer\":\"1\",\"receiver\":\"1\"}', '{\"payer\":\"1\",\"receiver\":\"1\"}', '{\"payer\":\"Voc\\u00ea presenteou um curso\",\"receiver\":\" Voc\\u00ea recebeu um presente de curso\"}', '{\"payer\":\"Voc\\u00ea presenteou um curso para [nome_do_usu\\u00e1rio] [t\\u00edtulo_do_curso][instrutor]\",\"receiver\":\"Voc\\u00ea recebeu um presente de curso de [payer][course_title][instructor]\"}', 'Course gift notification', 'Notify users after course gift', '1691818623'), ('20', 'noticeboard', '1', 'noticeboard', '[\"student\"]', '{\"student\":\"1\"}', '{\"student\":\"1\"}', '{\"student\":\" Quadro de Not\\u00edcias\"}', '{\"student\":\"Ol\\u00e1, voc\\u00ea tem um novo aviso de [instructor_name]. O curso [course_title] [notice_title][notice_description]\"}', 'Course Noticeboard', 'Notify to enrolled students when announcements are created by the instructor for a particular course.\n', '1699525375');
DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `from_user` int(11) DEFAULT NULL,
  `to_user` int(11) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `created_at` varchar(255) DEFAULT NULL,
  `updated_at` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `notifications` (`id`, `from_user`, `to_user`, `type`, `title`, `description`, `status`, `created_at`, `updated_at`) VALUES ('1', '1', '1', 'signup', 'New user registered', '\n    <div>New user registered Carolina De Marcos \r\n<br>User email: <b>dianademarcos1985@gmail.com</b></div>\n    ', '0', '1718813032', NULL), ('2', '1', '5', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at Academia Curaquantica13.</div>\n    ', '0', '1718813032', NULL), ('3', '1', '1', 'signup', 'Novo usuário cadastrado', '\n    <div>Novo usuário cadastrado Andreia  Sá \r\n<br>E-mail do usuário: <b>andysa1982@gmail.com</b></div>\n    ', '0', '1719230500', NULL), ('4', '1', '7', 'signup', 'Registrado com sucesso', '\n    <div>Você se registrou com sucesso conosco em Academia Curaquantica13.</div>\n    ', '1', '1719230500', NULL), ('5', '1', '1', 'signup', 'Novo usuário cadastrado', '\n    <div>Novo usuário cadastrado Patrícia  Nóbrega \r\n<br>E-mail do usuário: <b>cp.nobrega@gmail.com</b></div>\n    ', '0', '1719261172', NULL), ('6', '1', '10', 'signup', 'Registrado com sucesso', '\n    <div>Você se registrou com sucesso conosco em Academia Curaquantica13.</div>\n    ', '1', '1719261172', NULL), ('7', '1', '1', 'signup', 'Novo usuário cadastrado', '\n    <div>Novo usuário cadastrado Edite Pinto \r\n<br>E-mail do usuário: <b>editepinto21@hotmail.com</b></div>\n    ', '0', '1719321347', NULL), ('8', '1', '12', 'signup', 'Registrado com sucesso', '\n    <div>Você se registrou com sucesso conosco em Academia Curaquantica13.</div>\n    ', '1', '1719321347', NULL), ('9', '1', '1', 'signup', 'Novo usuário cadastrado', '\n    <div>Novo usuário cadastrado Washington Paula \r\n<br>E-mail do usuário: <b>wton2@hotmail.com</b></div>\n    ', '0', '1719496672', NULL), ('10', '1', '13', 'signup', 'Registrado com sucesso', '\n    <div>Você se registrou com sucesso conosco em Academia Curaquantica13.</div>\n    ', '0', '1719496672', NULL), ('11', '1', '1', 'signup', 'Novo usuário cadastrado', '\n    <div>Novo usuário cadastrado barbara Faria \r\n<br>E-mail do usuário: <b>carolinafreitas93@hotmail.com</b></div>\n    ', '0', '1721426225', NULL), ('12', '1', '14', 'signup', 'Registrado com sucesso', '\n    <div>Você se registrou com sucesso conosco em Academia Curaquantica13.</div>\n    ', '0', '1721426225', NULL), ('13', '1', '1', 'signup', 'Novo usuário cadastrado', '\n    <div>Novo usuário cadastrado Catarina Baeta \r\n<br>E-mail do usuário: <b>catarina.baeta@gmail.com</b></div>\n    ', '0', '1723314592', NULL), ('14', '1', '15', 'signup', 'Registrado com sucesso', '\n    <div>Você se registrou com sucesso conosco em Academia Curaquantica13.</div>\n    ', '0', '1723314593', NULL), ('15', '1', '1', 'signup', 'Novo usuário cadastrado', '\n    <div>Novo usuário cadastrado diana lira \r\n<br>E-mail do usuário: <b>dianac.lira@gmail.com</b></div>\n    ', '0', '1723584743', NULL), ('16', '1', '16', 'signup', 'Registrado com sucesso', '\n    <div>Você se registrou com sucesso conosco em Academia Curaquantica13.</div>\n    ', '0', '1723584743', NULL), ('17', '1', '1', 'signup', 'Novo usuário cadastrado', '\n    <div>Novo usuário cadastrado Carolina lira \r\n<br>E-mail do usuário: <b>dianademarcos@gmail.com</b></div>\n    ', '0', '1724089473', NULL), ('18', '1', '17', 'signup', 'Registrado com sucesso', '\n    <div>Você se registrou com sucesso conosco em Academia Curaquantica13.</div>\n    ', '0', '1724089473', NULL), ('19', '7', '7', 'certificate_eligibility', 'elegibilidade do certificado', '\n    <div>Curso: [curso_título]\r\nInstrutor: [nome_instrutor]\r\nLink do certificado: <a href=\"https://cursos.curaquantica13.com/certificate/26a3443d6f\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1725019367', NULL), ('20', '7', '1', 'certificate_eligibility', 'Elegibilidade do certificado', '\n    <div>Curso: [curso_título]\r\nAluno: [nome_aluno]\r\nLink do certificado: <a href=\"https://cursos.curaquantica13.com/certificate/26a3443d6f\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1725019367', NULL);
DROP TABLE IF EXISTS `offline_payment`;
CREATE TABLE `offline_payment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `amount` varchar(255) DEFAULT NULL,
  `course_id` varchar(255) DEFAULT NULL,
  `item_id` varchar(255) DEFAULT NULL,
  `item_type` varchar(255) DEFAULT NULL,
  `item_info` longtext DEFAULT NULL,
  `document_image` varchar(255) DEFAULT NULL,
  `timestamp` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `payment`;
CREATE TABLE `payment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `payment_type` varchar(50) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `date_added` int(11) DEFAULT NULL,
  `last_modified` int(11) DEFAULT NULL,
  `admin_revenue` varchar(255) DEFAULT NULL,
  `instructor_revenue` varchar(255) DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `instructor_payment_status` int(11) DEFAULT 0,
  `transaction_id` varchar(255) DEFAULT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `coupon` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `payment_gateways`;
CREATE TABLE `payment_gateways` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `identifier` varchar(255) DEFAULT NULL,
  `currency` varchar(100) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `keys` text NOT NULL,
  `model_name` varchar(255) DEFAULT NULL,
  `enabled_test_mode` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `is_addon` int(11) NOT NULL,
  `created_at` varchar(100) NOT NULL,
  `updated_at` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `payment_gateways` (`id`, `identifier`, `currency`, `title`, `description`, `keys`, `model_name`, `enabled_test_mode`, `status`, `is_addon`, `created_at`, `updated_at`) VALUES ('1', 'paypal', 'EUR', 'Paypal', '', '{\"sandbox_client_id\":\"curaquantica13@gmail.com\",\"sandbox_secret_key\":\"access_token$sandbox$2cv4qvd3xph6p9gg$e1de2ea5d62ad0cfff5f48ab4d1de32e\",\"production_client_id\":\"AZeqxXuXVmgAQmVXg_1DH1O0Cws74zVmct1i-CCu_zOPSDMtNS719L-KJ6SiCpBKXLEfvIo5exCLkCPk\",\"production_secret_key\":\"EJWzsSCIzzVIgb5ayv54OryyXBxPAAVoH02MEHoqy-ZodqlyEE02ccI4X3Wzs37cD4mrGoslSrV_OEIQ\"}', 'Payment_model', '0', '1', '0', '', '1719501126'), ('2', 'stripe', 'USD', 'Stripe', '', '{\"public_key\":\"pk_test_CAC3cB1mhgkJqXtypYBTGb4f\",\"secret_key\":\"sk_test_iatnshcHhQVRXdygXw3L2Pp2\",\"public_live_key\":\"pk_live_xxxxxxxxxxxxxxxxxxxxxxxx\",\"secret_live_key\":\"sk_live_xxxxxxxxxxxxxxxxxxxxxxxx\"}', 'Payment_model', '0', '0', '0', '', '1717685904'), ('3', 'razorpay', 'INR', 'Razorpay', '', '{\"key_id\":\"rzp_test_J60bqBOi1z1aF5\",\"secret_key\":\"uk935K7p4j96UCJgHK8kAU4q\",\"theme_color\":\"#23d792\"}', 'Payment_model', '0', '0', '0', '', '1717685912'), ('4', 'xendit', 'USD', 'Xendit', '', '{\"api_key\":\"xnd_development_44KVee2PG4HeeZxG69R5eXOJHVD7t84FZUIH8dMxa37ZU3bZ8KDKV9ugPfy5fRK\",\"secret_key\":\"your_xendit_secret_key\",\"other_parameter\":\"value\"}', 'Payment_model', '0', '0', '0', '', '1717685923'), ('5', 'payu', 'PLN', 'Payu', '', '{\"pos_id\":\"PKf789971N2ig5hbF71y1BX46k\",\"second_key\":\"vaWDmIqbwiVUOVitXet9ZlC9mQ\",\"client_id\":\"PKf789971N2ig5hbF71y1BX46k\",\"client_secret\":\"vaWDmIqbwiVUOVitXet9ZlC9mQ\"}', 'Payment_model', '0', '0', '0', '', '1717685933'), ('6', 'pagseguro', 'BRL', 'Pagseguro', '', '{\"api_key\":\"BAE981AF77CA4768A93849AFF5BF2331\",\"secret_key\":\"8045696DBFBF765FF4189FBAE1E02AB5\",\"other_parameter\":\"value\"}', 'Payment_model', '0', '0', '0', '', '1717685944'), ('7', 'sslcommerz', 'USD', 'Sslcommerz', '', '{\"store_id\":\"sslcommerz_store_id\",\"store_password\":\"sslcommerz_store_password\"}', 'Payment_model', '0', '0', '0', '', '1717685967'), ('8', 'skrill', 'USD', 'Skrill', '', '{\"skrill_merchant_email\":\"urwatech@gmail.com\",\"secret_passphrase\":\"your_skrill_secret_key\"}', 'Payment_model', '0', '0', '0', '', '1717685982'), ('10', 'doku', 'USD', 'Doku', '', '{\"client_id\":\"BRN-0271-1700996849302\",\"shared_key\":\"SK-BxOS4PfUdIEMHLccyMI3\"}', 'Payment_model', '0', '0', '0', '', '1717685995'), ('11', 'bkash', 'BDT', 'Bkash', '', '{\"app_key\":\"app-key\",\"app_secret\":\"app-secret\",\"username\":\"username\",\"password\":\"passwoed\"}', 'Payment_model', '0', '0', '0', '1700997440', '1717686009'), ('12', 'cashfree', 'INR', 'Cashfree', '', '{\"client_id\":\"TEST100748308df0665cabda6c2f38b903847001\",\"client_secret\":\"cfsk_ma_test_71065d7cadf8695e7845e86244bd7011_fff5714b\"}', 'Payment_model', '0', '0', '0', '1700997440', '1717686025'), ('13', 'maxicash', 'USD', 'Maxicash', '', '{\"merchant_id\":\"TEST100748308df0665cabda6c2f38b903847001\",\"merchant_password\":\"cfsk_ma_test_71065d7cadf8695e7845e86244bd7011_fff5714b\"}', 'Payment_model', '0', '0', '0', '1700997440', '1717686038'), ('14', 'aamarpay', 'BDT', 'Aamarpay', '', '{\"store_id\":\"aamarpaytest\",\"signature_key\":\"dbb74894e82415a2f7ff0ec3a97e4183\"}', 'Payment_model', '0', '0', '0', '1700997440', '1717686056'), ('15', 'flutterwave', 'NGN', 'Flutterwave', '', '{\"public_key\":\"FLWPUBK_TEST-b6fbee21fd2d9f13be74bf4d87fe6197-X\",\"secret_key\":\"FLWSECK_TEST-70c3f071a83a1d14bb8a0061e53845a7-X\"}', 'Payment_model', '0', '0', '0', '1700997440', '1717686071'), ('16', 'tazapay', 'USD', 'Tazapay', '', '{\"public_key\":\"pk_test_audpDpZGmHmYT46kmHvA\",\"api_key\":\"ak_test_CRXTUMNGV4MVPO7RDGT2\",\"api_secret\":\"sk_test_0OfyPSFUX4YqcQGkeyOWCVkEQ7WAWeZ6SmsNNpfFQ989qm15f8mu2gqmYhiXkZ87iF26Ej1Ex9pgNuTq9YoxksPmQjDEbyATBoWw0bNH12mQPIJQ4VGqEPIB5FEizarZ\"}', 'Payment_model', '0', '0', '0', '1700997440', '1717686082'), ('17', 'offline_payment', 'USD', 'Offline payment', '', '[]', 'Offline_payment_model', '0', '1', '1', '1717281879', '');
DROP TABLE IF EXISTS `payout`;
CREATE TABLE `payout` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `date_added` int(11) DEFAULT NULL,
  `last_modified` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT NULL,
  `permissions` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `question`;
CREATE TABLE `question` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) DEFAULT NULL,
  `title` longtext DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `number_of_options` int(11) DEFAULT NULL,
  `options` longtext DEFAULT NULL,
  `correct_answers` longtext DEFAULT NULL,
  `order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `quiz_results`;
CREATE TABLE `quiz_results` (
  `quiz_result_id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user_answers` longtext NOT NULL,
  `correct_answers` longtext NOT NULL COMMENT 'question_id',
  `total_obtained_marks` double NOT NULL,
  `date_added` varchar(100) NOT NULL,
  `date_updated` varchar(100) NOT NULL,
  `is_submitted` int(11) NOT NULL,
  PRIMARY KEY (`quiz_result_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `rating`;
CREATE TABLE `rating` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `rating` double DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ratable_id` int(11) DEFAULT NULL,
  `ratable_type` varchar(50) DEFAULT NULL,
  `date_added` int(11) DEFAULT NULL,
  `last_modified` int(11) DEFAULT NULL,
  `review` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `resource_files`;
CREATE TABLE `resource_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lesson_id` int(20) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `created_at` varchar(255) DEFAULT NULL,
  `updated_at` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `resource_files` (`id`, `lesson_id`, `title`, `file_name`, `created_at`, `updated_at`) VALUES ('1', '224', 'PASSO 2 TRAFEGO PAGO PERSONA', 'Dw6fheONxJc8vCY1GWKt.pdf', '1729107122', NULL);
DROP TABLE IF EXISTS `role`;
CREATE TABLE `role` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `date_added` int(11) DEFAULT NULL,
  `last_modified` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `role` (`id`, `name`, `date_added`, `last_modified`) VALUES ('1', 'Admin', '1234567890', '1234567890'), ('2', 'User', '1234567890', '1234567890');
DROP TABLE IF EXISTS `section`;
CREATE TABLE `section` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `start_date` varchar(255) DEFAULT NULL,
  `end_date` varchar(255) DEFAULT NULL,
  `restricted_by` varchar(255) DEFAULT NULL,
  `order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `section` (`id`, `title`, `course_id`, `start_date`, `end_date`, `restricted_by`, `order`) VALUES ('1', 'Bem-Vindos', '1', NULL, NULL, NULL, '0'), ('2', 'Instruções e Pontos Importantes', '1', NULL, NULL, NULL, '0'), ('3', 'Link Aula Google Meet', '1', NULL, NULL, NULL, '0'), ('4', 'Grupo Telegram Suporte e Trocas', '1', NULL, NULL, NULL, '0'), ('5', 'AULA: Dia 1', '1', NULL, NULL, NULL, '0'), ('6', 'AULA: Dia 2', '1', NULL, NULL, NULL, '0'), ('7', 'Materiais Gráficos', '1', NULL, NULL, NULL, '0'), ('8', 'Avisos Importantes', '1', NULL, NULL, NULL, '0'), ('9', 'Depoimentos', '1', NULL, NULL, NULL, '0'), ('10', 'Bônus', '1', NULL, NULL, NULL, '0'), ('11', 'Bem-Vindos Despertos!!', '2', NULL, NULL, NULL, '0'), ('12', 'Grupo Telegram Suporte e Apoio', '2', NULL, NULL, NULL, '0'), ('13', 'O que é a Desprogramação Neurobiológica?', '2', NULL, NULL, NULL, '0'), ('14', 'Dia 1: Abrindo o meu Coração para Receber', '2', NULL, NULL, NULL, '0'), ('15', 'Dia 2: Libertação de Karmas e Perdão', '2', NULL, NULL, NULL, '0'), ('16', 'Dia 3: Desapego, Culpa e Mágoa', '2', NULL, NULL, NULL, '0'), ('17', 'Dia 4: Corte de laços energéticos', '2', NULL, NULL, NULL, '0'), ('18', 'Dia 5: Trabalhando a Clareza', '2', NULL, NULL, NULL, '0'), ('19', 'Dia 6: Vivendo na frequência da GRATIDÃO', '2', NULL, NULL, NULL, '0'), ('20', 'Dia 7: Manifestando o Amor', '2', NULL, NULL, NULL, '0'), ('21', 'Avisos Importantes', '2', NULL, NULL, NULL, '0'), ('22', 'Como vai funcionar a Jornada Atraindo Abundância?', '3', NULL, NULL, NULL, '0'), ('23', 'O que deves fazer Durante a Jornada?', '3', NULL, NULL, NULL, '0'), ('24', 'Dia 1: Como abrir o meu receber?', '3', NULL, NULL, NULL, '0'), ('25', 'Dia 2: Cortando Laços energéticos que me conectam com a falta', '3', NULL, NULL, NULL, '0'), ('26', 'Dia 3: Desprogramando padrões familiares que me conectam com a escassez', '3', NULL, NULL, NULL, '0'), ('27', 'Dia 4: Desprogramando o medo ao Sucesso', '3', NULL, NULL, NULL, '0'), ('28', 'Dia 5: Passo a passo apara atrair Abundância', '3', NULL, NULL, NULL, '0'), ('29', 'Dia 6: Vibrando na frequência do Eu Sou', '3', NULL, NULL, NULL, '0'), ('30', 'Dia 7: Ancorando o novo padrão energético de Abundância', '3', NULL, NULL, NULL, '0'), ('31', 'Agradecimento', '3', NULL, NULL, NULL, '0'), ('32', 'Avisos Importantes', '3', NULL, NULL, NULL, '0'), ('33', 'Introdução', '4', NULL, NULL, NULL, '0'), ('34', 'Passo 1', '4', NULL, NULL, NULL, '0'), ('35', 'Passo 2', '4', NULL, NULL, NULL, '0'), ('36', 'Passo 3', '4', NULL, NULL, NULL, '0'), ('37', 'Passo 4', '4', NULL, NULL, NULL, '0'), ('38', 'Passo 5', '4', NULL, NULL, NULL, '0'), ('39', 'Passo 6', '4', NULL, NULL, NULL, '0'), ('40', 'Passo 7', '4', NULL, NULL, NULL, '0'), ('41', 'BOAS-VINDAS', '5', NULL, NULL, NULL, '1'), ('43', 'Modulo: AUTOCONHECIMENTO ', '5', NULL, NULL, NULL, '4'), ('44', 'Modulo: ESTRATÉGIAS DE MARKETING DIGITAL PARA PROFISSIONAIS DO BEM-ESTAR', '5', NULL, NULL, NULL, '8'), ('45', 'Modulo: NETWORKING e COLABORAÇÃO ', '5', NULL, NULL, NULL, '9'), ('47', 'ENCONTROS AO VIVO', '5', NULL, NULL, NULL, '2'), ('48', 'BASES DE I.A (INTELIGÊNCIA ARTIFICIAL)', '5', NULL, NULL, NULL, '5'), ('50', 'POSICIONAMENTO', '5', NULL, NULL, NULL, '7'), ('51', 'PRODUTIVIDADE PARA PROFISSIONAIS DO BEM-ESTAR', '5', NULL, NULL, NULL, '6'), ('52', '1.- Origem do Despertando o Poder de Autocura', '6', NULL, NULL, NULL, '0'), ('53', '2.- Exercício de respiração para acalmar e dormir', '6', NULL, NULL, NULL, '0'), ('54', '3.- Desprogramando o meu timo', '6', NULL, NULL, NULL, '0'), ('55', '4.- Sessão Anjos da Criação para limpeza e alinhamento energético da Glândula do Timo', '6', NULL, NULL, NULL, '0'), ('56', '5.- Agua Solarizada Azul', '6', NULL, NULL, NULL, '0'), ('57', '6.- Como preparar a Agua Solarizada', '6', NULL, NULL, NULL, '0'), ('58', '7.- Sessão DNB para abrir o Receber', '6', NULL, NULL, NULL, '0'), ('59', '8.- Exercício para ativar a glândula do timo', '6', NULL, NULL, NULL, '0'), ('60', '9.- Depoimento', '6', NULL, NULL, NULL, '0'), ('61', 'Teste de Visualização', '7', NULL, NULL, NULL, '0'), ('63', 'BOOTCAMP BRANDING', '5', NULL, NULL, NULL, '3');
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `settings` (`id`, `key`, `value`) VALUES ('1', 'language', 'portuguese'), ('2', 'system_name', 'Academia Curaquantica13'), ('3', 'system_title', 'Academia Curaquantica13'), ('4', 'system_email', 'curaquantica13@curaquantica13.com'), ('5', 'address', 'Funchal / Portugal'), ('6', 'phone', ' +351 969-741-855'), ('7', 'purchase_code', '2024-1973-0106'), ('8', 'paypal', '[{\"active\":\"1\",\"mode\":\"sandbox\",\"sandbox_client_id\":\"AfGaziKslex-scLAyYdDYXNFaz2aL5qGau-SbDgE_D2E80D3AFauLagP8e0kCq9au7W4IasmFbirUUYc\",\"sandbox_secret_key\":\"EMa5pCTuOpmHkhHaCGibGhVUcKg0yt5-C3CzJw-OWJCzaXXzTlyD17SICob_BkfM_0Nlk7TWnN42cbGz\",\"production_client_id\":\"1234\",\"production_secret_key\":\"12345\"}]'), ('9', 'stripe_keys', '[{\"active\":\"1\",\"testmode\":\"on\",\"public_key\":\"pk_test_CAC3cB1mhgkJqXtypYBTGb4f\",\"secret_key\":\"sk_test_iatnshcHhQVRXdygXw3L2Pp2\",\"public_live_key\":\"pk_live_xxxxxxxxxxxxxxxxxxxxxxxx\",\"secret_live_key\":\"sk_live_xxxxxxxxxxxxxxxxxxxxxxxx\"}]'), ('10', 'youtube_api_key', 'youtube-and-google-drive-api-key'), ('11', 'vimeo_api_key', 'vimeo-api-key'), ('12', 'slogan', 'Uma academia de vídeos baseado em cursos'), ('13', 'text_align', NULL), ('14', 'allow_instructor', '1'), ('15', 'instructor_revenue', '70'), ('16', 'system_currency', 'EUR'), ('17', 'paypal_currency', 'USD'), ('18', 'stripe_currency', 'USD'), ('19', 'author', 'Curaquantica13'), ('20', 'currency_position', 'left'), ('21', 'website_description', 'Estude qualquer assunto, a qualquer hora. explore milhares de cursos pelo menor preço de todos os tempos!'), ('22', 'website_keywords', 'curaquantica,terapias'), ('23', 'footer_text', 'Institucional Curaquantica13'), ('24', 'footer_link', 'https://curaquantica13.com'), ('25', 'protocol', 'SMTP'), ('26', 'smtp_host', 'mail.curaquantica13.com'), ('27', 'smtp_port', '465'), ('28', 'smtp_user', 'curaquantica13@curaquantica13.com'), ('29', 'smtp_pass', 'Cura@2024Email'), ('30', 'version', '6.9.1'), ('31', 'student_email_verification', 'disable'), ('32', 'instructor_application_note', 'Preencha todos os campos com atenção e compartilhe, caso queira compartilhar algum documento conosco isso nos ajudará a avaliá-lo como instrutor.'), ('33', 'razorpay_keys', '[{\"active\":\"1\",\"key\":\"rzp_test_J60bqBOi1z1aF5\",\"secret_key\":\"uk935K7p4j96UCJgHK8kAU4q\",\"theme_color\":\"#c7a600\"}]'), ('34', 'razorpay_currency', 'USD'), ('35', 'fb_app_id', NULL), ('36', 'fb_app_secret', NULL), ('37', 'fb_social_login', NULL), ('38', 'drip_content_settings', '{\"lesson_completion_role\":\"percentage\",\"minimum_duration\":15,\"minimum_percentage\":\"40\",\"locked_lesson_message\":\"&lt;h3 xss=&quot;removed&quot; style=&quot;text-align: center; &quot;&gt;&lt;span xss=&quot;removed&quot;&gt;&lt;strong&gt;Permiss\\u00e3o negada!&lt;\\/strong&gt;&lt;\\/span&gt;&lt;\\/h3&gt;&lt;p xss=&quot;removed&quot; style=&quot;text-align: center; &quot;&gt;&lt;span xss=&quot;removed&quot;&gt;Este curso oferece suporte a conte\\u00fado de conclus\\u00e3o, portanto, voc\\u00ea deve concluir as li\\u00e7\\u00f5es anteriores.&lt;\\/span&gt;&lt;\\/p&gt;\"}'), ('41', 'course_accessibility', 'publicly'), ('42', 'smtp_crypto', 'SSL'), ('43', 'allowed_device_number_of_loging', '200'), ('47', 'academy_cloud_access_token', 'jdfghasdfasdfasdfasdfasdf'), ('48', 'course_selling_tax', '0'), ('49', 'ccavenue_keys', '[{\"active\":\"1\",\"ccavenue_merchant_id\":\"cmi_xxxxxx\",\"ccavenue_working_key\":\"cwk_xxxxxxxxxxxx\",\"ccavenue_access_code\":\"ccc_xxxxxxxxxxxxx\"}]'), ('50', 'ccavenue_currency', 'INR'), ('51', 'iyzico_keys', '[{\"active\":\"1\",\"testmode\":\"on\",\"iyzico_currency\":\"TRY\",\"api_test_key\":\"atk_xxxxxxxx\",\"secret_test_key\":\"stk_xxxxxxxx\",\"api_live_key\":\"alk_xxxxxxxx\",\"secret_live_key\":\"slk_xxxxxxxx\"}]'), ('52', 'iyzico_currency', 'TRY'), ('53', 'paystack_keys', '[{\"active\":\"1\",\"testmode\":\"on\",\"secret_test_key\":\"sk_test_c746060e693dd50c6f397dffc6c3b2f655217c94\",\"public_test_key\":\"pk_test_0816abbed3c339b8473ff22f970c7da1c78cbe1b\",\"secret_live_key\":\"sk_live_xxxxxxxxxxxxxxxxxxxxx\",\"public_live_key\":\"pk_live_xxxxxxxxxxxxxxxxxxxxx\"}]'), ('54', 'paystack_currency', 'NGN'), ('55', 'paytm_keys', '[{\"PAYTM_MERCHANT_KEY\":\"PAYTM_MERCHANT_KEY\",\"PAYTM_MERCHANT_MID\":\"PAYTM_MERCHANT_MID\",\"PAYTM_MERCHANT_WEBSITE\":\"DEFAULT\",\"INDUSTRY_TYPE_ID\":\"Retail\",\"CHANNEL_ID\":\"WEB\"}]'), ('57', 'google_analytics_id', ''), ('58', 'meta_pixel_id', ''), ('59', 'smtp_from_email', 'curaquantica13@curaquantica13.com'), ('61', 'language_dirs', '{\"english\":\"ltr\",\"hindi\":\"rtl\",\"arabic\":\"rtl\"}'), ('62', 'timezone', 'Europe/Lisbon'), ('63', 'account_disable', '1'), ('64', 'offline_bank_information', '&lt;blockquote class=&quot;blockquote&quot;&gt;Insira suas informações bancárias&lt;/blockquote&gt;'), ('65', 'randCallRange', '20'), ('70', 'wasabi_key', 'access-key'), ('71', 'wasabi_secret_key', 'secret-key'), ('72', 'wasabi_bucketname', 'bucket-name'), ('73', 'wasabi_region', 'region-name'), ('74', 'bbb_setting', '{\"endpoint\":\"https:\\/\\/manager.bigbluemeeting.com\\/bigbluebutton\\/\",\"secret\":\"shared-secret-or-salt\"}'), ('75', 'iso_country_codes', '{\"AF\": \"Afghanistan\",\"AX\": \"Åland Islands\",\"AL\": \"Albania\",\"DZ\": \"Algeria\",\"AS\": \"American Samoa\",\"AD\": \"Andorra\",\"AO\": \"Angola\",\"AI\": \"Anguilla\",\"AQ\": \"Antarctica\",\"AG\": \"Antigua and Barbuda\",\"AR\": \"Argentina\",\"AM\": \"Armenia\",\"AW\": \"Aruba\",\"AU\": \"Australia\",\"AT\": \"Austria\",\"AZ\": \"Azerbaijan\",\"BS\": \"Bahamas\",\"BH\": \"Bahrain\",\"BD\": \"Bangladesh\",\"BB\": \"Barbados\",\"BY\": \"Belarus\",\"BE\": \"Belgium\",\"BZ\": \"Belize\",\"BJ\": \"Benin\",\"BM\": \"Bermuda\",\"BT\": \"Bhutan\",\"BO\": \"Bolivia (Plurinational State of)\",\"BQ\": \"Bonaire, Sint Eustatius and Saba\",\"BA\": \"Bosnia and Herzegovina\",\"BW\": \"Botswana\",\"BV\": \"Bouvet Island\",\"BR\": \"Brazil\",\"IO\": \"British Indian Ocean Territory\",\"BN\": \"Brunei Darussalam\",\"BG\": \"Bulgaria\",\"BF\": \"Burkina Faso\",\"BI\": \"Burundi\",\"CV\": \"Cabo Verde\",\"KH\": \"Cambodia\",\"CM\": \"Cameroon\",\"CA\": \"Canada\",\"KY\": \"Cayman Islands\",\"CF\": \"Central African Republic\",\"TD\": \"Chad\",\"CL\": \"Chile\",\"CN\": \"China\",\"CX\": \"Christmas Island\",\"CC\": \"Cocos (Keeling) Islands\",\"CO\": \"Colombia\",\"KM\": \"Comoros\",\"CG\": \"Congo\",\"CD\": \"Congo (Democratic Republic of the)\",\"CK\": \"Cook Islands\",\"CR\": \"Costa Rica\",\"CI\": \"Côte d\'Ivoire\",\"HR\": \"Croatia\",\"CU\": \"Cuba\",\"CW\": \"Curaçao\",\"CY\": \"Cyprus\",\"CZ\": \"Czech Republic\",\"DK\": \"Denmark\",\"DJ\": \"Djibouti\",\"DM\": \"Dominica\",\"DO\": \"Dominican Republic\",\"EC\": \"Ecuador\",\"EG\": \"Egypt\",\"SV\": \"El Salvador\",\"GQ\": \"Equatorial Guinea\",\"ER\": \"Eritrea\",\"EE\": \"Estonia\",\"ET\": \"Ethiopia\",\"FK\": \"Falkland Islands (Malvinas)\",\"FO\": \"Faroe Islands\",\"FJ\": \"Fiji\",\"FI\": \"Finland\",\"FR\": \"France\",\"GF\": \"French Guiana\",\"PF\": \"French Polynesia\",\"TF\": \"French Southern Territories\",\"GA\": \"Gabon\",\"GM\": \"Gambia\",\"GE\": \"Georgia\",\"DE\": \"Germany\",\"GH\": \"Ghana\",\"GI\": \"Gibraltar\",\"GR\": \"Greece\",\"GL\": \"Greenland\",\"GD\": \"Grenada\",\"GP\": \"Guadeloupe\",\"GU\": \"Guam\",\"GT\": \"Guatemala\",\"GG\": \"Guernsey\",\"GN\": \"Guinea\",\"GW\": \"Guinea-Bissau\",\"GY\": \"Guyana\",\"HT\": \"Haiti\",\"HM\": \"Heard Island and McDonald Islands\",\"VA\": \"Holy See\",\"HN\": \"Honduras\",\"HK\": \"Hong Kong\",\"HU\": \"Hungary\",\"IS\": \"Iceland\",\"IN\": \"India\",\"ID\": \"Indonesia\",\"IR\": \"Iran (Islamic Republic of)\",\"IQ\": \"Iraq\",\"IE\": \"Ireland\",\"IM\": \"Isle of Man\",\"IL\": \"Israel\",\"IT\": \"Italy\",\"JM\": \"Jamaica\",\"JP\": \"Japan\",\"JE\": \"Jersey\",\"JO\": \"Jordan\",\"KZ\": \"Kazakhstan\",\"KE\": \"Kenya\",\"KI\": \"Kiribati\",\"KP\": \"Korea (Democratic People\'s Republic of)\",\"KR\": \"Korea (Republic of)\",\"KW\": \"Kuwait\",\"KG\": \"Kyrgyzstan\",\"LA\": \"Lao People\'s Democratic Republic\",\"LV\": \"Latvia\",\"LB\": \"Lebanon\",\"LS\": \"Lesotho\",\"LR\": \"Liberia\",\"LY\": \"Libya\",\"LI\": \"Liechtenstein\",\"LT\": \"Lithuania\",\"LU\": \"Luxembourg\",\"MO\": \"Macao\",\"MK\": \"North Macedonia\",\"MG\": \"Madagascar\",\"MW\": \"Malawi\",\"MY\": \"Malaysia\",\"MV\": \"Maldives\",\"ML\": \"Mali\",\"MT\": \"Malta\",\"MH\": \"Marshall Islands\",\"MQ\": \"Martinique\",\"MR\": \"Mauritania\",\"MU\": \"Mauritius\",\"YT\": \"Mayotte\",\"MX\": \"Mexico\",\"FM\": \"Micronesia (Federated States of)\",\"MD\": \"Moldova (Republic of)\",\"MC\": \"Monaco\",\"MN\": \"Mongolia\",\"ME\": \"Montenegro\",\"MS\": \"Montserrat\",\"MA\": \"Morocco\",\"MZ\": \"Mozambique\",\"MM\": \"Myanmar\",\"NA\": \"Namibia\",\"NR\": \"Nauru\",\"NP\": \"Nepal\",\"NL\": \"Netherlands\",\"NC\": \"New Caledonia\",\"NZ\": \"New Zealand\",\"NI\": \"Nicaragua\",\"NE\": \"Niger\",\"NG\": \"Nigeria\",\"NU\": \"Niue\",\"NF\": \"Norfolk Island\",\"MP\": \"Northern Mariana Islands\",\"NO\": \"Norway\",\"OM\": \"Oman\",\"PK\": \"Pakistan\",\"PW\": \"Palau\",\"PS\": \"Palestine, State of\",\"PA\": \"Panama\",\"PG\": \"Papua New Guinea\",\"PY\": \"Paraguay\",\"PE\": \"Peru\",\"PH\": \"Philippines\",\"PN\": \"Pitcairn\",\"PL\": \"Poland\",\"PT\": \"Portugal\",\"PR\": \"Puerto Rico\",\"QA\": \"Qatar\",\"RE\": \"Réunion\",\"RO\": \"Romania\",\"RU\": \"Russian Federation\",\"RW\": \"Rwanda\",\"BL\": \"Saint Barthélemy\",\"SH\": \"Saint Helena, Ascension and Tristan da Cunha\",\"KN\": \"Saint Kitts and Nevis\",\"LC\": \"Saint Lucia\",\"MF\": \"Saint Martin (French part)\",\"PM\": \"Saint Pierre and Miquelon\",\"VC\": \"Saint Vincent and the Grenadines\",\"WS\": \"Samoa\",\"SM\": \"San Marino\",\"ST\": \"Sao Tome and Principe\",\"SA\": \"Saudi Arabia\",\"SN\": \"Senegal\",\"RS\": \"Serbia\",\"SC\": \"Seychelles\",\"SL\": \"Sierra Leone\",\"SG\": \"Singapore\",\"SX\": \"Sint Maarten (Dutch part)\",\"SK\": \"Slovakia\",\"SI\": \"Slovenia\",\"SB\": \"Solomon Islands\",\"SO\": \"Somalia\",\"ZA\": \"South Africa\",\"GS\": \"South Georgia and the South Sandwich Islands\",\"SS\": \"South Sudan\",\"ES\": \"Spain\",\"LK\": \"Sri Lanka\",\"SD\": \"Sudan\",\"SR\": \"Suriname\",\"SJ\": \"Svalbard and Jan Mayen\",\"SE\": \"Sweden\",\"CH\": \"Switzerland\",\"SY\": \"Syrian Arab Republic\",\"TW\": \"Taiwan, Province of China\",\"TJ\": \"Tajikistan\",\"TZ\": \"Tanzania, United Republic of\",\"TH\": \"Thailand\",\"TL\": \"Timor-Leste\",\"TG\": \"Togo\",\"TK\": \"Tokelau\",\"TO\": \"Tonga\",\"TT\": \"Trinidad and Tobago\",\"TN\": \"Tunisia\",\"TR\": \"Turkey\",\"TM\": \"Turkmenistan\",\"TC\": \"Turks and Caicos Islands\",\"TV\": \"Tuvalu\",\"UG\": \"Uganda\",\"UA\": \"Ukraine\",\"AE\": \"United Arab Emirates\",\"GB\": \"United Kingdom of Great Britain and Northern Ireland\",\"UM\": \"United States Minor Outlying Islands\",\"US\": \"United States of America\",\"UY\": \"Uruguay\",\"UZ\": \"Uzbekistan\",\"VU\": \"Vanuatu\",\"VE\": \"Venezuela (Bolivarian Republic of)\",\"VN\": \"Viet Nam\",\"VG\": \"Virgin Islands (British)\",\"VI\": \"Virgin Islands (U.S.)\",\"WF\": \"Wallis and Futuna\",\"EH\": \"Western Sahara\",\"YE\": \"Yemen\",\"ZM\": \"Zambia\",\"ZW\": \"Zimbabwe\"}'), ('76', 'affiliate_addon_percentage', '0'), ('77', 'affiliate_addon_active_status', '1'), ('78', 'certificate_template', 'Isto é para certificar que o Sr./Sra. {student} concluiu com êxito o curso com certificado de {course}.'), ('79', 'certificate-text-positons', '\n			&lt;div class=&quot;this-template&quot; style=&quot;width: 750px; position: relative;&quot;&gt;\n				&lt;img width=&quot;100%&quot; src=&quot;..\\..\\uploads/certificates/template.jpg&quot;&gt;\n				&lt;div class=&quot;draggable instructor_name&quot; style=&quot;position: absolute; font-family: &amp;quot;Miss Fajardose&amp;quot;; font-size: 40px; top: 373.892px; left: 553.889px;&quot;&gt;{instructor}&lt;/div&gt;&lt;div class=&quot;draggable course_level&quot; style=&quot;position: absolute;font-size: 16px;top: 444.861px;left: 84.8681px;&quot;&gt;{course_level}&lt;/div&gt;\n&lt;div class=&quot;draggable course_language&quot; style=&quot;position: absolute; font-size: 16px; top: 155.84px; left: 65.8473px;&quot;&gt;{course_language}&lt;/div&gt;\n&lt;div class=&quot;draggable student_name&quot; style=&quot;position: absolute; font-family: &amp;quot;Miss Fajardose&amp;quot;, cursive; font-size: 40px; top: 373.92px; left: 59.9063px;&quot;&gt;{student}&lt;/div&gt;\n&lt;div class=&quot;draggable duration_name&quot; style=&quot;position: absolute; font-size: 16px; top: 341.837px; left: 328.806px;&quot;&gt;{total_duration}&lt;/div&gt;\n&lt;div class=&quot;draggable lesson_name&quot; style=&quot;position: absolute;font-size: 16px;top: 341.882px;left: 124.868px;&quot;&gt;{total_lesson}&lt;/div&gt;\n				&lt;div class=&quot;draggable course_completion_date&quot; style=&quot;position: absolute; font-size: 20px; top: 151.924px; left: 543.896px;&quot;&gt;{date}&lt;/div&gt;\n				&lt;div class=&quot;draggable certificate_text&quot; style=&quot;position: absolute;width: 500px;text-align: center;font-size: 28px;top: 228.948px;font-family: &amp;quot;Pinyon Script&amp;quot;;left: 123.903px;&quot;&gt;This is to certify that Mr. / Ms. {student} successfully completed the course with on certificate for {course}.&lt;/div&gt;\n				&lt;div class=&quot;draggable qrCode&quot; style=&quot;position: absolute; width: 65px; height: 65px; text-align: center; font-size: 20px; top: 76.9202px; left: 594.924px;&quot;&gt;&lt;p style=&quot;text-align: center; padding: 4px 0px;&quot;&gt;Qr code&lt;/p&gt;&lt;/div&gt;\n			&lt;/div&gt;\n																																																																																				'), ('80', 'open_ai', '{\"model\":\"text-davinci-003\",\"max_tokens\":\"200\",\"ai_secret_key\":\"\"}');
DROP TABLE IF EXISTS `support_category`;
CREATE TABLE `support_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `support_macro`;
CREATE TABLE `support_macro` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `tag`;
CREATE TABLE `tag` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(255) DEFAULT NULL,
  `tagable_id` int(11) DEFAULT NULL,
  `tagable_type` varchar(255) DEFAULT NULL,
  `date_added` int(11) DEFAULT NULL,
  `last_modified` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `ticket_description`;
CREATE TABLE `ticket_description` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `file_name` varchar(50) DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `tickets`;
CREATE TABLE `tickets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `priority` varchar(255) DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `tutor_booking`;
CREATE TABLE `tutor_booking` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `sub_category_id` int(11) DEFAULT 0,
  `price_type` varchar(255) DEFAULT NULL,
  `tution_class_type` varchar(255) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT 0.00,
  `tutor_id` int(11) DEFAULT NULL,
  `meeting_link` varchar(255) DEFAULT NULL,
  `date_added` varchar(255) DEFAULT NULL,
  `active_status` int(11) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `tutor_category`;
CREATE TABLE `tutor_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `parent` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `tutor_live_class_settings`;
CREATE TABLE `tutor_live_class_settings` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `zoom_meeting_id` varchar(255) DEFAULT NULL,
  `zoom_meeting_password` varchar(255) DEFAULT NULL,
  `zoom_api_key` varchar(255) DEFAULT NULL,
  `zoom_secret_key` varchar(255) DEFAULT NULL,
  `tutor_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `tutor_payment`;
CREATE TABLE `tutor_payment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `tutor_id` int(11) DEFAULT NULL,
  `booking_id` int(11) DEFAULT NULL,
  `schedule_id` int(11) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `date_added` varchar(255) DEFAULT NULL,
  `admin_revenue` decimal(10,2) DEFAULT NULL,
  `instructor_revenue` decimal(10,2) DEFAULT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `last_modified` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `tutor_reviews`;
CREATE TABLE `tutor_reviews` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `tutor_id` int(11) DEFAULT NULL,
  `review` longtext DEFAULT NULL,
  `rating` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT '1',
  `date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `tutor_schedule`;
CREATE TABLE `tutor_schedule` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(11) DEFAULT 0,
  `tutor_id` int(11) DEFAULT 0,
  `start_time` varchar(255) DEFAULT NULL,
  `end_time` varchar(255) DEFAULT NULL,
  `tuition_type` int(11) DEFAULT 3,
  `valid_till` varchar(255) DEFAULT NULL,
  `tution_class_type` varchar(255) DEFAULT NULL,
  `selected_days` varchar(255) DEFAULT NULL,
  `class_type` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  `student_id` varchar(255) DEFAULT NULL,
  `active_status` int(11) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `skills` longtext NOT NULL,
  `social_links` longtext DEFAULT NULL,
  `biography` longtext DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `date_added` int(11) DEFAULT NULL,
  `last_modified` int(11) DEFAULT NULL,
  `wishlist` longtext DEFAULT NULL,
  `title` longtext DEFAULT NULL,
  `payment_keys` longtext NOT NULL,
  `verification_code` longtext DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `is_instructor` int(11) DEFAULT 0,
  `image` varchar(255) DEFAULT NULL,
  `temp` longtext DEFAULT NULL,
  `sessions` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `users` (`id`, `first_name`, `last_name`, `email`, `phone`, `address`, `password`, `skills`, `social_links`, `biography`, `role_id`, `date_added`, `last_modified`, `wishlist`, `title`, `payment_keys`, `verification_code`, `status`, `is_instructor`, `image`, `temp`, `sessions`) VALUES ('1', 'Administrador', 'Geral', 'diana.lira@curaquantica13.com', NULL, NULL, '291d7e0b3ee3da80bd209c4fb1ce74a4be0d07ba', 'Processos Terapêuticos,Auto-cura,Família,Vida Abundante,Jornada Profissional,Desenvolvimento Pessoal', '{\"facebook\":\"book.com\\/curaquantica13\",\"twitter\":\"\",\"linkedin\":\"\"}', '', '1', NULL, '1718833824', NULL, 'Sócia e Diretora da Curaquantica13', '', NULL, '1', '1', 'a97a7e58b26f13845839e1977cde9c36', NULL, ''), ('2', 'Diana', 'Lira', 'curaquantica13@gmail.com', '+351 969-741-855', 'Funchal, Portugal', '291d7e0b3ee3da80bd209c4fb1ce74a4be0d07ba', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', '', '2', '1717523828', NULL, '[]', NULL, '{\"paypal\":{\"sandbox_client_id\":\"\",\"sandbox_secret_key\":\"\",\"production_client_id\":\"\",\"production_secret_key\":\"\"},\"stripe\":{\"public_key\":\"\",\"secret_key\":\"\",\"public_live_key\":\"\",\"secret_live_key\":\"\"},\"razorpay\":{\"key_id\":\"\",\"secret_key\":\"\",\"theme_color\":\"\"},\"xendit\":{\"api_key\":\"\",\"secret_key\":\"\",\"other_parameter\":\"\"},\"payu\":{\"pos_id\":\"\",\"second_key\":\"\",\"client_id\":\"\",\"client_secret\":\"\"},\"pagseguro\":{\"api_key\":\"\",\"secret_key\":\"\",\"other_parameter\":\"\"},\"sslcommerz\":{\"store_id\":\"\",\"store_password\":\"\"},\"skrill\":{\"skrill_merchant_email\":\"\",\"secret_passphrase\":\"\"},\"doku\":{\"client_id\":\"\",\"shared_key\":\"\"},\"bkash\":{\"app_key\":\"\",\"app_secret\":\"\",\"username\":\"\",\"password\":\"\"},\"cashfree\":{\"client_id\":\"\",\"client_secret\":\"\"},\"maxicash\":{\"merchant_id\":\"\",\"merchant_password\":\"\"},\"aamarpay\":{\"store_id\":\"\",\"signature_key\":\"\"},\"flutterwave\":{\"public_key\":\"\",\"secret_key\":\"\"},\"tazapay\":{\"public_key\":\"\",\"api_key\":\"\",\"api_secret\":\"\"}}', NULL, '1', '1', '4385753ebcf83f6897c478db9f92a3fa', NULL, ''), ('4', 'Liliana Marli Canadá', 'Teixeira', 'lilianateixeira89@gmail.com', '351962453586', '', '793130c64adf373b51fff9c6631ed430e52d875c', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', '', '2', '1718472133', '1718472538', '[]', NULL, '{\"paypal\":{\"sandbox_client_id\":\"\",\"sandbox_secret_key\":\"\",\"production_client_id\":\"\",\"production_secret_key\":\"\"},\"stripe\":{\"public_key\":\"\",\"secret_key\":\"\",\"public_live_key\":\"\",\"secret_live_key\":\"\"},\"razorpay\":{\"key_id\":\"\",\"secret_key\":\"\",\"theme_color\":\"\"},\"xendit\":{\"api_key\":\"\",\"secret_key\":\"\",\"other_parameter\":\"\"},\"payu\":{\"pos_id\":\"\",\"second_key\":\"\",\"client_id\":\"\",\"client_secret\":\"\"},\"pagseguro\":{\"api_key\":\"\",\"secret_key\":\"\",\"other_parameter\":\"\"},\"sslcommerz\":{\"store_id\":\"\",\"store_password\":\"\"},\"skrill\":{\"skrill_merchant_email\":\"\",\"secret_passphrase\":\"\"},\"doku\":{\"client_id\":\"\",\"shared_key\":\"\"},\"bkash\":{\"app_key\":\"\",\"app_secret\":\"\",\"username\":\"\",\"password\":\"\"},\"cashfree\":{\"client_id\":\"\",\"client_secret\":\"\"},\"maxicash\":{\"merchant_id\":\"\",\"merchant_password\":\"\"},\"aamarpay\":{\"store_id\":\"\",\"signature_key\":\"\"},\"flutterwave\":{\"public_key\":\"\",\"secret_key\":\"\"},\"tazapay\":{\"public_key\":\"\",\"api_key\":\"\",\"api_secret\":\"\"}}', NULL, '1', '0', 'c7426ffc75f84498ffb3c50cc73fc243', NULL, '[]'), ('5', 'Carolina', 'De Marcos', 'dianademarcos1985@gmail.com', NULL, NULL, '3e30b5dd313bf856f8a6ce244319d4371a662887', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1718813005', NULL, '[]', NULL, '[]', '110561', '1', '0', NULL, NULL, '[]'), ('7', 'Andreia ', 'Sá', 'andysa1982@gmail.com', NULL, NULL, '539fd05c8cd5ff71403392f3acbd2b3aad78983b', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1719229860', NULL, '[]', NULL, '[]', '101003', '1', '0', NULL, NULL, '[\"72a0a2d08dd0a3b3dbf401b963d8fd6b4139b75e\",\"18cc317ff92c2d7992528b6db02c8890596cc04c\",\"74d7f358f33ce8860e9e93abcef0949ec26c0e27\",\"05225ed1e6136e0989267d744297ed1a0ed19ea4\",\"cf95e799b8e11a6a7639d5449284c15454a06c80\",\"8421618c236d4c66ca40b8f4a34da94b15208679\",\"894f2a4c7428d7131a0ef5400eff16fc25069fb4\",\"32b220e256a49ba6fa070ee18e93d2f73006e893\",\"c3d7d527f487406fabdd131cb99c9d5de4fe982c\",\"9205629f7626b62ae3d3bf0a82cf8c7f4263d48f\",\"b731bbfed60832e693ccf3f5ba565773cdafbab5\",\"75f208d8fb61a7e5527ad53899781b437990c7b1\",\"c4bdb52653c7fa3d8ac2f82ff750265defaaa29e\",\"96b4ec72952a0d486e29a7a569f8d72eb905a50c\"]'), ('9', 'Maria Olivia', 'Silva', 'oliviaamdasilvav66@gmail.com', NULL, NULL, '99407b7bbcab93429692f5c2680542c0f47107f2', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1719239421', '1719497390', '[]', NULL, '[]', 'b2xpdmlhYW1kYXNpbHZhdjY2X19nbWFpbC5jb20tLTU3Mjc', '1', '0', 'ddf74f6b883b68a1cf9864c6e34d011d', NULL, '[\"89bb90052464cacc34aa26b8cda04f8d1d8ca188\"]'), ('10', 'Patrícia ', 'Nóbrega', 'cp.nobrega@gmail.com', NULL, NULL, 'a485b8d99c7e85c1eef332b2177c7616ac8f2560', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1719261172', NULL, '[]', NULL, '[]', '158360', '1', '0', NULL, NULL, '[\"986bc842b57b9cc4cfe0ff24bccbb57b2e6d5786\",\"3bc7663074dd2c8d571ee8b479415df2857c4ec7\",\"0f6fdeb7834b2ec9f09e0372533b05fb72b5413a\",\"4dc38073ba6fbaf8054e8f5f5add6afc883c90b3\",\"f8ceb9fc224297ffbbbabab3371b547e9de3b76b\"]'), ('11', 'Nina Sicilia ', 'Rentroia Prieto Teixeira', 'rentroianina@gmail.com', NULL, NULL, '65daedd1dad96fb27e334b659c2b950ce64808b4', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1719313797', NULL, '[]', NULL, '[]', NULL, '1', '0', '59f36acc58f74669d8d18ee348ca7b41', NULL, '[\"512c9ecd9de268dd7da5a7391514c7cf9a4cb847\",\"1729873563d3ee6a405cd4c1982b218d1da80786\",\"23d26b552b6bd1233bf64aeb67384d522880cac6\",\"e87eac33477adf4b09f2f0dfde8b92ad8fb7e64e\",\"0725976797488e79fdbbc46ca835ac4c6f9a45fd\"]'), ('12', 'Edite', 'Pinto', 'editepinto21@hotmail.com', NULL, NULL, '20a9af53480a8c5ebcda2c65d6258677c95cd858', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1719321347', NULL, '[]', NULL, '[]', '155432', '1', '0', NULL, NULL, '[\"b23fb4b0c9d10803d1d177ee39abb88d3f836c78\",\"33d37903221cd563384f63db8cac37b83ee910de\",\"2e0d40efd97f975212205ad80cca0f423be1285c\",\"6ab33a86c8eb721e2f1f2158d104c93c73d28b69\",\"cec496b2f514a9f6d2b2f5b2156f05661ef159e7\",\"911ed4dab55ca64c5c6bd3315315821643ff2420\"]'), ('13', 'Washington', 'Paula', 'wton2@hotmail.com', NULL, NULL, 'e604c15dc528bbe92340bbe97e48b0ca572b622d', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1719496672', NULL, '[]', NULL, '[]', '150261', '1', '0', NULL, NULL, '[]'), ('14', 'barbara', 'Faria', 'carolinafreitas93@hotmail.com', NULL, NULL, '9cfda73ed6c28ed1216d9ce61a18b76c214b7f47', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1721426225', NULL, '[]', NULL, '[]', '140822', '1', '0', NULL, NULL, '[\"8629e68217dffa3ab127f141c9867a000159313b\"]'), ('15', 'Catarina', 'Baeta', 'catarina.baeta@gmail.com', NULL, NULL, '747165325ee426d6872854979492675dc51aa059', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1723314592', NULL, '[]', NULL, '[]', '161182', '1', '0', NULL, NULL, '[\"412e8673a146b2bb58597b6f6a71d68546d835d7\",\"80f8d51f6c0ca3a367af08f370f81b364b879375\"]'), ('16', 'diana', 'lira', 'dianac.lira@gmail.com', NULL, NULL, 'a7ddd391b75ebf78821c49f97dec245d2f39d816', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1723584743', NULL, '[]', NULL, '[]', '177488', '1', '0', NULL, NULL, '[]'), ('17', 'Carolina', 'lira', 'dianademarcos@gmail.com', NULL, NULL, 'a7ddd391b75ebf78821c49f97dec245d2f39d816', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1724089473', NULL, '[]', NULL, '[]', '123817', '1', '0', NULL, NULL, '[\"35f57daa30fe59b683b00ee283a5e19f9e2c4770\"]');
DROP TABLE IF EXISTS `watch_histories`;
CREATE TABLE `watch_histories` (
  `watch_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `completed_lesson` longtext NOT NULL,
  `course_progress` int(11) NOT NULL,
  `watching_lesson_id` int(11) NOT NULL,
  `quiz_result` longtext NOT NULL,
  `completed_date` varchar(255) DEFAULT NULL,
  `date_added` varchar(100) DEFAULT NULL,
  `date_updated` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`watch_history_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `watch_histories` (`watch_history_id`, `course_id`, `student_id`, `completed_lesson`, `course_progress`, `watching_lesson_id`, `quiz_result`, `completed_date`, `date_added`, `date_updated`) VALUES ('1', '1', '1', '', '0', '42', '', NULL, '1717524812', '1717613840'), ('2', '2', '1', '', '0', '68', '', NULL, '1717615722', '1717626511'), ('3', '5', '9', '', '0', '132', '', NULL, '1719265251', '1719267444'), ('4', '5', '10', '[\"144\",\"145\",\"135\",\"146\",\"138\",\"110\",\"155\",\"154\",\"156\",\"150\",\"136\",\"163\",\"161\",\"162\",\"169\",\"196\",\"199\",\"190\",\"149\",\"180\",\"193\",\"200\",\"203\",\"202\",\"206\",\"204\",\"219\",\"201\",\"216\",\"207\",\"208\",\"210\",\"211\",\"213\",\"221\",\"217\",\"224\",\"184\",\"186\",\"187\"]', '67', '188', '', NULL, '1719265522', '1729170702'), ('5', '5', '1', '', '0', '0', '', NULL, '1719266755', '1729714794'), ('6', '1', '5', '', '0', '36', '', NULL, '1719268941', '1719269026'), ('7', '5', '7', '[\"135\",\"110\",\"138\",\"146\",\"182\",\"158\",\"184\",\"186\",\"187\",\"188\",\"189\",\"193\",\"183\",\"144\",\"145\",\"155\",\"162\",\"192\",\"169\",\"194\",\"154\",\"197\",\"168\",\"196\",\"204\",\"198\",\"209\",\"202\",\"205\",\"180\",\"210\",\"203\"]', '58', '225', '', NULL, '1719274248', '1729774986'), ('8', '5', '5', '', '0', '135', '', NULL, '1719314370', '1719314377'), ('9', '5', '12', '[\"135\",\"138\",\"110\",\"141\",\"194\",\"146\",\"204\",\"144\",\"145\",\"201\",\"200\",\"216\",\"224\",\"223\"]', '22', '223', '', NULL, '1719438338', '1729877019'), ('10', '5', '11', '[\"135\",\"146\",\"138\",\"110\",\"144\",\"145\",\"155\",\"156\",\"150\",\"169\",\"196\",\"136\",\"149\",\"180\",\"163\",\"162\",\"158\",\"193\",\"184\",\"186\",\"187\",\"188\",\"189\",\"183\",\"154\",\"202\",\"203\",\"206\",\"205\",\"213\",\"210\",\"211\",\"207\",\"208\",\"215\",\"224\"]', '60', '224', '', NULL, '1719680878', '1730318016'), ('11', '3', '1', '', '0', '0', '', NULL, '1720642074', '1720646813'), ('12', '6', '14', '[\"170\",\"172\",\"171\"]', '33', '176', '', NULL, '1721427802', '1722090407'), ('13', '6', '7', '[\"170\",\"171\",\"172\",\"173\",\"174\",\"175\",\"176\",\"179\",\"178\"]', '100', '178', '', '1725019367', '1721818219', '1725019367'), ('14', '6', '15', '[\"170\",\"171\"]', '22', '172', '', NULL, '1723314633', '1723397481');
DROP TABLE IF EXISTS `watched_duration`;
CREATE TABLE `watched_duration` (
  `watched_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `watched_student_id` int(11) DEFAULT NULL,
  `watched_course_id` int(11) DEFAULT NULL,
  `watched_lesson_id` int(11) DEFAULT NULL,
  `current_duration` int(20) DEFAULT NULL,
  `watched_counter` longtext DEFAULT NULL,
  PRIMARY KEY (`watched_id`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `watched_duration` (`watched_id`, `watched_student_id`, `watched_course_id`, `watched_lesson_id`, `current_duration`, `watched_counter`) VALUES ('1', '1', '1', '2', '5', '[\"5\"]'), ('2', '1', '2', '50', '5', '[\"5\"]'), ('3', '1', '5', '132', '25', '[\"5\",\"10\",\"15\",\"20\",\"25\"]'), ('4', '1', '5', '133', '155', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\"]'), ('5', NULL, '5', '133', '10', '[\"0\",\"5\",\"10\"]'), ('6', '1', '5', '134', '5', '[\"5\"]'), ('7', '1', '5', '135', '45', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\"]'), ('8', '7', '5', '135', '65', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\"]'), ('9', '7', '5', '138', '60', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\"]'), ('10', '7', '5', '139', '15', '[\"5\",\"10\",\"15\"]'), ('11', '12', '5', '135', '65', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\"]'), ('12', '12', '5', '138', '60', '[\"5\",\"30\",\"35\",\"60\"]'), ('13', '1', '5', '144', '35', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\"]'), ('14', '1', '5', '145', '20', '[\"5\",\"10\",\"15\",\"20\"]'), ('15', '10', '5', '144', '1470', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"70\",\"75\",\"90\",\"95\",\"100\",\"115\",\"120\",\"135\",\"140\",\"145\",\"160\",\"165\",\"180\",\"185\",\"190\",\"205\",\"210\",\"225\",\"230\",\"235\",\"250\",\"255\",\"270\",\"275\",\"280\",\"295\",\"300\",\"315\",\"320\",\"325\",\"340\",\"345\",\"360\",\"365\",\"370\",\"385\",\"390\",\"405\",\"410\",\"415\",\"430\",\"435\",\"450\",\"455\",\"460\",\"475\",\"480\",\"495\",\"500\",\"505\",\"520\",\"525\",\"540\",\"545\",\"550\",\"565\",\"570\",\"585\",\"590\",\"595\",\"610\",\"615\",\"630\",\"635\",\"640\",\"655\",\"660\",\"675\",\"680\",\"685\",\"700\",\"705\",\"720\",\"725\",\"730\",\"745\",\"750\",\"765\",\"770\",\"775\",\"790\",\"795\",\"810\",\"815\",\"820\",\"835\",\"840\",\"855\",\"860\",\"865\",\"880\",\"885\",\"900\",\"905\",\"910\",\"925\",\"930\",\"945\",\"950\",\"955\",\"970\",\"975\",\"990\",\"995\",\"1000\",\"1015\",\"1020\",\"1035\",\"1040\",\"1045\",\"1060\",\"1065\",\"1080\",\"1085\",\"1090\",\"1105\",\"1110\",\"1125\",\"1130\",\"1135\",\"1150\",\"1155\",\"1170\",\"1175\",\"1180\",\"1195\",\"1200\",\"1215\",\"1220\",\"1225\",\"1240\",\"1245\",\"1260\",\"1265\",\"1270\",\"1285\",\"1290\",\"1305\",\"1310\",\"1315\",\"1330\",\"1335\",\"1350\",\"1355\",\"1360\",\"1375\",\"1380\",\"1395\",\"1400\",\"1405\",\"1420\",\"1425\",\"1440\",\"1445\",\"1450\",\"1465\",\"1470\"]'), ('16', '10', '5', '145', '2105', '[\"5\",\"20\",\"25\",\"30\",\"45\",\"50\",\"65\",\"70\",\"75\",\"90\",\"95\",\"110\",\"115\",\"120\",\"135\",\"140\",\"155\",\"160\",\"165\",\"175\",\"180\",\"185\",\"200\",\"205\",\"220\",\"225\",\"230\",\"245\",\"250\",\"265\",\"270\",\"275\",\"290\",\"295\",\"310\",\"315\",\"320\",\"335\",\"340\",\"350\",\"355\",\"370\",\"375\",\"380\",\"395\",\"400\",\"410\",\"425\",\"430\",\"435\",\"450\",\"455\",\"470\",\"475\",\"480\",\"495\",\"500\",\"515\",\"520\",\"525\",\"540\",\"545\",\"560\",\"565\",\"570\",\"585\",\"590\",\"605\",\"610\",\"615\",\"630\",\"635\",\"650\",\"655\",\"660\",\"675\",\"680\",\"685\",\"665\",\"670\",\"695\",\"700\",\"715\",\"720\",\"725\",\"740\",\"745\",\"760\",\"765\",\"770\",\"785\",\"790\",\"805\",\"810\",\"815\",\"830\",\"835\",\"850\",\"855\",\"860\",\"875\",\"880\",\"895\",\"900\",\"905\",\"920\",\"925\",\"940\",\"945\",\"950\",\"965\",\"970\",\"985\",\"990\",\"995\",\"1010\",\"1015\",\"1030\",\"1035\",\"1040\",\"1055\",\"1060\",\"1075\",\"1080\",\"1085\",\"1100\",\"1105\",\"1120\",\"1125\",\"1130\",\"1145\",\"1150\",\"1165\",\"1170\",\"1175\",\"1190\",\"1195\",\"1210\",\"1215\",\"1220\",\"1235\",\"1240\",\"1255\",\"1260\",\"1265\",\"1280\",\"1285\",\"1300\",\"1305\",\"1310\",\"1325\",\"1330\",\"1345\",\"1350\",\"1355\",\"1370\",\"1375\",\"1390\",\"1395\",\"1400\",\"1415\",\"1420\",\"1435\",\"1440\",\"1445\",\"1460\",\"1465\",\"1480\",\"1485\",\"1490\",\"1505\",\"1510\",\"1525\",\"1530\",\"1535\",\"1550\",\"1555\",\"1570\",\"1575\",\"1580\",\"1595\",\"1600\",\"1615\",\"1620\",\"1625\",\"1640\",\"1645\",\"1660\",\"1665\",\"1670\",\"1685\",\"1690\",\"1705\",\"1710\",\"1715\",\"1730\",\"1735\",\"1750\",\"1755\",\"1760\",\"1775\",\"1780\",\"1795\",\"1800\",\"1805\",\"1820\",\"1825\",\"1840\",\"1845\",\"1850\",\"1865\",\"1870\",\"1885\",\"1890\",\"1895\",\"1910\",\"1915\",\"1930\",\"1935\",\"1940\",\"1955\",\"1960\",\"1975\",\"1980\",\"1985\",\"2000\",\"2005\",\"2020\",\"2025\",\"2030\",\"2045\",\"2050\",\"2065\",\"2070\",\"2075\",\"2090\",\"2095\",\"2105\"]'), ('17', '10', '5', '135', '65', '[\"15\",\"20\",\"35\",\"40\",\"45\",\"50\",\"55\",\"65\"]'), ('18', '10', '5', '146', '145', '[\"5\",\"10\",\"25\",\"30\",\"45\",\"50\",\"55\",\"70\",\"75\",\"90\",\"95\",\"100\",\"115\",\"120\",\"135\",\"140\",\"145\"]'), ('19', '10', '5', '138', '50', '[\"5\",\"20\",\"25\",\"40\",\"45\",\"50\"]'), ('20', '11', '5', '135', '65', '[\"5\",\"15\",\"20\",\"25\",\"35\",\"40\",\"50\",\"55\",\"65\"]'), ('21', '11', '5', '146', '155', '[\"5\",\"10\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"55\",\"60\",\"70\",\"75\",\"80\",\"90\",\"95\",\"105\",\"110\",\"120\",\"125\",\"130\",\"140\",\"145\",\"155\"]'), ('22', '11', '5', '138', '60', '[\"5\",\"10\",\"15\",\"25\",\"30\",\"40\",\"45\",\"50\",\"60\",\"0\",\"20\",\"55\"]'), ('23', '11', '5', '144', '1195', '[\"10\",\"15\",\"115\",\"230\",\"315\",\"545\",\"590\",\"665\",\"640\",\"645\",\"650\",\"630\",\"635\",\"585\",\"660\",\"770\",\"800\",\"805\",\"810\",\"820\",\"825\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"870\",\"875\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"920\",\"925\",\"935\",\"940\",\"945\",\"955\",\"960\",\"970\",\"975\",\"985\",\"990\",\"995\",\"1005\",\"1010\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1195\"]'), ('24', '11', '5', '145', '290', '[\"5\",\"260\",\"265\",\"275\",\"280\",\"290\"]'), ('25', '12', '5', '144', '0', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"900\",\"905\",\"910\",\"1235\",\"1240\",\"1360\",\"1445\",\"0\"]'), ('26', '12', '5', '145', '2105', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"990\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1135\",\"1140\",\"1145\",\"1150\",\"1155\",\"1160\",\"1165\",\"1170\",\"1175\",\"1180\",\"1185\",\"1190\",\"1195\",\"1200\",\"1205\",\"1210\",\"1215\",\"1220\",\"1225\",\"1230\",\"1235\",\"1240\",\"1245\",\"1250\",\"1255\",\"1260\",\"1265\",\"1270\",\"1275\",\"1280\",\"1285\",\"1290\",\"1295\",\"1300\",\"1305\",\"1310\",\"1315\",\"1320\",\"1325\",\"1330\",\"1335\",\"1340\",\"1345\",\"1350\",\"1355\",\"1360\",\"1365\",\"1370\",\"1375\",\"1380\",\"1385\",\"1390\",\"1395\",\"1400\",\"1405\",\"1410\",\"1415\",\"1420\",\"1425\",\"1430\",\"1435\",\"1440\",\"1445\",\"1450\",\"1455\",\"1460\",\"1465\",\"1470\",\"1475\",\"1480\",\"1485\",\"1490\",\"1495\",\"1500\",\"1505\",\"1510\",\"1515\",\"1520\",\"1525\",\"1530\",\"1535\",\"1540\",\"1545\",\"1550\",\"1555\",\"1560\",\"1565\",\"1570\",\"1575\",\"1580\",\"1585\",\"1590\",\"1595\",\"1600\",\"1605\",\"1610\",\"1615\",\"1620\",\"1625\",\"1630\",\"1635\",\"1640\",\"1645\",\"1650\",\"1655\",\"1660\",\"1665\",\"1670\",\"1675\",\"1680\",\"1685\",\"1690\",\"1695\",\"1700\",\"1705\",\"1710\",\"1715\",\"1720\",\"1725\",\"1730\",\"1735\",\"1740\",\"1745\",\"1750\",\"1755\",\"1760\",\"1765\",\"1770\",\"1775\",\"1780\",\"1785\",\"1790\",\"1795\",\"1800\",\"1805\",\"1810\",\"1815\",\"1820\",\"1825\",\"1830\",\"1835\",\"1840\",\"1845\",\"1850\",\"1855\",\"1860\",\"1865\",\"1870\",\"1875\",\"1880\",\"1885\",\"1890\",\"1895\",\"1900\",\"1905\",\"1910\",\"1915\",\"1920\",\"1925\",\"1930\",\"1935\",\"1940\",\"1945\",\"1950\",\"1955\",\"1960\",\"1965\",\"1970\",\"1975\",\"1980\",\"1985\",\"1990\",\"1995\",\"2000\",\"2005\",\"2010\",\"2015\",\"2020\",\"2025\",\"2030\",\"2035\",\"2040\",\"2045\",\"2050\",\"2055\",\"2060\",\"2065\",\"2070\",\"2075\",\"2080\",\"2085\",\"2090\",\"2095\",\"2100\",\"2105\"]'), ('27', '10', '5', '155', '945', '[\"5\",\"15\",\"20\",\"25\",\"40\",\"45\",\"60\",\"65\",\"70\",\"85\",\"90\",\"95\",\"105\",\"110\",\"115\",\"130\",\"135\",\"150\",\"155\",\"160\",\"175\",\"180\",\"195\",\"200\",\"205\",\"220\",\"225\",\"230\",\"240\",\"245\",\"250\",\"265\",\"270\",\"275\",\"290\",\"295\",\"310\",\"315\",\"320\",\"335\",\"340\",\"355\",\"360\",\"365\",\"375\",\"380\",\"385\",\"400\",\"405\",\"410\",\"425\",\"430\",\"445\",\"450\",\"455\",\"470\",\"475\",\"490\",\"495\",\"500\",\"515\",\"520\",\"535\",\"540\",\"545\",\"560\",\"565\",\"580\",\"585\",\"590\",\"605\",\"610\",\"625\",\"630\",\"635\",\"650\",\"655\",\"670\",\"675\",\"680\",\"690\",\"695\",\"700\",\"715\",\"720\",\"740\",\"745\",\"760\",\"765\",\"770\",\"785\",\"790\",\"805\",\"810\",\"815\",\"830\",\"835\",\"850\",\"855\",\"860\",\"875\",\"880\",\"895\",\"900\",\"920\",\"925\",\"940\",\"945\"]'), ('28', '10', '5', '156', '1540', '[\"5\",\"10\",\"15\",\"30\",\"35\",\"40\",\"50\",\"55\",\"60\",\"25\",\"0\",\"20\",\"45\",\"65\",\"70\",\"85\",\"90\",\"95\",\"110\",\"115\",\"130\",\"135\",\"140\",\"155\",\"160\",\"175\",\"180\",\"185\",\"200\",\"205\",\"220\",\"225\",\"230\",\"245\",\"250\",\"265\",\"270\",\"275\",\"290\",\"295\",\"310\",\"315\",\"320\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"600\",\"605\",\"610\",\"625\",\"630\",\"645\",\"650\",\"655\",\"670\",\"675\",\"690\",\"695\",\"700\",\"715\",\"720\",\"735\",\"740\",\"745\",\"760\",\"765\",\"780\",\"785\",\"790\",\"805\",\"810\",\"825\",\"830\",\"835\",\"850\",\"855\",\"870\",\"875\",\"880\",\"895\",\"900\",\"915\",\"920\",\"925\",\"940\",\"945\",\"960\",\"965\",\"970\",\"985\",\"990\",\"1005\",\"1010\",\"1015\",\"1030\",\"1035\",\"1050\",\"1055\",\"1060\",\"1075\",\"1080\",\"1095\",\"1100\",\"1105\",\"1120\",\"1125\",\"1140\",\"1145\",\"1150\",\"1165\",\"1170\",\"1185\",\"1190\",\"1195\",\"1210\",\"1215\",\"1230\",\"1235\",\"1240\",\"1255\",\"1260\",\"1275\",\"1280\",\"1285\",\"1300\",\"1305\",\"1320\",\"1325\",\"1330\",\"1345\",\"1350\",\"1365\",\"1370\",\"1375\",\"1390\",\"1395\",\"1410\",\"1415\",\"1420\",\"1435\",\"1440\",\"1455\",\"1460\",\"1465\",\"1480\",\"1485\",\"1490\",\"1505\",\"1510\",\"1525\",\"1530\",\"1535\",\"1540\"]'), ('29', '10', '5', '154', '1110', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"990\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\"]'), ('30', '11', '5', '154', '970', '[\"5\",\"15\",\"20\",\"30\",\"35\",\"45\",\"50\",\"55\",\"700\",\"805\",\"860\",\"980\",\"990\",\"940\",\"945\",\"950\",\"955\",\"965\",\"970\"]'), ('31', '11', '5', '155', '10', '[\"10\"]'), ('32', '11', '5', '156', '1540', '[\"10\",\"15\",\"160\",\"585\",\"680\",\"790\",\"840\",\"955\",\"1115\",\"1145\",\"1515\",\"1490\",\"1510\",\"1520\",\"1525\",\"1530\",\"1540\"]'), ('33', '11', '5', '150', '4360', '[\"395\",\"30\",\"340\",\"345\",\"350\",\"480\",\"485\",\"490\",\"500\",\"820\",\"825\",\"830\",\"4235\",\"4340\",\"4270\",\"4280\",\"4285\",\"4295\",\"4300\",\"4305\",\"4315\",\"4320\",\"4330\",\"4335\",\"4345\",\"4350\",\"4355\",\"4360\"]'), ('34', '10', '5', '150', '4535', '[\"260\",\"270\",\"275\",\"280\",\"295\",\"300\",\"315\",\"320\",\"325\",\"340\",\"345\",\"360\",\"365\",\"370\",\"385\",\"390\",\"405\",\"410\",\"415\",\"430\",\"435\",\"450\",\"455\",\"460\",\"805\",\"570\",\"575\",\"590\",\"595\",\"600\",\"615\",\"620\",\"635\",\"640\",\"645\",\"660\",\"665\",\"680\",\"685\",\"690\",\"705\",\"710\",\"725\",\"730\",\"735\",\"750\",\"755\",\"770\",\"775\",\"780\",\"795\",\"800\",\"815\",\"820\",\"825\",\"840\",\"845\",\"860\",\"865\",\"870\",\"885\",\"890\",\"905\",\"910\",\"915\",\"930\",\"935\",\"950\",\"955\",\"960\",\"975\",\"980\",\"995\",\"1000\",\"1005\",\"1020\",\"1025\",\"1040\",\"1045\",\"1050\",\"1065\",\"1070\",\"1085\",\"1090\",\"1095\",\"1110\",\"1115\",\"1130\",\"1135\",\"1140\",\"1155\",\"1160\",\"1175\",\"1180\",\"1185\",\"1200\",\"1205\",\"1220\",\"1225\",\"1230\",\"1245\",\"1250\",\"1265\",\"1270\",\"1275\",\"1290\",\"1295\",\"1310\",\"1315\",\"1320\",\"1335\",\"1340\",\"1355\",\"1360\",\"1365\",\"1380\",\"1385\",\"1400\",\"1405\",\"1410\",\"1425\",\"1430\",\"1445\",\"1450\",\"1455\",\"1470\",\"1475\",\"1490\",\"1495\",\"1500\",\"1515\",\"1520\",\"1535\",\"1540\",\"1545\",\"1560\",\"1565\",\"1580\",\"1585\",\"1590\",\"1605\",\"1610\",\"1625\",\"1630\",\"1635\",\"1650\",\"1655\",\"1670\",\"1675\",\"1680\",\"1695\",\"1700\",\"1715\",\"1720\",\"1725\",\"1740\",\"1745\",\"1760\",\"1765\",\"1770\",\"1785\",\"1790\",\"1805\",\"1810\",\"1815\",\"1830\",\"1835\",\"1850\",\"1855\",\"1860\",\"1875\",\"1880\",\"1895\",\"1900\",\"1905\",\"1920\",\"1925\",\"1940\",\"1945\",\"1950\",\"1965\",\"1970\",\"1985\",\"1990\",\"1995\",\"2010\",\"2015\",\"2030\",\"2035\",\"2040\",\"2055\",\"2060\",\"2075\",\"2080\",\"2085\",\"2100\",\"2105\",\"2120\",\"2125\",\"2130\",\"2145\",\"2150\",\"2165\",\"2170\",\"2175\",\"2190\",\"2195\",\"2210\",\"2215\",\"2220\",\"2235\",\"2240\",\"2255\",\"2260\",\"2265\",\"2280\",\"2285\",\"2300\",\"2305\",\"2310\",\"2325\",\"2330\",\"2345\",\"2350\",\"2355\",\"2370\",\"2375\",\"2390\",\"2395\",\"2400\",\"2415\",\"2420\",\"2435\",\"2440\",\"2445\",\"2460\",\"2465\",\"2480\",\"2485\",\"2490\",\"2505\",\"2510\",\"2525\",\"2530\",\"2535\",\"2550\",\"2555\",\"2570\",\"2575\",\"2580\",\"2595\",\"2600\",\"2615\",\"2620\",\"2625\",\"2640\",\"2645\",\"2660\",\"2665\",\"2670\",\"2685\",\"2690\",\"2705\",\"2710\",\"2715\",\"2730\",\"2735\",\"2750\",\"2755\",\"2760\",\"2775\",\"2780\",\"2795\",\"2800\",\"2805\",\"2820\",\"2825\",\"2840\",\"2845\",\"2850\",\"2865\",\"2870\",\"2885\",\"2890\",\"2895\",\"2910\",\"2915\",\"2930\",\"2935\",\"2940\",\"2955\",\"2960\",\"2975\",\"2980\",\"2985\",\"3000\",\"3005\",\"3020\",\"3025\",\"3030\",\"3045\",\"3050\",\"3065\",\"3070\",\"3075\",\"3090\",\"3095\",\"3110\",\"3115\",\"3120\",\"3135\",\"3140\",\"3155\",\"3160\",\"3165\",\"3180\",\"3185\",\"3200\",\"3205\",\"3210\",\"3225\",\"3230\",\"3245\",\"3250\",\"3255\",\"3270\",\"3275\",\"3290\",\"3295\",\"3300\",\"3315\",\"3320\",\"3335\",\"3340\",\"3345\",\"3360\",\"3365\",\"3380\",\"3385\",\"3390\",\"3405\",\"3410\",\"3425\",\"3430\",\"3435\",\"3450\",\"3455\",\"3470\",\"3475\",\"3480\",\"3495\",\"3500\",\"3515\",\"3520\",\"3525\",\"3540\",\"3545\",\"3560\",\"3565\",\"3570\",\"3585\",\"3590\",\"3605\",\"3610\",\"3615\",\"3630\",\"3635\",\"3650\",\"3655\",\"3660\",\"3675\",\"3680\",\"3695\",\"3700\",\"3705\",\"3720\",\"3725\",\"3740\",\"3745\",\"3750\",\"3765\",\"3770\",\"3785\",\"3790\",\"3795\",\"3810\",\"3815\",\"3830\",\"3835\",\"3840\",\"3855\",\"3860\",\"3875\",\"3880\",\"3885\",\"3900\",\"3905\",\"3920\",\"3925\",\"3930\",\"3945\",\"3950\",\"3965\",\"3970\",\"3975\",\"3990\",\"3995\",\"4010\",\"4015\",\"4020\",\"4035\",\"4040\",\"4055\",\"4060\",\"4065\",\"4080\",\"4085\",\"4100\",\"4105\",\"4110\",\"4125\",\"4130\",\"4145\",\"4150\",\"4155\",\"4170\",\"4175\",\"4190\",\"4195\",\"4200\",\"4215\",\"4220\",\"4235\",\"4240\",\"4245\",\"4260\",\"4265\",\"4280\",\"4285\",\"4290\",\"4305\",\"4310\",\"4325\",\"4330\",\"4335\",\"4350\",\"4355\",\"4370\",\"4375\",\"4380\",\"4395\",\"4400\",\"4415\",\"4420\",\"4425\",\"4440\",\"4445\",\"4460\",\"4465\",\"4470\",\"4485\",\"4490\",\"4505\",\"4510\",\"4515\",\"4530\",\"4535\"]'), ('35', '1', '5', '163', '10', '[\"5\",\"10\",\"335\",\"340\",\"0\"]'), ('36', '7', '5', '146', '155', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"145\",\"125\",\"130\",\"135\",\"140\",\"150\",\"155\"]'), ('37', '7', '5', '144', '1470', '[\"5\",\"540\",\"745\",\"750\",\"1410\",\"1415\",\"1420\",\"1425\",\"1430\",\"1435\",\"1440\",\"1445\",\"0\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"990\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1135\",\"1140\",\"1145\",\"1150\",\"1155\",\"1160\",\"1165\",\"1170\",\"1175\",\"1180\",\"1185\",\"1190\",\"1195\",\"1200\",\"1205\",\"1210\",\"1215\",\"1220\",\"1225\",\"1230\",\"1235\",\"1240\",\"1245\",\"1250\",\"1255\",\"1260\",\"1265\",\"1270\",\"1275\",\"1280\",\"1285\",\"1290\",\"1295\",\"1300\",\"1305\",\"1310\",\"1315\",\"1320\",\"1325\",\"1330\",\"1335\",\"1340\",\"1345\",\"1350\",\"1355\",\"1360\",\"1365\",\"1370\",\"1375\",\"1380\",\"1385\",\"1390\",\"1395\",\"1400\",\"1405\",\"1450\",\"1455\",\"1460\",\"1465\",\"1470\"]'), ('38', '7', '5', '155', '945', '[\"90\",\"570\",\"0\",\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\"]'), ('39', '7', '5', '150', '1135', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"990\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1135\"]'), ('40', '10', '5', '163', '1335', '[\"5\",\"10\",\"25\",\"30\",\"35\",\"50\",\"55\",\"75\",\"80\",\"85\",\"100\",\"105\",\"120\",\"125\",\"130\",\"145\",\"150\",\"165\",\"170\",\"175\",\"190\",\"195\",\"210\",\"215\",\"220\",\"235\",\"240\",\"255\",\"260\",\"265\",\"280\",\"285\",\"300\",\"305\",\"310\",\"325\",\"330\",\"345\",\"350\",\"355\",\"370\",\"375\",\"390\",\"395\",\"400\",\"415\",\"420\",\"435\",\"440\",\"445\",\"460\",\"465\",\"480\",\"485\",\"490\",\"505\",\"510\",\"525\",\"530\",\"535\",\"550\",\"555\",\"570\",\"575\",\"580\",\"595\",\"600\",\"615\",\"620\",\"625\",\"640\",\"645\",\"660\",\"665\",\"670\",\"685\",\"690\",\"705\",\"710\",\"715\",\"730\",\"735\",\"750\",\"755\",\"760\",\"775\",\"780\",\"795\",\"800\",\"805\",\"820\",\"910\",\"915\",\"920\",\"935\",\"940\",\"825\",\"840\",\"845\",\"850\",\"865\",\"870\",\"885\",\"890\",\"895\",\"930\",\"955\",\"960\",\"975\",\"980\",\"985\",\"1000\",\"1005\",\"1020\",\"1025\",\"1030\",\"1045\",\"1050\",\"1065\",\"1070\",\"1075\",\"1090\",\"1095\",\"1110\",\"1115\",\"1120\",\"1135\",\"1140\",\"1155\",\"1160\",\"1165\",\"1180\",\"1185\",\"1200\",\"1205\",\"1210\",\"1225\",\"1230\",\"1245\",\"1250\",\"1255\",\"1270\",\"1275\",\"1290\",\"1295\",\"1300\",\"1315\",\"1320\",\"1335\"]'), ('41', '10', '5', '161', '660', '[\"5\",\"10\",\"25\",\"30\",\"45\",\"50\",\"55\",\"70\",\"75\",\"90\",\"95\",\"100\",\"115\",\"120\",\"135\",\"140\",\"145\",\"160\",\"165\",\"180\",\"185\",\"190\",\"205\",\"210\",\"265\",\"270\",\"285\",\"290\",\"295\",\"310\",\"315\",\"380\",\"385\",\"390\",\"395\",\"410\",\"415\",\"430\",\"435\",\"440\",\"455\",\"460\",\"465\",\"475\",\"480\",\"485\",\"500\",\"505\",\"510\",\"520\",\"525\",\"530\",\"545\",\"550\",\"555\",\"565\",\"570\",\"575\",\"590\",\"595\",\"610\",\"615\",\"620\",\"635\",\"640\",\"645\",\"655\",\"660\"]'), ('42', '10', '5', '162', '470', '[\"15\",\"20\",\"25\",\"50\",\"55\",\"60\",\"75\",\"80\",\"95\",\"100\",\"105\",\"110\",\"125\",\"130\",\"145\",\"150\",\"155\",\"170\",\"175\",\"190\",\"195\",\"200\",\"215\",\"220\",\"235\",\"240\",\"245\",\"260\",\"265\",\"280\",\"285\",\"290\",\"305\",\"310\",\"325\",\"330\",\"335\",\"350\",\"355\",\"370\",\"375\",\"380\",\"395\",\"400\",\"415\",\"420\",\"425\",\"440\",\"445\",\"460\",\"465\",\"470\"]'), ('43', '1', '5', '161', '360', '[\"5\",\"100\",\"265\",\"380\",\"0\",\"495\",\"500\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\"]'), ('44', '1', '5', '162', '155', '[\"45\",\"245\",\"420\",\"0\",\"10\",\"150\",\"155\"]'), ('45', '1', '5', '169', '5805', '[\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"0\",\"5\",\"760\",\"1190\",\"1745\",\"3795\",\"4430\",\"4435\",\"4440\",\"5805\"]'), ('46', '1', '5', '180', '595', '[\"370\",\"495\",\"510\",\"595\"]'), ('47', '1', '5', '184', '90', '[\"90\"]'), ('48', '1', '5', '185', '215', '[\"10\",\"195\",\"200\",\"205\",\"210\",\"215\"]'), ('49', '1', '5', '186', '80', '[\"45\",\"80\"]'), ('50', '1', '5', '189', '80', '[\"80\"]'), ('51', '1', '5', '182', '175', '[\"175\"]'), ('52', '1', '5', '155', '110', '[\"110\"]'), ('53', '1', '5', '156', '210', '[\"210\"]'), ('54', '7', '5', '163', '335', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"795\",\"800\",\"805\",\"0\"]'), ('55', '12', '5', '169', '2760', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"990\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1135\",\"1140\",\"1145\",\"1150\",\"1155\",\"1160\",\"1165\",\"1170\",\"1175\",\"1180\",\"1185\",\"1190\",\"1195\",\"1200\",\"1205\",\"1210\",\"1215\",\"1220\",\"1225\",\"1230\",\"1235\",\"1240\",\"1245\",\"1250\",\"1255\",\"1260\",\"1265\",\"1270\",\"1275\",\"1280\",\"1285\",\"1290\",\"1295\",\"1300\",\"1305\",\"1310\",\"1315\",\"1320\",\"1325\",\"1330\",\"1335\",\"1340\",\"1345\",\"1350\",\"1355\",\"1360\",\"1365\",\"1370\",\"1375\",\"1380\",\"1385\",\"1390\",\"1395\",\"1400\",\"1405\",\"1410\",\"1415\",\"1420\",\"1425\",\"1430\",\"1435\",\"1440\",\"1445\",\"1450\",\"1455\",\"1460\",\"1465\",\"1470\",\"1475\",\"1480\",\"1485\",\"1490\",\"1495\",\"1500\",\"1505\",\"1510\",\"1515\",\"1520\",\"1525\",\"1530\",\"1535\",\"1540\",\"1545\",\"1550\",\"1555\",\"1560\",\"1565\",\"1570\",\"1575\",\"1580\",\"1585\",\"1590\",\"1595\",\"1600\",\"1605\",\"1610\",\"1615\",\"1620\",\"1625\",\"1630\",\"1635\",\"1640\",\"1645\",\"1650\",\"1655\",\"1660\",\"1665\",\"1670\",\"1675\",\"1680\",\"1685\",\"1690\",\"1695\",\"1700\",\"1705\",\"1710\",\"1715\",\"1720\",\"1725\",\"1730\",\"1735\",\"1740\",\"1745\",\"1750\",\"1755\",\"1760\",\"1765\",\"1770\",\"1775\",\"1780\",\"1785\",\"1790\",\"1795\",\"1800\",\"1805\",\"1810\",\"1815\",\"1820\",\"1825\",\"1830\",\"1835\",\"1840\",\"1845\",\"1850\",\"1855\",\"1860\",\"1865\",\"1870\",\"1875\",\"1880\",\"1885\",\"1890\",\"1895\",\"1900\",\"1905\",\"1910\",\"1915\",\"1920\",\"1925\",\"1930\",\"1935\",\"1940\",\"1945\",\"1950\",\"1955\",\"1960\",\"1965\",\"1970\",\"1975\",\"1980\",\"1985\",\"1990\",\"1995\",\"2000\",\"2005\",\"2010\",\"2015\",\"2020\",\"2025\",\"2030\",\"2035\",\"2040\",\"2045\",\"2050\",\"2055\",\"2060\",\"2065\",\"2070\",\"2075\",\"2080\",\"2085\",\"2090\",\"2095\",\"2100\",\"2105\",\"2110\",\"2115\",\"2120\",\"2125\",\"2130\",\"2135\",\"2140\",\"2145\",\"2150\",\"2155\",\"2160\",\"2165\",\"2170\",\"2175\",\"2180\",\"2185\",\"2190\",\"2195\",\"2200\",\"2205\",\"2210\",\"2215\",\"2220\",\"2225\",\"2230\",\"2235\",\"2240\",\"2245\",\"2250\",\"2255\",\"2260\",\"2265\",\"2270\",\"2275\",\"2280\",\"2285\",\"2290\",\"2295\",\"2300\",\"2305\",\"2310\",\"2315\",\"2320\",\"2325\",\"2330\",\"2335\",\"2340\",\"2345\",\"2350\",\"2355\",\"2360\",\"2365\",\"2370\",\"2375\",\"2380\",\"2385\",\"2390\",\"2395\",\"2400\",\"2405\",\"2410\",\"2415\",\"2420\",\"2425\",\"2430\",\"2435\",\"2440\",\"2445\",\"2450\",\"2455\",\"2460\",\"2465\",\"2470\",\"2475\",\"2480\",\"2485\",\"2490\",\"2495\",\"2500\",\"2505\",\"2510\",\"2515\",\"2520\",\"2525\",\"2530\",\"2535\",\"2540\",\"2545\",\"2550\",\"2555\",\"2560\",\"2565\",\"2570\",\"2575\",\"2580\",\"2585\",\"2590\",\"2595\",\"2600\",\"2605\",\"2610\",\"2615\",\"2620\",\"2625\",\"2630\",\"2635\",\"2640\",\"2645\",\"2650\",\"2655\",\"2660\",\"2665\",\"2670\",\"2675\",\"2680\",\"2685\",\"2690\",\"2695\",\"2700\",\"2705\",\"2710\",\"2715\",\"2720\",\"2725\",\"2730\",\"2735\",\"2740\",\"2745\",\"2750\",\"2755\",\"2760\",\"2765\",\"2770\",\"2775\",\"2780\",\"2785\",\"2790\",\"2795\",\"2800\",\"2805\",\"2810\",\"2815\",\"2820\",\"2825\",\"2830\",\"2835\",\"3585\",\"2880\",\"2885\",\"2890\",\"2895\",\"2900\",\"2905\",\"2910\",\"2915\",\"2920\",\"2925\",\"2930\",\"2935\",\"2940\",\"2945\",\"2950\",\"2955\",\"2960\",\"2965\",\"2970\",\"2975\",\"2980\",\"2985\",\"2990\",\"2995\",\"3000\",\"3005\",\"3010\",\"3015\",\"3020\",\"3025\",\"3030\",\"3035\",\"3040\",\"3045\",\"3050\",\"3055\",\"3060\",\"3065\",\"3070\",\"3075\",\"3080\",\"3085\",\"3090\",\"3095\",\"3100\",\"3105\",\"3110\",\"3115\",\"3120\",\"3125\",\"3130\",\"3135\",\"3140\",\"3145\",\"3150\",\"3155\",\"3160\",\"3165\",\"3170\",\"3175\",\"3180\",\"3185\",\"3190\",\"3195\",\"3200\",\"3205\",\"3210\",\"3215\",\"3220\",\"3225\",\"3230\",\"3235\",\"3240\",\"3245\",\"3250\",\"3255\",\"3260\",\"3265\",\"3270\",\"3275\",\"3280\",\"3285\",\"3290\",\"3295\",\"3300\",\"3305\",\"3310\",\"3315\",\"3320\",\"3325\",\"3330\",\"3335\",\"3340\",\"3345\",\"3350\",\"3355\",\"3360\",\"3365\",\"3370\",\"3375\",\"3380\",\"3385\",\"3390\",\"3395\",\"3400\",\"3405\",\"3410\",\"3415\",\"3420\",\"3425\",\"3430\",\"3435\",\"3440\",\"3445\",\"3450\",\"3455\",\"3460\",\"3465\",\"3470\",\"3475\",\"3480\",\"3485\",\"3490\",\"3495\",\"3500\",\"3505\",\"3510\",\"3515\",\"3520\",\"3525\",\"3530\",\"3535\",\"3540\",\"3545\",\"3550\",\"3555\",\"3560\",\"3565\",\"3570\",\"3575\",\"3580\",\"3590\",\"3595\",\"3600\",\"3605\",\"3610\",\"3615\",\"3620\",\"3625\",\"3630\",\"3635\",\"3640\",\"3645\",\"3650\",\"3655\",\"3660\",\"3665\",\"3670\",\"3675\",\"3680\",\"3685\",\"3690\",\"3695\",\"3700\",\"3705\",\"3710\",\"3715\",\"3720\",\"3725\",\"3730\",\"3735\",\"3740\",\"3745\",\"3750\",\"3755\",\"3760\",\"3765\",\"3770\",\"3775\",\"3780\",\"3785\",\"3790\",\"3795\",\"3800\",\"3805\",\"3810\",\"3815\",\"3820\",\"3825\",\"3830\",\"3835\",\"3840\",\"3845\",\"3850\",\"3855\",\"3860\",\"3865\",\"3870\",\"3875\",\"3880\",\"3885\",\"3890\",\"3895\",\"3900\",\"3905\",\"3910\",\"3915\",\"3920\",\"3925\",\"3930\",\"3935\",\"3940\",\"3945\",\"3950\",\"3955\",\"3960\",\"3965\",\"3970\",\"3975\",\"3980\",\"3985\",\"3990\",\"3995\",\"4000\",\"4005\",\"4010\",\"4015\",\"4020\",\"4025\",\"4030\",\"4035\",\"4040\",\"4045\",\"4050\",\"4055\",\"4060\",\"4065\",\"4070\",\"4075\",\"4080\",\"4085\",\"4090\",\"4095\",\"4100\",\"4105\",\"4110\",\"4115\",\"4120\",\"4125\",\"4130\",\"4135\",\"4140\",\"4145\",\"4150\",\"4155\",\"4160\",\"4165\",\"4170\",\"4175\",\"4180\",\"4185\",\"4190\",\"4195\",\"4200\",\"4205\",\"4210\",\"4215\",\"4220\",\"4225\",\"4230\",\"4235\",\"4240\",\"4245\",\"4250\",\"4255\",\"4260\",\"4265\",\"4270\",\"4275\",\"4280\",\"4285\",\"4290\",\"4295\",\"4300\",\"4305\",\"4310\",\"4315\",\"4320\",\"4325\",\"4330\",\"4335\",\"4340\",\"4345\",\"4350\",\"4355\",\"4360\",\"4365\",\"4370\",\"4375\",\"4380\",\"4385\",\"4390\",\"4395\",\"4400\",\"4405\",\"4410\",\"4415\",\"4420\",\"4425\",\"4430\",\"4435\",\"4440\",\"4445\",\"4450\",\"4455\",\"4460\",\"4465\",\"4470\",\"4475\",\"4480\",\"4485\",\"4490\",\"4495\",\"4500\",\"4505\",\"4510\",\"4515\",\"4520\",\"4525\",\"4530\",\"4535\",\"4540\",\"4545\",\"4550\",\"4555\",\"4560\",\"4565\",\"4570\",\"4575\",\"4580\",\"4585\",\"4590\",\"4595\",\"4600\",\"4605\",\"4610\",\"4615\",\"4620\",\"4625\",\"4630\",\"4635\",\"4640\",\"4645\",\"4650\",\"4655\",\"4660\",\"4665\",\"4670\",\"4675\",\"4680\",\"4685\",\"4690\",\"4695\",\"4700\",\"4705\",\"4710\",\"4715\",\"4720\",\"4725\",\"4730\",\"4735\",\"4740\",\"4745\",\"4750\",\"4755\",\"4760\",\"4765\",\"4770\",\"4775\",\"4780\",\"4785\",\"4790\",\"4795\",\"4800\",\"4805\",\"4810\",\"4815\",\"4820\",\"4825\",\"4830\",\"4835\",\"4840\",\"4845\",\"4850\",\"4855\",\"4860\",\"4865\",\"4870\",\"4875\",\"4880\",\"4885\",\"4890\",\"4895\",\"4900\",\"4905\",\"4910\",\"4915\",\"4920\",\"4925\",\"4930\",\"4935\",\"4940\",\"4945\",\"4950\",\"4955\",\"4960\",\"4965\",\"4970\",\"4975\",\"4980\",\"4985\",\"4990\",\"4995\",\"5000\",\"5005\",\"5010\",\"5015\",\"5020\",\"5025\",\"5030\",\"5035\",\"5040\",\"5045\",\"5050\",\"5055\",\"5060\",\"5065\",\"5070\",\"5075\",\"5080\",\"5085\",\"5090\",\"5095\",\"5100\",\"5105\",\"5110\",\"5115\",\"5120\",\"5125\",\"5130\",\"5135\",\"5140\",\"5145\",\"5150\",\"5155\",\"5160\",\"5165\",\"5170\",\"5175\",\"5180\",\"5185\",\"5190\",\"5195\",\"5200\",\"5205\",\"5210\",\"5215\",\"5220\",\"5225\",\"5230\",\"5235\",\"5240\",\"5245\",\"5250\",\"5255\",\"5260\",\"5265\",\"5270\",\"5275\",\"5280\",\"5285\",\"5290\",\"5295\",\"5300\",\"5305\",\"5310\",\"5315\",\"5320\",\"5325\",\"5330\",\"5335\",\"5340\",\"5345\",\"5350\",\"5355\",\"5360\",\"5365\",\"5370\",\"5375\",\"5380\",\"5385\",\"5390\",\"5395\",\"5400\",\"5405\",\"5410\",\"5415\",\"5420\",\"5425\",\"5430\",\"5435\",\"5440\",\"5445\",\"5450\",\"5455\",\"5460\",\"5465\",\"5470\",\"5475\",\"5480\",\"5485\",\"5490\",\"5495\",\"5500\",\"5505\",\"5510\",\"5515\",\"5520\",\"5525\",\"5530\",\"5535\",\"5540\",\"5545\",\"5550\",\"5555\",\"5560\",\"5565\",\"5570\",\"5575\",\"5580\",\"5585\",\"5590\",\"5595\",\"5600\",\"5605\",\"5610\",\"5615\",\"5620\",\"5625\",\"5630\",\"5635\",\"5640\",\"5645\",\"5650\",\"5655\",\"5660\",\"5665\",\"5670\",\"5675\",\"5680\",\"5685\",\"5690\",\"5695\",\"5700\",\"5705\",\"5710\",\"5715\",\"5720\",\"5725\",\"5730\",\"5735\",\"5740\",\"5745\",\"5750\",\"5755\",\"5760\",\"5765\",\"5770\",\"5775\",\"5780\",\"5785\",\"5790\",\"5795\",\"5800\",\"5805\",\"5810\",\"5815\",\"5820\",\"5825\",\"5830\",\"5835\",\"5840\",\"5845\",\"5850\",\"5855\",\"5860\",\"5865\",\"5870\",\"5875\",\"5880\",\"5885\",\"5890\",\"5895\",\"5900\",\"5905\",\"5910\",\"5915\",\"5920\",\"5925\",\"5930\",\"5935\",\"5940\",\"5945\",\"5950\",\"5955\",\"5960\",\"5965\",\"5970\",\"5975\",\"5980\",\"5985\",\"5990\",\"5995\",\"6000\",\"6005\",\"6010\",\"6015\",\"6020\",\"6025\",\"6030\",\"6035\",\"6040\",\"6045\",\"6050\",\"6055\",\"6060\",\"6065\",\"6070\",\"6075\",\"6080\",\"6085\",\"6090\",\"6095\",\"6100\",\"6105\",\"6110\",\"6115\",\"6120\",\"6125\",\"6130\",\"6135\",\"6140\",\"6145\",\"6150\",\"6155\",\"6160\",\"6165\",\"6170\",\"6175\",\"6180\",\"6185\",\"6190\",\"6195\",\"6200\",\"6205\",\"6210\",\"6215\",\"6220\",\"6225\",\"6230\",\"6235\",\"6240\",\"6245\",\"6250\",\"6255\",\"6260\",\"6265\",\"6270\",\"6275\",\"6280\",\"6285\",\"6290\",\"6295\",\"6300\",\"6305\",\"6310\",\"6315\",\"6320\",\"6325\",\"6330\",\"6335\",\"6340\",\"6345\",\"6350\",\"6355\",\"6360\",\"6365\",\"6370\",\"6375\",\"6380\",\"6385\",\"6390\",\"6395\",\"6400\",\"6405\",\"6410\",\"6415\",\"6420\",\"6425\",\"6430\",\"6435\",\"6440\",\"6445\",\"6450\",\"6455\",\"6460\",\"6465\",\"6470\",\"6475\",\"6480\",\"6485\",\"6490\",\"6495\",\"6500\",\"6505\",\"6510\",\"6515\",\"6520\",\"6525\",\"6530\",\"6535\",\"6540\",\"6545\",\"6550\",\"6555\",\"6560\",\"6565\",\"6570\",\"6575\",\"6580\",\"6585\"]'), ('56', '7', '5', '182', '0', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"390\",\"0\"]'), ('57', '7', '5', '184', '260', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\"]'), ('58', '7', '5', '186', '155', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\"]'), ('59', '7', '5', '187', '580', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\"]'), ('60', '7', '5', '188', '300', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\"]'), ('61', '7', '5', '189', '440', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\"]'), ('62', '7', '5', '183', '3600', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"990\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1135\",\"1140\",\"1145\",\"1150\",\"1155\",\"1160\",\"1165\",\"1170\",\"1175\",\"1180\",\"1185\",\"1190\",\"1195\",\"1200\",\"1205\",\"1210\",\"1215\",\"1220\",\"1225\",\"1230\",\"1235\",\"1240\",\"1245\",\"1250\",\"1255\",\"1260\",\"1265\",\"1270\",\"1275\",\"1280\",\"1285\",\"1290\",\"1295\",\"1300\",\"1305\",\"1310\",\"1315\",\"1320\",\"1325\",\"1330\",\"1335\",\"1340\",\"1345\",\"1350\",\"1355\",\"1360\",\"1365\",\"1370\",\"1375\",\"1380\",\"1385\",\"1390\",\"1395\",\"1400\",\"1405\",\"1410\",\"1415\",\"1420\",\"1425\",\"1430\",\"1435\",\"1440\",\"1445\",\"1450\",\"1455\",\"1460\",\"1465\",\"1470\",\"1475\",\"1480\",\"1485\",\"1490\",\"1495\",\"1500\",\"1505\",\"1510\",\"1515\",\"1520\",\"1525\",\"1530\",\"1535\",\"1540\",\"1545\",\"1550\",\"1555\",\"1560\",\"1565\",\"1570\",\"1575\",\"1580\",\"1585\",\"1590\",\"1595\",\"1600\",\"1605\",\"1610\",\"1615\",\"1620\",\"1625\",\"1630\",\"1635\",\"1640\",\"1645\",\"1650\",\"1655\",\"1660\",\"1665\",\"1670\",\"1675\",\"1680\",\"1685\",\"1690\",\"1695\",\"1700\",\"1705\",\"1710\",\"1715\",\"1720\",\"1725\",\"1730\",\"1735\",\"1740\",\"1745\",\"1750\",\"1755\",\"1760\",\"1765\",\"1770\",\"1775\",\"1780\",\"1785\",\"1790\",\"1795\",\"1800\",\"1805\",\"1810\",\"1815\",\"1820\",\"1825\",\"1830\",\"1835\",\"1840\",\"1845\",\"1850\",\"1855\",\"1860\",\"1865\",\"1870\",\"1875\",\"1880\",\"1885\",\"1890\",\"1895\",\"1900\",\"1905\",\"1910\",\"1915\",\"1920\",\"1925\",\"1930\",\"1935\",\"1940\",\"1945\",\"1950\",\"1955\",\"1960\",\"1965\",\"1970\",\"1975\",\"1980\",\"1985\",\"1990\",\"1995\",\"2000\",\"2005\",\"2010\",\"2015\",\"2020\",\"2025\",\"2030\",\"2035\",\"2040\",\"2045\",\"2050\",\"2055\",\"2060\",\"2065\",\"2070\",\"2075\",\"2080\",\"2085\",\"2090\",\"2095\",\"2100\",\"2105\",\"2110\",\"2115\",\"2120\",\"2125\",\"2130\",\"2135\",\"2140\",\"2145\",\"2150\",\"2155\",\"2160\",\"2165\",\"2170\",\"2175\",\"2180\",\"2185\",\"2190\",\"2195\",\"2200\",\"2205\",\"2210\",\"2215\",\"2220\",\"2225\",\"2230\",\"2235\",\"2240\",\"2245\",\"2250\",\"2255\",\"2260\",\"2265\",\"2270\",\"2275\",\"2280\",\"2285\",\"2290\",\"2295\",\"2300\",\"2305\",\"2310\",\"2315\",\"2320\",\"2325\",\"2330\",\"2335\",\"2340\",\"2345\",\"2350\",\"2355\",\"2360\",\"2365\",\"2370\",\"2375\",\"2380\",\"2385\",\"2390\",\"2395\",\"2400\",\"2405\",\"2410\",\"2415\",\"2420\",\"2425\",\"2430\",\"2435\",\"2440\",\"2445\",\"2450\",\"2455\",\"2460\",\"2465\",\"2470\",\"2475\",\"2480\",\"2485\",\"2490\",\"2495\",\"2500\",\"2505\",\"2510\",\"2515\",\"2520\",\"2525\",\"2530\",\"2535\",\"2540\",\"2545\",\"2550\",\"2555\",\"2560\",\"2565\",\"2570\",\"2575\",\"2580\",\"2585\",\"2590\",\"2595\",\"2600\",\"2605\",\"2610\",\"2615\",\"2620\",\"2625\",\"2630\",\"2635\",\"2640\",\"2645\",\"2650\",\"2655\",\"2660\",\"2665\",\"2670\",\"2675\",\"2680\",\"2685\",\"2690\",\"2695\",\"2700\",\"2705\",\"2710\",\"2715\",\"2720\",\"2725\",\"2730\",\"2735\",\"2740\",\"2745\",\"2750\",\"2755\",\"2760\",\"2765\",\"2770\",\"2775\",\"2780\",\"2785\",\"2790\",\"2795\",\"2800\",\"2805\",\"2810\",\"2815\",\"2820\",\"2825\",\"2830\",\"2835\",\"2840\",\"2845\",\"2850\",\"2855\",\"2860\",\"2865\",\"2870\",\"2875\",\"2880\",\"2885\",\"2890\",\"2895\",\"2900\",\"2905\",\"2910\",\"2915\",\"2920\",\"2925\",\"2930\",\"2935\",\"2940\",\"2945\",\"2950\",\"2955\",\"2960\",\"2965\",\"2970\",\"2975\",\"2980\",\"2985\",\"2990\",\"2995\",\"3000\",\"3005\",\"3010\",\"3015\",\"3020\",\"3025\",\"3030\",\"3035\",\"3040\",\"3045\",\"3050\",\"3055\",\"3060\",\"3065\",\"3070\",\"3075\",\"3080\",\"3085\",\"3090\",\"3095\",\"3100\",\"3105\",\"3110\",\"3115\",\"3120\",\"3125\",\"3130\",\"3135\",\"3140\",\"3145\",\"3150\",\"3155\",\"3160\",\"3165\",\"3170\",\"3175\",\"3180\",\"3185\",\"3190\",\"3195\",\"3200\",\"3205\",\"3210\",\"3215\",\"3220\",\"3225\",\"3230\",\"3235\",\"3240\",\"3245\",\"3250\",\"3255\",\"3260\",\"3265\",\"3270\",\"3275\",\"3280\",\"3285\",\"3290\",\"3295\",\"3300\",\"3305\",\"3310\",\"3315\",\"3320\",\"3325\",\"3330\",\"3335\",\"3345\",\"3350\",\"3355\",\"3360\",\"3365\",\"3370\",\"3375\",\"3380\",\"3385\",\"3390\",\"3395\",\"3400\",\"3405\",\"3410\",\"3415\",\"3420\",\"3425\",\"3430\",\"3435\",\"3440\",\"3445\",\"3450\",\"3455\",\"3460\",\"3465\",\"3470\",\"3475\",\"3480\",\"3485\",\"3490\",\"3495\",\"3500\",\"3505\",\"3510\",\"3515\",\"3520\",\"3525\",\"3530\",\"3535\",\"3540\",\"3545\",\"3550\",\"3555\",\"3560\",\"3565\",\"3570\",\"3575\",\"3580\",\"3585\",\"3590\",\"3595\",\"3600\"]'), ('63', '7', '5', '169', '4880', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"0\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"990\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1135\",\"1140\",\"1145\",\"1150\",\"1155\",\"1160\",\"1165\",\"1170\",\"1175\",\"1180\",\"1185\",\"1190\",\"1195\",\"1200\",\"1205\",\"1210\",\"1215\",\"1220\",\"1225\",\"1230\",\"1235\",\"1240\",\"1245\",\"1250\",\"1255\",\"1260\",\"1265\",\"1270\",\"1275\",\"1280\",\"1285\",\"1290\",\"1295\",\"1300\",\"1305\",\"1310\",\"1315\",\"1320\",\"1325\",\"1330\",\"1335\",\"1340\",\"1345\",\"1350\",\"1355\",\"1360\",\"1365\",\"1370\",\"1375\",\"1380\",\"1385\",\"1390\",\"1395\",\"1400\",\"1405\",\"1410\",\"1415\",\"1420\",\"1425\",\"1430\",\"1435\",\"1440\",\"1445\",\"1450\",\"1455\",\"1460\",\"1465\",\"1470\",\"1475\",\"1480\",\"1485\",\"1490\",\"1495\",\"1500\",\"1505\",\"1510\",\"1515\",\"1520\",\"1525\",\"1530\",\"1535\",\"1540\",\"1545\",\"1550\",\"1555\",\"1560\",\"1565\",\"1570\",\"1575\",\"1580\",\"1585\",\"1590\",\"1595\",\"1600\",\"1605\",\"1610\",\"1615\",\"1620\",\"1625\",\"1630\",\"1635\",\"1640\",\"1645\",\"1650\",\"1655\",\"1660\",\"1665\",\"1670\",\"1675\",\"1680\",\"1685\",\"1690\",\"1695\",\"1700\",\"1705\",\"1710\",\"1715\",\"1720\",\"1725\",\"1730\",\"1735\",\"1740\",\"1745\",\"1750\",\"1755\",\"1760\",\"1765\",\"1770\",\"1775\",\"1780\",\"1785\",\"1790\",\"1795\",\"1800\",\"1805\",\"1810\",\"1815\",\"1820\",\"1825\",\"1830\",\"1835\",\"1840\",\"1845\",\"1850\",\"1855\",\"1860\",\"1865\",\"1870\",\"1875\",\"1880\",\"1885\",\"1890\",\"1895\",\"1900\",\"1905\",\"1910\",\"1915\",\"1920\",\"1925\",\"1930\",\"1935\",\"1940\",\"1945\",\"1950\",\"1955\",\"1960\",\"1965\",\"1970\",\"1975\",\"1980\",\"1985\",\"1990\",\"1995\",\"2000\",\"2005\",\"2010\",\"2015\",\"2020\",\"2025\",\"2030\",\"2035\",\"2040\",\"2045\",\"2050\",\"2055\",\"2060\",\"2065\",\"2070\",\"2075\",\"2080\",\"2085\",\"2090\",\"2095\",\"2100\",\"2105\",\"2110\",\"2115\",\"2120\",\"2125\",\"2130\",\"2135\",\"2140\",\"2145\",\"2150\",\"2155\",\"2160\",\"2165\",\"2170\",\"2175\",\"2180\",\"2185\",\"2190\",\"2195\",\"2200\",\"2205\",\"2210\",\"2215\",\"2220\",\"2225\",\"2230\",\"2235\",\"2240\",\"2245\",\"2250\",\"2255\",\"2260\",\"2265\",\"2270\",\"2275\",\"2280\",\"2285\",\"2290\",\"2295\",\"2300\",\"2305\",\"2310\",\"2315\",\"2320\",\"2325\",\"2330\",\"2335\",\"2340\",\"2345\",\"2350\",\"2355\",\"2360\",\"2365\",\"2370\",\"2375\",\"2380\",\"2385\",\"2390\",\"2395\",\"2400\",\"2405\",\"2410\",\"2415\",\"2420\",\"2425\",\"2430\",\"2435\",\"2440\",\"2445\",\"2450\",\"2455\",\"2460\",\"2465\",\"2470\",\"2475\",\"2480\",\"2485\",\"2490\",\"2495\",\"2500\",\"2505\",\"2510\",\"2515\",\"2520\",\"2525\",\"2530\",\"2535\",\"2540\",\"2545\",\"2550\",\"2555\",\"2560\",\"2565\",\"2570\",\"2575\",\"2580\",\"2585\",\"2590\",\"2595\",\"2600\",\"2605\",\"2610\",\"2615\",\"2620\",\"2625\",\"2630\",\"2635\",\"2640\",\"2645\",\"2650\",\"2655\",\"2660\",\"2665\",\"2670\",\"2675\",\"2680\",\"2685\",\"2690\",\"2695\",\"2700\",\"2705\",\"2710\",\"2715\",\"2720\",\"2725\",\"2730\",\"2735\",\"2740\",\"2745\",\"2750\",\"2755\",\"2760\",\"2765\",\"2770\",\"2775\",\"2780\",\"2785\",\"2790\",\"2795\",\"2800\",\"2810\",\"2815\",\"2820\",\"2825\",\"2830\",\"2835\",\"2840\",\"2845\",\"2850\",\"2855\",\"2860\",\"2865\",\"2870\",\"2875\",\"2880\",\"2885\",\"2890\",\"2895\",\"2900\",\"2905\",\"2910\",\"2915\",\"2920\",\"2925\",\"2930\",\"2935\",\"2940\",\"2945\",\"2950\",\"2955\",\"2960\",\"2965\",\"2970\",\"2975\",\"2980\",\"2985\",\"2990\",\"2995\",\"3000\",\"3005\",\"3010\",\"3015\",\"3020\",\"3025\",\"3030\",\"3035\",\"3040\",\"3045\",\"3050\",\"3055\",\"3060\",\"3065\",\"3070\",\"3075\",\"3080\",\"3085\",\"3090\",\"3095\",\"3100\",\"3105\",\"3110\",\"3115\",\"3120\",\"3125\",\"3130\",\"3135\",\"3140\",\"3145\",\"3150\",\"3155\",\"3160\",\"3165\",\"3170\",\"3175\",\"3180\",\"3185\",\"3190\",\"3195\",\"3200\",\"3205\",\"3210\",\"3215\",\"3220\",\"3225\",\"3230\",\"3235\",\"3240\",\"3245\",\"3250\",\"3255\",\"3260\",\"3265\",\"3270\",\"3275\",\"3280\",\"3285\",\"3290\",\"3295\",\"3300\",\"3305\",\"3310\",\"3315\",\"3320\",\"3325\",\"3330\",\"3335\",\"3340\",\"3345\",\"3350\",\"3355\",\"3360\",\"3365\",\"3370\",\"3375\",\"3380\",\"3385\",\"3390\",\"3395\",\"3400\",\"3405\",\"3410\",\"3415\",\"3420\",\"3425\",\"3430\",\"3435\",\"3440\",\"3445\",\"3450\",\"3455\",\"3460\",\"3465\",\"3470\",\"3475\",\"3480\",\"3485\",\"3490\",\"3495\",\"3500\",\"3505\",\"3510\",\"3515\",\"3520\",\"3525\",\"3530\",\"3535\",\"3540\",\"3545\",\"3550\",\"3555\",\"3560\",\"3565\",\"3570\",\"3575\",\"3580\",\"3585\",\"3590\",\"3595\",\"3600\",\"3605\",\"3610\",\"3615\",\"3620\",\"3625\",\"3630\",\"3635\",\"3640\",\"3645\",\"3650\",\"3655\",\"3660\",\"3665\",\"3670\",\"3675\",\"3680\",\"3685\",\"3690\",\"3695\",\"3700\",\"3705\",\"3710\",\"3715\",\"3720\",\"3725\",\"3730\",\"3735\",\"3740\",\"3745\",\"3750\",\"3755\",\"3760\",\"3765\",\"3770\",\"3775\",\"3780\",\"3785\",\"3790\",\"3795\",\"3800\",\"3805\",\"3810\",\"3815\",\"3820\",\"3825\",\"3830\",\"3835\",\"3840\",\"3845\",\"3850\",\"3855\",\"3860\",\"3865\",\"3870\",\"3875\",\"3880\",\"3885\",\"3890\",\"3895\",\"3900\",\"3905\",\"3910\",\"3915\",\"3920\",\"3925\",\"3930\",\"3935\",\"3940\",\"3945\",\"3950\",\"3955\",\"3960\",\"3965\",\"3970\",\"3975\",\"3980\",\"3985\",\"3990\",\"3995\",\"4000\",\"4005\",\"4010\",\"4015\",\"4020\",\"4025\",\"4030\",\"4035\",\"4040\",\"4045\",\"4050\",\"4055\",\"4060\",\"4065\",\"4070\",\"4075\",\"4080\",\"4085\",\"4090\",\"4095\",\"4100\",\"4105\",\"4110\",\"4115\",\"4120\",\"4125\",\"4130\",\"4135\",\"4140\",\"4145\",\"4150\",\"4155\",\"4160\",\"4165\",\"4170\",\"4175\",\"4180\",\"4185\",\"4190\",\"4195\",\"4200\",\"4205\",\"4210\",\"4215\",\"4220\",\"4225\",\"4230\",\"4235\",\"4240\",\"4245\",\"4250\",\"4255\",\"4260\",\"4265\",\"4270\",\"4275\",\"4280\",\"4285\",\"4290\",\"4295\",\"4300\",\"4305\",\"4310\",\"4315\",\"4320\",\"4325\",\"4330\",\"4335\",\"4340\",\"4345\",\"4350\",\"4355\",\"4360\",\"4365\",\"4370\",\"4375\",\"4380\",\"4385\",\"4390\",\"4395\",\"4400\",\"4405\",\"4410\",\"4415\",\"4420\",\"4425\",\"4430\",\"4435\",\"4440\",\"4445\",\"4450\",\"4455\",\"4460\",\"4465\",\"4470\",\"4475\",\"4480\",\"4485\",\"4490\",\"4495\",\"4500\",\"4505\",\"4510\",\"4515\",\"4520\",\"4525\",\"4530\",\"4535\",\"4540\",\"4545\",\"4550\",\"4555\",\"4560\",\"4565\",\"4570\",\"4575\",\"4580\",\"4585\",\"4590\",\"4595\",\"4600\",\"4605\",\"4610\",\"4615\",\"4620\",\"4625\",\"4630\",\"4635\",\"4640\",\"4645\",\"4650\",\"4655\",\"4660\",\"4665\",\"4670\",\"4675\",\"4680\",\"4685\",\"4690\",\"4695\",\"4700\",\"4705\",\"4710\",\"4715\",\"4720\",\"4725\",\"4730\",\"4735\",\"4740\",\"4745\",\"4750\",\"4755\",\"4760\",\"4765\",\"4770\",\"4775\",\"4780\",\"4785\",\"4790\",\"4795\",\"4800\",\"4805\",\"4810\",\"4815\",\"4820\",\"4825\",\"4830\",\"4835\",\"4840\",\"4845\",\"4850\",\"4855\",\"4860\",\"4865\",\"4870\",\"4875\",\"4880\"]'), ('64', '7', '5', '145', '2105', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"990\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1135\",\"1140\",\"1145\",\"1150\",\"1155\",\"1160\",\"1165\",\"1170\",\"1175\",\"1180\",\"1185\",\"1190\",\"1195\",\"1200\",\"1205\",\"1210\",\"1215\",\"1220\",\"1225\",\"1230\",\"1235\",\"1240\",\"1245\",\"1250\",\"1255\",\"1260\",\"1265\",\"1270\",\"1275\",\"1280\",\"1285\",\"1290\",\"1295\",\"1300\",\"1305\",\"1310\",\"1315\",\"1320\",\"1325\",\"1330\",\"1335\",\"1340\",\"1345\",\"1350\",\"1355\",\"1360\",\"1365\",\"1370\",\"1375\",\"1380\",\"1385\",\"1390\",\"1395\",\"1400\",\"1405\",\"1410\",\"1415\",\"1420\",\"1425\",\"1430\",\"1435\",\"1440\",\"1445\",\"1450\",\"1455\",\"1460\",\"1465\",\"1470\",\"1475\",\"1480\",\"1485\",\"1490\",\"1495\",\"1500\",\"1505\",\"1510\",\"1515\",\"1520\",\"1525\",\"1530\",\"1535\",\"1540\",\"1545\",\"1550\",\"1555\",\"1560\",\"1565\",\"1570\",\"1575\",\"1580\",\"1585\",\"1590\",\"1595\",\"1600\",\"1605\",\"1610\",\"1615\",\"1620\",\"1625\",\"1630\",\"1635\",\"1640\",\"1645\",\"1650\",\"1655\",\"1660\",\"1665\",\"1670\",\"1675\",\"1680\",\"1685\",\"1690\",\"1695\",\"1700\",\"1705\",\"1710\",\"1715\",\"1720\",\"1725\",\"1730\",\"1735\",\"1740\",\"1745\",\"1750\",\"1755\",\"1760\",\"1765\",\"1770\",\"1775\",\"1780\",\"1785\",\"1790\",\"1795\",\"1800\",\"1805\",\"1810\",\"1815\",\"1820\",\"1825\",\"1830\",\"1835\",\"1840\",\"1845\",\"1850\",\"1855\",\"1860\",\"1865\",\"1870\",\"1875\",\"1880\",\"1885\",\"1890\",\"1895\",\"1900\",\"1905\",\"1910\",\"1915\",\"1920\",\"1925\",\"1930\",\"1935\",\"1940\",\"1945\",\"1950\",\"1955\",\"1960\",\"1965\",\"1970\",\"1975\",\"1980\",\"1985\",\"1990\",\"1995\",\"2000\",\"2005\",\"2010\",\"2015\",\"2020\",\"2025\",\"2030\",\"2035\",\"2040\",\"2045\",\"2050\",\"2055\",\"2060\",\"2065\",\"2070\",\"2075\",\"2080\",\"2085\",\"2090\",\"2095\",\"2100\",\"2105\"]'), ('65', '7', '5', '156', '1430', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"990\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1135\",\"1140\",\"1145\",\"1150\",\"1155\",\"1160\",\"1165\",\"1170\",\"1175\",\"1180\",\"1185\",\"1190\",\"1195\",\"1200\",\"1205\",\"1210\",\"1215\",\"1220\",\"1225\",\"1230\",\"1235\",\"1240\",\"1245\",\"1250\",\"1255\",\"1260\",\"1265\",\"1270\",\"1275\",\"1280\",\"1285\",\"1290\",\"1295\",\"1300\",\"1305\",\"1310\",\"1315\",\"1320\",\"1325\",\"1330\",\"1335\",\"1340\",\"1345\",\"1350\",\"1355\",\"1360\",\"1365\",\"1370\",\"1375\",\"1380\",\"1385\",\"1390\",\"1395\",\"1400\",\"1405\",\"1410\",\"1415\",\"1420\",\"1425\",\"1430\"]'), ('66', '7', '5', '162', '475', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\"]'), ('67', '14', '6', '174', '300', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\"]'), ('68', '14', '6', '178', '5', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"0\"]'), ('69', '14', '6', '170', '330', '[\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\"]'), ('70', '14', '6', '171', '165', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\"]'), ('71', '14', '6', '172', '80', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\"]'), ('72', '14', '6', '175', '120', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\"]'), ('73', '14', '6', '176', '20', '[\"5\",\"10\",\"15\",\"20\"]'), ('74', '10', '5', '169', '6555', '[\"15\",\"20\",\"35\",\"40\",\"45\",\"60\",\"65\",\"80\",\"85\",\"90\",\"105\",\"110\",\"125\",\"130\",\"135\",\"150\",\"155\",\"170\",\"175\",\"180\",\"190\",\"195\",\"200\",\"215\",\"220\",\"235\",\"240\",\"245\",\"260\",\"265\",\"280\",\"285\",\"290\",\"305\",\"310\",\"315\",\"325\",\"330\",\"335\",\"350\",\"355\",\"360\",\"375\",\"380\",\"395\",\"400\",\"405\",\"415\",\"420\",\"425\",\"440\",\"445\",\"460\",\"465\",\"470\",\"485\",\"490\",\"495\",\"510\",\"515\",\"530\",\"535\",\"550\",\"555\",\"560\",\"575\",\"580\",\"595\",\"600\",\"605\",\"620\",\"625\",\"640\",\"645\",\"650\",\"665\",\"670\",\"675\",\"685\",\"690\",\"695\",\"710\",\"715\",\"720\",\"730\",\"735\",\"740\",\"755\",\"760\",\"775\",\"780\",\"785\",\"800\",\"805\",\"825\",\"830\",\"845\",\"850\",\"865\",\"870\",\"875\",\"890\",\"895\",\"910\",\"915\",\"920\",\"935\",\"940\",\"945\",\"955\",\"960\",\"965\",\"980\",\"985\",\"990\",\"1005\",\"1010\",\"1025\",\"1030\",\"1050\",\"1055\",\"1070\",\"1075\",\"1095\",\"1100\",\"1115\",\"1120\",\"1125\",\"1135\",\"1140\",\"1145\",\"1160\",\"1165\",\"1185\",\"1190\",\"1205\",\"1210\",\"1225\",\"1230\",\"1235\",\"1250\",\"1255\",\"1275\",\"1280\",\"1295\",\"1300\",\"1305\",\"1320\",\"1325\",\"1340\",\"1345\",\"1350\",\"1365\",\"1370\",\"1385\",\"1390\",\"1405\",\"1410\",\"1415\",\"1430\",\"1435\",\"1450\",\"1455\",\"1460\",\"1475\",\"1480\",\"1495\",\"1500\",\"1505\",\"1515\",\"1520\",\"1525\",\"1540\",\"1545\",\"1560\",\"1565\",\"1570\",\"1585\",\"1590\",\"1605\",\"1610\",\"1615\",\"1630\",\"1635\",\"1650\",\"1655\",\"1660\",\"1675\",\"1680\",\"1695\",\"1700\",\"1705\",\"1720\",\"1725\",\"1740\",\"1745\",\"1750\",\"1765\",\"1770\",\"1785\",\"1790\",\"1795\",\"1810\",\"1815\",\"1830\",\"1835\",\"1840\",\"1855\",\"1860\",\"1875\",\"1880\",\"1885\",\"1900\",\"1905\",\"1920\",\"1925\",\"1930\",\"1945\",\"1950\",\"1965\",\"1970\",\"1975\",\"1990\",\"1995\",\"2010\",\"2015\",\"2020\",\"2035\",\"2040\",\"2055\",\"2060\",\"2065\",\"2080\",\"2085\",\"2100\",\"2105\",\"2110\",\"2125\",\"2130\",\"2145\",\"2150\",\"2155\",\"2170\",\"2175\",\"2190\",\"2195\",\"2200\",\"2215\",\"2220\",\"2235\",\"2240\",\"2245\",\"2260\",\"2265\",\"2280\",\"2285\",\"2290\",\"2305\",\"2310\",\"2325\",\"2330\",\"2335\",\"2350\",\"2355\",\"2370\",\"2375\",\"2380\",\"2395\",\"2400\",\"2415\",\"2420\",\"2425\",\"2440\",\"2455\",\"2460\",\"2465\",\"2470\",\"2475\",\"2480\",\"2495\",\"2500\",\"2515\",\"2520\",\"2525\",\"2540\",\"2545\",\"2560\",\"2565\",\"2570\",\"2585\",\"2590\",\"2605\",\"2620\",\"2625\",\"2630\",\"2645\",\"2650\",\"2665\",\"2670\",\"2675\",\"2690\",\"2695\",\"2710\",\"2715\",\"2720\",\"2735\",\"2740\",\"2755\",\"2760\",\"2765\",\"2780\",\"2785\",\"2800\",\"2805\",\"2810\",\"2825\",\"2830\",\"2845\",\"2850\",\"2855\",\"2870\",\"2875\",\"2890\",\"2895\",\"2900\",\"2915\",\"2920\",\"2935\",\"2940\",\"2945\",\"2960\",\"2965\",\"2980\",\"2985\",\"2990\",\"3005\",\"3010\",\"3035\",\"3040\",\"3055\",\"3060\",\"3065\",\"3080\",\"3085\",\"3100\",\"3105\",\"3110\",\"3125\",\"3130\",\"3135\",\"3150\",\"3155\",\"3170\",\"3175\",\"3180\",\"3195\",\"3200\",\"3215\",\"3220\",\"3225\",\"3240\",\"3245\",\"3260\",\"3265\",\"3270\",\"3285\",\"3290\",\"3300\",\"3305\",\"3310\",\"3325\",\"3330\",\"3345\",\"3350\",\"3355\",\"3370\",\"3375\",\"3390\",\"3395\",\"3400\",\"3415\",\"3420\",\"3435\",\"3440\",\"3445\",\"3460\",\"3465\",\"3480\",\"3485\",\"3490\",\"3505\",\"3510\",\"3525\",\"3530\",\"3535\",\"3550\",\"3555\",\"3570\",\"3575\",\"3580\",\"3595\",\"3600\",\"3615\",\"3620\",\"3625\",\"3640\",\"3645\",\"3660\",\"3665\",\"3670\",\"3685\",\"3690\",\"3705\",\"3710\",\"3715\",\"3730\",\"3735\",\"3750\",\"3755\",\"3760\",\"3775\",\"3780\",\"3795\",\"3800\",\"3805\",\"3825\",\"3830\",\"3845\",\"3850\",\"3855\",\"3870\",\"3875\",\"3890\",\"3895\",\"3900\",\"3915\",\"3920\",\"3935\",\"3940\",\"3945\",\"3960\",\"3965\",\"3980\",\"3985\",\"3990\",\"4005\",\"4010\",\"4025\",\"4030\",\"4035\",\"4050\",\"4055\",\"4070\",\"4075\",\"4080\",\"4095\",\"4100\",\"4115\",\"4120\",\"4125\",\"4135\",\"4140\",\"4155\",\"4160\",\"4165\",\"4180\",\"4185\",\"4200\",\"4205\",\"4210\",\"4225\",\"4230\",\"4245\",\"4250\",\"4255\",\"4270\",\"4275\",\"4290\",\"4295\",\"4300\",\"4315\",\"4320\",\"4335\",\"4340\",\"4345\",\"4360\",\"4365\",\"4380\",\"4385\",\"4390\",\"4405\",\"4410\",\"4425\",\"4430\",\"4435\",\"4450\",\"4455\",\"4470\",\"4475\",\"4480\",\"4495\",\"4500\",\"4515\",\"4520\",\"4525\",\"4540\",\"4545\",\"4560\",\"4565\",\"4570\",\"4585\",\"4590\",\"4605\",\"4610\",\"4615\",\"4630\",\"4635\",\"4650\",\"4655\",\"4660\",\"4675\",\"4680\",\"4695\",\"4700\",\"4705\",\"4720\",\"4725\",\"4740\",\"4745\",\"4750\",\"4765\",\"4770\",\"4785\",\"4790\",\"4795\",\"4810\",\"4815\",\"4830\",\"4835\",\"4840\",\"4855\",\"4860\",\"4875\",\"4880\",\"4885\",\"4900\",\"4905\",\"4920\",\"4925\",\"4930\",\"4945\",\"4950\",\"4965\",\"4970\",\"4975\",\"4990\",\"4995\",\"5010\",\"5015\",\"5020\",\"5035\",\"5040\",\"5055\",\"5060\",\"5065\",\"5080\",\"5085\",\"5100\",\"5105\",\"5110\",\"5125\",\"5130\",\"5145\",\"5150\",\"5155\",\"5170\",\"5175\",\"5190\",\"5195\",\"5200\",\"5215\",\"5220\",\"5235\",\"5240\",\"5245\",\"5260\",\"5265\",\"5280\",\"5285\",\"5290\",\"5305\",\"5310\",\"5325\",\"5330\",\"5335\",\"5350\",\"5355\",\"5370\",\"5375\",\"5380\",\"5395\",\"5400\",\"5415\",\"5420\",\"5425\",\"5440\",\"5445\",\"5460\",\"5465\",\"5470\",\"5485\",\"5490\",\"5505\",\"5510\",\"5515\",\"5530\",\"5535\",\"5550\",\"5555\",\"5560\",\"5575\",\"5580\",\"5590\",\"5605\",\"5610\",\"5625\",\"5630\",\"5635\",\"5650\",\"5655\",\"5670\",\"5675\",\"5680\",\"5695\",\"5700\",\"5715\",\"5720\",\"5725\",\"5740\",\"5745\",\"5760\",\"5765\",\"5770\",\"5785\",\"5790\",\"5805\",\"5810\",\"5815\",\"5830\",\"5835\",\"5850\",\"5855\",\"5860\",\"5875\",\"5880\",\"5895\",\"5900\",\"5905\",\"5920\",\"5925\",\"5940\",\"5945\",\"5950\",\"5965\",\"5970\",\"5985\",\"5990\",\"5995\",\"6010\",\"6015\",\"6030\",\"6035\",\"6040\",\"6055\",\"6060\",\"6075\",\"6080\",\"6085\",\"6100\",\"6105\",\"6120\",\"6125\",\"6130\",\"6145\",\"6150\",\"6165\",\"6170\",\"6175\",\"6190\",\"6195\",\"6210\",\"6215\",\"6220\",\"6235\",\"6240\",\"6255\",\"6260\",\"6265\",\"6280\",\"6285\",\"6300\",\"6305\",\"6310\",\"6325\",\"6330\",\"6345\",\"6350\",\"6355\",\"6370\",\"6375\",\"6390\",\"6395\",\"6400\",\"6415\",\"6420\",\"6440\",\"6445\",\"6460\",\"6465\",\"6470\",\"6485\",\"6490\",\"6510\",\"6525\",\"6530\",\"6545\",\"6550\",\"6555\"]'), ('75', '7', '6', '170', '330', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\"]'), ('76', '7', '6', '178', '30', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\"]'), ('77', '7', '5', '154', '960', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\"]'), ('78', '11', '5', '169', '5105', '[\"1610\",\"2370\",\"2445\",\"2855\",\"3100\",\"2915\",\"3520\",\"3655\",\"5105\"]'), ('79', '11', '5', '196', '1600', '[\"770\",\"1410\",\"1590\",\"1595\",\"1600\"]'), ('80', '11', '5', '163', '1335', '[\"55\",\"65\",\"70\",\"120\",\"125\",\"130\",\"140\",\"145\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"190\",\"195\",\"205\",\"0\",\"5\",\"10\",\"20\",\"25\",\"35\",\"40\",\"45\",\"60\",\"75\",\"85\",\"90\",\"95\",\"105\",\"110\",\"135\",\"185\",\"210\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"255\",\"260\",\"270\",\"275\",\"280\",\"290\",\"295\",\"305\",\"310\",\"320\",\"325\",\"330\",\"340\",\"345\",\"355\",\"360\",\"370\",\"375\",\"380\",\"390\",\"395\",\"405\",\"410\",\"420\",\"425\",\"430\",\"440\",\"445\",\"455\",\"460\",\"470\",\"475\",\"480\",\"490\",\"495\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"550\",\"585\",\"600\",\"605\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"650\",\"655\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"700\",\"705\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"750\",\"755\",\"765\",\"770\",\"775\",\"785\",\"790\",\"800\",\"805\",\"815\",\"820\",\"825\",\"835\",\"840\",\"850\",\"855\",\"865\",\"870\",\"875\",\"885\",\"890\",\"900\",\"905\",\"915\",\"920\",\"925\",\"935\",\"940\",\"950\",\"955\",\"965\",\"970\",\"975\",\"985\",\"990\",\"1000\",\"1005\",\"1015\",\"1020\",\"1025\",\"1035\",\"1040\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1085\",\"1090\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1135\",\"1140\",\"1150\",\"1155\",\"1160\",\"1165\",\"1170\",\"1175\",\"1185\",\"1190\",\"1200\",\"1205\",\"1215\",\"1220\",\"1225\",\"1235\",\"1240\",\"1250\",\"1255\",\"1260\",\"1265\",\"1270\",\"1275\",\"1285\",\"1290\",\"1300\",\"1305\",\"1310\",\"1315\",\"1320\",\"1325\",\"1335\"]'), ('81', '11', '5', '180', '825', '[\"5\",\"65\",\"40\",\"50\",\"55\",\"60\",\"70\",\"75\",\"85\",\"90\",\"100\",\"105\",\"110\",\"120\",\"125\",\"135\",\"140\",\"150\",\"155\",\"160\",\"165\",\"175\",\"180\",\"190\",\"195\",\"205\",\"210\",\"215\",\"225\",\"230\",\"240\",\"245\",\"255\",\"260\",\"265\",\"275\",\"280\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"325\",\"330\",\"340\",\"345\",\"350\",\"355\",\"360\",\"370\",\"375\",\"385\",\"390\",\"395\",\"405\",\"410\",\"420\",\"425\",\"435\",\"440\",\"445\",\"455\",\"460\",\"470\",\"475\",\"485\",\"490\",\"495\",\"505\",\"510\",\"540\",\"545\",\"550\",\"555\",\"565\",\"590\",\"600\",\"605\",\"615\",\"620\",\"625\",\"635\",\"640\",\"650\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"715\",\"720\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"765\",\"770\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"815\",\"820\",\"830\",\"835\",\"840\",\"850\",\"855\",\"865\",\"810\",\"825\"]'), ('82', '11', '5', '162', '475', '[\"10\",\"15\",\"25\",\"30\",\"35\",\"40\",\"45\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"90\",\"95\",\"105\",\"110\",\"115\",\"125\",\"130\",\"140\",\"145\",\"155\",\"160\",\"165\",\"175\",\"180\",\"190\",\"195\",\"205\",\"210\",\"215\",\"225\",\"230\",\"240\",\"245\",\"255\",\"260\",\"265\",\"275\",\"280\",\"290\",\"295\",\"305\",\"310\",\"315\",\"325\",\"330\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"375\",\"380\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"425\",\"430\",\"440\",\"445\",\"450\",\"460\",\"465\",\"475\"]'), ('83', '11', '5', '193', '390', '[\"5\",\"15\",\"20\",\"30\",\"35\",\"40\",\"45\",\"75\",\"80\",\"130\",\"145\",\"160\",\"175\",\"195\",\"245\",\"285\",\"290\",\"295\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"340\",\"345\",\"355\",\"360\",\"335\",\"370\",\"375\",\"385\",\"390\"]'), ('84', '11', '5', '184', '255', '[\"5\",\"15\",\"20\",\"30\",\"35\",\"40\",\"50\",\"55\",\"65\",\"70\",\"80\",\"85\",\"90\",\"100\",\"105\",\"115\",\"120\",\"130\",\"135\",\"140\",\"150\",\"155\",\"165\",\"170\",\"180\",\"185\",\"190\",\"200\",\"205\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"250\",\"255\"]'), ('85', '11', '5', '186', '160', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"35\",\"40\",\"50\",\"55\",\"60\",\"70\",\"75\",\"85\",\"90\",\"100\",\"105\",\"110\",\"120\",\"125\",\"135\",\"140\",\"150\",\"155\",\"160\"]'), ('86', '11', '5', '187', '585', '[\"5\",\"15\",\"20\",\"30\",\"35\",\"40\",\"50\",\"55\",\"65\",\"70\",\"80\",\"85\",\"90\",\"100\",\"105\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"150\",\"155\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"200\",\"205\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"250\",\"255\",\"265\",\"270\",\"275\",\"285\",\"290\",\"300\",\"305\",\"315\",\"320\",\"325\",\"335\",\"340\",\"350\",\"355\",\"365\",\"370\",\"375\",\"385\",\"390\",\"400\",\"405\",\"415\",\"420\",\"425\",\"435\",\"440\",\"450\",\"455\",\"465\",\"470\",\"475\",\"485\",\"490\",\"500\",\"505\",\"515\",\"520\",\"525\",\"535\",\"540\",\"550\",\"555\",\"565\",\"570\",\"575\",\"585\"]'), ('87', '11', '5', '188', '295', '[\"5\",\"10\",\"20\",\"25\",\"35\",\"40\",\"50\",\"55\",\"60\",\"70\",\"75\",\"85\",\"90\",\"100\",\"105\",\"110\",\"120\",\"125\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"170\",\"175\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"220\",\"225\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"270\",\"275\",\"285\",\"290\",\"295\"]'), ('88', '11', '5', '189', '440', '[\"5\",\"10\",\"20\",\"25\",\"35\",\"40\",\"50\",\"55\",\"60\",\"70\",\"75\",\"85\",\"90\",\"100\",\"105\",\"110\",\"120\",\"125\",\"135\",\"140\",\"150\",\"155\",\"160\",\"170\",\"175\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"220\",\"225\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"270\",\"275\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"320\",\"325\",\"335\",\"340\",\"345\",\"355\",\"360\",\"370\",\"375\",\"385\",\"390\",\"395\",\"405\",\"410\",\"420\",\"425\",\"435\",\"440\"]'), ('89', '11', '5', '183', '3600', '[\"5\",\"10\",\"15\",\"25\",\"30\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"75\",\"80\",\"90\",\"95\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"140\",\"145\",\"155\",\"160\",\"165\",\"170\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"470\",\"475\",\"480\",\"260\",\"485\",\"490\",\"495\",\"500\",\"505\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1135\",\"1145\",\"1150\",\"1155\",\"1160\",\"1165\",\"1170\",\"1180\",\"1185\",\"1190\",\"1195\",\"1200\",\"1205\",\"1210\",\"1215\",\"1225\",\"1230\",\"1235\",\"1240\",\"1245\",\"1250\",\"1255\",\"1260\",\"1270\",\"1275\",\"1280\",\"1285\",\"1290\",\"1295\",\"1300\",\"1305\",\"1315\",\"1320\",\"1325\",\"1330\",\"1335\",\"1340\",\"1345\",\"1350\",\"1360\",\"1365\",\"1370\",\"1375\",\"1380\",\"1385\",\"1395\",\"1400\",\"1405\",\"1410\",\"1415\",\"1420\",\"1425\",\"1430\",\"1440\",\"1445\",\"1450\",\"1455\",\"1460\",\"1465\",\"1470\",\"1475\",\"1485\",\"1490\",\"1495\",\"1500\",\"1505\",\"1510\",\"1515\",\"1520\",\"1530\",\"1535\",\"1540\",\"1545\",\"1550\",\"1555\",\"1565\",\"1570\",\"1575\",\"1580\",\"1585\",\"1590\",\"1595\",\"1600\",\"1610\",\"1615\",\"1620\",\"1625\",\"1630\",\"1635\",\"1640\",\"1645\",\"1655\",\"1660\",\"1665\",\"1670\",\"1675\",\"1680\",\"1690\",\"1695\",\"1700\",\"1705\",\"1710\",\"1715\",\"1720\",\"1725\",\"1735\",\"1745\",\"1750\",\"1760\",\"1765\",\"1770\",\"1780\",\"1785\",\"1795\",\"1800\",\"1810\",\"1815\",\"1820\",\"1830\",\"1835\",\"1845\",\"1850\",\"1860\",\"1865\",\"1870\",\"1880\",\"1885\",\"1895\",\"1900\",\"1910\",\"1915\",\"1920\",\"1930\",\"1935\",\"1945\",\"1950\",\"1960\",\"1965\",\"1970\",\"1980\",\"1985\",\"1995\",\"2000\",\"2005\",\"2010\",\"2015\",\"2020\",\"2030\",\"2035\",\"2045\",\"2050\",\"2055\",\"2060\",\"2065\",\"2070\",\"2080\",\"2085\",\"2095\",\"2100\",\"2105\",\"2110\",\"2115\",\"2120\",\"2130\",\"2135\",\"2145\",\"2150\",\"2155\",\"2165\",\"2170\",\"2180\",\"2185\",\"2195\",\"2200\",\"2205\",\"2210\",\"2215\",\"2225\",\"2230\",\"2240\",\"2245\",\"2250\",\"2260\",\"2265\",\"2275\",\"2280\",\"2290\",\"2295\",\"2300\",\"2310\",\"2315\",\"2325\",\"2330\",\"2340\",\"2345\",\"2350\",\"2360\",\"2365\",\"2375\",\"2380\",\"2390\",\"2395\",\"2400\",\"2410\",\"2415\",\"2425\",\"2430\",\"2435\",\"2440\",\"2445\",\"2450\",\"2455\",\"2460\",\"2465\",\"2470\",\"2475\",\"2480\",\"2485\",\"2490\",\"2495\",\"2500\",\"2505\",\"2510\",\"2515\",\"2520\",\"2525\",\"2530\",\"2535\",\"2540\",\"2545\",\"2550\",\"2555\",\"2560\",\"2565\",\"2570\",\"2575\",\"2580\",\"2585\",\"2590\",\"2595\",\"2600\",\"2605\",\"2610\",\"2615\",\"2620\",\"2625\",\"2630\",\"2635\",\"2640\",\"2645\",\"2650\",\"2655\",\"2660\",\"2665\",\"2670\",\"2675\",\"2680\",\"2685\",\"2690\",\"2695\",\"2700\",\"2705\",\"2710\",\"2715\",\"2720\",\"2725\",\"2730\",\"2735\",\"2740\",\"2745\",\"2750\",\"2755\",\"2760\",\"2765\",\"2770\",\"2775\",\"2780\",\"2785\",\"2790\",\"2795\",\"2800\",\"2805\",\"2810\",\"2815\",\"2820\",\"2825\",\"2830\",\"2835\",\"2840\",\"2845\",\"2850\",\"2855\",\"2860\",\"2865\",\"2870\",\"2875\",\"2880\",\"2885\",\"2890\",\"2895\",\"2900\",\"2905\",\"2910\",\"2915\",\"2920\",\"2925\",\"2930\",\"2935\",\"2940\",\"2945\",\"2950\",\"2955\",\"2960\",\"2965\",\"2970\",\"2975\",\"2980\",\"2985\",\"2990\",\"2995\",\"3000\",\"3005\",\"3010\",\"3015\",\"3020\",\"3025\",\"3030\",\"3035\",\"3040\",\"3045\",\"3050\",\"3055\",\"3060\",\"3065\",\"3070\",\"3075\",\"3080\",\"3085\",\"3090\",\"3095\",\"3100\",\"3105\",\"3110\",\"3115\",\"3120\",\"3125\",\"3130\",\"3135\",\"3140\",\"3145\",\"3150\",\"3155\",\"3160\",\"3165\",\"3170\",\"3175\",\"3180\",\"3185\",\"3190\",\"3195\",\"3200\",\"3205\",\"3210\",\"3215\",\"3220\",\"3225\",\"3230\",\"3235\",\"3240\",\"3245\",\"3250\",\"3255\",\"3260\",\"3265\",\"3270\",\"3275\",\"3280\",\"3285\",\"3290\",\"3295\",\"3300\",\"3305\",\"3310\",\"3315\",\"3320\",\"3325\",\"3330\",\"3335\",\"3340\",\"3345\",\"3350\",\"3355\",\"3360\",\"3365\",\"3370\",\"3375\",\"3380\",\"3385\",\"3390\",\"3395\",\"3400\",\"3405\",\"3410\",\"3415\",\"3420\",\"3425\",\"3430\",\"3435\",\"3440\",\"3445\",\"3450\",\"3455\",\"3460\",\"3465\",\"3470\",\"3475\",\"3480\",\"3485\",\"3490\",\"3495\",\"3500\",\"3505\",\"3510\",\"3515\",\"3520\",\"3525\",\"3530\",\"3535\",\"3540\",\"3545\",\"3550\",\"3555\",\"3560\",\"3565\",\"3570\",\"3575\",\"3580\",\"3585\",\"3590\",\"3595\",\"3600\"]'), ('90', '1', '5', '197', '1955', '[\"1365\",\"1370\",\"1955\"]'), ('91', '7', '5', '196', '5135', '[\"630\",\"0\",\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"990\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1135\",\"1140\",\"1145\",\"1150\",\"1155\",\"1160\",\"1165\",\"1170\",\"1175\",\"1180\",\"1185\",\"1190\",\"1195\",\"1200\",\"1205\",\"1210\",\"1215\",\"1220\",\"1225\",\"1230\",\"1235\",\"1240\",\"1245\",\"1250\",\"1255\",\"1260\",\"1265\",\"1270\",\"1275\",\"1280\",\"1285\",\"1290\",\"1295\",\"1300\",\"1305\",\"1310\",\"1315\",\"1320\",\"1325\",\"1330\",\"1335\",\"1340\",\"1345\",\"1350\",\"1355\",\"1360\",\"1365\",\"1370\",\"1375\",\"1380\",\"1385\",\"1390\",\"1395\",\"1400\",\"1405\",\"1410\",\"1415\",\"1420\",\"1425\",\"1430\",\"1435\",\"1440\",\"1445\",\"1450\",\"1455\",\"1460\",\"1465\",\"1470\",\"1475\",\"1480\",\"1485\",\"1490\",\"1495\",\"1500\",\"1505\",\"1510\",\"1515\",\"1520\",\"1525\",\"1530\",\"1535\",\"1540\",\"1545\",\"1550\",\"1555\",\"1560\",\"1565\",\"1570\",\"1575\",\"1580\",\"1585\",\"1590\",\"1595\",\"1600\",\"1605\",\"1610\",\"1615\",\"1620\",\"1625\",\"1630\",\"1635\",\"1640\",\"1645\",\"1650\",\"1655\",\"1660\",\"1665\",\"1670\",\"1675\",\"1680\",\"1685\",\"1690\",\"1695\",\"1700\",\"1705\",\"1710\",\"1715\",\"1720\",\"1725\",\"1730\",\"1735\",\"1740\",\"1745\",\"1750\",\"1755\",\"1760\",\"1765\",\"1770\",\"1775\",\"1780\",\"1785\",\"1790\",\"1795\",\"1800\",\"1805\",\"1810\",\"1815\",\"1820\",\"1825\",\"1830\",\"1835\",\"1840\",\"1845\",\"1850\",\"1855\",\"1860\",\"1865\",\"1870\",\"1875\",\"1880\",\"1885\",\"1890\",\"1895\",\"1900\",\"1905\",\"1910\",\"1915\",\"1920\",\"1925\",\"1930\",\"1935\",\"1940\",\"1945\",\"1950\",\"1955\",\"1960\",\"1965\",\"1970\",\"1975\",\"1980\",\"1985\",\"1990\",\"1995\",\"2000\",\"2005\",\"2010\",\"2015\",\"2020\",\"2025\",\"2030\",\"2035\",\"2040\",\"2045\",\"2050\",\"2055\",\"2060\",\"2065\",\"2070\",\"2075\",\"2080\",\"2085\",\"2090\",\"2095\",\"2100\",\"2105\",\"2110\",\"2115\",\"2120\",\"2125\",\"2130\",\"2135\",\"2140\",\"2145\",\"2150\",\"2155\",\"2160\",\"2165\",\"2170\",\"2175\",\"2180\",\"2185\",\"2190\",\"2195\",\"2200\",\"2205\",\"2210\",\"2215\",\"2220\",\"2225\",\"2230\",\"2235\",\"2240\",\"2245\",\"2250\",\"2255\",\"2260\",\"2265\",\"2270\",\"2275\",\"2280\",\"2285\",\"2290\",\"2295\",\"2300\",\"2305\",\"2310\",\"2315\",\"2320\",\"2325\",\"2330\",\"2335\",\"2340\",\"2345\",\"2350\",\"2355\",\"2360\",\"2365\",\"2370\",\"2375\",\"2380\",\"2385\",\"2390\",\"2395\",\"2400\",\"2405\",\"2410\",\"2415\",\"2420\",\"2425\",\"2430\",\"2435\",\"2440\",\"2445\",\"2450\",\"2455\",\"2460\",\"2465\",\"2470\",\"2475\",\"2480\",\"2485\",\"2490\",\"2495\",\"2500\",\"2505\",\"2510\",\"2515\",\"2520\",\"2525\",\"2530\",\"2535\",\"2540\",\"2545\",\"2550\",\"2555\",\"2560\",\"2565\",\"2570\",\"2575\",\"2580\",\"2585\",\"2590\",\"2595\",\"2600\",\"2605\",\"2610\",\"2615\",\"2620\",\"2625\",\"2630\",\"2635\",\"2640\",\"2645\",\"2650\",\"2655\",\"2660\",\"2665\",\"2670\",\"2675\",\"2680\",\"2685\",\"2690\",\"2695\",\"2700\",\"2705\",\"2710\",\"2715\",\"2720\",\"2725\",\"2730\",\"2735\",\"2740\",\"2745\",\"2750\",\"2755\",\"2760\",\"2765\",\"2770\",\"2775\",\"2780\",\"2785\",\"2790\",\"2795\",\"2800\",\"2805\",\"2810\",\"2815\",\"2820\",\"2825\",\"2830\",\"2835\",\"2840\",\"2845\",\"2850\",\"2855\",\"2860\",\"2865\",\"2870\",\"2875\",\"2880\",\"2885\",\"2890\",\"2895\",\"2900\",\"2905\",\"2910\",\"2915\",\"2920\",\"2925\",\"2930\",\"2935\",\"2940\",\"2945\",\"2950\",\"2955\",\"2960\",\"2965\",\"2970\",\"2975\",\"2980\",\"2985\",\"2990\",\"2995\",\"3000\",\"3005\",\"3010\",\"3015\",\"3020\",\"3025\",\"3030\",\"3035\",\"3040\",\"3045\",\"3050\",\"3055\",\"3060\",\"3065\",\"3070\",\"3075\",\"3080\",\"3085\",\"3090\",\"3095\",\"3100\",\"3105\",\"3110\",\"3115\",\"3120\",\"3125\",\"3130\",\"3135\",\"3140\",\"3145\",\"3150\",\"3155\",\"3160\",\"3165\",\"3170\",\"3175\",\"3180\",\"3185\",\"3190\",\"3195\",\"3200\",\"3205\",\"3210\",\"3215\",\"3220\",\"3225\",\"3230\",\"3235\",\"3240\",\"3245\",\"3250\",\"3255\",\"3260\",\"3265\",\"3270\",\"3275\",\"3280\",\"3285\",\"3290\",\"3295\",\"3300\",\"3305\",\"3310\",\"3315\",\"3320\",\"3325\",\"3330\",\"3335\",\"3340\",\"3345\",\"3350\",\"3355\",\"3360\",\"3365\",\"3370\",\"3375\",\"3380\",\"3385\",\"3390\",\"3395\",\"3400\",\"3405\",\"3410\",\"3415\",\"3420\",\"3425\",\"3430\",\"3435\",\"3440\",\"3445\",\"3450\",\"3455\",\"3460\",\"3465\",\"3470\",\"3475\",\"3480\",\"3485\",\"3490\",\"3495\",\"3500\",\"3505\",\"3510\",\"3515\",\"3520\",\"3525\",\"3530\",\"3535\",\"3540\",\"3545\",\"3550\",\"3555\",\"3560\",\"3565\",\"3570\",\"3575\",\"3580\",\"3585\",\"3590\",\"3595\",\"3600\",\"3605\",\"3610\",\"3615\",\"3620\",\"3625\",\"3630\",\"3635\",\"3640\",\"3645\",\"3650\",\"3655\",\"3660\",\"3665\",\"3670\",\"3675\",\"3680\",\"3685\",\"3690\",\"3695\",\"3700\",\"3705\",\"3710\",\"3715\",\"3720\",\"3725\",\"3730\",\"3735\",\"3740\",\"3745\",\"3750\",\"3755\",\"3760\",\"3765\",\"3770\",\"3775\",\"3780\",\"3785\",\"3790\",\"3795\",\"3800\",\"3805\",\"3810\",\"3815\",\"3820\",\"3825\",\"3830\",\"3835\",\"3840\",\"3845\",\"3850\",\"3855\",\"3860\",\"3865\",\"3870\",\"3875\",\"3880\",\"3885\",\"3890\",\"3895\",\"3900\",\"3905\",\"3910\",\"3915\",\"3920\",\"3925\",\"3930\",\"3935\",\"3940\",\"3945\",\"3950\",\"3955\",\"3960\",\"3965\",\"3970\",\"3975\",\"3980\",\"3985\",\"3990\",\"3995\",\"4000\",\"4005\",\"4010\",\"4015\",\"4020\",\"4025\",\"4030\",\"4035\",\"4040\",\"4045\",\"4050\",\"4055\",\"4060\",\"4065\",\"4070\",\"4075\",\"4080\",\"4085\",\"4090\",\"4095\",\"4100\",\"4105\",\"4110\",\"4115\",\"4120\",\"4125\",\"4130\",\"4135\",\"4140\",\"4145\",\"4150\",\"4155\",\"4160\",\"4165\",\"4170\",\"4175\",\"4180\",\"4185\",\"4190\",\"4195\",\"4200\",\"4205\",\"4210\",\"4215\",\"4220\",\"4225\",\"4230\",\"4235\",\"4240\",\"4245\",\"4250\",\"4255\",\"4260\",\"4265\",\"4270\",\"4275\",\"4280\",\"4285\",\"4290\",\"4295\",\"4300\",\"4305\",\"4310\",\"4315\",\"4320\",\"4325\",\"4330\",\"4335\",\"4340\",\"4345\",\"4350\",\"4355\",\"4360\",\"4365\",\"4370\",\"4375\",\"4380\",\"4385\",\"4390\",\"4395\",\"4400\",\"4405\",\"4410\",\"4415\",\"4420\",\"4425\",\"4430\",\"4435\",\"4440\",\"4445\",\"4450\",\"4455\",\"4460\",\"4465\",\"4470\",\"4475\",\"4480\",\"4485\",\"4490\",\"4495\",\"4500\",\"4505\",\"4510\",\"4515\",\"4520\",\"4525\",\"4530\",\"4535\",\"4540\",\"4545\",\"4550\",\"4555\",\"4560\",\"4565\",\"4570\",\"4575\",\"4580\",\"4585\",\"4590\",\"4595\",\"4600\",\"4605\",\"4610\",\"4615\",\"4620\",\"4625\",\"4630\",\"4635\",\"4640\",\"4645\",\"4650\",\"4655\",\"4660\",\"4665\",\"4670\",\"4675\",\"4680\",\"4685\",\"4690\",\"4695\",\"4700\",\"4705\",\"4710\",\"4715\",\"4720\",\"4725\",\"4730\",\"4735\",\"4740\",\"4745\",\"4750\",\"4755\",\"4760\",\"4765\",\"4770\",\"4775\",\"4780\",\"4785\",\"4790\",\"4795\",\"4800\",\"4805\",\"4810\",\"4815\",\"4820\",\"4825\",\"4830\",\"4835\",\"4840\",\"4845\",\"4850\",\"4855\",\"4860\",\"4865\",\"4870\",\"4875\",\"4880\",\"4885\",\"4890\",\"4895\",\"4900\",\"4905\",\"4910\",\"4915\",\"4920\",\"4925\",\"4930\",\"4935\",\"4940\",\"4945\",\"4950\",\"4955\",\"4960\",\"4965\",\"4970\",\"4975\",\"4980\",\"4985\",\"4990\",\"4995\",\"5000\",\"5005\",\"5010\",\"5015\",\"5020\",\"5025\",\"5030\",\"5035\",\"5040\",\"5045\",\"5050\",\"5055\",\"5060\",\"5065\",\"5070\",\"5075\",\"5080\",\"5085\",\"5090\",\"5095\",\"5100\",\"5105\",\"5110\",\"5115\",\"5120\",\"5125\",\"5130\",\"5135\"]'), ('92', '7', '5', '197', '2190', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"990\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1135\",\"1140\",\"1145\",\"1150\",\"1155\",\"1160\",\"1165\",\"1170\",\"1175\",\"1180\",\"1185\",\"1190\",\"1195\",\"1200\",\"1205\",\"1210\",\"1215\",\"1220\",\"1225\",\"1230\",\"1235\",\"1240\",\"1245\",\"1250\",\"1255\",\"1260\",\"1265\",\"1270\",\"1275\",\"1280\",\"1285\",\"1290\",\"1295\",\"1300\",\"1305\",\"1310\",\"1315\",\"1320\",\"1325\",\"1330\",\"1335\",\"1340\",\"1345\",\"1350\",\"1355\",\"1360\",\"1365\",\"1370\",\"1375\",\"1380\",\"1385\",\"1390\",\"1395\",\"1400\",\"1405\",\"1410\",\"1415\",\"1420\",\"1425\",\"1430\",\"1435\",\"1440\",\"1445\",\"1450\",\"1455\",\"1460\",\"1465\",\"1470\",\"1475\",\"1480\",\"1485\",\"1490\",\"1495\",\"1500\",\"1505\",\"1510\",\"1515\",\"1520\",\"1525\",\"1530\",\"1535\",\"1540\",\"1545\",\"1550\",\"1555\",\"1560\",\"1565\",\"1570\",\"1575\",\"1580\",\"1585\",\"1590\",\"1595\",\"1600\",\"1605\",\"1610\",\"1615\",\"1620\",\"1625\",\"1630\",\"1635\",\"1640\",\"1645\",\"1650\",\"1655\",\"1660\",\"1665\",\"1670\",\"1675\",\"1680\",\"1685\",\"1690\",\"1695\",\"1700\",\"1705\",\"1710\",\"1715\",\"1720\",\"1725\",\"1730\",\"1735\",\"1740\",\"1745\",\"1750\",\"1755\",\"1760\",\"1765\",\"1770\",\"1775\",\"1780\",\"1785\",\"1790\",\"1795\",\"1800\",\"1805\",\"1810\",\"1815\",\"1820\",\"1825\",\"1830\",\"1835\",\"1840\",\"1845\",\"1850\",\"1855\",\"1860\",\"1865\",\"1870\",\"1875\",\"1880\",\"1885\",\"1890\",\"1895\",\"1900\",\"1905\",\"1910\",\"1915\",\"1920\",\"1925\",\"1930\",\"1935\",\"1940\",\"1945\",\"1950\",\"1955\",\"1960\",\"1965\",\"1970\",\"1975\",\"1980\",\"1985\",\"1990\",\"1995\",\"2000\",\"2005\",\"2010\",\"2015\",\"2020\",\"2025\",\"2030\",\"2035\",\"2040\",\"2045\",\"2050\",\"2055\",\"2060\",\"2065\",\"2070\",\"2075\",\"2080\",\"2085\",\"2090\",\"2095\",\"2100\",\"2105\",\"2110\",\"2115\",\"2120\",\"2125\",\"2130\",\"2135\",\"2140\",\"2145\",\"2150\",\"2155\",\"2160\",\"2165\",\"2170\",\"2175\",\"2180\",\"2185\",\"2190\"]'), ('93', '1', '5', '199', '5180', '[\"5\",\"10\",\"15\",\"60\",\"2780\",\"4325\",\"0\",\"5725\",\"5180\"]'), ('94', '10', '5', '196', '5130', '[\"5\",\"20\",\"25\",\"40\",\"45\",\"50\",\"65\",\"70\",\"85\",\"90\",\"95\",\"110\",\"115\",\"130\",\"135\",\"140\",\"155\",\"160\",\"175\",\"180\",\"185\",\"200\",\"205\",\"220\",\"225\",\"230\",\"245\",\"250\",\"265\",\"270\",\"275\",\"290\",\"295\",\"310\",\"315\",\"320\",\"335\",\"340\",\"355\",\"360\",\"365\",\"380\",\"385\",\"400\",\"405\",\"410\",\"425\",\"430\",\"445\",\"450\",\"455\",\"470\",\"475\",\"490\",\"495\",\"500\",\"515\",\"520\",\"535\",\"540\",\"545\",\"560\",\"565\",\"580\",\"585\",\"590\",\"605\",\"610\",\"625\",\"630\",\"635\",\"650\",\"655\",\"670\",\"675\",\"680\",\"695\",\"700\",\"715\",\"720\",\"725\",\"740\",\"745\",\"760\",\"765\",\"770\",\"785\",\"790\",\"805\",\"810\",\"815\",\"830\",\"835\",\"850\",\"855\",\"860\",\"875\",\"880\",\"895\",\"900\",\"905\",\"920\",\"925\",\"940\",\"945\",\"950\",\"965\",\"970\",\"985\",\"990\",\"995\",\"1010\",\"1015\",\"1030\",\"1035\",\"1040\",\"1055\",\"1060\",\"1075\",\"1080\",\"1085\",\"1100\",\"1105\",\"1120\",\"1125\",\"1130\",\"1145\",\"1150\",\"1165\",\"1170\",\"1175\",\"1190\",\"1195\",\"1210\",\"1215\",\"1220\",\"1235\",\"1240\",\"1245\",\"1260\",\"1335\",\"1340\",\"1280\",\"1285\",\"1300\",\"1305\",\"1320\",\"1325\",\"1330\",\"1345\",\"1350\",\"1365\",\"1370\",\"1375\",\"1390\",\"1395\",\"1410\",\"1415\",\"1420\",\"1435\",\"1440\",\"1455\",\"1460\",\"1465\",\"1480\",\"1485\",\"1500\",\"1505\",\"1510\",\"1525\",\"1530\",\"1545\",\"1550\",\"1555\",\"1570\",\"1575\",\"1590\",\"1595\",\"1600\",\"1615\",\"1620\",\"1635\",\"1640\",\"1645\",\"1660\",\"1665\",\"1680\",\"1685\",\"1690\",\"1705\",\"1710\",\"1725\",\"1730\",\"1735\",\"1750\",\"1755\",\"1770\",\"1775\",\"1780\",\"1795\",\"1800\",\"1815\",\"1820\",\"1825\",\"1840\",\"1845\",\"1860\",\"1865\",\"1870\",\"1885\",\"1890\",\"1905\",\"1910\",\"1915\",\"1930\",\"1935\",\"1950\",\"1955\",\"1960\",\"1975\",\"1980\",\"1995\",\"2000\",\"2005\",\"2020\",\"2025\",\"2040\",\"2045\",\"2050\",\"2065\",\"2070\",\"2085\",\"2090\",\"2095\",\"2110\",\"2125\",\"2130\",\"2135\",\"2150\",\"2155\",\"2170\",\"2175\",\"2180\",\"2195\",\"2200\",\"2215\",\"2220\",\"2225\",\"2240\",\"2245\",\"2260\",\"2265\",\"2270\",\"2285\",\"2290\",\"2305\",\"2310\",\"2315\",\"2330\",\"2335\",\"2350\",\"2355\",\"2360\",\"2375\",\"2380\",\"2395\",\"2400\",\"2405\",\"2420\",\"2425\",\"2440\",\"2445\",\"2450\",\"2465\",\"2470\",\"2485\",\"2490\",\"2495\",\"2510\",\"2515\",\"2530\",\"2535\",\"2540\",\"2555\",\"2560\",\"2575\",\"2580\",\"2585\",\"2600\",\"2605\",\"2620\",\"2625\",\"2630\",\"2645\",\"2650\",\"2665\",\"2670\",\"2675\",\"2690\",\"2695\",\"2710\",\"2715\",\"2720\",\"2735\",\"2740\",\"2755\",\"2760\",\"2765\",\"2780\",\"2785\",\"2800\",\"2805\",\"2810\",\"2825\",\"2830\",\"2845\",\"2850\",\"2855\",\"2870\",\"2875\",\"2890\",\"2895\",\"2900\",\"2915\",\"2920\",\"2935\",\"2940\",\"2945\",\"2960\",\"2965\",\"2980\",\"2985\",\"2990\",\"3005\",\"3010\",\"3025\",\"3030\",\"3035\",\"3050\",\"3055\",\"3070\",\"3075\",\"3080\",\"3095\",\"3100\",\"3115\",\"3120\",\"3125\",\"3140\",\"3145\",\"3160\",\"3165\",\"3170\",\"3185\",\"3190\",\"3205\",\"3210\",\"3215\",\"3230\",\"3235\",\"3250\",\"3255\",\"3260\",\"3275\",\"3280\",\"3295\",\"3300\",\"3305\",\"3320\",\"3325\",\"3340\",\"3345\",\"3350\",\"3365\",\"3370\",\"3385\",\"3390\",\"3395\",\"3410\",\"3415\",\"3430\",\"3435\",\"3440\",\"3455\",\"3460\",\"3475\",\"3480\",\"3485\",\"3500\",\"3505\",\"3520\",\"3525\",\"3530\",\"3545\",\"3550\",\"3565\",\"3570\",\"3575\",\"3590\",\"3595\",\"3610\",\"3615\",\"3620\",\"3635\",\"3640\",\"3655\",\"3660\",\"3665\",\"3680\",\"3685\",\"3700\",\"3705\",\"3710\",\"3725\",\"3730\",\"3745\",\"3750\",\"3755\",\"3770\",\"3775\",\"3790\",\"3795\",\"3800\",\"3815\",\"3820\",\"3835\",\"3840\",\"3845\",\"3860\",\"3865\",\"3880\",\"3885\",\"3890\",\"3905\",\"3910\",\"3925\",\"3930\",\"3935\",\"3950\",\"3955\",\"3970\",\"3975\",\"3980\",\"3995\",\"4000\",\"4015\",\"4020\",\"4025\",\"4040\",\"4045\",\"4060\",\"4065\",\"4070\",\"4085\",\"4090\",\"4105\",\"4110\",\"4115\",\"4130\",\"4135\",\"4150\",\"4155\",\"4160\",\"4175\",\"4180\",\"4195\",\"4200\",\"4205\",\"4220\",\"4225\",\"4240\",\"4245\",\"4250\",\"4265\",\"4270\",\"4285\",\"4290\",\"4295\",\"4310\",\"4315\",\"4330\",\"4335\",\"4340\",\"4355\",\"4360\",\"4375\",\"4380\",\"4385\",\"4400\",\"4405\",\"4420\",\"4425\",\"4430\",\"4445\",\"4450\",\"4465\",\"4470\",\"4475\",\"4490\",\"4495\",\"4510\",\"4515\",\"4520\",\"4535\",\"4540\",\"4555\",\"4560\",\"4565\",\"4580\",\"4585\",\"4600\",\"4605\",\"4610\",\"4625\",\"4630\",\"4645\",\"4650\",\"4655\",\"4670\",\"4675\",\"4690\",\"4695\",\"4700\",\"4715\",\"4720\",\"4735\",\"4740\",\"4745\",\"4760\",\"4765\",\"4780\",\"4785\",\"4790\",\"4805\",\"4810\",\"4825\",\"4830\",\"4835\",\"4850\",\"4855\",\"4870\",\"4875\",\"4880\",\"4895\",\"4900\",\"4915\",\"4920\",\"4925\",\"4930\",\"4945\",\"4950\",\"4965\",\"4970\",\"4975\",\"4990\",\"4995\",\"5010\",\"5015\",\"5020\",\"5035\",\"5040\",\"5055\",\"5060\",\"5065\",\"5080\",\"5085\",\"5100\",\"5105\",\"5110\",\"5125\",\"5130\"]'), ('95', '15', '6', '170', '330', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\"]'), ('96', '15', '6', '171', '165', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\"]'), ('97', '15', '6', '172', '75', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\"]'), ('98', '7', '5', '199', '980', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\"]'), ('99', '11', '5', '200', '5625', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"75\",\"80\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"125\",\"130\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"175\",\"180\",\"190\",\"195\",\"200\",\"210\",\"215\",\"225\",\"230\",\"240\",\"245\",\"250\",\"260\",\"265\",\"275\",\"280\",\"290\",\"295\",\"300\",\"310\",\"315\",\"325\",\"330\",\"340\",\"345\",\"350\",\"360\",\"365\",\"375\",\"380\",\"390\",\"395\",\"400\",\"410\",\"415\",\"255\",\"270\",\"285\",\"305\",\"320\",\"335\",\"355\",\"370\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"605\",\"610\",\"620\",\"625\",\"630\",\"640\",\"645\",\"655\",\"660\",\"670\",\"675\",\"680\",\"690\",\"695\",\"705\",\"710\",\"720\",\"725\",\"730\",\"740\",\"745\",\"755\",\"760\",\"770\",\"775\",\"780\",\"1260\",\"1265\",\"1275\",\"1280\",\"1290\",\"1295\",\"1300\",\"1305\",\"1310\",\"1315\",\"1325\",\"1330\",\"1340\",\"1345\",\"1350\",\"1355\",\"1360\",\"1365\",\"1375\",\"1580\",\"1590\",\"1595\",\"1605\",\"1610\",\"1620\",\"1625\",\"1630\",\"1795\",\"1800\",\"1810\",\"1815\",\"1820\",\"1830\",\"1835\",\"1845\",\"1850\",\"1860\",\"2255\",\"2260\",\"2265\",\"2270\",\"2280\",\"2285\",\"2295\",\"2300\",\"2305\",\"2310\",\"2315\",\"2320\",\"2330\",\"2335\",\"2345\",\"2350\",\"2355\",\"2365\",\"2370\",\"2380\",\"2385\",\"2395\",\"2400\",\"2620\",\"2625\",\"2630\",\"2640\",\"2645\",\"2655\",\"2660\",\"2665\",\"2675\",\"2680\",\"2690\",\"2695\",\"2705\",\"2710\",\"2715\",\"2725\",\"2730\",\"2740\",\"2745\",\"2750\",\"2755\",\"2760\",\"2765\",\"2775\",\"2780\",\"2790\",\"2795\",\"2800\",\"2805\",\"2810\",\"2815\",\"2825\",\"2830\",\"2840\",\"2845\",\"2850\",\"2860\",\"2865\",\"2875\",\"2880\",\"2890\",\"2895\",\"2900\",\"2910\",\"2915\",\"2925\",\"2930\",\"2940\",\"2945\",\"2950\",\"2960\",\"2965\",\"3345\",\"3350\",\"3360\",\"3630\",\"3640\",\"3645\",\"3650\",\"3655\",\"3660\",\"3665\",\"3675\",\"3680\",\"3690\",\"3695\",\"3700\",\"3705\",\"3710\",\"3715\",\"3725\",\"3730\",\"3740\",\"3745\",\"3750\",\"3755\",\"3760\",\"3765\",\"3775\",\"3780\",\"3790\",\"3795\",\"3800\",\"3810\",\"3815\",\"3825\",\"3830\",\"3840\",\"3845\",\"3850\",\"3860\",\"3865\",\"3875\",\"3880\",\"4065\",\"4070\",\"4075\",\"4085\",\"4090\",\"4100\",\"4105\",\"4110\",\"4120\",\"4125\",\"4135\",\"4140\",\"4150\",\"4155\",\"4160\",\"4170\",\"4175\",\"4185\",\"4190\",\"4200\",\"4205\",\"4210\",\"4220\",\"4225\",\"4235\",\"4240\",\"4245\",\"4250\",\"4255\",\"4260\",\"4270\",\"4275\",\"4285\",\"4290\",\"4295\",\"4300\",\"4305\",\"4310\",\"4320\",\"4325\",\"4335\",\"4340\",\"4345\",\"4350\",\"4355\",\"4360\",\"4370\",\"4375\",\"4635\",\"4645\",\"4650\",\"4830\",\"4835\",\"4845\",\"4850\",\"4855\",\"4860\",\"4865\",\"4875\",\"4880\",\"4890\",\"4895\",\"4900\",\"4905\",\"4910\",\"4915\",\"4925\",\"4930\",\"4940\",\"4945\",\"4955\",\"4960\",\"4970\",\"4975\",\"4980\",\"4990\",\"4995\",\"5255\",\"5355\",\"5365\",\"5525\",\"5535\",\"5540\",\"5550\",\"5555\",\"5565\",\"5570\",\"5580\",\"5585\",\"5595\",\"5600\",\"5610\",\"5620\",\"5625\"]'), ('100', '11', '5', '199', '790', '[\"5\",\"10\",\"350\",\"620\",\"625\",\"630\",\"640\",\"645\",\"655\",\"660\",\"670\",\"675\",\"680\",\"690\",\"695\",\"705\",\"710\",\"720\",\"725\",\"730\",\"740\",\"745\",\"755\",\"760\",\"770\",\"775\",\"780\",\"790\"]'), ('101', '10', '5', '199', '5650', '[\"5\",\"10\",\"15\",\"30\",\"35\",\"50\",\"55\",\"60\",\"75\",\"80\",\"95\",\"100\",\"105\",\"120\",\"125\",\"140\",\"145\",\"150\",\"165\",\"170\",\"185\",\"190\",\"195\",\"210\",\"215\",\"230\",\"235\",\"240\",\"255\",\"260\",\"275\",\"280\",\"285\",\"300\",\"305\",\"320\",\"325\",\"330\",\"345\",\"350\",\"365\",\"370\",\"375\",\"390\",\"395\",\"410\",\"415\",\"420\",\"435\",\"440\",\"455\",\"460\",\"465\",\"480\",\"485\",\"500\",\"505\",\"510\",\"525\",\"530\",\"545\",\"550\",\"555\",\"570\",\"575\",\"590\",\"595\",\"600\",\"615\",\"620\",\"635\",\"640\",\"645\",\"660\",\"665\",\"680\",\"685\",\"690\",\"705\",\"710\",\"725\",\"730\",\"735\",\"750\",\"755\",\"770\",\"775\",\"780\",\"795\",\"800\",\"815\",\"820\",\"825\",\"840\",\"845\",\"860\",\"865\",\"870\",\"885\",\"890\",\"905\",\"910\",\"915\",\"930\",\"935\",\"950\",\"955\",\"960\",\"975\",\"980\",\"995\",\"1000\",\"1005\",\"1020\",\"1025\",\"1040\",\"1045\",\"1050\",\"1065\",\"1070\",\"1085\",\"1090\",\"1095\",\"1110\",\"1115\",\"1130\",\"1135\",\"1140\",\"1155\",\"1160\",\"1175\",\"1180\",\"1185\",\"1200\",\"1205\",\"1220\",\"1225\",\"1230\",\"1245\",\"1250\",\"1265\",\"1270\",\"1275\",\"1400\",\"1405\",\"1420\",\"1425\",\"1430\",\"1445\",\"1450\",\"1465\",\"1470\",\"1475\",\"1490\",\"1495\",\"1510\",\"1515\",\"1520\",\"1535\",\"1540\",\"1555\",\"1560\",\"1565\",\"1580\",\"1585\",\"1600\",\"1605\",\"1610\",\"1625\",\"1630\",\"1645\",\"1650\",\"1655\",\"1670\",\"1675\",\"1690\",\"1695\",\"1700\",\"1715\",\"1720\",\"1735\",\"1740\",\"1745\",\"1760\",\"1765\",\"1780\",\"1785\",\"1790\",\"1805\",\"1810\",\"1825\",\"1830\",\"1835\",\"1850\",\"1855\",\"1870\",\"1875\",\"1880\",\"1895\",\"1900\",\"1915\",\"1920\",\"1925\",\"1940\",\"1945\",\"1960\",\"1965\",\"1970\",\"1985\",\"1990\",\"2005\",\"2010\",\"2015\",\"2030\",\"2035\",\"2050\",\"2055\",\"2060\",\"2075\",\"2080\",\"2095\",\"2100\",\"2105\",\"2120\",\"2125\",\"2140\",\"2145\",\"2150\",\"2165\",\"2170\",\"2185\",\"2190\",\"2195\",\"2210\",\"2215\",\"2230\",\"2235\",\"2240\",\"2255\",\"2260\",\"2275\",\"2280\",\"2285\",\"2300\",\"2305\",\"2320\",\"2325\",\"2330\",\"2345\",\"2350\",\"2365\",\"2370\",\"2375\",\"2390\",\"2395\",\"2410\",\"2415\",\"2420\",\"2435\",\"2440\",\"2455\",\"2460\",\"2465\",\"2480\",\"2485\",\"2500\",\"2505\",\"2510\",\"2525\",\"2530\",\"2545\",\"2550\",\"2555\",\"2570\",\"2575\",\"2590\",\"2595\",\"2600\",\"2615\",\"2620\",\"2635\",\"2640\",\"2645\",\"2660\",\"2665\",\"2680\",\"2685\",\"2690\",\"2705\",\"2710\",\"2725\",\"2730\",\"2735\",\"2750\",\"2755\",\"2770\",\"2775\",\"2780\",\"2795\",\"2800\",\"2815\",\"2820\",\"2825\",\"2840\",\"2845\",\"2860\",\"2865\",\"2870\",\"2885\",\"2890\",\"2905\",\"2910\",\"2915\",\"2930\",\"2935\",\"2950\",\"2955\",\"2960\",\"2975\",\"2980\",\"2995\",\"3000\",\"3005\",\"3020\",\"3025\",\"3040\",\"3045\",\"3050\",\"3065\",\"3070\",\"3085\",\"3090\",\"3095\",\"3110\",\"3115\",\"3130\",\"3135\",\"3140\",\"3155\",\"3160\",\"3175\",\"3180\",\"3185\",\"3200\",\"3205\",\"3220\",\"3225\",\"3230\",\"3245\",\"3250\",\"3265\",\"3270\",\"3275\",\"3290\",\"3295\",\"3310\",\"3315\",\"3320\",\"3335\",\"3340\",\"3355\",\"3360\",\"3365\",\"3380\",\"3385\",\"3400\",\"3405\",\"3410\",\"3425\",\"3430\",\"3445\",\"3450\",\"3455\",\"3470\",\"3475\",\"3490\",\"3495\",\"3500\",\"3515\",\"3520\",\"3535\",\"3540\",\"3545\",\"3560\",\"3565\",\"3580\",\"3585\",\"3590\",\"3605\",\"3610\",\"3625\",\"3630\",\"3635\",\"3650\",\"3655\",\"3670\",\"3675\",\"3680\",\"3695\",\"3700\",\"3715\",\"3720\",\"3725\",\"3740\",\"3745\",\"3760\",\"3765\",\"3770\",\"3785\",\"3790\",\"3805\",\"3810\",\"3815\",\"3830\",\"3835\",\"3850\",\"3855\",\"3860\",\"3875\",\"3880\",\"3895\",\"3900\",\"3905\",\"3920\",\"3925\",\"3940\",\"3945\",\"3950\",\"3965\",\"3970\",\"3985\",\"3990\",\"3995\",\"4010\",\"4015\",\"4030\",\"4035\",\"4040\",\"4055\",\"4060\",\"4075\",\"4080\",\"4085\",\"4100\",\"4105\",\"4120\",\"4125\",\"4130\",\"4145\",\"4150\",\"4165\",\"4170\",\"4175\",\"4190\",\"4195\",\"4210\",\"4215\",\"4220\",\"4235\",\"4240\",\"4255\",\"4260\",\"4265\",\"4280\",\"4285\",\"4300\",\"4305\",\"4310\",\"4325\",\"4330\",\"4345\",\"4350\",\"4355\",\"4370\",\"4375\",\"4390\",\"4395\",\"4400\",\"4415\",\"4420\",\"4435\",\"4440\",\"4445\",\"4460\",\"4465\",\"4480\",\"4485\",\"4490\",\"4505\",\"4510\",\"4525\",\"4530\",\"4535\",\"4550\",\"4555\",\"4570\",\"4575\",\"4580\",\"4585\",\"4590\",\"4595\",\"4600\",\"4605\",\"4610\",\"4615\",\"4620\",\"4625\",\"4630\",\"4635\",\"4640\",\"4645\",\"4650\",\"4655\",\"4660\",\"4665\",\"4670\",\"4675\",\"4680\",\"4685\",\"4690\",\"4695\",\"4700\",\"4705\",\"4710\",\"4715\",\"4720\",\"4725\",\"4730\",\"4735\",\"4740\",\"4745\",\"4750\",\"4755\",\"4760\",\"4765\",\"4770\",\"4775\",\"4780\",\"4785\",\"4790\",\"4795\",\"4800\",\"4805\",\"4810\",\"4815\",\"4820\",\"4825\",\"4830\",\"4835\",\"4840\",\"4845\",\"4850\",\"4855\",\"4860\",\"4865\",\"4870\",\"4875\",\"4880\",\"4885\",\"4890\",\"4900\",\"4905\",\"4910\",\"4925\",\"4930\",\"4945\",\"4950\",\"4955\",\"4970\",\"4975\",\"4990\",\"4995\",\"5000\",\"5015\",\"5020\",\"5035\",\"5040\",\"5045\",\"5060\",\"5065\",\"5080\",\"5085\",\"5090\",\"5105\",\"5110\",\"5125\",\"5130\",\"5135\",\"5150\",\"5155\",\"5170\",\"5175\",\"5180\",\"5195\",\"5200\",\"5215\",\"5220\",\"5225\",\"5240\",\"5245\",\"5260\",\"5265\",\"5270\",\"5285\",\"5290\",\"5305\",\"5310\",\"5315\",\"5330\",\"5335\",\"5350\",\"5355\",\"5360\",\"5375\",\"5380\",\"5395\",\"5400\",\"5405\",\"5420\",\"5425\",\"5440\",\"5445\",\"5450\",\"5465\",\"5470\",\"5485\",\"5490\",\"5495\",\"5510\",\"5515\",\"5530\",\"5535\",\"5540\",\"5555\",\"5560\",\"5575\",\"5580\",\"5585\",\"5600\",\"5605\",\"5620\",\"5625\",\"5630\",\"5645\",\"5650\"]'), ('102', '10', '5', '200', '5360', '[\"5\",\"10\",\"25\",\"30\",\"45\",\"50\",\"55\",\"70\",\"75\",\"90\",\"95\",\"100\",\"115\",\"120\",\"135\",\"140\",\"145\",\"160\",\"165\",\"180\",\"185\",\"190\",\"205\",\"210\",\"225\",\"230\",\"235\",\"250\",\"255\",\"270\",\"275\",\"280\",\"295\",\"300\",\"315\",\"320\",\"325\",\"340\",\"345\",\"360\",\"365\",\"370\",\"385\",\"390\",\"405\",\"410\",\"415\",\"430\",\"435\",\"450\",\"455\",\"460\",\"475\",\"480\",\"240\",\"245\",\"260\",\"265\",\"285\",\"290\",\"305\",\"310\",\"330\",\"335\",\"350\",\"355\",\"375\",\"380\",\"395\",\"400\",\"420\",\"425\",\"440\",\"445\",\"465\",\"470\",\"485\",\"490\",\"505\",\"510\",\"515\",\"530\",\"535\",\"550\",\"555\",\"560\",\"575\",\"580\",\"595\",\"600\",\"605\",\"620\",\"625\",\"640\",\"645\",\"650\",\"665\",\"670\",\"685\",\"690\",\"695\",\"710\",\"715\",\"730\",\"735\",\"740\",\"755\",\"760\",\"775\",\"780\",\"785\",\"800\",\"805\",\"820\",\"825\",\"830\",\"845\",\"850\",\"865\",\"870\",\"875\",\"890\",\"895\",\"910\",\"915\",\"920\",\"935\",\"940\",\"955\",\"960\",\"965\",\"980\",\"985\",\"1000\",\"1005\",\"1010\",\"1025\",\"1030\",\"1045\",\"1050\",\"1055\",\"1070\",\"1075\",\"1090\",\"1095\",\"1100\",\"1115\",\"1120\",\"1135\",\"1140\",\"1145\",\"1160\",\"1165\",\"1180\",\"1185\",\"1190\",\"1205\",\"1210\",\"1225\",\"1230\",\"1235\",\"1250\",\"1255\",\"570\",\"590\",\"610\",\"615\",\"630\",\"635\",\"655\",\"660\",\"675\",\"680\",\"700\",\"705\",\"720\",\"725\",\"745\",\"750\",\"765\",\"770\",\"795\",\"815\",\"840\",\"860\",\"885\",\"905\",\"1175\",\"1195\",\"1200\",\"1220\",\"1240\",\"1245\",\"1260\",\"1265\",\"1270\",\"1275\",\"1290\",\"1295\",\"1300\",\"1315\",\"1320\",\"1335\",\"1340\",\"1345\",\"1360\",\"1365\",\"1380\",\"1385\",\"1390\",\"1405\",\"1410\",\"1425\",\"1430\",\"1435\",\"1450\",\"1455\",\"1470\",\"1355\",\"1370\",\"1375\",\"1395\",\"1400\",\"1415\",\"1420\",\"1440\",\"1445\",\"1460\",\"1465\",\"1480\",\"1485\",\"1490\",\"1505\",\"1510\",\"1525\",\"1530\",\"1535\",\"1550\",\"1555\",\"1570\",\"1575\",\"1580\",\"1595\",\"1600\",\"1615\",\"1620\",\"1625\",\"1640\",\"1645\",\"1660\",\"1665\",\"1670\",\"1685\",\"1690\",\"1705\",\"1710\",\"1715\",\"1730\",\"1735\",\"1750\",\"1755\",\"1760\",\"1775\",\"1780\",\"1795\",\"1800\",\"1805\",\"1820\",\"1825\",\"1840\",\"1845\",\"1850\",\"1865\",\"1870\",\"1885\",\"1890\",\"1895\",\"1910\",\"1915\",\"1930\",\"1935\",\"1940\",\"1955\",\"1960\",\"1975\",\"1980\",\"1985\",\"2000\",\"2005\",\"2020\",\"2025\",\"2030\",\"2045\",\"2050\",\"2065\",\"2070\",\"2075\",\"2090\",\"2095\",\"2110\",\"2115\",\"2120\",\"2135\",\"2140\",\"2155\",\"2160\",\"2165\",\"2180\",\"2185\",\"2200\",\"2205\",\"2210\",\"2225\",\"2230\",\"2245\",\"2250\",\"2255\",\"2270\",\"2275\",\"2290\",\"2295\",\"2300\",\"2315\",\"2320\",\"2335\",\"2340\",\"2345\",\"2360\",\"2365\",\"2380\",\"2385\",\"2390\",\"2405\",\"2410\",\"2425\",\"2430\",\"2435\",\"2450\",\"2455\",\"2470\",\"2475\",\"2480\",\"2495\",\"2500\",\"2515\",\"2520\",\"2525\",\"2540\",\"2545\",\"2560\",\"2565\",\"2570\",\"2585\",\"2590\",\"2605\",\"2610\",\"2615\",\"2630\",\"2635\",\"2650\",\"2655\",\"2660\",\"2675\",\"2680\",\"2695\",\"2700\",\"2705\",\"2720\",\"2725\",\"2740\",\"2745\",\"2750\",\"2765\",\"2770\",\"2785\",\"2790\",\"2795\",\"2810\",\"2815\",\"2830\",\"2835\",\"2840\",\"2855\",\"2860\",\"2875\",\"2880\",\"2885\",\"2900\",\"2905\",\"2920\",\"2925\",\"2930\",\"2945\",\"2950\",\"2965\",\"2970\",\"2975\",\"2990\",\"2995\",\"3010\",\"3015\",\"3020\",\"3035\",\"3040\",\"3055\",\"3060\",\"3065\",\"3080\",\"3085\",\"3100\",\"3105\",\"3110\",\"3125\",\"3130\",\"3145\",\"3150\",\"3155\",\"3170\",\"3175\",\"3180\",\"3195\",\"3200\",\"3215\",\"3220\",\"3225\",\"3240\",\"3245\",\"3250\",\"3260\",\"3265\",\"3270\",\"3285\",\"3290\",\"3310\",\"3315\",\"3330\",\"3335\",\"3340\",\"3350\",\"3355\",\"3360\",\"3375\",\"3380\",\"3400\",\"3405\",\"3420\",\"3425\",\"3445\",\"3450\",\"3465\",\"3470\",\"3490\",\"3495\",\"3510\",\"3515\",\"3535\",\"3540\",\"3555\",\"3560\",\"3575\",\"3580\",\"3585\",\"3600\",\"3605\",\"3610\",\"3620\",\"3625\",\"3630\",\"3645\",\"3650\",\"3665\",\"3670\",\"3675\",\"3690\",\"3695\",\"3710\",\"3715\",\"3720\",\"3735\",\"3740\",\"3760\",\"3765\",\"3780\",\"3785\",\"3790\",\"3805\",\"3810\",\"3825\",\"3830\",\"3835\",\"3845\",\"3850\",\"3855\",\"3870\",\"3875\",\"3880\",\"3890\",\"3895\",\"3900\",\"3915\",\"3920\",\"3935\",\"3940\",\"3945\",\"3960\",\"3965\",\"3970\",\"3985\",\"3990\",\"4005\",\"4010\",\"4030\",\"4035\",\"4050\",\"4055\",\"4070\",\"4075\",\"4080\",\"4095\",\"4100\",\"4105\",\"4120\",\"4125\",\"4140\",\"4145\",\"4160\",\"4165\",\"4170\",\"4185\",\"4190\",\"4210\",\"4215\",\"4230\",\"4235\",\"4255\",\"4260\",\"4275\",\"4280\",\"4285\",\"4300\",\"4305\",\"4320\",\"4325\",\"4330\",\"4340\",\"4345\",\"4350\",\"4365\",\"4370\",\"4375\",\"4390\",\"4395\",\"4410\",\"4415\",\"4420\",\"4435\",\"4440\",\"4455\",\"4460\",\"4465\",\"4480\",\"4485\",\"4500\",\"4505\",\"4525\",\"4530\",\"4545\",\"4550\",\"4555\",\"4565\",\"4570\",\"4575\",\"4590\",\"4595\",\"4600\",\"4615\",\"4620\",\"4635\",\"4640\",\"4660\",\"4665\",\"4680\",\"4685\",\"4690\",\"4700\",\"4705\",\"4710\",\"4725\",\"4730\",\"4735\",\"4745\",\"4750\",\"4755\",\"4770\",\"4775\",\"4780\",\"4795\",\"4800\",\"4815\",\"4820\",\"4825\",\"4835\",\"4840\",\"4845\",\"4860\",\"4865\",\"4880\",\"4885\",\"4890\",\"4905\",\"4910\",\"4915\",\"4930\",\"4935\",\"4950\",\"4955\",\"4960\",\"4975\",\"4980\",\"4995\",\"5000\",\"5005\",\"5015\",\"5020\",\"5025\",\"5040\",\"5045\",\"5050\",\"5060\",\"5065\",\"5070\",\"5085\",\"5090\",\"5095\",\"5110\",\"5115\",\"5130\",\"5135\",\"5140\",\"5150\",\"5155\",\"5160\",\"5175\",\"5180\",\"5195\",\"5200\",\"5205\",\"5220\",\"5225\",\"5240\",\"5245\",\"5250\",\"5265\",\"5270\",\"5275\",\"5290\",\"5295\",\"5310\",\"5315\",\"5330\",\"5335\",\"5340\",\"5355\",\"5360\"]'), ('103', '10', '5', '180', '745', '[\"5\",\"155\",\"170\",\"175\",\"180\",\"245\",\"320\",\"545\",\"560\",\"745\"]'), ('104', '10', '5', '193', '325', '[\"5\",\"10\",\"25\",\"30\",\"45\",\"50\",\"55\",\"70\",\"75\",\"90\",\"95\",\"100\",\"115\",\"120\",\"135\",\"140\",\"145\",\"160\",\"165\",\"180\",\"185\",\"190\",\"205\",\"210\",\"225\",\"230\",\"235\",\"250\",\"255\",\"270\",\"275\",\"280\",\"295\",\"300\",\"315\",\"320\",\"325\"]'), ('105', '10', '5', '184', '240', '[\"10\",\"15\",\"30\",\"35\",\"40\",\"55\",\"60\",\"75\",\"80\",\"85\",\"100\",\"105\",\"120\",\"125\",\"130\",\"145\",\"150\",\"165\",\"170\",\"175\",\"190\",\"195\",\"210\",\"215\",\"220\",\"235\",\"240\",\"255\",\"260\",\"0\",\"5\",\"50\",\"95\",\"140\",\"185\",\"230\"]'), ('106', '7', '5', '200', '935', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\"]'), ('107', '10', '5', '202', '5325', '[\"5\",\"10\",\"25\",\"30\",\"45\",\"50\",\"55\",\"70\",\"75\",\"90\",\"95\",\"100\",\"115\",\"120\",\"135\",\"140\",\"145\",\"160\",\"165\",\"180\",\"185\",\"190\",\"205\",\"210\",\"225\",\"230\",\"235\",\"250\",\"255\",\"270\",\"275\",\"280\",\"295\",\"300\",\"315\",\"320\",\"325\",\"340\",\"345\",\"360\",\"365\",\"370\",\"385\",\"390\",\"405\",\"410\",\"415\",\"430\",\"435\",\"450\",\"455\",\"460\",\"475\",\"480\",\"495\",\"500\",\"505\",\"520\",\"525\",\"540\",\"545\",\"550\",\"565\",\"570\",\"585\",\"590\",\"595\",\"610\",\"615\",\"630\",\"635\",\"640\",\"655\",\"660\",\"675\",\"680\",\"685\",\"700\",\"705\",\"720\",\"725\",\"730\",\"745\",\"750\",\"765\",\"770\",\"775\",\"790\",\"795\",\"810\",\"815\",\"820\",\"835\",\"840\",\"855\",\"860\",\"865\",\"880\",\"885\",\"900\",\"905\",\"910\",\"925\",\"930\",\"945\",\"950\",\"955\",\"970\",\"975\",\"990\",\"995\",\"1000\",\"1015\",\"1020\",\"1035\",\"1040\",\"1045\",\"1060\",\"1065\",\"1080\",\"1085\",\"1090\",\"1105\",\"1110\",\"1125\",\"1130\",\"1135\",\"1150\",\"1155\",\"1170\",\"1175\",\"1180\",\"1195\",\"1200\",\"1215\",\"1220\",\"1225\",\"1240\",\"1245\",\"1260\",\"1265\",\"1270\",\"1285\",\"1290\",\"1305\",\"1310\",\"1315\",\"1330\",\"1335\",\"1350\",\"1355\",\"1360\",\"1375\",\"1380\",\"1395\",\"1400\",\"1405\",\"1420\",\"1425\",\"1430\",\"1435\",\"1450\",\"1455\",\"1460\",\"1475\",\"1480\",\"1495\",\"1500\",\"1505\",\"1520\",\"1525\",\"1540\",\"1545\",\"1550\",\"1565\",\"1570\",\"1585\",\"1590\",\"1595\",\"1610\",\"1615\",\"1630\",\"1635\",\"1640\",\"1655\",\"1660\",\"1675\",\"1680\",\"1685\",\"1700\",\"1705\",\"1720\",\"1725\",\"1730\",\"1745\",\"1750\",\"1765\",\"1770\",\"1775\",\"1790\",\"1795\",\"1810\",\"1815\",\"1820\",\"1835\",\"1840\",\"1855\",\"1860\",\"1865\",\"1880\",\"1885\",\"1900\",\"1905\",\"1910\",\"1925\",\"1930\",\"1945\",\"1950\",\"1955\",\"1970\",\"1975\",\"1990\",\"1995\",\"2000\",\"2015\",\"2020\",\"2035\",\"2040\",\"2045\",\"2060\",\"2065\",\"2080\",\"2085\",\"2090\",\"2105\",\"2110\",\"2125\",\"2130\",\"2135\",\"2150\",\"2155\",\"2170\",\"2175\",\"2180\",\"2195\",\"2200\",\"2215\",\"2220\",\"2225\",\"2240\",\"2245\",\"2260\",\"2265\",\"2270\",\"2285\",\"2290\",\"2305\",\"2310\",\"2315\",\"2330\",\"2335\",\"2350\",\"2355\",\"2360\",\"2375\",\"2380\",\"2395\",\"2400\",\"2405\",\"2420\",\"2425\",\"2440\",\"2445\",\"2450\",\"2465\",\"2470\",\"2485\",\"2490\",\"2495\",\"2510\",\"2515\",\"2530\",\"2535\",\"2540\",\"2555\",\"2560\",\"2575\",\"2580\",\"2585\",\"2600\",\"2605\",\"2620\",\"2625\",\"2630\",\"2645\",\"2650\",\"2665\",\"2670\",\"2690\",\"2695\",\"2710\",\"2715\",\"2730\",\"2735\",\"2740\",\"2755\",\"2760\",\"2775\",\"2780\",\"2785\",\"2800\",\"2805\",\"2820\",\"2825\",\"2830\",\"2835\",\"2850\",\"2860\",\"2865\",\"2870\",\"2885\",\"2890\",\"2905\",\"2910\",\"2915\",\"2930\",\"2935\",\"2950\",\"2955\",\"2960\",\"2975\",\"2980\",\"2995\",\"3000\",\"3005\",\"3020\",\"3025\",\"3040\",\"3045\",\"3050\",\"3065\",\"3070\",\"3085\",\"3090\",\"3095\",\"3110\",\"3115\",\"3130\",\"3135\",\"3140\",\"3155\",\"3160\",\"3175\",\"3180\",\"3185\",\"3200\",\"3205\",\"3220\",\"3225\",\"3230\",\"3245\",\"3250\",\"3265\",\"3270\",\"3275\",\"3290\",\"3295\",\"3310\",\"3315\",\"3320\",\"3335\",\"3340\",\"3355\",\"3360\",\"3365\",\"3380\",\"3385\",\"3400\",\"3405\",\"3410\",\"3425\",\"3430\",\"3445\",\"3450\",\"3455\",\"3470\",\"3475\",\"3490\",\"3495\",\"3500\",\"3515\",\"3520\",\"3535\",\"3540\",\"3545\",\"3560\",\"3565\",\"3580\",\"3585\",\"3590\",\"3605\",\"3610\",\"3625\",\"3630\",\"3635\",\"3650\",\"3655\",\"3670\",\"3675\",\"3680\",\"3695\",\"3700\",\"3715\",\"3720\",\"3725\",\"3740\",\"3745\",\"3760\",\"3765\",\"3770\",\"3785\",\"3790\",\"3805\",\"3810\",\"3815\",\"3830\",\"3835\",\"3850\",\"3855\",\"3860\",\"3875\",\"3880\",\"3895\",\"3900\",\"3905\",\"3920\",\"3925\",\"3940\",\"3945\",\"3950\",\"3965\",\"3970\",\"3985\",\"3990\",\"3995\",\"4010\",\"4015\",\"4030\",\"4035\",\"4040\",\"4055\",\"4060\",\"4075\",\"4080\",\"4085\",\"4100\",\"4105\",\"4120\",\"4125\",\"4130\",\"4145\",\"4150\",\"4165\",\"4170\",\"4175\",\"4190\",\"4195\",\"4210\",\"4215\",\"4220\",\"4235\",\"4240\",\"4255\",\"4260\",\"4265\",\"4280\",\"4285\",\"4300\",\"4305\",\"4310\",\"4325\",\"4330\",\"4345\",\"4350\",\"4365\",\"4370\",\"4375\",\"4390\",\"4395\",\"4410\",\"4415\",\"4420\",\"4435\",\"4440\",\"4455\",\"4460\",\"4465\",\"4480\",\"4485\",\"4500\",\"4505\",\"4510\",\"4525\",\"4530\",\"4545\",\"4550\",\"4555\",\"4570\",\"4575\",\"4590\",\"4595\",\"4600\",\"4615\",\"4620\",\"4635\",\"4640\",\"4645\",\"4660\",\"4665\",\"4680\",\"4685\",\"4690\",\"4705\",\"4710\",\"4725\",\"4730\",\"4735\",\"4750\",\"4755\",\"4770\",\"4775\",\"4780\",\"4795\",\"4800\",\"4815\",\"4820\",\"4825\",\"4840\",\"4845\",\"4860\",\"4865\",\"4870\",\"4885\",\"4890\",\"4905\",\"4910\",\"4915\",\"4930\",\"4935\",\"4950\",\"4955\",\"4960\",\"4975\",\"4980\",\"4995\",\"5000\",\"5005\",\"5020\",\"5025\",\"5040\",\"5045\",\"5050\",\"5065\",\"5070\",\"5085\",\"5090\",\"5095\",\"5110\",\"5115\",\"5130\",\"5135\",\"5140\",\"5155\",\"5160\",\"5175\",\"5180\",\"5185\",\"5200\",\"5205\",\"5220\",\"5225\",\"5230\",\"5245\",\"5250\",\"5265\",\"5270\",\"5275\",\"5280\",\"5295\",\"5300\",\"5315\",\"5320\",\"5325\"]'), ('108', '1', '5', '202', '5385', '[\"330\",\"2300\",\"3435\",\"5245\",\"5250\",\"5255\",\"5260\",\"5265\",\"5270\",\"5275\",\"5280\",\"5285\",\"5290\",\"5295\",\"5300\",\"5305\",\"5310\",\"5315\",\"5320\",\"5325\",\"5330\",\"5335\",\"5340\",\"5345\",\"5350\",\"5355\",\"5360\",\"5365\",\"5370\",\"5375\",\"5380\",\"5385\"]'), ('109', '1', '5', '206', '8170', '[\"1400\",\"8075\",\"7690\",\"7045\",\"8010\",\"8165\",\"8170\"]'), ('110', '10', '5', '206', '7675', '[\"685\",\"690\",\"705\",\"710\",\"715\",\"1105\",\"2345\",\"2350\",\"2925\",\"2930\",\"3670\",\"3675\",\"4080\",\"4470\",\"4205\",\"4210\",\"4225\",\"4230\",\"4235\",\"4250\",\"4255\",\"4675\",\"4995\",\"5380\",\"5385\",\"5840\",\"5845\",\"5850\",\"5860\",\"5865\",\"5440\",\"5455\",\"5460\",\"5475\",\"5480\",\"5485\",\"5500\",\"5505\",\"5520\",\"5525\",\"5530\",\"5545\",\"5550\",\"5565\",\"5570\",\"5575\",\"5590\",\"5595\",\"5610\",\"5615\",\"5620\",\"5635\",\"5640\",\"5655\",\"5660\",\"5665\",\"5680\",\"5685\",\"5700\",\"5705\",\"5710\",\"5725\",\"5730\",\"5745\",\"5750\",\"5755\",\"5770\",\"5775\",\"5790\",\"5795\",\"5800\",\"5815\",\"5820\",\"5835\",\"5880\",\"5885\",\"5890\",\"5905\",\"5910\",\"5925\",\"5930\",\"5935\",\"5950\",\"5955\",\"5970\",\"5975\",\"6435\",\"6440\",\"6455\",\"6460\",\"6475\",\"6480\",\"6485\",\"6500\",\"6505\",\"6520\",\"6525\",\"6530\",\"6545\",\"6550\",\"6565\",\"6570\",\"6575\",\"6590\",\"6595\",\"6610\",\"6615\",\"6620\",\"6635\",\"6640\",\"6655\",\"6660\",\"6665\",\"6680\",\"6685\",\"6700\",\"6705\",\"6710\",\"6725\",\"6730\",\"7335\",\"7340\",\"7355\",\"7360\",\"7375\",\"7380\",\"7385\",\"7400\",\"7405\",\"7420\",\"7425\",\"7430\",\"7445\",\"7450\",\"7465\",\"7470\",\"7475\",\"7490\",\"7495\",\"7510\",\"7515\",\"7520\",\"7535\",\"7540\",\"7555\",\"7560\",\"7565\",\"7580\",\"7585\",\"7600\",\"7605\",\"7610\",\"7625\",\"7630\",\"7645\",\"7650\",\"7655\",\"7670\",\"7675\"]'), ('111', '11', '5', '202', '3810', '[\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"45\",\"50\",\"60\",\"65\",\"70\",\"80\",\"85\",\"365\",\"375\",\"380\",\"390\",\"395\",\"405\",\"410\",\"415\",\"425\",\"430\",\"440\",\"445\",\"450\",\"455\",\"460\",\"745\",\"755\",\"760\",\"765\",\"770\",\"895\",\"905\",\"1140\",\"1575\",\"2015\",\"2020\",\"2030\",\"2035\",\"2045\",\"2050\",\"2055\",\"2060\",\"2355\",\"2365\",\"2130\",\"2135\",\"2140\",\"2145\",\"2150\",\"2155\",\"2165\",\"2170\",\"2270\",\"2485\",\"2490\",\"2495\",\"2505\",\"2510\",\"2520\",\"2525\",\"2530\",\"2535\",\"2845\",\"3395\",\"3405\",\"3410\",\"3420\",\"3425\",\"3435\",\"3810\"]'), ('112', '11', '5', '206', '8165', '[\"520\",\"355\",\"95\",\"0\",\"1480\",\"1985\",\"2855\",\"3180\",\"2975\",\"2785\",\"3005\",\"2800\",\"2805\",\"2810\",\"2820\",\"2825\",\"2835\",\"2860\",\"2865\",\"2870\",\"2875\",\"2885\",\"2890\",\"2900\",\"2905\",\"2910\",\"2915\",\"2920\",\"2925\",\"2935\",\"2940\",\"2950\",\"2955\",\"2960\",\"2970\",\"2985\",\"2990\",\"3000\",\"3010\",\"3020\",\"3025\",\"3035\",\"3040\",\"3050\",\"3055\",\"3060\",\"3070\",\"3075\",\"3085\",\"3090\",\"3100\",\"3105\",\"3110\",\"3120\",\"3125\",\"3135\",\"3140\",\"3150\",\"3155\",\"3160\",\"3170\",\"3175\",\"3185\",\"3190\",\"3195\",\"3200\",\"3205\",\"3210\",\"3220\",\"3225\",\"3235\",\"3240\",\"3245\",\"3250\",\"3255\",\"3260\",\"3270\",\"3275\",\"3285\",\"3290\",\"3295\",\"3300\",\"3305\",\"3310\",\"3320\",\"3325\",\"3335\",\"3340\",\"3345\",\"3350\",\"3355\",\"3360\",\"3370\",\"3375\",\"3385\",\"3390\",\"3395\",\"3400\",\"3405\",\"3410\",\"3420\",\"3425\",\"3435\",\"3440\",\"3445\",\"3450\",\"3455\",\"3460\",\"3470\",\"3475\",\"3485\",\"3490\",\"3495\",\"3500\",\"3505\",\"3510\",\"3515\",\"3520\",\"3525\",\"3530\",\"3535\",\"3540\",\"3545\",\"3790\",\"3795\",\"3800\",\"4130\",\"4295\",\"4565\",\"4690\",\"4825\",\"4830\",\"4835\",\"4840\",\"4850\",\"4855\",\"4990\",\"5055\",\"5060\",\"5070\",\"5075\",\"5225\",\"5230\",\"5240\",\"5245\",\"5255\",\"5260\",\"5265\",\"5270\",\"5275\",\"5280\",\"5290\",\"5295\",\"5305\",\"5310\",\"5315\",\"5320\",\"5325\",\"5330\",\"5340\",\"5345\",\"5355\",\"5360\",\"5365\",\"5505\",\"5510\",\"5520\",\"5525\",\"5535\",\"5540\",\"5545\",\"5555\",\"5560\",\"5570\",\"5575\",\"5585\",\"5590\",\"5595\",\"5605\",\"5730\",\"5600\",\"5610\",\"5615\",\"5620\",\"5630\",\"5635\",\"5645\",\"5650\",\"5660\",\"5665\",\"5670\",\"5680\",\"5685\",\"5695\",\"5700\",\"5705\",\"5710\",\"5715\",\"5720\",\"5725\",\"5735\",\"5745\",\"5750\",\"5760\",\"5765\",\"5770\",\"5775\",\"5780\",\"5785\",\"5795\",\"5800\",\"5810\",\"5815\",\"5820\",\"5830\",\"5835\",\"5845\",\"5850\",\"5860\",\"5865\",\"5870\",\"5880\",\"5885\",\"5895\",\"5900\",\"5910\",\"5915\",\"5920\",\"5930\",\"5935\",\"5945\",\"5950\",\"5960\",\"5965\",\"5970\",\"6145\",\"6410\",\"6705\",\"6850\",\"7025\",\"7165\",\"7170\",\"7305\",\"7310\",\"7315\",\"7425\",\"7430\",\"7050\",\"7160\",\"7290\",\"7295\",\"7300\",\"7325\",\"7330\",\"7335\",\"7470\",\"7475\",\"7485\",\"7490\",\"7500\",\"7505\",\"7510\",\"7520\",\"7525\",\"7535\",\"7540\",\"7550\",\"7555\",\"7560\",\"7570\",\"7575\",\"7585\",\"7590\",\"7600\",\"7605\",\"7610\",\"7615\",\"7625\",\"7630\",\"7640\",\"7645\",\"7650\",\"7655\",\"7660\",\"7665\",\"7675\",\"7680\",\"7690\",\"7695\",\"7700\",\"7710\",\"7715\",\"7725\",\"7730\",\"7770\",\"7775\",\"7780\",\"7790\",\"7795\",\"7805\",\"7810\",\"7815\",\"7825\",\"7830\",\"7840\",\"7845\",\"7850\",\"7855\",\"7860\",\"7865\",\"7875\",\"7880\",\"7890\",\"7895\",\"7900\",\"7905\",\"7910\",\"7915\",\"7925\",\"7930\",\"7940\",\"7945\",\"7950\",\"7960\",\"7965\",\"7975\",\"7980\",\"7990\",\"7995\",\"8000\",\"8010\",\"8015\",\"8025\",\"8030\",\"8040\",\"8045\",\"8050\",\"8060\",\"8065\",\"8075\",\"8080\",\"8090\",\"8095\",\"8100\",\"8110\",\"8115\",\"8125\",\"8130\",\"8140\",\"8145\",\"8150\",\"8160\",\"8165\"]'), ('113', '7', '5', '202', '190', '[\"5\",\"10\",\"15\",\"20\",\"25\",\"30\",\"35\",\"40\",\"45\",\"50\",\"55\",\"60\",\"65\",\"70\",\"75\",\"80\",\"85\",\"90\",\"95\",\"100\",\"105\",\"110\",\"115\",\"120\",\"125\",\"130\",\"135\",\"140\",\"145\",\"150\",\"155\",\"160\",\"165\",\"170\",\"175\",\"180\",\"185\",\"190\",\"195\",\"200\",\"205\",\"210\",\"215\",\"220\",\"225\",\"230\",\"235\",\"240\",\"245\",\"250\",\"255\",\"260\",\"265\",\"270\",\"275\",\"280\",\"285\",\"290\",\"295\",\"300\",\"305\",\"310\",\"315\",\"320\",\"325\",\"330\",\"335\",\"340\",\"345\",\"350\",\"355\",\"360\",\"365\",\"370\",\"375\",\"380\",\"385\",\"390\",\"395\",\"400\",\"405\",\"410\",\"415\",\"420\",\"425\",\"430\",\"435\",\"440\",\"445\",\"450\",\"455\",\"460\",\"465\",\"470\",\"475\",\"480\",\"485\",\"490\",\"495\",\"500\",\"505\",\"510\",\"515\",\"520\",\"525\",\"530\",\"535\",\"540\",\"545\",\"550\",\"555\",\"560\",\"565\",\"570\",\"575\",\"580\",\"585\",\"590\",\"595\",\"600\",\"605\",\"610\",\"615\",\"620\",\"625\",\"630\",\"635\",\"640\",\"645\",\"650\",\"655\",\"660\",\"665\",\"670\",\"675\",\"680\",\"685\",\"690\",\"695\",\"700\",\"705\",\"710\",\"715\",\"720\",\"725\",\"730\",\"735\",\"740\",\"745\",\"750\",\"755\",\"760\",\"765\",\"770\",\"775\",\"780\",\"785\",\"790\",\"795\",\"800\",\"805\",\"0\",\"810\",\"815\",\"820\",\"825\",\"830\",\"835\",\"840\",\"845\",\"850\",\"855\",\"860\",\"865\",\"870\",\"875\",\"880\",\"885\",\"890\",\"895\",\"900\",\"905\",\"910\",\"915\",\"920\",\"925\",\"930\",\"935\",\"940\",\"945\",\"950\",\"955\",\"960\",\"965\",\"970\",\"975\",\"980\",\"985\",\"990\",\"995\",\"1000\",\"1005\",\"1010\",\"1015\",\"1020\",\"1025\",\"1030\",\"1035\",\"1040\",\"1045\",\"1050\",\"1055\",\"1060\",\"1065\",\"1070\",\"1075\",\"1080\",\"1085\",\"1090\",\"1095\",\"1100\",\"1105\",\"1110\",\"1115\",\"1120\",\"1125\",\"1130\",\"1135\",\"1140\",\"1145\",\"1150\",\"1155\",\"1160\",\"1165\",\"1170\",\"1175\",\"1180\",\"1185\",\"1190\",\"1195\",\"1200\",\"1205\",\"1210\",\"1215\",\"1220\",\"1225\",\"1230\",\"1235\",\"1240\",\"1245\",\"1250\",\"1255\",\"1260\",\"1265\",\"1270\",\"1275\",\"1280\",\"1285\",\"1290\",\"1295\",\"1300\",\"1305\",\"1310\",\"1315\",\"1320\",\"1325\",\"1330\",\"1335\",\"1340\",\"1345\",\"1350\",\"1355\",\"1360\",\"1365\",\"1370\",\"1375\",\"1380\",\"1385\",\"1390\",\"1395\",\"1400\",\"1405\",\"1410\",\"1415\",\"1420\",\"1425\",\"1430\",\"1435\",\"1440\",\"1445\",\"1450\",\"1455\",\"1460\",\"1465\",\"1470\",\"1475\",\"1480\",\"1485\",\"1490\",\"1495\",\"1500\",\"1505\",\"1510\",\"1515\",\"1520\",\"1525\",\"1530\",\"1535\",\"1540\",\"1545\",\"1550\",\"1555\",\"1560\",\"1565\",\"1570\",\"1575\",\"1580\",\"1585\",\"1590\",\"1595\",\"1600\",\"1605\",\"1610\",\"1615\",\"1620\",\"1625\",\"1630\",\"1635\",\"1640\",\"1645\",\"1650\",\"1655\",\"1660\",\"1665\",\"1670\",\"1675\",\"1680\",\"1685\",\"1690\",\"1695\",\"1700\",\"1705\",\"1710\",\"1715\",\"1720\",\"1725\",\"1730\",\"1735\",\"1740\",\"1745\",\"1750\",\"1755\",\"1760\",\"1765\",\"1770\",\"1775\",\"1780\",\"1785\",\"1790\",\"1795\",\"1800\",\"1805\",\"1810\",\"1815\",\"1820\",\"1825\",\"1830\",\"1835\",\"1840\",\"1845\",\"1850\",\"1855\",\"1860\",\"1865\",\"1870\",\"1875\",\"1880\",\"1885\",\"1890\",\"1895\",\"1900\",\"1905\",\"1910\",\"1915\",\"1920\",\"1925\",\"1930\",\"1935\",\"1940\",\"1945\",\"1950\",\"1955\",\"1960\",\"1965\",\"1970\",\"1975\",\"1980\",\"1985\",\"1990\",\"1995\",\"2000\",\"2005\",\"2010\",\"2015\",\"2020\",\"2025\",\"2030\",\"2035\",\"2040\",\"2045\",\"2050\",\"2055\",\"2060\",\"2065\",\"2070\",\"2075\",\"2080\",\"2085\",\"2090\",\"2095\",\"2100\",\"2105\",\"2110\",\"2115\",\"2120\",\"2125\",\"2130\",\"2135\",\"2140\",\"2145\",\"2150\",\"2155\",\"2160\",\"2165\",\"2170\",\"2175\",\"2180\",\"2185\",\"2190\",\"2195\",\"2200\",\"2205\",\"2210\",\"2215\",\"2220\",\"2225\",\"2230\",\"2235\",\"2240\",\"2245\",\"2250\",\"2255\",\"2260\",\"2265\",\"2270\",\"2275\",\"2280\",\"2285\",\"2290\",\"2295\",\"2300\",\"2305\",\"2310\",\"2315\",\"2320\",\"2325\",\"2330\",\"2335\",\"2340\",\"2345\",\"2350\",\"2355\",\"2360\",\"2365\",\"2370\",\"2375\",\"2380\",\"2385\",\"2390\",\"2395\",\"2400\",\"2405\",\"2410\",\"2415\",\"2420\",\"2425\",\"2430\",\"2435\",\"2440\",\"2445\",\"2450\",\"2455\",\"2460\",\"2465\",\"2470\",\"2475\",\"2480\",\"2485\",\"2490\",\"2495\",\"2500\",\"2505\",\"2510\",\"2515\",\"2520\",\"2525\",\"2530\",\"2535\",\"2540\",\"2545\",\"2550\",\"2555\",\"2560\",\"2565\",\"2570\",\"2575\",\"2580\",\"2585\",\"2590\",\"2595\",\"2600\",\"2605\",\"2610\",\"2615\",\"2620\",\"2625\",\"2630\",\"2635\",\"2640\",\"2645\",\"2650\",\"2655\",\"2660\",\"2665\",\"2670\",\"2675\",\"2680\",\"2685\",\"2690\",\"2695\",\"2700\",\"2705\",\"2710\",\"2715\",\"2720\",\"2725\",\"2730\",\"2735\",\"2740\",\"2745\",\"2750\",\"2755\",\"2760\",\"2765\",\"2770\",\"2775\",\"2780\",\"2785\",\"2790\",\"2795\",\"2800\",\"2805\",\"2810\",\"2815\",\"2820\",\"2825\",\"2830\",\"2835\",\"2840\",\"2845\",\"2850\",\"2855\",\"2860\",\"2865\",\"2870\",\"2875\",\"2880\",\"2885\",\"2890\",\"2895\",\"2900\",\"2905\",\"2910\",\"2915\",\"2920\",\"2925\",\"2930\",\"2935\",\"2940\",\"2945\",\"2950\",\"2955\",\"2960\",\"2965\",\"2970\",\"2975\",\"2980\",\"2985\",\"2990\",\"2995\",\"3000\",\"3005\",\"3010\",\"3015\",\"3020\",\"3025\",\"3030\",\"3035\",\"3040\",\"3045\",\"3050\",\"3055\",\"3060\",\"3065\",\"3070\",\"3075\",\"3080\",\"3085\",\"3090\",\"3095\",\"3100\",\"3105\",\"3110\",\"3115\",\"3120\",\"3125\",\"3130\",\"3135\",\"3140\",\"3145\",\"3150\",\"3155\",\"3160\",\"3165\",\"3170\",\"3175\",\"3180\",\"3185\",\"3190\",\"3195\",\"3200\",\"3205\",\"3210\",\"3215\",\"3220\",\"3225\",\"3230\",\"3235\",\"3240\",\"3245\",\"3250\",\"3255\",\"3260\",\"3265\",\"3270\",\"3275\",\"3280\",\"3285\",\"3290\",\"3295\",\"3300\",\"3305\",\"3310\",\"3315\",\"3320\",\"3325\",\"3330\",\"3335\",\"3340\",\"3345\",\"3350\",\"3355\",\"3360\",\"3365\",\"3370\",\"3375\",\"3380\",\"3385\",\"3390\",\"3395\",\"3400\",\"3405\",\"3410\",\"3415\",\"3420\",\"3425\",\"3430\",\"3435\",\"3440\",\"3445\",\"3450\",\"3455\",\"3460\",\"3465\",\"3470\",\"3475\",\"3480\",\"3485\",\"3490\",\"3495\",\"3500\",\"3505\",\"3510\",\"3515\",\"3520\",\"3525\",\"3530\",\"3535\",\"3540\",\"3545\",\"3550\",\"3555\",\"3560\",\"3565\",\"3570\",\"3575\",\"3580\",\"3585\",\"3590\",\"3595\",\"3600\",\"3605\",\"3610\",\"3615\",\"3620\",\"3625\",\"3630\",\"3635\",\"3640\",\"3645\",\"3650\",\"3655\",\"3660\",\"3665\",\"3670\",\"3675\",\"3680\",\"3685\",\"3690\",\"3695\",\"3700\",\"3705\",\"3710\",\"3715\",\"3720\",\"3725\",\"3730\",\"3735\",\"3740\",\"3745\",\"3750\",\"3755\",\"3760\",\"3765\",\"3770\",\"3775\",\"3780\",\"3785\",\"3790\",\"3795\",\"3800\",\"3805\",\"3810\",\"3815\",\"3820\",\"3825\",\"3830\",\"3835\",\"3840\",\"3845\",\"3850\",\"3855\",\"3860\",\"3865\",\"3870\",\"3875\",\"3880\",\"3885\",\"3890\",\"3895\",\"3900\",\"3905\",\"3910\",\"3915\",\"3920\",\"3925\",\"3930\",\"3935\",\"3940\",\"3945\",\"3950\",\"3955\",\"3960\",\"3965\",\"3970\",\"3975\",\"3980\",\"3985\",\"3990\",\"3995\",\"4000\",\"4005\",\"4010\",\"4015\",\"4020\",\"4025\",\"4030\",\"4035\",\"4040\",\"4045\",\"4050\",\"4055\",\"4060\",\"4065\",\"4070\",\"4075\",\"4080\",\"4085\",\"4090\",\"4095\",\"4100\",\"4105\",\"4110\",\"4115\",\"4120\",\"4125\",\"4130\",\"4135\",\"4140\",\"4145\",\"4150\",\"4155\",\"4160\",\"4165\",\"4170\",\"4175\",\"4180\",\"4185\",\"4190\",\"4195\",\"4200\",\"4205\",\"4210\",\"4215\",\"4220\",\"4225\",\"4230\",\"4235\",\"4240\",\"4245\",\"4250\",\"4255\",\"4260\",\"4265\",\"4270\",\"4275\",\"4280\",\"4285\",\"4290\",\"4295\",\"4300\",\"4305\",\"4310\",\"4315\",\"4320\",\"4325\",\"4330\",\"4335\",\"4340\",\"4345\",\"4350\",\"4355\",\"4360\",\"4365\",\"4370\",\"4375\",\"4380\",\"4385\",\"4390\",\"4395\",\"4400\",\"4405\",\"4410\",\"4415\",\"4420\",\"4425\",\"4430\",\"4435\",\"4440\",\"4445\",\"4450\",\"4455\",\"4460\",\"4465\",\"4470\",\"4475\",\"4480\",\"4485\",\"4490\",\"4495\",\"4500\",\"4505\",\"4510\",\"4515\",\"4520\",\"4525\",\"4530\",\"4535\",\"4540\",\"4545\",\"4550\",\"4555\",\"4560\",\"4565\",\"4570\",\"4575\",\"4580\",\"4585\",\"4590\",\"4595\",\"4600\",\"4605\",\"4610\",\"4615\",\"4620\",\"4625\",\"4630\",\"4635\",\"4640\",\"4645\",\"4650\",\"4655\",\"4660\",\"4665\",\"4670\",\"4675\",\"4680\",\"4685\",\"4690\",\"4695\",\"4700\",\"4705\",\"4710\",\"4715\",\"4720\",\"4725\",\"4730\",\"4735\",\"4740\",\"4745\",\"4750\",\"4755\",\"4760\",\"4765\",\"4770\",\"4775\",\"4780\",\"4785\",\"4790\",\"4795\",\"4800\",\"4805\",\"4810\",\"4815\",\"4820\",\"4825\",\"4830\",\"4835\",\"4840\",\"4845\",\"4850\",\"4855\",\"4860\",\"4865\",\"4870\",\"4875\",\"4880\",\"4885\",\"4890\",\"4895\",\"4900\",\"4905\",\"4910\",\"4915\",\"4920\",\"4925\",\"4930\",\"4935\",\"4940\",\"4945\",\"4950\",\"4955\",\"4960\",\"4965\",\"4970\",\"4975\",\"4980\",\"4985\",\"4990\",\"4995\",\"5000\",\"5005\",\"5010\",\"5015\",\"5020\",\"5025\",\"5030\",\"5035\",\"5040\",\"5045\",\"5050\",\"5055\",\"5060\",\"5065\",\"5070\",\"5075\",\"5080\",\"5085\",\"5090\",\"5095\",\"5100\",\"5105\",\"5110\",\"5115\",\"5120\",\"5125\",\"5130\",\"5135\",\"5140\",\"5145\",\"5150\",\"5155\",\"5160\",\"5165\",\"5170\",\"5175\",\"5180\",\"5185\",\"5190\",\"5195\",\"5200\",\"5205\",\"5210\",\"5215\",\"5220\",\"5225\",\"5230\",\"5235\",\"5240\",\"5245\",\"5250\",\"5255\",\"5260\",\"5265\",\"5270\",\"5275\",\"5280\",\"5285\",\"5290\",\"5295\",\"5300\",\"5305\",\"5310\",\"5315\",\"5320\",\"5325\",\"5330\",\"5335\",\"5340\",\"5345\",\"5350\",\"5355\",\"5360\",\"5365\",\"5370\",\"5375\",\"5380\",\"5385\",\"5390\",\"5395\",\"5400\",\"5405\",\"5410\",\"5415\",\"5420\",\"5425\",\"5430\",\"5435\",\"5440\",\"5445\",\"5450\",\"5455\",\"5460\",\"5465\",\"5470\",\"5475\",\"5480\",\"5485\",\"5490\",\"5495\",\"5500\",\"5505\",\"5510\",\"5515\",\"5520\",\"5525\",\"5530\",\"5535\",\"5540\",\"5545\",\"5550\",\"5555\",\